/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

public final class SupportBundleRequest implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String CONTENT_FILTERS_ALL = "ALL";

    public static final java.lang.String CONTENT_FILTERS_DEFAULT = "DEFAULT";

    public static final java.lang.String CONTENT_FILTERS_REMOVE_CORE_FILES = "REMOVE_CORE_FILES";

    public static final java.lang.String CONTENT_FILTERS_EAL4_AUDIT = "EAL4_AUDIT";

    private java.util.List<com.vmware.vapi.bindings.Structure> containerNodes;

    private java.util.List<java.lang.String> contentFilters;

    private java.util.List<java.lang.String> dynamicContentFilters;

    private java.lang.Long logAgeLimit;

    private java.util.List<java.lang.String> nodes;

    private com.vmware.nsx.model.SupportBundleRemoteFileServer remoteFileServer;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public SupportBundleRequest() {
    }

    protected SupportBundleRequest(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * List of container clusters and their nodes requiring support bundle collection
     *
     * @return The current value of the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx.model.SupportBundleContainerNode}. When methods return a value of
     * this class as a return value, the property will contain all the properties
     * defined in {@link com.vmware.nsx.model.SupportBundleContainerNode}.
     */
    public java.util.List<com.vmware.vapi.bindings.Structure> getContainerNodes() {
        return this.containerNodes;
    }

    /**
     * List of container clusters and their nodes requiring support bundle collection
     *
     * @param containerNodes New value for the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx.model.SupportBundleContainerNode}. When methods return a value of
     * this class as a return value, the property will contain all the properties
     * defined in {@link com.vmware.nsx.model.SupportBundleContainerNode}.
     */
    public void setContainerNodes(java.util.List<com.vmware.vapi.bindings.Structure> containerNodes) {
        this.containerNodes = containerNodes;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.SupportBundleRequest#CONTENT_FILTERS_ALL}</li> <li> {@link
     * com.vmware.nsx.model.SupportBundleRequest#CONTENT_FILTERS_DEFAULT}</li> <li>
     * {@link
     * com.vmware.nsx.model.SupportBundleRequest#CONTENT_FILTERS_REMOVE_CORE_FILES}</li>
     * <li> {@link
     * com.vmware.nsx.model.SupportBundleRequest#CONTENT_FILTERS_EAL4_AUDIT}</li> </ul>
     *
     * <p>List of content filters that specify additional content or action when
     * collecting support bundle. </p> <ul><li>Filter <code>ALL</code> includes core
     * dumps and audit logs in support bundle</li> <li>Filter
     * <code>REMOVE_CORE_FILES</code> can optionally be in list with <code>ALL</code>,
     * to remove core dump files after collected in support bundle</li> <li>Filter
     * <code>EAL4_AUDIT</code> can optionally be in list to collect pre-defined
     * selective log files. The selected log files are deleted from the support bundle
     * if the files have not been modified in the last 4 hours.</li></ul> 
     * <p>By
     * default no core dumps and audit logs are included in support bundle with filter
     * <code>DEFAULT</code>.</p> 
     * <p>No other content-filters can be added along with
     * <code>EAL4_AUDIT</code> content-filter</p>
     * <p> </p>
     * <p>When content-filter
     * <code>EAL4_AUDIT</code> is added, the log_age_limit field is disabled.</p>
     *
     * <p>Note, <code>REMOVE_CORE_FILES</code> is limited to NSX appliance nodes
     * only.</p>
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getContentFilters() {
        return this.contentFilters;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.SupportBundleRequest#CONTENT_FILTERS_ALL}</li> <li> {@link
     * com.vmware.nsx.model.SupportBundleRequest#CONTENT_FILTERS_DEFAULT}</li> <li>
     * {@link
     * com.vmware.nsx.model.SupportBundleRequest#CONTENT_FILTERS_REMOVE_CORE_FILES}</li>
     * <li> {@link
     * com.vmware.nsx.model.SupportBundleRequest#CONTENT_FILTERS_EAL4_AUDIT}</li> </ul>
     *
     * <p>List of content filters that specify additional content or action when
     * collecting support bundle. </p> <ul><li>Filter <code>ALL</code> includes core
     * dumps and audit logs in support bundle</li> <li>Filter
     * <code>REMOVE_CORE_FILES</code> can optionally be in list with <code>ALL</code>,
     * to remove core dump files after collected in support bundle</li> <li>Filter
     * <code>EAL4_AUDIT</code> can optionally be in list to collect pre-defined
     * selective log files. The selected log files are deleted from the support bundle
     * if the files have not been modified in the last 4 hours.</li></ul> 
     * <p>By
     * default no core dumps and audit logs are included in support bundle with filter
     * <code>DEFAULT</code>.</p> 
     * <p>No other content-filters can be added along with
     * <code>EAL4_AUDIT</code> content-filter</p>
     * <p> </p>
     * <p>When content-filter
     * <code>EAL4_AUDIT</code> is added, the log_age_limit field is disabled.</p>
     *
     * <p>Note, <code>REMOVE_CORE_FILES</code> is limited to NSX appliance nodes
     * only.</p>
     *
     * @param contentFilters New value for the property.
     */
    public void setContentFilters(java.util.List<java.lang.String> contentFilters) {
        this.contentFilters = contentFilters;
    }

    /**
     * List of dynamic content filters that specify additional content to include in
     * the support bundle. The list of available filters available depends on your
     * NSX-T deployment and can be determined by invoking the GET
     * /api/v1/adminstration/support-bundles/dynamic-content-filters NSX API. For
     * example, if NSX Intelligence is deployed, filters for collecting specific
     * information about services are available.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getDynamicContentFilters() {
        return this.dynamicContentFilters;
    }

    /**
     * List of dynamic content filters that specify additional content to include in
     * the support bundle. The list of available filters available depends on your
     * NSX-T deployment and can be determined by invoking the GET
     * /api/v1/adminstration/support-bundles/dynamic-content-filters NSX API. For
     * example, if NSX Intelligence is deployed, filters for collecting specific
     * information about services are available.
     *
     * @param dynamicContentFilters New value for the property.
     */
    public void setDynamicContentFilters(java.util.List<java.lang.String> dynamicContentFilters) {
        this.dynamicContentFilters = dynamicContentFilters;
    }

    /**
     * Include log files with modified times not past the age limit in days format:
     * int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLogAgeLimit() {
        return this.logAgeLimit;
    }

    /**
     * Include log files with modified times not past the age limit in days format:
     * int64
     *
     * @param logAgeLimit New value for the property.
     */
    public void setLogAgeLimit(java.lang.Long logAgeLimit) {
        this.logAgeLimit = logAgeLimit;
    }

    /**
     * List of cluster/fabric node UUIDs processed in specified order
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getNodes() {
        return this.nodes;
    }

    /**
     * List of cluster/fabric node UUIDs processed in specified order
     *
     * @param nodes New value for the property.
     */
    public void setNodes(java.util.List<java.lang.String> nodes) {
        this.nodes = nodes;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.SupportBundleRemoteFileServer getRemoteFileServer() {
        return this.remoteFileServer;
    }

    /**
     *
     *
     * @param remoteFileServer New value for the property.
     */
    public void setRemoteFileServer(com.vmware.nsx.model.SupportBundleRemoteFileServer remoteFileServer) {
        this.remoteFileServer = remoteFileServer;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.supportBundleRequest;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("container_nodes",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.containerNodes, this._getType().getField("container_nodes")));
        structValue.setField("content_filters",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.contentFilters, this._getType().getField("content_filters")));
        structValue.setField("dynamic_content_filters",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dynamicContentFilters, this._getType().getField("dynamic_content_filters")));
        structValue.setField("log_age_limit",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.logAgeLimit, this._getType().getField("log_age_limit")));
        structValue.setField("nodes",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nodes, this._getType().getField("nodes")));
        structValue.setField("remote_file_server",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.remoteFileServer, this._getType().getField("remote_file_server")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.supportBundleRequest;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.supportBundleRequest.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static SupportBundleRequest _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new SupportBundleRequest(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static SupportBundleRequest _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new SupportBundleRequest(structValue);
    }

    /**
     * Builder class for {@link SupportBundleRequest}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.vapi.bindings.Structure> containerNodes;
        private java.util.List<java.lang.String> contentFilters;
        private java.util.List<java.lang.String> dynamicContentFilters;
        private java.lang.Long logAgeLimit;
        private java.util.List<java.lang.String> nodes;
        private com.vmware.nsx.model.SupportBundleRemoteFileServer remoteFileServer;

        /**
         * Constructor with parameters for the required properties of
         * {@link SupportBundleRequest}.
         */
        public Builder() {
        }

        /**
         * List of container clusters and their nodes requiring support bundle collection
         *
         * @param containerNodes New value for the property.
         * When clients pass a value of this class as a parameter, the property must
         * contain all the properties defined in {@link
         * com.vmware.nsx.model.SupportBundleContainerNode}. When methods return a value of
         * this class as a return value, the property will contain all the properties
         * defined in {@link com.vmware.nsx.model.SupportBundleContainerNode}.
         */
        public Builder setContainerNodes(java.util.List<com.vmware.vapi.bindings.Structure> containerNodes) {
            this.containerNodes = containerNodes;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.SupportBundleRequest#CONTENT_FILTERS_ALL}</li> <li> {@link
         * com.vmware.nsx.model.SupportBundleRequest#CONTENT_FILTERS_DEFAULT}</li> <li>
         * {@link
         * com.vmware.nsx.model.SupportBundleRequest#CONTENT_FILTERS_REMOVE_CORE_FILES}</li>
         * <li> {@link
         * com.vmware.nsx.model.SupportBundleRequest#CONTENT_FILTERS_EAL4_AUDIT}</li> </ul>
         *
         * <p>List of content filters that specify additional content or action when
         * collecting support bundle. </p> <ul><li>Filter <code>ALL</code> includes core
         * dumps and audit logs in support bundle</li> <li>Filter
         * <code>REMOVE_CORE_FILES</code> can optionally be in list with <code>ALL</code>,
         * to remove core dump files after collected in support bundle</li> <li>Filter
         * <code>EAL4_AUDIT</code> can optionally be in list to collect pre-defined
         * selective log files. The selected log files are deleted from the support bundle
         * if the files have not been modified in the last 4 hours.</li></ul> 
         * <p>By
         * default no core dumps and audit logs are included in support bundle with filter
         * <code>DEFAULT</code>.</p> 
         * <p>No other content-filters can be added along with
         * <code>EAL4_AUDIT</code> content-filter</p>
         * <p> </p>
         * <p>When content-filter
         * <code>EAL4_AUDIT</code> is added, the log_age_limit field is disabled.</p>
         *
         * <p>Note, <code>REMOVE_CORE_FILES</code> is limited to NSX appliance nodes
         * only.</p>
         *
         * @param contentFilters New value for the property.
         */
        public Builder setContentFilters(java.util.List<java.lang.String> contentFilters) {
            this.contentFilters = contentFilters;
            return this;
        }

        /**
         * List of dynamic content filters that specify additional content to include in
         * the support bundle. The list of available filters available depends on your
         * NSX-T deployment and can be determined by invoking the GET
         * /api/v1/adminstration/support-bundles/dynamic-content-filters NSX API. For
         * example, if NSX Intelligence is deployed, filters for collecting specific
         * information about services are available.
         *
         * @param dynamicContentFilters New value for the property.
         */
        public Builder setDynamicContentFilters(java.util.List<java.lang.String> dynamicContentFilters) {
            this.dynamicContentFilters = dynamicContentFilters;
            return this;
        }

        /**
         * Include log files with modified times not past the age limit in days format:
         * int64
         *
         * @param logAgeLimit New value for the property.
         */
        public Builder setLogAgeLimit(java.lang.Long logAgeLimit) {
            this.logAgeLimit = logAgeLimit;
            return this;
        }

        /**
         * List of cluster/fabric node UUIDs processed in specified order
         *
         * @param nodes New value for the property.
         */
        public Builder setNodes(java.util.List<java.lang.String> nodes) {
            this.nodes = nodes;
            return this;
        }

        /**
         *
         *
         * @param remoteFileServer New value for the property.
         */
        public Builder setRemoteFileServer(com.vmware.nsx.model.SupportBundleRemoteFileServer remoteFileServer) {
            this.remoteFileServer = remoteFileServer;
            return this;
        }

        public SupportBundleRequest build() {
            SupportBundleRequest result = new SupportBundleRequest();
            result.setContainerNodes(this.containerNodes);
            result.setContentFilters(this.contentFilters);
            result.setDynamicContentFilters(this.dynamicContentFilters);
            result.setLogAgeLimit(this.logAgeLimit);
            result.setNodes(this.nodes);
            result.setRemoteFileServer(this.remoteFileServer);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("container_nodes", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.DynamicStructType(java.util.Arrays.<com.vmware.vapi.internal.data.ConstraintValidator>asList(new com.vmware.vapi.internal.bindings.HasFieldsOfValidator(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.supportBundleContainerNode; } }))))));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("container_nodes",
                                                                                "containerNodes",
                                                                                "getContainerNodes",
                                                                                "setContainerNodes");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("content_filters", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("content_filters",
                                                                                "contentFilters",
                                                                                "getContentFilters",
                                                                                "setContentFilters");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("dynamic_content_filters", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dynamic_content_filters",
                                                                                "dynamicContentFilters",
                                                                                "getDynamicContentFilters",
                                                                                "setDynamicContentFilters");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("log_age_limit", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("log_age_limit",
                                                                                "logAgeLimit",
                                                                                "getLogAgeLimit",
                                                                                "setLogAgeLimit");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("nodes", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("nodes",
                                                                                "nodes",
                                                                                "getNodes",
                                                                                "setNodes");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("remote_file_server", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.supportBundleRemoteFileServer; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("remote_file_server",
                                                                                "remoteFileServer",
                                                                                "getRemoteFileServer",
                                                                                "setRemoteFileServer");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.support_bundle_request",
                                                            fields,
                                                            com.vmware.nsx.model.SupportBundleRequest.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

