/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * A login credential specifying a username and password
 */
public final class UsernamePasswordLoginCredential implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "UsernamePasswordLoginCredential";

    private java.lang.String password;

    private java.lang.String thumbprint;

    private java.lang.String username;

    private final java.lang.String credentialType = "UsernamePasswordLoginCredential";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public UsernamePasswordLoginCredential() {
    }

    protected UsernamePasswordLoginCredential(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The authentication password for login
     *
     * @return The current value of the property.
     */
    public java.lang.String getPassword() {
        return this.password;
    }

    /**
     * The authentication password for login
     *
     * @param password New value for the property.
     */
    public void setPassword(java.lang.String password) {
        this.password = password;
    }

    /**
     * Thumbprint of the login server
     *
     * @return The current value of the property.
     */
    public java.lang.String getThumbprint() {
        return this.thumbprint;
    }

    /**
     * Thumbprint of the login server
     *
     * @param thumbprint New value for the property.
     */
    public void setThumbprint(java.lang.String thumbprint) {
        this.thumbprint = thumbprint;
    }

    /**
     * The username for login
     *
     * @return The current value of the property.
     */
    public java.lang.String getUsername() {
        return this.username;
    }

    /**
     * The username for login
     *
     * @param username New value for the property.
     */
    public void setUsername(java.lang.String username) {
        this.username = username;
    }

    /**
     * Possible values are 'UsernamePasswordLoginCredential',
     * 'VerifiableAsymmetricLoginCredential', 'SessionLoginCredential'.
     * The value of this property is automatically populated to {@code "UsernamePasswordLoginCredential"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCredentialType() {
        return this.credentialType;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.usernamePasswordLoginCredential;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("password",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.password, this._getType().getField("password")));
        structValue.setField("thumbprint",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.thumbprint, this._getType().getField("thumbprint")));
        structValue.setField("username",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.username, this._getType().getField("username")));
        structValue.setField("credential_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.credentialType, this._getType().getField("credential_type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.usernamePasswordLoginCredential;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.usernamePasswordLoginCredential.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static UsernamePasswordLoginCredential _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new UsernamePasswordLoginCredential(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static UsernamePasswordLoginCredential _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new UsernamePasswordLoginCredential(structValue);
    }

    /**
     * Builder class for {@link UsernamePasswordLoginCredential}.
     */
    public static final class Builder {
        private java.lang.String password;
        private java.lang.String thumbprint;
        private java.lang.String username;

        /**
         * Constructor with parameters for the required properties of
         * {@link UsernamePasswordLoginCredential}.
         */
        public Builder() {
        }

        /**
         * The authentication password for login
         *
         * @param password New value for the property.
         */
        public Builder setPassword(java.lang.String password) {
            this.password = password;
            return this;
        }

        /**
         * Thumbprint of the login server
         *
         * @param thumbprint New value for the property.
         */
        public Builder setThumbprint(java.lang.String thumbprint) {
            this.thumbprint = thumbprint;
            return this;
        }

        /**
         * The username for login
         *
         * @param username New value for the property.
         */
        public Builder setUsername(java.lang.String username) {
            this.username = username;
            return this;
        }

        public UsernamePasswordLoginCredential build() {
            UsernamePasswordLoginCredential result = new UsernamePasswordLoginCredential();
            result.setPassword(this.password);
            result.setThumbprint(this.thumbprint);
            result.setUsername(this.username);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("password", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("password",
                                                                                "password",
                                                                                "getPassword",
                                                                                "setPassword");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("thumbprint", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("thumbprint",
                                                                                "thumbprint",
                                                                                "getThumbprint",
                                                                                "setThumbprint");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("username", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("username",
                                                                                "username",
                                                                                "getUsername",
                                                                                "setUsername");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("credential_type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("credential_type",
                                                                                "credentialType",
                                                                                "getCredentialType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.username_password_login_credential",
                                                            fields,
                                                            com.vmware.nsx.model.UsernamePasswordLoginCredential.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "credential_type",
                                                            "UsernamePasswordLoginCredential");
    }
}

