/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * The Vsphere deployment configuration determines where to deploy the edge node.
 * It contains settings that are applied during install time. Use EdgeNodeSettings
 * to specify host name, SSH, NTP and DNS settings for both deployment and
 * consequent update. These settings are editable for manually deployed edge nodes
 * as well. EdgeNodeSettings reports current values configured on the edge node.
 */
public final class VsphereDeploymentConfig implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "VsphereDeploymentConfig";

    public static final java.lang.String IPV6ASSIGNMENT_TYPE_STATIC = "STATIC";

    private java.util.List<com.vmware.nsx.model.KeyValuePair> advancedConfiguration;

    private java.lang.String computeFolderId;

    private java.lang.String computeId;

    private java.util.List<java.lang.String> dataNetworkIds;

    private java.util.List<java.lang.String> defaultGatewayAddresses;

    private java.lang.String hostId;

    private java.lang.Boolean ipv4AssignmentEnabled;

    private java.lang.String ipv6AssignmentType;

    private java.lang.String managementNetworkId;

    private java.util.List<com.vmware.nsx.model.IPSubnet> managementPortSubnets;

    private com.vmware.nsx.model.ReservationInfo reservationInfo;

    private com.vmware.nsx.model.ResourceAssignment resourceAllocation;

    private java.lang.String storageId;

    private java.lang.String vcId;

    private final java.lang.String placementType = "VsphereDeploymentConfig";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public VsphereDeploymentConfig() {
    }

    protected VsphereDeploymentConfig(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * This field is deprecated. EdgeNodeSettings field 'advanced_configuration' must
     * be used instead. Array of additional specific properties for advanced or
     * cloud-specific deployments in key-value format.
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.util.List<com.vmware.nsx.model.KeyValuePair> getAdvancedConfiguration() {
        return this.advancedConfiguration;
    }

    /**
     * This field is deprecated. EdgeNodeSettings field 'advanced_configuration' must
     * be used instead. Array of additional specific properties for advanced or
     * cloud-specific deployments in key-value format.
     *
     * @param advancedConfiguration New value for the property.
     */
    @Deprecated
    public void setAdvancedConfiguration(java.util.List<com.vmware.nsx.model.KeyValuePair> advancedConfiguration) {
        this.advancedConfiguration = advancedConfiguration;
    }

    /**
     * The edge node vm will be deployed on the specified compute folder created in a
     * datacenter, if compute folder is specified. Note - User must ensure that compute
     * folder is accessible by specified cluster/host.
     *
     * @return The current value of the property.
     */
    public java.lang.String getComputeFolderId() {
        return this.computeFolderId;
    }

    /**
     * The edge node vm will be deployed on the specified compute folder created in a
     * datacenter, if compute folder is specified. Note - User must ensure that compute
     * folder is accessible by specified cluster/host.
     *
     * @param computeFolderId New value for the property.
     */
    public void setComputeFolderId(java.lang.String computeFolderId) {
        this.computeFolderId = computeFolderId;
    }

    /**
     * The edge node vm will be deployed on the specified cluster or resourcepool. Note
     * - all the hosts must have nsx fabric prepared in the specified cluster.
     *
     * @return The current value of the property.
     */
    public java.lang.String getComputeId() {
        return this.computeId;
    }

    /**
     * The edge node vm will be deployed on the specified cluster or resourcepool. Note
     * - all the hosts must have nsx fabric prepared in the specified cluster.
     *
     * @param computeId New value for the property.
     */
    public void setComputeId(java.lang.String computeId) {
        this.computeId = computeId;
    }

    /**
     * List of distributed portgroups, VLAN logical switch identifiers or segment paths
     * to which the datapath serving vnics of edge node vm will be connected. If a VM
     * network interface is not configured, it is disconnected and represented as an
     * empty string.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getDataNetworkIds() {
        return this.dataNetworkIds;
    }

    /**
     * List of distributed portgroups, VLAN logical switch identifiers or segment paths
     * to which the datapath serving vnics of edge node vm will be connected. If a VM
     * network interface is not configured, it is disconnected and represented as an
     * empty string.
     *
     * @param dataNetworkIds New value for the property.
     */
    public void setDataNetworkIds(java.util.List<java.lang.String> dataNetworkIds) {
        this.dataNetworkIds = dataNetworkIds;
    }

    /**
     * The default gateway for edge node must be specified if all the nodes it
     * communicates with are not in the same subnet. Note: IPv4, IPv6 and Dual Stack
     * Address is supported and it must belong to management network. format: ip
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getDefaultGatewayAddresses() {
        return this.defaultGatewayAddresses;
    }

    /**
     * The default gateway for edge node must be specified if all the nodes it
     * communicates with are not in the same subnet. Note: IPv4, IPv6 and Dual Stack
     * Address is supported and it must belong to management network. format: ip
     *
     * @param defaultGatewayAddresses New value for the property.
     */
    public void setDefaultGatewayAddresses(java.util.List<java.lang.String> defaultGatewayAddresses) {
        this.defaultGatewayAddresses = defaultGatewayAddresses;
    }

    /**
     * The edge node vm will be deployed on the specified Host within the cluster if
     * host_id is specified. Note - User must ensure that storage and specified
     * networks are accessible by this host.
     *
     * @return The current value of the property.
     */
    public java.lang.String getHostId() {
        return this.hostId;
    }

    /**
     * The edge node vm will be deployed on the specified Host within the cluster if
     * host_id is specified. Note - User must ensure that storage and specified
     * networks are accessible by this host.
     *
     * @param hostId New value for the property.
     */
    public void setHostId(java.lang.String hostId) {
        this.hostId = hostId;
    }

    /**
     * This flag represents whether IPv4 configuration is enabled or not. This flag is
     * especially important when IPv6 only configuration is required and value should
     * be false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getIpv4AssignmentEnabled() {
        return this.ipv4AssignmentEnabled;
    }

    /**
     * This flag represents whether IPv4 configuration is enabled or not. This flag is
     * especially important when IPv6 only configuration is required and value should
     * be false.
     *
     * @param ipv4AssignmentEnabled New value for the property.
     */
    public void setIpv4AssignmentEnabled(java.lang.Boolean ipv4AssignmentEnabled) {
        this.ipv4AssignmentEnabled = ipv4AssignmentEnabled;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.VsphereDeploymentConfig#IPV6ASSIGNMENT_TYPE_STATIC}</li>
     * </ul> IPv6 assignment type e.g STATIC, DHCPV6, SLAAC. if enum value is STATIC
     * then management_port_subnets is mandatory. In this iteration DHCPV6 and SLAAC
     * are not supported.
     *
     * @return The current value of the property.
     */
    public java.lang.String getIpv6AssignmentType() {
        return this.ipv6AssignmentType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.VsphereDeploymentConfig#IPV6ASSIGNMENT_TYPE_STATIC}</li>
     * </ul> IPv6 assignment type e.g STATIC, DHCPV6, SLAAC. if enum value is STATIC
     * then management_port_subnets is mandatory. In this iteration DHCPV6 and SLAAC
     * are not supported.
     *
     * @param ipv6AssignmentType New value for the property.
     */
    public void setIpv6AssignmentType(java.lang.String ipv6AssignmentType) {
        this.ipv6AssignmentType = ipv6AssignmentType;
    }

    /**
     * Distributed portgroup identifier to which the management vnic of edge node vm
     * will be connected. This portgroup must have connectivity with MP and CCP. A VLAN
     * logical switch identifier may also be specified. If VM network interface is not
     * connected, it is represented as an empty string.
     *
     * @return The current value of the property.
     */
    public java.lang.String getManagementNetworkId() {
        return this.managementNetworkId;
    }

    /**
     * Distributed portgroup identifier to which the management vnic of edge node vm
     * will be connected. This portgroup must have connectivity with MP and CCP. A VLAN
     * logical switch identifier may also be specified. If VM network interface is not
     * connected, it is represented as an empty string.
     *
     * @param managementNetworkId New value for the property.
     */
    public void setManagementNetworkId(java.lang.String managementNetworkId) {
        this.managementNetworkId = managementNetworkId;
    }

    /**
     * IP Address and subnet configuration for the management port. Note: IPv4, IPv6
     * and Dual Stack Address is supported.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.IPSubnet> getManagementPortSubnets() {
        return this.managementPortSubnets;
    }

    /**
     * IP Address and subnet configuration for the management port. Note: IPv4, IPv6
     * and Dual Stack Address is supported.
     *
     * @param managementPortSubnets New value for the property.
     */
    public void setManagementPortSubnets(java.util.List<com.vmware.nsx.model.IPSubnet> managementPortSubnets) {
        this.managementPortSubnets = managementPortSubnets;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.ReservationInfo getReservationInfo() {
        return this.reservationInfo;
    }

    /**
     *
     *
     * @param reservationInfo New value for the property.
     */
    public void setReservationInfo(com.vmware.nsx.model.ReservationInfo reservationInfo) {
        this.reservationInfo = reservationInfo;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.ResourceAssignment getResourceAllocation() {
        return this.resourceAllocation;
    }

    /**
     *
     *
     * @param resourceAllocation New value for the property.
     */
    public void setResourceAllocation(com.vmware.nsx.model.ResourceAssignment resourceAllocation) {
        this.resourceAllocation = resourceAllocation;
    }

    /**
     * The edge node vm will be deployed on the specified datastore. User must ensure
     * that storage is accessible by the specified cluster/host.
     *
     * @return The current value of the property.
     */
    public java.lang.String getStorageId() {
        return this.storageId;
    }

    /**
     * The edge node vm will be deployed on the specified datastore. User must ensure
     * that storage is accessible by the specified cluster/host.
     *
     * @param storageId New value for the property.
     */
    public void setStorageId(java.lang.String storageId) {
        this.storageId = storageId;
    }

    /**
     * The vc specific identifiers will be resolved on this VC. So all other
     * identifiers specified here must belong to this vcenter server.
     *
     * @return The current value of the property.
     */
    public java.lang.String getVcId() {
        return this.vcId;
    }

    /**
     * The vc specific identifiers will be resolved on this VC. So all other
     * identifiers specified here must belong to this vcenter server.
     *
     * @param vcId New value for the property.
     */
    public void setVcId(java.lang.String vcId) {
        this.vcId = vcId;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.DeploymentConfig#PLACEMENT_TYPE_VSPHEREDEPLOYMENTCONFIG}</li>
     * </ul>
     * The value of this property is automatically populated to {@code "VsphereDeploymentConfig"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPlacementType() {
        return this.placementType;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.vsphereDeploymentConfig;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("advanced_configuration",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.advancedConfiguration, this._getType().getField("advanced_configuration")));
        structValue.setField("compute_folder_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.computeFolderId, this._getType().getField("compute_folder_id")));
        structValue.setField("compute_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.computeId, this._getType().getField("compute_id")));
        structValue.setField("data_network_ids",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dataNetworkIds, this._getType().getField("data_network_ids")));
        structValue.setField("default_gateway_addresses",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.defaultGatewayAddresses, this._getType().getField("default_gateway_addresses")));
        structValue.setField("host_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.hostId, this._getType().getField("host_id")));
        structValue.setField("ipv4_assignment_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ipv4AssignmentEnabled, this._getType().getField("ipv4_assignment_enabled")));
        structValue.setField("ipv6_assignment_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ipv6AssignmentType, this._getType().getField("ipv6_assignment_type")));
        structValue.setField("management_network_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.managementNetworkId, this._getType().getField("management_network_id")));
        structValue.setField("management_port_subnets",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.managementPortSubnets, this._getType().getField("management_port_subnets")));
        structValue.setField("reservation_info",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.reservationInfo, this._getType().getField("reservation_info")));
        structValue.setField("resource_allocation",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceAllocation, this._getType().getField("resource_allocation")));
        structValue.setField("storage_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.storageId, this._getType().getField("storage_id")));
        structValue.setField("vc_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vcId, this._getType().getField("vc_id")));
        structValue.setField("placement_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.placementType, this._getType().getField("placement_type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.vsphereDeploymentConfig;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.vsphereDeploymentConfig.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static VsphereDeploymentConfig _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new VsphereDeploymentConfig(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static VsphereDeploymentConfig _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new VsphereDeploymentConfig(structValue);
    }

    /**
     * Builder class for {@link VsphereDeploymentConfig}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.nsx.model.KeyValuePair> advancedConfiguration;
        private java.lang.String computeFolderId;
        private java.lang.String computeId;
        private java.util.List<java.lang.String> dataNetworkIds;
        private java.util.List<java.lang.String> defaultGatewayAddresses;
        private java.lang.String hostId;
        private java.lang.Boolean ipv4AssignmentEnabled;
        private java.lang.String ipv6AssignmentType;
        private java.lang.String managementNetworkId;
        private java.util.List<com.vmware.nsx.model.IPSubnet> managementPortSubnets;
        private com.vmware.nsx.model.ReservationInfo reservationInfo;
        private com.vmware.nsx.model.ResourceAssignment resourceAllocation;
        private java.lang.String storageId;
        private java.lang.String vcId;

        /**
         * Constructor with parameters for the required properties of
         * {@link VsphereDeploymentConfig}.
         */
        public Builder() {
        }

        /**
         * This field is deprecated. EdgeNodeSettings field 'advanced_configuration' must
         * be used instead. Array of additional specific properties for advanced or
         * cloud-specific deployments in key-value format.
         *
         * @param advancedConfiguration New value for the property.
         */
        public Builder setAdvancedConfiguration(java.util.List<com.vmware.nsx.model.KeyValuePair> advancedConfiguration) {
            this.advancedConfiguration = advancedConfiguration;
            return this;
        }

        /**
         * The edge node vm will be deployed on the specified compute folder created in a
         * datacenter, if compute folder is specified. Note - User must ensure that compute
         * folder is accessible by specified cluster/host.
         *
         * @param computeFolderId New value for the property.
         */
        public Builder setComputeFolderId(java.lang.String computeFolderId) {
            this.computeFolderId = computeFolderId;
            return this;
        }

        /**
         * The edge node vm will be deployed on the specified cluster or resourcepool. Note
         * - all the hosts must have nsx fabric prepared in the specified cluster.
         *
         * @param computeId New value for the property.
         */
        public Builder setComputeId(java.lang.String computeId) {
            this.computeId = computeId;
            return this;
        }

        /**
         * List of distributed portgroups, VLAN logical switch identifiers or segment paths
         * to which the datapath serving vnics of edge node vm will be connected. If a VM
         * network interface is not configured, it is disconnected and represented as an
         * empty string.
         *
         * @param dataNetworkIds New value for the property.
         */
        public Builder setDataNetworkIds(java.util.List<java.lang.String> dataNetworkIds) {
            this.dataNetworkIds = dataNetworkIds;
            return this;
        }

        /**
         * The default gateway for edge node must be specified if all the nodes it
         * communicates with are not in the same subnet. Note: IPv4, IPv6 and Dual Stack
         * Address is supported and it must belong to management network. format: ip
         *
         * @param defaultGatewayAddresses New value for the property.
         */
        public Builder setDefaultGatewayAddresses(java.util.List<java.lang.String> defaultGatewayAddresses) {
            this.defaultGatewayAddresses = defaultGatewayAddresses;
            return this;
        }

        /**
         * The edge node vm will be deployed on the specified Host within the cluster if
         * host_id is specified. Note - User must ensure that storage and specified
         * networks are accessible by this host.
         *
         * @param hostId New value for the property.
         */
        public Builder setHostId(java.lang.String hostId) {
            this.hostId = hostId;
            return this;
        }

        /**
         * This flag represents whether IPv4 configuration is enabled or not. This flag is
         * especially important when IPv6 only configuration is required and value should
         * be false.
         *
         * @param ipv4AssignmentEnabled New value for the property.
         */
        public Builder setIpv4AssignmentEnabled(java.lang.Boolean ipv4AssignmentEnabled) {
            this.ipv4AssignmentEnabled = ipv4AssignmentEnabled;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.VsphereDeploymentConfig#IPV6ASSIGNMENT_TYPE_STATIC}</li>
         * </ul> IPv6 assignment type e.g STATIC, DHCPV6, SLAAC. if enum value is STATIC
         * then management_port_subnets is mandatory. In this iteration DHCPV6 and SLAAC
         * are not supported.
         *
         * @param ipv6AssignmentType New value for the property.
         */
        public Builder setIpv6AssignmentType(java.lang.String ipv6AssignmentType) {
            this.ipv6AssignmentType = ipv6AssignmentType;
            return this;
        }

        /**
         * Distributed portgroup identifier to which the management vnic of edge node vm
         * will be connected. This portgroup must have connectivity with MP and CCP. A VLAN
         * logical switch identifier may also be specified. If VM network interface is not
         * connected, it is represented as an empty string.
         *
         * @param managementNetworkId New value for the property.
         */
        public Builder setManagementNetworkId(java.lang.String managementNetworkId) {
            this.managementNetworkId = managementNetworkId;
            return this;
        }

        /**
         * IP Address and subnet configuration for the management port. Note: IPv4, IPv6
         * and Dual Stack Address is supported.
         *
         * @param managementPortSubnets New value for the property.
         */
        public Builder setManagementPortSubnets(java.util.List<com.vmware.nsx.model.IPSubnet> managementPortSubnets) {
            this.managementPortSubnets = managementPortSubnets;
            return this;
        }

        /**
         *
         *
         * @param reservationInfo New value for the property.
         */
        public Builder setReservationInfo(com.vmware.nsx.model.ReservationInfo reservationInfo) {
            this.reservationInfo = reservationInfo;
            return this;
        }

        /**
         *
         *
         * @param resourceAllocation New value for the property.
         */
        public Builder setResourceAllocation(com.vmware.nsx.model.ResourceAssignment resourceAllocation) {
            this.resourceAllocation = resourceAllocation;
            return this;
        }

        /**
         * The edge node vm will be deployed on the specified datastore. User must ensure
         * that storage is accessible by the specified cluster/host.
         *
         * @param storageId New value for the property.
         */
        public Builder setStorageId(java.lang.String storageId) {
            this.storageId = storageId;
            return this;
        }

        /**
         * The vc specific identifiers will be resolved on this VC. So all other
         * identifiers specified here must belong to this vcenter server.
         *
         * @param vcId New value for the property.
         */
        public Builder setVcId(java.lang.String vcId) {
            this.vcId = vcId;
            return this;
        }

        public VsphereDeploymentConfig build() {
            VsphereDeploymentConfig result = new VsphereDeploymentConfig();
            result.setAdvancedConfiguration(this.advancedConfiguration);
            result.setComputeFolderId(this.computeFolderId);
            result.setComputeId(this.computeId);
            result.setDataNetworkIds(this.dataNetworkIds);
            result.setDefaultGatewayAddresses(this.defaultGatewayAddresses);
            result.setHostId(this.hostId);
            result.setIpv4AssignmentEnabled(this.ipv4AssignmentEnabled);
            result.setIpv6AssignmentType(this.ipv6AssignmentType);
            result.setManagementNetworkId(this.managementNetworkId);
            result.setManagementPortSubnets(this.managementPortSubnets);
            result.setReservationInfo(this.reservationInfo);
            result.setResourceAllocation(this.resourceAllocation);
            result.setStorageId(this.storageId);
            result.setVcId(this.vcId);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("advanced_configuration", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.keyValuePair; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("advanced_configuration",
                                                                                "advancedConfiguration",
                                                                                "getAdvancedConfiguration",
                                                                                "setAdvancedConfiguration");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("compute_folder_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("compute_folder_id",
                                                                                "computeFolderId",
                                                                                "getComputeFolderId",
                                                                                "setComputeFolderId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("compute_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("compute_id",
                                                                                "computeId",
                                                                                "getComputeId",
                                                                                "setComputeId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("data_network_ids", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("data_network_ids",
                                                                                "dataNetworkIds",
                                                                                "getDataNetworkIds",
                                                                                "setDataNetworkIds");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("default_gateway_addresses", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("default_gateway_addresses",
                                                                                "defaultGatewayAddresses",
                                                                                "getDefaultGatewayAddresses",
                                                                                "setDefaultGatewayAddresses");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("host_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("host_id",
                                                                                "hostId",
                                                                                "getHostId",
                                                                                "setHostId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ipv4_assignment_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ipv4_assignment_enabled",
                                                                                "ipv4AssignmentEnabled",
                                                                                "getIpv4AssignmentEnabled",
                                                                                "setIpv4AssignmentEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ipv6_assignment_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ipv6_assignment_type",
                                                                                "ipv6AssignmentType",
                                                                                "getIpv6AssignmentType",
                                                                                "setIpv6AssignmentType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("management_network_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("management_network_id",
                                                                                "managementNetworkId",
                                                                                "getManagementNetworkId",
                                                                                "setManagementNetworkId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("management_port_subnets", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.IPSubnet; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("management_port_subnets",
                                                                                "managementPortSubnets",
                                                                                "getManagementPortSubnets",
                                                                                "setManagementPortSubnets");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("reservation_info", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.reservationInfo; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("reservation_info",
                                                                                "reservationInfo",
                                                                                "getReservationInfo",
                                                                                "setReservationInfo");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_allocation", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.resourceAssignment; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_allocation",
                                                                                "resourceAllocation",
                                                                                "getResourceAllocation",
                                                                                "setResourceAllocation");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("storage_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("storage_id",
                                                                                "storageId",
                                                                                "getStorageId",
                                                                                "setStorageId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vc_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vc_id",
                                                                                "vcId",
                                                                                "getVcId",
                                                                                "setVcId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("placement_type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("placement_type",
                                                                                "placementType",
                                                                                "getPlacementType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.vsphere_deployment_config",
                                                            fields,
                                                            com.vmware.nsx.model.VsphereDeploymentConfig.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "placement_type",
                                                            "VsphereDeploymentConfig");
    }
}

