/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.node.network.
 * Used by client-side stubs.
 */

package com.vmware.nsx.node.network;

public interface Interfaces extends com.vmware.vapi.bindings.Service, com.vmware.nsx.node.network.InterfacesTypes {

    /**
     * Returns detailed information about the specified interface. Interface
     * information includes MTU, broadcast and host IP addresses, link and admin
     * status, MAC address, network mask, and the IP configuration method.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param interfaceId ID of interface to read (required)
     * @return com.vmware.nsx.model.NodeNetworkInterfaceProperties
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.NodeNetworkInterfaceProperties get(java.lang.String interfaceId);

    /**
     * Returns detailed information about the specified interface. Interface
     * information includes MTU, broadcast and host IP addresses, link and admin
     * status, MAC address, network mask, and the IP configuration method.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param interfaceId ID of interface to read (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.NodeNetworkInterfaceProperties
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.NodeNetworkInterfaceProperties get(java.lang.String interfaceId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns detailed information about the specified interface. Interface
     * information includes MTU, broadcast and host IP addresses, link and admin
     * status, MAC address, network mask, and the IP configuration method.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param interfaceId ID of interface to read (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String interfaceId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeNetworkInterfaceProperties> asyncCallback);

    /**
     * Returns detailed information about the specified interface. Interface
     * information includes MTU, broadcast and host IP addresses, link and admin
     * status, MAC address, network mask, and the IP configuration method.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param interfaceId ID of interface to read (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String interfaceId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeNetworkInterfaceProperties> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns the number of interfaces on the node appliance and detailed information
     * about each interface. Interface information includes MTU, broadcast and host IP
     * addresses, link and admin status, MAC address, network mask, and the IP
     * configuration method (static or DHCP).
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @return com.vmware.nsx.model.NodeNetworkInterfacePropertiesListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.NodeNetworkInterfacePropertiesListResult list();

    /**
     * Returns the number of interfaces on the node appliance and detailed information
     * about each interface. Interface information includes MTU, broadcast and host IP
     * addresses, link and admin status, MAC address, network mask, and the IP
     * configuration method (static or DHCP).
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.NodeNetworkInterfacePropertiesListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.NodeNetworkInterfacePropertiesListResult list(com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns the number of interfaces on the node appliance and detailed information
     * about each interface. Interface information includes MTU, broadcast and host IP
     * addresses, link and admin status, MAC address, network mask, and the IP
     * configuration method (static or DHCP).
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeNetworkInterfacePropertiesListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeNetworkInterfacePropertiesListResult> asyncCallback);

    /**
     * Returns the number of interfaces on the node appliance and detailed information
     * about each interface. Interface information includes MTU, broadcast and host IP
     * addresses, link and admin status, MAC address, network mask, and the IP
     * configuration method (static or DHCP).
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeNetworkInterfacePropertiesListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeNetworkInterfacePropertiesListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Updates the specified interface properties. You cannot change the properties
     * <code>ip_configuration</code>, <code>ip_addresses</code>, or <code>plane</code>.
     * NSX Manager must have a static IP address. You must use NSX CLI to configure a
     * controller or an edge node.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param interfaceId ID of interface to update (required)
     * @param nodeNetworkInterfaceProperties (required)
     * @return com.vmware.nsx.model.NodeNetworkInterfaceProperties
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.NodeNetworkInterfaceProperties update(java.lang.String interfaceId, com.vmware.nsx.model.NodeNetworkInterfaceProperties nodeNetworkInterfaceProperties);

    /**
     * Updates the specified interface properties. You cannot change the properties
     * <code>ip_configuration</code>, <code>ip_addresses</code>, or <code>plane</code>.
     * NSX Manager must have a static IP address. You must use NSX CLI to configure a
     * controller or an edge node.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param interfaceId ID of interface to update (required)
     * @param nodeNetworkInterfaceProperties (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.NodeNetworkInterfaceProperties
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.NodeNetworkInterfaceProperties update(java.lang.String interfaceId, com.vmware.nsx.model.NodeNetworkInterfaceProperties nodeNetworkInterfaceProperties, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Updates the specified interface properties. You cannot change the properties
     * <code>ip_configuration</code>, <code>ip_addresses</code>, or <code>plane</code>.
     * NSX Manager must have a static IP address. You must use NSX CLI to configure a
     * controller or an edge node.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param interfaceId ID of interface to update (required)
     * @param nodeNetworkInterfaceProperties (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String interfaceId, com.vmware.nsx.model.NodeNetworkInterfaceProperties nodeNetworkInterfaceProperties, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeNetworkInterfaceProperties> asyncCallback);

    /**
     * Updates the specified interface properties. You cannot change the properties
     * <code>ip_configuration</code>, <code>ip_addresses</code>, or <code>plane</code>.
     * NSX Manager must have a static IP address. You must use NSX CLI to configure a
     * controller or an edge node.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param interfaceId ID of interface to update (required)
     * @param nodeNetworkInterfaceProperties (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String interfaceId, com.vmware.nsx.model.NodeNetworkInterfaceProperties nodeNetworkInterfaceProperties, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeNetworkInterfaceProperties> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
