/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.ns_groups.
 * Used by client-side stubs.
 */

package com.vmware.nsx.ns_groups;

public interface ConsolidatedEffectiveIpAddressMembers extends com.vmware.vapi.bindings.Service, com.vmware.nsx.ns_groups.ConsolidatedEffectiveIpAddressMembersTypes {

    /**
     * Returns consolidated effective ip address members of the specified NSGroup.
     * Applicable in case of federated environment. The response contains site-wise
     * list of consolidated effective IP address members. In the response, for the
     * local-site, the list will contain static and dynamicaly translated IPs. For the
     * remote sites, the list will contain only the dynamically translated IPs. The
     * static IPs will not be seen in the response of this API. Hence, user can refer
     * to the local-site Ip response in the API results or the group definition to see
     * the static IP membership of the Group. This API is applicable only for NSGroups
     * containing either VirtualMachine, VIF, LogicalSwitch, LogicalPort or IPSet
     * member type. For NSGroups containing other member types,it returns an empty
     * list. Use the cursor value in the response to fetch the next page. If there is
     * no cursor value for a response, it implies the last page in the results for the
     * query.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param nsGroupId NSGroup Id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param ipFilter IP address, range, or subnet (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param siteId UUID of the site from which the effective IP addresses are to be fetched
     * (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx.model.ConsolidatedEffectiveIPAddressMemberListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.ConsolidatedEffectiveIPAddressMemberListResult list(java.lang.String nsGroupId, java.lang.String cursor, java.lang.String includedFields, java.lang.String ipFilter, java.lang.Long pageSize, java.lang.String siteId, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * Returns consolidated effective ip address members of the specified NSGroup.
     * Applicable in case of federated environment. The response contains site-wise
     * list of consolidated effective IP address members. In the response, for the
     * local-site, the list will contain static and dynamicaly translated IPs. For the
     * remote sites, the list will contain only the dynamically translated IPs. The
     * static IPs will not be seen in the response of this API. Hence, user can refer
     * to the local-site Ip response in the API results or the group definition to see
     * the static IP membership of the Group. This API is applicable only for NSGroups
     * containing either VirtualMachine, VIF, LogicalSwitch, LogicalPort or IPSet
     * member type. For NSGroups containing other member types,it returns an empty
     * list. Use the cursor value in the response to fetch the next page. If there is
     * no cursor value for a response, it implies the last page in the results for the
     * query.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param nsGroupId NSGroup Id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param ipFilter IP address, range, or subnet (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param siteId UUID of the site from which the effective IP addresses are to be fetched
     * (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.ConsolidatedEffectiveIPAddressMemberListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.ConsolidatedEffectiveIPAddressMemberListResult list(java.lang.String nsGroupId, java.lang.String cursor, java.lang.String includedFields, java.lang.String ipFilter, java.lang.Long pageSize, java.lang.String siteId, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns consolidated effective ip address members of the specified NSGroup.
     * Applicable in case of federated environment. The response contains site-wise
     * list of consolidated effective IP address members. In the response, for the
     * local-site, the list will contain static and dynamicaly translated IPs. For the
     * remote sites, the list will contain only the dynamically translated IPs. The
     * static IPs will not be seen in the response of this API. Hence, user can refer
     * to the local-site Ip response in the API results or the group definition to see
     * the static IP membership of the Group. This API is applicable only for NSGroups
     * containing either VirtualMachine, VIF, LogicalSwitch, LogicalPort or IPSet
     * member type. For NSGroups containing other member types,it returns an empty
     * list. Use the cursor value in the response to fetch the next page. If there is
     * no cursor value for a response, it implies the last page in the results for the
     * query.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ConsolidatedEffectiveIPAddressMemberListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param nsGroupId NSGroup Id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param ipFilter IP address, range, or subnet (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param siteId UUID of the site from which the effective IP addresses are to be fetched
     * (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String nsGroupId, java.lang.String cursor, java.lang.String includedFields, java.lang.String ipFilter, java.lang.Long pageSize, java.lang.String siteId, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ConsolidatedEffectiveIPAddressMemberListResult> asyncCallback);

    /**
     * Returns consolidated effective ip address members of the specified NSGroup.
     * Applicable in case of federated environment. The response contains site-wise
     * list of consolidated effective IP address members. In the response, for the
     * local-site, the list will contain static and dynamicaly translated IPs. For the
     * remote sites, the list will contain only the dynamically translated IPs. The
     * static IPs will not be seen in the response of this API. Hence, user can refer
     * to the local-site Ip response in the API results or the group definition to see
     * the static IP membership of the Group. This API is applicable only for NSGroups
     * containing either VirtualMachine, VIF, LogicalSwitch, LogicalPort or IPSet
     * member type. For NSGroups containing other member types,it returns an empty
     * list. Use the cursor value in the response to fetch the next page. If there is
     * no cursor value for a response, it implies the last page in the results for the
     * query.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ConsolidatedEffectiveIPAddressMemberListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param nsGroupId NSGroup Id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param ipFilter IP address, range, or subnet (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param siteId UUID of the site from which the effective IP addresses are to be fetched
     * (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String nsGroupId, java.lang.String cursor, java.lang.String includedFields, java.lang.String ipFilter, java.lang.Long pageSize, java.lang.String siteId, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ConsolidatedEffectiveIPAddressMemberListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
