/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.serviceinsertion.services.
 * Used by client-side stubs.
 */

package com.vmware.nsx.serviceinsertion.services;

public interface ServiceDeployments extends com.vmware.vapi.bindings.Service, com.vmware.nsx.serviceinsertion.services.ServiceDeploymentsTypes {

    /**
     * This will deploy a particular service on a given cluster / host. Internally
     * multiple service instance can be created during the deployment. If there are no
     * issues in the parameters, the call returns immediately, and the service VMs will
     * be deployed asynchronously. To get the overall status of the deployment or to
     * get the status of individual service vm, please use the deployment status APIs.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param serviceId (required)
     * @param serviceDeployment (required)
     * @return com.vmware.nsx.model.ServiceDeployment
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.ServiceDeployment create(java.lang.String serviceId, com.vmware.nsx.model.ServiceDeployment serviceDeployment);

    /**
     * This will deploy a particular service on a given cluster / host. Internally
     * multiple service instance can be created during the deployment. If there are no
     * issues in the parameters, the call returns immediately, and the service VMs will
     * be deployed asynchronously. To get the overall status of the deployment or to
     * get the status of individual service vm, please use the deployment status APIs.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param serviceId (required)
     * @param serviceDeployment (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.ServiceDeployment
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.ServiceDeployment create(java.lang.String serviceId, com.vmware.nsx.model.ServiceDeployment serviceDeployment, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * This will deploy a particular service on a given cluster / host. Internally
     * multiple service instance can be created during the deployment. If there are no
     * issues in the parameters, the call returns immediately, and the service VMs will
     * be deployed asynchronously. To get the overall status of the deployment or to
     * get the status of individual service vm, please use the deployment status APIs.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceDeployment
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param serviceDeployment (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void create(java.lang.String serviceId, com.vmware.nsx.model.ServiceDeployment serviceDeployment, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceDeployment> asyncCallback);

    /**
     * This will deploy a particular service on a given cluster / host. Internally
     * multiple service instance can be created during the deployment. If there are no
     * issues in the parameters, the call returns immediately, and the service VMs will
     * be deployed asynchronously. To get the overall status of the deployment or to
     * get the status of individual service vm, please use the deployment status APIs.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceDeployment
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param serviceDeployment (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void create(java.lang.String serviceId, com.vmware.nsx.model.ServiceDeployment serviceDeployment, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceDeployment> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Remove the service deployment. Will remove all the Service VMs that were created
     * as part of this deployment. User can send optional force delete option which
     * will force remove the deployment, but should be used only when the regular
     * delete is not working. Regular delete will ensure proper cleanup of Service VMs
     * and related objects. Directly calling this API without trying regular undeploy
     * will result in unexpected results, and orphan objects.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param serviceId (required)
     * @param serviceDeploymentId (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String serviceId, java.lang.String serviceDeploymentId, java.lang.Boolean force);

    /**
     * Remove the service deployment. Will remove all the Service VMs that were created
     * as part of this deployment. User can send optional force delete option which
     * will force remove the deployment, but should be used only when the regular
     * delete is not working. Regular delete will ensure proper cleanup of Service VMs
     * and related objects. Directly calling this API without trying regular undeploy
     * will result in unexpected results, and orphan objects.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param serviceId (required)
     * @param serviceDeploymentId (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String serviceId, java.lang.String serviceDeploymentId, java.lang.Boolean force, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Remove the service deployment. Will remove all the Service VMs that were created
     * as part of this deployment. User can send optional force delete option which
     * will force remove the deployment, but should be used only when the regular
     * delete is not working. Regular delete will ensure proper cleanup of Service VMs
     * and related objects. Directly calling this API without trying regular undeploy
     * will result in unexpected results, and orphan objects.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param serviceDeploymentId (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String serviceId, java.lang.String serviceDeploymentId, java.lang.Boolean force, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Remove the service deployment. Will remove all the Service VMs that were created
     * as part of this deployment. User can send optional force delete option which
     * will force remove the deployment, but should be used only when the regular
     * delete is not working. Regular delete will ensure proper cleanup of Service VMs
     * and related objects. Directly calling this API without trying regular undeploy
     * will result in unexpected results, and orphan objects.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param serviceDeploymentId (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String serviceId, java.lang.String serviceDeploymentId, java.lang.Boolean force, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns detail of service deployment.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param serviceId (required)
     * @param serviceDeploymentId (required)
     * @return com.vmware.nsx.model.ServiceDeployment
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.ServiceDeployment get(java.lang.String serviceId, java.lang.String serviceDeploymentId);

    /**
     * Returns detail of service deployment.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param serviceId (required)
     * @param serviceDeploymentId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.ServiceDeployment
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.ServiceDeployment get(java.lang.String serviceId, java.lang.String serviceDeploymentId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns detail of service deployment.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceDeployment
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param serviceDeploymentId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String serviceId, java.lang.String serviceDeploymentId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceDeployment> asyncCallback);

    /**
     * Returns detail of service deployment.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceDeployment
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param serviceDeploymentId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String serviceId, java.lang.String serviceDeploymentId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceDeployment> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns the list of deployments for the given service
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param serviceId (required)
     * @return com.vmware.nsx.model.ServiceDeploymentListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.ServiceDeploymentListResult list(java.lang.String serviceId);

    /**
     * Returns the list of deployments for the given service
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param serviceId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.ServiceDeploymentListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.ServiceDeploymentListResult list(java.lang.String serviceId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns the list of deployments for the given service
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceDeploymentListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String serviceId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceDeploymentListResult> asyncCallback);

    /**
     * Returns the list of deployments for the given service
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceDeploymentListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String serviceId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceDeploymentListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Update an existing Service Deployment. <br/> This API is deprecated since only
     * property we can change on service deployment is display name, which is used for
     * the SVM name. Changing the name will cause the name of the deployment to go out
     * of sync with the deployed VM.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param serviceId (required)
     * @param serviceDeploymentId (required)
     * @param serviceDeployment (required)
     * @return com.vmware.nsx.model.ServiceDeployment
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.ServiceDeployment update(java.lang.String serviceId, java.lang.String serviceDeploymentId, com.vmware.nsx.model.ServiceDeployment serviceDeployment);

    /**
     * Update an existing Service Deployment. <br/> This API is deprecated since only
     * property we can change on service deployment is display name, which is used for
     * the SVM name. Changing the name will cause the name of the deployment to go out
     * of sync with the deployed VM.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param serviceId (required)
     * @param serviceDeploymentId (required)
     * @param serviceDeployment (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.ServiceDeployment
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.ServiceDeployment update(java.lang.String serviceId, java.lang.String serviceDeploymentId, com.vmware.nsx.model.ServiceDeployment serviceDeployment, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Update an existing Service Deployment. <br/> This API is deprecated since only
     * property we can change on service deployment is display name, which is used for
     * the SVM name. Changing the name will cause the name of the deployment to go out
     * of sync with the deployed VM.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceDeployment
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param serviceDeploymentId (required)
     * @param serviceDeployment (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void update(java.lang.String serviceId, java.lang.String serviceDeploymentId, com.vmware.nsx.model.ServiceDeployment serviceDeployment, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceDeployment> asyncCallback);

    /**
     * Update an existing Service Deployment. <br/> This API is deprecated since only
     * property we can change on service deployment is display name, which is used for
     * the SVM name. Changing the name will cause the name of the deployment to go out
     * of sync with the deployed VM.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceDeployment
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param serviceDeploymentId (required)
     * @param serviceDeployment (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void update(java.lang.String serviceId, java.lang.String serviceDeploymentId, com.vmware.nsx.model.ServiceDeployment serviceDeployment, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceDeployment> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * If new deployment spec is provided, the deployment will be moved to the provided
     * spec provided that current deployment state is either UPGRADE_FAILED or
     * DEPLOYMENT_SUCCESSFUL If same deployment spec is provided, upgrade will be done
     * only if current deployment state is UPGRADE_FAILED If the exisiting data store
     * is upgraded or changed, there is an optional parameter to supply the new storage
     * Id during upgrade which would perform the deployment upgrade on the new data
     * store
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param serviceId (required)
     * @param serviceDeploymentId (required)
     * @param deploymentSpecName (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void upgrade(java.lang.String serviceId, java.lang.String serviceDeploymentId, com.vmware.nsx.model.DeploymentSpecName deploymentSpecName);

    /**
     * If new deployment spec is provided, the deployment will be moved to the provided
     * spec provided that current deployment state is either UPGRADE_FAILED or
     * DEPLOYMENT_SUCCESSFUL If same deployment spec is provided, upgrade will be done
     * only if current deployment state is UPGRADE_FAILED If the exisiting data store
     * is upgraded or changed, there is an optional parameter to supply the new storage
     * Id during upgrade which would perform the deployment upgrade on the new data
     * store
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param serviceId (required)
     * @param serviceDeploymentId (required)
     * @param deploymentSpecName (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void upgrade(java.lang.String serviceId, java.lang.String serviceDeploymentId, com.vmware.nsx.model.DeploymentSpecName deploymentSpecName, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * If new deployment spec is provided, the deployment will be moved to the provided
     * spec provided that current deployment state is either UPGRADE_FAILED or
     * DEPLOYMENT_SUCCESSFUL If same deployment spec is provided, upgrade will be done
     * only if current deployment state is UPGRADE_FAILED If the exisiting data store
     * is upgraded or changed, there is an optional parameter to supply the new storage
     * Id during upgrade which would perform the deployment upgrade on the new data
     * store
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param serviceDeploymentId (required)
     * @param deploymentSpecName (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void upgrade(java.lang.String serviceId, java.lang.String serviceDeploymentId, com.vmware.nsx.model.DeploymentSpecName deploymentSpecName, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * If new deployment spec is provided, the deployment will be moved to the provided
     * spec provided that current deployment state is either UPGRADE_FAILED or
     * DEPLOYMENT_SUCCESSFUL If same deployment spec is provided, upgrade will be done
     * only if current deployment state is UPGRADE_FAILED If the exisiting data store
     * is upgraded or changed, there is an optional parameter to supply the new storage
     * Id during upgrade which would perform the deployment upgrade on the new data
     * store
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param serviceDeploymentId (required)
     * @param deploymentSpecName (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void upgrade(java.lang.String serviceId, java.lang.String serviceDeploymentId, com.vmware.nsx.model.DeploymentSpecName deploymentSpecName, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
