/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.serviceinsertion.services.service_instances.
 * Used by client-side stubs.
 */

package com.vmware.nsx.serviceinsertion.services.service_instances;

public interface InstanceEndpoints extends com.vmware.vapi.bindings.Service, com.vmware.nsx.serviceinsertion.services.service_instances.InstanceEndpointsTypes {

    /**
     * Adds a new instance endpoint. It belongs to one service instance and is attached
     * to one service attachment. It represents a redirection target for a Rule. <br/>
     * This API has been deprecated, please use below Policy API <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/byod-service-instances/<service-instance-id>/service-instance-endpoints/<service-instance-endpoint-id>
     * PATCH
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/byod-service-instances/<service-instance-id>/service-instance-endpoints/<service-instance-endpoint-id>
     * PUT
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/byod-service-instances/<service-instance-id>/service-instance-endpoints/<service-instance-endpoint-id>
     * PATCH
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/byod-service-instances/<service-instance-id>/service-instance-endpoints/<service-instance-endpoint-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @param instanceEndpoint (required)
     * @return com.vmware.nsx.model.InstanceEndpoint
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.InstanceEndpoint create(java.lang.String serviceId, java.lang.String serviceInstanceId, com.vmware.nsx.model.InstanceEndpoint instanceEndpoint);

    /**
     * Adds a new instance endpoint. It belongs to one service instance and is attached
     * to one service attachment. It represents a redirection target for a Rule. <br/>
     * This API has been deprecated, please use below Policy API <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/byod-service-instances/<service-instance-id>/service-instance-endpoints/<service-instance-endpoint-id>
     * PATCH
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/byod-service-instances/<service-instance-id>/service-instance-endpoints/<service-instance-endpoint-id>
     * PUT
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/byod-service-instances/<service-instance-id>/service-instance-endpoints/<service-instance-endpoint-id>
     * PATCH
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/byod-service-instances/<service-instance-id>/service-instance-endpoints/<service-instance-endpoint-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @param instanceEndpoint (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.InstanceEndpoint
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.InstanceEndpoint create(java.lang.String serviceId, java.lang.String serviceInstanceId, com.vmware.nsx.model.InstanceEndpoint instanceEndpoint, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Adds a new instance endpoint. It belongs to one service instance and is attached
     * to one service attachment. It represents a redirection target for a Rule. <br/>
     * This API has been deprecated, please use below Policy API <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/byod-service-instances/<service-instance-id>/service-instance-endpoints/<service-instance-endpoint-id>
     * PATCH
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/byod-service-instances/<service-instance-id>/service-instance-endpoints/<service-instance-endpoint-id>
     * PUT
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/byod-service-instances/<service-instance-id>/service-instance-endpoints/<service-instance-endpoint-id>
     * PATCH
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/byod-service-instances/<service-instance-id>/service-instance-endpoints/<service-instance-endpoint-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.InstanceEndpoint
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @param instanceEndpoint (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void create(java.lang.String serviceId, java.lang.String serviceInstanceId, com.vmware.nsx.model.InstanceEndpoint instanceEndpoint, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.InstanceEndpoint> asyncCallback);

    /**
     * Adds a new instance endpoint. It belongs to one service instance and is attached
     * to one service attachment. It represents a redirection target for a Rule. <br/>
     * This API has been deprecated, please use below Policy API <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/byod-service-instances/<service-instance-id>/service-instance-endpoints/<service-instance-endpoint-id>
     * PATCH
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/byod-service-instances/<service-instance-id>/service-instance-endpoints/<service-instance-endpoint-id>
     * PUT
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/byod-service-instances/<service-instance-id>/service-instance-endpoints/<service-instance-endpoint-id>
     * PATCH
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/byod-service-instances/<service-instance-id>/service-instance-endpoints/<service-instance-endpoint-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.InstanceEndpoint
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @param instanceEndpoint (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void create(java.lang.String serviceId, java.lang.String serviceInstanceId, com.vmware.nsx.model.InstanceEndpoint instanceEndpoint, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.InstanceEndpoint> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Delete instance endpoint information for a given instace endpoint. Please make
     * sure to delete all the Service Insertion Rules, which refer to this Endpoint as
     * 'redirect_tos' target. <br/> This API has been deprecated, please use below
     * Policy API <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/byod-service-instances/<service-instance-id>/service-instance-endpoints/<service-instance-endpoint-id>
     * DELETE
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/byod-service-instances/<service-instance-id>/service-instance-endpoints/<service-instance-endpoint-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @param instanceEndpointId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void delete(java.lang.String serviceId, java.lang.String serviceInstanceId, java.lang.String instanceEndpointId);

    /**
     * Delete instance endpoint information for a given instace endpoint. Please make
     * sure to delete all the Service Insertion Rules, which refer to this Endpoint as
     * 'redirect_tos' target. <br/> This API has been deprecated, please use below
     * Policy API <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/byod-service-instances/<service-instance-id>/service-instance-endpoints/<service-instance-endpoint-id>
     * DELETE
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/byod-service-instances/<service-instance-id>/service-instance-endpoints/<service-instance-endpoint-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @param instanceEndpointId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void delete(java.lang.String serviceId, java.lang.String serviceInstanceId, java.lang.String instanceEndpointId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Delete instance endpoint information for a given instace endpoint. Please make
     * sure to delete all the Service Insertion Rules, which refer to this Endpoint as
     * 'redirect_tos' target. <br/> This API has been deprecated, please use below
     * Policy API <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/byod-service-instances/<service-instance-id>/service-instance-endpoints/<service-instance-endpoint-id>
     * DELETE
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/byod-service-instances/<service-instance-id>/service-instance-endpoints/<service-instance-endpoint-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @param instanceEndpointId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void delete(java.lang.String serviceId, java.lang.String serviceInstanceId, java.lang.String instanceEndpointId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Delete instance endpoint information for a given instace endpoint. Please make
     * sure to delete all the Service Insertion Rules, which refer to this Endpoint as
     * 'redirect_tos' target. <br/> This API has been deprecated, please use below
     * Policy API <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/byod-service-instances/<service-instance-id>/service-instance-endpoints/<service-instance-endpoint-id>
     * DELETE
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/byod-service-instances/<service-instance-id>/service-instance-endpoints/<service-instance-endpoint-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @param instanceEndpointId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void delete(java.lang.String serviceId, java.lang.String serviceInstanceId, java.lang.String instanceEndpointId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns detailed Endpoint information for a given InstanceEndpoint. <br/> This
     * API has been deprecated, for North-South service insertion please use below
     * Policy API <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/byod-service-instances/<service-instance-id>/service-instance-endpoints/<service-instance-endpoint-id>
     * GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/byod-service-instances/<service-instance-id>/service-instance-endpoints/<service-instance-endpoint-id&ggit;
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @param instanceEndpointId (required)
     * @return com.vmware.nsx.model.InstanceEndpoint
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.InstanceEndpoint get(java.lang.String serviceId, java.lang.String serviceInstanceId, java.lang.String instanceEndpointId);

    /**
     * Returns detailed Endpoint information for a given InstanceEndpoint. <br/> This
     * API has been deprecated, for North-South service insertion please use below
     * Policy API <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/byod-service-instances/<service-instance-id>/service-instance-endpoints/<service-instance-endpoint-id>
     * GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/byod-service-instances/<service-instance-id>/service-instance-endpoints/<service-instance-endpoint-id&ggit;
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @param instanceEndpointId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.InstanceEndpoint
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.InstanceEndpoint get(java.lang.String serviceId, java.lang.String serviceInstanceId, java.lang.String instanceEndpointId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns detailed Endpoint information for a given InstanceEndpoint. <br/> This
     * API has been deprecated, for North-South service insertion please use below
     * Policy API <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/byod-service-instances/<service-instance-id>/service-instance-endpoints/<service-instance-endpoint-id>
     * GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/byod-service-instances/<service-instance-id>/service-instance-endpoints/<service-instance-endpoint-id&ggit;
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.InstanceEndpoint
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @param instanceEndpointId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String serviceId, java.lang.String serviceInstanceId, java.lang.String instanceEndpointId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.InstanceEndpoint> asyncCallback);

    /**
     * Returns detailed Endpoint information for a given InstanceEndpoint. <br/> This
     * API has been deprecated, for North-South service insertion please use below
     * Policy API <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/byod-service-instances/<service-instance-id>/service-instance-endpoints/<service-instance-endpoint-id>
     * GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/byod-service-instances/<service-instance-id>/service-instance-endpoints/<service-instance-endpoint-id&ggit;
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.InstanceEndpoint
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @param instanceEndpointId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String serviceId, java.lang.String serviceInstanceId, java.lang.String instanceEndpointId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.InstanceEndpoint> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * List all InstanceEndpoints of a service instance.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @return com.vmware.nsx.model.InstanceEndpointListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.InstanceEndpointListResult list(java.lang.String serviceId, java.lang.String serviceInstanceId);

    /**
     * List all InstanceEndpoints of a service instance.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.InstanceEndpointListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.InstanceEndpointListResult list(java.lang.String serviceId, java.lang.String serviceInstanceId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * List all InstanceEndpoints of a service instance.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.InstanceEndpointListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String serviceId, java.lang.String serviceInstanceId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.InstanceEndpointListResult> asyncCallback);

    /**
     * List all InstanceEndpoints of a service instance.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.InstanceEndpointListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String serviceId, java.lang.String serviceInstanceId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.InstanceEndpointListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
