/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.transport_nodes.
 * Used by client-side stubs.
 */

package com.vmware.nsx.transport_nodes;

public interface State extends com.vmware.vapi.bindings.Service, com.vmware.nsx.transport_nodes.StateTypes {

    /**
     * Returns information about the current state of the transport node configuration
     * and information about the associated hostswitch. This api is now deprecated.
     * Please use new api -
     * /infra/sites/<site-id>/enforcement-points/<enforcementpoint-id>/host-transport-nodes/<host-transport-node-id>/state
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param transportNodeId (required)
     * @return com.vmware.nsx.model.TransportNodeState
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.TransportNodeState get(java.lang.String transportNodeId);

    /**
     * Returns information about the current state of the transport node configuration
     * and information about the associated hostswitch. This api is now deprecated.
     * Please use new api -
     * /infra/sites/<site-id>/enforcement-points/<enforcementpoint-id>/host-transport-nodes/<host-transport-node-id>/state
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param transportNodeId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.TransportNodeState
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.TransportNodeState get(java.lang.String transportNodeId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about the current state of the transport node configuration
     * and information about the associated hostswitch. This api is now deprecated.
     * Please use new api -
     * /infra/sites/<site-id>/enforcement-points/<enforcementpoint-id>/host-transport-nodes/<host-transport-node-id>/state
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportNodeState
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param transportNodeId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String transportNodeId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportNodeState> asyncCallback);

    /**
     * Returns information about the current state of the transport node configuration
     * and information about the associated hostswitch. This api is now deprecated.
     * Please use new api -
     * /infra/sites/<site-id>/enforcement-points/<enforcementpoint-id>/host-transport-nodes/<host-transport-node-id>/state
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportNodeState
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param transportNodeId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String transportNodeId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportNodeState> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns a list of transport node states that have realized state as provided as
     * query parameter. This api will be deprecated in future. For Host, please use new
     * api - /infra/sites/<site-id>/enforcement-points/<enforcementpoint-
     * id>/host-transport-nodes/state
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param mmState maintenance mode state (optional)
     * @param status Realized state of transport nodes (optional)
     * @param vtepIp Virtual tunnel endpoint ip address of transport node (optional)
     * @return com.vmware.nsx.model.TransportNodeStateListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.TransportNodeStateListResult list(java.lang.String mmState, java.lang.String status, java.lang.String vtepIp);

    /**
     * Returns a list of transport node states that have realized state as provided as
     * query parameter. This api will be deprecated in future. For Host, please use new
     * api - /infra/sites/<site-id>/enforcement-points/<enforcementpoint-
     * id>/host-transport-nodes/state
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param mmState maintenance mode state (optional)
     * @param status Realized state of transport nodes (optional)
     * @param vtepIp Virtual tunnel endpoint ip address of transport node (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.TransportNodeStateListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.TransportNodeStateListResult list(java.lang.String mmState, java.lang.String status, java.lang.String vtepIp, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns a list of transport node states that have realized state as provided as
     * query parameter. This api will be deprecated in future. For Host, please use new
     * api - /infra/sites/<site-id>/enforcement-points/<enforcementpoint-
     * id>/host-transport-nodes/state
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportNodeStateListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param mmState maintenance mode state (optional)
     * @param status Realized state of transport nodes (optional)
     * @param vtepIp Virtual tunnel endpoint ip address of transport node (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String mmState, java.lang.String status, java.lang.String vtepIp, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportNodeStateListResult> asyncCallback);

    /**
     * Returns a list of transport node states that have realized state as provided as
     * query parameter. This api will be deprecated in future. For Host, please use new
     * api - /infra/sites/<site-id>/enforcement-points/<enforcementpoint-
     * id>/host-transport-nodes/state
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportNodeStateListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param mmState maintenance mode state (optional)
     * @param status Realized state of transport nodes (optional)
     * @param vtepIp Virtual tunnel endpoint ip address of transport node (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String mmState, java.lang.String status, java.lang.String vtepIp, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportNodeStateListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
