/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.transport_nodes.
 * Used by client-side stubs.
 */

package com.vmware.nsx.transport_nodes;

public interface Status extends com.vmware.vapi.bindings.Service, com.vmware.nsx.transport_nodes.StatusTypes {

    /**
     * Get high-level summary of all transport nodes. The service layer does not
     * support source = realtime or cached.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param nodeType Transport node type (optional)
     * @return com.vmware.nsx.model.HeatMapTransportZoneStatus
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.HeatMapTransportZoneStatus get(java.lang.String nodeType);

    /**
     * Get high-level summary of all transport nodes. The service layer does not
     * support source = realtime or cached.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param nodeType Transport node type (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.HeatMapTransportZoneStatus
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.HeatMapTransportZoneStatus get(java.lang.String nodeType, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get high-level summary of all transport nodes. The service layer does not
     * support source = realtime or cached.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.HeatMapTransportZoneStatus
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param nodeType Transport node type (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String nodeType, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.HeatMapTransportZoneStatus> asyncCallback);

    /**
     * Get high-level summary of all transport nodes. The service layer does not
     * support source = realtime or cached.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.HeatMapTransportZoneStatus
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param nodeType Transport node type (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String nodeType, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.HeatMapTransportZoneStatus> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Read status of a transport node
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param nodeId ID of transport node (required)
     * @param source Data source type. (optional)
     * @return com.vmware.nsx.model.TransportNodeStatus
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.TransportNodeStatus get0(java.lang.String nodeId, java.lang.String source);

    /**
     * Read status of a transport node
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param nodeId ID of transport node (required)
     * @param source Data source type. (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.TransportNodeStatus
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.TransportNodeStatus get0(java.lang.String nodeId, java.lang.String source, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Read status of a transport node
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportNodeStatus
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param nodeId ID of transport node (required)
     * @param source Data source type. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get0(java.lang.String nodeId, java.lang.String source, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportNodeStatus> asyncCallback);

    /**
     * Read status of a transport node
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportNodeStatus
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param nodeId ID of transport node (required)
     * @param source Data source type. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get0(java.lang.String nodeId, java.lang.String source, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportNodeStatus> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
