/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.transport_nodes.network.
 * Used by client-side stubs.
 */

package com.vmware.nsx.transport_nodes.network;

public interface Interfaces extends com.vmware.vapi.bindings.Service, com.vmware.nsx.transport_nodes.network.InterfacesTypes {

    /**
     * Returns detailed information about the specified interface. Interface
     * information includes MTU, broadcast and host IP addresses, link and admin
     * status, MAC address, network mask, and the IP configuration method (static or
     * DHCP).
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param transportNodeId (required)
     * @param interfaceId (required)
     * @param source Data source type. (optional)
     * @return com.vmware.nsx.model.NodeInterfaceProperties
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.NodeInterfaceProperties get(java.lang.String transportNodeId, java.lang.String interfaceId, java.lang.String source);

    /**
     * Returns detailed information about the specified interface. Interface
     * information includes MTU, broadcast and host IP addresses, link and admin
     * status, MAC address, network mask, and the IP configuration method (static or
     * DHCP).
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param transportNodeId (required)
     * @param interfaceId (required)
     * @param source Data source type. (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.NodeInterfaceProperties
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.NodeInterfaceProperties get(java.lang.String transportNodeId, java.lang.String interfaceId, java.lang.String source, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns detailed information about the specified interface. Interface
     * information includes MTU, broadcast and host IP addresses, link and admin
     * status, MAC address, network mask, and the IP configuration method (static or
     * DHCP).
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeInterfaceProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param transportNodeId (required)
     * @param interfaceId (required)
     * @param source Data source type. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String transportNodeId, java.lang.String interfaceId, java.lang.String source, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeInterfaceProperties> asyncCallback);

    /**
     * Returns detailed information about the specified interface. Interface
     * information includes MTU, broadcast and host IP addresses, link and admin
     * status, MAC address, network mask, and the IP configuration method (static or
     * DHCP).
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeInterfaceProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param transportNodeId (required)
     * @param interfaceId (required)
     * @param source Data source type. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String transportNodeId, java.lang.String interfaceId, java.lang.String source, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeInterfaceProperties> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns the number of interfaces on the node and detailed information about each
     * interface. Interface information includes MTU, broadcast and host IP addresses,
     * link and admin status, MAC address, network mask, and the IP configuration
     * method (static or DHCP).
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param transportNodeId (required)
     * @param adminStatus Admin status of the interface (optional)
     * @param source Data source type. (optional)
     * @return com.vmware.nsx.model.NodeInterfacePropertiesListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.NodeInterfacePropertiesListResult list(java.lang.String transportNodeId, java.lang.String adminStatus, java.lang.String source);

    /**
     * Returns the number of interfaces on the node and detailed information about each
     * interface. Interface information includes MTU, broadcast and host IP addresses,
     * link and admin status, MAC address, network mask, and the IP configuration
     * method (static or DHCP).
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param transportNodeId (required)
     * @param adminStatus Admin status of the interface (optional)
     * @param source Data source type. (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.NodeInterfacePropertiesListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.NodeInterfacePropertiesListResult list(java.lang.String transportNodeId, java.lang.String adminStatus, java.lang.String source, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns the number of interfaces on the node and detailed information about each
     * interface. Interface information includes MTU, broadcast and host IP addresses,
     * link and admin status, MAC address, network mask, and the IP configuration
     * method (static or DHCP).
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeInterfacePropertiesListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param transportNodeId (required)
     * @param adminStatus Admin status of the interface (optional)
     * @param source Data source type. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String transportNodeId, java.lang.String adminStatus, java.lang.String source, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeInterfacePropertiesListResult> asyncCallback);

    /**
     * Returns the number of interfaces on the node and detailed information about each
     * interface. Interface information includes MTU, broadcast and host IP addresses,
     * link and admin status, MAC address, network mask, and the IP configuration
     * method (static or DHCP).
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeInterfacePropertiesListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param transportNodeId (required)
     * @param adminStatus Admin status of the interface (optional)
     * @param source Data source type. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String transportNodeId, java.lang.String adminStatus, java.lang.String source, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeInterfacePropertiesListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
