/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.trust_management.
 * Used by client-side stubs.
 */

package com.vmware.nsx.trust_management;

public interface OidcUris extends com.vmware.vapi.bindings.Service, com.vmware.nsx.trust_management.OidcUrisTypes {

    /**
     * This request also fetches the issuer and jwks_uri meta-data from the OIDC
     * end-point and stores it.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param oidcEndPoint (required)
     * @return com.vmware.nsx.model.OidcEndPoint
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.OidcEndPoint create(com.vmware.nsx.model.OidcEndPoint oidcEndPoint);

    /**
     * This request also fetches the issuer and jwks_uri meta-data from the OIDC
     * end-point and stores it.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param oidcEndPoint (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.OidcEndPoint
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.OidcEndPoint create(com.vmware.nsx.model.OidcEndPoint oidcEndPoint, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * This request also fetches the issuer and jwks_uri meta-data from the OIDC
     * end-point and stores it.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.OidcEndPoint
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param oidcEndPoint (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void create(com.vmware.nsx.model.OidcEndPoint oidcEndPoint, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.OidcEndPoint> asyncCallback);

    /**
     * This request also fetches the issuer and jwks_uri meta-data from the OIDC
     * end-point and stores it.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.OidcEndPoint
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param oidcEndPoint (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void create(com.vmware.nsx.model.OidcEndPoint oidcEndPoint, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.OidcEndPoint> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * When ?refresh=true is added to the request, the meta-data is newly fetched from
     * the OIDC end-point.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param id (required)
     * @param refresh Refresh meta-data (optional, default to false)
     * @return com.vmware.nsx.model.OidcEndPoint
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.OidcEndPoint get(java.lang.String id, java.lang.Boolean refresh);

    /**
     * When ?refresh=true is added to the request, the meta-data is newly fetched from
     * the OIDC end-point.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param id (required)
     * @param refresh Refresh meta-data (optional, default to false)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.OidcEndPoint
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.OidcEndPoint get(java.lang.String id, java.lang.Boolean refresh, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * When ?refresh=true is added to the request, the meta-data is newly fetched from
     * the OIDC end-point.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.OidcEndPoint
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param id (required)
     * @param refresh Refresh meta-data (optional, default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String id, java.lang.Boolean refresh, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.OidcEndPoint> asyncCallback);

    /**
     * When ?refresh=true is added to the request, the meta-data is newly fetched from
     * the OIDC end-point.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.OidcEndPoint
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param id (required)
     * @param refresh Refresh meta-data (optional, default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String id, java.lang.Boolean refresh, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.OidcEndPoint> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Return the list of OpenID Connect end-points.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param oidcType Type of OIDC endpoint to return (optional)
     * @return com.vmware.nsx.model.OidcEndPointListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.OidcEndPointListResult list(java.lang.String oidcType);

    /**
     * Return the list of OpenID Connect end-points.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param oidcType Type of OIDC endpoint to return (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.OidcEndPointListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.OidcEndPointListResult list(java.lang.String oidcType, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Return the list of OpenID Connect end-points.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.OidcEndPointListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param oidcType Type of OIDC endpoint to return (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String oidcType, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.OidcEndPointListResult> asyncCallback);

    /**
     * Return the list of OpenID Connect end-points.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.OidcEndPointListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param oidcType Type of OIDC endpoint to return (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String oidcType, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.OidcEndPointListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Refresh an OpenID Connect end-point by re-reading data from the OIDC URI.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param id (required)
     * @return com.vmware.nsx.model.OidcEndPoint
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.OidcEndPoint refresh(java.lang.String id);

    /**
     * Refresh an OpenID Connect end-point by re-reading data from the OIDC URI.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param id (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.OidcEndPoint
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.OidcEndPoint refresh(java.lang.String id, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Refresh an OpenID Connect end-point by re-reading data from the OIDC URI.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.OidcEndPoint
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param id (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void refresh(java.lang.String id, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.OidcEndPoint> asyncCallback);

    /**
     * Refresh an OpenID Connect end-point by re-reading data from the OIDC URI.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.OidcEndPoint
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param id (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void refresh(java.lang.String id, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.OidcEndPoint> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Update the properties of an OpenID Connect end-point. The oidc_uri property may
     * not be changed. If you need to update the oidc_uri, you should delete the OIDC
     * end-point and create a new one with the correct oidc_uri. This request also
     * re-fetches the issuer, jwks_uri, and other meta-data from the OIDC end-point and
     * stores it.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param id (required)
     * @param oidcEndPoint (required)
     * @return com.vmware.nsx.model.OidcEndPoint
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.OidcEndPoint update(java.lang.String id, com.vmware.nsx.model.OidcEndPoint oidcEndPoint);

    /**
     * Update the properties of an OpenID Connect end-point. The oidc_uri property may
     * not be changed. If you need to update the oidc_uri, you should delete the OIDC
     * end-point and create a new one with the correct oidc_uri. This request also
     * re-fetches the issuer, jwks_uri, and other meta-data from the OIDC end-point and
     * stores it.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param id (required)
     * @param oidcEndPoint (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.OidcEndPoint
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.OidcEndPoint update(java.lang.String id, com.vmware.nsx.model.OidcEndPoint oidcEndPoint, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Update the properties of an OpenID Connect end-point. The oidc_uri property may
     * not be changed. If you need to update the oidc_uri, you should delete the OIDC
     * end-point and create a new one with the correct oidc_uri. This request also
     * re-fetches the issuer, jwks_uri, and other meta-data from the OIDC end-point and
     * stores it.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.OidcEndPoint
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param id (required)
     * @param oidcEndPoint (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String id, com.vmware.nsx.model.OidcEndPoint oidcEndPoint, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.OidcEndPoint> asyncCallback);

    /**
     * Update the properties of an OpenID Connect end-point. The oidc_uri property may
     * not be changed. If you need to update the oidc_uri, you should delete the OIDC
     * end-point and create a new one with the correct oidc_uri. This request also
     * re-fetches the issuer, jwks_uri, and other meta-data from the OIDC end-point and
     * stores it.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.OidcEndPoint
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param id (required)
     * @param oidcEndPoint (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String id, com.vmware.nsx.model.OidcEndPoint oidcEndPoint, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.OidcEndPoint> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Update a OpenID Connect end-point's thumbprint used to connect to the oidc_uri
     * through SSL
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param updateOidcEndPointThumbprintRequest (required)
     * @return com.vmware.nsx.model.OidcEndPoint
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.OidcEndPoint updatethumbprint(com.vmware.nsx.model.UpdateOidcEndPointThumbprintRequest updateOidcEndPointThumbprintRequest);

    /**
     * Update a OpenID Connect end-point's thumbprint used to connect to the oidc_uri
     * through SSL
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param updateOidcEndPointThumbprintRequest (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.OidcEndPoint
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.OidcEndPoint updatethumbprint(com.vmware.nsx.model.UpdateOidcEndPointThumbprintRequest updateOidcEndPointThumbprintRequest, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Update a OpenID Connect end-point's thumbprint used to connect to the oidc_uri
     * through SSL
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.OidcEndPoint
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param updateOidcEndPointThumbprintRequest (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void updatethumbprint(com.vmware.nsx.model.UpdateOidcEndPointThumbprintRequest updateOidcEndPointThumbprintRequest, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.OidcEndPoint> asyncCallback);

    /**
     * Update a OpenID Connect end-point's thumbprint used to connect to the oidc_uri
     * through SSL
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.OidcEndPoint
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param updateOidcEndPointThumbprintRequest (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void updatethumbprint(com.vmware.nsx.model.UpdateOidcEndPointThumbprintRequest updateOidcEndPointThumbprintRequest, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.OidcEndPoint> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
