/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.trust_management.oidc_uris.
 * Used by client-side stubs.
 */

package com.vmware.nsx.trust_management.oidc_uris;

public interface UserOrGroupExists extends com.vmware.vapi.bindings.Service, com.vmware.nsx.trust_management.oidc_uris.UserOrGroupExistsTypes {

    /**
     * Search the System for Cross-domain Identity Management (SCIM) source to find a
     * user or group whose name exactly matches the given name.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param id (required)
     * @param name User or group name to search for (required)
     * @return com.vmware.nsx.model.VerifyScimUserOrGroupExistsResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.VerifyScimUserOrGroupExistsResult get(java.lang.String id, java.lang.String name);

    /**
     * Search the System for Cross-domain Identity Management (SCIM) source to find a
     * user or group whose name exactly matches the given name.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param id (required)
     * @param name User or group name to search for (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.VerifyScimUserOrGroupExistsResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.VerifyScimUserOrGroupExistsResult get(java.lang.String id, java.lang.String name, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Search the System for Cross-domain Identity Management (SCIM) source to find a
     * user or group whose name exactly matches the given name.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.VerifyScimUserOrGroupExistsResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param id (required)
     * @param name User or group name to search for (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String id, java.lang.String name, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.VerifyScimUserOrGroupExistsResult> asyncCallback);

    /**
     * Search the System for Cross-domain Identity Management (SCIM) source to find a
     * user or group whose name exactly matches the given name.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.VerifyScimUserOrGroupExistsResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param id (required)
     * @param name User or group name to search for (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String id, java.lang.String name, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.VerifyScimUserOrGroupExistsResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
