/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for model: com.vmware.nsx.
 */

package com.vmware.nsx.util;

import java.util.Map;

import com.vmware.vapi.internal.util.Validate;

import com.vmware.vapi.bindings.type.StructType;

/**
 * Utility for StructType.
 */
public final class StructTypeUtil {

    /**
     * Populates mappings for structures defined in a model (set of VMODL
     * definitions).
     *
     * For each top level structure and each structure defined in a service,
     * adds an entry to the map where the key is the fully qualified canonical
     * name of the structure, and the value is a StructType. It allows to
     * retrieve the StructType from the canonical name of an structure.
     *
     * @param mapping map to fill with mappings for each structure in the bindings;
     *                must not be null.
     */
    public static void populateCanonicalNameToStructTypeMap(Map<String, StructType> mapping) {
        Validate.notNull(mapping);
        add(mapping,
            "com.vmware.nsx.model.ALG_type_NS_service",
            com.vmware.nsx.model.StructDefinitions.ALGTypeNSService);
        add(mapping,
            "com.vmware.nsx.model.acceptable_component_version",
            com.vmware.nsx.model.StructDefinitions.acceptableComponentVersion);
        add(mapping,
            "com.vmware.nsx.model.acceptable_component_version_list",
            com.vmware.nsx.model.StructDefinitions.acceptableComponentVersionList);
        add(mapping,
            "com.vmware.nsx.model.actionable_resource",
            com.vmware.nsx.model.StructDefinitions.actionableResource);
        add(mapping,
            "com.vmware.nsx.model.actionable_resource_list_result",
            com.vmware.nsx.model.StructDefinitions.actionableResourceListResult);
        add(mapping,
            "com.vmware.nsx.model.active_standby_sync_status",
            com.vmware.nsx.model.StructDefinitions.activeStandbySyncStatus);
        add(mapping,
            "com.vmware.nsx.model.add_cluster_node_spec",
            com.vmware.nsx.model.StructDefinitions.addClusterNodeSpec);
        add(mapping,
            "com.vmware.nsx.model.add_cluster_node_VM_info",
            com.vmware.nsx.model.StructDefinitions.addClusterNodeVMInfo);
        add(mapping,
            "com.vmware.nsx.model.add_controller_node_spec",
            com.vmware.nsx.model.StructDefinitions.addControllerNodeSpec);
        add(mapping,
            "com.vmware.nsx.model.add_management_node_spec",
            com.vmware.nsx.model.StructDefinitions.addManagementNodeSpec);
        add(mapping,
            "com.vmware.nsx.model.address_binding_entry",
            com.vmware.nsx.model.StructDefinitions.addressBindingEntry);
        add(mapping,
            "com.vmware.nsx.model.advance_cluster_restore_input",
            com.vmware.nsx.model.StructDefinitions.advanceClusterRestoreInput);
        add(mapping,
            "com.vmware.nsx.model.advance_cluster_restore_request",
            com.vmware.nsx.model.StructDefinitions.advanceClusterRestoreRequest);
        add(mapping,
            "com.vmware.nsx.model.advertise_rule",
            com.vmware.nsx.model.StructDefinitions.advertiseRule);
        add(mapping,
            "com.vmware.nsx.model.advertise_rule_list",
            com.vmware.nsx.model.StructDefinitions.advertiseRuleList);
        add(mapping,
            "com.vmware.nsx.model.advertisement_config",
            com.vmware.nsx.model.StructDefinitions.advertisementConfig);
        add(mapping,
            "com.vmware.nsx.model.advertisement_rule_filter",
            com.vmware.nsx.model.StructDefinitions.advertisementRuleFilter);
        add(mapping,
            "com.vmware.nsx.model.agent_status",
            com.vmware.nsx.model.StructDefinitions.agentStatus);
        add(mapping,
            "com.vmware.nsx.model.agent_status_count",
            com.vmware.nsx.model.StructDefinitions.agentStatusCount);
        add(mapping,
            "com.vmware.nsx.model.aggregated_data_counter",
            com.vmware.nsx.model.StructDefinitions.aggregatedDataCounter);
        add(mapping,
            "com.vmware.nsx.model.aggregated_data_counter_ex",
            com.vmware.nsx.model.StructDefinitions.aggregatedDataCounterEx);
        add(mapping,
            "com.vmware.nsx.model.aggregated_logical_router_port_counters",
            com.vmware.nsx.model.StructDefinitions.aggregatedLogicalRouterPortCounters);
        add(mapping,
            "com.vmware.nsx.model.alarm",
            com.vmware.nsx.model.StructDefinitions.alarm);
        add(mapping,
            "com.vmware.nsx.model.alarms_list_result",
            com.vmware.nsx.model.StructDefinitions.alarmsListResult);
        add(mapping,
            "com.vmware.nsx.model.all_cluster_group_status",
            com.vmware.nsx.model.StructDefinitions.allClusterGroupStatus);
        add(mapping,
            "com.vmware.nsx.model.allocated_service",
            com.vmware.nsx.model.StructDefinitions.allocatedService);
        add(mapping,
            "com.vmware.nsx.model.allocation_based_on_failure_domain",
            com.vmware.nsx.model.StructDefinitions.allocationBasedOnFailureDomain);
        add(mapping,
            "com.vmware.nsx.model.allocation_ip_address",
            com.vmware.nsx.model.StructDefinitions.allocationIpAddress);
        add(mapping,
            "com.vmware.nsx.model.allocation_ip_address_list_result",
            com.vmware.nsx.model.StructDefinitions.allocationIpAddressListResult);
        add(mapping,
            "com.vmware.nsx.model.allocation_pool",
            com.vmware.nsx.model.StructDefinitions.allocationPool);
        add(mapping,
            "com.vmware.nsx.model.allocation_rule",
            com.vmware.nsx.model.StructDefinitions.allocationRule);
        add(mapping,
            "com.vmware.nsx.model.allocation_rule_action",
            com.vmware.nsx.model.StructDefinitions.allocationRuleAction);
        add(mapping,
            "com.vmware.nsx.model.antrea_container_cluster_node",
            com.vmware.nsx.model.StructDefinitions.antreaContainerClusterNode);
        add(mapping,
            "com.vmware.nsx.model.antrea_support_bundle_container_node",
            com.vmware.nsx.model.StructDefinitions.antreaSupportBundleContainerNode);
        add(mapping,
            "com.vmware.nsx.model.aph_info",
            com.vmware.nsx.model.StructDefinitions.aphInfo);
        add(mapping,
            "com.vmware.nsx.model.api_error",
            com.vmware.nsx.model.StructDefinitions.apiError);
        add(mapping,
            "com.vmware.nsx.model.api_service_config",
            com.vmware.nsx.model.StructDefinitions.apiServiceConfig);
        add(mapping,
            "com.vmware.nsx.model.appliance_latency_data",
            com.vmware.nsx.model.StructDefinitions.applianceLatencyData);
        add(mapping,
            "com.vmware.nsx.model.appliance_latency_data_item",
            com.vmware.nsx.model.StructDefinitions.applianceLatencyDataItem);
        add(mapping,
            "com.vmware.nsx.model.appliance_latency_list_result",
            com.vmware.nsx.model.StructDefinitions.applianceLatencyListResult);
        add(mapping,
            "com.vmware.nsx.model.appliance_management_task_list_result",
            com.vmware.nsx.model.StructDefinitions.applianceManagementTaskListResult);
        add(mapping,
            "com.vmware.nsx.model.appliance_management_task_properties",
            com.vmware.nsx.model.StructDefinitions.applianceManagementTaskProperties);
        add(mapping,
            "com.vmware.nsx.model.appliance_process_data",
            com.vmware.nsx.model.StructDefinitions.applianceProcessData);
        add(mapping,
            "com.vmware.nsx.model.appliance_process_list_result",
            com.vmware.nsx.model.StructDefinitions.applianceProcessListResult);
        add(mapping,
            "com.vmware.nsx.model.applied_tos",
            com.vmware.nsx.model.StructDefinitions.appliedTos);
        add(mapping,
            "com.vmware.nsx.model.arp_header",
            com.vmware.nsx.model.StructDefinitions.arpHeader);
        add(mapping,
            "com.vmware.nsx.model.assigned_by_dhcp",
            com.vmware.nsx.model.StructDefinitions.assignedByDhcp);
        add(mapping,
            "com.vmware.nsx.model.association_list_result",
            com.vmware.nsx.model.StructDefinitions.associationListResult);
        add(mapping,
            "com.vmware.nsx.model.attached_interface",
            com.vmware.nsx.model.StructDefinitions.attachedInterface);
        add(mapping,
            "com.vmware.nsx.model.attachment_context",
            com.vmware.nsx.model.StructDefinitions.attachmentContext);
        add(mapping,
            "com.vmware.nsx.model.attribute",
            com.vmware.nsx.model.StructDefinitions.attribute);
        add(mapping,
            "com.vmware.nsx.model.audit_log",
            com.vmware.nsx.model.StructDefinitions.auditLog);
        add(mapping,
            "com.vmware.nsx.model.audit_log_list_result",
            com.vmware.nsx.model.StructDefinitions.auditLogListResult);
        add(mapping,
            "com.vmware.nsx.model.audit_log_request",
            com.vmware.nsx.model.StructDefinitions.auditLogRequest);
        add(mapping,
            "com.vmware.nsx.model.auth_service_properties",
            com.vmware.nsx.model.StructDefinitions.authServiceProperties);
        add(mapping,
            "com.vmware.nsx.model.authentication_policy_properties",
            com.vmware.nsx.model.StructDefinitions.authenticationPolicyProperties);
        add(mapping,
            "com.vmware.nsx.model.authentication_scheme",
            com.vmware.nsx.model.StructDefinitions.authenticationScheme);
        add(mapping,
            "com.vmware.nsx.model.automatic_health_check",
            com.vmware.nsx.model.StructDefinitions.automaticHealthCheck);
        add(mapping,
            "com.vmware.nsx.model.automatic_health_check_list_result",
            com.vmware.nsx.model.StructDefinitions.automaticHealthCheckListResult);
        add(mapping,
            "com.vmware.nsx.model.automatic_health_check_toggle",
            com.vmware.nsx.model.StructDefinitions.automaticHealthCheckToggle);
        add(mapping,
            "com.vmware.nsx.model.avi_end_point",
            com.vmware.nsx.model.StructDefinitions.aviEndPoint);
        add(mapping,
            "com.vmware.nsx.model.axes",
            com.vmware.nsx.model.StructDefinitions.axes);
        add(mapping,
            "com.vmware.nsx.model.axis_unit",
            com.vmware.nsx.model.StructDefinitions.axisUnit);
        add(mapping,
            "com.vmware.nsx.model.BFD_diagnostic_count",
            com.vmware.nsx.model.StructDefinitions.BFDDiagnosticCount);
        add(mapping,
            "com.vmware.nsx.model.BFD_properties",
            com.vmware.nsx.model.StructDefinitions.BFDProperties);
        add(mapping,
            "com.vmware.nsx.model.BFD_status_count",
            com.vmware.nsx.model.StructDefinitions.BFDStatusCount);
        add(mapping,
            "com.vmware.nsx.model.BGP_community_list",
            com.vmware.nsx.model.StructDefinitions.BGPCommunityList);
        add(mapping,
            "com.vmware.nsx.model.BGP_community_list_list_result",
            com.vmware.nsx.model.StructDefinitions.BGPCommunityListListResult);
        add(mapping,
            "com.vmware.nsx.model.backup_configuration",
            com.vmware.nsx.model.StructDefinitions.backupConfiguration);
        add(mapping,
            "com.vmware.nsx.model.backup_operation_history",
            com.vmware.nsx.model.StructDefinitions.backupOperationHistory);
        add(mapping,
            "com.vmware.nsx.model.backup_operation_status",
            com.vmware.nsx.model.StructDefinitions.backupOperationStatus);
        add(mapping,
            "com.vmware.nsx.model.backup_overview",
            com.vmware.nsx.model.StructDefinitions.backupOverview);
        add(mapping,
            "com.vmware.nsx.model.backup_schedule",
            com.vmware.nsx.model.StructDefinitions.backupSchedule);
        add(mapping,
            "com.vmware.nsx.model.backup_ui_frames_info",
            com.vmware.nsx.model.StructDefinitions.backupUiFramesInfo);
        add(mapping,
            "com.vmware.nsx.model.backup_ui_frames_info_list",
            com.vmware.nsx.model.StructDefinitions.backupUiFramesInfoList);
        add(mapping,
            "com.vmware.nsx.model.base_firewall_profile",
            com.vmware.nsx.model.StructDefinitions.baseFirewallProfile);
        add(mapping,
            "com.vmware.nsx.model.base_host_switch_profile",
            com.vmware.nsx.model.StructDefinitions.baseHostSwitchProfile);
        add(mapping,
            "com.vmware.nsx.model.base_node_aggregate_info",
            com.vmware.nsx.model.StructDefinitions.baseNodeAggregateInfo);
        add(mapping,
            "com.vmware.nsx.model.base_pkt_cap_resource",
            com.vmware.nsx.model.StructDefinitions.basePktCapResource);
        add(mapping,
            "com.vmware.nsx.model.base_service_instance",
            com.vmware.nsx.model.StructDefinitions.baseServiceInstance);
        add(mapping,
            "com.vmware.nsx.model.base_service_profile",
            com.vmware.nsx.model.StructDefinitions.baseServiceProfile);
        add(mapping,
            "com.vmware.nsx.model.base_switching_profile",
            com.vmware.nsx.model.StructDefinitions.baseSwitchingProfile);
        add(mapping,
            "com.vmware.nsx.model.basic_authentication_scheme",
            com.vmware.nsx.model.StructDefinitions.basicAuthenticationScheme);
        add(mapping,
            "com.vmware.nsx.model.batch_request",
            com.vmware.nsx.model.StructDefinitions.batchRequest);
        add(mapping,
            "com.vmware.nsx.model.batch_request_item",
            com.vmware.nsx.model.StructDefinitions.batchRequestItem);
        add(mapping,
            "com.vmware.nsx.model.batch_response",
            com.vmware.nsx.model.StructDefinitions.batchResponse);
        add(mapping,
            "com.vmware.nsx.model.batch_response_item",
            com.vmware.nsx.model.StructDefinitions.batchResponseItem);
        add(mapping,
            "com.vmware.nsx.model.bfd_config",
            com.vmware.nsx.model.StructDefinitions.bfdConfig);
        add(mapping,
            "com.vmware.nsx.model.bfd_config_parameters",
            com.vmware.nsx.model.StructDefinitions.bfdConfigParameters);
        add(mapping,
            "com.vmware.nsx.model.bfd_health_monitoring_profile",
            com.vmware.nsx.model.StructDefinitions.bfdHealthMonitoringProfile);
        add(mapping,
            "com.vmware.nsx.model.bgp_address_family",
            com.vmware.nsx.model.StructDefinitions.bgpAddressFamily);
        add(mapping,
            "com.vmware.nsx.model.bgp_config",
            com.vmware.nsx.model.StructDefinitions.bgpConfig);
        add(mapping,
            "com.vmware.nsx.model.bgp_neighbor",
            com.vmware.nsx.model.StructDefinitions.bgpNeighbor);
        add(mapping,
            "com.vmware.nsx.model.bgp_neighbor_address_family",
            com.vmware.nsx.model.StructDefinitions.bgpNeighborAddressFamily);
        add(mapping,
            "com.vmware.nsx.model.bgp_neighbor_list_result",
            com.vmware.nsx.model.StructDefinitions.bgpNeighborListResult);
        add(mapping,
            "com.vmware.nsx.model.bgp_neighbor_route_details",
            com.vmware.nsx.model.StructDefinitions.bgpNeighborRouteDetails);
        add(mapping,
            "com.vmware.nsx.model.bgp_neighbor_route_details_csv_record",
            com.vmware.nsx.model.StructDefinitions.bgpNeighborRouteDetailsCsvRecord);
        add(mapping,
            "com.vmware.nsx.model.bgp_neighbor_route_details_in_csv_format",
            com.vmware.nsx.model.StructDefinitions.bgpNeighborRouteDetailsInCsvFormat);
        add(mapping,
            "com.vmware.nsx.model.bgp_neighbor_status",
            com.vmware.nsx.model.StructDefinitions.bgpNeighborStatus);
        add(mapping,
            "com.vmware.nsx.model.bgp_neighbor_status_lite_dto",
            com.vmware.nsx.model.StructDefinitions.bgpNeighborStatusLiteDto);
        add(mapping,
            "com.vmware.nsx.model.bgp_neighbors_status_list_result",
            com.vmware.nsx.model.StructDefinitions.bgpNeighborsStatusListResult);
        add(mapping,
            "com.vmware.nsx.model.bgp_route_aggregation",
            com.vmware.nsx.model.StructDefinitions.bgpRouteAggregation);
        add(mapping,
            "com.vmware.nsx.model.binary_packet_data",
            com.vmware.nsx.model.StructDefinitions.binaryPacketData);
        add(mapping,
            "com.vmware.nsx.model.bpdu_filter",
            com.vmware.nsx.model.StructDefinitions.bpduFilter);
        add(mapping,
            "com.vmware.nsx.model.bridge_endpoint",
            com.vmware.nsx.model.StructDefinitions.bridgeEndpoint);
        add(mapping,
            "com.vmware.nsx.model.bridge_endpoint_list_result",
            com.vmware.nsx.model.StructDefinitions.bridgeEndpointListResult);
        add(mapping,
            "com.vmware.nsx.model.bridge_endpoint_profile",
            com.vmware.nsx.model.StructDefinitions.bridgeEndpointProfile);
        add(mapping,
            "com.vmware.nsx.model.bridge_endpoint_profile_list_result",
            com.vmware.nsx.model.StructDefinitions.bridgeEndpointProfileListResult);
        add(mapping,
            "com.vmware.nsx.model.bridge_endpoint_statistics",
            com.vmware.nsx.model.StructDefinitions.bridgeEndpointStatistics);
        add(mapping,
            "com.vmware.nsx.model.bridge_endpoint_status",
            com.vmware.nsx.model.StructDefinitions.bridgeEndpointStatus);
        add(mapping,
            "com.vmware.nsx.model.bridge_high_availability_cluster_profile",
            com.vmware.nsx.model.StructDefinitions.bridgeHighAvailabilityClusterProfile);
        add(mapping,
            "com.vmware.nsx.model.broker_properties",
            com.vmware.nsx.model.StructDefinitions.brokerProperties);
        add(mapping,
            "com.vmware.nsx.model.bundle_id",
            com.vmware.nsx.model.StructDefinitions.bundleId);
        add(mapping,
            "com.vmware.nsx.model.bundle_ids",
            com.vmware.nsx.model.StructDefinitions.bundleIds);
        add(mapping,
            "com.vmware.nsx.model.bundle_upload_permission",
            com.vmware.nsx.model.StructDefinitions.bundleUploadPermission);
        add(mapping,
            "com.vmware.nsx.model.bundle_upload_status",
            com.vmware.nsx.model.StructDefinitions.bundleUploadStatus);
        add(mapping,
            "com.vmware.nsx.model.byod_service_instance",
            com.vmware.nsx.model.StructDefinitions.byodServiceInstance);
        add(mapping,
            "com.vmware.nsx.model.CCP_upgrade_status",
            com.vmware.nsx.model.StructDefinitions.CCPUpgradeStatus);
        add(mapping,
            "com.vmware.nsx.model.CC_snmp_v3_user",
            com.vmware.nsx.model.StructDefinitions.CCSnmpV3User);
        add(mapping,
            "com.vmware.nsx.model.CPU_reservation",
            com.vmware.nsx.model.StructDefinitions.CPUReservation);
        add(mapping,
            "com.vmware.nsx.model.callback_authentication_scheme",
            com.vmware.nsx.model.StructDefinitions.callbackAuthenticationScheme);
        add(mapping,
            "com.vmware.nsx.model.capacity_dashboard_usage",
            com.vmware.nsx.model.StructDefinitions.capacityDashboardUsage);
        add(mapping,
            "com.vmware.nsx.model.capacity_threshold",
            com.vmware.nsx.model.StructDefinitions.capacityThreshold);
        add(mapping,
            "com.vmware.nsx.model.capacity_threshold_list",
            com.vmware.nsx.model.StructDefinitions.capacityThresholdList);
        add(mapping,
            "com.vmware.nsx.model.capacity_usage",
            com.vmware.nsx.model.StructDefinitions.capacityUsage);
        add(mapping,
            "com.vmware.nsx.model.capacity_usage_meta_info",
            com.vmware.nsx.model.StructDefinitions.capacityUsageMetaInfo);
        add(mapping,
            "com.vmware.nsx.model.capacity_usage_response",
            com.vmware.nsx.model.StructDefinitions.capacityUsageResponse);
        add(mapping,
            "com.vmware.nsx.model.central_config_properties",
            com.vmware.nsx.model.StructDefinitions.centralConfigProperties);
        add(mapping,
            "com.vmware.nsx.model.central_node_config_profile",
            com.vmware.nsx.model.StructDefinitions.centralNodeConfigProfile);
        add(mapping,
            "com.vmware.nsx.model.central_node_config_profile_list_result",
            com.vmware.nsx.model.StructDefinitions.centralNodeConfigProfileListResult);
        add(mapping,
            "com.vmware.nsx.model.certificate",
            com.vmware.nsx.model.StructDefinitions.certificate);
        add(mapping,
            "com.vmware.nsx.model.certificate_checking_status",
            com.vmware.nsx.model.StructDefinitions.certificateCheckingStatus);
        add(mapping,
            "com.vmware.nsx.model.certificate_data",
            com.vmware.nsx.model.StructDefinitions.certificateData);
        add(mapping,
            "com.vmware.nsx.model.certificate_key_pair",
            com.vmware.nsx.model.StructDefinitions.certificateKeyPair);
        add(mapping,
            "com.vmware.nsx.model.certificate_list",
            com.vmware.nsx.model.StructDefinitions.certificateList);
        add(mapping,
            "com.vmware.nsx.model.certificate_profile",
            com.vmware.nsx.model.StructDefinitions.certificateProfile);
        add(mapping,
            "com.vmware.nsx.model.certificate_profile_list_result",
            com.vmware.nsx.model.StructDefinitions.certificateProfileListResult);
        add(mapping,
            "com.vmware.nsx.model.cipher_suite",
            com.vmware.nsx.model.StructDefinitions.cipherSuite);
        add(mapping,
            "com.vmware.nsx.model.claim_map",
            com.vmware.nsx.model.StructDefinitions.claimMap);
        add(mapping,
            "com.vmware.nsx.model.claim_value_to_role_map",
            com.vmware.nsx.model.StructDefinitions.claimValueToRoleMap);
        add(mapping,
            "com.vmware.nsx.model.classless_static_route",
            com.vmware.nsx.model.StructDefinitions.classlessStaticRoute);
        add(mapping,
            "com.vmware.nsx.model.client_ssl_profile_binding",
            com.vmware.nsx.model.StructDefinitions.clientSslProfileBinding);
        add(mapping,
            "com.vmware.nsx.model.client_type_collection_configuration",
            com.vmware.nsx.model.StructDefinitions.clientTypeCollectionConfiguration);
        add(mapping,
            "com.vmware.nsx.model.cloud_native_service_instance",
            com.vmware.nsx.model.StructDefinitions.cloudNativeServiceInstance);
        add(mapping,
            "com.vmware.nsx.model.cloud_native_service_instance_list_result",
            com.vmware.nsx.model.StructDefinitions.cloudNativeServiceInstanceListResult);
        add(mapping,
            "com.vmware.nsx.model.cluster_backup_info",
            com.vmware.nsx.model.StructDefinitions.clusterBackupInfo);
        add(mapping,
            "com.vmware.nsx.model.cluster_backup_info_list_result",
            com.vmware.nsx.model.StructDefinitions.clusterBackupInfoListResult);
        add(mapping,
            "com.vmware.nsx.model.cluster_certificate_id",
            com.vmware.nsx.model.StructDefinitions.clusterCertificateId);
        add(mapping,
            "com.vmware.nsx.model.cluster_config",
            com.vmware.nsx.model.StructDefinitions.clusterConfig);
        add(mapping,
            "com.vmware.nsx.model.cluster_configuration",
            com.vmware.nsx.model.StructDefinitions.clusterConfiguration);
        add(mapping,
            "com.vmware.nsx.model.cluster_dpu_config",
            com.vmware.nsx.model.StructDefinitions.clusterDpuConfig);
        add(mapping,
            "com.vmware.nsx.model.cluster_group_member_status",
            com.vmware.nsx.model.StructDefinitions.clusterGroupMemberStatus);
        add(mapping,
            "com.vmware.nsx.model.cluster_group_service_leader",
            com.vmware.nsx.model.StructDefinitions.clusterGroupServiceLeader);
        add(mapping,
            "com.vmware.nsx.model.cluster_group_status",
            com.vmware.nsx.model.StructDefinitions.clusterGroupStatus);
        add(mapping,
            "com.vmware.nsx.model.cluster_initialization_node_info",
            com.vmware.nsx.model.StructDefinitions.clusterInitializationNodeInfo);
        add(mapping,
            "com.vmware.nsx.model.cluster_node",
            com.vmware.nsx.model.StructDefinitions.clusterNode);
        add(mapping,
            "com.vmware.nsx.model.cluster_node_config",
            com.vmware.nsx.model.StructDefinitions.clusterNodeConfig);
        add(mapping,
            "com.vmware.nsx.model.cluster_node_config_list_result",
            com.vmware.nsx.model.StructDefinitions.clusterNodeConfigListResult);
        add(mapping,
            "com.vmware.nsx.model.cluster_node_entity",
            com.vmware.nsx.model.StructDefinitions.clusterNodeEntity);
        add(mapping,
            "com.vmware.nsx.model.cluster_node_info",
            com.vmware.nsx.model.StructDefinitions.clusterNodeInfo);
        add(mapping,
            "com.vmware.nsx.model.cluster_node_status",
            com.vmware.nsx.model.StructDefinitions.clusterNodeStatus);
        add(mapping,
            "com.vmware.nsx.model.cluster_node_VM_deployment_config",
            com.vmware.nsx.model.StructDefinitions.clusterNodeVMDeploymentConfig);
        add(mapping,
            "com.vmware.nsx.model.cluster_node_VM_deployment_request",
            com.vmware.nsx.model.StructDefinitions.clusterNodeVMDeploymentRequest);
        add(mapping,
            "com.vmware.nsx.model.cluster_node_VM_deployment_request_list",
            com.vmware.nsx.model.StructDefinitions.clusterNodeVMDeploymentRequestList);
        add(mapping,
            "com.vmware.nsx.model.cluster_node_VM_deployment_status_report",
            com.vmware.nsx.model.StructDefinitions.clusterNodeVMDeploymentStatusReport);
        add(mapping,
            "com.vmware.nsx.model.cluster_profile",
            com.vmware.nsx.model.StructDefinitions.clusterProfile);
        add(mapping,
            "com.vmware.nsx.model.cluster_profile_list_result",
            com.vmware.nsx.model.StructDefinitions.clusterProfileListResult);
        add(mapping,
            "com.vmware.nsx.model.cluster_profile_type_id_entry",
            com.vmware.nsx.model.StructDefinitions.clusterProfileTypeIdEntry);
        add(mapping,
            "com.vmware.nsx.model.cluster_restore_status",
            com.vmware.nsx.model.StructDefinitions.clusterRestoreStatus);
        add(mapping,
            "com.vmware.nsx.model.cluster_role_config",
            com.vmware.nsx.model.StructDefinitions.clusterRoleConfig);
        add(mapping,
            "com.vmware.nsx.model.cluster_status",
            com.vmware.nsx.model.StructDefinitions.clusterStatus);
        add(mapping,
            "com.vmware.nsx.model.cluster_virtual_ip_properties",
            com.vmware.nsx.model.StructDefinitions.clusterVirtualIpProperties);
        add(mapping,
            "com.vmware.nsx.model.clustering_config",
            com.vmware.nsx.model.StructDefinitions.clusteringConfig);
        add(mapping,
            "com.vmware.nsx.model.clustering_info",
            com.vmware.nsx.model.StructDefinitions.clusteringInfo);
        add(mapping,
            "com.vmware.nsx.model.clusters_aggregate_info",
            com.vmware.nsx.model.StructDefinitions.clustersAggregateInfo);
        add(mapping,
            "com.vmware.nsx.model.cm_thumbprint_hashing_config",
            com.vmware.nsx.model.StructDefinitions.cmThumbprintHashingConfig);
        add(mapping,
            "com.vmware.nsx.model.column_item",
            com.vmware.nsx.model.StructDefinitions.columnItem);
        add(mapping,
            "com.vmware.nsx.model.community_match_expression",
            com.vmware.nsx.model.StructDefinitions.communityMatchExpression);
        add(mapping,
            "com.vmware.nsx.model.community_match_operation",
            com.vmware.nsx.model.StructDefinitions.communityMatchOperation);
        add(mapping,
            "com.vmware.nsx.model.component_migration_status",
            com.vmware.nsx.model.StructDefinitions.componentMigrationStatus);
        add(mapping,
            "com.vmware.nsx.model.component_target_version",
            com.vmware.nsx.model.StructDefinitions.componentTargetVersion);
        add(mapping,
            "com.vmware.nsx.model.component_upgrade_checks_info",
            com.vmware.nsx.model.StructDefinitions.componentUpgradeChecksInfo);
        add(mapping,
            "com.vmware.nsx.model.component_upgrade_checks_info_list_result",
            com.vmware.nsx.model.StructDefinitions.componentUpgradeChecksInfoListResult);
        add(mapping,
            "com.vmware.nsx.model.component_upgrade_status",
            com.vmware.nsx.model.StructDefinitions.componentUpgradeStatus);
        add(mapping,
            "com.vmware.nsx.model.compute_collection",
            com.vmware.nsx.model.StructDefinitions.computeCollection);
        add(mapping,
            "com.vmware.nsx.model.compute_collection_list_result",
            com.vmware.nsx.model.StructDefinitions.computeCollectionListResult);
        add(mapping,
            "com.vmware.nsx.model.compute_collection_network_interfaces_list_result",
            com.vmware.nsx.model.StructDefinitions.computeCollectionNetworkInterfacesListResult);
        add(mapping,
            "com.vmware.nsx.model.compute_manager",
            com.vmware.nsx.model.StructDefinitions.computeManager);
        add(mapping,
            "com.vmware.nsx.model.compute_manager_list_result",
            com.vmware.nsx.model.StructDefinitions.computeManagerListResult);
        add(mapping,
            "com.vmware.nsx.model.compute_manager_status",
            com.vmware.nsx.model.StructDefinitions.computeManagerStatus);
        add(mapping,
            "com.vmware.nsx.model.compute_manager_topology",
            com.vmware.nsx.model.StructDefinitions.computeManagerTopology);
        add(mapping,
            "com.vmware.nsx.model.conditional_forwarder_zone",
            com.vmware.nsx.model.StructDefinitions.conditionalForwarderZone);
        add(mapping,
            "com.vmware.nsx.model.configuration_state",
            com.vmware.nsx.model.StructDefinitions.configurationState);
        add(mapping,
            "com.vmware.nsx.model.configuration_state_element",
            com.vmware.nsx.model.StructDefinitions.configurationStateElement);
        add(mapping,
            "com.vmware.nsx.model.consolidated_effective_IP_address_member_list_result",
            com.vmware.nsx.model.StructDefinitions.consolidatedEffectiveIPAddressMemberListResult);
        add(mapping,
            "com.vmware.nsx.model.container_application",
            com.vmware.nsx.model.StructDefinitions.containerApplication);
        add(mapping,
            "com.vmware.nsx.model.container_application_instance",
            com.vmware.nsx.model.StructDefinitions.containerApplicationInstance);
        add(mapping,
            "com.vmware.nsx.model.container_application_instance_list_result",
            com.vmware.nsx.model.StructDefinitions.containerApplicationInstanceListResult);
        add(mapping,
            "com.vmware.nsx.model.container_application_list_result",
            com.vmware.nsx.model.StructDefinitions.containerApplicationListResult);
        add(mapping,
            "com.vmware.nsx.model.container_cluster",
            com.vmware.nsx.model.StructDefinitions.containerCluster);
        add(mapping,
            "com.vmware.nsx.model.container_cluster_list_result",
            com.vmware.nsx.model.StructDefinitions.containerClusterListResult);
        add(mapping,
            "com.vmware.nsx.model.container_cluster_node",
            com.vmware.nsx.model.StructDefinitions.containerClusterNode);
        add(mapping,
            "com.vmware.nsx.model.container_cluster_node_list_result",
            com.vmware.nsx.model.StructDefinitions.containerClusterNodeListResult);
        add(mapping,
            "com.vmware.nsx.model.container_cluster_status",
            com.vmware.nsx.model.StructDefinitions.containerClusterStatus);
        add(mapping,
            "com.vmware.nsx.model.container_cluster_status_list",
            com.vmware.nsx.model.StructDefinitions.containerClusterStatusList);
        add(mapping,
            "com.vmware.nsx.model.container_cluster_summary",
            com.vmware.nsx.model.StructDefinitions.containerClusterSummary);
        add(mapping,
            "com.vmware.nsx.model.container_configuration",
            com.vmware.nsx.model.StructDefinitions.containerConfiguration);
        add(mapping,
            "com.vmware.nsx.model.container_egress",
            com.vmware.nsx.model.StructDefinitions.containerEgress);
        add(mapping,
            "com.vmware.nsx.model.container_egress_list_result",
            com.vmware.nsx.model.StructDefinitions.containerEgressListResult);
        add(mapping,
            "com.vmware.nsx.model.container_gateway",
            com.vmware.nsx.model.StructDefinitions.containerGateway);
        add(mapping,
            "com.vmware.nsx.model.container_gateway_address",
            com.vmware.nsx.model.StructDefinitions.containerGatewayAddress);
        add(mapping,
            "com.vmware.nsx.model.container_gateway_list_result",
            com.vmware.nsx.model.StructDefinitions.containerGatewayListResult);
        add(mapping,
            "com.vmware.nsx.model.container_gateway_listener",
            com.vmware.nsx.model.StructDefinitions.containerGatewayListener);
        add(mapping,
            "com.vmware.nsx.model.container_infrastructure_info",
            com.vmware.nsx.model.StructDefinitions.containerInfrastructureInfo);
        add(mapping,
            "com.vmware.nsx.model.container_ingress_policy",
            com.vmware.nsx.model.StructDefinitions.containerIngressPolicy);
        add(mapping,
            "com.vmware.nsx.model.container_ingress_policy_list_result",
            com.vmware.nsx.model.StructDefinitions.containerIngressPolicyListResult);
        add(mapping,
            "com.vmware.nsx.model.container_ip_pool",
            com.vmware.nsx.model.StructDefinitions.containerIpPool);
        add(mapping,
            "com.vmware.nsx.model.container_ip_pool_list_result",
            com.vmware.nsx.model.StructDefinitions.containerIpPoolListResult);
        add(mapping,
            "com.vmware.nsx.model.container_load_balancer_ingress",
            com.vmware.nsx.model.StructDefinitions.containerLoadBalancerIngress);
        add(mapping,
            "com.vmware.nsx.model.container_network_policy",
            com.vmware.nsx.model.StructDefinitions.containerNetworkPolicy);
        add(mapping,
            "com.vmware.nsx.model.container_network_policy_list_result",
            com.vmware.nsx.model.StructDefinitions.containerNetworkPolicyListResult);
        add(mapping,
            "com.vmware.nsx.model.container_project",
            com.vmware.nsx.model.StructDefinitions.containerProject);
        add(mapping,
            "com.vmware.nsx.model.container_project_list_result",
            com.vmware.nsx.model.StructDefinitions.containerProjectListResult);
        add(mapping,
            "com.vmware.nsx.model.container_service_port",
            com.vmware.nsx.model.StructDefinitions.containerServicePort);
        add(mapping,
            "com.vmware.nsx.model.control_cluster_node_status",
            com.vmware.nsx.model.StructDefinitions.controlClusterNodeStatus);
        add(mapping,
            "com.vmware.nsx.model.control_conn_status",
            com.vmware.nsx.model.StructDefinitions.controlConnStatus);
        add(mapping,
            "com.vmware.nsx.model.controller_cluster_role_config",
            com.vmware.nsx.model.StructDefinitions.controllerClusterRoleConfig);
        add(mapping,
            "com.vmware.nsx.model.controller_cluster_status",
            com.vmware.nsx.model.StructDefinitions.controllerClusterStatus);
        add(mapping,
            "com.vmware.nsx.model.controller_node_aggregate_info",
            com.vmware.nsx.model.StructDefinitions.controllerNodeAggregateInfo);
        add(mapping,
            "com.vmware.nsx.model.controller_profiler_properties",
            com.vmware.nsx.model.StructDefinitions.controllerProfilerProperties);
        add(mapping,
            "com.vmware.nsx.model.copy_from_remote_file_properties",
            com.vmware.nsx.model.StructDefinitions.copyFromRemoteFileProperties);
        add(mapping,
            "com.vmware.nsx.model.copy_remote_file_properties",
            com.vmware.nsx.model.StructDefinitions.copyRemoteFileProperties);
        add(mapping,
            "com.vmware.nsx.model.copy_to_remote_file_properties",
            com.vmware.nsx.model.StructDefinitions.copyToRemoteFileProperties);
        add(mapping,
            "com.vmware.nsx.model.core_dump_config",
            com.vmware.nsx.model.StructDefinitions.coreDumpConfig);
        add(mapping,
            "com.vmware.nsx.model.core_dump_process_config",
            com.vmware.nsx.model.StructDefinitions.coreDumpProcessConfig);
        add(mapping,
            "com.vmware.nsx.model.corfu_certificate_expiry_check_properties",
            com.vmware.nsx.model.StructDefinitions.corfuCertificateExpiryCheckProperties);
        add(mapping,
            "com.vmware.nsx.model.cpu_core_config_for_enhanced_networking_stack_switch",
            com.vmware.nsx.model.StructDefinitions.cpuCoreConfigForEnhancedNetworkingStackSwitch);
        add(mapping,
            "com.vmware.nsx.model.cpu_usage",
            com.vmware.nsx.model.StructDefinitions.cpuUsage);
        add(mapping,
            "com.vmware.nsx.model.create_remote_directory_properties",
            com.vmware.nsx.model.StructDefinitions.createRemoteDirectoryProperties);
        add(mapping,
            "com.vmware.nsx.model.crl",
            com.vmware.nsx.model.StructDefinitions.crl);
        add(mapping,
            "com.vmware.nsx.model.crl_distribution_point",
            com.vmware.nsx.model.StructDefinitions.crlDistributionPoint);
        add(mapping,
            "com.vmware.nsx.model.crl_distribution_point_list",
            com.vmware.nsx.model.StructDefinitions.crlDistributionPointList);
        add(mapping,
            "com.vmware.nsx.model.crl_distribution_point_status",
            com.vmware.nsx.model.StructDefinitions.crlDistributionPointStatus);
        add(mapping,
            "com.vmware.nsx.model.crl_list",
            com.vmware.nsx.model.StructDefinitions.crlList);
        add(mapping,
            "com.vmware.nsx.model.crl_object_data",
            com.vmware.nsx.model.StructDefinitions.crlObjectData);
        add(mapping,
            "com.vmware.nsx.model.crl_pem_request_type",
            com.vmware.nsx.model.StructDefinitions.crlPemRequestType);
        add(mapping,
            "com.vmware.nsx.model.crypto_algorithm",
            com.vmware.nsx.model.StructDefinitions.cryptoAlgorithm);
        add(mapping,
            "com.vmware.nsx.model.csp_config",
            com.vmware.nsx.model.StructDefinitions.cspConfig);
        add(mapping,
            "com.vmware.nsx.model.csr",
            com.vmware.nsx.model.StructDefinitions.csr);
        add(mapping,
            "com.vmware.nsx.model.csr_ext",
            com.vmware.nsx.model.StructDefinitions.csrExt);
        add(mapping,
            "com.vmware.nsx.model.csr_extensions",
            com.vmware.nsx.model.StructDefinitions.csrExtensions);
        add(mapping,
            "com.vmware.nsx.model.csr_list",
            com.vmware.nsx.model.StructDefinitions.csrList);
        add(mapping,
            "com.vmware.nsx.model.csr_with_days_valid",
            com.vmware.nsx.model.StructDefinitions.csrWithDaysValid);
        add(mapping,
            "com.vmware.nsx.model.csv_list_result",
            com.vmware.nsx.model.StructDefinitions.csvListResult);
        add(mapping,
            "com.vmware.nsx.model.csv_record",
            com.vmware.nsx.model.StructDefinitions.csvRecord);
        add(mapping,
            "com.vmware.nsx.model.current_backup_operation_status",
            com.vmware.nsx.model.StructDefinitions.currentBackupOperationStatus);
        add(mapping,
            "com.vmware.nsx.model.current_realization_state_barrier",
            com.vmware.nsx.model.StructDefinitions.currentRealizationStateBarrier);
        add(mapping,
            "com.vmware.nsx.model.custom_filter_widget_configuration",
            com.vmware.nsx.model.StructDefinitions.customFilterWidgetConfiguration);
        add(mapping,
            "com.vmware.nsx.model.custom_widget_configuration",
            com.vmware.nsx.model.StructDefinitions.customWidgetConfiguration);
        add(mapping,
            "com.vmware.nsx.model.DAD_profile",
            com.vmware.nsx.model.StructDefinitions.DADProfile);
        add(mapping,
            "com.vmware.nsx.model.DAD_profile_list_result",
            com.vmware.nsx.model.StructDefinitions.DADProfileListResult);
        add(mapping,
            "com.vmware.nsx.model.DS_exclude_list",
            com.vmware.nsx.model.StructDefinitions.DSExcludeList);
        add(mapping,
            "com.vmware.nsx.model.DS_insert_parameters",
            com.vmware.nsx.model.StructDefinitions.DSInsertParameters);
        add(mapping,
            "com.vmware.nsx.model.DS_rule",
            com.vmware.nsx.model.StructDefinitions.DSRule);
        add(mapping,
            "com.vmware.nsx.model.DS_rule_state",
            com.vmware.nsx.model.StructDefinitions.DSRuleState);
        add(mapping,
            "com.vmware.nsx.model.DS_section",
            com.vmware.nsx.model.StructDefinitions.DSSection);
        add(mapping,
            "com.vmware.nsx.model.DS_section_list_result",
            com.vmware.nsx.model.StructDefinitions.DSSectionListResult);
        add(mapping,
            "com.vmware.nsx.model.DS_section_query_parameters",
            com.vmware.nsx.model.StructDefinitions.DSSectionQueryParameters);
        add(mapping,
            "com.vmware.nsx.model.DS_section_state",
            com.vmware.nsx.model.StructDefinitions.DSSectionState);
        add(mapping,
            "com.vmware.nsx.model.DS_service",
            com.vmware.nsx.model.StructDefinitions.DSService);
        add(mapping,
            "com.vmware.nsx.model.DVS_config",
            com.vmware.nsx.model.StructDefinitions.DVSConfig);
        add(mapping,
            "com.vmware.nsx.model.daily_telemetry_schedule",
            com.vmware.nsx.model.StructDefinitions.dailyTelemetrySchedule);
        add(mapping,
            "com.vmware.nsx.model.data_counter",
            com.vmware.nsx.model.StructDefinitions.dataCounter);
        add(mapping,
            "com.vmware.nsx.model.data_type_collection_configuration",
            com.vmware.nsx.model.StructDefinitions.dataTypeCollectionConfiguration);
        add(mapping,
            "com.vmware.nsx.model.datapath_counter_result",
            com.vmware.nsx.model.StructDefinitions.datapathCounterResult);
        add(mapping,
            "com.vmware.nsx.model.datapath_module_counter",
            com.vmware.nsx.model.StructDefinitions.datapathModuleCounter);
        add(mapping,
            "com.vmware.nsx.model.datapath_stats_action_argument",
            com.vmware.nsx.model.StructDefinitions.datapathStatsActionArgument);
        add(mapping,
            "com.vmware.nsx.model.datapath_stats_action_config",
            com.vmware.nsx.model.StructDefinitions.datapathStatsActionConfig);
        add(mapping,
            "com.vmware.nsx.model.datapath_stats_result",
            com.vmware.nsx.model.StructDefinitions.datapathStatsResult);
        add(mapping,
            "com.vmware.nsx.model.datasource",
            com.vmware.nsx.model.StructDefinitions.datasource);
        add(mapping,
            "com.vmware.nsx.model.default_filter_value",
            com.vmware.nsx.model.StructDefinitions.defaultFilterValue);
        add(mapping,
            "com.vmware.nsx.model.deployment_config",
            com.vmware.nsx.model.StructDefinitions.deploymentConfig);
        add(mapping,
            "com.vmware.nsx.model.deployment_spec_name",
            com.vmware.nsx.model.StructDefinitions.deploymentSpecName);
        add(mapping,
            "com.vmware.nsx.model.deployment_template",
            com.vmware.nsx.model.StructDefinitions.deploymentTemplate);
        add(mapping,
            "com.vmware.nsx.model.destination_nsx_api_endpoint",
            com.vmware.nsx.model.StructDefinitions.destinationNsxApiEndpoint);
        add(mapping,
            "com.vmware.nsx.model.dhcp_filter",
            com.vmware.nsx.model.StructDefinitions.dhcpFilter);
        add(mapping,
            "com.vmware.nsx.model.dhcp_header",
            com.vmware.nsx.model.StructDefinitions.dhcpHeader);
        add(mapping,
            "com.vmware.nsx.model.dhcp_ip_pool",
            com.vmware.nsx.model.StructDefinitions.dhcpIpPool);
        add(mapping,
            "com.vmware.nsx.model.dhcp_ip_pool_list_result",
            com.vmware.nsx.model.StructDefinitions.dhcpIpPoolListResult);
        add(mapping,
            "com.vmware.nsx.model.dhcp_ip_pool_usage",
            com.vmware.nsx.model.StructDefinitions.dhcpIpPoolUsage);
        add(mapping,
            "com.vmware.nsx.model.dhcp_lease_per_IP",
            com.vmware.nsx.model.StructDefinitions.dhcpLeasePerIP);
        add(mapping,
            "com.vmware.nsx.model.dhcp_leases",
            com.vmware.nsx.model.StructDefinitions.dhcpLeases);
        add(mapping,
            "com.vmware.nsx.model.dhcp_option121",
            com.vmware.nsx.model.StructDefinitions.dhcpOption121);
        add(mapping,
            "com.vmware.nsx.model.dhcp_options",
            com.vmware.nsx.model.StructDefinitions.dhcpOptions);
        add(mapping,
            "com.vmware.nsx.model.dhcp_profile",
            com.vmware.nsx.model.StructDefinitions.dhcpProfile);
        add(mapping,
            "com.vmware.nsx.model.dhcp_profile_list_result",
            com.vmware.nsx.model.StructDefinitions.dhcpProfileListResult);
        add(mapping,
            "com.vmware.nsx.model.dhcp_relay_profile",
            com.vmware.nsx.model.StructDefinitions.dhcpRelayProfile);
        add(mapping,
            "com.vmware.nsx.model.dhcp_relay_profile_list_result",
            com.vmware.nsx.model.StructDefinitions.dhcpRelayProfileListResult);
        add(mapping,
            "com.vmware.nsx.model.dhcp_relay_service",
            com.vmware.nsx.model.StructDefinitions.dhcpRelayService);
        add(mapping,
            "com.vmware.nsx.model.dhcp_relay_service_list_result",
            com.vmware.nsx.model.StructDefinitions.dhcpRelayServiceListResult);
        add(mapping,
            "com.vmware.nsx.model.dhcp_server_status",
            com.vmware.nsx.model.StructDefinitions.dhcpServerStatus);
        add(mapping,
            "com.vmware.nsx.model.dhcp_static_binding",
            com.vmware.nsx.model.StructDefinitions.dhcpStaticBinding);
        add(mapping,
            "com.vmware.nsx.model.dhcp_static_binding_list_result",
            com.vmware.nsx.model.StructDefinitions.dhcpStaticBindingListResult);
        add(mapping,
            "com.vmware.nsx.model.dhcp_statistics",
            com.vmware.nsx.model.StructDefinitions.dhcpStatistics);
        add(mapping,
            "com.vmware.nsx.model.dhcp_v6_info_base",
            com.vmware.nsx.model.StructDefinitions.dhcpV6InfoBase);
        add(mapping,
            "com.vmware.nsx.model.dhcp_v6_ip_pool",
            com.vmware.nsx.model.StructDefinitions.dhcpV6IpPool);
        add(mapping,
            "com.vmware.nsx.model.dhcp_v6_ip_pool_list_result",
            com.vmware.nsx.model.StructDefinitions.dhcpV6IpPoolListResult);
        add(mapping,
            "com.vmware.nsx.model.dhcp_v6_static_binding",
            com.vmware.nsx.model.StructDefinitions.dhcpV6StaticBinding);
        add(mapping,
            "com.vmware.nsx.model.dhcp_v6_static_binding_list_result",
            com.vmware.nsx.model.StructDefinitions.dhcpV6StaticBindingListResult);
        add(mapping,
            "com.vmware.nsx.model.dhcpv6_header",
            com.vmware.nsx.model.StructDefinitions.dhcpv6Header);
        add(mapping,
            "com.vmware.nsx.model.directory_ad_domain",
            com.vmware.nsx.model.StructDefinitions.directoryAdDomain);
        add(mapping,
            "com.vmware.nsx.model.directory_ad_group",
            com.vmware.nsx.model.StructDefinitions.directoryAdGroup);
        add(mapping,
            "com.vmware.nsx.model.directory_domain",
            com.vmware.nsx.model.StructDefinitions.directoryDomain);
        add(mapping,
            "com.vmware.nsx.model.directory_domain_list_results",
            com.vmware.nsx.model.StructDefinitions.directoryDomainListResults);
        add(mapping,
            "com.vmware.nsx.model.directory_domain_size",
            com.vmware.nsx.model.StructDefinitions.directoryDomainSize);
        add(mapping,
            "com.vmware.nsx.model.directory_domain_sync_settings",
            com.vmware.nsx.model.StructDefinitions.directoryDomainSyncSettings);
        add(mapping,
            "com.vmware.nsx.model.directory_domain_sync_stats",
            com.vmware.nsx.model.StructDefinitions.directoryDomainSyncStats);
        add(mapping,
            "com.vmware.nsx.model.directory_event_log_server",
            com.vmware.nsx.model.StructDefinitions.directoryEventLogServer);
        add(mapping,
            "com.vmware.nsx.model.directory_event_log_server_status",
            com.vmware.nsx.model.StructDefinitions.directoryEventLogServerStatus);
        add(mapping,
            "com.vmware.nsx.model.directory_group",
            com.vmware.nsx.model.StructDefinitions.directoryGroup);
        add(mapping,
            "com.vmware.nsx.model.directory_group_list_results",
            com.vmware.nsx.model.StructDefinitions.directoryGroupListResults);
        add(mapping,
            "com.vmware.nsx.model.directory_group_member",
            com.vmware.nsx.model.StructDefinitions.directoryGroupMember);
        add(mapping,
            "com.vmware.nsx.model.directory_group_member_list_results",
            com.vmware.nsx.model.StructDefinitions.directoryGroupMemberListResults);
        add(mapping,
            "com.vmware.nsx.model.directory_ldap_server",
            com.vmware.nsx.model.StructDefinitions.directoryLdapServer);
        add(mapping,
            "com.vmware.nsx.model.directory_ldap_server_list_results",
            com.vmware.nsx.model.StructDefinitions.directoryLdapServerListResults);
        add(mapping,
            "com.vmware.nsx.model.directory_ldap_server_status",
            com.vmware.nsx.model.StructDefinitions.directoryLdapServerStatus);
        add(mapping,
            "com.vmware.nsx.model.directory_org_unit",
            com.vmware.nsx.model.StructDefinitions.directoryOrgUnit);
        add(mapping,
            "com.vmware.nsx.model.directory_org_unit_list_results",
            com.vmware.nsx.model.StructDefinitions.directoryOrgUnitListResults);
        add(mapping,
            "com.vmware.nsx.model.discovered_node",
            com.vmware.nsx.model.StructDefinitions.discoveredNode);
        add(mapping,
            "com.vmware.nsx.model.discovered_node_interface_properties",
            com.vmware.nsx.model.StructDefinitions.discoveredNodeInterfaceProperties);
        add(mapping,
            "com.vmware.nsx.model.discovered_node_list_result",
            com.vmware.nsx.model.StructDefinitions.discoveredNodeListResult);
        add(mapping,
            "com.vmware.nsx.model.discovered_node_network_interfaces",
            com.vmware.nsx.model.StructDefinitions.discoveredNodeNetworkInterfaces);
        add(mapping,
            "com.vmware.nsx.model.discovered_resource",
            com.vmware.nsx.model.StructDefinitions.discoveredResource);
        add(mapping,
            "com.vmware.nsx.model.discovered_resource_association",
            com.vmware.nsx.model.StructDefinitions.discoveredResourceAssociation);
        add(mapping,
            "com.vmware.nsx.model.discovered_resource_scope",
            com.vmware.nsx.model.StructDefinitions.discoveredResourceScope);
        add(mapping,
            "com.vmware.nsx.model.dns_answer",
            com.vmware.nsx.model.StructDefinitions.dnsAnswer);
        add(mapping,
            "com.vmware.nsx.model.dns_failed_queries",
            com.vmware.nsx.model.StructDefinitions.dnsFailedQueries);
        add(mapping,
            "com.vmware.nsx.model.dns_failed_query",
            com.vmware.nsx.model.StructDefinitions.dnsFailedQuery);
        add(mapping,
            "com.vmware.nsx.model.dns_forwarder",
            com.vmware.nsx.model.StructDefinitions.dnsForwarder);
        add(mapping,
            "com.vmware.nsx.model.dns_forwarder_list_result",
            com.vmware.nsx.model.StructDefinitions.dnsForwarderListResult);
        add(mapping,
            "com.vmware.nsx.model.dns_forwarder_statistics",
            com.vmware.nsx.model.StructDefinitions.dnsForwarderStatistics);
        add(mapping,
            "com.vmware.nsx.model.dns_forwarder_status",
            com.vmware.nsx.model.StructDefinitions.dnsForwarderStatus);
        add(mapping,
            "com.vmware.nsx.model.dns_header",
            com.vmware.nsx.model.StructDefinitions.dnsHeader);
        add(mapping,
            "com.vmware.nsx.model.dns_query_answer",
            com.vmware.nsx.model.StructDefinitions.dnsQueryAnswer);
        add(mapping,
            "com.vmware.nsx.model.dns_ttl_config",
            com.vmware.nsx.model.StructDefinitions.dnsTtlConfig);
        add(mapping,
            "com.vmware.nsx.model.donut_configuration",
            com.vmware.nsx.model.StructDefinitions.donutConfiguration);
        add(mapping,
            "com.vmware.nsx.model.donut_part",
            com.vmware.nsx.model.StructDefinitions.donutPart);
        add(mapping,
            "com.vmware.nsx.model.donut_section",
            com.vmware.nsx.model.StructDefinitions.donutSection);
        add(mapping,
            "com.vmware.nsx.model.dpu_info",
            com.vmware.nsx.model.StructDefinitions.dpuInfo);
        add(mapping,
            "com.vmware.nsx.model.dpu_status_properties",
            com.vmware.nsx.model.StructDefinitions.dpuStatusProperties);
        add(mapping,
            "com.vmware.nsx.model.dropdown_filter_plot_configuration",
            com.vmware.nsx.model.StructDefinitions.dropdownFilterPlotConfiguration);
        add(mapping,
            "com.vmware.nsx.model.dropdown_filter_widget_configuration",
            com.vmware.nsx.model.StructDefinitions.dropdownFilterWidgetConfiguration);
        add(mapping,
            "com.vmware.nsx.model.dropdown_item",
            com.vmware.nsx.model.StructDefinitions.dropdownItem);
        add(mapping,
            "com.vmware.nsx.model.dscp",
            com.vmware.nsx.model.StructDefinitions.dscp);
        add(mapping,
            "com.vmware.nsx.model.duplicate_address_binding_entry",
            com.vmware.nsx.model.StructDefinitions.duplicateAddressBindingEntry);
        add(mapping,
            "com.vmware.nsx.model.duplicate_IP_detection",
            com.vmware.nsx.model.StructDefinitions.duplicateIPDetection);
        add(mapping,
            "com.vmware.nsx.model.dynamic_content_filters",
            com.vmware.nsx.model.StructDefinitions.dynamicContentFilters);
        add(mapping,
            "com.vmware.nsx.model.EULA_acceptance",
            com.vmware.nsx.model.StructDefinitions.EULAAcceptance);
        add(mapping,
            "com.vmware.nsx.model.EULA_content",
            com.vmware.nsx.model.StructDefinitions.EULAContent);
        add(mapping,
            "com.vmware.nsx.model.edge_cluster",
            com.vmware.nsx.model.StructDefinitions.edgeCluster);
        add(mapping,
            "com.vmware.nsx.model.edge_cluster_allocation_status",
            com.vmware.nsx.model.StructDefinitions.edgeClusterAllocationStatus);
        add(mapping,
            "com.vmware.nsx.model.edge_cluster_inter_site_status",
            com.vmware.nsx.model.StructDefinitions.edgeClusterInterSiteStatus);
        add(mapping,
            "com.vmware.nsx.model.edge_cluster_list_result",
            com.vmware.nsx.model.StructDefinitions.edgeClusterListResult);
        add(mapping,
            "com.vmware.nsx.model.edge_cluster_member",
            com.vmware.nsx.model.StructDefinitions.edgeClusterMember);
        add(mapping,
            "com.vmware.nsx.model.edge_cluster_member_allocation_pool",
            com.vmware.nsx.model.StructDefinitions.edgeClusterMemberAllocationPool);
        add(mapping,
            "com.vmware.nsx.model.edge_cluster_member_allocation_profile",
            com.vmware.nsx.model.StructDefinitions.edgeClusterMemberAllocationProfile);
        add(mapping,
            "com.vmware.nsx.model.edge_cluster_member_index",
            com.vmware.nsx.model.StructDefinitions.edgeClusterMemberIndex);
        add(mapping,
            "com.vmware.nsx.model.edge_cluster_member_inter_site_status",
            com.vmware.nsx.model.StructDefinitions.edgeClusterMemberInterSiteStatus);
        add(mapping,
            "com.vmware.nsx.model.edge_cluster_member_status",
            com.vmware.nsx.model.StructDefinitions.edgeClusterMemberStatus);
        add(mapping,
            "com.vmware.nsx.model.edge_cluster_member_transport_node",
            com.vmware.nsx.model.StructDefinitions.edgeClusterMemberTransportNode);
        add(mapping,
            "com.vmware.nsx.model.edge_cluster_state",
            com.vmware.nsx.model.StructDefinitions.edgeClusterState);
        add(mapping,
            "com.vmware.nsx.model.edge_cluster_status",
            com.vmware.nsx.model.StructDefinitions.edgeClusterStatus);
        add(mapping,
            "com.vmware.nsx.model.edge_configuration_state",
            com.vmware.nsx.model.StructDefinitions.edgeConfigurationState);
        add(mapping,
            "com.vmware.nsx.model.edge_high_availability_profile",
            com.vmware.nsx.model.StructDefinitions.edgeHighAvailabilityProfile);
        add(mapping,
            "com.vmware.nsx.model.edge_member_allocation_status",
            com.vmware.nsx.model.StructDefinitions.edgeMemberAllocationStatus);
        add(mapping,
            "com.vmware.nsx.model.edge_node",
            com.vmware.nsx.model.StructDefinitions.edgeNode);
        add(mapping,
            "com.vmware.nsx.model.edge_node_deployment_config",
            com.vmware.nsx.model.StructDefinitions.edgeNodeDeploymentConfig);
        add(mapping,
            "com.vmware.nsx.model.edge_node_settings",
            com.vmware.nsx.model.StructDefinitions.edgeNodeSettings);
        add(mapping,
            "com.vmware.nsx.model.edge_transport_node_datapath_memory_pool_usage",
            com.vmware.nsx.model.StructDefinitions.edgeTransportNodeDatapathMemoryPoolUsage);
        add(mapping,
            "com.vmware.nsx.model.edge_transport_node_datapath_memory_usage",
            com.vmware.nsx.model.StructDefinitions.edgeTransportNodeDatapathMemoryUsage);
        add(mapping,
            "com.vmware.nsx.model.edge_transport_node_memory_usage",
            com.vmware.nsx.model.StructDefinitions.edgeTransportNodeMemoryUsage);
        add(mapping,
            "com.vmware.nsx.model.edge_upgrade_status",
            com.vmware.nsx.model.StructDefinitions.edgeUpgradeStatus);
        add(mapping,
            "com.vmware.nsx.model.effective_IP_address_member_list_result",
            com.vmware.nsx.model.StructDefinitions.effectiveIPAddressMemberListResult);
        add(mapping,
            "com.vmware.nsx.model.effective_IP_info",
            com.vmware.nsx.model.StructDefinitions.effectiveIPInfo);
        add(mapping,
            "com.vmware.nsx.model.effective_member_resource_list_result",
            com.vmware.nsx.model.StructDefinitions.effectiveMemberResourceListResult);
        add(mapping,
            "com.vmware.nsx.model.effective_member_type_list_result",
            com.vmware.nsx.model.StructDefinitions.effectiveMemberTypeListResult);
        add(mapping,
            "com.vmware.nsx.model.effective_profile_list_result",
            com.vmware.nsx.model.StructDefinitions.effectiveProfileListResult);
        add(mapping,
            "com.vmware.nsx.model.egress_rate_shaper",
            com.vmware.nsx.model.StructDefinitions.egressRateShaper);
        add(mapping,
            "com.vmware.nsx.model.embedded_resource",
            com.vmware.nsx.model.StructDefinitions.embeddedResource);
        add(mapping,
            "com.vmware.nsx.model.endpoint",
            com.vmware.nsx.model.StructDefinitions.endpoint);
        add(mapping,
            "com.vmware.nsx.model.entitlement_spec",
            com.vmware.nsx.model.StructDefinitions.entitlementSpec);
        add(mapping,
            "com.vmware.nsx.model.error_info",
            com.vmware.nsx.model.StructDefinitions.errorInfo);
        add(mapping,
            "com.vmware.nsx.model.error_resolver_info",
            com.vmware.nsx.model.StructDefinitions.errorResolverInfo);
        add(mapping,
            "com.vmware.nsx.model.error_resolver_info_list",
            com.vmware.nsx.model.StructDefinitions.errorResolverInfoList);
        add(mapping,
            "com.vmware.nsx.model.error_resolver_metadata",
            com.vmware.nsx.model.StructDefinitions.errorResolverMetadata);
        add(mapping,
            "com.vmware.nsx.model.error_resolver_metadata_list",
            com.vmware.nsx.model.StructDefinitions.errorResolverMetadataList);
        add(mapping,
            "com.vmware.nsx.model.error_resolver_system_metadata",
            com.vmware.nsx.model.StructDefinitions.errorResolverSystemMetadata);
        add(mapping,
            "com.vmware.nsx.model.error_resolver_user_input_data",
            com.vmware.nsx.model.StructDefinitions.errorResolverUserInputData);
        add(mapping,
            "com.vmware.nsx.model.error_resolver_user_metadata",
            com.vmware.nsx.model.StructDefinitions.errorResolverUserMetadata);
        add(mapping,
            "com.vmware.nsx.model.esx_global_opaque_config",
            com.vmware.nsx.model.StructDefinitions.esxGlobalOpaqueConfig);
        add(mapping,
            "com.vmware.nsx.model.ether_type_NS_service",
            com.vmware.nsx.model.StructDefinitions.etherTypeNSService);
        add(mapping,
            "com.vmware.nsx.model.ethernet_header",
            com.vmware.nsx.model.StructDefinitions.ethernetHeader);
        add(mapping,
            "com.vmware.nsx.model.event_list_result",
            com.vmware.nsx.model.StructDefinitions.eventListResult);
        add(mapping,
            "com.vmware.nsx.model.exclude_list",
            com.vmware.nsx.model.StructDefinitions.excludeList);
        add(mapping,
            "com.vmware.nsx.model.extended_solution_config",
            com.vmware.nsx.model.StructDefinitions.extendedSolutionConfig);
        add(mapping,
            "com.vmware.nsx.model.extra_config",
            com.vmware.nsx.model.StructDefinitions.extraConfig);
        add(mapping,
            "com.vmware.nsx.model.extra_config_host_switch_profile",
            com.vmware.nsx.model.StructDefinitions.extraConfigHostSwitchProfile);
        add(mapping,
            "com.vmware.nsx.model.failed_node_support_bundle_result",
            com.vmware.nsx.model.StructDefinitions.failedNodeSupportBundleResult);
        add(mapping,
            "com.vmware.nsx.model.failure_domain",
            com.vmware.nsx.model.StructDefinitions.failureDomain);
        add(mapping,
            "com.vmware.nsx.model.failure_domain_list_result",
            com.vmware.nsx.model.StructDefinitions.failureDomainListResult);
        add(mapping,
            "com.vmware.nsx.model.feature_permission",
            com.vmware.nsx.model.StructDefinitions.featurePermission);
        add(mapping,
            "com.vmware.nsx.model.feature_permission_array",
            com.vmware.nsx.model.StructDefinitions.featurePermissionArray);
        add(mapping,
            "com.vmware.nsx.model.feature_permission_list_result",
            com.vmware.nsx.model.StructDefinitions.featurePermissionListResult);
        add(mapping,
            "com.vmware.nsx.model.feature_set",
            com.vmware.nsx.model.StructDefinitions.featureSet);
        add(mapping,
            "com.vmware.nsx.model.feature_stack_collection_configuration",
            com.vmware.nsx.model.StructDefinitions.featureStackCollectionConfiguration);
        add(mapping,
            "com.vmware.nsx.model.feature_stack_collection_configuration_list",
            com.vmware.nsx.model.StructDefinitions.featureStackCollectionConfigurationList);
        add(mapping,
            "com.vmware.nsx.model.feature_usage",
            com.vmware.nsx.model.StructDefinitions.featureUsage);
        add(mapping,
            "com.vmware.nsx.model.feature_usage_csv_record",
            com.vmware.nsx.model.StructDefinitions.featureUsageCsvRecord);
        add(mapping,
            "com.vmware.nsx.model.feature_usage_list",
            com.vmware.nsx.model.StructDefinitions.featureUsageList);
        add(mapping,
            "com.vmware.nsx.model.feature_usage_list_in_csv_format",
            com.vmware.nsx.model.StructDefinitions.featureUsageListInCsvFormat);
        add(mapping,
            "com.vmware.nsx.model.federation_configuration",
            com.vmware.nsx.model.StructDefinitions.federationConfiguration);
        add(mapping,
            "com.vmware.nsx.model.federation_site",
            com.vmware.nsx.model.StructDefinitions.federationSite);
        add(mapping,
            "com.vmware.nsx.model.federation_site_migration_state",
            com.vmware.nsx.model.StructDefinitions.federationSiteMigrationState);
        add(mapping,
            "com.vmware.nsx.model.federation_status",
            com.vmware.nsx.model.StructDefinitions.federationStatus);
        add(mapping,
            "com.vmware.nsx.model.feed_back",
            com.vmware.nsx.model.StructDefinitions.feedBack);
        add(mapping,
            "com.vmware.nsx.model.feed_back_error_message",
            com.vmware.nsx.model.StructDefinitions.feedBackErrorMessage);
        add(mapping,
            "com.vmware.nsx.model.feed_back_list_result",
            com.vmware.nsx.model.StructDefinitions.feedBackListResult);
        add(mapping,
            "com.vmware.nsx.model.fields_filter_data",
            com.vmware.nsx.model.StructDefinitions.fieldsFilterData);
        add(mapping,
            "com.vmware.nsx.model.fields_packet_data",
            com.vmware.nsx.model.StructDefinitions.fieldsPacketData);
        add(mapping,
            "com.vmware.nsx.model.file_properties",
            com.vmware.nsx.model.StructDefinitions.fileProperties);
        add(mapping,
            "com.vmware.nsx.model.file_properties_list_result",
            com.vmware.nsx.model.StructDefinitions.filePropertiesListResult);
        add(mapping,
            "com.vmware.nsx.model.file_thumbprint",
            com.vmware.nsx.model.StructDefinitions.fileThumbprint);
        add(mapping,
            "com.vmware.nsx.model.file_transfer_authentication_scheme",
            com.vmware.nsx.model.StructDefinitions.fileTransferAuthenticationScheme);
        add(mapping,
            "com.vmware.nsx.model.file_transfer_protocol",
            com.vmware.nsx.model.StructDefinitions.fileTransferProtocol);
        add(mapping,
            "com.vmware.nsx.model.filter",
            com.vmware.nsx.model.StructDefinitions.filter);
        add(mapping,
            "com.vmware.nsx.model.filter_request",
            com.vmware.nsx.model.StructDefinitions.filterRequest);
        add(mapping,
            "com.vmware.nsx.model.filter_widget_configuration",
            com.vmware.nsx.model.StructDefinitions.filterWidgetConfiguration);
        add(mapping,
            "com.vmware.nsx.model.fips_global_config",
            com.vmware.nsx.model.StructDefinitions.fipsGlobalConfig);
        add(mapping,
            "com.vmware.nsx.model.fire_wall_service_association_list_result",
            com.vmware.nsx.model.StructDefinitions.fireWallServiceAssociationListResult);
        add(mapping,
            "com.vmware.nsx.model.firewall_cpu_mem_thresholds_profile",
            com.vmware.nsx.model.StructDefinitions.firewallCpuMemThresholdsProfile);
        add(mapping,
            "com.vmware.nsx.model.firewall_dns_profile",
            com.vmware.nsx.model.StructDefinitions.firewallDnsProfile);
        add(mapping,
            "com.vmware.nsx.model.firewall_flood_protection_profile",
            com.vmware.nsx.model.StructDefinitions.firewallFloodProtectionProfile);
        add(mapping,
            "com.vmware.nsx.model.firewall_global_config",
            com.vmware.nsx.model.StructDefinitions.firewallGlobalConfig);
        add(mapping,
            "com.vmware.nsx.model.firewall_profile_list_result",
            com.vmware.nsx.model.StructDefinitions.firewallProfileListResult);
        add(mapping,
            "com.vmware.nsx.model.firewall_rule",
            com.vmware.nsx.model.StructDefinitions.firewallRule);
        add(mapping,
            "com.vmware.nsx.model.firewall_rule_list",
            com.vmware.nsx.model.StructDefinitions.firewallRuleList);
        add(mapping,
            "com.vmware.nsx.model.firewall_rule_list_result",
            com.vmware.nsx.model.StructDefinitions.firewallRuleListResult);
        add(mapping,
            "com.vmware.nsx.model.firewall_section",
            com.vmware.nsx.model.StructDefinitions.firewallSection);
        add(mapping,
            "com.vmware.nsx.model.firewall_section_list_result",
            com.vmware.nsx.model.StructDefinitions.firewallSectionListResult);
        add(mapping,
            "com.vmware.nsx.model.firewall_section_lock",
            com.vmware.nsx.model.StructDefinitions.firewallSectionLock);
        add(mapping,
            "com.vmware.nsx.model.firewall_section_rule_list",
            com.vmware.nsx.model.StructDefinitions.firewallSectionRuleList);
        add(mapping,
            "com.vmware.nsx.model.firewall_section_state",
            com.vmware.nsx.model.StructDefinitions.firewallSectionState);
        add(mapping,
            "com.vmware.nsx.model.firewall_sections_summary",
            com.vmware.nsx.model.StructDefinitions.firewallSectionsSummary);
        add(mapping,
            "com.vmware.nsx.model.firewall_sections_summary_list",
            com.vmware.nsx.model.StructDefinitions.firewallSectionsSummaryList);
        add(mapping,
            "com.vmware.nsx.model.firewall_service",
            com.vmware.nsx.model.StructDefinitions.firewallService);
        add(mapping,
            "com.vmware.nsx.model.firewall_session_timer_profile",
            com.vmware.nsx.model.StructDefinitions.firewallSessionTimerProfile);
        add(mapping,
            "com.vmware.nsx.model.firewall_stats",
            com.vmware.nsx.model.StructDefinitions.firewallStats);
        add(mapping,
            "com.vmware.nsx.model.firewall_stats_list",
            com.vmware.nsx.model.StructDefinitions.firewallStatsList);
        add(mapping,
            "com.vmware.nsx.model.firewall_status",
            com.vmware.nsx.model.StructDefinitions.firewallStatus);
        add(mapping,
            "com.vmware.nsx.model.firewall_status_list_result",
            com.vmware.nsx.model.StructDefinitions.firewallStatusListResult);
        add(mapping,
            "com.vmware.nsx.model.firstn_sampling",
            com.vmware.nsx.model.StructDefinitions.firstnSampling);
        add(mapping,
            "com.vmware.nsx.model.footer",
            com.vmware.nsx.model.StructDefinitions.footer);
        add(mapping,
            "com.vmware.nsx.model.footer_action",
            com.vmware.nsx.model.StructDefinitions.footerAction);
        add(mapping,
            "com.vmware.nsx.model.forwarder_zone",
            com.vmware.nsx.model.StructDefinitions.forwarderZone);
        add(mapping,
            "com.vmware.nsx.model.full_sync_status",
            com.vmware.nsx.model.StructDefinitions.fullSyncStatus);
        add(mapping,
            "com.vmware.nsx.model.general_security_settings_profile",
            com.vmware.nsx.model.StructDefinitions.generalSecuritySettingsProfile);
        add(mapping,
            "com.vmware.nsx.model.generic_dhcp_option",
            com.vmware.nsx.model.StructDefinitions.genericDhcpOption);
        add(mapping,
            "com.vmware.nsx.model.gi_service_profile",
            com.vmware.nsx.model.StructDefinitions.giServiceProfile);
        add(mapping,
            "com.vmware.nsx.model.global_collection_configuration",
            com.vmware.nsx.model.StructDefinitions.globalCollectionConfiguration);
        add(mapping,
            "com.vmware.nsx.model.global_configs",
            com.vmware.nsx.model.StructDefinitions.globalConfigs);
        add(mapping,
            "com.vmware.nsx.model.global_configs_list_result",
            com.vmware.nsx.model.StructDefinitions.globalConfigsListResult);
        add(mapping,
            "com.vmware.nsx.model.global_restore_status",
            com.vmware.nsx.model.StructDefinitions.globalRestoreStatus);
        add(mapping,
            "com.vmware.nsx.model.graceful_restart_config",
            com.vmware.nsx.model.StructDefinitions.gracefulRestartConfig);
        add(mapping,
            "com.vmware.nsx.model.graceful_restart_timer",
            com.vmware.nsx.model.StructDefinitions.gracefulRestartTimer);
        add(mapping,
            "com.vmware.nsx.model.graph_configuration",
            com.vmware.nsx.model.StructDefinitions.graphConfiguration);
        add(mapping,
            "com.vmware.nsx.model.graph_definition",
            com.vmware.nsx.model.StructDefinitions.graphDefinition);
        add(mapping,
            "com.vmware.nsx.model.grid_configuration",
            com.vmware.nsx.model.StructDefinitions.gridConfiguration);
        add(mapping,
            "com.vmware.nsx.model.grouped_migration_feedback_request",
            com.vmware.nsx.model.StructDefinitions.groupedMigrationFeedbackRequest);
        add(mapping,
            "com.vmware.nsx.model.grouped_migration_feedback_request_list_result",
            com.vmware.nsx.model.StructDefinitions.groupedMigrationFeedbackRequestListResult);
        add(mapping,
            "com.vmware.nsx.model.guest_info",
            com.vmware.nsx.model.StructDefinitions.guestInfo);
        add(mapping,
            "com.vmware.nsx.model.ha_vip_config",
            com.vmware.nsx.model.StructDefinitions.haVipConfig);
        add(mapping,
            "com.vmware.nsx.model.header",
            com.vmware.nsx.model.StructDefinitions.header);
        add(mapping,
            "com.vmware.nsx.model.health_check_result",
            com.vmware.nsx.model.StructDefinitions.healthCheckResult);
        add(mapping,
            "com.vmware.nsx.model.health_check_result_on_host_switch",
            com.vmware.nsx.model.StructDefinitions.healthCheckResultOnHostSwitch);
        add(mapping,
            "com.vmware.nsx.model.health_check_result_per_transport_node",
            com.vmware.nsx.model.StructDefinitions.healthCheckResultPerTransportNode);
        add(mapping,
            "com.vmware.nsx.model.health_check_result_per_uplink",
            com.vmware.nsx.model.StructDefinitions.healthCheckResultPerUplink);
        add(mapping,
            "com.vmware.nsx.model.health_check_spec_vlans",
            com.vmware.nsx.model.StructDefinitions.healthCheckSpecVlans);
        add(mapping,
            "com.vmware.nsx.model.health_check_vlan_range",
            com.vmware.nsx.model.StructDefinitions.healthCheckVlanRange);
        add(mapping,
            "com.vmware.nsx.model.heat_map_transport_nodes_aggregate_status",
            com.vmware.nsx.model.StructDefinitions.heatMapTransportNodesAggregateStatus);
        add(mapping,
            "com.vmware.nsx.model.heat_map_transport_zone_status",
            com.vmware.nsx.model.StructDefinitions.heatMapTransportZoneStatus);
        add(mapping,
            "com.vmware.nsx.model.host_infra_traffic_type",
            com.vmware.nsx.model.StructDefinitions.hostInfraTrafficType);
        add(mapping,
            "com.vmware.nsx.model.host_node",
            com.vmware.nsx.model.StructDefinitions.hostNode);
        add(mapping,
            "com.vmware.nsx.model.host_node_login_credential",
            com.vmware.nsx.model.StructDefinitions.hostNodeLoginCredential);
        add(mapping,
            "com.vmware.nsx.model.host_node_status",
            com.vmware.nsx.model.StructDefinitions.hostNodeStatus);
        add(mapping,
            "com.vmware.nsx.model.host_node_status_list_result",
            com.vmware.nsx.model.StructDefinitions.hostNodeStatusListResult);
        add(mapping,
            "com.vmware.nsx.model.host_switch_config_option",
            com.vmware.nsx.model.StructDefinitions.hostSwitchConfigOption);
        add(mapping,
            "com.vmware.nsx.model.host_switch_info",
            com.vmware.nsx.model.StructDefinitions.hostSwitchInfo);
        add(mapping,
            "com.vmware.nsx.model.host_switch_profile_type_id_entry",
            com.vmware.nsx.model.StructDefinitions.hostSwitchProfileTypeIdEntry);
        add(mapping,
            "com.vmware.nsx.model.host_switch_profiles_list_result",
            com.vmware.nsx.model.StructDefinitions.hostSwitchProfilesListResult);
        add(mapping,
            "com.vmware.nsx.model.host_switch_spec",
            com.vmware.nsx.model.StructDefinitions.hostSwitchSpec);
        add(mapping,
            "com.vmware.nsx.model.host_switch_state",
            com.vmware.nsx.model.StructDefinitions.hostSwitchState);
        add(mapping,
            "com.vmware.nsx.model.host_upgrade_status",
            com.vmware.nsx.model.StructDefinitions.hostUpgradeStatus);
        add(mapping,
            "com.vmware.nsx.model.hosted_entity_info",
            com.vmware.nsx.model.StructDefinitions.hostedEntityInfo);
        add(mapping,
            "com.vmware.nsx.model.http_protocol",
            com.vmware.nsx.model.StructDefinitions.httpProtocol);
        add(mapping,
            "com.vmware.nsx.model.http_service_properties",
            com.vmware.nsx.model.StructDefinitions.httpServiceProperties);
        add(mapping,
            "com.vmware.nsx.model.https_protocol",
            com.vmware.nsx.model.StructDefinitions.httpsProtocol);
        add(mapping,
            "com.vmware.nsx.model.ICMP_type_NS_service",
            com.vmware.nsx.model.StructDefinitions.ICMPTypeNSService);
        add(mapping,
            "com.vmware.nsx.model.IDS_event_data_request",
            com.vmware.nsx.model.StructDefinitions.IDSEventDataRequest);
        add(mapping,
            "com.vmware.nsx.model.IDS_events_by_signature",
            com.vmware.nsx.model.StructDefinitions.IDSEventsBySignature);
        add(mapping,
            "com.vmware.nsx.model.IDS_events_by_signature_result",
            com.vmware.nsx.model.StructDefinitions.IDSEventsBySignatureResult);
        add(mapping,
            "com.vmware.nsx.model.IDS_events_summary",
            com.vmware.nsx.model.StructDefinitions.IDSEventsSummary);
        add(mapping,
            "com.vmware.nsx.model.IDS_profile",
            com.vmware.nsx.model.StructDefinitions.IDSProfile);
        add(mapping,
            "com.vmware.nsx.model.IDS_signature_detail",
            com.vmware.nsx.model.StructDefinitions.IDSSignatureDetail);
        add(mapping,
            "com.vmware.nsx.model.IDS_summary_list_result",
            com.vmware.nsx.model.StructDefinitions.IDSSummaryListResult);
        add(mapping,
            "com.vmware.nsx.model.IGMP_type_NS_service",
            com.vmware.nsx.model.StructDefinitions.IGMPTypeNSService);
        add(mapping,
            "com.vmware.nsx.model.IP_address_element",
            com.vmware.nsx.model.StructDefinitions.IPAddressElement);
        add(mapping,
            "com.vmware.nsx.model.IP_address_element_list_result",
            com.vmware.nsx.model.StructDefinitions.IPAddressElementListResult);
        add(mapping,
            "com.vmware.nsx.model.IP_addresses",
            com.vmware.nsx.model.StructDefinitions.IPAddresses);
        add(mapping,
            "com.vmware.nsx.model.IP_info",
            com.vmware.nsx.model.StructDefinitions.IPInfo);
        add(mapping,
            "com.vmware.nsx.model.IP_mirror_destination",
            com.vmware.nsx.model.StructDefinitions.IPMirrorDestination);
        add(mapping,
            "com.vmware.nsx.model.IP_prefix_list",
            com.vmware.nsx.model.StructDefinitions.IPPrefixList);
        add(mapping,
            "com.vmware.nsx.model.IP_prefix_list_list_result",
            com.vmware.nsx.model.StructDefinitions.IPPrefixListListResult);
        add(mapping,
            "com.vmware.nsx.model.IP_protocol_NS_service",
            com.vmware.nsx.model.StructDefinitions.IPProtocolNSService);
        add(mapping,
            "com.vmware.nsx.model.IP_sec_VPNDPD_profile",
            com.vmware.nsx.model.StructDefinitions.IPSecVPNDPDProfile);
        add(mapping,
            "com.vmware.nsx.model.IP_sec_VPNDPD_profile_list_result",
            com.vmware.nsx.model.StructDefinitions.IPSecVPNDPDProfileListResult);
        add(mapping,
            "com.vmware.nsx.model.IP_sec_VPNIKE_profile",
            com.vmware.nsx.model.StructDefinitions.IPSecVPNIKEProfile);
        add(mapping,
            "com.vmware.nsx.model.IP_sec_VPNIKE_profile_list_result",
            com.vmware.nsx.model.StructDefinitions.IPSecVPNIKEProfileListResult);
        add(mapping,
            "com.vmware.nsx.model.IP_sec_VPNIKE_service_summary",
            com.vmware.nsx.model.StructDefinitions.IPSecVPNIKEServiceSummary);
        add(mapping,
            "com.vmware.nsx.model.IP_sec_VPNIKE_session_status",
            com.vmware.nsx.model.StructDefinitions.IPSecVPNIKESessionStatus);
        add(mapping,
            "com.vmware.nsx.model.IP_sec_VPNIKE_traffic_statistics",
            com.vmware.nsx.model.StructDefinitions.IPSecVPNIKETrafficStatistics);
        add(mapping,
            "com.vmware.nsx.model.IP_sec_VPN_local_endpoint",
            com.vmware.nsx.model.StructDefinitions.IPSecVPNLocalEndpoint);
        add(mapping,
            "com.vmware.nsx.model.IP_sec_VPN_local_endpoint_list_result",
            com.vmware.nsx.model.StructDefinitions.IPSecVPNLocalEndpointListResult);
        add(mapping,
            "com.vmware.nsx.model.IP_sec_VPN_peer_endpoint",
            com.vmware.nsx.model.StructDefinitions.IPSecVPNPeerEndpoint);
        add(mapping,
            "com.vmware.nsx.model.IP_sec_VPN_peer_endpoint_list_result",
            com.vmware.nsx.model.StructDefinitions.IPSecVPNPeerEndpointListResult);
        add(mapping,
            "com.vmware.nsx.model.IP_sec_VPN_policy_rule",
            com.vmware.nsx.model.StructDefinitions.IPSecVPNPolicyRule);
        add(mapping,
            "com.vmware.nsx.model.IP_sec_VPN_policy_subnet",
            com.vmware.nsx.model.StructDefinitions.IPSecVPNPolicySubnet);
        add(mapping,
            "com.vmware.nsx.model.IP_sec_VPN_policy_traffic_statistics",
            com.vmware.nsx.model.StructDefinitions.IPSecVPNPolicyTrafficStatistics);
        add(mapping,
            "com.vmware.nsx.model.IP_sec_VPN_service",
            com.vmware.nsx.model.StructDefinitions.IPSecVPNService);
        add(mapping,
            "com.vmware.nsx.model.IP_sec_VPN_service_list_result",
            com.vmware.nsx.model.StructDefinitions.IPSecVPNServiceListResult);
        add(mapping,
            "com.vmware.nsx.model.IP_sec_VPN_session",
            com.vmware.nsx.model.StructDefinitions.IPSecVPNSession);
        add(mapping,
            "com.vmware.nsx.model.IP_sec_VPN_session_list_result",
            com.vmware.nsx.model.StructDefinitions.IPSecVPNSessionListResult);
        add(mapping,
            "com.vmware.nsx.model.IP_sec_VPN_session_state",
            com.vmware.nsx.model.StructDefinitions.IPSecVPNSessionState);
        add(mapping,
            "com.vmware.nsx.model.IP_sec_VPN_session_statistics",
            com.vmware.nsx.model.StructDefinitions.IPSecVPNSessionStatistics);
        add(mapping,
            "com.vmware.nsx.model.IP_sec_VPN_session_status",
            com.vmware.nsx.model.StructDefinitions.IPSecVPNSessionStatus);
        add(mapping,
            "com.vmware.nsx.model.IP_sec_VPN_session_summary",
            com.vmware.nsx.model.StructDefinitions.IPSecVPNSessionSummary);
        add(mapping,
            "com.vmware.nsx.model.IP_sec_VPN_session_traffic_summary",
            com.vmware.nsx.model.StructDefinitions.IPSecVPNSessionTrafficSummary);
        add(mapping,
            "com.vmware.nsx.model.IP_sec_VPN_traffic_counters",
            com.vmware.nsx.model.StructDefinitions.IPSecVPNTrafficCounters);
        add(mapping,
            "com.vmware.nsx.model.IP_sec_VPN_transport_status",
            com.vmware.nsx.model.StructDefinitions.IPSecVPNTransportStatus);
        add(mapping,
            "com.vmware.nsx.model.IP_sec_VPN_tunnel_profile",
            com.vmware.nsx.model.StructDefinitions.IPSecVPNTunnelProfile);
        add(mapping,
            "com.vmware.nsx.model.IP_sec_VPN_tunnel_profile_list_result",
            com.vmware.nsx.model.StructDefinitions.IPSecVPNTunnelProfileListResult);
        add(mapping,
            "com.vmware.nsx.model.IP_sec_VPN_tunnel_traffic_statistics",
            com.vmware.nsx.model.StructDefinitions.IPSecVPNTunnelTrafficStatistics);
        add(mapping,
            "com.vmware.nsx.model.IP_set",
            com.vmware.nsx.model.StructDefinitions.IPSet);
        add(mapping,
            "com.vmware.nsx.model.IP_set_list_result",
            com.vmware.nsx.model.StructDefinitions.IPSetListResult);
        add(mapping,
            "com.vmware.nsx.model.IP_subnet",
            com.vmware.nsx.model.StructDefinitions.IPSubnet);
        add(mapping,
            "com.vmware.nsx.model.I_psec_VPNIKE_session_summary",
            com.vmware.nsx.model.StructDefinitions.IPsecVPNIKESessionSummary);
        add(mapping,
            "com.vmware.nsx.model.I_pv4_address_properties",
            com.vmware.nsx.model.StructDefinitions.IPv4AddressProperties);
        add(mapping,
            "com.vmware.nsx.model.I_pv4_dhcp_server",
            com.vmware.nsx.model.StructDefinitions.IPv4DhcpServer);
        add(mapping,
            "com.vmware.nsx.model.I_pv6_address_properties",
            com.vmware.nsx.model.StructDefinitions.IPv6AddressProperties);
        add(mapping,
            "com.vmware.nsx.model.I_pv6_DAD_status",
            com.vmware.nsx.model.StructDefinitions.IPv6DADStatus);
        add(mapping,
            "com.vmware.nsx.model.I_pv6_dhcp_server",
            com.vmware.nsx.model.StructDefinitions.IPv6DhcpServer);
        add(mapping,
            "com.vmware.nsx.model.I_pv6_profiles",
            com.vmware.nsx.model.StructDefinitions.IPv6Profiles);
        add(mapping,
            "com.vmware.nsx.model.icmp_echo_request_header",
            com.vmware.nsx.model.StructDefinitions.icmpEchoRequestHeader);
        add(mapping,
            "com.vmware.nsx.model.icon",
            com.vmware.nsx.model.StructDefinitions.icon);
        add(mapping,
            "com.vmware.nsx.model.idfw_compute_collection_condition",
            com.vmware.nsx.model.StructDefinitions.idfwComputeCollectionCondition);
        add(mapping,
            "com.vmware.nsx.model.idfw_compute_collection_list_result",
            com.vmware.nsx.model.StructDefinitions.idfwComputeCollectionListResult);
        add(mapping,
            "com.vmware.nsx.model.idfw_compute_collection_status",
            com.vmware.nsx.model.StructDefinitions.idfwComputeCollectionStatus);
        add(mapping,
            "com.vmware.nsx.model.idfw_dir_group_user_session_mapping",
            com.vmware.nsx.model.StructDefinitions.idfwDirGroupUserSessionMapping);
        add(mapping,
            "com.vmware.nsx.model.idfw_enabled_compute_collection",
            com.vmware.nsx.model.StructDefinitions.idfwEnabledComputeCollection);
        add(mapping,
            "com.vmware.nsx.model.idfw_enabled_compute_collection_list_result",
            com.vmware.nsx.model.StructDefinitions.idfwEnabledComputeCollectionListResult);
        add(mapping,
            "com.vmware.nsx.model.idfw_master_switch_setting",
            com.vmware.nsx.model.StructDefinitions.idfwMasterSwitchSetting);
        add(mapping,
            "com.vmware.nsx.model.idfw_nsgroup_vm_detail_list_result",
            com.vmware.nsx.model.StructDefinitions.idfwNsgroupVmDetailListResult);
        add(mapping,
            "com.vmware.nsx.model.idfw_standalone_hosts_switch_setting",
            com.vmware.nsx.model.StructDefinitions.idfwStandaloneHostsSwitchSetting);
        add(mapping,
            "com.vmware.nsx.model.idfw_system_stats",
            com.vmware.nsx.model.StructDefinitions.idfwSystemStats);
        add(mapping,
            "com.vmware.nsx.model.idfw_transport_node_condition",
            com.vmware.nsx.model.StructDefinitions.idfwTransportNodeCondition);
        add(mapping,
            "com.vmware.nsx.model.idfw_transport_node_status",
            com.vmware.nsx.model.StructDefinitions.idfwTransportNodeStatus);
        add(mapping,
            "com.vmware.nsx.model.idfw_transport_node_status_list_result",
            com.vmware.nsx.model.StructDefinitions.idfwTransportNodeStatusListResult);
        add(mapping,
            "com.vmware.nsx.model.idfw_user_session_data",
            com.vmware.nsx.model.StructDefinitions.idfwUserSessionData);
        add(mapping,
            "com.vmware.nsx.model.idfw_user_session_data_and_mappings",
            com.vmware.nsx.model.StructDefinitions.idfwUserSessionDataAndMappings);
        add(mapping,
            "com.vmware.nsx.model.idfw_user_stats",
            com.vmware.nsx.model.StructDefinitions.idfwUserStats);
        add(mapping,
            "com.vmware.nsx.model.idfw_virtual_machine_condition",
            com.vmware.nsx.model.StructDefinitions.idfwVirtualMachineCondition);
        add(mapping,
            "com.vmware.nsx.model.idfw_virtual_machine_status",
            com.vmware.nsx.model.StructDefinitions.idfwVirtualMachineStatus);
        add(mapping,
            "com.vmware.nsx.model.idfw_virtual_machine_status_list_result",
            com.vmware.nsx.model.StructDefinitions.idfwVirtualMachineStatusListResult);
        add(mapping,
            "com.vmware.nsx.model.idfw_vm_detail",
            com.vmware.nsx.model.StructDefinitions.idfwVmDetail);
        add(mapping,
            "com.vmware.nsx.model.idfw_vm_stats",
            com.vmware.nsx.model.StructDefinitions.idfwVmStats);
        add(mapping,
            "com.vmware.nsx.model.ids_event_flow_data",
            com.vmware.nsx.model.StructDefinitions.idsEventFlowData);
        add(mapping,
            "com.vmware.nsx.model.ids_global_config",
            com.vmware.nsx.model.StructDefinitions.idsGlobalConfig);
        add(mapping,
            "com.vmware.nsx.model.ids_user_list",
            com.vmware.nsx.model.StructDefinitions.idsUserList);
        add(mapping,
            "com.vmware.nsx.model.ids_user_stats",
            com.vmware.nsx.model.StructDefinitions.idsUserStats);
        add(mapping,
            "com.vmware.nsx.model.ids_vm_list",
            com.vmware.nsx.model.StructDefinitions.idsVmList);
        add(mapping,
            "com.vmware.nsx.model.ids_vm_stats",
            com.vmware.nsx.model.StructDefinitions.idsVmStats);
        add(mapping,
            "com.vmware.nsx.model.included_fields_parameters",
            com.vmware.nsx.model.StructDefinitions.includedFieldsParameters);
        add(mapping,
            "com.vmware.nsx.model.ingress_broadcast_rate_shaper",
            com.vmware.nsx.model.StructDefinitions.ingressBroadcastRateShaper);
        add(mapping,
            "com.vmware.nsx.model.ingress_rate_shaper",
            com.vmware.nsx.model.StructDefinitions.ingressRateShaper);
        add(mapping,
            "com.vmware.nsx.model.initiate_cluster_restore_request",
            com.vmware.nsx.model.StructDefinitions.initiateClusterRestoreRequest);
        add(mapping,
            "com.vmware.nsx.model.install_upgrade_service_properties",
            com.vmware.nsx.model.StructDefinitions.installUpgradeServiceProperties);
        add(mapping,
            "com.vmware.nsx.model.instance_deployment_config",
            com.vmware.nsx.model.StructDefinitions.instanceDeploymentConfig);
        add(mapping,
            "com.vmware.nsx.model.instance_endpoint",
            com.vmware.nsx.model.StructDefinitions.instanceEndpoint);
        add(mapping,
            "com.vmware.nsx.model.instance_endpoint_list_result",
            com.vmware.nsx.model.StructDefinitions.instanceEndpointListResult);
        add(mapping,
            "com.vmware.nsx.model.instance_runtime",
            com.vmware.nsx.model.StructDefinitions.instanceRuntime);
        add(mapping,
            "com.vmware.nsx.model.instance_runtime_list_result",
            com.vmware.nsx.model.StructDefinitions.instanceRuntimeListResult);
        add(mapping,
            "com.vmware.nsx.model.instruction_info",
            com.vmware.nsx.model.StructDefinitions.instructionInfo);
        add(mapping,
            "com.vmware.nsx.model.intelligence_broker_endpoint_info",
            com.vmware.nsx.model.StructDefinitions.intelligenceBrokerEndpointInfo);
        add(mapping,
            "com.vmware.nsx.model.intelligence_flow_private_ip_prefix_info",
            com.vmware.nsx.model.StructDefinitions.intelligenceFlowPrivateIpPrefixInfo);
        add(mapping,
            "com.vmware.nsx.model.intelligence_form_factor",
            com.vmware.nsx.model.StructDefinitions.intelligenceFormFactor);
        add(mapping,
            "com.vmware.nsx.model.intelligence_form_factors",
            com.vmware.nsx.model.StructDefinitions.intelligenceFormFactors);
        add(mapping,
            "com.vmware.nsx.model.intelligence_host_configuration_info",
            com.vmware.nsx.model.StructDefinitions.intelligenceHostConfigurationInfo);
        add(mapping,
            "com.vmware.nsx.model.inter_SR_routing_config",
            com.vmware.nsx.model.StructDefinitions.interSRRoutingConfig);
        add(mapping,
            "com.vmware.nsx.model.inter_site_bgp_summary",
            com.vmware.nsx.model.StructDefinitions.interSiteBgpSummary);
        add(mapping,
            "com.vmware.nsx.model.inter_site_port_counters",
            com.vmware.nsx.model.StructDefinitions.interSitePortCounters);
        add(mapping,
            "com.vmware.nsx.model.interface_igmp_local_group_config",
            com.vmware.nsx.model.StructDefinitions.interfaceIgmpLocalGroupConfig);
        add(mapping,
            "com.vmware.nsx.model.interface_neighbor_properties",
            com.vmware.nsx.model.StructDefinitions.interfaceNeighborProperties);
        add(mapping,
            "com.vmware.nsx.model.interface_neighbor_property_list_result",
            com.vmware.nsx.model.StructDefinitions.interfaceNeighborPropertyListResult);
        add(mapping,
            "com.vmware.nsx.model.interface_pim_config",
            com.vmware.nsx.model.StructDefinitions.interfacePimConfig);
        add(mapping,
            "com.vmware.nsx.model.interval_backup_schedule",
            com.vmware.nsx.model.StructDefinitions.intervalBackupSchedule);
        add(mapping,
            "com.vmware.nsx.model.interval_sampling",
            com.vmware.nsx.model.StructDefinitions.intervalSampling);
        add(mapping,
            "com.vmware.nsx.model.inventory_config",
            com.vmware.nsx.model.StructDefinitions.inventoryConfig);
        add(mapping,
            "com.vmware.nsx.model.ip_address_info",
            com.vmware.nsx.model.StructDefinitions.ipAddressInfo);
        add(mapping,
            "com.vmware.nsx.model.ip_allocation_base",
            com.vmware.nsx.model.StructDefinitions.ipAllocationBase);
        add(mapping,
            "com.vmware.nsx.model.ip_assignment_spec",
            com.vmware.nsx.model.StructDefinitions.ipAssignmentSpec);
        add(mapping,
            "com.vmware.nsx.model.ip_block",
            com.vmware.nsx.model.StructDefinitions.ipBlock);
        add(mapping,
            "com.vmware.nsx.model.ip_block_list_result",
            com.vmware.nsx.model.StructDefinitions.ipBlockListResult);
        add(mapping,
            "com.vmware.nsx.model.ip_block_subnet",
            com.vmware.nsx.model.StructDefinitions.ipBlockSubnet);
        add(mapping,
            "com.vmware.nsx.model.ip_block_subnet_list_result",
            com.vmware.nsx.model.StructDefinitions.ipBlockSubnetListResult);
        add(mapping,
            "com.vmware.nsx.model.ip_discovery_switching_profile",
            com.vmware.nsx.model.StructDefinitions.ipDiscoverySwitchingProfile);
        add(mapping,
            "com.vmware.nsx.model.ip_info",
            com.vmware.nsx.model.StructDefinitions.ipInfo);
        add(mapping,
            "com.vmware.nsx.model.ip_mac_pair",
            com.vmware.nsx.model.StructDefinitions.ipMacPair);
        add(mapping,
            "com.vmware.nsx.model.ip_pool",
            com.vmware.nsx.model.StructDefinitions.ipPool);
        add(mapping,
            "com.vmware.nsx.model.ip_pool_list_result",
            com.vmware.nsx.model.StructDefinitions.ipPoolListResult);
        add(mapping,
            "com.vmware.nsx.model.ip_pool_range",
            com.vmware.nsx.model.StructDefinitions.ipPoolRange);
        add(mapping,
            "com.vmware.nsx.model.ip_pool_subnet",
            com.vmware.nsx.model.StructDefinitions.ipPoolSubnet);
        add(mapping,
            "com.vmware.nsx.model.ipfix_collector",
            com.vmware.nsx.model.StructDefinitions.ipfixCollector);
        add(mapping,
            "com.vmware.nsx.model.ipfix_collector_config",
            com.vmware.nsx.model.StructDefinitions.ipfixCollectorConfig);
        add(mapping,
            "com.vmware.nsx.model.ipfix_collector_config_list_result",
            com.vmware.nsx.model.StructDefinitions.ipfixCollectorConfigListResult);
        add(mapping,
            "com.vmware.nsx.model.ipfix_collector_upm_profile",
            com.vmware.nsx.model.StructDefinitions.ipfixCollectorUpmProfile);
        add(mapping,
            "com.vmware.nsx.model.ipfix_collector_upm_profile_list_result",
            com.vmware.nsx.model.StructDefinitions.ipfixCollectorUpmProfileListResult);
        add(mapping,
            "com.vmware.nsx.model.ipfix_config",
            com.vmware.nsx.model.StructDefinitions.ipfixConfig);
        add(mapping,
            "com.vmware.nsx.model.ipfix_config_list_result",
            com.vmware.nsx.model.StructDefinitions.ipfixConfigListResult);
        add(mapping,
            "com.vmware.nsx.model.ipfix_dfw_config",
            com.vmware.nsx.model.StructDefinitions.ipfixDfwConfig);
        add(mapping,
            "com.vmware.nsx.model.ipfix_dfw_template_parameters",
            com.vmware.nsx.model.StructDefinitions.ipfixDfwTemplateParameters);
        add(mapping,
            "com.vmware.nsx.model.ipfix_service_association_list_result",
            com.vmware.nsx.model.StructDefinitions.ipfixServiceAssociationListResult);
        add(mapping,
            "com.vmware.nsx.model.ipfix_switch_upm_profile",
            com.vmware.nsx.model.StructDefinitions.ipfixSwitchUpmProfile);
        add(mapping,
            "com.vmware.nsx.model.ipfix_upm_profile",
            com.vmware.nsx.model.StructDefinitions.ipfixUpmProfile);
        add(mapping,
            "com.vmware.nsx.model.ipfix_upm_profile_list_result",
            com.vmware.nsx.model.StructDefinitions.ipfixUpmProfileListResult);
        add(mapping,
            "com.vmware.nsx.model.ipv4_header",
            com.vmware.nsx.model.StructDefinitions.ipv4Header);
        add(mapping,
            "com.vmware.nsx.model.ipv6_header",
            com.vmware.nsx.model.StructDefinitions.ipv6Header);
        add(mapping,
            "com.vmware.nsx.model.issuer_serial_number",
            com.vmware.nsx.model.StructDefinitions.issuerSerialNumber);
        add(mapping,
            "com.vmware.nsx.model.join_cluster_parameters",
            com.vmware.nsx.model.StructDefinitions.joinClusterParameters);
        add(mapping,
            "com.vmware.nsx.model.key_store_info",
            com.vmware.nsx.model.StructDefinitions.keyStoreInfo);
        add(mapping,
            "com.vmware.nsx.model.key_value",
            com.vmware.nsx.model.StructDefinitions.keyValue);
        add(mapping,
            "com.vmware.nsx.model.key_value_pair",
            com.vmware.nsx.model.StructDefinitions.keyValuePair);
        add(mapping,
            "com.vmware.nsx.model.known_host_parameter",
            com.vmware.nsx.model.StructDefinitions.knownHostParameter);
        add(mapping,
            "com.vmware.nsx.model.l2_forwarder_remote_macs",
            com.vmware.nsx.model.StructDefinitions.l2ForwarderRemoteMacs);
        add(mapping,
            "com.vmware.nsx.model.l2_forwarder_remote_macs_per_site",
            com.vmware.nsx.model.StructDefinitions.l2ForwarderRemoteMacsPerSite);
        add(mapping,
            "com.vmware.nsx.model.l2_forwarder_statistics",
            com.vmware.nsx.model.StructDefinitions.l2ForwarderStatistics);
        add(mapping,
            "com.vmware.nsx.model.l2_forwarder_status",
            com.vmware.nsx.model.StructDefinitions.l2ForwarderStatus);
        add(mapping,
            "com.vmware.nsx.model.l2_forwarder_status_per_node",
            com.vmware.nsx.model.StructDefinitions.l2ForwarderStatusPerNode);
        add(mapping,
            "com.vmware.nsx.model.l2_VPN_per_LS_traffic_statistics",
            com.vmware.nsx.model.StructDefinitions.l2VPNPerLSTrafficStatistics);
        add(mapping,
            "com.vmware.nsx.model.l2_VPN_session_remote_macs",
            com.vmware.nsx.model.StructDefinitions.l2VPNSessionRemoteMacs);
        add(mapping,
            "com.vmware.nsx.model.l2_VPN_session_remote_macs_for_LS",
            com.vmware.nsx.model.StructDefinitions.l2VPNSessionRemoteMacsForLS);
        add(mapping,
            "com.vmware.nsx.model.l2_VPN_session_statistics",
            com.vmware.nsx.model.StructDefinitions.l2VPNSessionStatistics);
        add(mapping,
            "com.vmware.nsx.model.l2_VPN_session_status",
            com.vmware.nsx.model.StructDefinitions.l2VPNSessionStatus);
        add(mapping,
            "com.vmware.nsx.model.l2_VPN_session_summary",
            com.vmware.nsx.model.StructDefinitions.l2VPNSessionSummary);
        add(mapping,
            "com.vmware.nsx.model.l2_VPN_tap_traffic_statistics",
            com.vmware.nsx.model.StructDefinitions.l2VPNTapTrafficStatistics);
        add(mapping,
            "com.vmware.nsx.model.l2_VPN_transport_tunnel_status",
            com.vmware.nsx.model.StructDefinitions.l2VPNTransportTunnelStatus);
        add(mapping,
            "com.vmware.nsx.model.l2_vpn_attachment_context",
            com.vmware.nsx.model.StructDefinitions.l2VpnAttachmentContext);
        add(mapping,
            "com.vmware.nsx.model.l2_vpn_service",
            com.vmware.nsx.model.StructDefinitions.l2VpnService);
        add(mapping,
            "com.vmware.nsx.model.l2_vpn_service_list_result",
            com.vmware.nsx.model.StructDefinitions.l2VpnServiceListResult);
        add(mapping,
            "com.vmware.nsx.model.l2_vpn_session",
            com.vmware.nsx.model.StructDefinitions.l2VpnSession);
        add(mapping,
            "com.vmware.nsx.model.l2_vpn_session_list_result",
            com.vmware.nsx.model.StructDefinitions.l2VpnSessionListResult);
        add(mapping,
            "com.vmware.nsx.model.l2_vpn_session_peer_codes",
            com.vmware.nsx.model.StructDefinitions.l2VpnSessionPeerCodes);
        add(mapping,
            "com.vmware.nsx.model.l2_vpn_tcp_mss_clamping",
            com.vmware.nsx.model.StructDefinitions.l2VpnTcpMssClamping);
        add(mapping,
            "com.vmware.nsx.model.l2_vpn_tunnel_encapsulation",
            com.vmware.nsx.model.StructDefinitions.l2VpnTunnelEncapsulation);
        add(mapping,
            "com.vmware.nsx.model.l2_vpn_tunnel_peer_code",
            com.vmware.nsx.model.StructDefinitions.l2VpnTunnelPeerCode);
        add(mapping,
            "com.vmware.nsx.model.l4_port_set_NS_service",
            com.vmware.nsx.model.StructDefinitions.l4PortSetNSService);
        add(mapping,
            "com.vmware.nsx.model.label",
            com.vmware.nsx.model.StructDefinitions.label);
        add(mapping,
            "com.vmware.nsx.model.label_value_configuration",
            com.vmware.nsx.model.StructDefinitions.labelValueConfiguration);
        add(mapping,
            "com.vmware.nsx.model.lacp_group_config_info",
            com.vmware.nsx.model.StructDefinitions.lacpGroupConfigInfo);
        add(mapping,
            "com.vmware.nsx.model.lag",
            com.vmware.nsx.model.StructDefinitions.lag);
        add(mapping,
            "com.vmware.nsx.model.latency_stat_profile",
            com.vmware.nsx.model.StructDefinitions.latencyStatProfile);
        add(mapping,
            "com.vmware.nsx.model.latency_stat_profile_list_result",
            com.vmware.nsx.model.StructDefinitions.latencyStatProfileListResult);
        add(mapping,
            "com.vmware.nsx.model.layout",
            com.vmware.nsx.model.StructDefinitions.layout);
        add(mapping,
            "com.vmware.nsx.model.layout_properties",
            com.vmware.nsx.model.StructDefinitions.layoutProperties);
        add(mapping,
            "com.vmware.nsx.model.lb_access_list_control",
            com.vmware.nsx.model.StructDefinitions.lbAccessListControl);
        add(mapping,
            "com.vmware.nsx.model.lb_active_monitor",
            com.vmware.nsx.model.StructDefinitions.lbActiveMonitor);
        add(mapping,
            "com.vmware.nsx.model.lb_app_profile",
            com.vmware.nsx.model.StructDefinitions.lbAppProfile);
        add(mapping,
            "com.vmware.nsx.model.lb_app_profile_list_result",
            com.vmware.nsx.model.StructDefinitions.lbAppProfileListResult);
        add(mapping,
            "com.vmware.nsx.model.lb_client_certificate_issuer_dn_condition",
            com.vmware.nsx.model.StructDefinitions.lbClientCertificateIssuerDnCondition);
        add(mapping,
            "com.vmware.nsx.model.lb_client_certificate_subject_dn_condition",
            com.vmware.nsx.model.StructDefinitions.lbClientCertificateSubjectDnCondition);
        add(mapping,
            "com.vmware.nsx.model.lb_client_ssl_profile",
            com.vmware.nsx.model.StructDefinitions.lbClientSslProfile);
        add(mapping,
            "com.vmware.nsx.model.lb_client_ssl_profile_list_result",
            com.vmware.nsx.model.StructDefinitions.lbClientSslProfileListResult);
        add(mapping,
            "com.vmware.nsx.model.lb_connection_drop_action",
            com.vmware.nsx.model.StructDefinitions.lbConnectionDropAction);
        add(mapping,
            "com.vmware.nsx.model.lb_cookie_persistence_profile",
            com.vmware.nsx.model.StructDefinitions.lbCookiePersistenceProfile);
        add(mapping,
            "com.vmware.nsx.model.lb_cookie_time",
            com.vmware.nsx.model.StructDefinitions.lbCookieTime);
        add(mapping,
            "com.vmware.nsx.model.lb_edge_node_usage",
            com.vmware.nsx.model.StructDefinitions.lbEdgeNodeUsage);
        add(mapping,
            "com.vmware.nsx.model.lb_fast_tcp_profile",
            com.vmware.nsx.model.StructDefinitions.lbFastTcpProfile);
        add(mapping,
            "com.vmware.nsx.model.lb_fast_udp_profile",
            com.vmware.nsx.model.StructDefinitions.lbFastUdpProfile);
        add(mapping,
            "com.vmware.nsx.model.lb_generic_persistence_profile",
            com.vmware.nsx.model.StructDefinitions.lbGenericPersistenceProfile);
        add(mapping,
            "com.vmware.nsx.model.lb_http_monitor",
            com.vmware.nsx.model.StructDefinitions.lbHttpMonitor);
        add(mapping,
            "com.vmware.nsx.model.lb_http_profile",
            com.vmware.nsx.model.StructDefinitions.lbHttpProfile);
        add(mapping,
            "com.vmware.nsx.model.lb_http_redirect_action",
            com.vmware.nsx.model.StructDefinitions.lbHttpRedirectAction);
        add(mapping,
            "com.vmware.nsx.model.lb_http_reject_action",
            com.vmware.nsx.model.StructDefinitions.lbHttpRejectAction);
        add(mapping,
            "com.vmware.nsx.model.lb_http_request_body_condition",
            com.vmware.nsx.model.StructDefinitions.lbHttpRequestBodyCondition);
        add(mapping,
            "com.vmware.nsx.model.lb_http_request_cookie_condition",
            com.vmware.nsx.model.StructDefinitions.lbHttpRequestCookieCondition);
        add(mapping,
            "com.vmware.nsx.model.lb_http_request_header",
            com.vmware.nsx.model.StructDefinitions.lbHttpRequestHeader);
        add(mapping,
            "com.vmware.nsx.model.lb_http_request_header_condition",
            com.vmware.nsx.model.StructDefinitions.lbHttpRequestHeaderCondition);
        add(mapping,
            "com.vmware.nsx.model.lb_http_request_header_delete_action",
            com.vmware.nsx.model.StructDefinitions.lbHttpRequestHeaderDeleteAction);
        add(mapping,
            "com.vmware.nsx.model.lb_http_request_header_rewrite_action",
            com.vmware.nsx.model.StructDefinitions.lbHttpRequestHeaderRewriteAction);
        add(mapping,
            "com.vmware.nsx.model.lb_http_request_method_condition",
            com.vmware.nsx.model.StructDefinitions.lbHttpRequestMethodCondition);
        add(mapping,
            "com.vmware.nsx.model.lb_http_request_uri_arguments_condition",
            com.vmware.nsx.model.StructDefinitions.lbHttpRequestUriArgumentsCondition);
        add(mapping,
            "com.vmware.nsx.model.lb_http_request_uri_condition",
            com.vmware.nsx.model.StructDefinitions.lbHttpRequestUriCondition);
        add(mapping,
            "com.vmware.nsx.model.lb_http_request_uri_rewrite_action",
            com.vmware.nsx.model.StructDefinitions.lbHttpRequestUriRewriteAction);
        add(mapping,
            "com.vmware.nsx.model.lb_http_request_version_condition",
            com.vmware.nsx.model.StructDefinitions.lbHttpRequestVersionCondition);
        add(mapping,
            "com.vmware.nsx.model.lb_http_response_header_condition",
            com.vmware.nsx.model.StructDefinitions.lbHttpResponseHeaderCondition);
        add(mapping,
            "com.vmware.nsx.model.lb_http_response_header_delete_action",
            com.vmware.nsx.model.StructDefinitions.lbHttpResponseHeaderDeleteAction);
        add(mapping,
            "com.vmware.nsx.model.lb_http_response_header_rewrite_action",
            com.vmware.nsx.model.StructDefinitions.lbHttpResponseHeaderRewriteAction);
        add(mapping,
            "com.vmware.nsx.model.lb_http_ssl_condition",
            com.vmware.nsx.model.StructDefinitions.lbHttpSslCondition);
        add(mapping,
            "com.vmware.nsx.model.lb_https_monitor",
            com.vmware.nsx.model.StructDefinitions.lbHttpsMonitor);
        add(mapping,
            "com.vmware.nsx.model.lb_icmp_monitor",
            com.vmware.nsx.model.StructDefinitions.lbIcmpMonitor);
        add(mapping,
            "com.vmware.nsx.model.lb_ip_header_condition",
            com.vmware.nsx.model.StructDefinitions.lbIpHeaderCondition);
        add(mapping,
            "com.vmware.nsx.model.lb_jwt_auth_action",
            com.vmware.nsx.model.StructDefinitions.lbJwtAuthAction);
        add(mapping,
            "com.vmware.nsx.model.lb_jwt_certificate_key",
            com.vmware.nsx.model.StructDefinitions.lbJwtCertificateKey);
        add(mapping,
            "com.vmware.nsx.model.lb_jwt_key",
            com.vmware.nsx.model.StructDefinitions.lbJwtKey);
        add(mapping,
            "com.vmware.nsx.model.lb_jwt_public_key",
            com.vmware.nsx.model.StructDefinitions.lbJwtPublicKey);
        add(mapping,
            "com.vmware.nsx.model.lb_jwt_symmetric_key",
            com.vmware.nsx.model.StructDefinitions.lbJwtSymmetricKey);
        add(mapping,
            "com.vmware.nsx.model.lb_monitor",
            com.vmware.nsx.model.StructDefinitions.lbMonitor);
        add(mapping,
            "com.vmware.nsx.model.lb_monitor_list_result",
            com.vmware.nsx.model.StructDefinitions.lbMonitorListResult);
        add(mapping,
            "com.vmware.nsx.model.lb_node_count_per_severity",
            com.vmware.nsx.model.StructDefinitions.lbNodeCountPerSeverity);
        add(mapping,
            "com.vmware.nsx.model.lb_node_usage",
            com.vmware.nsx.model.StructDefinitions.lbNodeUsage);
        add(mapping,
            "com.vmware.nsx.model.lb_node_usage_summary",
            com.vmware.nsx.model.StructDefinitions.lbNodeUsageSummary);
        add(mapping,
            "com.vmware.nsx.model.lb_passive_monitor",
            com.vmware.nsx.model.StructDefinitions.lbPassiveMonitor);
        add(mapping,
            "com.vmware.nsx.model.lb_persistence_cookie_time",
            com.vmware.nsx.model.StructDefinitions.lbPersistenceCookieTime);
        add(mapping,
            "com.vmware.nsx.model.lb_persistence_profile",
            com.vmware.nsx.model.StructDefinitions.lbPersistenceProfile);
        add(mapping,
            "com.vmware.nsx.model.lb_persistence_profile_list_result",
            com.vmware.nsx.model.StructDefinitions.lbPersistenceProfileListResult);
        add(mapping,
            "com.vmware.nsx.model.lb_pool",
            com.vmware.nsx.model.StructDefinitions.lbPool);
        add(mapping,
            "com.vmware.nsx.model.lb_pool_list_result",
            com.vmware.nsx.model.StructDefinitions.lbPoolListResult);
        add(mapping,
            "com.vmware.nsx.model.lb_pool_member_statistics",
            com.vmware.nsx.model.StructDefinitions.lbPoolMemberStatistics);
        add(mapping,
            "com.vmware.nsx.model.lb_pool_member_status",
            com.vmware.nsx.model.StructDefinitions.lbPoolMemberStatus);
        add(mapping,
            "com.vmware.nsx.model.lb_pool_statistics",
            com.vmware.nsx.model.StructDefinitions.lbPoolStatistics);
        add(mapping,
            "com.vmware.nsx.model.lb_pool_statistics_list_result",
            com.vmware.nsx.model.StructDefinitions.lbPoolStatisticsListResult);
        add(mapping,
            "com.vmware.nsx.model.lb_pool_status",
            com.vmware.nsx.model.StructDefinitions.lbPoolStatus);
        add(mapping,
            "com.vmware.nsx.model.lb_pool_status_list_result",
            com.vmware.nsx.model.StructDefinitions.lbPoolStatusListResult);
        add(mapping,
            "com.vmware.nsx.model.lb_rule",
            com.vmware.nsx.model.StructDefinitions.lbRule);
        add(mapping,
            "com.vmware.nsx.model.lb_rule_action",
            com.vmware.nsx.model.StructDefinitions.lbRuleAction);
        add(mapping,
            "com.vmware.nsx.model.lb_rule_condition",
            com.vmware.nsx.model.StructDefinitions.lbRuleCondition);
        add(mapping,
            "com.vmware.nsx.model.lb_rule_list_result",
            com.vmware.nsx.model.StructDefinitions.lbRuleListResult);
        add(mapping,
            "com.vmware.nsx.model.lb_select_pool_action",
            com.vmware.nsx.model.StructDefinitions.lbSelectPoolAction);
        add(mapping,
            "com.vmware.nsx.model.lb_server_ssl_profile",
            com.vmware.nsx.model.StructDefinitions.lbServerSslProfile);
        add(mapping,
            "com.vmware.nsx.model.lb_server_ssl_profile_list_result",
            com.vmware.nsx.model.StructDefinitions.lbServerSslProfileListResult);
        add(mapping,
            "com.vmware.nsx.model.lb_service",
            com.vmware.nsx.model.StructDefinitions.lbService);
        add(mapping,
            "com.vmware.nsx.model.lb_service_debug_info",
            com.vmware.nsx.model.StructDefinitions.lbServiceDebugInfo);
        add(mapping,
            "com.vmware.nsx.model.lb_service_instance_detail",
            com.vmware.nsx.model.StructDefinitions.lbServiceInstanceDetail);
        add(mapping,
            "com.vmware.nsx.model.lb_service_instance_detail_per_status",
            com.vmware.nsx.model.StructDefinitions.lbServiceInstanceDetailPerStatus);
        add(mapping,
            "com.vmware.nsx.model.lb_service_instance_detail_per_transport_node",
            com.vmware.nsx.model.StructDefinitions.lbServiceInstanceDetailPerTransportNode);
        add(mapping,
            "com.vmware.nsx.model.lb_service_list_result",
            com.vmware.nsx.model.StructDefinitions.lbServiceListResult);
        add(mapping,
            "com.vmware.nsx.model.lb_service_statistics",
            com.vmware.nsx.model.StructDefinitions.lbServiceStatistics);
        add(mapping,
            "com.vmware.nsx.model.lb_service_statistics_counter",
            com.vmware.nsx.model.StructDefinitions.lbServiceStatisticsCounter);
        add(mapping,
            "com.vmware.nsx.model.lb_service_status",
            com.vmware.nsx.model.StructDefinitions.lbServiceStatus);
        add(mapping,
            "com.vmware.nsx.model.lb_service_usage",
            com.vmware.nsx.model.StructDefinitions.lbServiceUsage);
        add(mapping,
            "com.vmware.nsx.model.lb_session_cookie_time",
            com.vmware.nsx.model.StructDefinitions.lbSessionCookieTime);
        add(mapping,
            "com.vmware.nsx.model.lb_snat_auto_map",
            com.vmware.nsx.model.StructDefinitions.lbSnatAutoMap);
        add(mapping,
            "com.vmware.nsx.model.lb_snat_ip_element",
            com.vmware.nsx.model.StructDefinitions.lbSnatIpElement);
        add(mapping,
            "com.vmware.nsx.model.lb_snat_ip_pool",
            com.vmware.nsx.model.StructDefinitions.lbSnatIpPool);
        add(mapping,
            "com.vmware.nsx.model.lb_snat_translation",
            com.vmware.nsx.model.StructDefinitions.lbSnatTranslation);
        add(mapping,
            "com.vmware.nsx.model.lb_source_ip_persistence_profile",
            com.vmware.nsx.model.StructDefinitions.lbSourceIpPersistenceProfile);
        add(mapping,
            "com.vmware.nsx.model.lb_ssl_cipher_and_protocol_list_result",
            com.vmware.nsx.model.StructDefinitions.lbSslCipherAndProtocolListResult);
        add(mapping,
            "com.vmware.nsx.model.lb_ssl_cipher_info",
            com.vmware.nsx.model.StructDefinitions.lbSslCipherInfo);
        add(mapping,
            "com.vmware.nsx.model.lb_ssl_mode_selection_action",
            com.vmware.nsx.model.StructDefinitions.lbSslModeSelectionAction);
        add(mapping,
            "com.vmware.nsx.model.lb_ssl_profile",
            com.vmware.nsx.model.StructDefinitions.lbSslProfile);
        add(mapping,
            "com.vmware.nsx.model.lb_ssl_protocol_info",
            com.vmware.nsx.model.StructDefinitions.lbSslProtocolInfo);
        add(mapping,
            "com.vmware.nsx.model.lb_ssl_sni_condition",
            com.vmware.nsx.model.StructDefinitions.lbSslSniCondition);
        add(mapping,
            "com.vmware.nsx.model.lb_statistics_counter",
            com.vmware.nsx.model.StructDefinitions.lbStatisticsCounter);
        add(mapping,
            "com.vmware.nsx.model.lb_tcp_header_condition",
            com.vmware.nsx.model.StructDefinitions.lbTcpHeaderCondition);
        add(mapping,
            "com.vmware.nsx.model.lb_tcp_monitor",
            com.vmware.nsx.model.StructDefinitions.lbTcpMonitor);
        add(mapping,
            "com.vmware.nsx.model.lb_udp_monitor",
            com.vmware.nsx.model.StructDefinitions.lbUdpMonitor);
        add(mapping,
            "com.vmware.nsx.model.lb_variable_assignment_action",
            com.vmware.nsx.model.StructDefinitions.lbVariableAssignmentAction);
        add(mapping,
            "com.vmware.nsx.model.lb_variable_condition",
            com.vmware.nsx.model.StructDefinitions.lbVariableCondition);
        add(mapping,
            "com.vmware.nsx.model.lb_variable_persistence_learn_action",
            com.vmware.nsx.model.StructDefinitions.lbVariablePersistenceLearnAction);
        add(mapping,
            "com.vmware.nsx.model.lb_variable_persistence_on_action",
            com.vmware.nsx.model.StructDefinitions.lbVariablePersistenceOnAction);
        add(mapping,
            "com.vmware.nsx.model.lb_virtual_server",
            com.vmware.nsx.model.StructDefinitions.lbVirtualServer);
        add(mapping,
            "com.vmware.nsx.model.lb_virtual_server_list_result",
            com.vmware.nsx.model.StructDefinitions.lbVirtualServerListResult);
        add(mapping,
            "com.vmware.nsx.model.lb_virtual_server_statistics",
            com.vmware.nsx.model.StructDefinitions.lbVirtualServerStatistics);
        add(mapping,
            "com.vmware.nsx.model.lb_virtual_server_statistics_list_result",
            com.vmware.nsx.model.StructDefinitions.lbVirtualServerStatisticsListResult);
        add(mapping,
            "com.vmware.nsx.model.lb_virtual_server_status",
            com.vmware.nsx.model.StructDefinitions.lbVirtualServerStatus);
        add(mapping,
            "com.vmware.nsx.model.lb_virtual_server_status_list_result",
            com.vmware.nsx.model.StructDefinitions.lbVirtualServerStatusListResult);
        add(mapping,
            "com.vmware.nsx.model.lb_virtual_server_with_rule",
            com.vmware.nsx.model.StructDefinitions.lbVirtualServerWithRule);
        add(mapping,
            "com.vmware.nsx.model.legend",
            com.vmware.nsx.model.StructDefinitions.legend);
        add(mapping,
            "com.vmware.nsx.model.legend_widget_configuration",
            com.vmware.nsx.model.StructDefinitions.legendWidgetConfiguration);
        add(mapping,
            "com.vmware.nsx.model.license",
            com.vmware.nsx.model.StructDefinitions.license);
        add(mapping,
            "com.vmware.nsx.model.license_offer",
            com.vmware.nsx.model.StructDefinitions.licenseOffer);
        add(mapping,
            "com.vmware.nsx.model.licenses_list_result",
            com.vmware.nsx.model.StructDefinitions.licensesListResult);
        add(mapping,
            "com.vmware.nsx.model.line_chart_plot_configuration",
            com.vmware.nsx.model.StructDefinitions.lineChartPlotConfiguration);
        add(mapping,
            "com.vmware.nsx.model.list_result",
            com.vmware.nsx.model.StructDefinitions.listResult);
        add(mapping,
            "com.vmware.nsx.model.list_result_query_parameters",
            com.vmware.nsx.model.StructDefinitions.listResultQueryParameters);
        add(mapping,
            "com.vmware.nsx.model.live_trace_action_config",
            com.vmware.nsx.model.StructDefinitions.liveTraceActionConfig);
        add(mapping,
            "com.vmware.nsx.model.live_trace_filter_data",
            com.vmware.nsx.model.StructDefinitions.liveTraceFilterData);
        add(mapping,
            "com.vmware.nsx.model.live_trace_filter_invalid_info",
            com.vmware.nsx.model.StructDefinitions.liveTraceFilterInvalidInfo);
        add(mapping,
            "com.vmware.nsx.model.live_trace_ipsec_vpn_config",
            com.vmware.nsx.model.StructDefinitions.liveTraceIpsecVpnConfig);
        add(mapping,
            "com.vmware.nsx.model.live_trace_list_result",
            com.vmware.nsx.model.StructDefinitions.liveTraceListResult);
        add(mapping,
            "com.vmware.nsx.model.live_trace_request",
            com.vmware.nsx.model.StructDefinitions.liveTraceRequest);
        add(mapping,
            "com.vmware.nsx.model.live_trace_result",
            com.vmware.nsx.model.StructDefinitions.liveTraceResult);
        add(mapping,
            "com.vmware.nsx.model.live_trace_status",
            com.vmware.nsx.model.StructDefinitions.liveTraceStatus);
        add(mapping,
            "com.vmware.nsx.model.lldp_host_switch_profile",
            com.vmware.nsx.model.StructDefinitions.lldpHostSwitchProfile);
        add(mapping,
            "com.vmware.nsx.model.load_balancer_allocation_pool",
            com.vmware.nsx.model.StructDefinitions.loadBalancerAllocationPool);
        add(mapping,
            "com.vmware.nsx.model.local_site_configuration",
            com.vmware.nsx.model.StructDefinitions.localSiteConfiguration);
        add(mapping,
            "com.vmware.nsx.model.logging_service_properties",
            com.vmware.nsx.model.StructDefinitions.loggingServiceProperties);
        add(mapping,
            "com.vmware.nsx.model.logical_construct_migration_stats",
            com.vmware.nsx.model.StructDefinitions.logicalConstructMigrationStats);
        add(mapping,
            "com.vmware.nsx.model.logical_construct_migration_stats_list_result",
            com.vmware.nsx.model.StructDefinitions.logicalConstructMigrationStatsListResult);
        add(mapping,
            "com.vmware.nsx.model.logical_dhcp_server",
            com.vmware.nsx.model.StructDefinitions.logicalDhcpServer);
        add(mapping,
            "com.vmware.nsx.model.logical_dhcp_server_list_result",
            com.vmware.nsx.model.StructDefinitions.logicalDhcpServerListResult);
        add(mapping,
            "com.vmware.nsx.model.logical_port",
            com.vmware.nsx.model.StructDefinitions.logicalPort);
        add(mapping,
            "com.vmware.nsx.model.logical_port_attachment",
            com.vmware.nsx.model.StructDefinitions.logicalPortAttachment);
        add(mapping,
            "com.vmware.nsx.model.logical_port_attachment_state",
            com.vmware.nsx.model.StructDefinitions.logicalPortAttachmentState);
        add(mapping,
            "com.vmware.nsx.model.logical_port_list_result",
            com.vmware.nsx.model.StructDefinitions.logicalPortListResult);
        add(mapping,
            "com.vmware.nsx.model.logical_port_mac_address_csv_list_result",
            com.vmware.nsx.model.StructDefinitions.logicalPortMacAddressCsvListResult);
        add(mapping,
            "com.vmware.nsx.model.logical_port_mac_address_list_result",
            com.vmware.nsx.model.StructDefinitions.logicalPortMacAddressListResult);
        add(mapping,
            "com.vmware.nsx.model.logical_port_mac_table_csv_entry",
            com.vmware.nsx.model.StructDefinitions.logicalPortMacTableCsvEntry);
        add(mapping,
            "com.vmware.nsx.model.logical_port_mac_table_entry",
            com.vmware.nsx.model.StructDefinitions.logicalPortMacTableEntry);
        add(mapping,
            "com.vmware.nsx.model.logical_port_mirror_destination",
            com.vmware.nsx.model.StructDefinitions.logicalPortMirrorDestination);
        add(mapping,
            "com.vmware.nsx.model.logical_port_mirror_source",
            com.vmware.nsx.model.StructDefinitions.logicalPortMirrorSource);
        add(mapping,
            "com.vmware.nsx.model.logical_port_operational_status",
            com.vmware.nsx.model.StructDefinitions.logicalPortOperationalStatus);
        add(mapping,
            "com.vmware.nsx.model.logical_port_state",
            com.vmware.nsx.model.StructDefinitions.logicalPortState);
        add(mapping,
            "com.vmware.nsx.model.logical_port_statistics",
            com.vmware.nsx.model.StructDefinitions.logicalPortStatistics);
        add(mapping,
            "com.vmware.nsx.model.logical_port_status_summary",
            com.vmware.nsx.model.StructDefinitions.logicalPortStatusSummary);
        add(mapping,
            "com.vmware.nsx.model.logical_router",
            com.vmware.nsx.model.StructDefinitions.logicalRouter);
        add(mapping,
            "com.vmware.nsx.model.logical_router_centralized_service_port",
            com.vmware.nsx.model.StructDefinitions.logicalRouterCentralizedServicePort);
        add(mapping,
            "com.vmware.nsx.model.logical_router_config",
            com.vmware.nsx.model.StructDefinitions.logicalRouterConfig);
        add(mapping,
            "com.vmware.nsx.model.logical_router_down_link_port",
            com.vmware.nsx.model.StructDefinitions.logicalRouterDownLinkPort);
        add(mapping,
            "com.vmware.nsx.model.logical_router_IP_tunnel_port",
            com.vmware.nsx.model.StructDefinitions.logicalRouterIPTunnelPort);
        add(mapping,
            "com.vmware.nsx.model.logical_router_link_port_on_TIE_r0",
            com.vmware.nsx.model.StructDefinitions.logicalRouterLinkPortOnTIER0);
        add(mapping,
            "com.vmware.nsx.model.logical_router_link_port_on_TIE_r1",
            com.vmware.nsx.model.StructDefinitions.logicalRouterLinkPortOnTIER1);
        add(mapping,
            "com.vmware.nsx.model.logical_router_list_result",
            com.vmware.nsx.model.StructDefinitions.logicalRouterListResult);
        add(mapping,
            "com.vmware.nsx.model.logical_router_loopback_port",
            com.vmware.nsx.model.StructDefinitions.logicalRouterLoopbackPort);
        add(mapping,
            "com.vmware.nsx.model.logical_router_port",
            com.vmware.nsx.model.StructDefinitions.logicalRouterPort);
        add(mapping,
            "com.vmware.nsx.model.logical_router_port_arp_csv_record",
            com.vmware.nsx.model.StructDefinitions.logicalRouterPortArpCsvRecord);
        add(mapping,
            "com.vmware.nsx.model.logical_router_port_arp_entry",
            com.vmware.nsx.model.StructDefinitions.logicalRouterPortArpEntry);
        add(mapping,
            "com.vmware.nsx.model.logical_router_port_arp_table",
            com.vmware.nsx.model.StructDefinitions.logicalRouterPortArpTable);
        add(mapping,
            "com.vmware.nsx.model.logical_router_port_arp_table_in_csv_format",
            com.vmware.nsx.model.StructDefinitions.logicalRouterPortArpTableInCsvFormat);
        add(mapping,
            "com.vmware.nsx.model.logical_router_port_counters",
            com.vmware.nsx.model.StructDefinitions.logicalRouterPortCounters);
        add(mapping,
            "com.vmware.nsx.model.logical_router_port_list_result",
            com.vmware.nsx.model.StructDefinitions.logicalRouterPortListResult);
        add(mapping,
            "com.vmware.nsx.model.logical_router_port_state",
            com.vmware.nsx.model.StructDefinitions.logicalRouterPortState);
        add(mapping,
            "com.vmware.nsx.model.logical_router_port_statistics",
            com.vmware.nsx.model.StructDefinitions.logicalRouterPortStatistics);
        add(mapping,
            "com.vmware.nsx.model.logical_router_port_statistics_per_node",
            com.vmware.nsx.model.StructDefinitions.logicalRouterPortStatisticsPerNode);
        add(mapping,
            "com.vmware.nsx.model.logical_router_port_statistics_summary",
            com.vmware.nsx.model.StructDefinitions.logicalRouterPortStatisticsSummary);
        add(mapping,
            "com.vmware.nsx.model.logical_router_route_csv_record",
            com.vmware.nsx.model.StructDefinitions.logicalRouterRouteCsvRecord);
        add(mapping,
            "com.vmware.nsx.model.logical_router_route_entry",
            com.vmware.nsx.model.StructDefinitions.logicalRouterRouteEntry);
        add(mapping,
            "com.vmware.nsx.model.logical_router_route_table",
            com.vmware.nsx.model.StructDefinitions.logicalRouterRouteTable);
        add(mapping,
            "com.vmware.nsx.model.logical_router_route_table_in_csv_format",
            com.vmware.nsx.model.StructDefinitions.logicalRouterRouteTableInCsvFormat);
        add(mapping,
            "com.vmware.nsx.model.logical_router_state",
            com.vmware.nsx.model.StructDefinitions.logicalRouterState);
        add(mapping,
            "com.vmware.nsx.model.logical_router_status",
            com.vmware.nsx.model.StructDefinitions.logicalRouterStatus);
        add(mapping,
            "com.vmware.nsx.model.logical_router_status_per_node",
            com.vmware.nsx.model.StructDefinitions.logicalRouterStatusPerNode);
        add(mapping,
            "com.vmware.nsx.model.logical_router_up_link_port",
            com.vmware.nsx.model.StructDefinitions.logicalRouterUpLinkPort);
        add(mapping,
            "com.vmware.nsx.model.logical_service_router_cluster_state",
            com.vmware.nsx.model.StructDefinitions.logicalServiceRouterClusterState);
        add(mapping,
            "com.vmware.nsx.model.logical_switch",
            com.vmware.nsx.model.StructDefinitions.logicalSwitch);
        add(mapping,
            "com.vmware.nsx.model.logical_switch_list_result",
            com.vmware.nsx.model.StructDefinitions.logicalSwitchListResult);
        add(mapping,
            "com.vmware.nsx.model.logical_switch_mirror_source",
            com.vmware.nsx.model.StructDefinitions.logicalSwitchMirrorSource);
        add(mapping,
            "com.vmware.nsx.model.logical_switch_state",
            com.vmware.nsx.model.StructDefinitions.logicalSwitchState);
        add(mapping,
            "com.vmware.nsx.model.logical_switch_state_list_result",
            com.vmware.nsx.model.StructDefinitions.logicalSwitchStateListResult);
        add(mapping,
            "com.vmware.nsx.model.logical_switch_statistics",
            com.vmware.nsx.model.StructDefinitions.logicalSwitchStatistics);
        add(mapping,
            "com.vmware.nsx.model.logical_switch_status",
            com.vmware.nsx.model.StructDefinitions.logicalSwitchStatus);
        add(mapping,
            "com.vmware.nsx.model.logical_switch_status_summary",
            com.vmware.nsx.model.StructDefinitions.logicalSwitchStatusSummary);
        add(mapping,
            "com.vmware.nsx.model.login_credential",
            com.vmware.nsx.model.StructDefinitions.loginCredential);
        add(mapping,
            "com.vmware.nsx.model.ls_id_to_vm_and_vnics_mapping",
            com.vmware.nsx.model.StructDefinitions.lsIdToVmAndVnicsMapping);
        add(mapping,
            "com.vmware.nsx.model.MAC_address_element",
            com.vmware.nsx.model.StructDefinitions.MACAddressElement);
        add(mapping,
            "com.vmware.nsx.model.MAC_address_element_list_result",
            com.vmware.nsx.model.StructDefinitions.MACAddressElementListResult);
        add(mapping,
            "com.vmware.nsx.model.MAC_set",
            com.vmware.nsx.model.StructDefinitions.MACSet);
        add(mapping,
            "com.vmware.nsx.model.MAC_set_list_result",
            com.vmware.nsx.model.StructDefinitions.MACSetListResult);
        add(mapping,
            "com.vmware.nsx.model.MPA_config_properties",
            com.vmware.nsx.model.StructDefinitions.MPAConfigProperties);
        add(mapping,
            "com.vmware.nsx.model.MP_policy_promotion_history",
            com.vmware.nsx.model.StructDefinitions.MPPolicyPromotionHistory);
        add(mapping,
            "com.vmware.nsx.model.MP_policy_promotion_history_list",
            com.vmware.nsx.model.StructDefinitions.MPPolicyPromotionHistoryList);
        add(mapping,
            "com.vmware.nsx.model.MP_policy_promotion_state",
            com.vmware.nsx.model.StructDefinitions.MPPolicyPromotionState);
        add(mapping,
            "com.vmware.nsx.model.MP_resource",
            com.vmware.nsx.model.StructDefinitions.MPResource);
        add(mapping,
            "com.vmware.nsx.model.MP_resource_details",
            com.vmware.nsx.model.StructDefinitions.MPResourceDetails);
        add(mapping,
            "com.vmware.nsx.model.MP_resource_linked_details",
            com.vmware.nsx.model.StructDefinitions.MPResourceLinkedDetails);
        add(mapping,
            "com.vmware.nsx.model.MP_resource_metadata",
            com.vmware.nsx.model.StructDefinitions.MPResourceMetadata);
        add(mapping,
            "com.vmware.nsx.model.mac_address_csv_list_result",
            com.vmware.nsx.model.StructDefinitions.macAddressCsvListResult);
        add(mapping,
            "com.vmware.nsx.model.mac_address_list_result",
            com.vmware.nsx.model.StructDefinitions.macAddressListResult);
        add(mapping,
            "com.vmware.nsx.model.mac_learning_counters",
            com.vmware.nsx.model.StructDefinitions.macLearningCounters);
        add(mapping,
            "com.vmware.nsx.model.mac_learning_spec",
            com.vmware.nsx.model.StructDefinitions.macLearningSpec);
        add(mapping,
            "com.vmware.nsx.model.mac_management_switching_profile",
            com.vmware.nsx.model.StructDefinitions.macManagementSwitchingProfile);
        add(mapping,
            "com.vmware.nsx.model.mac_pool",
            com.vmware.nsx.model.StructDefinitions.macPool);
        add(mapping,
            "com.vmware.nsx.model.mac_pool_list_result",
            com.vmware.nsx.model.StructDefinitions.macPoolListResult);
        add(mapping,
            "com.vmware.nsx.model.mac_range",
            com.vmware.nsx.model.StructDefinitions.macRange);
        add(mapping,
            "com.vmware.nsx.model.mac_table_csv_record",
            com.vmware.nsx.model.StructDefinitions.macTableCsvRecord);
        add(mapping,
            "com.vmware.nsx.model.mac_table_entry",
            com.vmware.nsx.model.StructDefinitions.macTableEntry);
        add(mapping,
            "com.vmware.nsx.model.managed_resource",
            com.vmware.nsx.model.StructDefinitions.managedResource);
        add(mapping,
            "com.vmware.nsx.model.management_cluster_node_status",
            com.vmware.nsx.model.StructDefinitions.managementClusterNodeStatus);
        add(mapping,
            "com.vmware.nsx.model.management_cluster_role_config",
            com.vmware.nsx.model.StructDefinitions.managementClusterRoleConfig);
        add(mapping,
            "com.vmware.nsx.model.management_cluster_status",
            com.vmware.nsx.model.StructDefinitions.managementClusterStatus);
        add(mapping,
            "com.vmware.nsx.model.management_config",
            com.vmware.nsx.model.StructDefinitions.managementConfig);
        add(mapping,
            "com.vmware.nsx.model.management_node_aggregate_info",
            com.vmware.nsx.model.StructDefinitions.managementNodeAggregateInfo);
        add(mapping,
            "com.vmware.nsx.model.management_plane_base_node_info",
            com.vmware.nsx.model.StructDefinitions.managementPlaneBaseNodeInfo);
        add(mapping,
            "com.vmware.nsx.model.management_plane_broker_properties",
            com.vmware.nsx.model.StructDefinitions.managementPlaneBrokerProperties);
        add(mapping,
            "com.vmware.nsx.model.management_plane_properties",
            com.vmware.nsx.model.StructDefinitions.managementPlaneProperties);
        add(mapping,
            "com.vmware.nsx.model.mandatory_access_control_properties",
            com.vmware.nsx.model.StructDefinitions.mandatoryAccessControlProperties);
        add(mapping,
            "com.vmware.nsx.model.manual_health_check",
            com.vmware.nsx.model.StructDefinitions.manualHealthCheck);
        add(mapping,
            "com.vmware.nsx.model.manual_health_check_list_result",
            com.vmware.nsx.model.StructDefinitions.manualHealthCheckListResult);
        add(mapping,
            "com.vmware.nsx.model.memory_reservation",
            com.vmware.nsx.model.StructDefinitions.memoryReservation);
        add(mapping,
            "com.vmware.nsx.model.messaging_client_info",
            com.vmware.nsx.model.StructDefinitions.messagingClientInfo);
        add(mapping,
            "com.vmware.nsx.model.metadata_proxy",
            com.vmware.nsx.model.StructDefinitions.metadataProxy);
        add(mapping,
            "com.vmware.nsx.model.metadata_proxy_list_result",
            com.vmware.nsx.model.StructDefinitions.metadataProxyListResult);
        add(mapping,
            "com.vmware.nsx.model.metadata_proxy_statistics",
            com.vmware.nsx.model.StructDefinitions.metadataProxyStatistics);
        add(mapping,
            "com.vmware.nsx.model.metadata_proxy_statistics_per_logical_switch",
            com.vmware.nsx.model.StructDefinitions.metadataProxyStatisticsPerLogicalSwitch);
        add(mapping,
            "com.vmware.nsx.model.metadata_proxy_status",
            com.vmware.nsx.model.StructDefinitions.metadataProxyStatus);
        add(mapping,
            "com.vmware.nsx.model.mgmt_conn_status",
            com.vmware.nsx.model.StructDefinitions.mgmtConnStatus);
        add(mapping,
            "com.vmware.nsx.model.migrated_object",
            com.vmware.nsx.model.StructDefinitions.migratedObject);
        add(mapping,
            "com.vmware.nsx.model.migrated_object_list_result",
            com.vmware.nsx.model.StructDefinitions.migratedObjectListResult);
        add(mapping,
            "com.vmware.nsx.model.migration_data_download_request",
            com.vmware.nsx.model.StructDefinitions.migrationDataDownloadRequest);
        add(mapping,
            "com.vmware.nsx.model.migration_data_info",
            com.vmware.nsx.model.StructDefinitions.migrationDataInfo);
        add(mapping,
            "com.vmware.nsx.model.migration_feedback_category",
            com.vmware.nsx.model.StructDefinitions.migrationFeedbackCategory);
        add(mapping,
            "com.vmware.nsx.model.migration_feedback_request",
            com.vmware.nsx.model.StructDefinitions.migrationFeedbackRequest);
        add(mapping,
            "com.vmware.nsx.model.migration_feedback_request_list_result",
            com.vmware.nsx.model.StructDefinitions.migrationFeedbackRequestListResult);
        add(mapping,
            "com.vmware.nsx.model.migration_feedback_response",
            com.vmware.nsx.model.StructDefinitions.migrationFeedbackResponse);
        add(mapping,
            "com.vmware.nsx.model.migration_feedback_response_list",
            com.vmware.nsx.model.StructDefinitions.migrationFeedbackResponseList);
        add(mapping,
            "com.vmware.nsx.model.migration_feedback_summary_list_result",
            com.vmware.nsx.model.StructDefinitions.migrationFeedbackSummaryListResult);
        add(mapping,
            "com.vmware.nsx.model.migration_plan_settings",
            com.vmware.nsx.model.StructDefinitions.migrationPlanSettings);
        add(mapping,
            "com.vmware.nsx.model.migration_setup_info",
            com.vmware.nsx.model.StructDefinitions.migrationSetupInfo);
        add(mapping,
            "com.vmware.nsx.model.migration_stats",
            com.vmware.nsx.model.StructDefinitions.migrationStats);
        add(mapping,
            "com.vmware.nsx.model.migration_stats_result",
            com.vmware.nsx.model.StructDefinitions.migrationStatsResult);
        add(mapping,
            "com.vmware.nsx.model.migration_status",
            com.vmware.nsx.model.StructDefinitions.migrationStatus);
        add(mapping,
            "com.vmware.nsx.model.migration_summary",
            com.vmware.nsx.model.StructDefinitions.migrationSummary);
        add(mapping,
            "com.vmware.nsx.model.migration_switch_info",
            com.vmware.nsx.model.StructDefinitions.migrationSwitchInfo);
        add(mapping,
            "com.vmware.nsx.model.migration_switch_list_result",
            com.vmware.nsx.model.StructDefinitions.migrationSwitchListResult);
        add(mapping,
            "com.vmware.nsx.model.migration_unit",
            com.vmware.nsx.model.StructDefinitions.migrationUnit);
        add(mapping,
            "com.vmware.nsx.model.migration_unit_aggregate_info",
            com.vmware.nsx.model.StructDefinitions.migrationUnitAggregateInfo);
        add(mapping,
            "com.vmware.nsx.model.migration_unit_aggregate_info_list_result",
            com.vmware.nsx.model.StructDefinitions.migrationUnitAggregateInfoListResult);
        add(mapping,
            "com.vmware.nsx.model.migration_unit_group",
            com.vmware.nsx.model.StructDefinitions.migrationUnitGroup);
        add(mapping,
            "com.vmware.nsx.model.migration_unit_group_aggregate_info",
            com.vmware.nsx.model.StructDefinitions.migrationUnitGroupAggregateInfo);
        add(mapping,
            "com.vmware.nsx.model.migration_unit_group_aggregate_info_list_result",
            com.vmware.nsx.model.StructDefinitions.migrationUnitGroupAggregateInfoListResult);
        add(mapping,
            "com.vmware.nsx.model.migration_unit_group_list_result",
            com.vmware.nsx.model.StructDefinitions.migrationUnitGroupListResult);
        add(mapping,
            "com.vmware.nsx.model.migration_unit_group_status",
            com.vmware.nsx.model.StructDefinitions.migrationUnitGroupStatus);
        add(mapping,
            "com.vmware.nsx.model.migration_unit_group_status_list_result",
            com.vmware.nsx.model.StructDefinitions.migrationUnitGroupStatusListResult);
        add(mapping,
            "com.vmware.nsx.model.migration_unit_list",
            com.vmware.nsx.model.StructDefinitions.migrationUnitList);
        add(mapping,
            "com.vmware.nsx.model.migration_unit_list_result",
            com.vmware.nsx.model.StructDefinitions.migrationUnitListResult);
        add(mapping,
            "com.vmware.nsx.model.migration_unit_status",
            com.vmware.nsx.model.StructDefinitions.migrationUnitStatus);
        add(mapping,
            "com.vmware.nsx.model.migration_unit_status_list_result",
            com.vmware.nsx.model.StructDefinitions.migrationUnitStatusListResult);
        add(mapping,
            "com.vmware.nsx.model.migration_unit_type_stats",
            com.vmware.nsx.model.StructDefinitions.migrationUnitTypeStats);
        add(mapping,
            "com.vmware.nsx.model.migration_unit_type_stats_list",
            com.vmware.nsx.model.StructDefinitions.migrationUnitTypeStatsList);
        add(mapping,
            "com.vmware.nsx.model.mirror_destination",
            com.vmware.nsx.model.StructDefinitions.mirrorDestination);
        add(mapping,
            "com.vmware.nsx.model.mirror_source",
            com.vmware.nsx.model.StructDefinitions.mirrorSource);
        add(mapping,
            "com.vmware.nsx.model.mirror_stack_status_list_result",
            com.vmware.nsx.model.StructDefinitions.mirrorStackStatusListResult);
        add(mapping,
            "com.vmware.nsx.model.monitoring_event",
            com.vmware.nsx.model.StructDefinitions.monitoringEvent);
        add(mapping,
            "com.vmware.nsx.model.monthly_telemetry_schedule",
            com.vmware.nsx.model.StructDefinitions.monthlyTelemetrySchedule);
        add(mapping,
            "com.vmware.nsx.model.mp_data",
            com.vmware.nsx.model.StructDefinitions.mpData);
        add(mapping,
            "com.vmware.nsx.model.mp_data_by_principle_idenity",
            com.vmware.nsx.model.StructDefinitions.mpDataByPrincipleIdenity);
        add(mapping,
            "com.vmware.nsx.model.mp_data_list_result",
            com.vmware.nsx.model.StructDefinitions.mpDataListResult);
        add(mapping,
            "com.vmware.nsx.model.mp_migration_data",
            com.vmware.nsx.model.StructDefinitions.mpMigrationData);
        add(mapping,
            "com.vmware.nsx.model.msg_client_info",
            com.vmware.nsx.model.StructDefinitions.msgClientInfo);
        add(mapping,
            "com.vmware.nsx.model.multi_widget_configuration",
            com.vmware.nsx.model.StructDefinitions.multiWidgetConfiguration);
        add(mapping,
            "com.vmware.nsx.model.NAPI_log_level_value",
            com.vmware.nsx.model.StructDefinitions.NAPILogLevelValue);
        add(mapping,
            "com.vmware.nsx.model.NDRA_advertised_route",
            com.vmware.nsx.model.StructDefinitions.NDRAAdvertisedRoute);
        add(mapping,
            "com.vmware.nsx.model.NDRA_prefix_config",
            com.vmware.nsx.model.StructDefinitions.NDRAPrefixConfig);
        add(mapping,
            "com.vmware.nsx.model.NDRA_profile",
            com.vmware.nsx.model.StructDefinitions.NDRAProfile);
        add(mapping,
            "com.vmware.nsx.model.NDRA_profile_list_result",
            com.vmware.nsx.model.StructDefinitions.NDRAProfileListResult);
        add(mapping,
            "com.vmware.nsx.model.NS_attributes",
            com.vmware.nsx.model.StructDefinitions.NSAttributes);
        add(mapping,
            "com.vmware.nsx.model.NS_attributes_data",
            com.vmware.nsx.model.StructDefinitions.NSAttributesData);
        add(mapping,
            "com.vmware.nsx.model.NS_group",
            com.vmware.nsx.model.StructDefinitions.NSGroup);
        add(mapping,
            "com.vmware.nsx.model.NS_group_complex_expression",
            com.vmware.nsx.model.StructDefinitions.NSGroupComplexExpression);
        add(mapping,
            "com.vmware.nsx.model.NS_group_expression",
            com.vmware.nsx.model.StructDefinitions.NSGroupExpression);
        add(mapping,
            "com.vmware.nsx.model.NS_group_expression_list",
            com.vmware.nsx.model.StructDefinitions.NSGroupExpressionList);
        add(mapping,
            "com.vmware.nsx.model.NS_group_info",
            com.vmware.nsx.model.StructDefinitions.NSGroupInfo);
        add(mapping,
            "com.vmware.nsx.model.NS_group_list_result",
            com.vmware.nsx.model.StructDefinitions.NSGroupListResult);
        add(mapping,
            "com.vmware.nsx.model.NS_group_simple_expression",
            com.vmware.nsx.model.StructDefinitions.NSGroupSimpleExpression);
        add(mapping,
            "com.vmware.nsx.model.NS_group_tag_expression",
            com.vmware.nsx.model.StructDefinitions.NSGroupTagExpression);
        add(mapping,
            "com.vmware.nsx.model.NS_profile",
            com.vmware.nsx.model.StructDefinitions.NSProfile);
        add(mapping,
            "com.vmware.nsx.model.NS_profile_list_result",
            com.vmware.nsx.model.StructDefinitions.NSProfileListResult);
        add(mapping,
            "com.vmware.nsx.model.NS_service",
            com.vmware.nsx.model.StructDefinitions.NSService);
        add(mapping,
            "com.vmware.nsx.model.NS_service_element",
            com.vmware.nsx.model.StructDefinitions.NSServiceElement);
        add(mapping,
            "com.vmware.nsx.model.NS_service_group",
            com.vmware.nsx.model.StructDefinitions.NSServiceGroup);
        add(mapping,
            "com.vmware.nsx.model.NS_service_group_list_result",
            com.vmware.nsx.model.StructDefinitions.NSServiceGroupListResult);
        add(mapping,
            "com.vmware.nsx.model.NS_service_list_result",
            com.vmware.nsx.model.StructDefinitions.NSServiceListResult);
        add(mapping,
            "com.vmware.nsx.model.NS_supported_attribute_types_result",
            com.vmware.nsx.model.StructDefinitions.NSSupportedAttributeTypesResult);
        add(mapping,
            "com.vmware.nsx.model.NS_supported_attributes",
            com.vmware.nsx.model.StructDefinitions.NSSupportedAttributes);
        add(mapping,
            "com.vmware.nsx.model.NS_supported_attributes_list_result",
            com.vmware.nsx.model.StructDefinitions.NSSupportedAttributesListResult);
        add(mapping,
            "com.vmware.nsx.model.NSX_profile_reference",
            com.vmware.nsx.model.StructDefinitions.NSXProfileReference);
        add(mapping,
            "com.vmware.nsx.model.NSX_release",
            com.vmware.nsx.model.StructDefinitions.NSXRelease);
        add(mapping,
            "com.vmware.nsx.model.NSX_releases",
            com.vmware.nsx.model.StructDefinitions.NSXReleases);
        add(mapping,
            "com.vmware.nsx.model.named_teaming_policy",
            com.vmware.nsx.model.StructDefinitions.namedTeamingPolicy);
        add(mapping,
            "com.vmware.nsx.model.nat_counters",
            com.vmware.nsx.model.StructDefinitions.natCounters);
        add(mapping,
            "com.vmware.nsx.model.nat_rule",
            com.vmware.nsx.model.StructDefinitions.natRule);
        add(mapping,
            "com.vmware.nsx.model.nat_rule_list",
            com.vmware.nsx.model.StructDefinitions.natRuleList);
        add(mapping,
            "com.vmware.nsx.model.nat_rule_list_result",
            com.vmware.nsx.model.StructDefinitions.natRuleListResult);
        add(mapping,
            "com.vmware.nsx.model.nat_statistics_per_logical_router",
            com.vmware.nsx.model.StructDefinitions.natStatisticsPerLogicalRouter);
        add(mapping,
            "com.vmware.nsx.model.nat_statistics_per_rule",
            com.vmware.nsx.model.StructDefinitions.natStatisticsPerRule);
        add(mapping,
            "com.vmware.nsx.model.nat_statistics_per_transport_node",
            com.vmware.nsx.model.StructDefinitions.natStatisticsPerTransportNode);
        add(mapping,
            "com.vmware.nsx.model.ndp_header",
            com.vmware.nsx.model.StructDefinitions.ndpHeader);
        add(mapping,
            "com.vmware.nsx.model.neighbor_properties",
            com.vmware.nsx.model.StructDefinitions.neighborProperties);
        add(mapping,
            "com.vmware.nsx.model.network_error",
            com.vmware.nsx.model.StructDefinitions.networkError);
        add(mapping,
            "com.vmware.nsx.model.network_info",
            com.vmware.nsx.model.StructDefinitions.networkInfo);
        add(mapping,
            "com.vmware.nsx.model.new_host_transport_node_spec",
            com.vmware.nsx.model.StructDefinitions.newHostTransportNodeSpec);
        add(mapping,
            "com.vmware.nsx.model.new_role",
            com.vmware.nsx.model.StructDefinitions.newRole);
        add(mapping,
            "com.vmware.nsx.model.next_hop_prefix_lists_mapping",
            com.vmware.nsx.model.StructDefinitions.nextHopPrefixListsMapping);
        add(mapping,
            "com.vmware.nsx.model.nic_info",
            com.vmware.nsx.model.StructDefinitions.nicInfo);
        add(mapping,
            "com.vmware.nsx.model.nic_metadata",
            com.vmware.nsx.model.StructDefinitions.nicMetadata);
        add(mapping,
            "com.vmware.nsx.model.nioc_profile",
            com.vmware.nsx.model.StructDefinitions.niocProfile);
        add(mapping,
            "com.vmware.nsx.model.node",
            com.vmware.nsx.model.StructDefinitions.node);
        add(mapping,
            "com.vmware.nsx.model.node_async_replicator_service_properties",
            com.vmware.nsx.model.StructDefinitions.nodeAsyncReplicatorServiceProperties);
        add(mapping,
            "com.vmware.nsx.model.node_auth_provider_vidm_properties",
            com.vmware.nsx.model.StructDefinitions.nodeAuthProviderVidmProperties);
        add(mapping,
            "com.vmware.nsx.model.node_auth_provider_vidm_status",
            com.vmware.nsx.model.StructDefinitions.nodeAuthProviderVidmStatus);
        add(mapping,
            "com.vmware.nsx.model.node_auth_service_properties",
            com.vmware.nsx.model.StructDefinitions.nodeAuthServiceProperties);
        add(mapping,
            "com.vmware.nsx.model.node_capabilities_result",
            com.vmware.nsx.model.StructDefinitions.nodeCapabilitiesResult);
        add(mapping,
            "com.vmware.nsx.model.node_capability",
            com.vmware.nsx.model.StructDefinitions.nodeCapability);
        add(mapping,
            "com.vmware.nsx.model.node_certificate_info",
            com.vmware.nsx.model.StructDefinitions.nodeCertificateInfo);
        add(mapping,
            "com.vmware.nsx.model.node_entity_info",
            com.vmware.nsx.model.StructDefinitions.nodeEntityInfo);
        add(mapping,
            "com.vmware.nsx.model.node_file_system_properties",
            com.vmware.nsx.model.StructDefinitions.nodeFileSystemProperties);
        add(mapping,
            "com.vmware.nsx.model.node_grub_properties",
            com.vmware.nsx.model.StructDefinitions.nodeGrubProperties);
        add(mapping,
            "com.vmware.nsx.model.node_grub_user_properties",
            com.vmware.nsx.model.StructDefinitions.nodeGrubUserProperties);
        add(mapping,
            "com.vmware.nsx.model.node_http_service_properties",
            com.vmware.nsx.model.StructDefinitions.nodeHttpServiceProperties);
        add(mapping,
            "com.vmware.nsx.model.node_id_services_map",
            com.vmware.nsx.model.StructDefinitions.nodeIdServicesMap);
        add(mapping,
            "com.vmware.nsx.model.node_info",
            com.vmware.nsx.model.StructDefinitions.nodeInfo);
        add(mapping,
            "com.vmware.nsx.model.node_info_list_result",
            com.vmware.nsx.model.StructDefinitions.nodeInfoListResult);
        add(mapping,
            "com.vmware.nsx.model.node_install_upgrade_service_properties",
            com.vmware.nsx.model.StructDefinitions.nodeInstallUpgradeServiceProperties);
        add(mapping,
            "com.vmware.nsx.model.node_inter_site_statistics",
            com.vmware.nsx.model.StructDefinitions.nodeInterSiteStatistics);
        add(mapping,
            "com.vmware.nsx.model.node_interface_alias",
            com.vmware.nsx.model.StructDefinitions.nodeInterfaceAlias);
        add(mapping,
            "com.vmware.nsx.model.node_interface_properties",
            com.vmware.nsx.model.StructDefinitions.nodeInterfaceProperties);
        add(mapping,
            "com.vmware.nsx.model.node_interface_properties_list_result",
            com.vmware.nsx.model.StructDefinitions.nodeInterfacePropertiesListResult);
        add(mapping,
            "com.vmware.nsx.model.node_interface_statistics_properties",
            com.vmware.nsx.model.StructDefinitions.nodeInterfaceStatisticsProperties);
        add(mapping,
            "com.vmware.nsx.model.node_log_properties",
            com.vmware.nsx.model.StructDefinitions.nodeLogProperties);
        add(mapping,
            "com.vmware.nsx.model.node_log_properties_list_result",
            com.vmware.nsx.model.StructDefinitions.nodeLogPropertiesListResult);
        add(mapping,
            "com.vmware.nsx.model.node_messaging_client_info",
            com.vmware.nsx.model.StructDefinitions.nodeMessagingClientInfo);
        add(mapping,
            "com.vmware.nsx.model.node_mode",
            com.vmware.nsx.model.StructDefinitions.nodeMode);
        add(mapping,
            "com.vmware.nsx.model.node_name_servers_properties",
            com.vmware.nsx.model.StructDefinitions.nodeNameServersProperties);
        add(mapping,
            "com.vmware.nsx.model.node_network_interface_properties",
            com.vmware.nsx.model.StructDefinitions.nodeNetworkInterfaceProperties);
        add(mapping,
            "com.vmware.nsx.model.node_network_interface_properties_list_result",
            com.vmware.nsx.model.StructDefinitions.nodeNetworkInterfacePropertiesListResult);
        add(mapping,
            "com.vmware.nsx.model.node_network_properties",
            com.vmware.nsx.model.StructDefinitions.nodeNetworkProperties);
        add(mapping,
            "com.vmware.nsx.model.node_ntp_service_properties",
            com.vmware.nsx.model.StructDefinitions.nodeNtpServiceProperties);
        add(mapping,
            "com.vmware.nsx.model.node_phonehome_coordinator_service_properties",
            com.vmware.nsx.model.StructDefinitions.nodePhonehomeCoordinatorServiceProperties);
        add(mapping,
            "com.vmware.nsx.model.node_policy_service_properties",
            com.vmware.nsx.model.StructDefinitions.nodePolicyServiceProperties);
        add(mapping,
            "com.vmware.nsx.model.node_port_local_endpoint",
            com.vmware.nsx.model.StructDefinitions.nodePortLocalEndpoint);
        add(mapping,
            "com.vmware.nsx.model.node_process_properties",
            com.vmware.nsx.model.StructDefinitions.nodeProcessProperties);
        add(mapping,
            "com.vmware.nsx.model.node_process_properties_list_result",
            com.vmware.nsx.model.StructDefinitions.nodeProcessPropertiesListResult);
        add(mapping,
            "com.vmware.nsx.model.node_properties",
            com.vmware.nsx.model.StructDefinitions.nodeProperties);
        add(mapping,
            "com.vmware.nsx.model.node_proton_service_properties",
            com.vmware.nsx.model.StructDefinitions.nodeProtonServiceProperties);
        add(mapping,
            "com.vmware.nsx.model.node_route_properties",
            com.vmware.nsx.model.StructDefinitions.nodeRouteProperties);
        add(mapping,
            "com.vmware.nsx.model.node_route_properties_list_result",
            com.vmware.nsx.model.StructDefinitions.nodeRoutePropertiesListResult);
        add(mapping,
            "com.vmware.nsx.model.node_rtep_ips_config",
            com.vmware.nsx.model.StructDefinitions.nodeRtepIpsConfig);
        add(mapping,
            "com.vmware.nsx.model.node_search_domains_properties",
            com.vmware.nsx.model.StructDefinitions.nodeSearchDomainsProperties);
        add(mapping,
            "com.vmware.nsx.model.node_service_properties",
            com.vmware.nsx.model.StructDefinitions.nodeServiceProperties);
        add(mapping,
            "com.vmware.nsx.model.node_service_properties_list_result",
            com.vmware.nsx.model.StructDefinitions.nodeServicePropertiesListResult);
        add(mapping,
            "com.vmware.nsx.model.node_service_status_properties",
            com.vmware.nsx.model.StructDefinitions.nodeServiceStatusProperties);
        add(mapping,
            "com.vmware.nsx.model.node_snmp_service_properties",
            com.vmware.nsx.model.StructDefinitions.nodeSnmpServiceProperties);
        add(mapping,
            "com.vmware.nsx.model.node_snmp_v3_engine_ID",
            com.vmware.nsx.model.StructDefinitions.nodeSnmpV3EngineID);
        add(mapping,
            "com.vmware.nsx.model.node_ssh_service_properties",
            com.vmware.nsx.model.StructDefinitions.nodeSshServiceProperties);
        add(mapping,
            "com.vmware.nsx.model.node_status",
            com.vmware.nsx.model.StructDefinitions.nodeStatus);
        add(mapping,
            "com.vmware.nsx.model.node_status_properties",
            com.vmware.nsx.model.StructDefinitions.nodeStatusProperties);
        add(mapping,
            "com.vmware.nsx.model.node_summary",
            com.vmware.nsx.model.StructDefinitions.nodeSummary);
        add(mapping,
            "com.vmware.nsx.model.node_summary_list",
            com.vmware.nsx.model.StructDefinitions.nodeSummaryList);
        add(mapping,
            "com.vmware.nsx.model.node_syslog_exporter_properties",
            com.vmware.nsx.model.StructDefinitions.nodeSyslogExporterProperties);
        add(mapping,
            "com.vmware.nsx.model.node_syslog_exporter_properties_list_result",
            com.vmware.nsx.model.StructDefinitions.nodeSyslogExporterPropertiesListResult);
        add(mapping,
            "com.vmware.nsx.model.node_time",
            com.vmware.nsx.model.StructDefinitions.nodeTime);
        add(mapping,
            "com.vmware.nsx.model.node_user_password_property",
            com.vmware.nsx.model.StructDefinitions.nodeUserPasswordProperty);
        add(mapping,
            "com.vmware.nsx.model.node_user_properties",
            com.vmware.nsx.model.StructDefinitions.nodeUserProperties);
        add(mapping,
            "com.vmware.nsx.model.node_user_properties_list_result",
            com.vmware.nsx.model.StructDefinitions.nodeUserPropertiesListResult);
        add(mapping,
            "com.vmware.nsx.model.node_user_settings",
            com.vmware.nsx.model.StructDefinitions.nodeUserSettings);
        add(mapping,
            "com.vmware.nsx.model.node_version",
            com.vmware.nsx.model.StructDefinitions.nodeVersion);
        add(mapping,
            "com.vmware.nsx.model.normalized_resource_list_result",
            com.vmware.nsx.model.StructDefinitions.normalizedResourceListResult);
        add(mapping,
            "com.vmware.nsx.model.notification",
            com.vmware.nsx.model.StructDefinitions.notification);
        add(mapping,
            "com.vmware.nsx.model.notification_authentication_scheme",
            com.vmware.nsx.model.StructDefinitions.notificationAuthenticationScheme);
        add(mapping,
            "com.vmware.nsx.model.notification_watcher",
            com.vmware.nsx.model.StructDefinitions.notificationWatcher);
        add(mapping,
            "com.vmware.nsx.model.notification_watcher_list_result",
            com.vmware.nsx.model.StructDefinitions.notificationWatcherListResult);
        add(mapping,
            "com.vmware.nsx.model.notifications_list",
            com.vmware.nsx.model.StructDefinitions.notificationsList);
        add(mapping,
            "com.vmware.nsx.model.nsx_role",
            com.vmware.nsx.model.StructDefinitions.nsxRole);
        add(mapping,
            "com.vmware.nsx.model.nsxt_site",
            com.vmware.nsx.model.StructDefinitions.nsxtSite);
        add(mapping,
            "com.vmware.nsx.model.nsxt_site_to_avi_mapping",
            com.vmware.nsx.model.StructDefinitions.nsxtSiteToAviMapping);
        add(mapping,
            "com.vmware.nsx.model.ntp_properties",
            com.vmware.nsx.model.StructDefinitions.ntpProperties);
        add(mapping,
            "com.vmware.nsx.model.ntp_service_properties",
            com.vmware.nsx.model.StructDefinitions.ntpServiceProperties);
        add(mapping,
            "com.vmware.nsx.model.nvds_upgrade_config_issue",
            com.vmware.nsx.model.StructDefinitions.nvdsUpgradeConfigIssue);
        add(mapping,
            "com.vmware.nsx.model.nvds_upgrade_host_state",
            com.vmware.nsx.model.StructDefinitions.nvdsUpgradeHostState);
        add(mapping,
            "com.vmware.nsx.model.nvds_upgrade_precheck_id",
            com.vmware.nsx.model.StructDefinitions.nvdsUpgradePrecheckId);
        add(mapping,
            "com.vmware.nsx.model.nvds_upgrade_status_summary",
            com.vmware.nsx.model.StructDefinitions.nvdsUpgradeStatusSummary);
        add(mapping,
            "com.vmware.nsx.model.nvds_upgrade_topology",
            com.vmware.nsx.model.StructDefinitions.nvdsUpgradeTopology);
        add(mapping,
            "com.vmware.nsx.model.oauth2_credentials",
            com.vmware.nsx.model.StructDefinitions.oauth2Credentials);
        add(mapping,
            "com.vmware.nsx.model.oidc_end_point",
            com.vmware.nsx.model.StructDefinitions.oidcEndPoint);
        add(mapping,
            "com.vmware.nsx.model.oidc_end_point_health_status",
            com.vmware.nsx.model.StructDefinitions.oidcEndPointHealthStatus);
        add(mapping,
            "com.vmware.nsx.model.oidc_end_point_list_result",
            com.vmware.nsx.model.StructDefinitions.oidcEndPointListResult);
        add(mapping,
            "com.vmware.nsx.model.oidc_health_check_error",
            com.vmware.nsx.model.StructDefinitions.oidcHealthCheckError);
        add(mapping,
            "com.vmware.nsx.model.operation_collector",
            com.vmware.nsx.model.StructDefinitions.operationCollector);
        add(mapping,
            "com.vmware.nsx.model.operation_collector_global_config",
            com.vmware.nsx.model.StructDefinitions.operationCollectorGlobalConfig);
        add(mapping,
            "com.vmware.nsx.model.org_info",
            com.vmware.nsx.model.StructDefinitions.orgInfo);
        add(mapping,
            "com.vmware.nsx.model.ovf_info",
            com.vmware.nsx.model.StructDefinitions.ovfInfo);
        add(mapping,
            "com.vmware.nsx.model.owner_resource_link",
            com.vmware.nsx.model.StructDefinitions.ownerResourceLink);
        add(mapping,
            "com.vmware.nsx.model.package_logging_levels",
            com.vmware.nsx.model.StructDefinitions.packageLoggingLevels);
        add(mapping,
            "com.vmware.nsx.model.packet_address_classifier",
            com.vmware.nsx.model.StructDefinitions.packetAddressClassifier);
        add(mapping,
            "com.vmware.nsx.model.packet_capture_option",
            com.vmware.nsx.model.StructDefinitions.packetCaptureOption);
        add(mapping,
            "com.vmware.nsx.model.packet_capture_option_list",
            com.vmware.nsx.model.StructDefinitions.packetCaptureOptionList);
        add(mapping,
            "com.vmware.nsx.model.packet_capture_request",
            com.vmware.nsx.model.StructDefinitions.packetCaptureRequest);
        add(mapping,
            "com.vmware.nsx.model.packet_capture_session",
            com.vmware.nsx.model.StructDefinitions.packetCaptureSession);
        add(mapping,
            "com.vmware.nsx.model.packet_capture_session_list",
            com.vmware.nsx.model.StructDefinitions.packetCaptureSessionList);
        add(mapping,
            "com.vmware.nsx.model.packet_data",
            com.vmware.nsx.model.StructDefinitions.packetData);
        add(mapping,
            "com.vmware.nsx.model.packet_number_sampling",
            com.vmware.nsx.model.StructDefinitions.packetNumberSampling);
        add(mapping,
            "com.vmware.nsx.model.packet_type_and_counter",
            com.vmware.nsx.model.StructDefinitions.packetTypeAndCounter);
        add(mapping,
            "com.vmware.nsx.model.packets_dropped_by_security",
            com.vmware.nsx.model.StructDefinitions.packetsDroppedBySecurity);
        add(mapping,
            "com.vmware.nsx.model.password_authentication_scheme",
            com.vmware.nsx.model.StructDefinitions.passwordAuthenticationScheme);
        add(mapping,
            "com.vmware.nsx.model.password_complexity_properties",
            com.vmware.nsx.model.StructDefinitions.passwordComplexityProperties);
        add(mapping,
            "com.vmware.nsx.model.peer_certificate_chain",
            com.vmware.nsx.model.StructDefinitions.peerCertificateChain);
        add(mapping,
            "com.vmware.nsx.model.pending_change",
            com.vmware.nsx.model.StructDefinitions.pendingChange);
        add(mapping,
            "com.vmware.nsx.model.per_forwarder_statistics",
            com.vmware.nsx.model.StructDefinitions.perForwarderStatistics);
        add(mapping,
            "com.vmware.nsx.model.per_node_dns_failed_queries",
            com.vmware.nsx.model.StructDefinitions.perNodeDnsFailedQueries);
        add(mapping,
            "com.vmware.nsx.model.per_node_used_cache_statistics",
            com.vmware.nsx.model.StructDefinitions.perNodeUsedCacheStatistics);
        add(mapping,
            "com.vmware.nsx.model.per_step_restore_status",
            com.vmware.nsx.model.StructDefinitions.perStepRestoreStatus);
        add(mapping,
            "com.vmware.nsx.model.per_upstream_server_statistics",
            com.vmware.nsx.model.StructDefinitions.perUpstreamServerStatistics);
        add(mapping,
            "com.vmware.nsx.model.phonehome_coordinator_service_properties",
            com.vmware.nsx.model.StructDefinitions.phonehomeCoordinatorServiceProperties);
        add(mapping,
            "com.vmware.nsx.model.physical_server",
            com.vmware.nsx.model.StructDefinitions.physicalServer);
        add(mapping,
            "com.vmware.nsx.model.physical_server_list_result",
            com.vmware.nsx.model.StructDefinitions.physicalServerListResult);
        add(mapping,
            "com.vmware.nsx.model.pkt_cap_resource",
            com.vmware.nsx.model.StructDefinitions.pktCapResource);
        add(mapping,
            "com.vmware.nsx.model.pkt_cap_result",
            com.vmware.nsx.model.StructDefinitions.pktCapResult);
        add(mapping,
            "com.vmware.nsx.model.pktcap_action_argument",
            com.vmware.nsx.model.StructDefinitions.pktcapActionArgument);
        add(mapping,
            "com.vmware.nsx.model.pktcap_action_config",
            com.vmware.nsx.model.StructDefinitions.pktcapActionConfig);
        add(mapping,
            "com.vmware.nsx.model.plain_filter_data",
            com.vmware.nsx.model.StructDefinitions.plainFilterData);
        add(mapping,
            "com.vmware.nsx.model.plugin_file_properties",
            com.vmware.nsx.model.StructDefinitions.pluginFileProperties);
        add(mapping,
            "com.vmware.nsx.model.plugin_status",
            com.vmware.nsx.model.StructDefinitions.pluginStatus);
        add(mapping,
            "com.vmware.nsx.model.plugin_status_list",
            com.vmware.nsx.model.StructDefinitions.pluginStatusList);
        add(mapping,
            "com.vmware.nsx.model.pnic",
            com.vmware.nsx.model.StructDefinitions.pnic);
        add(mapping,
            "com.vmware.nsx.model.pnic_bond_status",
            com.vmware.nsx.model.StructDefinitions.pnicBondStatus);
        add(mapping,
            "com.vmware.nsx.model.pnic_bond_status_list_result",
            com.vmware.nsx.model.StructDefinitions.pnicBondStatusListResult);
        add(mapping,
            "com.vmware.nsx.model.pnic_mirror_destination",
            com.vmware.nsx.model.StructDefinitions.pnicMirrorDestination);
        add(mapping,
            "com.vmware.nsx.model.pnic_mirror_source",
            com.vmware.nsx.model.StructDefinitions.pnicMirrorSource);
        add(mapping,
            "com.vmware.nsx.model.point_definition",
            com.vmware.nsx.model.StructDefinitions.pointDefinition);
        add(mapping,
            "com.vmware.nsx.model.policy_based_IP_sec_VPN_session",
            com.vmware.nsx.model.StructDefinitions.policyBasedIPSecVPNSession);
        add(mapping,
            "com.vmware.nsx.model.policy_pkt_cap_resource",
            com.vmware.nsx.model.StructDefinitions.policyPktCapResource);
        add(mapping,
            "com.vmware.nsx.model.policy_traceflow_observation_delivered",
            com.vmware.nsx.model.StructDefinitions.policyTraceflowObservationDelivered);
        add(mapping,
            "com.vmware.nsx.model.policy_traceflow_observation_dropped",
            com.vmware.nsx.model.StructDefinitions.policyTraceflowObservationDropped);
        add(mapping,
            "com.vmware.nsx.model.policy_traceflow_observation_dropped_logical",
            com.vmware.nsx.model.StructDefinitions.policyTraceflowObservationDroppedLogical);
        add(mapping,
            "com.vmware.nsx.model.policy_traceflow_observation_forwarded_logical",
            com.vmware.nsx.model.StructDefinitions.policyTraceflowObservationForwardedLogical);
        add(mapping,
            "com.vmware.nsx.model.policy_traceflow_observation_ipsec_vpn",
            com.vmware.nsx.model.StructDefinitions.policyTraceflowObservationIpsecVpn);
        add(mapping,
            "com.vmware.nsx.model.policy_traceflow_observation_received_logical",
            com.vmware.nsx.model.StructDefinitions.policyTraceflowObservationReceivedLogical);
        add(mapping,
            "com.vmware.nsx.model.policy_traceflow_observation_relayed_logical",
            com.vmware.nsx.model.StructDefinitions.policyTraceflowObservationRelayedLogical);
        add(mapping,
            "com.vmware.nsx.model.pool_member",
            com.vmware.nsx.model.StructDefinitions.poolMember);
        add(mapping,
            "com.vmware.nsx.model.pool_member_group",
            com.vmware.nsx.model.StructDefinitions.poolMemberGroup);
        add(mapping,
            "com.vmware.nsx.model.pool_member_setting",
            com.vmware.nsx.model.StructDefinitions.poolMemberSetting);
        add(mapping,
            "com.vmware.nsx.model.pool_member_setting_list",
            com.vmware.nsx.model.StructDefinitions.poolMemberSettingList);
        add(mapping,
            "com.vmware.nsx.model.pool_usage",
            com.vmware.nsx.model.StructDefinitions.poolUsage);
        add(mapping,
            "com.vmware.nsx.model.port_attacher",
            com.vmware.nsx.model.StructDefinitions.portAttacher);
        add(mapping,
            "com.vmware.nsx.model.port_connection_BM_entities",
            com.vmware.nsx.model.StructDefinitions.portConnectionBMEntities);
        add(mapping,
            "com.vmware.nsx.model.port_connection_containers_entities",
            com.vmware.nsx.model.StructDefinitions.portConnectionContainersEntities);
        add(mapping,
            "com.vmware.nsx.model.port_connection_edge_node_group",
            com.vmware.nsx.model.StructDefinitions.portConnectionEdgeNodeGroup);
        add(mapping,
            "com.vmware.nsx.model.port_connection_entities",
            com.vmware.nsx.model.StructDefinitions.portConnectionEntities);
        add(mapping,
            "com.vmware.nsx.model.port_connection_entity",
            com.vmware.nsx.model.StructDefinitions.portConnectionEntity);
        add(mapping,
            "com.vmware.nsx.model.port_connection_error",
            com.vmware.nsx.model.StructDefinitions.portConnectionError);
        add(mapping,
            "com.vmware.nsx.model.port_connection_hypervisor",
            com.vmware.nsx.model.StructDefinitions.portConnectionHypervisor);
        add(mapping,
            "com.vmware.nsx.model.port_connection_logical_switch",
            com.vmware.nsx.model.StructDefinitions.portConnectionLogicalSwitch);
        add(mapping,
            "com.vmware.nsx.model.port_connection_router",
            com.vmware.nsx.model.StructDefinitions.portConnectionRouter);
        add(mapping,
            "com.vmware.nsx.model.port_connection_tunnel",
            com.vmware.nsx.model.StructDefinitions.portConnectionTunnel);
        add(mapping,
            "com.vmware.nsx.model.port_mirroring_filter",
            com.vmware.nsx.model.StructDefinitions.portMirroringFilter);
        add(mapping,
            "com.vmware.nsx.model.port_mirroring_session",
            com.vmware.nsx.model.StructDefinitions.portMirroringSession);
        add(mapping,
            "com.vmware.nsx.model.port_mirroring_session_list_result",
            com.vmware.nsx.model.StructDefinitions.portMirroringSessionListResult);
        add(mapping,
            "com.vmware.nsx.model.port_status",
            com.vmware.nsx.model.StructDefinitions.portStatus);
        add(mapping,
            "com.vmware.nsx.model.post_vm_group_migration_spec",
            com.vmware.nsx.model.StructDefinitions.postVmGroupMigrationSpec);
        add(mapping,
            "com.vmware.nsx.model.pre_vm_group_migration_spec",
            com.vmware.nsx.model.StructDefinitions.preVmGroupMigrationSpec);
        add(mapping,
            "com.vmware.nsx.model.precheck_parameters",
            com.vmware.nsx.model.StructDefinitions.precheckParameters);
        add(mapping,
            "com.vmware.nsx.model.preconfigured_endpoint",
            com.vmware.nsx.model.StructDefinitions.preconfiguredEndpoint);
        add(mapping,
            "com.vmware.nsx.model.preconfigured_host_switch",
            com.vmware.nsx.model.StructDefinitions.preconfiguredHostSwitch);
        add(mapping,
            "com.vmware.nsx.model.preconfigured_host_switch_spec",
            com.vmware.nsx.model.StructDefinitions.preconfiguredHostSwitchSpec);
        add(mapping,
            "com.vmware.nsx.model.prefix_config",
            com.vmware.nsx.model.StructDefinitions.prefixConfig);
        add(mapping,
            "com.vmware.nsx.model.principal",
            com.vmware.nsx.model.StructDefinitions.principal);
        add(mapping,
            "com.vmware.nsx.model.principal_identity",
            com.vmware.nsx.model.StructDefinitions.principalIdentity);
        add(mapping,
            "com.vmware.nsx.model.principal_identity_list",
            com.vmware.nsx.model.StructDefinitions.principalIdentityList);
        add(mapping,
            "com.vmware.nsx.model.principal_identity_with_certificate",
            com.vmware.nsx.model.StructDefinitions.principalIdentityWithCertificate);
        add(mapping,
            "com.vmware.nsx.model.process_information",
            com.vmware.nsx.model.StructDefinitions.processInformation);
        add(mapping,
            "com.vmware.nsx.model.progress_item",
            com.vmware.nsx.model.StructDefinitions.progressItem);
        add(mapping,
            "com.vmware.nsx.model.progress_item_part",
            com.vmware.nsx.model.StructDefinitions.progressItemPart);
        add(mapping,
            "com.vmware.nsx.model.property_item",
            com.vmware.nsx.model.StructDefinitions.propertyItem);
        add(mapping,
            "com.vmware.nsx.model.protocol",
            com.vmware.nsx.model.StructDefinitions.protocol);
        add(mapping,
            "com.vmware.nsx.model.protocol_version",
            com.vmware.nsx.model.StructDefinitions.protocolVersion);
        add(mapping,
            "com.vmware.nsx.model.proxy",
            com.vmware.nsx.model.StructDefinitions.proxy);
        add(mapping,
            "com.vmware.nsx.model.public_client_info",
            com.vmware.nsx.model.StructDefinitions.publicClientInfo);
        add(mapping,
            "com.vmware.nsx.model.public_cloud_gateway_node",
            com.vmware.nsx.model.StructDefinitions.publicCloudGatewayNode);
        add(mapping,
            "com.vmware.nsx.model.qos_base_rate_shaper",
            com.vmware.nsx.model.StructDefinitions.qosBaseRateShaper);
        add(mapping,
            "com.vmware.nsx.model.qos_switching_profile",
            com.vmware.nsx.model.StructDefinitions.qosSwitchingProfile);
        add(mapping,
            "com.vmware.nsx.model.RA_config",
            com.vmware.nsx.model.StructDefinitions.RAConfig);
        add(mapping,
            "com.vmware.nsx.model.ra_DNS_config",
            com.vmware.nsx.model.StructDefinitions.raDNSConfig);
        add(mapping,
            "com.vmware.nsx.model.rate_limits",
            com.vmware.nsx.model.StructDefinitions.rateLimits);
        add(mapping,
            "com.vmware.nsx.model.realization_state_barrier_config",
            com.vmware.nsx.model.StructDefinitions.realizationStateBarrierConfig);
        add(mapping,
            "com.vmware.nsx.model.recommended_feature_permission",
            com.vmware.nsx.model.StructDefinitions.recommendedFeaturePermission);
        add(mapping,
            "com.vmware.nsx.model.recommended_feature_permission_list_result",
            com.vmware.nsx.model.StructDefinitions.recommendedFeaturePermissionListResult);
        add(mapping,
            "com.vmware.nsx.model.redistribution_config",
            com.vmware.nsx.model.StructDefinitions.redistributionConfig);
        add(mapping,
            "com.vmware.nsx.model.redistribution_rule",
            com.vmware.nsx.model.StructDefinitions.redistributionRule);
        add(mapping,
            "com.vmware.nsx.model.redistribution_rule_list",
            com.vmware.nsx.model.StructDefinitions.redistributionRuleList);
        add(mapping,
            "com.vmware.nsx.model.reg_token_query",
            com.vmware.nsx.model.StructDefinitions.regTokenQuery);
        add(mapping,
            "com.vmware.nsx.model.registration_token",
            com.vmware.nsx.model.StructDefinitions.registrationToken);
        add(mapping,
            "com.vmware.nsx.model.related_api_error",
            com.vmware.nsx.model.StructDefinitions.relatedApiError);
        add(mapping,
            "com.vmware.nsx.model.remaining_support_bundle_node",
            com.vmware.nsx.model.StructDefinitions.remainingSupportBundleNode);
        add(mapping,
            "com.vmware.nsx.model.remote_bundle_url",
            com.vmware.nsx.model.StructDefinitions.remoteBundleUrl);
        add(mapping,
            "com.vmware.nsx.model.remote_file_server",
            com.vmware.nsx.model.StructDefinitions.remoteFileServer);
        add(mapping,
            "com.vmware.nsx.model.remote_server_fingerprint",
            com.vmware.nsx.model.StructDefinitions.remoteServerFingerprint);
        add(mapping,
            "com.vmware.nsx.model.remote_server_fingerprint_request",
            com.vmware.nsx.model.StructDefinitions.remoteServerFingerprintRequest);
        add(mapping,
            "com.vmware.nsx.model.remote_site_compatibility_info",
            com.vmware.nsx.model.StructDefinitions.remoteSiteCompatibilityInfo);
        add(mapping,
            "com.vmware.nsx.model.remote_site_credential",
            com.vmware.nsx.model.StructDefinitions.remoteSiteCredential);
        add(mapping,
            "com.vmware.nsx.model.remote_tunnel_endpoint",
            com.vmware.nsx.model.StructDefinitions.remoteTunnelEndpoint);
        add(mapping,
            "com.vmware.nsx.model.remote_tunnel_endpoint_config_state",
            com.vmware.nsx.model.StructDefinitions.remoteTunnelEndpointConfigState);
        add(mapping,
            "com.vmware.nsx.model.remote_tunnel_statistics",
            com.vmware.nsx.model.StructDefinitions.remoteTunnelStatistics);
        add(mapping,
            "com.vmware.nsx.model.remote_tunnel_statistics_per_site",
            com.vmware.nsx.model.StructDefinitions.remoteTunnelStatisticsPerSite);
        add(mapping,
            "com.vmware.nsx.model.render_configuration",
            com.vmware.nsx.model.StructDefinitions.renderConfiguration);
        add(mapping,
            "com.vmware.nsx.model.reorder_migration_request",
            com.vmware.nsx.model.StructDefinitions.reorderMigrationRequest);
        add(mapping,
            "com.vmware.nsx.model.reorder_request",
            com.vmware.nsx.model.StructDefinitions.reorderRequest);
        add(mapping,
            "com.vmware.nsx.model.repo_sync_status_report",
            com.vmware.nsx.model.StructDefinitions.repoSyncStatusReport);
        add(mapping,
            "com.vmware.nsx.model.reservation_info",
            com.vmware.nsx.model.StructDefinitions.reservationInfo);
        add(mapping,
            "com.vmware.nsx.model.reset_node_user_own_password_properties",
            com.vmware.nsx.model.StructDefinitions.resetNodeUserOwnPasswordProperties);
        add(mapping,
            "com.vmware.nsx.model.resource",
            com.vmware.nsx.model.StructDefinitions.resource);
        add(mapping,
            "com.vmware.nsx.model.resource_allocation",
            com.vmware.nsx.model.StructDefinitions.resourceAllocation);
        add(mapping,
            "com.vmware.nsx.model.resource_assignment",
            com.vmware.nsx.model.StructDefinitions.resourceAssignment);
        add(mapping,
            "com.vmware.nsx.model.resource_link",
            com.vmware.nsx.model.StructDefinitions.resourceLink);
        add(mapping,
            "com.vmware.nsx.model.resource_reference",
            com.vmware.nsx.model.StructDefinitions.resourceReference);
        add(mapping,
            "com.vmware.nsx.model.restore_configuration",
            com.vmware.nsx.model.StructDefinitions.restoreConfiguration);
        add(mapping,
            "com.vmware.nsx.model.restore_step",
            com.vmware.nsx.model.StructDefinitions.restoreStep);
        add(mapping,
            "com.vmware.nsx.model.revisioned_resource",
            com.vmware.nsx.model.StructDefinitions.revisionedResource);
        add(mapping,
            "com.vmware.nsx.model.role",
            com.vmware.nsx.model.StructDefinitions.role);
        add(mapping,
            "com.vmware.nsx.model.role_assignment_permission_config",
            com.vmware.nsx.model.StructDefinitions.roleAssignmentPermissionConfig);
        add(mapping,
            "com.vmware.nsx.model.role_binding",
            com.vmware.nsx.model.StructDefinitions.roleBinding);
        add(mapping,
            "com.vmware.nsx.model.role_binding_list_result",
            com.vmware.nsx.model.StructDefinitions.roleBindingListResult);
        add(mapping,
            "com.vmware.nsx.model.role_list_result",
            com.vmware.nsx.model.StructDefinitions.roleListResult);
        add(mapping,
            "com.vmware.nsx.model.role_with_features",
            com.vmware.nsx.model.StructDefinitions.roleWithFeatures);
        add(mapping,
            "com.vmware.nsx.model.role_with_features_list_result",
            com.vmware.nsx.model.StructDefinitions.roleWithFeaturesListResult);
        add(mapping,
            "com.vmware.nsx.model.roles_for_path",
            com.vmware.nsx.model.StructDefinitions.rolesForPath);
        add(mapping,
            "com.vmware.nsx.model.route_based_IP_sec_VPN_session",
            com.vmware.nsx.model.StructDefinitions.routeBasedIPSecVPNSession);
        add(mapping,
            "com.vmware.nsx.model.route_details",
            com.vmware.nsx.model.StructDefinitions.routeDetails);
        add(mapping,
            "com.vmware.nsx.model.route_map",
            com.vmware.nsx.model.StructDefinitions.routeMap);
        add(mapping,
            "com.vmware.nsx.model.route_map_list_result",
            com.vmware.nsx.model.StructDefinitions.routeMapListResult);
        add(mapping,
            "com.vmware.nsx.model.route_map_sequence",
            com.vmware.nsx.model.StructDefinitions.routeMapSequence);
        add(mapping,
            "com.vmware.nsx.model.route_map_sequence_match",
            com.vmware.nsx.model.StructDefinitions.routeMapSequenceMatch);
        add(mapping,
            "com.vmware.nsx.model.route_map_sequence_set",
            com.vmware.nsx.model.StructDefinitions.routeMapSequenceSet);
        add(mapping,
            "com.vmware.nsx.model.routes_per_transport_node",
            com.vmware.nsx.model.StructDefinitions.routesPerTransportNode);
        add(mapping,
            "com.vmware.nsx.model.routing_config",
            com.vmware.nsx.model.StructDefinitions.routingConfig);
        add(mapping,
            "com.vmware.nsx.model.routing_global_config",
            com.vmware.nsx.model.StructDefinitions.routingGlobalConfig);
        add(mapping,
            "com.vmware.nsx.model.routing_policy",
            com.vmware.nsx.model.StructDefinitions.routingPolicy);
        add(mapping,
            "com.vmware.nsx.model.row_list_field",
            com.vmware.nsx.model.StructDefinitions.rowListField);
        add(mapping,
            "com.vmware.nsx.model.rule_state",
            com.vmware.nsx.model.StructDefinitions.ruleState);
        add(mapping,
            "com.vmware.nsx.model.runtime_interface_operational_status",
            com.vmware.nsx.model.StructDefinitions.runtimeInterfaceOperationalStatus);
        add(mapping,
            "com.vmware.nsx.model.runtime_interface_statistics",
            com.vmware.nsx.model.StructDefinitions.runtimeInterfaceStatistics);
        add(mapping,
            "com.vmware.nsx.model.SHA_predefined_plugin_profile_data",
            com.vmware.nsx.model.StructDefinitions.SHAPredefinedPluginProfileData);
        add(mapping,
            "com.vmware.nsx.model.SI_aggregated_data_counter",
            com.vmware.nsx.model.StructDefinitions.SIAggregatedDataCounter);
        add(mapping,
            "com.vmware.nsx.model.SI_aggregated_data_counter_ex",
            com.vmware.nsx.model.StructDefinitions.SIAggregatedDataCounterEx);
        add(mapping,
            "com.vmware.nsx.model.SI_data_counter",
            com.vmware.nsx.model.StructDefinitions.SIDataCounter);
        add(mapping,
            "com.vmware.nsx.model.SI_error_class",
            com.vmware.nsx.model.StructDefinitions.SIErrorClass);
        add(mapping,
            "com.vmware.nsx.model.SI_exclude_list",
            com.vmware.nsx.model.StructDefinitions.SIExcludeList);
        add(mapping,
            "com.vmware.nsx.model.SI_mac_learning_counters",
            com.vmware.nsx.model.StructDefinitions.SIMacLearningCounters);
        add(mapping,
            "com.vmware.nsx.model.SI_packet_type_and_counter",
            com.vmware.nsx.model.StructDefinitions.SIPacketTypeAndCounter);
        add(mapping,
            "com.vmware.nsx.model.SI_packets_dropped_by_security",
            com.vmware.nsx.model.StructDefinitions.SIPacketsDroppedBySecurity);
        add(mapping,
            "com.vmware.nsx.model.SI_service_profile_list_result",
            com.vmware.nsx.model.StructDefinitions.SIServiceProfileListResult);
        add(mapping,
            "com.vmware.nsx.model.SVM_configure_issue",
            com.vmware.nsx.model.StructDefinitions.SVMConfigureIssue);
        add(mapping,
            "com.vmware.nsx.model.SVM_deployment_spec",
            com.vmware.nsx.model.StructDefinitions.SVMDeploymentSpec);
        add(mapping,
            "com.vmware.nsx.model.saml_token_login_credential",
            com.vmware.nsx.model.StructDefinitions.samlTokenLoginCredential);
        add(mapping,
            "com.vmware.nsx.model.sampling_argument",
            com.vmware.nsx.model.StructDefinitions.samplingArgument);
        add(mapping,
            "com.vmware.nsx.model.scim_search_list_result",
            com.vmware.nsx.model.StructDefinitions.scimSearchListResult);
        add(mapping,
            "com.vmware.nsx.model.scim_search_result",
            com.vmware.nsx.model.StructDefinitions.scimSearchResult);
        add(mapping,
            "com.vmware.nsx.model.scope_association",
            com.vmware.nsx.model.StructDefinitions.scopeAssociation);
        add(mapping,
            "com.vmware.nsx.model.scope_association_list",
            com.vmware.nsx.model.StructDefinitions.scopeAssociationList);
        add(mapping,
            "com.vmware.nsx.model.scope_association_list_result",
            com.vmware.nsx.model.StructDefinitions.scopeAssociationListResult);
        add(mapping,
            "com.vmware.nsx.model.scp_protocol",
            com.vmware.nsx.model.StructDefinitions.scpProtocol);
        add(mapping,
            "com.vmware.nsx.model.search_response",
            com.vmware.nsx.model.StructDefinitions.searchResponse);
        add(mapping,
            "com.vmware.nsx.model.security_certificate",
            com.vmware.nsx.model.StructDefinitions.securityCertificate);
        add(mapping,
            "com.vmware.nsx.model.security_global_config",
            com.vmware.nsx.model.StructDefinitions.securityGlobalConfig);
        add(mapping,
            "com.vmware.nsx.model.selectable_resource_reference",
            com.vmware.nsx.model.StructDefinitions.selectableResourceReference);
        add(mapping,
            "com.vmware.nsx.model.selective_sync_settings",
            com.vmware.nsx.model.StructDefinitions.selectiveSyncSettings);
        add(mapping,
            "com.vmware.nsx.model.self_resource_link",
            com.vmware.nsx.model.StructDefinitions.selfResourceLink);
        add(mapping,
            "com.vmware.nsx.model.server_ssl_profile_binding",
            com.vmware.nsx.model.StructDefinitions.serverSslProfileBinding);
        add(mapping,
            "com.vmware.nsx.model.service_association_list_result",
            com.vmware.nsx.model.StructDefinitions.serviceAssociationListResult);
        add(mapping,
            "com.vmware.nsx.model.service_attachment",
            com.vmware.nsx.model.StructDefinitions.serviceAttachment);
        add(mapping,
            "com.vmware.nsx.model.service_attachment_list_result",
            com.vmware.nsx.model.StructDefinitions.serviceAttachmentListResult);
        add(mapping,
            "com.vmware.nsx.model.service_binding",
            com.vmware.nsx.model.StructDefinitions.serviceBinding);
        add(mapping,
            "com.vmware.nsx.model.service_capability",
            com.vmware.nsx.model.StructDefinitions.serviceCapability);
        add(mapping,
            "com.vmware.nsx.model.service_chain",
            com.vmware.nsx.model.StructDefinitions.serviceChain);
        add(mapping,
            "com.vmware.nsx.model.service_chain_list_result",
            com.vmware.nsx.model.StructDefinitions.serviceChainListResult);
        add(mapping,
            "com.vmware.nsx.model.service_chain_mapping",
            com.vmware.nsx.model.StructDefinitions.serviceChainMapping);
        add(mapping,
            "com.vmware.nsx.model.service_chain_mapping_list_result",
            com.vmware.nsx.model.StructDefinitions.serviceChainMappingListResult);
        add(mapping,
            "com.vmware.nsx.model.service_config",
            com.vmware.nsx.model.StructDefinitions.serviceConfig);
        add(mapping,
            "com.vmware.nsx.model.service_config_list",
            com.vmware.nsx.model.StructDefinitions.serviceConfigList);
        add(mapping,
            "com.vmware.nsx.model.service_config_list_result",
            com.vmware.nsx.model.StructDefinitions.serviceConfigListResult);
        add(mapping,
            "com.vmware.nsx.model.service_definition",
            com.vmware.nsx.model.StructDefinitions.serviceDefinition);
        add(mapping,
            "com.vmware.nsx.model.service_deployment",
            com.vmware.nsx.model.StructDefinitions.serviceDeployment);
        add(mapping,
            "com.vmware.nsx.model.service_deployment_config",
            com.vmware.nsx.model.StructDefinitions.serviceDeploymentConfig);
        add(mapping,
            "com.vmware.nsx.model.service_deployment_issue",
            com.vmware.nsx.model.StructDefinitions.serviceDeploymentIssue);
        add(mapping,
            "com.vmware.nsx.model.service_deployment_list_result",
            com.vmware.nsx.model.StructDefinitions.serviceDeploymentListResult);
        add(mapping,
            "com.vmware.nsx.model.service_deployment_spec",
            com.vmware.nsx.model.StructDefinitions.serviceDeploymentSpec);
        add(mapping,
            "com.vmware.nsx.model.service_deployment_status",
            com.vmware.nsx.model.StructDefinitions.serviceDeploymentStatus);
        add(mapping,
            "com.vmware.nsx.model.service_endpoint",
            com.vmware.nsx.model.StructDefinitions.serviceEndpoint);
        add(mapping,
            "com.vmware.nsx.model.service_insertion_rule",
            com.vmware.nsx.model.StructDefinitions.serviceInsertionRule);
        add(mapping,
            "com.vmware.nsx.model.service_insertion_rule_list",
            com.vmware.nsx.model.StructDefinitions.serviceInsertionRuleList);
        add(mapping,
            "com.vmware.nsx.model.service_insertion_rule_list_result",
            com.vmware.nsx.model.StructDefinitions.serviceInsertionRuleListResult);
        add(mapping,
            "com.vmware.nsx.model.service_insertion_section",
            com.vmware.nsx.model.StructDefinitions.serviceInsertionSection);
        add(mapping,
            "com.vmware.nsx.model.service_insertion_section_list_result",
            com.vmware.nsx.model.StructDefinitions.serviceInsertionSectionListResult);
        add(mapping,
            "com.vmware.nsx.model.service_insertion_section_rule_list",
            com.vmware.nsx.model.StructDefinitions.serviceInsertionSectionRuleList);
        add(mapping,
            "com.vmware.nsx.model.service_insertion_service",
            com.vmware.nsx.model.StructDefinitions.serviceInsertionService);
        add(mapping,
            "com.vmware.nsx.model.service_insertion_service_list_result",
            com.vmware.nsx.model.StructDefinitions.serviceInsertionServiceListResult);
        add(mapping,
            "com.vmware.nsx.model.service_insertion_service_profile",
            com.vmware.nsx.model.StructDefinitions.serviceInsertionServiceProfile);
        add(mapping,
            "com.vmware.nsx.model.service_insertion_status",
            com.vmware.nsx.model.StructDefinitions.serviceInsertionStatus);
        add(mapping,
            "com.vmware.nsx.model.service_insertion_status_list_result",
            com.vmware.nsx.model.StructDefinitions.serviceInsertionStatusListResult);
        add(mapping,
            "com.vmware.nsx.model.service_instance",
            com.vmware.nsx.model.StructDefinitions.serviceInstance);
        add(mapping,
            "com.vmware.nsx.model.service_instance_health_status",
            com.vmware.nsx.model.StructDefinitions.serviceInstanceHealthStatus);
        add(mapping,
            "com.vmware.nsx.model.service_instance_list_result",
            com.vmware.nsx.model.StructDefinitions.serviceInstanceListResult);
        add(mapping,
            "com.vmware.nsx.model.service_instance_NS_groups",
            com.vmware.nsx.model.StructDefinitions.serviceInstanceNSGroups);
        add(mapping,
            "com.vmware.nsx.model.service_instance_status",
            com.vmware.nsx.model.StructDefinitions.serviceInstanceStatus);
        add(mapping,
            "com.vmware.nsx.model.service_manager",
            com.vmware.nsx.model.StructDefinitions.serviceManager);
        add(mapping,
            "com.vmware.nsx.model.service_manager_list_result",
            com.vmware.nsx.model.StructDefinitions.serviceManagerListResult);
        add(mapping,
            "com.vmware.nsx.model.service_path",
            com.vmware.nsx.model.StructDefinitions.servicePath);
        add(mapping,
            "com.vmware.nsx.model.service_path_hop",
            com.vmware.nsx.model.StructDefinitions.servicePathHop);
        add(mapping,
            "com.vmware.nsx.model.service_path_list_result",
            com.vmware.nsx.model.StructDefinitions.servicePathListResult);
        add(mapping,
            "com.vmware.nsx.model.service_profile_NS_groups",
            com.vmware.nsx.model.StructDefinitions.serviceProfileNSGroups);
        add(mapping,
            "com.vmware.nsx.model.service_router_allocation_config",
            com.vmware.nsx.model.StructDefinitions.serviceRouterAllocationConfig);
        add(mapping,
            "com.vmware.nsx.model.session_login_credential",
            com.vmware.nsx.model.StructDefinitions.sessionLoginCredential);
        add(mapping,
            "com.vmware.nsx.model.set_inter_site_aph_certificate_request",
            com.vmware.nsx.model.StructDefinitions.setInterSiteAphCertificateRequest);
        add(mapping,
            "com.vmware.nsx.model.set_principal_identity_certificate_for_federation_request",
            com.vmware.nsx.model.StructDefinitions.setPrincipalIdentityCertificateForFederationRequest);
        add(mapping,
            "com.vmware.nsx.model.setup_details",
            com.vmware.nsx.model.StructDefinitions.setupDetails);
        add(mapping,
            "com.vmware.nsx.model.sftp_protocol",
            com.vmware.nsx.model.StructDefinitions.sftpProtocol);
        add(mapping,
            "com.vmware.nsx.model.site_compatibility_info",
            com.vmware.nsx.model.StructDefinitions.siteCompatibilityInfo);
        add(mapping,
            "com.vmware.nsx.model.site_status",
            com.vmware.nsx.model.StructDefinitions.siteStatus);
        add(mapping,
            "com.vmware.nsx.model.smartnic_agent_status",
            com.vmware.nsx.model.StructDefinitions.smartnicAgentStatus);
        add(mapping,
            "com.vmware.nsx.model.snmp_properties",
            com.vmware.nsx.model.StructDefinitions.snmpProperties);
        add(mapping,
            "com.vmware.nsx.model.snmp_service_properties",
            com.vmware.nsx.model.StructDefinitions.snmpServiceProperties);
        add(mapping,
            "com.vmware.nsx.model.snmp_v3_user",
            com.vmware.nsx.model.StructDefinitions.snmpV3User);
        add(mapping,
            "com.vmware.nsx.model.snmpv2c_community",
            com.vmware.nsx.model.StructDefinitions.snmpv2cCommunity);
        add(mapping,
            "com.vmware.nsx.model.snmpv2c_properties",
            com.vmware.nsx.model.StructDefinitions.snmpv2cProperties);
        add(mapping,
            "com.vmware.nsx.model.snmpv2c_target",
            com.vmware.nsx.model.StructDefinitions.snmpv2cTarget);
        add(mapping,
            "com.vmware.nsx.model.snmpv3_properties",
            com.vmware.nsx.model.StructDefinitions.snmpv3Properties);
        add(mapping,
            "com.vmware.nsx.model.snmpv3_target",
            com.vmware.nsx.model.StructDefinitions.snmpv3Target);
        add(mapping,
            "com.vmware.nsx.model.snmpv3_user",
            com.vmware.nsx.model.StructDefinitions.snmpv3User);
        add(mapping,
            "com.vmware.nsx.model.software_module",
            com.vmware.nsx.model.StructDefinitions.softwareModule);
        add(mapping,
            "com.vmware.nsx.model.software_module_result",
            com.vmware.nsx.model.StructDefinitions.softwareModuleResult);
        add(mapping,
            "com.vmware.nsx.model.solution_config",
            com.vmware.nsx.model.StructDefinitions.solutionConfig);
        add(mapping,
            "com.vmware.nsx.model.solution_config_list_result",
            com.vmware.nsx.model.StructDefinitions.solutionConfigListResult);
        add(mapping,
            "com.vmware.nsx.model.source_entity",
            com.vmware.nsx.model.StructDefinitions.sourceEntity);
        add(mapping,
            "com.vmware.nsx.model.source_entity_result",
            com.vmware.nsx.model.StructDefinitions.sourceEntityResult);
        add(mapping,
            "com.vmware.nsx.model.source_nsx_api_endpoint",
            com.vmware.nsx.model.StructDefinitions.sourceNsxApiEndpoint);
        add(mapping,
            "com.vmware.nsx.model.spacer_widget_configuration",
            com.vmware.nsx.model.StructDefinitions.spacerWidgetConfiguration);
        add(mapping,
            "com.vmware.nsx.model.spoof_guard_switching_profile",
            com.vmware.nsx.model.StructDefinitions.spoofGuardSwitchingProfile);
        add(mapping,
            "com.vmware.nsx.model.ssh_fingerprint_properties",
            com.vmware.nsx.model.StructDefinitions.sshFingerprintProperties);
        add(mapping,
            "com.vmware.nsx.model.ssh_key_base_properties",
            com.vmware.nsx.model.StructDefinitions.sshKeyBaseProperties);
        add(mapping,
            "com.vmware.nsx.model.ssh_key_properties",
            com.vmware.nsx.model.StructDefinitions.sshKeyProperties);
        add(mapping,
            "com.vmware.nsx.model.ssh_key_properties_list_result",
            com.vmware.nsx.model.StructDefinitions.sshKeyPropertiesListResult);
        add(mapping,
            "com.vmware.nsx.model.ssh_service_properties",
            com.vmware.nsx.model.StructDefinitions.sshServiceProperties);
        add(mapping,
            "com.vmware.nsx.model.standard_host_switch",
            com.vmware.nsx.model.StructDefinitions.standardHostSwitch);
        add(mapping,
            "com.vmware.nsx.model.standard_host_switch_spec",
            com.vmware.nsx.model.StructDefinitions.standardHostSwitchSpec);
        add(mapping,
            "com.vmware.nsx.model.standby_relocation_config",
            com.vmware.nsx.model.StructDefinitions.standbyRelocationConfig);
        add(mapping,
            "com.vmware.nsx.model.stat_item",
            com.vmware.nsx.model.StructDefinitions.statItem);
        add(mapping,
            "com.vmware.nsx.model.static_filter",
            com.vmware.nsx.model.StructDefinitions.staticFilter);
        add(mapping,
            "com.vmware.nsx.model.static_hop_bfd_peer",
            com.vmware.nsx.model.StructDefinitions.staticHopBfdPeer);
        add(mapping,
            "com.vmware.nsx.model.static_hop_bfd_peer_list_result",
            com.vmware.nsx.model.StructDefinitions.staticHopBfdPeerListResult);
        add(mapping,
            "com.vmware.nsx.model.static_ip_list_spec",
            com.vmware.nsx.model.StructDefinitions.staticIpListSpec);
        add(mapping,
            "com.vmware.nsx.model.static_ip_mac_list_spec",
            com.vmware.nsx.model.StructDefinitions.staticIpMacListSpec);
        add(mapping,
            "com.vmware.nsx.model.static_ip_pool_spec",
            com.vmware.nsx.model.StructDefinitions.staticIpPoolSpec);
        add(mapping,
            "com.vmware.nsx.model.static_route",
            com.vmware.nsx.model.StructDefinitions.staticRoute);
        add(mapping,
            "com.vmware.nsx.model.static_route_list_result",
            com.vmware.nsx.model.StructDefinitions.staticRouteListResult);
        add(mapping,
            "com.vmware.nsx.model.static_route_next_hop",
            com.vmware.nsx.model.StructDefinitions.staticRouteNextHop);
        add(mapping,
            "com.vmware.nsx.model.stats_configuration",
            com.vmware.nsx.model.StructDefinitions.statsConfiguration);
        add(mapping,
            "com.vmware.nsx.model.status_count",
            com.vmware.nsx.model.StructDefinitions.statusCount);
        add(mapping,
            "com.vmware.nsx.model.structured_data",
            com.vmware.nsx.model.StructDefinitions.structuredData);
        add(mapping,
            "com.vmware.nsx.model.stub_status",
            com.vmware.nsx.model.StructDefinitions.stubStatus);
        add(mapping,
            "com.vmware.nsx.model.sub_pool",
            com.vmware.nsx.model.StructDefinitions.subPool);
        add(mapping,
            "com.vmware.nsx.model.subject_alt_names",
            com.vmware.nsx.model.StructDefinitions.subjectAltNames);
        add(mapping,
            "com.vmware.nsx.model.subject_public_key_hash",
            com.vmware.nsx.model.StructDefinitions.subjectPublicKeyHash);
        add(mapping,
            "com.vmware.nsx.model.subnet_ip_range",
            com.vmware.nsx.model.StructDefinitions.subnetIpRange);
        add(mapping,
            "com.vmware.nsx.model.success_node_support_bundle_result",
            com.vmware.nsx.model.StructDefinitions.successNodeSupportBundleResult);
        add(mapping,
            "com.vmware.nsx.model.summary_migration_feedback_request",
            com.vmware.nsx.model.StructDefinitions.summaryMigrationFeedbackRequest);
        add(mapping,
            "com.vmware.nsx.model.support_bundle_container_node",
            com.vmware.nsx.model.StructDefinitions.supportBundleContainerNode);
        add(mapping,
            "com.vmware.nsx.model.support_bundle_file_transfer_authentication_scheme",
            com.vmware.nsx.model.StructDefinitions.supportBundleFileTransferAuthenticationScheme);
        add(mapping,
            "com.vmware.nsx.model.support_bundle_file_transfer_protocol",
            com.vmware.nsx.model.StructDefinitions.supportBundleFileTransferProtocol);
        add(mapping,
            "com.vmware.nsx.model.support_bundle_query_parameters",
            com.vmware.nsx.model.StructDefinitions.supportBundleQueryParameters);
        add(mapping,
            "com.vmware.nsx.model.support_bundle_remote_file_server",
            com.vmware.nsx.model.StructDefinitions.supportBundleRemoteFileServer);
        add(mapping,
            "com.vmware.nsx.model.support_bundle_request",
            com.vmware.nsx.model.StructDefinitions.supportBundleRequest);
        add(mapping,
            "com.vmware.nsx.model.support_bundle_result",
            com.vmware.nsx.model.StructDefinitions.supportBundleResult);
        add(mapping,
            "com.vmware.nsx.model.supported_host_OS_list_result",
            com.vmware.nsx.model.StructDefinitions.supportedHostOSListResult);
        add(mapping,
            "com.vmware.nsx.model.svm_connectivity_status",
            com.vmware.nsx.model.StructDefinitions.svmConnectivityStatus);
        add(mapping,
            "com.vmware.nsx.model.switch_security_switching_profile",
            com.vmware.nsx.model.StructDefinitions.switchSecuritySwitchingProfile);
        add(mapping,
            "com.vmware.nsx.model.switching_global_config",
            com.vmware.nsx.model.StructDefinitions.switchingGlobalConfig);
        add(mapping,
            "com.vmware.nsx.model.switching_profile_status",
            com.vmware.nsx.model.StructDefinitions.switchingProfileStatus);
        add(mapping,
            "com.vmware.nsx.model.switching_profile_type_id_entry",
            com.vmware.nsx.model.StructDefinitions.switchingProfileTypeIdEntry);
        add(mapping,
            "com.vmware.nsx.model.switching_profiles_list_result",
            com.vmware.nsx.model.StructDefinitions.switchingProfilesListResult);
        add(mapping,
            "com.vmware.nsx.model.switching_to_vmc_mode_parameters",
            com.vmware.nsx.model.StructDefinitions.switchingToVmcModeParameters);
        add(mapping,
            "com.vmware.nsx.model.switchover_status",
            com.vmware.nsx.model.StructDefinitions.switchoverStatus);
        add(mapping,
            "com.vmware.nsx.model.syslog_configuration",
            com.vmware.nsx.model.StructDefinitions.syslogConfiguration);
        add(mapping,
            "com.vmware.nsx.model.syslog_exporter",
            com.vmware.nsx.model.StructDefinitions.syslogExporter);
        add(mapping,
            "com.vmware.nsx.model.syslog_properties",
            com.vmware.nsx.model.StructDefinitions.syslogProperties);
        add(mapping,
            "com.vmware.nsx.model.system_health_agent_profile",
            com.vmware.nsx.model.StructDefinitions.systemHealthAgentProfile);
        add(mapping,
            "com.vmware.nsx.model.system_health_agent_profile_list_result",
            com.vmware.nsx.model.StructDefinitions.systemHealthAgentProfileListResult);
        add(mapping,
            "com.vmware.nsx.model.system_health_plugin_profile",
            com.vmware.nsx.model.StructDefinitions.systemHealthPluginProfile);
        add(mapping,
            "com.vmware.nsx.model.system_health_plugin_profile_list",
            com.vmware.nsx.model.StructDefinitions.systemHealthPluginProfileList);
        add(mapping,
            "com.vmware.nsx.model.tag",
            com.vmware.nsx.model.StructDefinitions.tag);
        add(mapping,
            "com.vmware.nsx.model.target_resource_status",
            com.vmware.nsx.model.StructDefinitions.targetResourceStatus);
        add(mapping,
            "com.vmware.nsx.model.task_list_result",
            com.vmware.nsx.model.StructDefinitions.taskListResult);
        add(mapping,
            "com.vmware.nsx.model.task_properties",
            com.vmware.nsx.model.StructDefinitions.taskProperties);
        add(mapping,
            "com.vmware.nsx.model.tcp_header",
            com.vmware.nsx.model.StructDefinitions.tcpHeader);
        add(mapping,
            "com.vmware.nsx.model.tcp_mss_clamping",
            com.vmware.nsx.model.StructDefinitions.tcpMssClamping);
        add(mapping,
            "com.vmware.nsx.model.teaming_policy",
            com.vmware.nsx.model.StructDefinitions.teamingPolicy);
        add(mapping,
            "com.vmware.nsx.model.telemetry_agreement",
            com.vmware.nsx.model.StructDefinitions.telemetryAgreement);
        add(mapping,
            "com.vmware.nsx.model.telemetry_config",
            com.vmware.nsx.model.StructDefinitions.telemetryConfig);
        add(mapping,
            "com.vmware.nsx.model.telemetry_proxy",
            com.vmware.nsx.model.StructDefinitions.telemetryProxy);
        add(mapping,
            "com.vmware.nsx.model.telemetry_schedule",
            com.vmware.nsx.model.StructDefinitions.telemetrySchedule);
        add(mapping,
            "com.vmware.nsx.model.threat_status",
            com.vmware.nsx.model.StructDefinitions.threatStatus);
        add(mapping,
            "com.vmware.nsx.model.time_range_dropdown_filter_widget_configuration",
            com.vmware.nsx.model.StructDefinitions.timeRangeDropdownFilterWidgetConfiguration);
        add(mapping,
            "com.vmware.nsx.model.time_range_filter_info",
            com.vmware.nsx.model.StructDefinitions.timeRangeFilterInfo);
        add(mapping,
            "com.vmware.nsx.model.tls_service_endpoint",
            com.vmware.nsx.model.StructDefinitions.tlsServiceEndpoint);
        add(mapping,
            "com.vmware.nsx.model.tn_hyperbus_status",
            com.vmware.nsx.model.StructDefinitions.tnHyperbusStatus);
        add(mapping,
            "com.vmware.nsx.model.tn_node_agent_status_list_result",
            com.vmware.nsx.model.StructDefinitions.tnNodeAgentStatusListResult);
        add(mapping,
            "com.vmware.nsx.model.tn_node_agentstatus",
            com.vmware.nsx.model.StructDefinitions.tnNodeAgentstatus);
        add(mapping,
            "com.vmware.nsx.model.tn_node_stack_span_status",
            com.vmware.nsx.model.StructDefinitions.tnNodeStackSpanStatus);
        add(mapping,
            "com.vmware.nsx.model.token_based_principal_identity",
            com.vmware.nsx.model.StructDefinitions.tokenBasedPrincipalIdentity);
        add(mapping,
            "com.vmware.nsx.model.token_based_principal_identity_list_result",
            com.vmware.nsx.model.StructDefinitions.tokenBasedPrincipalIdentityListResult);
        add(mapping,
            "com.vmware.nsx.model.tooltip",
            com.vmware.nsx.model.StructDefinitions.tooltip);
        add(mapping,
            "com.vmware.nsx.model.trace_action_argument",
            com.vmware.nsx.model.StructDefinitions.traceActionArgument);
        add(mapping,
            "com.vmware.nsx.model.trace_action_config",
            com.vmware.nsx.model.StructDefinitions.traceActionConfig);
        add(mapping,
            "com.vmware.nsx.model.trace_result",
            com.vmware.nsx.model.StructDefinitions.traceResult);
        add(mapping,
            "com.vmware.nsx.model.traceflow",
            com.vmware.nsx.model.StructDefinitions.traceflow);
        add(mapping,
            "com.vmware.nsx.model.traceflow_list_result",
            com.vmware.nsx.model.StructDefinitions.traceflowListResult);
        add(mapping,
            "com.vmware.nsx.model.traceflow_observation",
            com.vmware.nsx.model.StructDefinitions.traceflowObservation);
        add(mapping,
            "com.vmware.nsx.model.traceflow_observation_counters",
            com.vmware.nsx.model.StructDefinitions.traceflowObservationCounters);
        add(mapping,
            "com.vmware.nsx.model.traceflow_observation_delivered",
            com.vmware.nsx.model.StructDefinitions.traceflowObservationDelivered);
        add(mapping,
            "com.vmware.nsx.model.traceflow_observation_dropped",
            com.vmware.nsx.model.StructDefinitions.traceflowObservationDropped);
        add(mapping,
            "com.vmware.nsx.model.traceflow_observation_dropped_logical",
            com.vmware.nsx.model.StructDefinitions.traceflowObservationDroppedLogical);
        add(mapping,
            "com.vmware.nsx.model.traceflow_observation_forwarded",
            com.vmware.nsx.model.StructDefinitions.traceflowObservationForwarded);
        add(mapping,
            "com.vmware.nsx.model.traceflow_observation_forwarded_logical",
            com.vmware.nsx.model.StructDefinitions.traceflowObservationForwardedLogical);
        add(mapping,
            "com.vmware.nsx.model.traceflow_observation_ipsec_vpn",
            com.vmware.nsx.model.StructDefinitions.traceflowObservationIpsecVpn);
        add(mapping,
            "com.vmware.nsx.model.traceflow_observation_list_result",
            com.vmware.nsx.model.StructDefinitions.traceflowObservationListResult);
        add(mapping,
            "com.vmware.nsx.model.traceflow_observation_protected",
            com.vmware.nsx.model.StructDefinitions.traceflowObservationProtected);
        add(mapping,
            "com.vmware.nsx.model.traceflow_observation_received",
            com.vmware.nsx.model.StructDefinitions.traceflowObservationReceived);
        add(mapping,
            "com.vmware.nsx.model.traceflow_observation_received_logical",
            com.vmware.nsx.model.StructDefinitions.traceflowObservationReceivedLogical);
        add(mapping,
            "com.vmware.nsx.model.traceflow_observation_relayed_logical",
            com.vmware.nsx.model.StructDefinitions.traceflowObservationRelayedLogical);
        add(mapping,
            "com.vmware.nsx.model.traceflow_observation_replication_logical",
            com.vmware.nsx.model.StructDefinitions.traceflowObservationReplicationLogical);
        add(mapping,
            "com.vmware.nsx.model.traceflow_request",
            com.vmware.nsx.model.StructDefinitions.traceflowRequest);
        add(mapping,
            "com.vmware.nsx.model.transport_info",
            com.vmware.nsx.model.StructDefinitions.transportInfo);
        add(mapping,
            "com.vmware.nsx.model.transport_node",
            com.vmware.nsx.model.StructDefinitions.transportNode);
        add(mapping,
            "com.vmware.nsx.model.transport_node_collection",
            com.vmware.nsx.model.StructDefinitions.transportNodeCollection);
        add(mapping,
            "com.vmware.nsx.model.transport_node_collection_list_result",
            com.vmware.nsx.model.StructDefinitions.transportNodeCollectionListResult);
        add(mapping,
            "com.vmware.nsx.model.transport_node_collection_state",
            com.vmware.nsx.model.StructDefinitions.transportNodeCollectionState);
        add(mapping,
            "com.vmware.nsx.model.transport_node_datapath_stats",
            com.vmware.nsx.model.StructDefinitions.transportNodeDatapathStats);
        add(mapping,
            "com.vmware.nsx.model.transport_node_deployment_progress_state",
            com.vmware.nsx.model.StructDefinitions.transportNodeDeploymentProgressState);
        add(mapping,
            "com.vmware.nsx.model.transport_node_list_result",
            com.vmware.nsx.model.StructDefinitions.transportNodeListResult);
        add(mapping,
            "com.vmware.nsx.model.transport_node_member_info",
            com.vmware.nsx.model.StructDefinitions.transportNodeMemberInfo);
        add(mapping,
            "com.vmware.nsx.model.transport_node_profile",
            com.vmware.nsx.model.StructDefinitions.transportNodeProfile);
        add(mapping,
            "com.vmware.nsx.model.transport_node_profile_list_result",
            com.vmware.nsx.model.StructDefinitions.transportNodeProfileListResult);
        add(mapping,
            "com.vmware.nsx.model.transport_node_profile_sub_config",
            com.vmware.nsx.model.StructDefinitions.transportNodeProfileSubConfig);
        add(mapping,
            "com.vmware.nsx.model.transport_node_remote_tunnel_endpoint_config",
            com.vmware.nsx.model.StructDefinitions.transportNodeRemoteTunnelEndpointConfig);
        add(mapping,
            "com.vmware.nsx.model.transport_node_state",
            com.vmware.nsx.model.StructDefinitions.transportNodeState);
        add(mapping,
            "com.vmware.nsx.model.transport_node_state_list_result",
            com.vmware.nsx.model.StructDefinitions.transportNodeStateListResult);
        add(mapping,
            "com.vmware.nsx.model.transport_node_status",
            com.vmware.nsx.model.StructDefinitions.transportNodeStatus);
        add(mapping,
            "com.vmware.nsx.model.transport_node_status_list_result",
            com.vmware.nsx.model.StructDefinitions.transportNodeStatusListResult);
        add(mapping,
            "com.vmware.nsx.model.transport_protocol_header",
            com.vmware.nsx.model.StructDefinitions.transportProtocolHeader);
        add(mapping,
            "com.vmware.nsx.model.transport_zone",
            com.vmware.nsx.model.StructDefinitions.transportZone);
        add(mapping,
            "com.vmware.nsx.model.transport_zone_end_point",
            com.vmware.nsx.model.StructDefinitions.transportZoneEndPoint);
        add(mapping,
            "com.vmware.nsx.model.transport_zone_list_result",
            com.vmware.nsx.model.StructDefinitions.transportZoneListResult);
        add(mapping,
            "com.vmware.nsx.model.transport_zone_profile",
            com.vmware.nsx.model.StructDefinitions.transportZoneProfile);
        add(mapping,
            "com.vmware.nsx.model.transport_zone_profile_list_result",
            com.vmware.nsx.model.StructDefinitions.transportZoneProfileListResult);
        add(mapping,
            "com.vmware.nsx.model.transport_zone_profile_type_id_entry",
            com.vmware.nsx.model.StructDefinitions.transportZoneProfileTypeIdEntry);
        add(mapping,
            "com.vmware.nsx.model.transport_zone_status",
            com.vmware.nsx.model.StructDefinitions.transportZoneStatus);
        add(mapping,
            "com.vmware.nsx.model.trigger_uc_upgrade_parameters",
            com.vmware.nsx.model.StructDefinitions.triggerUcUpgradeParameters);
        add(mapping,
            "com.vmware.nsx.model.trunk_vlan_range",
            com.vmware.nsx.model.StructDefinitions.trunkVlanRange);
        add(mapping,
            "com.vmware.nsx.model.trust_management_data",
            com.vmware.nsx.model.StructDefinitions.trustManagementData);
        add(mapping,
            "com.vmware.nsx.model.trust_object_data",
            com.vmware.nsx.model.StructDefinitions.trustObjectData);
        add(mapping,
            "com.vmware.nsx.model.tunnel_list",
            com.vmware.nsx.model.StructDefinitions.tunnelList);
        add(mapping,
            "com.vmware.nsx.model.tunnel_port_config",
            com.vmware.nsx.model.StructDefinitions.tunnelPortConfig);
        add(mapping,
            "com.vmware.nsx.model.tunnel_properties",
            com.vmware.nsx.model.StructDefinitions.tunnelProperties);
        add(mapping,
            "com.vmware.nsx.model.tunnel_status_count",
            com.vmware.nsx.model.StructDefinitions.tunnelStatusCount);
        add(mapping,
            "com.vmware.nsx.model.uc_functional_state",
            com.vmware.nsx.model.StructDefinitions.ucFunctionalState);
        add(mapping,
            "com.vmware.nsx.model.uc_state_properties",
            com.vmware.nsx.model.StructDefinitions.ucStateProperties);
        add(mapping,
            "com.vmware.nsx.model.uc_upgrade_status",
            com.vmware.nsx.model.StructDefinitions.ucUpgradeStatus);
        add(mapping,
            "com.vmware.nsx.model.udp_header",
            com.vmware.nsx.model.StructDefinitions.udpHeader);
        add(mapping,
            "com.vmware.nsx.model.unassociated_VM_list_result",
            com.vmware.nsx.model.StructDefinitions.unassociatedVMListResult);
        add(mapping,
            "com.vmware.nsx.model.unbounded_key_value_pair",
            com.vmware.nsx.model.StructDefinitions.unboundedKeyValuePair);
        add(mapping,
            "com.vmware.nsx.model.unidirectional_service_path",
            com.vmware.nsx.model.StructDefinitions.unidirectionalServicePath);
        add(mapping,
            "com.vmware.nsx.model.update_oidc_end_point_thumbprint_request",
            com.vmware.nsx.model.StructDefinitions.updateOidcEndPointThumbprintRequest);
        add(mapping,
            "com.vmware.nsx.model.update_principal_identity_certificate_request",
            com.vmware.nsx.model.StructDefinitions.updatePrincipalIdentityCertificateRequest);
        add(mapping,
            "com.vmware.nsx.model.upgrade_bundle_fetch_request",
            com.vmware.nsx.model.StructDefinitions.upgradeBundleFetchRequest);
        add(mapping,
            "com.vmware.nsx.model.upgrade_bundle_id",
            com.vmware.nsx.model.StructDefinitions.upgradeBundleId);
        add(mapping,
            "com.vmware.nsx.model.upgrade_bundle_info",
            com.vmware.nsx.model.StructDefinitions.upgradeBundleInfo);
        add(mapping,
            "com.vmware.nsx.model.upgrade_bundle_upload_status",
            com.vmware.nsx.model.StructDefinitions.upgradeBundleUploadStatus);
        add(mapping,
            "com.vmware.nsx.model.upgrade_check",
            com.vmware.nsx.model.StructDefinitions.upgradeCheck);
        add(mapping,
            "com.vmware.nsx.model.upgrade_check_csv_list_result",
            com.vmware.nsx.model.StructDefinitions.upgradeCheckCsvListResult);
        add(mapping,
            "com.vmware.nsx.model.upgrade_check_csv_record",
            com.vmware.nsx.model.StructDefinitions.upgradeCheckCsvRecord);
        add(mapping,
            "com.vmware.nsx.model.upgrade_check_failure",
            com.vmware.nsx.model.StructDefinitions.upgradeCheckFailure);
        add(mapping,
            "com.vmware.nsx.model.upgrade_check_failure_list_result",
            com.vmware.nsx.model.StructDefinitions.upgradeCheckFailureListResult);
        add(mapping,
            "com.vmware.nsx.model.upgrade_check_failure_message",
            com.vmware.nsx.model.StructDefinitions.upgradeCheckFailureMessage);
        add(mapping,
            "com.vmware.nsx.model.upgrade_check_info",
            com.vmware.nsx.model.StructDefinitions.upgradeCheckInfo);
        add(mapping,
            "com.vmware.nsx.model.upgrade_check_list_result",
            com.vmware.nsx.model.StructDefinitions.upgradeCheckListResult);
        add(mapping,
            "com.vmware.nsx.model.upgrade_check_list_results",
            com.vmware.nsx.model.StructDefinitions.upgradeCheckListResults);
        add(mapping,
            "com.vmware.nsx.model.upgrade_check_success",
            com.vmware.nsx.model.StructDefinitions.upgradeCheckSuccess);
        add(mapping,
            "com.vmware.nsx.model.upgrade_check_success_list_result",
            com.vmware.nsx.model.StructDefinitions.upgradeCheckSuccessListResult);
        add(mapping,
            "com.vmware.nsx.model.upgrade_check_success_message",
            com.vmware.nsx.model.StructDefinitions.upgradeCheckSuccessMessage);
        add(mapping,
            "com.vmware.nsx.model.upgrade_checks_execution_status",
            com.vmware.nsx.model.StructDefinitions.upgradeChecksExecutionStatus);
        add(mapping,
            "com.vmware.nsx.model.upgrade_history",
            com.vmware.nsx.model.StructDefinitions.upgradeHistory);
        add(mapping,
            "com.vmware.nsx.model.upgrade_history_list",
            com.vmware.nsx.model.StructDefinitions.upgradeHistoryList);
        add(mapping,
            "com.vmware.nsx.model.upgrade_plan_settings",
            com.vmware.nsx.model.StructDefinitions.upgradePlanSettings);
        add(mapping,
            "com.vmware.nsx.model.upgrade_progress_status",
            com.vmware.nsx.model.StructDefinitions.upgradeProgressStatus);
        add(mapping,
            "com.vmware.nsx.model.upgrade_status",
            com.vmware.nsx.model.StructDefinitions.upgradeStatus);
        add(mapping,
            "com.vmware.nsx.model.upgrade_status_summary",
            com.vmware.nsx.model.StructDefinitions.upgradeStatusSummary);
        add(mapping,
            "com.vmware.nsx.model.upgrade_summary",
            com.vmware.nsx.model.StructDefinitions.upgradeSummary);
        add(mapping,
            "com.vmware.nsx.model.upgrade_task_properties",
            com.vmware.nsx.model.StructDefinitions.upgradeTaskProperties);
        add(mapping,
            "com.vmware.nsx.model.upgrade_topology",
            com.vmware.nsx.model.StructDefinitions.upgradeTopology);
        add(mapping,
            "com.vmware.nsx.model.upgrade_unit",
            com.vmware.nsx.model.StructDefinitions.upgradeUnit);
        add(mapping,
            "com.vmware.nsx.model.upgrade_unit_aggregate_info",
            com.vmware.nsx.model.StructDefinitions.upgradeUnitAggregateInfo);
        add(mapping,
            "com.vmware.nsx.model.upgrade_unit_aggregate_info_list_result",
            com.vmware.nsx.model.StructDefinitions.upgradeUnitAggregateInfoListResult);
        add(mapping,
            "com.vmware.nsx.model.upgrade_unit_group",
            com.vmware.nsx.model.StructDefinitions.upgradeUnitGroup);
        add(mapping,
            "com.vmware.nsx.model.upgrade_unit_group_aggregate_info",
            com.vmware.nsx.model.StructDefinitions.upgradeUnitGroupAggregateInfo);
        add(mapping,
            "com.vmware.nsx.model.upgrade_unit_group_aggregate_info_list_result",
            com.vmware.nsx.model.StructDefinitions.upgradeUnitGroupAggregateInfoListResult);
        add(mapping,
            "com.vmware.nsx.model.upgrade_unit_group_info",
            com.vmware.nsx.model.StructDefinitions.upgradeUnitGroupInfo);
        add(mapping,
            "com.vmware.nsx.model.upgrade_unit_group_list_result",
            com.vmware.nsx.model.StructDefinitions.upgradeUnitGroupListResult);
        add(mapping,
            "com.vmware.nsx.model.upgrade_unit_group_status",
            com.vmware.nsx.model.StructDefinitions.upgradeUnitGroupStatus);
        add(mapping,
            "com.vmware.nsx.model.upgrade_unit_group_status_list_result",
            com.vmware.nsx.model.StructDefinitions.upgradeUnitGroupStatusListResult);
        add(mapping,
            "com.vmware.nsx.model.upgrade_unit_list",
            com.vmware.nsx.model.StructDefinitions.upgradeUnitList);
        add(mapping,
            "com.vmware.nsx.model.upgrade_unit_list_result",
            com.vmware.nsx.model.StructDefinitions.upgradeUnitListResult);
        add(mapping,
            "com.vmware.nsx.model.upgrade_unit_status",
            com.vmware.nsx.model.StructDefinitions.upgradeUnitStatus);
        add(mapping,
            "com.vmware.nsx.model.upgrade_unit_status_list_result",
            com.vmware.nsx.model.StructDefinitions.upgradeUnitStatusListResult);
        add(mapping,
            "com.vmware.nsx.model.upgrade_unit_type_stats",
            com.vmware.nsx.model.StructDefinitions.upgradeUnitTypeStats);
        add(mapping,
            "com.vmware.nsx.model.upgrade_unit_type_stats_list",
            com.vmware.nsx.model.StructDefinitions.upgradeUnitTypeStatsList);
        add(mapping,
            "com.vmware.nsx.model.uplink",
            com.vmware.nsx.model.StructDefinitions.uplink);
        add(mapping,
            "com.vmware.nsx.model.uplink_host_switch_profile",
            com.vmware.nsx.model.StructDefinitions.uplinkHostSwitchProfile);
        add(mapping,
            "com.vmware.nsx.model.url_alias",
            com.vmware.nsx.model.StructDefinitions.urlAlias);
        add(mapping,
            "com.vmware.nsx.model.user_info",
            com.vmware.nsx.model.StructDefinitions.userInfo);
        add(mapping,
            "com.vmware.nsx.model.username_password_login_credential",
            com.vmware.nsx.model.StructDefinitions.usernamePasswordLoginCredential);
        add(mapping,
            "com.vmware.nsx.model.v2t_site_mapping",
            com.vmware.nsx.model.StructDefinitions.v2tSiteMapping);
        add(mapping,
            "com.vmware.nsx.model.v2t_site_mapping_spec",
            com.vmware.nsx.model.StructDefinitions.v2tSiteMappingSpec);
        add(mapping,
            "com.vmware.nsx.model.VIP_subnet",
            com.vmware.nsx.model.StructDefinitions.VIPSubnet);
        add(mapping,
            "com.vmware.nsx.model.VM_deployment_progress_state",
            com.vmware.nsx.model.StructDefinitions.VMDeploymentProgressState);
        add(mapping,
            "com.vmware.nsx.model.validation_error",
            com.vmware.nsx.model.StructDefinitions.validationError);
        add(mapping,
            "com.vmware.nsx.model.vds_topology",
            com.vmware.nsx.model.StructDefinitions.vdsTopology);
        add(mapping,
            "com.vmware.nsx.model.vds_uplink",
            com.vmware.nsx.model.StructDefinitions.vdsUplink);
        add(mapping,
            "com.vmware.nsx.model.vendor_template",
            com.vmware.nsx.model.StructDefinitions.vendorTemplate);
        add(mapping,
            "com.vmware.nsx.model.vendor_template_list_result",
            com.vmware.nsx.model.StructDefinitions.vendorTemplateListResult);
        add(mapping,
            "com.vmware.nsx.model.verifiable_asymmetric_login_credential",
            com.vmware.nsx.model.StructDefinitions.verifiableAsymmetricLoginCredential);
        add(mapping,
            "com.vmware.nsx.model.verify_scim_user_or_group_exists_result",
            com.vmware.nsx.model.StructDefinitions.verifyScimUserOrGroupExistsResult);
        add(mapping,
            "com.vmware.nsx.model.version_list",
            com.vmware.nsx.model.StructDefinitions.versionList);
        add(mapping,
            "com.vmware.nsx.model.vidm_info",
            com.vmware.nsx.model.StructDefinitions.vidmInfo);
        add(mapping,
            "com.vmware.nsx.model.vidm_info_list_result",
            com.vmware.nsx.model.StructDefinitions.vidmInfoListResult);
        add(mapping,
            "com.vmware.nsx.model.view",
            com.vmware.nsx.model.StructDefinitions.view);
        add(mapping,
            "com.vmware.nsx.model.view_list",
            com.vmware.nsx.model.StructDefinitions.viewList);
        add(mapping,
            "com.vmware.nsx.model.vif_attachment_context",
            com.vmware.nsx.model.StructDefinitions.vifAttachmentContext);
        add(mapping,
            "com.vmware.nsx.model.virtual_machine",
            com.vmware.nsx.model.StructDefinitions.virtualMachine);
        add(mapping,
            "com.vmware.nsx.model.virtual_machine_list_result",
            com.vmware.nsx.model.StructDefinitions.virtualMachineListResult);
        add(mapping,
            "com.vmware.nsx.model.virtual_machine_runtime_info",
            com.vmware.nsx.model.StructDefinitions.virtualMachineRuntimeInfo);
        add(mapping,
            "com.vmware.nsx.model.virtual_machine_tag_update",
            com.vmware.nsx.model.StructDefinitions.virtualMachineTagUpdate);
        add(mapping,
            "com.vmware.nsx.model.virtual_network_interface",
            com.vmware.nsx.model.StructDefinitions.virtualNetworkInterface);
        add(mapping,
            "com.vmware.nsx.model.virtual_network_interface_list_result",
            com.vmware.nsx.model.StructDefinitions.virtualNetworkInterfaceListResult);
        add(mapping,
            "com.vmware.nsx.model.virtual_network_interface_runtime_info",
            com.vmware.nsx.model.StructDefinitions.virtualNetworkInterfaceRuntimeInfo);
        add(mapping,
            "com.vmware.nsx.model.virtual_service_instance",
            com.vmware.nsx.model.StructDefinitions.virtualServiceInstance);
        add(mapping,
            "com.vmware.nsx.model.virtual_switch",
            com.vmware.nsx.model.StructDefinitions.virtualSwitch);
        add(mapping,
            "com.vmware.nsx.model.virtual_switch_list_result",
            com.vmware.nsx.model.StructDefinitions.virtualSwitchListResult);
        add(mapping,
            "com.vmware.nsx.model.vlan_mirror_source",
            com.vmware.nsx.model.StructDefinitions.vlanMirrorSource);
        add(mapping,
            "com.vmware.nsx.model.vlan_trunk_spec",
            com.vmware.nsx.model.StructDefinitions.vlanTrunkSpec);
        add(mapping,
            "com.vmware.nsx.model.vm_group_execution_details",
            com.vmware.nsx.model.StructDefinitions.vmGroupExecutionDetails);
        add(mapping,
            "com.vmware.nsx.model.vm_nic_info",
            com.vmware.nsx.model.StructDefinitions.vmNicInfo);
        add(mapping,
            "com.vmware.nsx.model.vm_to_vnics_mapping",
            com.vmware.nsx.model.StructDefinitions.vmToVnicsMapping);
        add(mapping,
            "com.vmware.nsx.model.vm_tools_info",
            com.vmware.nsx.model.StructDefinitions.vmToolsInfo);
        add(mapping,
            "com.vmware.nsx.model.vm_tools_info_list_result",
            com.vmware.nsx.model.StructDefinitions.vmToolsInfoListResult);
        add(mapping,
            "com.vmware.nsx.model.vmknic_network",
            com.vmware.nsx.model.StructDefinitions.vmknicNetwork);
        add(mapping,
            "com.vmware.nsx.model.vni_pool",
            com.vmware.nsx.model.StructDefinitions.vniPool);
        add(mapping,
            "com.vmware.nsx.model.vni_pool_list_result",
            com.vmware.nsx.model.StructDefinitions.vniPoolListResult);
        add(mapping,
            "com.vmware.nsx.model.vni_range",
            com.vmware.nsx.model.StructDefinitions.vniRange);
        add(mapping,
            "com.vmware.nsx.model.vsphere_cluster_node_VM_deployment_config",
            com.vmware.nsx.model.StructDefinitions.vsphereClusterNodeVMDeploymentConfig);
        add(mapping,
            "com.vmware.nsx.model.vsphere_deployment_config",
            com.vmware.nsx.model.StructDefinitions.vsphereDeploymentConfig);
        add(mapping,
            "com.vmware.nsx.model.vtep_csv_list_result",
            com.vmware.nsx.model.StructDefinitions.vtepCsvListResult);
        add(mapping,
            "com.vmware.nsx.model.vtep_label_pool",
            com.vmware.nsx.model.StructDefinitions.vtepLabelPool);
        add(mapping,
            "com.vmware.nsx.model.vtep_label_pool_list_result",
            com.vmware.nsx.model.StructDefinitions.vtepLabelPoolListResult);
        add(mapping,
            "com.vmware.nsx.model.vtep_label_pool_usage",
            com.vmware.nsx.model.StructDefinitions.vtepLabelPoolUsage);
        add(mapping,
            "com.vmware.nsx.model.vtep_label_range",
            com.vmware.nsx.model.StructDefinitions.vtepLabelRange);
        add(mapping,
            "com.vmware.nsx.model.vtep_list_result",
            com.vmware.nsx.model.StructDefinitions.vtepListResult);
        add(mapping,
            "com.vmware.nsx.model.vtep_table_csv_record",
            com.vmware.nsx.model.StructDefinitions.vtepTableCsvRecord);
        add(mapping,
            "com.vmware.nsx.model.vtep_table_entry",
            com.vmware.nsx.model.StructDefinitions.vtepTableEntry);
        add(mapping,
            "com.vmware.nsx.model.weekly_backup_schedule",
            com.vmware.nsx.model.StructDefinitions.weeklyBackupSchedule);
        add(mapping,
            "com.vmware.nsx.model.weekly_telemetry_schedule",
            com.vmware.nsx.model.StructDefinitions.weeklyTelemetrySchedule);
        add(mapping,
            "com.vmware.nsx.model.widget_configuration",
            com.vmware.nsx.model.StructDefinitions.widgetConfiguration);
        add(mapping,
            "com.vmware.nsx.model.widget_configuration_list",
            com.vmware.nsx.model.StructDefinitions.widgetConfigurationList);
        add(mapping,
            "com.vmware.nsx.model.widget_item",
            com.vmware.nsx.model.StructDefinitions.widgetItem);
        add(mapping,
            "com.vmware.nsx.model.widget_plot_configuration",
            com.vmware.nsx.model.StructDefinitions.widgetPlotConfiguration);
        add(mapping,
            "com.vmware.nsx.model.x509_certificate",
            com.vmware.nsx.model.StructDefinitions.x509Certificate);
        add(mapping,
            "com.vmware.nsx.model.x509_crl",
            com.vmware.nsx.model.StructDefinitions.x509Crl);
        add(mapping,
            "com.vmware.nsx.model.x509_crl_entry",
            com.vmware.nsx.model.StructDefinitions.x509CrlEntry);
    }

    private static void add(Map<String, StructType> mapping, String key, StructType structType) {
        if (mapping.containsKey(key)) {
            throw new IllegalArgumentException("Two structures with the same canonical name detected: " + key +
                                               ". Unable to populate the map.");
        }
        mapping.put(key, structType);
    }
}
