/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.vpn.l2vpn.
 * Used by client-side stubs.
 */

package com.vmware.nsx.vpn.l2vpn;

public interface Services extends com.vmware.vapi.bindings.Service, com.vmware.nsx.vpn.l2vpn.ServicesTypes {

    /**
     * Create L2VPN service for a given logical router <br/> <br/> Please use below
     * Policy APIs. <br/> PATCH
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/l2vpn-services/<service-id> <br/> PATCH
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param l2VpnService (required)
     * @return com.vmware.nsx.model.L2VpnService
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.L2VpnService create(com.vmware.nsx.model.L2VpnService l2VpnService);

    /**
     * Create L2VPN service for a given logical router <br/> <br/> Please use below
     * Policy APIs. <br/> PATCH
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/l2vpn-services/<service-id> <br/> PATCH
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param l2VpnService (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.L2VpnService
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.L2VpnService create(com.vmware.nsx.model.L2VpnService l2VpnService, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Create L2VPN service for a given logical router <br/> <br/> Please use below
     * Policy APIs. <br/> PATCH
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/l2vpn-services/<service-id> <br/> PATCH
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.L2VpnService
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param l2VpnService (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void create(com.vmware.nsx.model.L2VpnService l2VpnService, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.L2VpnService> asyncCallback);

    /**
     * Create L2VPN service for a given logical router <br/> <br/> Please use below
     * Policy APIs. <br/> PATCH
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/l2vpn-services/<service-id> <br/> PATCH
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.L2VpnService
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param l2VpnService (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void create(com.vmware.nsx.model.L2VpnService l2VpnService, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.L2VpnService> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Delete a specific L2VPN service. If there are any L2VpnSessions on this
     * L2VpnService, those needs to be deleted first. <br/> <br/> Please use below
     * Policy APIs. <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/l2vpn-services/<service-id> <br/>
     * DELETE /policy/api/v1/infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param l2vpnServiceId (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void delete(java.lang.String l2vpnServiceId, java.lang.Boolean force);

    /**
     * Delete a specific L2VPN service. If there are any L2VpnSessions on this
     * L2VpnService, those needs to be deleted first. <br/> <br/> Please use below
     * Policy APIs. <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/l2vpn-services/<service-id> <br/>
     * DELETE /policy/api/v1/infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param l2vpnServiceId (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void delete(java.lang.String l2vpnServiceId, java.lang.Boolean force, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Delete a specific L2VPN service. If there are any L2VpnSessions on this
     * L2VpnService, those needs to be deleted first. <br/> <br/> Please use below
     * Policy APIs. <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/l2vpn-services/<service-id> <br/>
     * DELETE /policy/api/v1/infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param l2vpnServiceId (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void delete(java.lang.String l2vpnServiceId, java.lang.Boolean force, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Delete a specific L2VPN service. If there are any L2VpnSessions on this
     * L2VpnService, those needs to be deleted first. <br/> <br/> Please use below
     * Policy APIs. <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/l2vpn-services/<service-id> <br/>
     * DELETE /policy/api/v1/infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param l2vpnServiceId (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void delete(java.lang.String l2vpnServiceId, java.lang.Boolean force, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Get a specific L2VPN service <br/> <br/> Please use below Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/l2vpn-services/<service-id> <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param l2vpnServiceId (required)
     * @return com.vmware.nsx.model.L2VpnService
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.L2VpnService get(java.lang.String l2vpnServiceId);

    /**
     * Get a specific L2VPN service <br/> <br/> Please use below Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/l2vpn-services/<service-id> <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param l2vpnServiceId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.L2VpnService
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.L2VpnService get(java.lang.String l2vpnServiceId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get a specific L2VPN service <br/> <br/> Please use below Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/l2vpn-services/<service-id> <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.L2VpnService
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param l2vpnServiceId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String l2vpnServiceId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.L2VpnService> asyncCallback);

    /**
     * Get a specific L2VPN service <br/> <br/> Please use below Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/l2vpn-services/<service-id> <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.L2VpnService
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param l2vpnServiceId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String l2vpnServiceId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.L2VpnService> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Get paginated list of all L2VPN services <br/> <br/> Please use below Policy
     * APIs. <br/> GET /policy/api/v1/infra/tier-0s/<tier-0-id>/l2vpn-services <br/>
     * GET /policy/api/v1/infra/tier-1s/<tier-1-id>/l2vpn-services
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx.model.L2VpnServiceListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.L2VpnServiceListResult list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * Get paginated list of all L2VPN services <br/> <br/> Please use below Policy
     * APIs. <br/> GET /policy/api/v1/infra/tier-0s/<tier-0-id>/l2vpn-services <br/>
     * GET /policy/api/v1/infra/tier-1s/<tier-1-id>/l2vpn-services
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.L2VpnServiceListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.L2VpnServiceListResult list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get paginated list of all L2VPN services <br/> <br/> Please use below Policy
     * APIs. <br/> GET /policy/api/v1/infra/tier-0s/<tier-0-id>/l2vpn-services <br/>
     * GET /policy/api/v1/infra/tier-1s/<tier-1-id>/l2vpn-services
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.L2VpnServiceListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.L2VpnServiceListResult> asyncCallback);

    /**
     * Get paginated list of all L2VPN services <br/> <br/> Please use below Policy
     * APIs. <br/> GET /policy/api/v1/infra/tier-0s/<tier-0-id>/l2vpn-services <br/>
     * GET /policy/api/v1/infra/tier-1s/<tier-1-id>/l2vpn-services
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.L2VpnServiceListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.L2VpnServiceListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Edit a specific L2VPN service <br/> <br/> Please use below Policy APIs. <br/>
     * PUT /policy/api/v1/infra/tier-0s/<tier-0-id>/l2vpn-services/<service-id> <br/>
     * PUT /policy/api/v1/infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param l2vpnServiceId (required)
     * @param l2VpnService (required)
     * @return com.vmware.nsx.model.L2VpnService
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.L2VpnService update(java.lang.String l2vpnServiceId, com.vmware.nsx.model.L2VpnService l2VpnService);

    /**
     * Edit a specific L2VPN service <br/> <br/> Please use below Policy APIs. <br/>
     * PUT /policy/api/v1/infra/tier-0s/<tier-0-id>/l2vpn-services/<service-id> <br/>
     * PUT /policy/api/v1/infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param l2vpnServiceId (required)
     * @param l2VpnService (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.L2VpnService
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.L2VpnService update(java.lang.String l2vpnServiceId, com.vmware.nsx.model.L2VpnService l2VpnService, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Edit a specific L2VPN service <br/> <br/> Please use below Policy APIs. <br/>
     * PUT /policy/api/v1/infra/tier-0s/<tier-0-id>/l2vpn-services/<service-id> <br/>
     * PUT /policy/api/v1/infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.L2VpnService
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param l2vpnServiceId (required)
     * @param l2VpnService (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void update(java.lang.String l2vpnServiceId, com.vmware.nsx.model.L2VpnService l2VpnService, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.L2VpnService> asyncCallback);

    /**
     * Edit a specific L2VPN service <br/> <br/> Please use below Policy APIs. <br/>
     * PUT /policy/api/v1/infra/tier-0s/<tier-0-id>/l2vpn-services/<service-id> <br/>
     * PUT /policy/api/v1/infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.L2VpnService
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param l2vpnServiceId (required)
     * @param l2VpnService (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void update(java.lang.String l2vpnServiceId, com.vmware.nsx.model.L2VpnService l2VpnService, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.L2VpnService> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
