/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.nsx.dhcp.servers;

import com.vmware.nsx.dhcp.servers.IpPools;
import com.vmware.nsx.dhcp.servers.Ipv6IpPools;
import com.vmware.nsx.dhcp.servers.Ipv6StaticBindings;
import com.vmware.nsx.dhcp.servers.Leases;
import com.vmware.nsx.dhcp.servers.State;
import com.vmware.nsx.dhcp.servers.StaticBindings;
import com.vmware.nsx.dhcp.servers.Statistics;
import com.vmware.nsx.dhcp.servers.Status;
import com.vmware.nsx.dhcp.servers.ip_pools.IpPoolsFactory;
import com.vmware.nsx.dhcp.servers.static_bindings.StaticBindingsFactory;
import com.vmware.vapi.bindings.StubConfiguration;
import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vapi.bindings.StubFactory;

public class ServersFactory {
    private StubFactory stubFactory;
    private StubConfiguration stubConfig;

    private ServersFactory() {
    }

    public static ServersFactory getFactory(StubFactory stubFactory, StubConfiguration stubConfig) {
        ServersFactory instance = new ServersFactory();
        instance.stubFactory = stubFactory;
        instance.stubConfig = stubConfig;
        return instance;
    }

    public IpPools ipPoolsService() {
        return (IpPools)this.stubFactory.createStub(IpPools.class, (StubConfigurationBase)this.stubConfig);
    }

    public Ipv6IpPools ipv6IpPoolsService() {
        return (Ipv6IpPools)this.stubFactory.createStub(Ipv6IpPools.class, (StubConfigurationBase)this.stubConfig);
    }

    public Ipv6StaticBindings ipv6StaticBindingsService() {
        return (Ipv6StaticBindings)this.stubFactory.createStub(Ipv6StaticBindings.class, (StubConfigurationBase)this.stubConfig);
    }

    public Leases leasesService() {
        return (Leases)this.stubFactory.createStub(Leases.class, (StubConfigurationBase)this.stubConfig);
    }

    public State stateService() {
        return (State)this.stubFactory.createStub(State.class, (StubConfigurationBase)this.stubConfig);
    }

    public StaticBindings staticBindingsService() {
        return (StaticBindings)this.stubFactory.createStub(StaticBindings.class, (StubConfigurationBase)this.stubConfig);
    }

    public Statistics statisticsService() {
        return (Statistics)this.stubFactory.createStub(Statistics.class, (StubConfigurationBase)this.stubConfig);
    }

    public Status statusService() {
        return (Status)this.stubFactory.createStub(Status.class, (StubConfigurationBase)this.stubConfig);
    }

    public IpPoolsFactory ipPools() {
        return IpPoolsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public StaticBindingsFactory staticBindings() {
        return StaticBindingsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public void updateStubConfiguration(StubFactory stubFactory, StubConfiguration stubConfig) {
        if (this.stubFactory == stubFactory && this.stubConfig == stubConfig) {
            return;
        }
        this.stubFactory = stubFactory;
        this.stubConfig = stubConfig;
    }
}

