/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.cluster.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.cluster;

public interface Restore extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.cluster.RestoreTypes {

    /**
     * Advance any currently suspended restore operation. The operation might have been
     * suspended because (1) the user had suspended it previously, or (2) the operation
     * is waiting for user input, to be provided as a part of the POST request body.
     * This operation is only valid when a GET cluster/restore/status returns a status
     * with value SUSPENDED. Otherwise, a 409 response is returned.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param advanceClusterRestoreRequest (required)
     * @return com.vmware.nsx_policy.model.ClusterRestoreStatus
     * @throws com.vmware.vapi.std.errors.ConcurrentChange  Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.ClusterRestoreStatus advance(com.vmware.nsx_policy.model.AdvanceClusterRestoreRequest advanceClusterRestoreRequest);

    /**
     * Advance any currently suspended restore operation. The operation might have been
     * suspended because (1) the user had suspended it previously, or (2) the operation
     * is waiting for user input, to be provided as a part of the POST request body.
     * This operation is only valid when a GET cluster/restore/status returns a status
     * with value SUSPENDED. Otherwise, a 409 response is returned.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param advanceClusterRestoreRequest (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.ClusterRestoreStatus
     * @throws com.vmware.vapi.std.errors.ConcurrentChange  Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.ClusterRestoreStatus advance(com.vmware.nsx_policy.model.AdvanceClusterRestoreRequest advanceClusterRestoreRequest, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Advance any currently suspended restore operation. The operation might have been
     * suspended because (1) the user had suspended it previously, or (2) the operation
     * is waiting for user input, to be provided as a part of the POST request body.
     * This operation is only valid when a GET cluster/restore/status returns a status
     * with value SUSPENDED. Otherwise, a 409 response is returned.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ClusterRestoreStatus
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} -  Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param advanceClusterRestoreRequest (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void advance(com.vmware.nsx_policy.model.AdvanceClusterRestoreRequest advanceClusterRestoreRequest, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ClusterRestoreStatus> asyncCallback);

    /**
     * Advance any currently suspended restore operation. The operation might have been
     * suspended because (1) the user had suspended it previously, or (2) the operation
     * is waiting for user input, to be provided as a part of the POST request body.
     * This operation is only valid when a GET cluster/restore/status returns a status
     * with value SUSPENDED. Otherwise, a 409 response is returned.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ClusterRestoreStatus
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} -  Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param advanceClusterRestoreRequest (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void advance(com.vmware.nsx_policy.model.AdvanceClusterRestoreRequest advanceClusterRestoreRequest, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ClusterRestoreStatus> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * This operation is only valid when a restore is in suspended state. The UI user
     * can cancel any restore operation when the restore is suspended either due to an
     * error, or for a user input. The API user would need to monitor the progression
     * of a restore by calling periodically \"/api/v1/cluster/restore/status\" API. The
     * response object (ClusterRestoreStatus), contains a field \"endpoints\". The API
     * user can cancel the restore process if 'cancel' action is shown in the endpoint
     * field. This operation is only valid when a GET cluster/restore/status returns a
     * status with value SUSPENDED.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @return com.vmware.nsx_policy.model.ClusterRestoreStatus
     * @throws com.vmware.vapi.std.errors.ConcurrentChange  Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.ClusterRestoreStatus cancel();

    /**
     * This operation is only valid when a restore is in suspended state. The UI user
     * can cancel any restore operation when the restore is suspended either due to an
     * error, or for a user input. The API user would need to monitor the progression
     * of a restore by calling periodically \"/api/v1/cluster/restore/status\" API. The
     * response object (ClusterRestoreStatus), contains a field \"endpoints\". The API
     * user can cancel the restore process if 'cancel' action is shown in the endpoint
     * field. This operation is only valid when a GET cluster/restore/status returns a
     * status with value SUSPENDED.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.ClusterRestoreStatus
     * @throws com.vmware.vapi.std.errors.ConcurrentChange  Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.ClusterRestoreStatus cancel(com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * This operation is only valid when a restore is in suspended state. The UI user
     * can cancel any restore operation when the restore is suspended either due to an
     * error, or for a user input. The API user would need to monitor the progression
     * of a restore by calling periodically \"/api/v1/cluster/restore/status\" API. The
     * response object (ClusterRestoreStatus), contains a field \"endpoints\". The API
     * user can cancel the restore process if 'cancel' action is shown in the endpoint
     * field. This operation is only valid when a GET cluster/restore/status returns a
     * status with value SUSPENDED.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ClusterRestoreStatus
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} -  Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void cancel(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ClusterRestoreStatus> asyncCallback);

    /**
     * This operation is only valid when a restore is in suspended state. The UI user
     * can cancel any restore operation when the restore is suspended either due to an
     * error, or for a user input. The API user would need to monitor the progression
     * of a restore by calling periodically \"/api/v1/cluster/restore/status\" API. The
     * response object (ClusterRestoreStatus), contains a field \"endpoints\". The API
     * user can cancel the restore process if 'cancel' action is shown in the endpoint
     * field. This operation is only valid when a GET cluster/restore/status returns a
     * status with value SUSPENDED.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ClusterRestoreStatus
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} -  Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void cancel(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ClusterRestoreStatus> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Retry any currently in-progress, failed restore operation. Only the last step of
     * the multi-step restore operation would have failed,and only that step is
     * retried. This operation is only valid when a GET cluster/restore/status returns
     * a status with value FAILED. Otherwise, a 409 response is returned.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @return com.vmware.nsx_policy.model.ClusterRestoreStatus
     * @throws com.vmware.vapi.std.errors.ConcurrentChange  Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.ClusterRestoreStatus retry();

    /**
     * Retry any currently in-progress, failed restore operation. Only the last step of
     * the multi-step restore operation would have failed,and only that step is
     * retried. This operation is only valid when a GET cluster/restore/status returns
     * a status with value FAILED. Otherwise, a 409 response is returned.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.ClusterRestoreStatus
     * @throws com.vmware.vapi.std.errors.ConcurrentChange  Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.ClusterRestoreStatus retry(com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Retry any currently in-progress, failed restore operation. Only the last step of
     * the multi-step restore operation would have failed,and only that step is
     * retried. This operation is only valid when a GET cluster/restore/status returns
     * a status with value FAILED. Otherwise, a 409 response is returned.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ClusterRestoreStatus
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} -  Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void retry(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ClusterRestoreStatus> asyncCallback);

    /**
     * Retry any currently in-progress, failed restore operation. Only the last step of
     * the multi-step restore operation would have failed,and only that step is
     * retried. This operation is only valid when a GET cluster/restore/status returns
     * a status with value FAILED. Otherwise, a 409 response is returned.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ClusterRestoreStatus
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} -  Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void retry(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ClusterRestoreStatus> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Start the restore of an NSX cluster, from some previously backed-up
     * configuration. This operation is only valid when a GET cluster/restore/status
     * returns a status with value NOT_STARTED. Otherwise, a 409 response is returned.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param initiateClusterRestoreRequest (required)
     * @return com.vmware.nsx_policy.model.ClusterRestoreStatus
     * @throws com.vmware.vapi.std.errors.ConcurrentChange  Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.ClusterRestoreStatus start(com.vmware.nsx_policy.model.InitiateClusterRestoreRequest initiateClusterRestoreRequest);

    /**
     * Start the restore of an NSX cluster, from some previously backed-up
     * configuration. This operation is only valid when a GET cluster/restore/status
     * returns a status with value NOT_STARTED. Otherwise, a 409 response is returned.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param initiateClusterRestoreRequest (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.ClusterRestoreStatus
     * @throws com.vmware.vapi.std.errors.ConcurrentChange  Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.ClusterRestoreStatus start(com.vmware.nsx_policy.model.InitiateClusterRestoreRequest initiateClusterRestoreRequest, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Start the restore of an NSX cluster, from some previously backed-up
     * configuration. This operation is only valid when a GET cluster/restore/status
     * returns a status with value NOT_STARTED. Otherwise, a 409 response is returned.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ClusterRestoreStatus
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} -  Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param initiateClusterRestoreRequest (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void start(com.vmware.nsx_policy.model.InitiateClusterRestoreRequest initiateClusterRestoreRequest, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ClusterRestoreStatus> asyncCallback);

    /**
     * Start the restore of an NSX cluster, from some previously backed-up
     * configuration. This operation is only valid when a GET cluster/restore/status
     * returns a status with value NOT_STARTED. Otherwise, a 409 response is returned.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ClusterRestoreStatus
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} -  Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param initiateClusterRestoreRequest (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void start(com.vmware.nsx_policy.model.InitiateClusterRestoreRequest initiateClusterRestoreRequest, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ClusterRestoreStatus> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Suspend any currently running restore operation. The restore operation is made
     * up of a number of steps. When this call is issued, any currently running step is
     * allowed to finish (successfully or with errors), and the next step (and
     * therefore the entire restore operation) is suspended until a subsequent resume
     * or cancel call is issued. This operation is only valid when a GET
     * cluster/restore/status returns a status with value RUNNING. Otherwise, a 409
     * response is returned.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @return com.vmware.nsx_policy.model.ClusterRestoreStatus
     * @throws com.vmware.vapi.std.errors.ConcurrentChange  Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.ClusterRestoreStatus suspend();

    /**
     * Suspend any currently running restore operation. The restore operation is made
     * up of a number of steps. When this call is issued, any currently running step is
     * allowed to finish (successfully or with errors), and the next step (and
     * therefore the entire restore operation) is suspended until a subsequent resume
     * or cancel call is issued. This operation is only valid when a GET
     * cluster/restore/status returns a status with value RUNNING. Otherwise, a 409
     * response is returned.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.ClusterRestoreStatus
     * @throws com.vmware.vapi.std.errors.ConcurrentChange  Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.ClusterRestoreStatus suspend(com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Suspend any currently running restore operation. The restore operation is made
     * up of a number of steps. When this call is issued, any currently running step is
     * allowed to finish (successfully or with errors), and the next step (and
     * therefore the entire restore operation) is suspended until a subsequent resume
     * or cancel call is issued. This operation is only valid when a GET
     * cluster/restore/status returns a status with value RUNNING. Otherwise, a 409
     * response is returned.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ClusterRestoreStatus
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} -  Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void suspend(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ClusterRestoreStatus> asyncCallback);

    /**
     * Suspend any currently running restore operation. The restore operation is made
     * up of a number of steps. When this call is issued, any currently running step is
     * allowed to finish (successfully or with errors), and the next step (and
     * therefore the entire restore operation) is suspended until a subsequent resume
     * or cancel call is issued. This operation is only valid when a GET
     * cluster/restore/status returns a status with value RUNNING. Otherwise, a 409
     * response is returned.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ClusterRestoreStatus
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} -  Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void suspend(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ClusterRestoreStatus> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
