/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.cluster.backups.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.cluster.backups;

public interface Config extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.cluster.backups.ConfigTypes {

    /**
     * Get a configuration of a file server and timers for automated backup. Fields
     * that contain secrets (password, passphrase) are not returned.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @return com.vmware.nsx_policy.model.BackupConfiguration
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.BackupConfiguration get();

    /**
     * Get a configuration of a file server and timers for automated backup. Fields
     * that contain secrets (password, passphrase) are not returned.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.BackupConfiguration
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.BackupConfiguration get(com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get a configuration of a file server and timers for automated backup. Fields
     * that contain secrets (password, passphrase) are not returned.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.BackupConfiguration
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.BackupConfiguration> asyncCallback);

    /**
     * Get a configuration of a file server and timers for automated backup. Fields
     * that contain secrets (password, passphrase) are not returned.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.BackupConfiguration
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.BackupConfiguration> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Configure file server and timers for automated backup. If secret fields are
     * omitted (password, passphrase) then use the previously set value.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param backupConfiguration (required)
     * @param frameType Frame type (optional, default to LOCAL_LOCAL_MANAGER)
     * @param siteId Site ID (optional, default to localhost)
     * @return com.vmware.nsx_policy.model.BackupConfiguration
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.BackupConfiguration update(com.vmware.nsx_policy.model.BackupConfiguration backupConfiguration, java.lang.String frameType, java.lang.String siteId);

    /**
     * Configure file server and timers for automated backup. If secret fields are
     * omitted (password, passphrase) then use the previously set value.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param backupConfiguration (required)
     * @param frameType Frame type (optional, default to LOCAL_LOCAL_MANAGER)
     * @param siteId Site ID (optional, default to localhost)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.BackupConfiguration
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.BackupConfiguration update(com.vmware.nsx_policy.model.BackupConfiguration backupConfiguration, java.lang.String frameType, java.lang.String siteId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Configure file server and timers for automated backup. If secret fields are
     * omitted (password, passphrase) then use the previously set value.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.BackupConfiguration
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param backupConfiguration (required)
     * @param frameType Frame type (optional, default to LOCAL_LOCAL_MANAGER)
     * @param siteId Site ID (optional, default to localhost)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(com.vmware.nsx_policy.model.BackupConfiguration backupConfiguration, java.lang.String frameType, java.lang.String siteId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.BackupConfiguration> asyncCallback);

    /**
     * Configure file server and timers for automated backup. If secret fields are
     * omitted (password, passphrase) then use the previously set value.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.BackupConfiguration
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param backupConfiguration (required)
     * @param frameType Frame type (optional, default to LOCAL_LOCAL_MANAGER)
     * @param siteId Site ID (optional, default to localhost)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(com.vmware.nsx_policy.model.BackupConfiguration backupConfiguration, java.lang.String frameType, java.lang.String siteId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.BackupConfiguration> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
