/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.global_infra.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.global_infra;

public interface GroupAssociations extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.global_infra.GroupAssociationsTypes {

    /**
     * Get policy groups for which the given object is a member. In Federation
     * environment, if the given object is a global entity (eg: global segment) and if
     * the entity is not stretched to the site specified in the enforcement_point_path
     * parameter,then the following is returned:- 1)If the entity is a member of any
     * global group and that group is stretched to the enforcement_point_path site,then
     * the API returns an empty list. 2)If the entity is not a member of any global
     * group,this API returns an 'invalid path' error message. 3)If both the entity and
     * its corresponding groups are stretched to the enforcement_point_path site , then
     * the API returns the groups list.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param intentPath String path of the intent object (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx_policy.model.PolicyResourceReferenceForEPListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.PolicyResourceReferenceForEPListResult list(java.lang.String intentPath, java.lang.String cursor, java.lang.String enforcementPointPath, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * Get policy groups for which the given object is a member. In Federation
     * environment, if the given object is a global entity (eg: global segment) and if
     * the entity is not stretched to the site specified in the enforcement_point_path
     * parameter,then the following is returned:- 1)If the entity is a member of any
     * global group and that group is stretched to the enforcement_point_path site,then
     * the API returns an empty list. 2)If the entity is not a member of any global
     * group,this API returns an 'invalid path' error message. 3)If both the entity and
     * its corresponding groups are stretched to the enforcement_point_path site , then
     * the API returns the groups list.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param intentPath String path of the intent object (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.PolicyResourceReferenceForEPListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.PolicyResourceReferenceForEPListResult list(java.lang.String intentPath, java.lang.String cursor, java.lang.String enforcementPointPath, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get policy groups for which the given object is a member. In Federation
     * environment, if the given object is a global entity (eg: global segment) and if
     * the entity is not stretched to the site specified in the enforcement_point_path
     * parameter,then the following is returned:- 1)If the entity is a member of any
     * global group and that group is stretched to the enforcement_point_path site,then
     * the API returns an empty list. 2)If the entity is not a member of any global
     * group,this API returns an 'invalid path' error message. 3)If both the entity and
     * its corresponding groups are stretched to the enforcement_point_path site , then
     * the API returns the groups list.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyResourceReferenceForEPListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param intentPath String path of the intent object (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String intentPath, java.lang.String cursor, java.lang.String enforcementPointPath, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyResourceReferenceForEPListResult> asyncCallback);

    /**
     * Get policy groups for which the given object is a member. In Federation
     * environment, if the given object is a global entity (eg: global segment) and if
     * the entity is not stretched to the site specified in the enforcement_point_path
     * parameter,then the following is returned:- 1)If the entity is a member of any
     * global group and that group is stretched to the enforcement_point_path site,then
     * the API returns an empty list. 2)If the entity is not a member of any global
     * group,this API returns an 'invalid path' error message. 3)If both the entity and
     * its corresponding groups are stretched to the enforcement_point_path site , then
     * the API returns the groups list.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyResourceReferenceForEPListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param intentPath String path of the intent object (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String intentPath, java.lang.String cursor, java.lang.String enforcementPointPath, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyResourceReferenceForEPListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
