
/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 */


package com.vmware.nsx_policy.infra;

/**
 * {@link InfraFactory} is responsible for creating instances of services
 * contained inside the com.vmware.nsx_policy.infra package and also has the subpackages reference
 * to access respective subpackage services.
 * <p>
*/
public class InfraFactory {

    private com.vmware.vapi.bindings.StubFactory stubFactory;
    private com.vmware.vapi.bindings.StubConfiguration stubConfig;

    // restricting developers to create instance of this class directly
    private InfraFactory() {

    }

    /**
     * Creates the new instance of this class with provided configuration
     * @param stubFactory {@link StubFactory} instance is responsible for creating stubs
     * @param stubConfig {@link StubConfiguration} instance is required to authenticate the request
     * @return {@link InfraFactory} factory instance
     */
    public static InfraFactory getFactory(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        InfraFactory instance = new InfraFactory();
        instance.stubFactory = stubFactory;
        instance.stubConfig = stubConfig;
        return instance;
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbAnalyticsProfiles}
     */
    public com.vmware.nsx_policy.infra.AlbAnalyticsProfiles albAnalyticsProfilesService() {
        return this.stubFactory.createStub(AlbAnalyticsProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbApplicationPersistenceProfiles}
     */
    public com.vmware.nsx_policy.infra.AlbApplicationPersistenceProfiles albApplicationPersistenceProfilesService() {
        return this.stubFactory.createStub(AlbApplicationPersistenceProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbApplicationProfiles}
     */
    public com.vmware.nsx_policy.infra.AlbApplicationProfiles albApplicationProfilesService() {
        return this.stubFactory.createStub(AlbApplicationProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbAuthProfiles}
     */
    public com.vmware.nsx_policy.infra.AlbAuthProfiles albAuthProfilesService() {
        return this.stubFactory.createStub(AlbAuthProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbAuthToken}
     */
    public com.vmware.nsx_policy.infra.AlbAuthToken albAuthTokenService() {
        return this.stubFactory.createStub(AlbAuthToken.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbAutoScaleLaunchConfigs}
     */
    public com.vmware.nsx_policy.infra.AlbAutoScaleLaunchConfigs albAutoScaleLaunchConfigsService() {
        return this.stubFactory.createStub(AlbAutoScaleLaunchConfigs.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbControllerVersion}
     */
    public com.vmware.nsx_policy.infra.AlbControllerVersion albControllerVersionService() {
        return this.stubFactory.createStub(AlbControllerVersion.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbDnsPolicies}
     */
    public com.vmware.nsx_policy.infra.AlbDnsPolicies albDnsPoliciesService() {
        return this.stubFactory.createStub(AlbDnsPolicies.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbErrorPageBodies}
     */
    public com.vmware.nsx_policy.infra.AlbErrorPageBodies albErrorPageBodiesService() {
        return this.stubFactory.createStub(AlbErrorPageBodies.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbErrorPageProfiles}
     */
    public com.vmware.nsx_policy.infra.AlbErrorPageProfiles albErrorPageProfilesService() {
        return this.stubFactory.createStub(AlbErrorPageProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbHardwareSecurityModuleGroups}
     */
    public com.vmware.nsx_policy.infra.AlbHardwareSecurityModuleGroups albHardwareSecurityModuleGroupsService() {
        return this.stubFactory.createStub(AlbHardwareSecurityModuleGroups.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbHealthMonitors}
     */
    public com.vmware.nsx_policy.infra.AlbHealthMonitors albHealthMonitorsService() {
        return this.stubFactory.createStub(AlbHealthMonitors.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbHttpPolicySets}
     */
    public com.vmware.nsx_policy.infra.AlbHttpPolicySets albHttpPolicySetsService() {
        return this.stubFactory.createStub(AlbHttpPolicySets.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbIpAddrGroups}
     */
    public com.vmware.nsx_policy.infra.AlbIpAddrGroups albIpAddrGroupsService() {
        return this.stubFactory.createStub(AlbIpAddrGroups.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbL4PolicySets}
     */
    public com.vmware.nsx_policy.infra.AlbL4PolicySets albL4PolicySetsService() {
        return this.stubFactory.createStub(AlbL4PolicySets.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbNetworkProfiles}
     */
    public com.vmware.nsx_policy.infra.AlbNetworkProfiles albNetworkProfilesService() {
        return this.stubFactory.createStub(AlbNetworkProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbNetworkSecurityPolicies}
     */
    public com.vmware.nsx_policy.infra.AlbNetworkSecurityPolicies albNetworkSecurityPoliciesService() {
        return this.stubFactory.createStub(AlbNetworkSecurityPolicies.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbOnboardingWorkflow}
     */
    public com.vmware.nsx_policy.infra.AlbOnboardingWorkflow albOnboardingWorkflowService() {
        return this.stubFactory.createStub(AlbOnboardingWorkflow.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbPkiProfiles}
     */
    public com.vmware.nsx_policy.infra.AlbPkiProfiles albPkiProfilesService() {
        return this.stubFactory.createStub(AlbPkiProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbPoolGroupDeploymentPolicies}
     */
    public com.vmware.nsx_policy.infra.AlbPoolGroupDeploymentPolicies albPoolGroupDeploymentPoliciesService() {
        return this.stubFactory.createStub(AlbPoolGroupDeploymentPolicies.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbPoolGroups}
     */
    public com.vmware.nsx_policy.infra.AlbPoolGroups albPoolGroupsService() {
        return this.stubFactory.createStub(AlbPoolGroups.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbPools}
     */
    public com.vmware.nsx_policy.infra.AlbPools albPoolsService() {
        return this.stubFactory.createStub(AlbPools.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbPriorityLabels}
     */
    public com.vmware.nsx_policy.infra.AlbPriorityLabels albPriorityLabelsService() {
        return this.stubFactory.createStub(AlbPriorityLabels.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbProtocolParsers}
     */
    public com.vmware.nsx_policy.infra.AlbProtocolParsers albProtocolParsersService() {
        return this.stubFactory.createStub(AlbProtocolParsers.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbSecurityPolicies}
     */
    public com.vmware.nsx_policy.infra.AlbSecurityPolicies albSecurityPoliciesService() {
        return this.stubFactory.createStub(AlbSecurityPolicies.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbServerAutoScalePolicies}
     */
    public com.vmware.nsx_policy.infra.AlbServerAutoScalePolicies albServerAutoScalePoliciesService() {
        return this.stubFactory.createStub(AlbServerAutoScalePolicies.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbSslKeyAndCertificates}
     */
    public com.vmware.nsx_policy.infra.AlbSslKeyAndCertificates albSslKeyAndCertificatesService() {
        return this.stubFactory.createStub(AlbSslKeyAndCertificates.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbSslProfiles}
     */
    public com.vmware.nsx_policy.infra.AlbSslProfiles albSslProfilesService() {
        return this.stubFactory.createStub(AlbSslProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbSsoPolicies}
     */
    public com.vmware.nsx_policy.infra.AlbSsoPolicies albSsoPoliciesService() {
        return this.stubFactory.createStub(AlbSsoPolicies.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbStringGroups}
     */
    public com.vmware.nsx_policy.infra.AlbStringGroups albStringGroupsService() {
        return this.stubFactory.createStub(AlbStringGroups.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbTrafficCloneProfiles}
     */
    public com.vmware.nsx_policy.infra.AlbTrafficCloneProfiles albTrafficCloneProfilesService() {
        return this.stubFactory.createStub(AlbTrafficCloneProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbVirtualServices}
     */
    public com.vmware.nsx_policy.infra.AlbVirtualServices albVirtualServicesService() {
        return this.stubFactory.createStub(AlbVirtualServices.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbVsDataScriptSets}
     */
    public com.vmware.nsx_policy.infra.AlbVsDataScriptSets albVsDataScriptSetsService() {
        return this.stubFactory.createStub(AlbVsDataScriptSets.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbVsVips}
     */
    public com.vmware.nsx_policy.infra.AlbVsVips albVsVipsService() {
        return this.stubFactory.createStub(AlbVsVips.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbWafCrs}
     */
    public com.vmware.nsx_policy.infra.AlbWafCrs albWafCrsService() {
        return this.stubFactory.createStub(AlbWafCrs.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbWafPolicies}
     */
    public com.vmware.nsx_policy.infra.AlbWafPolicies albWafPoliciesService() {
        return this.stubFactory.createStub(AlbWafPolicies.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbWafPolicyPsmGroups}
     */
    public com.vmware.nsx_policy.infra.AlbWafPolicyPsmGroups albWafPolicyPsmGroupsService() {
        return this.stubFactory.createStub(AlbWafPolicyPsmGroups.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbWafProfiles}
     */
    public com.vmware.nsx_policy.infra.AlbWafProfiles albWafProfilesService() {
        return this.stubFactory.createStub(AlbWafProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.AlbWebhooks}
     */
    public com.vmware.nsx_policy.infra.AlbWebhooks albWebhooksService() {
        return this.stubFactory.createStub(AlbWebhooks.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.BfdProfiles}
     */
    public com.vmware.nsx_policy.infra.BfdProfiles bfdProfilesService() {
        return this.stubFactory.createStub(BfdProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.Cabundles}
     */
    public com.vmware.nsx_policy.infra.Cabundles cabundlesService() {
        return this.stubFactory.createStub(Cabundles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.Certificates}
     */
    public com.vmware.nsx_policy.infra.Certificates certificatesService() {
        return this.stubFactory.createStub(Certificates.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.CloudNativeServiceGroupAssociations}
     */
    public com.vmware.nsx_policy.infra.CloudNativeServiceGroupAssociations cloudNativeServiceGroupAssociationsService() {
        return this.stubFactory.createStub(CloudNativeServiceGroupAssociations.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.ConnectivityGlobalConfig}
     */
    public com.vmware.nsx_policy.infra.ConnectivityGlobalConfig connectivityGlobalConfigService() {
        return this.stubFactory.createStub(ConnectivityGlobalConfig.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.Constraints}
     */
    public com.vmware.nsx_policy.infra.Constraints constraintsService() {
        return this.stubFactory.createStub(Constraints.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.ContextProfiles}
     */
    public com.vmware.nsx_policy.infra.ContextProfiles contextProfilesService() {
        return this.stubFactory.createStub(ContextProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.Crls}
     */
    public com.vmware.nsx_policy.infra.Crls crlsService() {
        return this.stubFactory.createStub(Crls.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.Csrs}
     */
    public com.vmware.nsx_policy.infra.Csrs csrsService() {
        return this.stubFactory.createStub(Csrs.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.DeploymentZones}
     */
    public com.vmware.nsx_policy.infra.DeploymentZones deploymentZonesService() {
        return this.stubFactory.createStub(DeploymentZones.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.DhcpRelayConfigs}
     */
    public com.vmware.nsx_policy.infra.DhcpRelayConfigs dhcpRelayConfigsService() {
        return this.stubFactory.createStub(DhcpRelayConfigs.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.DhcpServerConfigs}
     */
    public com.vmware.nsx_policy.infra.DhcpServerConfigs dhcpServerConfigsService() {
        return this.stubFactory.createStub(DhcpServerConfigs.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.DnsForwarderZones}
     */
    public com.vmware.nsx_policy.infra.DnsForwarderZones dnsForwarderZonesService() {
        return this.stubFactory.createStub(DnsForwarderZones.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.DnsSecurityProfiles}
     */
    public com.vmware.nsx_policy.infra.DnsSecurityProfiles dnsSecurityProfilesService() {
        return this.stubFactory.createStub(DnsSecurityProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.Domains}
     */
    public com.vmware.nsx_policy.infra.Domains domainsService() {
        return this.stubFactory.createStub(Domains.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.Drafts}
     */
    public com.vmware.nsx_policy.infra.Drafts draftsService() {
        return this.stubFactory.createStub(Drafts.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.EvpnTenantConfigs}
     */
    public com.vmware.nsx_policy.infra.EvpnTenantConfigs evpnTenantConfigsService() {
        return this.stubFactory.createStub(EvpnTenantConfigs.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.FederationConfig}
     */
    public com.vmware.nsx_policy.infra.FederationConfig federationConfigService() {
        return this.stubFactory.createStub(FederationConfig.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.FirewallIdentityStoreLdapServer}
     */
    public com.vmware.nsx_policy.infra.FirewallIdentityStoreLdapServer firewallIdentityStoreLdapServerService() {
        return this.stubFactory.createStub(FirewallIdentityStoreLdapServer.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.FirewallIdentityStoreSize}
     */
    public com.vmware.nsx_policy.infra.FirewallIdentityStoreSize firewallIdentityStoreSizeService() {
        return this.stubFactory.createStub(FirewallIdentityStoreSize.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.FirewallIdentityStores}
     */
    public com.vmware.nsx_policy.infra.FirewallIdentityStores firewallIdentityStoresService() {
        return this.stubFactory.createStub(FirewallIdentityStores.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.FirewallIdentityStoresOrgUnits}
     */
    public com.vmware.nsx_policy.infra.FirewallIdentityStoresOrgUnits firewallIdentityStoresOrgUnitsService() {
        return this.stubFactory.createStub(FirewallIdentityStoresOrgUnits.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.FirewallIpReputationFeed}
     */
    public com.vmware.nsx_policy.infra.FirewallIpReputationFeed firewallIpReputationFeedService() {
        return this.stubFactory.createStub(FirewallIpReputationFeed.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.FirewallSchedulers}
     */
    public com.vmware.nsx_policy.infra.FirewallSchedulers firewallSchedulersService() {
        return this.stubFactory.createStub(FirewallSchedulers.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.FirewallSessionTimerProfiles}
     */
    public com.vmware.nsx_policy.infra.FirewallSessionTimerProfiles firewallSessionTimerProfilesService() {
        return this.stubFactory.createStub(FirewallSessionTimerProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.FloodProtectionProfiles}
     */
    public com.vmware.nsx_policy.infra.FloodProtectionProfiles floodProtectionProfilesService() {
        return this.stubFactory.createStub(FloodProtectionProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.FullSyncAction}
     */
    public com.vmware.nsx_policy.infra.FullSyncAction fullSyncActionService() {
        return this.stubFactory.createStub(FullSyncAction.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.FullSyncStates}
     */
    public com.vmware.nsx_policy.infra.FullSyncStates fullSyncStatesService() {
        return this.stubFactory.createStub(FullSyncStates.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.GatewayQosProfiles}
     */
    public com.vmware.nsx_policy.infra.GatewayQosProfiles gatewayQosProfilesService() {
        return this.stubFactory.createStub(GatewayQosProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.GlobalConfig}
     */
    public com.vmware.nsx_policy.infra.GlobalConfig globalConfigService() {
        return this.stubFactory.createStub(GlobalConfig.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.GroupAssociations}
     */
    public com.vmware.nsx_policy.infra.GroupAssociations groupAssociationsService() {
        return this.stubFactory.createStub(GroupAssociations.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.GroupServiceAssociations}
     */
    public com.vmware.nsx_policy.infra.GroupServiceAssociations groupServiceAssociationsService() {
        return this.stubFactory.createStub(GroupServiceAssociations.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.HostSwitchProfiles}
     */
    public com.vmware.nsx_policy.infra.HostSwitchProfiles hostSwitchProfilesService() {
        return this.stubFactory.createStub(HostSwitchProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.HostTransportNodeProfiles}
     */
    public com.vmware.nsx_policy.infra.HostTransportNodeProfiles hostTransportNodeProfilesService() {
        return this.stubFactory.createStub(HostTransportNodeProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.IdentityFirewallStores}
     */
    public com.vmware.nsx_policy.infra.IdentityFirewallStores identityFirewallStoresService() {
        return this.stubFactory.createStub(IdentityFirewallStores.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.IdentityGroupAssociations}
     */
    public com.vmware.nsx_policy.infra.IdentityGroupAssociations identityGroupAssociationsService() {
        return this.stubFactory.createStub(IdentityGroupAssociations.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.IgmpProfiles}
     */
    public com.vmware.nsx_policy.infra.IgmpProfiles igmpProfilesService() {
        return this.stubFactory.createStub(IgmpProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.IpAddressGroupAssociations}
     */
    public com.vmware.nsx_policy.infra.IpAddressGroupAssociations ipAddressGroupAssociationsService() {
        return this.stubFactory.createStub(IpAddressGroupAssociations.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.IpBlocks}
     */
    public com.vmware.nsx_policy.infra.IpBlocks ipBlocksService() {
        return this.stubFactory.createStub(IpBlocks.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.IpDiscoveryProfiles}
     */
    public com.vmware.nsx_policy.infra.IpDiscoveryProfiles ipDiscoveryProfilesService() {
        return this.stubFactory.createStub(IpDiscoveryProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.IpPools}
     */
    public com.vmware.nsx_policy.infra.IpPools ipPoolsService() {
        return this.stubFactory.createStub(IpPools.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.IpfixDfwCollectorProfiles}
     */
    public com.vmware.nsx_policy.infra.IpfixDfwCollectorProfiles ipfixDfwCollectorProfilesService() {
        return this.stubFactory.createStub(IpfixDfwCollectorProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.IpfixDfwProfiles}
     */
    public com.vmware.nsx_policy.infra.IpfixDfwProfiles ipfixDfwProfilesService() {
        return this.stubFactory.createStub(IpfixDfwProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.IpfixL2CollectorProfiles}
     */
    public com.vmware.nsx_policy.infra.IpfixL2CollectorProfiles ipfixL2CollectorProfilesService() {
        return this.stubFactory.createStub(IpfixL2CollectorProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.IpfixL2Profiles}
     */
    public com.vmware.nsx_policy.infra.IpfixL2Profiles ipfixL2ProfilesService() {
        return this.stubFactory.createStub(IpfixL2Profiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.IpsecVpnDpdProfiles}
     */
    public com.vmware.nsx_policy.infra.IpsecVpnDpdProfiles ipsecVpnDpdProfilesService() {
        return this.stubFactory.createStub(IpsecVpnDpdProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.IpsecVpnIkeProfiles}
     */
    public com.vmware.nsx_policy.infra.IpsecVpnIkeProfiles ipsecVpnIkeProfilesService() {
        return this.stubFactory.createStub(IpsecVpnIkeProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.IpsecVpnTunnelProfiles}
     */
    public com.vmware.nsx_policy.infra.IpsecVpnTunnelProfiles ipsecVpnTunnelProfilesService() {
        return this.stubFactory.createStub(IpsecVpnTunnelProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.Ipv6DadProfiles}
     */
    public com.vmware.nsx_policy.infra.Ipv6DadProfiles ipv6DadProfilesService() {
        return this.stubFactory.createStub(Ipv6DadProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.Ipv6NdraProfiles}
     */
    public com.vmware.nsx_policy.infra.Ipv6NdraProfiles ipv6NdraProfilesService() {
        return this.stubFactory.createStub(Ipv6NdraProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.L7AccessProfiles}
     */
    public com.vmware.nsx_policy.infra.L7AccessProfiles l7AccessProfilesService() {
        return this.stubFactory.createStub(L7AccessProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.Labels}
     */
    public com.vmware.nsx_policy.infra.Labels labelsService() {
        return this.stubFactory.createStub(Labels.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.LatencyProfiles}
     */
    public com.vmware.nsx_policy.infra.LatencyProfiles latencyProfilesService() {
        return this.stubFactory.createStub(LatencyProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.LbAppProfiles}
     */
    public com.vmware.nsx_policy.infra.LbAppProfiles lbAppProfilesService() {
        return this.stubFactory.createStub(LbAppProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.LbClientSslProfiles}
     */
    public com.vmware.nsx_policy.infra.LbClientSslProfiles lbClientSslProfilesService() {
        return this.stubFactory.createStub(LbClientSslProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.LbMonitorProfiles}
     */
    public com.vmware.nsx_policy.infra.LbMonitorProfiles lbMonitorProfilesService() {
        return this.stubFactory.createStub(LbMonitorProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.LbNodeUsage}
     */
    public com.vmware.nsx_policy.infra.LbNodeUsage lbNodeUsageService() {
        return this.stubFactory.createStub(LbNodeUsage.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.LbNodeUsageSummary}
     */
    public com.vmware.nsx_policy.infra.LbNodeUsageSummary lbNodeUsageSummaryService() {
        return this.stubFactory.createStub(LbNodeUsageSummary.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.LbPersistenceProfiles}
     */
    public com.vmware.nsx_policy.infra.LbPersistenceProfiles lbPersistenceProfilesService() {
        return this.stubFactory.createStub(LbPersistenceProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.LbPools}
     */
    public com.vmware.nsx_policy.infra.LbPools lbPoolsService() {
        return this.stubFactory.createStub(LbPools.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.LbServerSslProfiles}
     */
    public com.vmware.nsx_policy.infra.LbServerSslProfiles lbServerSslProfilesService() {
        return this.stubFactory.createStub(LbServerSslProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.LbServiceUsageSummary}
     */
    public com.vmware.nsx_policy.infra.LbServiceUsageSummary lbServiceUsageSummaryService() {
        return this.stubFactory.createStub(LbServiceUsageSummary.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.LbServices}
     */
    public com.vmware.nsx_policy.infra.LbServices lbServicesService() {
        return this.stubFactory.createStub(LbServices.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.LbSslCiphersAndProtocols}
     */
    public com.vmware.nsx_policy.infra.LbSslCiphersAndProtocols lbSslCiphersAndProtocolsService() {
        return this.stubFactory.createStub(LbSslCiphersAndProtocols.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.LbVirtualServers}
     */
    public com.vmware.nsx_policy.infra.LbVirtualServers lbVirtualServersService() {
        return this.stubFactory.createStub(LbVirtualServers.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.Livetraces}
     */
    public com.vmware.nsx_policy.infra.Livetraces livetracesService() {
        return this.stubFactory.createStub(Livetraces.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.MacDiscoveryProfiles}
     */
    public com.vmware.nsx_policy.infra.MacDiscoveryProfiles macDiscoveryProfilesService() {
        return this.stubFactory.createStub(MacDiscoveryProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.ManagerIpPools}
     */
    public com.vmware.nsx_policy.infra.ManagerIpPools managerIpPoolsService() {
        return this.stubFactory.createStub(ManagerIpPools.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.MetadataProxies}
     */
    public com.vmware.nsx_policy.infra.MetadataProxies metadataProxiesService() {
        return this.stubFactory.createStub(MetadataProxies.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.NvdsUrt}
     */
    public com.vmware.nsx_policy.infra.NvdsUrt nvdsUrtService() {
        return this.stubFactory.createStub(NvdsUrt.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.OpsGlobalConfig}
     */
    public com.vmware.nsx_policy.infra.OpsGlobalConfig opsGlobalConfigService() {
        return this.stubFactory.createStub(OpsGlobalConfig.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.PartnerServices}
     */
    public com.vmware.nsx_policy.infra.PartnerServices partnerServicesService() {
        return this.stubFactory.createStub(PartnerServices.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.PhysicalServerGroupAssociations}
     */
    public com.vmware.nsx_policy.infra.PhysicalServerGroupAssociations physicalServerGroupAssociationsService() {
        return this.stubFactory.createStub(PhysicalServerGroupAssociations.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.PimProfiles}
     */
    public com.vmware.nsx_policy.infra.PimProfiles pimProfilesService() {
        return this.stubFactory.createStub(PimProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.PodGroupAssociations}
     */
    public com.vmware.nsx_policy.infra.PodGroupAssociations podGroupAssociationsService() {
        return this.stubFactory.createStub(PodGroupAssociations.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.PortMirroringProfiles}
     */
    public com.vmware.nsx_policy.infra.PortMirroringProfiles portMirroringProfilesService() {
        return this.stubFactory.createStub(PortMirroringProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.QosProfiles}
     */
    public com.vmware.nsx_policy.infra.QosProfiles qosProfilesService() {
        return this.stubFactory.createStub(QosProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.Reactions}
     */
    public com.vmware.nsx_policy.infra.Reactions reactionsService() {
        return this.stubFactory.createStub(Reactions.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.SandboxedResources}
     */
    public com.vmware.nsx_policy.infra.SandboxedResources sandboxedResourcesService() {
        return this.stubFactory.createStub(SandboxedResources.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.SecurityGlobalConfig}
     */
    public com.vmware.nsx_policy.infra.SecurityGlobalConfig securityGlobalConfigService() {
        return this.stubFactory.createStub(SecurityGlobalConfig.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.SegmentSecurityProfiles}
     */
    public com.vmware.nsx_policy.infra.SegmentSecurityProfiles segmentSecurityProfilesService() {
        return this.stubFactory.createStub(SegmentSecurityProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.Segments}
     */
    public com.vmware.nsx_policy.infra.Segments segmentsService() {
        return this.stubFactory.createStub(Segments.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.ServiceChains}
     */
    public com.vmware.nsx_policy.infra.ServiceChains serviceChainsService() {
        return this.stubFactory.createStub(ServiceChains.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.ServiceReferences}
     */
    public com.vmware.nsx_policy.infra.ServiceReferences serviceReferencesService() {
        return this.stubFactory.createStub(ServiceReferences.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.Services}
     */
    public com.vmware.nsx_policy.infra.Services servicesService() {
        return this.stubFactory.createStub(Services.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.Shares}
     */
    public com.vmware.nsx_policy.infra.Shares sharesService() {
        return this.stubFactory.createStub(Shares.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.Sites}
     */
    public com.vmware.nsx_policy.infra.Sites sitesService() {
        return this.stubFactory.createStub(Sites.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.Span}
     */
    public com.vmware.nsx_policy.infra.Span spanService() {
        return this.stubFactory.createStub(Span.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.SpoofguardProfiles}
     */
    public com.vmware.nsx_policy.infra.SpoofguardProfiles spoofguardProfilesService() {
        return this.stubFactory.createStub(SpoofguardProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.StaticMimeContents}
     */
    public com.vmware.nsx_policy.infra.StaticMimeContents staticMimeContentsService() {
        return this.stubFactory.createStub(StaticMimeContents.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.Tags}
     */
    public com.vmware.nsx_policy.infra.Tags tagsService() {
        return this.stubFactory.createStub(Tags.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.Tier0s}
     */
    public com.vmware.nsx_policy.infra.Tier0s tier0sService() {
        return this.stubFactory.createStub(Tier0s.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.Tier1s}
     */
    public com.vmware.nsx_policy.infra.Tier1s tier1sService() {
        return this.stubFactory.createStub(Tier1s.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.TlsInspectionActionProfiles}
     */
    public com.vmware.nsx_policy.infra.TlsInspectionActionProfiles tlsInspectionActionProfilesService() {
        return this.stubFactory.createStub(TlsInspectionActionProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.TlsInspectionPolicies}
     */
    public com.vmware.nsx_policy.infra.TlsInspectionPolicies tlsInspectionPoliciesService() {
        return this.stubFactory.createStub(TlsInspectionPolicies.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.Traceflows}
     */
    public com.vmware.nsx_policy.infra.Traceflows traceflowsService() {
        return this.stubFactory.createStub(Traceflows.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.TransportZoneProfiles}
     */
    public com.vmware.nsx_policy.infra.TransportZoneProfiles transportZoneProfilesService() {
        return this.stubFactory.createStub(TransportZoneProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.UrlCategories}
     */
    public com.vmware.nsx_policy.infra.UrlCategories urlCategoriesService() {
        return this.stubFactory.createStub(UrlCategories.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.UrlReputationSeverities}
     */
    public com.vmware.nsx_policy.infra.UrlReputationSeverities urlReputationSeveritiesService() {
        return this.stubFactory.createStub(UrlReputationSeverities.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.VirtualMachineGroupAssociations}
     */
    public com.vmware.nsx_policy.infra.VirtualMachineGroupAssociations virtualMachineGroupAssociationsService() {
        return this.stubFactory.createStub(VirtualMachineGroupAssociations.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.VirtualNetworkInterfaceGroupAssociations}
     */
    public com.vmware.nsx_policy.infra.VirtualNetworkInterfaceGroupAssociations virtualNetworkInterfaceGroupAssociationsService() {
        return this.stubFactory.createStub(VirtualNetworkInterfaceGroupAssociations.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx_policy.infra.VniPools}
     */
    public com.vmware.nsx_policy.infra.VniPools vniPoolsService() {
        return this.stubFactory.createStub(VniPools.class, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.antrea.AntreaFactory antrea() {
        return com.vmware.nsx_policy.infra.antrea.AntreaFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.capacity.CapacityFactory capacity() {
        return com.vmware.nsx_policy.infra.capacity.CapacityFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.context_profiles.ContextProfilesFactory contextProfiles() {
        return com.vmware.nsx_policy.infra.context_profiles.ContextProfilesFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.deployment_zones.DeploymentZonesFactory deploymentZones() {
        return com.vmware.nsx_policy.infra.deployment_zones.DeploymentZonesFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.dhcp_server_configs.DhcpServerConfigsFactory dhcpServerConfigs() {
        return com.vmware.nsx_policy.infra.dhcp_server_configs.DhcpServerConfigsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.domains.DomainsFactory domains() {
        return com.vmware.nsx_policy.infra.domains.DomainsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.drafts.DraftsFactory drafts() {
        return com.vmware.nsx_policy.infra.drafts.DraftsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.firewall.FirewallFactory firewall() {
        return com.vmware.nsx_policy.infra.firewall.FirewallFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.firewall_identity_store_event_log_servers.FirewallIdentityStoreEventLogServersFactory firewallIdentityStoreEventLogServers() {
        return com.vmware.nsx_policy.infra.firewall_identity_store_event_log_servers.FirewallIdentityStoreEventLogServersFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.firewall_identity_stores.FirewallIdentityStoresFactory firewallIdentityStores() {
        return com.vmware.nsx_policy.infra.firewall_identity_stores.FirewallIdentityStoresFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.flood_protection_profiles.FloodProtectionProfilesFactory floodProtectionProfiles() {
        return com.vmware.nsx_policy.infra.flood_protection_profiles.FloodProtectionProfilesFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.identity_firewall_stores.IdentityFirewallStoresFactory identityFirewallStores() {
        return com.vmware.nsx_policy.infra.identity_firewall_stores.IdentityFirewallStoresFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.ip_pools.IpPoolsFactory ipPools() {
        return com.vmware.nsx_policy.infra.ip_pools.IpPoolsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.l7_access_profiles.L7AccessProfilesFactory l7AccessProfiles() {
        return com.vmware.nsx_policy.infra.l7_access_profiles.L7AccessProfilesFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.lb_services.LbServicesFactory lbServices() {
        return com.vmware.nsx_policy.infra.lb_services.LbServicesFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.livetraces.LivetracesFactory livetraces() {
        return com.vmware.nsx_policy.infra.livetraces.LivetracesFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.metadata_proxies.MetadataProxiesFactory metadataProxies() {
        return com.vmware.nsx_policy.infra.metadata_proxies.MetadataProxiesFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.nvds_urt.NvdsUrtFactory nvdsUrt() {
        return com.vmware.nsx_policy.infra.nvds_urt.NvdsUrtFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.realized_state.RealizedStateFactory realizedState() {
        return com.vmware.nsx_policy.infra.realized_state.RealizedStateFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.security.SecurityFactory security() {
        return com.vmware.nsx_policy.infra.security.SecurityFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.segments.SegmentsFactory segments() {
        return com.vmware.nsx_policy.infra.segments.SegmentsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.service_chains.ServiceChainsFactory serviceChains() {
        return com.vmware.nsx_policy.infra.service_chains.ServiceChainsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.service_references.ServiceReferencesFactory serviceReferences() {
        return com.vmware.nsx_policy.infra.service_references.ServiceReferencesFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.services.ServicesFactory services() {
        return com.vmware.nsx_policy.infra.services.ServicesFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.session_timer_profiles.SessionTimerProfilesFactory sessionTimerProfiles() {
        return com.vmware.nsx_policy.infra.session_timer_profiles.SessionTimerProfilesFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.sha.ShaFactory sha() {
        return com.vmware.nsx_policy.infra.sha.ShaFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.shares.SharesFactory shares() {
        return com.vmware.nsx_policy.infra.shares.SharesFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.site.SiteFactory site() {
        return com.vmware.nsx_policy.infra.site.SiteFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.sites.SitesFactory sites() {
        return com.vmware.nsx_policy.infra.sites.SitesFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.tags.TagsFactory tags() {
        return com.vmware.nsx_policy.infra.tags.TagsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.tier_0s.Tier0sFactory tier0s() {
        return com.vmware.nsx_policy.infra.tier_0s.Tier0sFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.tier_1s.Tier1sFactory tier1s() {
        return com.vmware.nsx_policy.infra.tier_1s.Tier1sFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.tls_inspection_policies.TlsInspectionPoliciesFactory tlsInspectionPolicies() {
        return com.vmware.nsx_policy.infra.tls_inspection_policies.TlsInspectionPoliciesFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx_policy.infra.traceflows.TraceflowsFactory traceflows() {
        return com.vmware.nsx_policy.infra.traceflows.TraceflowsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public void updateStubConfiguration(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        if (this.stubFactory == stubFactory && this.stubConfig == stubConfig)
            return;

        this.stubFactory = stubFactory;
        this.stubConfig = stubConfig;
    }

}
