/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.infra.domains.groups.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.infra.domains.groups;

public interface MacAddressExpressions extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.infra.domains.groups.MacAddressExpressionsTypes {

    /**
     * It will add or remove the specified MAC Addresses from a given expression of a
     * group.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param domainId (required)
     * @param groupId (required)
     * @param expressionId (required)
     * @param mACAddressList (required)
     * @param action Add or Remove group members. (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void create(java.lang.String domainId, java.lang.String groupId, java.lang.String expressionId, com.vmware.nsx_policy.model.MACAddressList mACAddressList, java.lang.String action);

    /**
     * It will add or remove the specified MAC Addresses from a given expression of a
     * group.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param domainId (required)
     * @param groupId (required)
     * @param expressionId (required)
     * @param mACAddressList (required)
     * @param action Add or Remove group members. (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void create(java.lang.String domainId, java.lang.String groupId, java.lang.String expressionId, com.vmware.nsx_policy.model.MACAddressList mACAddressList, java.lang.String action, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * It will add or remove the specified MAC Addresses from a given expression of a
     * group.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param domainId (required)
     * @param groupId (required)
     * @param expressionId (required)
     * @param mACAddressList (required)
     * @param action Add or Remove group members. (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void create(java.lang.String domainId, java.lang.String groupId, java.lang.String expressionId, com.vmware.nsx_policy.model.MACAddressList mACAddressList, java.lang.String action, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * It will add or remove the specified MAC Addresses from a given expression of a
     * group.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param domainId (required)
     * @param groupId (required)
     * @param expressionId (required)
     * @param mACAddressList (required)
     * @param action Add or Remove group members. (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void create(java.lang.String domainId, java.lang.String groupId, java.lang.String expressionId, com.vmware.nsx_policy.model.MACAddressList mACAddressList, java.lang.String action, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Delete Group MACAddressExpression
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param domainId Domain ID (required)
     * @param groupId Group ID (required)
     * @param expressionId MACAddressExpression ID (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String domainId, java.lang.String groupId, java.lang.String expressionId);

    /**
     * Delete Group MACAddressExpression
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param domainId Domain ID (required)
     * @param groupId Group ID (required)
     * @param expressionId MACAddressExpression ID (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String domainId, java.lang.String groupId, java.lang.String expressionId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Delete Group MACAddressExpression
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param domainId Domain ID (required)
     * @param groupId Group ID (required)
     * @param expressionId MACAddressExpression ID (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String domainId, java.lang.String groupId, java.lang.String expressionId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Delete Group MACAddressExpression
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param domainId Domain ID (required)
     * @param groupId Group ID (required)
     * @param expressionId MACAddressExpression ID (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String domainId, java.lang.String groupId, java.lang.String expressionId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * If a group MACAddressExpression with the expression-id is not already present,
     * create a new MACAddressExpression. If it already exists, replace the existing
     * MACAddressExpression.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param domainId Domain ID (required)
     * @param groupId Group ID (required)
     * @param expressionId MACAddressExpression ID (required)
     * @param mACAddressExpression (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void patch(java.lang.String domainId, java.lang.String groupId, java.lang.String expressionId, com.vmware.nsx_policy.model.MACAddressExpression mACAddressExpression);

    /**
     * If a group MACAddressExpression with the expression-id is not already present,
     * create a new MACAddressExpression. If it already exists, replace the existing
     * MACAddressExpression.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param domainId Domain ID (required)
     * @param groupId Group ID (required)
     * @param expressionId MACAddressExpression ID (required)
     * @param mACAddressExpression (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void patch(java.lang.String domainId, java.lang.String groupId, java.lang.String expressionId, com.vmware.nsx_policy.model.MACAddressExpression mACAddressExpression, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * If a group MACAddressExpression with the expression-id is not already present,
     * create a new MACAddressExpression. If it already exists, replace the existing
     * MACAddressExpression.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param domainId Domain ID (required)
     * @param groupId Group ID (required)
     * @param expressionId MACAddressExpression ID (required)
     * @param mACAddressExpression (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void patch(java.lang.String domainId, java.lang.String groupId, java.lang.String expressionId, com.vmware.nsx_policy.model.MACAddressExpression mACAddressExpression, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * If a group MACAddressExpression with the expression-id is not already present,
     * create a new MACAddressExpression. If it already exists, replace the existing
     * MACAddressExpression.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param domainId Domain ID (required)
     * @param groupId Group ID (required)
     * @param expressionId MACAddressExpression ID (required)
     * @param mACAddressExpression (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void patch(java.lang.String domainId, java.lang.String groupId, java.lang.String expressionId, com.vmware.nsx_policy.model.MACAddressExpression mACAddressExpression, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
