/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.infra.firewall_identity_stores.groups.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.infra.firewall_identity_stores.groups;

public interface MemberGroups extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.infra.firewall_identity_stores.groups.MemberGroupsTypes {

    /**
     * A member group could be either direct member of the group specified by group_id
     * or nested member of it. Both direct member groups and nested member groups are
     * returned. Directory group member sync must be enabled to get the correct
     * results.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param firewallIdentityStoreId Firewall Identity store identifier (required)
     * @param groupId Directory group identifier (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx_policy.model.DirectoryGroupMemberListResults
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.DirectoryGroupMemberListResults list(java.lang.String firewallIdentityStoreId, java.lang.String groupId, java.lang.String cursor, java.lang.String enforcementPointPath, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * A member group could be either direct member of the group specified by group_id
     * or nested member of it. Both direct member groups and nested member groups are
     * returned. Directory group member sync must be enabled to get the correct
     * results.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param firewallIdentityStoreId Firewall Identity store identifier (required)
     * @param groupId Directory group identifier (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.DirectoryGroupMemberListResults
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.DirectoryGroupMemberListResults list(java.lang.String firewallIdentityStoreId, java.lang.String groupId, java.lang.String cursor, java.lang.String enforcementPointPath, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * A member group could be either direct member of the group specified by group_id
     * or nested member of it. Both direct member groups and nested member groups are
     * returned. Directory group member sync must be enabled to get the correct
     * results.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.DirectoryGroupMemberListResults
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param firewallIdentityStoreId Firewall Identity store identifier (required)
     * @param groupId Directory group identifier (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String firewallIdentityStoreId, java.lang.String groupId, java.lang.String cursor, java.lang.String enforcementPointPath, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.DirectoryGroupMemberListResults> asyncCallback);

    /**
     * A member group could be either direct member of the group specified by group_id
     * or nested member of it. Both direct member groups and nested member groups are
     * returned. Directory group member sync must be enabled to get the correct
     * results.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.DirectoryGroupMemberListResults
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param firewallIdentityStoreId Firewall Identity store identifier (required)
     * @param groupId Directory group identifier (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String firewallIdentityStoreId, java.lang.String groupId, java.lang.String cursor, java.lang.String enforcementPointPath, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.DirectoryGroupMemberListResults> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
