/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.infra.service_chains.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.infra.service_chains;

public interface ServicePaths extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.infra.service_chains.ServicePathsTypes {

    /**
     * This API can be used to read service paths for a given service-chain-id.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param serviceChainId Id of Service chain (required)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @return com.vmware.nsx_policy.model.ServicePathListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.ServicePathListResult list(java.lang.String serviceChainId, java.lang.String enforcementPointPath);

    /**
     * This API can be used to read service paths for a given service-chain-id.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param serviceChainId Id of Service chain (required)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.ServicePathListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.ServicePathListResult list(java.lang.String serviceChainId, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * This API can be used to read service paths for a given service-chain-id.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ServicePathListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceChainId Id of Service chain (required)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String serviceChainId, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ServicePathListResult> asyncCallback);

    /**
     * This API can be used to read service paths for a given service-chain-id.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ServicePathListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceChainId Id of Service chain (required)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String serviceChainId, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ServicePathListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
