/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.infra.settings.firewall.security.malware_prevention_service.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.infra.settings.firewall.security.malware_prevention_service;

public interface Profiles extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.infra.settings.firewall.security.malware_prevention_service.ProfilesTypes {

    /**
     * Delete Malware Prevention profile.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param profileId Profile ID (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String profileId);

    /**
     * Delete Malware Prevention profile.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param profileId Profile ID (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String profileId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Delete Malware Prevention profile.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param profileId Profile ID (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String profileId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Delete Malware Prevention profile.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param profileId Profile ID (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String profileId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Read Malware Prevention profile
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param profileId Profile ID (required)
     * @return com.vmware.nsx_policy.model.MalwarePreventionProfile
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.MalwarePreventionProfile get(java.lang.String profileId);

    /**
     * Read Malware Prevention profile
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param profileId Profile ID (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.MalwarePreventionProfile
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.MalwarePreventionProfile get(java.lang.String profileId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Read Malware Prevention profile
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.MalwarePreventionProfile
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param profileId Profile ID (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String profileId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.MalwarePreventionProfile> asyncCallback);

    /**
     * Read Malware Prevention profile
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.MalwarePreventionProfile
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param profileId Profile ID (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String profileId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.MalwarePreventionProfile> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * List Malware Prevention profiles.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx_policy.model.MalwarePreventionProfileListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.MalwarePreventionProfileListResult list(java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * List Malware Prevention profiles.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.MalwarePreventionProfileListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.MalwarePreventionProfileListResult list(java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * List Malware Prevention profiles.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.MalwarePreventionProfileListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.MalwarePreventionProfileListResult> asyncCallback);

    /**
     * List Malware Prevention profiles.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.MalwarePreventionProfileListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.MalwarePreventionProfileListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Patch Malware Prevention profile.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param profileId Profile ID (required)
     * @param malwarePreventionProfile (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void patch(java.lang.String profileId, com.vmware.nsx_policy.model.MalwarePreventionProfile malwarePreventionProfile);

    /**
     * Patch Malware Prevention profile.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param profileId Profile ID (required)
     * @param malwarePreventionProfile (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void patch(java.lang.String profileId, com.vmware.nsx_policy.model.MalwarePreventionProfile malwarePreventionProfile, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Patch Malware Prevention profile.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param profileId Profile ID (required)
     * @param malwarePreventionProfile (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void patch(java.lang.String profileId, com.vmware.nsx_policy.model.MalwarePreventionProfile malwarePreventionProfile, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Patch Malware Prevention profile.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param profileId Profile ID (required)
     * @param malwarePreventionProfile (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void patch(java.lang.String profileId, com.vmware.nsx_policy.model.MalwarePreventionProfile malwarePreventionProfile, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Update Malware Prevention profile.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param profileId Profile ID (required)
     * @param malwarePreventionProfile (required)
     * @return com.vmware.nsx_policy.model.MalwarePreventionProfile
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.MalwarePreventionProfile update(java.lang.String profileId, com.vmware.nsx_policy.model.MalwarePreventionProfile malwarePreventionProfile);

    /**
     * Update Malware Prevention profile.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param profileId Profile ID (required)
     * @param malwarePreventionProfile (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.MalwarePreventionProfile
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.MalwarePreventionProfile update(java.lang.String profileId, com.vmware.nsx_policy.model.MalwarePreventionProfile malwarePreventionProfile, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Update Malware Prevention profile.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.MalwarePreventionProfile
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param profileId Profile ID (required)
     * @param malwarePreventionProfile (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String profileId, com.vmware.nsx_policy.model.MalwarePreventionProfile malwarePreventionProfile, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.MalwarePreventionProfile> asyncCallback);

    /**
     * Update Malware Prevention profile.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.MalwarePreventionProfile
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param profileId Profile ID (required)
     * @param malwarePreventionProfile (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String profileId, com.vmware.nsx_policy.model.MalwarePreventionProfile malwarePreventionProfile, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.MalwarePreventionProfile> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
