/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.infra.sites.enforcement_points.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.infra.sites.enforcement_points;

public interface HostTransportNodes extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.infra.sites.enforcement_points.HostTransportNodesTypes {

    /**
     * Deletes the specified transport node. Query param force can be used to force
     * delete the host nodes. Force delete is not supported if transport node is part
     * of a cluster on which Transport node profile is applied. It also removes the
     * specified host node from system. If unprepare_host option is set to false, then
     * host will be deleted without uninstalling the NSX components from the host. If
     * transport node delete is called with query param force not being set or set to
     * false and uninstall of NSX components in the host fails, TransportNodeState
     * object will be retained. If transport node delete is called with query param
     * force set to true and uninstall of NSX components in the host fails,
     * TransportNodeState object will be deleted.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param hostTransportNodeId (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param unprepareHost Uninstall NSX components from host while deleting (optional, default to true)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String hostTransportNodeId, java.lang.Boolean force, java.lang.Boolean unprepareHost);

    /**
     * Deletes the specified transport node. Query param force can be used to force
     * delete the host nodes. Force delete is not supported if transport node is part
     * of a cluster on which Transport node profile is applied. It also removes the
     * specified host node from system. If unprepare_host option is set to false, then
     * host will be deleted without uninstalling the NSX components from the host. If
     * transport node delete is called with query param force not being set or set to
     * false and uninstall of NSX components in the host fails, TransportNodeState
     * object will be retained. If transport node delete is called with query param
     * force set to true and uninstall of NSX components in the host fails,
     * TransportNodeState object will be deleted.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param hostTransportNodeId (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param unprepareHost Uninstall NSX components from host while deleting (optional, default to true)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String hostTransportNodeId, java.lang.Boolean force, java.lang.Boolean unprepareHost, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Deletes the specified transport node. Query param force can be used to force
     * delete the host nodes. Force delete is not supported if transport node is part
     * of a cluster on which Transport node profile is applied. It also removes the
     * specified host node from system. If unprepare_host option is set to false, then
     * host will be deleted without uninstalling the NSX components from the host. If
     * transport node delete is called with query param force not being set or set to
     * false and uninstall of NSX components in the host fails, TransportNodeState
     * object will be retained. If transport node delete is called with query param
     * force set to true and uninstall of NSX components in the host fails,
     * TransportNodeState object will be deleted.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param hostTransportNodeId (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param unprepareHost Uninstall NSX components from host while deleting (optional, default to true)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String hostTransportNodeId, java.lang.Boolean force, java.lang.Boolean unprepareHost, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Deletes the specified transport node. Query param force can be used to force
     * delete the host nodes. Force delete is not supported if transport node is part
     * of a cluster on which Transport node profile is applied. It also removes the
     * specified host node from system. If unprepare_host option is set to false, then
     * host will be deleted without uninstalling the NSX components from the host. If
     * transport node delete is called with query param force not being set or set to
     * false and uninstall of NSX components in the host fails, TransportNodeState
     * object will be retained. If transport node delete is called with query param
     * force set to true and uninstall of NSX components in the host fails,
     * TransportNodeState object will be deleted.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param hostTransportNodeId (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param unprepareHost Uninstall NSX components from host while deleting (optional, default to true)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String hostTransportNodeId, java.lang.Boolean force, java.lang.Boolean unprepareHost, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about a specified transport node.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param hostTransportNodeId (required)
     * @return com.vmware.nsx_policy.model.HostTransportNode
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.HostTransportNode get(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String hostTransportNodeId);

    /**
     * Returns information about a specified transport node.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param hostTransportNodeId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.HostTransportNode
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.HostTransportNode get(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String hostTransportNodeId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about a specified transport node.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.HostTransportNode
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param hostTransportNodeId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String hostTransportNodeId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.HostTransportNode> asyncCallback);

    /**
     * Returns information about a specified transport node.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.HostTransportNode
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param hostTransportNodeId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String hostTransportNodeId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.HostTransportNode> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about all host transport nodes along with underlying host
     * details. A transport node is a host that contains hostswitches. A hostswitch can
     * have virtual machines connected to them. Because each transport node has
     * hostswitches, transport nodes can also have virtual tunnel endpoints, which
     * means that they can be part of the overlay.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param discoveredNodeId discovered node id (optional)
     * @param inMaintenanceMode maintenance mode flag (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param nodeIp Transport node IP address (optional)
     * @param nodeTypes a list of node types separated by comma or a single type (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param transportZonePath Transport zone path (optional)
     * @return com.vmware.nsx_policy.model.HostTransportNodeListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.HostTransportNodeListResult list(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String cursor, java.lang.String discoveredNodeId, java.lang.Boolean inMaintenanceMode, java.lang.String includedFields, java.lang.String nodeIp, java.lang.String nodeTypes, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String transportZonePath);

    /**
     * Returns information about all host transport nodes along with underlying host
     * details. A transport node is a host that contains hostswitches. A hostswitch can
     * have virtual machines connected to them. Because each transport node has
     * hostswitches, transport nodes can also have virtual tunnel endpoints, which
     * means that they can be part of the overlay.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param discoveredNodeId discovered node id (optional)
     * @param inMaintenanceMode maintenance mode flag (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param nodeIp Transport node IP address (optional)
     * @param nodeTypes a list of node types separated by comma or a single type (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param transportZonePath Transport zone path (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.HostTransportNodeListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.HostTransportNodeListResult list(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String cursor, java.lang.String discoveredNodeId, java.lang.Boolean inMaintenanceMode, java.lang.String includedFields, java.lang.String nodeIp, java.lang.String nodeTypes, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String transportZonePath, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about all host transport nodes along with underlying host
     * details. A transport node is a host that contains hostswitches. A hostswitch can
     * have virtual machines connected to them. Because each transport node has
     * hostswitches, transport nodes can also have virtual tunnel endpoints, which
     * means that they can be part of the overlay.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.HostTransportNodeListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param discoveredNodeId discovered node id (optional)
     * @param inMaintenanceMode maintenance mode flag (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param nodeIp Transport node IP address (optional)
     * @param nodeTypes a list of node types separated by comma or a single type (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param transportZonePath Transport zone path (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String cursor, java.lang.String discoveredNodeId, java.lang.Boolean inMaintenanceMode, java.lang.String includedFields, java.lang.String nodeIp, java.lang.String nodeTypes, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String transportZonePath, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.HostTransportNodeListResult> asyncCallback);

    /**
     * Returns information about all host transport nodes along with underlying host
     * details. A transport node is a host that contains hostswitches. A hostswitch can
     * have virtual machines connected to them. Because each transport node has
     * hostswitches, transport nodes can also have virtual tunnel endpoints, which
     * means that they can be part of the overlay.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.HostTransportNodeListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param discoveredNodeId discovered node id (optional)
     * @param inMaintenanceMode maintenance mode flag (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param nodeIp Transport node IP address (optional)
     * @param nodeTypes a list of node types separated by comma or a single type (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param transportZonePath Transport zone path (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String cursor, java.lang.String discoveredNodeId, java.lang.Boolean inMaintenanceMode, java.lang.String includedFields, java.lang.String nodeIp, java.lang.String nodeTypes, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String transportZonePath, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.HostTransportNodeListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Transport nodes are hypervisor hosts that will participate in an NSX-T overlay.
     * For a hypervisor host, this means that it hosts VMs that will communicate over
     * NSX-T logical switches. This API creates transport node for a host node
     * (hypervisor) in the transport network. When you run this command for a host, NSX
     * Manager attempts to install the NSX kernel modules, which are packaged as VIB,
     * RPM, or DEB files. For the installation to succeed, you must provide the host
     * login credentials and the host thumbprint. To get the ESXi host thumbprint, SSH
     * to the host and run the <b>openssl x509 -in /etc/vmware/ssl/rui.crt -fingerprint
     * -sha256 -noout</b> command. To generate host key thumbprint using SHA-256
     * algorithm please follow the steps below. Log into the host, making sure that the
     * connection is not vulnerable to a man in the middle attack. Check whether a
     * public key already exists. Host public key is generally located at
     * '/etc/ssh/ssh_host_rsa_key.pub'. If the key is not present then generate a new
     * key by running the following command and follow the instructions. <b>ssh-keygen
     * -t rsa</b> Now generate a SHA256 hash of the key using the following command.
     * Please make sure to pass the appropriate file name if the public key is stored
     * with a different file name other than the default 'id_rsa.pub'. <b>awk '{print
     * $2}' id_rsa.pub | base64 -d | sha256sum -b | sed 's/ .*$//' | xxd -r -p |
     * base64</b> Additional documentation on creating a transport node can be found in
     * the NSX-T Installation Guide. In order for the transport node to forward
     * packets, the host_switch_spec property must be specified. Host switches (called
     * bridges in OVS on KVM hypervisors) are the individual switches within the host
     * virtual switch. Virtual machines are connected to the host switches. When
     * creating a transport node, you need to specify if the host switches are already
     * manually preconfigured on the node, or if NSX should create and manage the host
     * switches. You specify this choice by the type of host switches you pass in the
     * host_switch_spec property of the TransportNode request payload. For a KVM host,
     * you can preconfigure the host switch, or you can have NSX Manager perform the
     * configuration. For an ESXi host NSX Manager always configures the host switch.
     * To preconfigure the host switches on a KVM host, pass an array of
     * PreconfiguredHostSwitchSpec objects that describes those host switches. In the
     * current NSX-T release, only one prefonfigured host switch can be specified. See
     * the PreconfiguredHostSwitchSpec schema definition for documentation on the
     * properties that must be provided. Preconfigured host switches are only supported
     * on KVM hosts, not on ESXi hosts. To allow NSX to manage the host switch
     * configuration on KVM hosts, ESXi hosts, pass an array of StandardHostSwitchSpec
     * objects in the host_switch_spec property, and NSX will automatically create host
     * switches with the properties you provide. In the current NSX-T release, up to 16
     * host switches can be automatically managed. See the StandardHostSwitchSpec
     * schema definition for documentation on the properties that must be provided. The
     * request should provide node_deployement_info.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param hostTransportNodeId (required)
     * @param hostTransportNode (required)
     * @param esxMgmtIfMigrationDest The network ids to which the ESX vmk interfaces will be migrated (optional)
     * @param ifId The ESX vmk interfaces to migrate (optional)
     * @param overrideNsxOwnership Override NSX Ownership (optional, default to false)
     * @param pingIp IP Addresses to ping right after ESX vmk interfaces were migrated. (optional)
     * @param skipValidation Whether to skip front-end validation for vmk/vnic/pnic migration (optional,
     * default to false)
     * @param vnic The ESX vmk interfaces and/or VM NIC to migrate (optional)
     * @param vnicMigrationDest The migration destinations of ESX vmk interfaces and/or VM NIC (optional)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void patch(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String hostTransportNodeId, com.vmware.nsx_policy.model.HostTransportNode hostTransportNode, java.lang.String esxMgmtIfMigrationDest, java.lang.String ifId, java.lang.Boolean overrideNsxOwnership, java.lang.String pingIp, java.lang.Boolean skipValidation, java.lang.String vnic, java.lang.String vnicMigrationDest);

    /**
     * Transport nodes are hypervisor hosts that will participate in an NSX-T overlay.
     * For a hypervisor host, this means that it hosts VMs that will communicate over
     * NSX-T logical switches. This API creates transport node for a host node
     * (hypervisor) in the transport network. When you run this command for a host, NSX
     * Manager attempts to install the NSX kernel modules, which are packaged as VIB,
     * RPM, or DEB files. For the installation to succeed, you must provide the host
     * login credentials and the host thumbprint. To get the ESXi host thumbprint, SSH
     * to the host and run the <b>openssl x509 -in /etc/vmware/ssl/rui.crt -fingerprint
     * -sha256 -noout</b> command. To generate host key thumbprint using SHA-256
     * algorithm please follow the steps below. Log into the host, making sure that the
     * connection is not vulnerable to a man in the middle attack. Check whether a
     * public key already exists. Host public key is generally located at
     * '/etc/ssh/ssh_host_rsa_key.pub'. If the key is not present then generate a new
     * key by running the following command and follow the instructions. <b>ssh-keygen
     * -t rsa</b> Now generate a SHA256 hash of the key using the following command.
     * Please make sure to pass the appropriate file name if the public key is stored
     * with a different file name other than the default 'id_rsa.pub'. <b>awk '{print
     * $2}' id_rsa.pub | base64 -d | sha256sum -b | sed 's/ .*$//' | xxd -r -p |
     * base64</b> Additional documentation on creating a transport node can be found in
     * the NSX-T Installation Guide. In order for the transport node to forward
     * packets, the host_switch_spec property must be specified. Host switches (called
     * bridges in OVS on KVM hypervisors) are the individual switches within the host
     * virtual switch. Virtual machines are connected to the host switches. When
     * creating a transport node, you need to specify if the host switches are already
     * manually preconfigured on the node, or if NSX should create and manage the host
     * switches. You specify this choice by the type of host switches you pass in the
     * host_switch_spec property of the TransportNode request payload. For a KVM host,
     * you can preconfigure the host switch, or you can have NSX Manager perform the
     * configuration. For an ESXi host NSX Manager always configures the host switch.
     * To preconfigure the host switches on a KVM host, pass an array of
     * PreconfiguredHostSwitchSpec objects that describes those host switches. In the
     * current NSX-T release, only one prefonfigured host switch can be specified. See
     * the PreconfiguredHostSwitchSpec schema definition for documentation on the
     * properties that must be provided. Preconfigured host switches are only supported
     * on KVM hosts, not on ESXi hosts. To allow NSX to manage the host switch
     * configuration on KVM hosts, ESXi hosts, pass an array of StandardHostSwitchSpec
     * objects in the host_switch_spec property, and NSX will automatically create host
     * switches with the properties you provide. In the current NSX-T release, up to 16
     * host switches can be automatically managed. See the StandardHostSwitchSpec
     * schema definition for documentation on the properties that must be provided. The
     * request should provide node_deployement_info.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param hostTransportNodeId (required)
     * @param hostTransportNode (required)
     * @param esxMgmtIfMigrationDest The network ids to which the ESX vmk interfaces will be migrated (optional)
     * @param ifId The ESX vmk interfaces to migrate (optional)
     * @param overrideNsxOwnership Override NSX Ownership (optional, default to false)
     * @param pingIp IP Addresses to ping right after ESX vmk interfaces were migrated. (optional)
     * @param skipValidation Whether to skip front-end validation for vmk/vnic/pnic migration (optional,
     * default to false)
     * @param vnic The ESX vmk interfaces and/or VM NIC to migrate (optional)
     * @param vnicMigrationDest The migration destinations of ESX vmk interfaces and/or VM NIC (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void patch(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String hostTransportNodeId, com.vmware.nsx_policy.model.HostTransportNode hostTransportNode, java.lang.String esxMgmtIfMigrationDest, java.lang.String ifId, java.lang.Boolean overrideNsxOwnership, java.lang.String pingIp, java.lang.Boolean skipValidation, java.lang.String vnic, java.lang.String vnicMigrationDest, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Transport nodes are hypervisor hosts that will participate in an NSX-T overlay.
     * For a hypervisor host, this means that it hosts VMs that will communicate over
     * NSX-T logical switches. This API creates transport node for a host node
     * (hypervisor) in the transport network. When you run this command for a host, NSX
     * Manager attempts to install the NSX kernel modules, which are packaged as VIB,
     * RPM, or DEB files. For the installation to succeed, you must provide the host
     * login credentials and the host thumbprint. To get the ESXi host thumbprint, SSH
     * to the host and run the <b>openssl x509 -in /etc/vmware/ssl/rui.crt -fingerprint
     * -sha256 -noout</b> command. To generate host key thumbprint using SHA-256
     * algorithm please follow the steps below. Log into the host, making sure that the
     * connection is not vulnerable to a man in the middle attack. Check whether a
     * public key already exists. Host public key is generally located at
     * '/etc/ssh/ssh_host_rsa_key.pub'. If the key is not present then generate a new
     * key by running the following command and follow the instructions. <b>ssh-keygen
     * -t rsa</b> Now generate a SHA256 hash of the key using the following command.
     * Please make sure to pass the appropriate file name if the public key is stored
     * with a different file name other than the default 'id_rsa.pub'. <b>awk '{print
     * $2}' id_rsa.pub | base64 -d | sha256sum -b | sed 's/ .*$//' | xxd -r -p |
     * base64</b> Additional documentation on creating a transport node can be found in
     * the NSX-T Installation Guide. In order for the transport node to forward
     * packets, the host_switch_spec property must be specified. Host switches (called
     * bridges in OVS on KVM hypervisors) are the individual switches within the host
     * virtual switch. Virtual machines are connected to the host switches. When
     * creating a transport node, you need to specify if the host switches are already
     * manually preconfigured on the node, or if NSX should create and manage the host
     * switches. You specify this choice by the type of host switches you pass in the
     * host_switch_spec property of the TransportNode request payload. For a KVM host,
     * you can preconfigure the host switch, or you can have NSX Manager perform the
     * configuration. For an ESXi host NSX Manager always configures the host switch.
     * To preconfigure the host switches on a KVM host, pass an array of
     * PreconfiguredHostSwitchSpec objects that describes those host switches. In the
     * current NSX-T release, only one prefonfigured host switch can be specified. See
     * the PreconfiguredHostSwitchSpec schema definition for documentation on the
     * properties that must be provided. Preconfigured host switches are only supported
     * on KVM hosts, not on ESXi hosts. To allow NSX to manage the host switch
     * configuration on KVM hosts, ESXi hosts, pass an array of StandardHostSwitchSpec
     * objects in the host_switch_spec property, and NSX will automatically create host
     * switches with the properties you provide. In the current NSX-T release, up to 16
     * host switches can be automatically managed. See the StandardHostSwitchSpec
     * schema definition for documentation on the properties that must be provided. The
     * request should provide node_deployement_info.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param hostTransportNodeId (required)
     * @param hostTransportNode (required)
     * @param esxMgmtIfMigrationDest The network ids to which the ESX vmk interfaces will be migrated (optional)
     * @param ifId The ESX vmk interfaces to migrate (optional)
     * @param overrideNsxOwnership Override NSX Ownership (optional, default to false)
     * @param pingIp IP Addresses to ping right after ESX vmk interfaces were migrated. (optional)
     * @param skipValidation Whether to skip front-end validation for vmk/vnic/pnic migration (optional,
     * default to false)
     * @param vnic The ESX vmk interfaces and/or VM NIC to migrate (optional)
     * @param vnicMigrationDest The migration destinations of ESX vmk interfaces and/or VM NIC (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void patch(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String hostTransportNodeId, com.vmware.nsx_policy.model.HostTransportNode hostTransportNode, java.lang.String esxMgmtIfMigrationDest, java.lang.String ifId, java.lang.Boolean overrideNsxOwnership, java.lang.String pingIp, java.lang.Boolean skipValidation, java.lang.String vnic, java.lang.String vnicMigrationDest, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Transport nodes are hypervisor hosts that will participate in an NSX-T overlay.
     * For a hypervisor host, this means that it hosts VMs that will communicate over
     * NSX-T logical switches. This API creates transport node for a host node
     * (hypervisor) in the transport network. When you run this command for a host, NSX
     * Manager attempts to install the NSX kernel modules, which are packaged as VIB,
     * RPM, or DEB files. For the installation to succeed, you must provide the host
     * login credentials and the host thumbprint. To get the ESXi host thumbprint, SSH
     * to the host and run the <b>openssl x509 -in /etc/vmware/ssl/rui.crt -fingerprint
     * -sha256 -noout</b> command. To generate host key thumbprint using SHA-256
     * algorithm please follow the steps below. Log into the host, making sure that the
     * connection is not vulnerable to a man in the middle attack. Check whether a
     * public key already exists. Host public key is generally located at
     * '/etc/ssh/ssh_host_rsa_key.pub'. If the key is not present then generate a new
     * key by running the following command and follow the instructions. <b>ssh-keygen
     * -t rsa</b> Now generate a SHA256 hash of the key using the following command.
     * Please make sure to pass the appropriate file name if the public key is stored
     * with a different file name other than the default 'id_rsa.pub'. <b>awk '{print
     * $2}' id_rsa.pub | base64 -d | sha256sum -b | sed 's/ .*$//' | xxd -r -p |
     * base64</b> Additional documentation on creating a transport node can be found in
     * the NSX-T Installation Guide. In order for the transport node to forward
     * packets, the host_switch_spec property must be specified. Host switches (called
     * bridges in OVS on KVM hypervisors) are the individual switches within the host
     * virtual switch. Virtual machines are connected to the host switches. When
     * creating a transport node, you need to specify if the host switches are already
     * manually preconfigured on the node, or if NSX should create and manage the host
     * switches. You specify this choice by the type of host switches you pass in the
     * host_switch_spec property of the TransportNode request payload. For a KVM host,
     * you can preconfigure the host switch, or you can have NSX Manager perform the
     * configuration. For an ESXi host NSX Manager always configures the host switch.
     * To preconfigure the host switches on a KVM host, pass an array of
     * PreconfiguredHostSwitchSpec objects that describes those host switches. In the
     * current NSX-T release, only one prefonfigured host switch can be specified. See
     * the PreconfiguredHostSwitchSpec schema definition for documentation on the
     * properties that must be provided. Preconfigured host switches are only supported
     * on KVM hosts, not on ESXi hosts. To allow NSX to manage the host switch
     * configuration on KVM hosts, ESXi hosts, pass an array of StandardHostSwitchSpec
     * objects in the host_switch_spec property, and NSX will automatically create host
     * switches with the properties you provide. In the current NSX-T release, up to 16
     * host switches can be automatically managed. See the StandardHostSwitchSpec
     * schema definition for documentation on the properties that must be provided. The
     * request should provide node_deployement_info.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param hostTransportNodeId (required)
     * @param hostTransportNode (required)
     * @param esxMgmtIfMigrationDest The network ids to which the ESX vmk interfaces will be migrated (optional)
     * @param ifId The ESX vmk interfaces to migrate (optional)
     * @param overrideNsxOwnership Override NSX Ownership (optional, default to false)
     * @param pingIp IP Addresses to ping right after ESX vmk interfaces were migrated. (optional)
     * @param skipValidation Whether to skip front-end validation for vmk/vnic/pnic migration (optional,
     * default to false)
     * @param vnic The ESX vmk interfaces and/or VM NIC to migrate (optional)
     * @param vnicMigrationDest The migration destinations of ESX vmk interfaces and/or VM NIC (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void patch(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String hostTransportNodeId, com.vmware.nsx_policy.model.HostTransportNode hostTransportNode, java.lang.String esxMgmtIfMigrationDest, java.lang.String ifId, java.lang.Boolean overrideNsxOwnership, java.lang.String pingIp, java.lang.Boolean skipValidation, java.lang.String vnic, java.lang.String vnicMigrationDest, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * A host can be overridden to have different configuration than Transport Node
     * Profile(TNP) on cluster. This action will restore such overridden host back to
     * cluster level TNP. This API can be used in other case. When TNP is applied to a
     * cluster, if any validation fails (e.g. VMs running on host) then existing
     * transport node (TN) is not updated. In that case after the issue is resolved
     * manually (e.g. VMs powered off), you can call this API to update TN as per
     * cluster level TNP.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param hostTransportNodeId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void restoreclusterconfig(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String hostTransportNodeId);

    /**
     * A host can be overridden to have different configuration than Transport Node
     * Profile(TNP) on cluster. This action will restore such overridden host back to
     * cluster level TNP. This API can be used in other case. When TNP is applied to a
     * cluster, if any validation fails (e.g. VMs running on host) then existing
     * transport node (TN) is not updated. In that case after the issue is resolved
     * manually (e.g. VMs powered off), you can call this API to update TN as per
     * cluster level TNP.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param hostTransportNodeId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void restoreclusterconfig(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String hostTransportNodeId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * A host can be overridden to have different configuration than Transport Node
     * Profile(TNP) on cluster. This action will restore such overridden host back to
     * cluster level TNP. This API can be used in other case. When TNP is applied to a
     * cluster, if any validation fails (e.g. VMs running on host) then existing
     * transport node (TN) is not updated. In that case after the issue is resolved
     * manually (e.g. VMs powered off), you can call this API to update TN as per
     * cluster level TNP.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param hostTransportNodeId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void restoreclusterconfig(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String hostTransportNodeId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * A host can be overridden to have different configuration than Transport Node
     * Profile(TNP) on cluster. This action will restore such overridden host back to
     * cluster level TNP. This API can be used in other case. When TNP is applied to a
     * cluster, if any validation fails (e.g. VMs running on host) then existing
     * transport node (TN) is not updated. In that case after the issue is resolved
     * manually (e.g. VMs powered off), you can call this API to update TN as per
     * cluster level TNP.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param hostTransportNodeId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void restoreclusterconfig(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String hostTransportNodeId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Resync the TransportNode configuration on a host. It is similar to updating the
     * TransportNode with existing configuration, but force synce these configurations
     * to the host (no backend optimizations).
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param hostTransportNodeId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void resynchostconfig(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String hostTransportNodeId);

    /**
     * Resync the TransportNode configuration on a host. It is similar to updating the
     * TransportNode with existing configuration, but force synce these configurations
     * to the host (no backend optimizations).
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param hostTransportNodeId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void resynchostconfig(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String hostTransportNodeId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Resync the TransportNode configuration on a host. It is similar to updating the
     * TransportNode with existing configuration, but force synce these configurations
     * to the host (no backend optimizations).
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param hostTransportNodeId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void resynchostconfig(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String hostTransportNodeId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Resync the TransportNode configuration on a host. It is similar to updating the
     * TransportNode with existing configuration, but force synce these configurations
     * to the host (no backend optimizations).
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param hostTransportNodeId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void resynchostconfig(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String hostTransportNodeId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Transport nodes are hypervisor hosts that will participate in an NSX-T overlay.
     * For a hypervisor host, this means that it hosts VMs that will communicate over
     * NSX-T logical switches. This API creates transport node for a host node
     * (hypervisor) in the transport network. When you run this command for a host, NSX
     * Manager attempts to install the NSX kernel modules, which are packaged as VIB,
     * RPM, or DEB files. For the installation to succeed, you must provide the host
     * login credentials and the host thumbprint. To get the ESXi host thumbprint, SSH
     * to the host and run the <b>openssl x509 -in /etc/vmware/ssl/rui.crt -fingerprint
     * -sha256 -noout</b> command. To generate host key thumbprint using SHA-256
     * algorithm please follow the steps below. Log into the host, making sure that the
     * connection is not vulnerable to a man in the middle attack. Check whether a
     * public key already exists. Host public key is generally located at
     * '/etc/ssh/ssh_host_rsa_key.pub'. If the key is not present then generate a new
     * key by running the following command and follow the instructions. <b>ssh-keygen
     * -t rsa</b> Now generate a SHA256 hash of the key using the following command.
     * Please make sure to pass the appropriate file name if the public key is stored
     * with a different file name other than the default 'id_rsa.pub'. <b>awk '{print
     * $2}' id_rsa.pub | base64 -d | sha256sum -b | sed 's/ .*$//' | xxd -r -p |
     * base64</b> Additional documentation on creating a transport node can be found in
     * the NSX-T Installation Guide. In order for the transport node to forward
     * packets, the host_switch_spec property must be specified. Host switches (called
     * bridges in OVS on KVM hypervisors) are the individual switches within the host
     * virtual switch. Virtual machines are connected to the host switches. When
     * creating a transport node, you need to specify if the host switches are already
     * manually preconfigured on the node, or if NSX should create and manage the host
     * switches. You specify this choice by the type of host switches you pass in the
     * host_switch_spec property of the TransportNode request payload. For a KVM host,
     * you can preconfigure the host switch, or you can have NSX Manager perform the
     * configuration. For an ESXi host NSX Manager always configures the host switch.
     * To preconfigure the host switches on a KVM host, pass an array of
     * PreconfiguredHostSwitchSpec objects that describes those host switches. In the
     * current NSX-T release, only one prefonfigured host switch can be specified. See
     * the PreconfiguredHostSwitchSpec schema definition for documentation on the
     * properties that must be provided. Preconfigured host switches are only supported
     * on KVM hosts, not on ESXi hosts. To allow NSX to manage the host switch
     * configuration on KVM hosts, ESXi hosts, pass an array of StandardHostSwitchSpec
     * objects in the host_switch_spec property, and NSX will automatically create host
     * switches with the properties you provide. In the current NSX-T release, up to 16
     * host switches can be automatically managed. See the StandardHostSwitchSpec
     * schema definition for documentation on the properties that must be provided. The
     * request should provide node_deployement_info.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param hostTransportNodeId (required)
     * @param hostTransportNode (required)
     * @param esxMgmtIfMigrationDest The network ids to which the ESX vmk interfaces will be migrated (optional)
     * @param ifId The ESX vmk interfaces to migrate (optional)
     * @param overrideNsxOwnership Override NSX Ownership (optional, default to false)
     * @param pingIp IP Addresses to ping right after ESX vmk interfaces were migrated. (optional)
     * @param skipValidation Whether to skip front-end validation for vmk/vnic/pnic migration (optional,
     * default to false)
     * @param vnic The ESX vmk interfaces and/or VM NIC to migrate (optional)
     * @param vnicMigrationDest The migration destinations of ESX vmk interfaces and/or VM NIC (optional)
     * @return com.vmware.nsx_policy.model.HostTransportNode
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.HostTransportNode update(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String hostTransportNodeId, com.vmware.nsx_policy.model.HostTransportNode hostTransportNode, java.lang.String esxMgmtIfMigrationDest, java.lang.String ifId, java.lang.Boolean overrideNsxOwnership, java.lang.String pingIp, java.lang.Boolean skipValidation, java.lang.String vnic, java.lang.String vnicMigrationDest);

    /**
     * Transport nodes are hypervisor hosts that will participate in an NSX-T overlay.
     * For a hypervisor host, this means that it hosts VMs that will communicate over
     * NSX-T logical switches. This API creates transport node for a host node
     * (hypervisor) in the transport network. When you run this command for a host, NSX
     * Manager attempts to install the NSX kernel modules, which are packaged as VIB,
     * RPM, or DEB files. For the installation to succeed, you must provide the host
     * login credentials and the host thumbprint. To get the ESXi host thumbprint, SSH
     * to the host and run the <b>openssl x509 -in /etc/vmware/ssl/rui.crt -fingerprint
     * -sha256 -noout</b> command. To generate host key thumbprint using SHA-256
     * algorithm please follow the steps below. Log into the host, making sure that the
     * connection is not vulnerable to a man in the middle attack. Check whether a
     * public key already exists. Host public key is generally located at
     * '/etc/ssh/ssh_host_rsa_key.pub'. If the key is not present then generate a new
     * key by running the following command and follow the instructions. <b>ssh-keygen
     * -t rsa</b> Now generate a SHA256 hash of the key using the following command.
     * Please make sure to pass the appropriate file name if the public key is stored
     * with a different file name other than the default 'id_rsa.pub'. <b>awk '{print
     * $2}' id_rsa.pub | base64 -d | sha256sum -b | sed 's/ .*$//' | xxd -r -p |
     * base64</b> Additional documentation on creating a transport node can be found in
     * the NSX-T Installation Guide. In order for the transport node to forward
     * packets, the host_switch_spec property must be specified. Host switches (called
     * bridges in OVS on KVM hypervisors) are the individual switches within the host
     * virtual switch. Virtual machines are connected to the host switches. When
     * creating a transport node, you need to specify if the host switches are already
     * manually preconfigured on the node, or if NSX should create and manage the host
     * switches. You specify this choice by the type of host switches you pass in the
     * host_switch_spec property of the TransportNode request payload. For a KVM host,
     * you can preconfigure the host switch, or you can have NSX Manager perform the
     * configuration. For an ESXi host NSX Manager always configures the host switch.
     * To preconfigure the host switches on a KVM host, pass an array of
     * PreconfiguredHostSwitchSpec objects that describes those host switches. In the
     * current NSX-T release, only one prefonfigured host switch can be specified. See
     * the PreconfiguredHostSwitchSpec schema definition for documentation on the
     * properties that must be provided. Preconfigured host switches are only supported
     * on KVM hosts, not on ESXi hosts. To allow NSX to manage the host switch
     * configuration on KVM hosts, ESXi hosts, pass an array of StandardHostSwitchSpec
     * objects in the host_switch_spec property, and NSX will automatically create host
     * switches with the properties you provide. In the current NSX-T release, up to 16
     * host switches can be automatically managed. See the StandardHostSwitchSpec
     * schema definition for documentation on the properties that must be provided. The
     * request should provide node_deployement_info.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param hostTransportNodeId (required)
     * @param hostTransportNode (required)
     * @param esxMgmtIfMigrationDest The network ids to which the ESX vmk interfaces will be migrated (optional)
     * @param ifId The ESX vmk interfaces to migrate (optional)
     * @param overrideNsxOwnership Override NSX Ownership (optional, default to false)
     * @param pingIp IP Addresses to ping right after ESX vmk interfaces were migrated. (optional)
     * @param skipValidation Whether to skip front-end validation for vmk/vnic/pnic migration (optional,
     * default to false)
     * @param vnic The ESX vmk interfaces and/or VM NIC to migrate (optional)
     * @param vnicMigrationDest The migration destinations of ESX vmk interfaces and/or VM NIC (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.HostTransportNode
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.HostTransportNode update(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String hostTransportNodeId, com.vmware.nsx_policy.model.HostTransportNode hostTransportNode, java.lang.String esxMgmtIfMigrationDest, java.lang.String ifId, java.lang.Boolean overrideNsxOwnership, java.lang.String pingIp, java.lang.Boolean skipValidation, java.lang.String vnic, java.lang.String vnicMigrationDest, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Transport nodes are hypervisor hosts that will participate in an NSX-T overlay.
     * For a hypervisor host, this means that it hosts VMs that will communicate over
     * NSX-T logical switches. This API creates transport node for a host node
     * (hypervisor) in the transport network. When you run this command for a host, NSX
     * Manager attempts to install the NSX kernel modules, which are packaged as VIB,
     * RPM, or DEB files. For the installation to succeed, you must provide the host
     * login credentials and the host thumbprint. To get the ESXi host thumbprint, SSH
     * to the host and run the <b>openssl x509 -in /etc/vmware/ssl/rui.crt -fingerprint
     * -sha256 -noout</b> command. To generate host key thumbprint using SHA-256
     * algorithm please follow the steps below. Log into the host, making sure that the
     * connection is not vulnerable to a man in the middle attack. Check whether a
     * public key already exists. Host public key is generally located at
     * '/etc/ssh/ssh_host_rsa_key.pub'. If the key is not present then generate a new
     * key by running the following command and follow the instructions. <b>ssh-keygen
     * -t rsa</b> Now generate a SHA256 hash of the key using the following command.
     * Please make sure to pass the appropriate file name if the public key is stored
     * with a different file name other than the default 'id_rsa.pub'. <b>awk '{print
     * $2}' id_rsa.pub | base64 -d | sha256sum -b | sed 's/ .*$//' | xxd -r -p |
     * base64</b> Additional documentation on creating a transport node can be found in
     * the NSX-T Installation Guide. In order for the transport node to forward
     * packets, the host_switch_spec property must be specified. Host switches (called
     * bridges in OVS on KVM hypervisors) are the individual switches within the host
     * virtual switch. Virtual machines are connected to the host switches. When
     * creating a transport node, you need to specify if the host switches are already
     * manually preconfigured on the node, or if NSX should create and manage the host
     * switches. You specify this choice by the type of host switches you pass in the
     * host_switch_spec property of the TransportNode request payload. For a KVM host,
     * you can preconfigure the host switch, or you can have NSX Manager perform the
     * configuration. For an ESXi host NSX Manager always configures the host switch.
     * To preconfigure the host switches on a KVM host, pass an array of
     * PreconfiguredHostSwitchSpec objects that describes those host switches. In the
     * current NSX-T release, only one prefonfigured host switch can be specified. See
     * the PreconfiguredHostSwitchSpec schema definition for documentation on the
     * properties that must be provided. Preconfigured host switches are only supported
     * on KVM hosts, not on ESXi hosts. To allow NSX to manage the host switch
     * configuration on KVM hosts, ESXi hosts, pass an array of StandardHostSwitchSpec
     * objects in the host_switch_spec property, and NSX will automatically create host
     * switches with the properties you provide. In the current NSX-T release, up to 16
     * host switches can be automatically managed. See the StandardHostSwitchSpec
     * schema definition for documentation on the properties that must be provided. The
     * request should provide node_deployement_info.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.HostTransportNode
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param hostTransportNodeId (required)
     * @param hostTransportNode (required)
     * @param esxMgmtIfMigrationDest The network ids to which the ESX vmk interfaces will be migrated (optional)
     * @param ifId The ESX vmk interfaces to migrate (optional)
     * @param overrideNsxOwnership Override NSX Ownership (optional, default to false)
     * @param pingIp IP Addresses to ping right after ESX vmk interfaces were migrated. (optional)
     * @param skipValidation Whether to skip front-end validation for vmk/vnic/pnic migration (optional,
     * default to false)
     * @param vnic The ESX vmk interfaces and/or VM NIC to migrate (optional)
     * @param vnicMigrationDest The migration destinations of ESX vmk interfaces and/or VM NIC (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String hostTransportNodeId, com.vmware.nsx_policy.model.HostTransportNode hostTransportNode, java.lang.String esxMgmtIfMigrationDest, java.lang.String ifId, java.lang.Boolean overrideNsxOwnership, java.lang.String pingIp, java.lang.Boolean skipValidation, java.lang.String vnic, java.lang.String vnicMigrationDest, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.HostTransportNode> asyncCallback);

    /**
     * Transport nodes are hypervisor hosts that will participate in an NSX-T overlay.
     * For a hypervisor host, this means that it hosts VMs that will communicate over
     * NSX-T logical switches. This API creates transport node for a host node
     * (hypervisor) in the transport network. When you run this command for a host, NSX
     * Manager attempts to install the NSX kernel modules, which are packaged as VIB,
     * RPM, or DEB files. For the installation to succeed, you must provide the host
     * login credentials and the host thumbprint. To get the ESXi host thumbprint, SSH
     * to the host and run the <b>openssl x509 -in /etc/vmware/ssl/rui.crt -fingerprint
     * -sha256 -noout</b> command. To generate host key thumbprint using SHA-256
     * algorithm please follow the steps below. Log into the host, making sure that the
     * connection is not vulnerable to a man in the middle attack. Check whether a
     * public key already exists. Host public key is generally located at
     * '/etc/ssh/ssh_host_rsa_key.pub'. If the key is not present then generate a new
     * key by running the following command and follow the instructions. <b>ssh-keygen
     * -t rsa</b> Now generate a SHA256 hash of the key using the following command.
     * Please make sure to pass the appropriate file name if the public key is stored
     * with a different file name other than the default 'id_rsa.pub'. <b>awk '{print
     * $2}' id_rsa.pub | base64 -d | sha256sum -b | sed 's/ .*$//' | xxd -r -p |
     * base64</b> Additional documentation on creating a transport node can be found in
     * the NSX-T Installation Guide. In order for the transport node to forward
     * packets, the host_switch_spec property must be specified. Host switches (called
     * bridges in OVS on KVM hypervisors) are the individual switches within the host
     * virtual switch. Virtual machines are connected to the host switches. When
     * creating a transport node, you need to specify if the host switches are already
     * manually preconfigured on the node, or if NSX should create and manage the host
     * switches. You specify this choice by the type of host switches you pass in the
     * host_switch_spec property of the TransportNode request payload. For a KVM host,
     * you can preconfigure the host switch, or you can have NSX Manager perform the
     * configuration. For an ESXi host NSX Manager always configures the host switch.
     * To preconfigure the host switches on a KVM host, pass an array of
     * PreconfiguredHostSwitchSpec objects that describes those host switches. In the
     * current NSX-T release, only one prefonfigured host switch can be specified. See
     * the PreconfiguredHostSwitchSpec schema definition for documentation on the
     * properties that must be provided. Preconfigured host switches are only supported
     * on KVM hosts, not on ESXi hosts. To allow NSX to manage the host switch
     * configuration on KVM hosts, ESXi hosts, pass an array of StandardHostSwitchSpec
     * objects in the host_switch_spec property, and NSX will automatically create host
     * switches with the properties you provide. In the current NSX-T release, up to 16
     * host switches can be automatically managed. See the StandardHostSwitchSpec
     * schema definition for documentation on the properties that must be provided. The
     * request should provide node_deployement_info.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.HostTransportNode
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param hostTransportNodeId (required)
     * @param hostTransportNode (required)
     * @param esxMgmtIfMigrationDest The network ids to which the ESX vmk interfaces will be migrated (optional)
     * @param ifId The ESX vmk interfaces to migrate (optional)
     * @param overrideNsxOwnership Override NSX Ownership (optional, default to false)
     * @param pingIp IP Addresses to ping right after ESX vmk interfaces were migrated. (optional)
     * @param skipValidation Whether to skip front-end validation for vmk/vnic/pnic migration (optional,
     * default to false)
     * @param vnic The ESX vmk interfaces and/or VM NIC to migrate (optional)
     * @param vnicMigrationDest The migration destinations of ESX vmk interfaces and/or VM NIC (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String hostTransportNodeId, com.vmware.nsx_policy.model.HostTransportNode hostTransportNode, java.lang.String esxMgmtIfMigrationDest, java.lang.String ifId, java.lang.Boolean overrideNsxOwnership, java.lang.String pingIp, java.lang.Boolean skipValidation, java.lang.String vnic, java.lang.String vnicMigrationDest, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.HostTransportNode> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Put transport node into maintenance mode or exit from maintenance mode. When
     * HostTransportNode is in maintenance mode no configuration changes are allowed
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param hostTransportNodeId (required)
     * @param action (optional)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void updatemaintenancemode(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String hostTransportNodeId, java.lang.String action);

    /**
     * Put transport node into maintenance mode or exit from maintenance mode. When
     * HostTransportNode is in maintenance mode no configuration changes are allowed
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param hostTransportNodeId (required)
     * @param action (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void updatemaintenancemode(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String hostTransportNodeId, java.lang.String action, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Put transport node into maintenance mode or exit from maintenance mode. When
     * HostTransportNode is in maintenance mode no configuration changes are allowed
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param hostTransportNodeId (required)
     * @param action (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void updatemaintenancemode(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String hostTransportNodeId, java.lang.String action, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Put transport node into maintenance mode or exit from maintenance mode. When
     * HostTransportNode is in maintenance mode no configuration changes are allowed
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param hostTransportNodeId (required)
     * @param action (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void updatemaintenancemode(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String hostTransportNodeId, java.lang.String action, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
