/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.infra.sites.enforcement_points.edge_clusters.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.infra.sites.enforcement_points.edge_clusters;

public interface UrlCategorizationConfigs extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.infra.sites.enforcement_points.edge_clusters.UrlCategorizationConfigsTypes {

    /**
     * Delete PolicyUrlCategorizationConfig. If deleted, the URL categorization will be
     * disabled for that edge cluster.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param siteId (required)
     * @param enforcementPointId (required)
     * @param edgeClusterId (required)
     * @param urlCategorizationConfigId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String edgeClusterId, java.lang.String urlCategorizationConfigId);

    /**
     * Delete PolicyUrlCategorizationConfig. If deleted, the URL categorization will be
     * disabled for that edge cluster.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param siteId (required)
     * @param enforcementPointId (required)
     * @param edgeClusterId (required)
     * @param urlCategorizationConfigId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String edgeClusterId, java.lang.String urlCategorizationConfigId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Delete PolicyUrlCategorizationConfig. If deleted, the URL categorization will be
     * disabled for that edge cluster.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementPointId (required)
     * @param edgeClusterId (required)
     * @param urlCategorizationConfigId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String edgeClusterId, java.lang.String urlCategorizationConfigId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Delete PolicyUrlCategorizationConfig. If deleted, the URL categorization will be
     * disabled for that edge cluster.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementPointId (required)
     * @param edgeClusterId (required)
     * @param urlCategorizationConfigId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String edgeClusterId, java.lang.String urlCategorizationConfigId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Gets a PolicyUrlCategorizationConfig. This returns the details of the config
     * like whether the URL categorization is enabled or disabled, the id of the
     * context profiles which are used to filter the categories, and the update
     * frequency of the data from the cloud.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param siteId (required)
     * @param enforcementPointId (required)
     * @param edgeClusterId (required)
     * @param urlCategorizationConfigId (required)
     * @return com.vmware.nsx_policy.model.PolicyUrlCategorizationConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.PolicyUrlCategorizationConfig get(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String edgeClusterId, java.lang.String urlCategorizationConfigId);

    /**
     * Gets a PolicyUrlCategorizationConfig. This returns the details of the config
     * like whether the URL categorization is enabled or disabled, the id of the
     * context profiles which are used to filter the categories, and the update
     * frequency of the data from the cloud.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param siteId (required)
     * @param enforcementPointId (required)
     * @param edgeClusterId (required)
     * @param urlCategorizationConfigId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.PolicyUrlCategorizationConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.PolicyUrlCategorizationConfig get(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String edgeClusterId, java.lang.String urlCategorizationConfigId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Gets a PolicyUrlCategorizationConfig. This returns the details of the config
     * like whether the URL categorization is enabled or disabled, the id of the
     * context profiles which are used to filter the categories, and the update
     * frequency of the data from the cloud.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyUrlCategorizationConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementPointId (required)
     * @param edgeClusterId (required)
     * @param urlCategorizationConfigId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String edgeClusterId, java.lang.String urlCategorizationConfigId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyUrlCategorizationConfig> asyncCallback);

    /**
     * Gets a PolicyUrlCategorizationConfig. This returns the details of the config
     * like whether the URL categorization is enabled or disabled, the id of the
     * context profiles which are used to filter the categories, and the update
     * frequency of the data from the cloud.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyUrlCategorizationConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementPointId (required)
     * @param edgeClusterId (required)
     * @param urlCategorizationConfigId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String edgeClusterId, java.lang.String urlCategorizationConfigId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyUrlCategorizationConfig> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Creates/Updates a PolicyUrlCategorizationConfig. Creating or updating the
     * PolicyUrlCategorizationConfig will enable or disable URL categorization for the
     * given edge cluster. If the context_profiles field is empty, the edge cluster
     * will detect all the categories of URLs. If context_profiles field has any
     * context profiles, the edge cluster will detect only the categories listed within
     * those context profiles. The context profiles should have attribute type
     * URL_CATEGORY. The update_frequency specifies how frequently in minutes, the edge
     * cluster will get updates about the URL data from the URL categorization cloud
     * service. If the update_frequency is not specified, the default update frequency
     * will be 30 min.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param siteId (required)
     * @param enforcementPointId (required)
     * @param edgeClusterId (required)
     * @param urlCategorizationConfigId (required)
     * @param policyUrlCategorizationConfig (required)
     * @return com.vmware.nsx_policy.model.PolicyUrlCategorizationConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.PolicyUrlCategorizationConfig patch(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String edgeClusterId, java.lang.String urlCategorizationConfigId, com.vmware.nsx_policy.model.PolicyUrlCategorizationConfig policyUrlCategorizationConfig);

    /**
     * Creates/Updates a PolicyUrlCategorizationConfig. Creating or updating the
     * PolicyUrlCategorizationConfig will enable or disable URL categorization for the
     * given edge cluster. If the context_profiles field is empty, the edge cluster
     * will detect all the categories of URLs. If context_profiles field has any
     * context profiles, the edge cluster will detect only the categories listed within
     * those context profiles. The context profiles should have attribute type
     * URL_CATEGORY. The update_frequency specifies how frequently in minutes, the edge
     * cluster will get updates about the URL data from the URL categorization cloud
     * service. If the update_frequency is not specified, the default update frequency
     * will be 30 min.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param siteId (required)
     * @param enforcementPointId (required)
     * @param edgeClusterId (required)
     * @param urlCategorizationConfigId (required)
     * @param policyUrlCategorizationConfig (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.PolicyUrlCategorizationConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.PolicyUrlCategorizationConfig patch(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String edgeClusterId, java.lang.String urlCategorizationConfigId, com.vmware.nsx_policy.model.PolicyUrlCategorizationConfig policyUrlCategorizationConfig, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Creates/Updates a PolicyUrlCategorizationConfig. Creating or updating the
     * PolicyUrlCategorizationConfig will enable or disable URL categorization for the
     * given edge cluster. If the context_profiles field is empty, the edge cluster
     * will detect all the categories of URLs. If context_profiles field has any
     * context profiles, the edge cluster will detect only the categories listed within
     * those context profiles. The context profiles should have attribute type
     * URL_CATEGORY. The update_frequency specifies how frequently in minutes, the edge
     * cluster will get updates about the URL data from the URL categorization cloud
     * service. If the update_frequency is not specified, the default update frequency
     * will be 30 min.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyUrlCategorizationConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementPointId (required)
     * @param edgeClusterId (required)
     * @param urlCategorizationConfigId (required)
     * @param policyUrlCategorizationConfig (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void patch(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String edgeClusterId, java.lang.String urlCategorizationConfigId, com.vmware.nsx_policy.model.PolicyUrlCategorizationConfig policyUrlCategorizationConfig, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyUrlCategorizationConfig> asyncCallback);

    /**
     * Creates/Updates a PolicyUrlCategorizationConfig. Creating or updating the
     * PolicyUrlCategorizationConfig will enable or disable URL categorization for the
     * given edge cluster. If the context_profiles field is empty, the edge cluster
     * will detect all the categories of URLs. If context_profiles field has any
     * context profiles, the edge cluster will detect only the categories listed within
     * those context profiles. The context profiles should have attribute type
     * URL_CATEGORY. The update_frequency specifies how frequently in minutes, the edge
     * cluster will get updates about the URL data from the URL categorization cloud
     * service. If the update_frequency is not specified, the default update frequency
     * will be 30 min.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyUrlCategorizationConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementPointId (required)
     * @param edgeClusterId (required)
     * @param urlCategorizationConfigId (required)
     * @param policyUrlCategorizationConfig (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void patch(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String edgeClusterId, java.lang.String urlCategorizationConfigId, com.vmware.nsx_policy.model.PolicyUrlCategorizationConfig policyUrlCategorizationConfig, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyUrlCategorizationConfig> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Creates/Updates a PolicyUrlCategorizationConfig. Creating or updating the
     * PolicyUrlCategorizationConfig will enable or disable URL categorization for the
     * given edge cluster. If the context_profiles field is empty, the edge cluster
     * will detect all the categories of URLs. If context_profiles field has any
     * context profiles, the edge cluster will detect only the categories listed within
     * those context profiles. The context profiles should have attribute type
     * URL_CATEGORY. The update_frequency specifies how frequently in minutes, the edge
     * cluster will get updates about the URL data from the URL categorization cloud
     * service. If the update_frequency is not specified, the default update frequency
     * will be 30 min.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param siteId (required)
     * @param enforcementPointId (required)
     * @param edgeClusterId (required)
     * @param urlCategorizationConfigId (required)
     * @param policyUrlCategorizationConfig (required)
     * @return com.vmware.nsx_policy.model.PolicyUrlCategorizationConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.PolicyUrlCategorizationConfig update(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String edgeClusterId, java.lang.String urlCategorizationConfigId, com.vmware.nsx_policy.model.PolicyUrlCategorizationConfig policyUrlCategorizationConfig);

    /**
     * Creates/Updates a PolicyUrlCategorizationConfig. Creating or updating the
     * PolicyUrlCategorizationConfig will enable or disable URL categorization for the
     * given edge cluster. If the context_profiles field is empty, the edge cluster
     * will detect all the categories of URLs. If context_profiles field has any
     * context profiles, the edge cluster will detect only the categories listed within
     * those context profiles. The context profiles should have attribute type
     * URL_CATEGORY. The update_frequency specifies how frequently in minutes, the edge
     * cluster will get updates about the URL data from the URL categorization cloud
     * service. If the update_frequency is not specified, the default update frequency
     * will be 30 min.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param siteId (required)
     * @param enforcementPointId (required)
     * @param edgeClusterId (required)
     * @param urlCategorizationConfigId (required)
     * @param policyUrlCategorizationConfig (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.PolicyUrlCategorizationConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.PolicyUrlCategorizationConfig update(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String edgeClusterId, java.lang.String urlCategorizationConfigId, com.vmware.nsx_policy.model.PolicyUrlCategorizationConfig policyUrlCategorizationConfig, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Creates/Updates a PolicyUrlCategorizationConfig. Creating or updating the
     * PolicyUrlCategorizationConfig will enable or disable URL categorization for the
     * given edge cluster. If the context_profiles field is empty, the edge cluster
     * will detect all the categories of URLs. If context_profiles field has any
     * context profiles, the edge cluster will detect only the categories listed within
     * those context profiles. The context profiles should have attribute type
     * URL_CATEGORY. The update_frequency specifies how frequently in minutes, the edge
     * cluster will get updates about the URL data from the URL categorization cloud
     * service. If the update_frequency is not specified, the default update frequency
     * will be 30 min.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyUrlCategorizationConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementPointId (required)
     * @param edgeClusterId (required)
     * @param urlCategorizationConfigId (required)
     * @param policyUrlCategorizationConfig (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String edgeClusterId, java.lang.String urlCategorizationConfigId, com.vmware.nsx_policy.model.PolicyUrlCategorizationConfig policyUrlCategorizationConfig, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyUrlCategorizationConfig> asyncCallback);

    /**
     * Creates/Updates a PolicyUrlCategorizationConfig. Creating or updating the
     * PolicyUrlCategorizationConfig will enable or disable URL categorization for the
     * given edge cluster. If the context_profiles field is empty, the edge cluster
     * will detect all the categories of URLs. If context_profiles field has any
     * context profiles, the edge cluster will detect only the categories listed within
     * those context profiles. The context profiles should have attribute type
     * URL_CATEGORY. The update_frequency specifies how frequently in minutes, the edge
     * cluster will get updates about the URL data from the URL categorization cloud
     * service. If the update_frequency is not specified, the default update frequency
     * will be 30 min.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyUrlCategorizationConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementPointId (required)
     * @param edgeClusterId (required)
     * @param urlCategorizationConfigId (required)
     * @param policyUrlCategorizationConfig (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String edgeClusterId, java.lang.String urlCategorizationConfigId, com.vmware.nsx_policy.model.PolicyUrlCategorizationConfig policyUrlCategorizationConfig, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyUrlCategorizationConfig> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
