/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.infra.sites.enforcement_points.host_transport_nodes.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.infra.sites.enforcement_points.host_transport_nodes;

public interface DiscoveredVifs extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.infra.sites.enforcement_points.host_transport_nodes.DiscoveredVifsTypes {

    /**
     * For the given TransportNode, fetch all the VIF info from VC and return the
     * corresponding state. Only host switch configured for security will be
     * considered.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param hostTransportNodeId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param hostSwitchId VDS identifier (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param segmentId Segment identifier (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx_policy.model.DiscoveredVifStateListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.DiscoveredVifStateListResult list(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String hostTransportNodeId, java.lang.String cursor, java.lang.String hostSwitchId, java.lang.String includedFields, java.lang.Long pageSize, java.lang.String segmentId, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * For the given TransportNode, fetch all the VIF info from VC and return the
     * corresponding state. Only host switch configured for security will be
     * considered.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param hostTransportNodeId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param hostSwitchId VDS identifier (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param segmentId Segment identifier (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.DiscoveredVifStateListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_policy.model.DiscoveredVifStateListResult list(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String hostTransportNodeId, java.lang.String cursor, java.lang.String hostSwitchId, java.lang.String includedFields, java.lang.Long pageSize, java.lang.String segmentId, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * For the given TransportNode, fetch all the VIF info from VC and return the
     * corresponding state. Only host switch configured for security will be
     * considered.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.DiscoveredVifStateListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param hostTransportNodeId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param hostSwitchId VDS identifier (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param segmentId Segment identifier (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String hostTransportNodeId, java.lang.String cursor, java.lang.String hostSwitchId, java.lang.String includedFields, java.lang.Long pageSize, java.lang.String segmentId, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.DiscoveredVifStateListResult> asyncCallback);

    /**
     * For the given TransportNode, fetch all the VIF info from VC and return the
     * corresponding state. Only host switch configured for security will be
     * considered.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.DiscoveredVifStateListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param hostTransportNodeId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param hostSwitchId VDS identifier (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param segmentId Segment identifier (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String hostTransportNodeId, java.lang.String cursor, java.lang.String hostSwitchId, java.lang.String includedFields, java.lang.Long pageSize, java.lang.String segmentId, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.DiscoveredVifStateListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
