/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.infra.tier_1s.locale_services.l2vpn_services.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.infra.tier_1s.locale_services.l2vpn_services;

public interface Sessions extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.infra.tier_1s.locale_services.l2vpn_services.SessionsTypes {

    /**
     * Create or patch an L2VPN session under Tier-1 from Peer Codes. In addition to
     * the L2VPN Session, the IPSec VPN Session, along with the IKE, Tunnel, and DPD
     * Profiles are created and owned by the system. IPSec VPN Service and Local
     * Endpoint are created only when required, i.e., an IPSec VPN Service does not
     * already exist, or an IPSec VPN Local Endpoint with same local address does not
     * already exist. Updating the L2VPN Session can be performed only through this API
     * by specifying new peer codes. Use of specific APIs to update the L2VPN Session
     * and the different resources associated with it is not allowed, except for IPSec
     * VPN Service and Local Endpoint, resources that are not system owned. API
     * supported only when L2VPN Service is in Client Mode. <br/> This API is
     * deprecated. Please use POST
     * /infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>/sessions/<session-id>?action=create_with_peer_code
     * instead. Note: Please note that request is validated and any error messages
     * returned from validation may include the new VPN path instead of the deprecated
     * path. Both new path and old path refer to same resource. Also VPN path returned
     * in the Alarm, GPRR payload may include the new VPN path.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier1Id (required)
     * @param localeServiceId (required)
     * @param serviceId (required)
     * @param sessionId (required)
     * @param l2VPNSessionData (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void createwithpeercode(java.lang.String tier1Id, java.lang.String localeServiceId, java.lang.String serviceId, java.lang.String sessionId, com.vmware.nsx_policy.model.L2VPNSessionData l2VPNSessionData);

    /**
     * Create or patch an L2VPN session under Tier-1 from Peer Codes. In addition to
     * the L2VPN Session, the IPSec VPN Session, along with the IKE, Tunnel, and DPD
     * Profiles are created and owned by the system. IPSec VPN Service and Local
     * Endpoint are created only when required, i.e., an IPSec VPN Service does not
     * already exist, or an IPSec VPN Local Endpoint with same local address does not
     * already exist. Updating the L2VPN Session can be performed only through this API
     * by specifying new peer codes. Use of specific APIs to update the L2VPN Session
     * and the different resources associated with it is not allowed, except for IPSec
     * VPN Service and Local Endpoint, resources that are not system owned. API
     * supported only when L2VPN Service is in Client Mode. <br/> This API is
     * deprecated. Please use POST
     * /infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>/sessions/<session-id>?action=create_with_peer_code
     * instead. Note: Please note that request is validated and any error messages
     * returned from validation may include the new VPN path instead of the deprecated
     * path. Both new path and old path refer to same resource. Also VPN path returned
     * in the Alarm, GPRR payload may include the new VPN path.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier1Id (required)
     * @param localeServiceId (required)
     * @param serviceId (required)
     * @param sessionId (required)
     * @param l2VPNSessionData (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void createwithpeercode(java.lang.String tier1Id, java.lang.String localeServiceId, java.lang.String serviceId, java.lang.String sessionId, com.vmware.nsx_policy.model.L2VPNSessionData l2VPNSessionData, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Create or patch an L2VPN session under Tier-1 from Peer Codes. In addition to
     * the L2VPN Session, the IPSec VPN Session, along with the IKE, Tunnel, and DPD
     * Profiles are created and owned by the system. IPSec VPN Service and Local
     * Endpoint are created only when required, i.e., an IPSec VPN Service does not
     * already exist, or an IPSec VPN Local Endpoint with same local address does not
     * already exist. Updating the L2VPN Session can be performed only through this API
     * by specifying new peer codes. Use of specific APIs to update the L2VPN Session
     * and the different resources associated with it is not allowed, except for IPSec
     * VPN Service and Local Endpoint, resources that are not system owned. API
     * supported only when L2VPN Service is in Client Mode. <br/> This API is
     * deprecated. Please use POST
     * /infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>/sessions/<session-id>?action=create_with_peer_code
     * instead. Note: Please note that request is validated and any error messages
     * returned from validation may include the new VPN path instead of the deprecated
     * path. Both new path and old path refer to same resource. Also VPN path returned
     * in the Alarm, GPRR payload may include the new VPN path.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier1Id (required)
     * @param localeServiceId (required)
     * @param serviceId (required)
     * @param sessionId (required)
     * @param l2VPNSessionData (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void createwithpeercode(java.lang.String tier1Id, java.lang.String localeServiceId, java.lang.String serviceId, java.lang.String sessionId, com.vmware.nsx_policy.model.L2VPNSessionData l2VPNSessionData, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Create or patch an L2VPN session under Tier-1 from Peer Codes. In addition to
     * the L2VPN Session, the IPSec VPN Session, along with the IKE, Tunnel, and DPD
     * Profiles are created and owned by the system. IPSec VPN Service and Local
     * Endpoint are created only when required, i.e., an IPSec VPN Service does not
     * already exist, or an IPSec VPN Local Endpoint with same local address does not
     * already exist. Updating the L2VPN Session can be performed only through this API
     * by specifying new peer codes. Use of specific APIs to update the L2VPN Session
     * and the different resources associated with it is not allowed, except for IPSec
     * VPN Service and Local Endpoint, resources that are not system owned. API
     * supported only when L2VPN Service is in Client Mode. <br/> This API is
     * deprecated. Please use POST
     * /infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>/sessions/<session-id>?action=create_with_peer_code
     * instead. Note: Please note that request is validated and any error messages
     * returned from validation may include the new VPN path instead of the deprecated
     * path. Both new path and old path refer to same resource. Also VPN path returned
     * in the Alarm, GPRR payload may include the new VPN path.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier1Id (required)
     * @param localeServiceId (required)
     * @param serviceId (required)
     * @param sessionId (required)
     * @param l2VPNSessionData (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void createwithpeercode(java.lang.String tier1Id, java.lang.String localeServiceId, java.lang.String serviceId, java.lang.String sessionId, com.vmware.nsx_policy.model.L2VPNSessionData l2VPNSessionData, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Delete L2VPN session under Tier-1. When L2VPN Service is in CLIENT Mode, the
     * L2VPN Session is deleted along with its transpot tunnels and related resources.
     * <br/> This API is deprecated. Please use DELETE
     * /infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>/ sessions/<session-id>
     * instead. Note: Please note that request is validated and any error messages
     * returned from validation may include the new VPN path instead of the deprecated
     * path. Both new path and old path refer to same resource. Also VPN path returned
     * in the Alarm, GPRR payload may include the new VPN path.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier1Id (required)
     * @param localeServiceId (required)
     * @param serviceId (required)
     * @param sessionId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void delete(java.lang.String tier1Id, java.lang.String localeServiceId, java.lang.String serviceId, java.lang.String sessionId);

    /**
     * Delete L2VPN session under Tier-1. When L2VPN Service is in CLIENT Mode, the
     * L2VPN Session is deleted along with its transpot tunnels and related resources.
     * <br/> This API is deprecated. Please use DELETE
     * /infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>/ sessions/<session-id>
     * instead. Note: Please note that request is validated and any error messages
     * returned from validation may include the new VPN path instead of the deprecated
     * path. Both new path and old path refer to same resource. Also VPN path returned
     * in the Alarm, GPRR payload may include the new VPN path.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier1Id (required)
     * @param localeServiceId (required)
     * @param serviceId (required)
     * @param sessionId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void delete(java.lang.String tier1Id, java.lang.String localeServiceId, java.lang.String serviceId, java.lang.String sessionId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Delete L2VPN session under Tier-1. When L2VPN Service is in CLIENT Mode, the
     * L2VPN Session is deleted along with its transpot tunnels and related resources.
     * <br/> This API is deprecated. Please use DELETE
     * /infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>/ sessions/<session-id>
     * instead. Note: Please note that request is validated and any error messages
     * returned from validation may include the new VPN path instead of the deprecated
     * path. Both new path and old path refer to same resource. Also VPN path returned
     * in the Alarm, GPRR payload may include the new VPN path.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier1Id (required)
     * @param localeServiceId (required)
     * @param serviceId (required)
     * @param sessionId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void delete(java.lang.String tier1Id, java.lang.String localeServiceId, java.lang.String serviceId, java.lang.String sessionId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Delete L2VPN session under Tier-1. When L2VPN Service is in CLIENT Mode, the
     * L2VPN Session is deleted along with its transpot tunnels and related resources.
     * <br/> This API is deprecated. Please use DELETE
     * /infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>/ sessions/<session-id>
     * instead. Note: Please note that request is validated and any error messages
     * returned from validation may include the new VPN path instead of the deprecated
     * path. Both new path and old path refer to same resource. Also VPN path returned
     * in the Alarm, GPRR payload may include the new VPN path.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier1Id (required)
     * @param localeServiceId (required)
     * @param serviceId (required)
     * @param sessionId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void delete(java.lang.String tier1Id, java.lang.String localeServiceId, java.lang.String serviceId, java.lang.String sessionId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Get L2VPN session under Tier-1. <br/> This API is deprecated. Please use GET
     * /infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>/ sessions/<session-id>
     * instead. Note: The API will return a new VPN path for \"transport_tunnels\" in
     * the response payload instead of the deprecated API path Both paths refer to the
     * same object. Please note that request is validated and any error messages
     * returned from validation may include the new VPN path instead of the deprecated
     * path. Both new path and old path refer to same resource.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier1Id (required)
     * @param localeServiceId (required)
     * @param serviceId (required)
     * @param sessionId (required)
     * @return com.vmware.nsx_policy.model.L2VPNSession
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx_policy.model.L2VPNSession get(java.lang.String tier1Id, java.lang.String localeServiceId, java.lang.String serviceId, java.lang.String sessionId);

    /**
     * Get L2VPN session under Tier-1. <br/> This API is deprecated. Please use GET
     * /infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>/ sessions/<session-id>
     * instead. Note: The API will return a new VPN path for \"transport_tunnels\" in
     * the response payload instead of the deprecated API path Both paths refer to the
     * same object. Please note that request is validated and any error messages
     * returned from validation may include the new VPN path instead of the deprecated
     * path. Both new path and old path refer to same resource.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier1Id (required)
     * @param localeServiceId (required)
     * @param serviceId (required)
     * @param sessionId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.L2VPNSession
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx_policy.model.L2VPNSession get(java.lang.String tier1Id, java.lang.String localeServiceId, java.lang.String serviceId, java.lang.String sessionId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get L2VPN session under Tier-1. <br/> This API is deprecated. Please use GET
     * /infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>/ sessions/<session-id>
     * instead. Note: The API will return a new VPN path for \"transport_tunnels\" in
     * the response payload instead of the deprecated API path Both paths refer to the
     * same object. Please note that request is validated and any error messages
     * returned from validation may include the new VPN path instead of the deprecated
     * path. Both new path and old path refer to same resource.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.L2VPNSession
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier1Id (required)
     * @param localeServiceId (required)
     * @param serviceId (required)
     * @param sessionId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String tier1Id, java.lang.String localeServiceId, java.lang.String serviceId, java.lang.String sessionId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.L2VPNSession> asyncCallback);

    /**
     * Get L2VPN session under Tier-1. <br/> This API is deprecated. Please use GET
     * /infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>/ sessions/<session-id>
     * instead. Note: The API will return a new VPN path for \"transport_tunnels\" in
     * the response payload instead of the deprecated API path Both paths refer to the
     * same object. Please note that request is validated and any error messages
     * returned from validation may include the new VPN path instead of the deprecated
     * path. Both new path and old path refer to same resource.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.L2VPNSession
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier1Id (required)
     * @param localeServiceId (required)
     * @param serviceId (required)
     * @param sessionId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String tier1Id, java.lang.String localeServiceId, java.lang.String serviceId, java.lang.String sessionId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.L2VPNSession> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Get paginated list of all L2VPN sessions under Tier-1. <br/> This API is
     * deprecated. Please use GET
     * /infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>/sessions instead. Note:
     * The API will return a new VPN path for \"transport_tunnels\" in the response
     * payload instead of the deprecated API path Both paths refer to the same object.
     * Please note that request is validated and any error messages returned from
     * validation may include the new VPN path instead of the deprecated path. Both new
     * path and old path refer to same resource.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier1Id (required)
     * @param localeServiceId (required)
     * @param serviceId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx_policy.model.L2VPNSessionListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx_policy.model.L2VPNSessionListResult list(java.lang.String tier1Id, java.lang.String localeServiceId, java.lang.String serviceId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * Get paginated list of all L2VPN sessions under Tier-1. <br/> This API is
     * deprecated. Please use GET
     * /infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>/sessions instead. Note:
     * The API will return a new VPN path for \"transport_tunnels\" in the response
     * payload instead of the deprecated API path Both paths refer to the same object.
     * Please note that request is validated and any error messages returned from
     * validation may include the new VPN path instead of the deprecated path. Both new
     * path and old path refer to same resource.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier1Id (required)
     * @param localeServiceId (required)
     * @param serviceId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.L2VPNSessionListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx_policy.model.L2VPNSessionListResult list(java.lang.String tier1Id, java.lang.String localeServiceId, java.lang.String serviceId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get paginated list of all L2VPN sessions under Tier-1. <br/> This API is
     * deprecated. Please use GET
     * /infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>/sessions instead. Note:
     * The API will return a new VPN path for \"transport_tunnels\" in the response
     * payload instead of the deprecated API path Both paths refer to the same object.
     * Please note that request is validated and any error messages returned from
     * validation may include the new VPN path instead of the deprecated path. Both new
     * path and old path refer to same resource.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.L2VPNSessionListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier1Id (required)
     * @param localeServiceId (required)
     * @param serviceId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void list(java.lang.String tier1Id, java.lang.String localeServiceId, java.lang.String serviceId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.L2VPNSessionListResult> asyncCallback);

    /**
     * Get paginated list of all L2VPN sessions under Tier-1. <br/> This API is
     * deprecated. Please use GET
     * /infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>/sessions instead. Note:
     * The API will return a new VPN path for \"transport_tunnels\" in the response
     * payload instead of the deprecated API path Both paths refer to the same object.
     * Please note that request is validated and any error messages returned from
     * validation may include the new VPN path instead of the deprecated path. Both new
     * path and old path refer to same resource.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.L2VPNSessionListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier1Id (required)
     * @param localeServiceId (required)
     * @param serviceId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void list(java.lang.String tier1Id, java.lang.String localeServiceId, java.lang.String serviceId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.L2VPNSessionListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Create or patch an L2VPN session under Tier-1. API supported only when L2VPN
     * Service is in Server Mode. <br/> This API is deprecated. Please use PATCH
     * /infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>/ sessions/<session-id>
     * instead. Note: Please note that request is validated and any error messages
     * returned from validation may include the new VPN path instead of the deprecated
     * path. Both new path and old path refer to same resource. Also VPN path returned
     * in the Alarm, GPRR payload may include the new VPN path.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier1Id (required)
     * @param localeServiceId (required)
     * @param serviceId (required)
     * @param sessionId (required)
     * @param l2VPNSession (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void patch(java.lang.String tier1Id, java.lang.String localeServiceId, java.lang.String serviceId, java.lang.String sessionId, com.vmware.nsx_policy.model.L2VPNSession l2VPNSession);

    /**
     * Create or patch an L2VPN session under Tier-1. API supported only when L2VPN
     * Service is in Server Mode. <br/> This API is deprecated. Please use PATCH
     * /infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>/ sessions/<session-id>
     * instead. Note: Please note that request is validated and any error messages
     * returned from validation may include the new VPN path instead of the deprecated
     * path. Both new path and old path refer to same resource. Also VPN path returned
     * in the Alarm, GPRR payload may include the new VPN path.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier1Id (required)
     * @param localeServiceId (required)
     * @param serviceId (required)
     * @param sessionId (required)
     * @param l2VPNSession (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void patch(java.lang.String tier1Id, java.lang.String localeServiceId, java.lang.String serviceId, java.lang.String sessionId, com.vmware.nsx_policy.model.L2VPNSession l2VPNSession, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Create or patch an L2VPN session under Tier-1. API supported only when L2VPN
     * Service is in Server Mode. <br/> This API is deprecated. Please use PATCH
     * /infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>/ sessions/<session-id>
     * instead. Note: Please note that request is validated and any error messages
     * returned from validation may include the new VPN path instead of the deprecated
     * path. Both new path and old path refer to same resource. Also VPN path returned
     * in the Alarm, GPRR payload may include the new VPN path.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier1Id (required)
     * @param localeServiceId (required)
     * @param serviceId (required)
     * @param sessionId (required)
     * @param l2VPNSession (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void patch(java.lang.String tier1Id, java.lang.String localeServiceId, java.lang.String serviceId, java.lang.String sessionId, com.vmware.nsx_policy.model.L2VPNSession l2VPNSession, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Create or patch an L2VPN session under Tier-1. API supported only when L2VPN
     * Service is in Server Mode. <br/> This API is deprecated. Please use PATCH
     * /infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>/ sessions/<session-id>
     * instead. Note: Please note that request is validated and any error messages
     * returned from validation may include the new VPN path instead of the deprecated
     * path. Both new path and old path refer to same resource. Also VPN path returned
     * in the Alarm, GPRR payload may include the new VPN path.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier1Id (required)
     * @param localeServiceId (required)
     * @param serviceId (required)
     * @param sessionId (required)
     * @param l2VPNSession (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void patch(java.lang.String tier1Id, java.lang.String localeServiceId, java.lang.String serviceId, java.lang.String sessionId, com.vmware.nsx_policy.model.L2VPNSession l2VPNSession, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Create or fully replace L2VPN session under Tier-1. API supported only when
     * L2VPN Service is in Server Mode. Revision is optional for creation and required
     * for update. <br/> This API is deprecated. Please use PUT
     * /infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>/ sessions/<session-id>
     * instead. Note: The API will return a new VPN path for \"transport_tunnels\" in
     * the response payload instead of the deprecated API path Both paths refer to the
     * same object. Please note that request is validated and any error messages
     * returned from validation may include the new VPN path instead of the deprecated
     * path. Both new path and old path refer to same resource. Also VPN path returned
     * in the Alarm, GPRR payload may include the new VPN path.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier1Id (required)
     * @param localeServiceId (required)
     * @param serviceId (required)
     * @param sessionId (required)
     * @param l2VPNSession (required)
     * @return com.vmware.nsx_policy.model.L2VPNSession
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx_policy.model.L2VPNSession update(java.lang.String tier1Id, java.lang.String localeServiceId, java.lang.String serviceId, java.lang.String sessionId, com.vmware.nsx_policy.model.L2VPNSession l2VPNSession);

    /**
     * Create or fully replace L2VPN session under Tier-1. API supported only when
     * L2VPN Service is in Server Mode. Revision is optional for creation and required
     * for update. <br/> This API is deprecated. Please use PUT
     * /infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>/ sessions/<session-id>
     * instead. Note: The API will return a new VPN path for \"transport_tunnels\" in
     * the response payload instead of the deprecated API path Both paths refer to the
     * same object. Please note that request is validated and any error messages
     * returned from validation may include the new VPN path instead of the deprecated
     * path. Both new path and old path refer to same resource. Also VPN path returned
     * in the Alarm, GPRR payload may include the new VPN path.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier1Id (required)
     * @param localeServiceId (required)
     * @param serviceId (required)
     * @param sessionId (required)
     * @param l2VPNSession (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.L2VPNSession
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx_policy.model.L2VPNSession update(java.lang.String tier1Id, java.lang.String localeServiceId, java.lang.String serviceId, java.lang.String sessionId, com.vmware.nsx_policy.model.L2VPNSession l2VPNSession, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Create or fully replace L2VPN session under Tier-1. API supported only when
     * L2VPN Service is in Server Mode. Revision is optional for creation and required
     * for update. <br/> This API is deprecated. Please use PUT
     * /infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>/ sessions/<session-id>
     * instead. Note: The API will return a new VPN path for \"transport_tunnels\" in
     * the response payload instead of the deprecated API path Both paths refer to the
     * same object. Please note that request is validated and any error messages
     * returned from validation may include the new VPN path instead of the deprecated
     * path. Both new path and old path refer to same resource. Also VPN path returned
     * in the Alarm, GPRR payload may include the new VPN path.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.L2VPNSession
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier1Id (required)
     * @param localeServiceId (required)
     * @param serviceId (required)
     * @param sessionId (required)
     * @param l2VPNSession (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void update(java.lang.String tier1Id, java.lang.String localeServiceId, java.lang.String serviceId, java.lang.String sessionId, com.vmware.nsx_policy.model.L2VPNSession l2VPNSession, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.L2VPNSession> asyncCallback);

    /**
     * Create or fully replace L2VPN session under Tier-1. API supported only when
     * L2VPN Service is in Server Mode. Revision is optional for creation and required
     * for update. <br/> This API is deprecated. Please use PUT
     * /infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>/ sessions/<session-id>
     * instead. Note: The API will return a new VPN path for \"transport_tunnels\" in
     * the response payload instead of the deprecated API path Both paths refer to the
     * same object. Please note that request is validated and any error messages
     * returned from validation may include the new VPN path instead of the deprecated
     * path. Both new path and old path refer to same resource. Also VPN path returned
     * in the Alarm, GPRR payload may include the new VPN path.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.L2VPNSession
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier1Id (required)
     * @param localeServiceId (required)
     * @param serviceId (required)
     * @param sessionId (required)
     * @param l2VPNSession (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void update(java.lang.String tier1Id, java.lang.String localeServiceId, java.lang.String serviceId, java.lang.String sessionId, com.vmware.nsx_policy.model.L2VPNSession l2VPNSession, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.L2VPNSession> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
