/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Advanced load balancer ClientLogConfiguration object
 */
public final class ALBClientLogConfiguration implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String FILTERED_LOG_PROCESSING_NONE = "LOGS_PROCESSING_NONE";

    public static final java.lang.String FILTERED_LOG_PROCESSING_SYNC_AND_INDEX_ON_DEMAND = "LOGS_PROCESSING_SYNC_AND_INDEX_ON_DEMAND";

    public static final java.lang.String FILTERED_LOG_PROCESSING_AUTO_SYNC_AND_INDEX = "LOGS_PROCESSING_AUTO_SYNC_AND_INDEX";

    public static final java.lang.String FILTERED_LOG_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND = "LOGS_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND";

    public static final java.lang.String NON_SIGNIFICANT_LOG_PROCESSING_NONE = "LOGS_PROCESSING_NONE";

    public static final java.lang.String NON_SIGNIFICANT_LOG_PROCESSING_SYNC_AND_INDEX_ON_DEMAND = "LOGS_PROCESSING_SYNC_AND_INDEX_ON_DEMAND";

    public static final java.lang.String NON_SIGNIFICANT_LOG_PROCESSING_AUTO_SYNC_AND_INDEX = "LOGS_PROCESSING_AUTO_SYNC_AND_INDEX";

    public static final java.lang.String NON_SIGNIFICANT_LOG_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND = "LOGS_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND";

    public static final java.lang.String SIGNIFICANT_LOG_PROCESSING_NONE = "LOGS_PROCESSING_NONE";

    public static final java.lang.String SIGNIFICANT_LOG_PROCESSING_SYNC_AND_INDEX_ON_DEMAND = "LOGS_PROCESSING_SYNC_AND_INDEX_ON_DEMAND";

    public static final java.lang.String SIGNIFICANT_LOG_PROCESSING_AUTO_SYNC_AND_INDEX = "LOGS_PROCESSING_AUTO_SYNC_AND_INDEX";

    public static final java.lang.String SIGNIFICANT_LOG_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND = "LOGS_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND";

    private java.lang.Boolean enableSignificantLogCollection;

    private java.lang.String filteredLogProcessing;

    private java.lang.String nonSignificantLogProcessing;

    private java.lang.String significantLogProcessing;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBClientLogConfiguration() {
    }

    protected ALBClientLogConfiguration(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Enable significant log collection. By default, this flag is enabled, which means
     * that Avi SEs collect significant logs and forward them to Controller for further
     * processing. For example, these logs correspond to error conditions such as when
     * the response code for a request is 500. Users can deactivate this flag to turn
     * off default significant log collection. Allowed in Basic(Allowed values- false)
     * edition, Essentials(Allowed values- false) edition, Enterprise edition. Special
     * default for Basic edition is false, Essentials edition is false, Enterprise is
     * True. Default value when not specified in API or module is interpreted by ALB
     * Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnableSignificantLogCollection() {
        return this.enableSignificantLogCollection;
    }

    /**
     * Enable significant log collection. By default, this flag is enabled, which means
     * that Avi SEs collect significant logs and forward them to Controller for further
     * processing. For example, these logs correspond to error conditions such as when
     * the response code for a request is 500. Users can deactivate this flag to turn
     * off default significant log collection. Allowed in Basic(Allowed values- false)
     * edition, Essentials(Allowed values- false) edition, Enterprise edition. Special
     * default for Basic edition is false, Essentials edition is false, Enterprise is
     * True. Default value when not specified in API or module is interpreted by ALB
     * Controller as false.
     *
     * @param enableSignificantLogCollection New value for the property.
     */
    public void setEnableSignificantLogCollection(java.lang.Boolean enableSignificantLogCollection) {
        this.enableSignificantLogCollection = enableSignificantLogCollection;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogConfiguration#FILTERED_LOG_PROCESSING_NONE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogConfiguration#FILTERED_LOG_PROCESSING_SYNC_AND_INDEX_ON_DEMAND}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogConfiguration#FILTERED_LOG_PROCESSING_AUTO_SYNC_AND_INDEX}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogConfiguration#FILTERED_LOG_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND}</li>
     * </ul> Filtered logs are logs that match any client log filters or rules with
     * logging enabled. Such logs are processed by the Logs Analytics system according
     * to this setting. Enum options - LOGS_PROCESSING_NONE,
     * LOGS_PROCESSING_SYNC_AND_INDEX_ON_DEMAND, LOGS_PROCESSING_AUTO_SYNC_AND_INDEX,
     * LOGS_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND. Default value when not specified
     * in API or module is interpreted by ALB Controller as
     * LOGS_PROCESSING_SYNC_AND_INDEX_ON_DEMAND.
     *
     * @return The current value of the property.
     */
    public java.lang.String getFilteredLogProcessing() {
        return this.filteredLogProcessing;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogConfiguration#FILTERED_LOG_PROCESSING_NONE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogConfiguration#FILTERED_LOG_PROCESSING_SYNC_AND_INDEX_ON_DEMAND}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogConfiguration#FILTERED_LOG_PROCESSING_AUTO_SYNC_AND_INDEX}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogConfiguration#FILTERED_LOG_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND}</li>
     * </ul> Filtered logs are logs that match any client log filters or rules with
     * logging enabled. Such logs are processed by the Logs Analytics system according
     * to this setting. Enum options - LOGS_PROCESSING_NONE,
     * LOGS_PROCESSING_SYNC_AND_INDEX_ON_DEMAND, LOGS_PROCESSING_AUTO_SYNC_AND_INDEX,
     * LOGS_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND. Default value when not specified
     * in API or module is interpreted by ALB Controller as
     * LOGS_PROCESSING_SYNC_AND_INDEX_ON_DEMAND.
     *
     * @param filteredLogProcessing New value for the property.
     */
    public void setFilteredLogProcessing(java.lang.String filteredLogProcessing) {
        this.filteredLogProcessing = filteredLogProcessing;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogConfiguration#NON_SIGNIFICANT_LOG_PROCESSING_NONE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogConfiguration#NON_SIGNIFICANT_LOG_PROCESSING_SYNC_AND_INDEX_ON_DEMAND}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogConfiguration#NON_SIGNIFICANT_LOG_PROCESSING_AUTO_SYNC_AND_INDEX}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogConfiguration#NON_SIGNIFICANT_LOG_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND}</li>
     * </ul> Logs that are neither significant nor filtered, are processed by the Logs
     * Analytics system according to this setting. Enum options - LOGS_PROCESSING_NONE,
     * LOGS_PROCESSING_SYNC_AND_INDEX_ON_DEMAND, LOGS_PROCESSING_AUTO_SYNC_AND_INDEX,
     * LOGS_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND. Default value when not specified
     * in API or module is interpreted by ALB Controller as
     * LOGS_PROCESSING_SYNC_AND_INDEX_ON_DEMAND.
     *
     * @return The current value of the property.
     */
    public java.lang.String getNonSignificantLogProcessing() {
        return this.nonSignificantLogProcessing;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogConfiguration#NON_SIGNIFICANT_LOG_PROCESSING_NONE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogConfiguration#NON_SIGNIFICANT_LOG_PROCESSING_SYNC_AND_INDEX_ON_DEMAND}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogConfiguration#NON_SIGNIFICANT_LOG_PROCESSING_AUTO_SYNC_AND_INDEX}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogConfiguration#NON_SIGNIFICANT_LOG_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND}</li>
     * </ul> Logs that are neither significant nor filtered, are processed by the Logs
     * Analytics system according to this setting. Enum options - LOGS_PROCESSING_NONE,
     * LOGS_PROCESSING_SYNC_AND_INDEX_ON_DEMAND, LOGS_PROCESSING_AUTO_SYNC_AND_INDEX,
     * LOGS_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND. Default value when not specified
     * in API or module is interpreted by ALB Controller as
     * LOGS_PROCESSING_SYNC_AND_INDEX_ON_DEMAND.
     *
     * @param nonSignificantLogProcessing New value for the property.
     */
    public void setNonSignificantLogProcessing(java.lang.String nonSignificantLogProcessing) {
        this.nonSignificantLogProcessing = nonSignificantLogProcessing;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogConfiguration#SIGNIFICANT_LOG_PROCESSING_NONE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogConfiguration#SIGNIFICANT_LOG_PROCESSING_SYNC_AND_INDEX_ON_DEMAND}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogConfiguration#SIGNIFICANT_LOG_PROCESSING_AUTO_SYNC_AND_INDEX}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogConfiguration#SIGNIFICANT_LOG_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND}</li>
     * </ul> Significant logs are processed by the Logs Analytics system according to
     * this setting. Enum options - LOGS_PROCESSING_NONE,
     * LOGS_PROCESSING_SYNC_AND_INDEX_ON_DEMAND, LOGS_PROCESSING_AUTO_SYNC_AND_INDEX,
     * LOGS_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND. Default value when not specified
     * in API or module is interpreted by ALB Controller as
     * LOGS_PROCESSING_SYNC_AND_INDEX_ON_DEMAND.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSignificantLogProcessing() {
        return this.significantLogProcessing;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogConfiguration#SIGNIFICANT_LOG_PROCESSING_NONE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogConfiguration#SIGNIFICANT_LOG_PROCESSING_SYNC_AND_INDEX_ON_DEMAND}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogConfiguration#SIGNIFICANT_LOG_PROCESSING_AUTO_SYNC_AND_INDEX}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogConfiguration#SIGNIFICANT_LOG_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND}</li>
     * </ul> Significant logs are processed by the Logs Analytics system according to
     * this setting. Enum options - LOGS_PROCESSING_NONE,
     * LOGS_PROCESSING_SYNC_AND_INDEX_ON_DEMAND, LOGS_PROCESSING_AUTO_SYNC_AND_INDEX,
     * LOGS_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND. Default value when not specified
     * in API or module is interpreted by ALB Controller as
     * LOGS_PROCESSING_SYNC_AND_INDEX_ON_DEMAND.
     *
     * @param significantLogProcessing New value for the property.
     */
    public void setSignificantLogProcessing(java.lang.String significantLogProcessing) {
        this.significantLogProcessing = significantLogProcessing;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBClientLogConfiguration;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("enable_significant_log_collection",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enableSignificantLogCollection, this._getType().getField("enable_significant_log_collection")));
        structValue.setField("filtered_log_processing",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.filteredLogProcessing, this._getType().getField("filtered_log_processing")));
        structValue.setField("non_significant_log_processing",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nonSignificantLogProcessing, this._getType().getField("non_significant_log_processing")));
        structValue.setField("significant_log_processing",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.significantLogProcessing, this._getType().getField("significant_log_processing")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBClientLogConfiguration;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.ALBClientLogConfiguration.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBClientLogConfiguration _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBClientLogConfiguration(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBClientLogConfiguration _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBClientLogConfiguration(structValue);
    }

    /**
     * Builder class for {@link ALBClientLogConfiguration}.
     */
    public static final class Builder {
        private java.lang.Boolean enableSignificantLogCollection;
        private java.lang.String filteredLogProcessing;
        private java.lang.String nonSignificantLogProcessing;
        private java.lang.String significantLogProcessing;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBClientLogConfiguration}.
         */
        public Builder() {
        }

        /**
         * Enable significant log collection. By default, this flag is enabled, which means
         * that Avi SEs collect significant logs and forward them to Controller for further
         * processing. For example, these logs correspond to error conditions such as when
         * the response code for a request is 500. Users can deactivate this flag to turn
         * off default significant log collection. Allowed in Basic(Allowed values- false)
         * edition, Essentials(Allowed values- false) edition, Enterprise edition. Special
         * default for Basic edition is false, Essentials edition is false, Enterprise is
         * True. Default value when not specified in API or module is interpreted by ALB
         * Controller as false.
         *
         * @param enableSignificantLogCollection New value for the property.
         */
        public Builder setEnableSignificantLogCollection(java.lang.Boolean enableSignificantLogCollection) {
            this.enableSignificantLogCollection = enableSignificantLogCollection;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.ALBClientLogConfiguration#FILTERED_LOG_PROCESSING_NONE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.ALBClientLogConfiguration#FILTERED_LOG_PROCESSING_SYNC_AND_INDEX_ON_DEMAND}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.ALBClientLogConfiguration#FILTERED_LOG_PROCESSING_AUTO_SYNC_AND_INDEX}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.ALBClientLogConfiguration#FILTERED_LOG_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND}</li>
         * </ul> Filtered logs are logs that match any client log filters or rules with
         * logging enabled. Such logs are processed by the Logs Analytics system according
         * to this setting. Enum options - LOGS_PROCESSING_NONE,
         * LOGS_PROCESSING_SYNC_AND_INDEX_ON_DEMAND, LOGS_PROCESSING_AUTO_SYNC_AND_INDEX,
         * LOGS_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND. Default value when not specified
         * in API or module is interpreted by ALB Controller as
         * LOGS_PROCESSING_SYNC_AND_INDEX_ON_DEMAND.
         *
         * @param filteredLogProcessing New value for the property.
         */
        public Builder setFilteredLogProcessing(java.lang.String filteredLogProcessing) {
            this.filteredLogProcessing = filteredLogProcessing;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.ALBClientLogConfiguration#NON_SIGNIFICANT_LOG_PROCESSING_NONE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.ALBClientLogConfiguration#NON_SIGNIFICANT_LOG_PROCESSING_SYNC_AND_INDEX_ON_DEMAND}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.ALBClientLogConfiguration#NON_SIGNIFICANT_LOG_PROCESSING_AUTO_SYNC_AND_INDEX}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.ALBClientLogConfiguration#NON_SIGNIFICANT_LOG_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND}</li>
         * </ul> Logs that are neither significant nor filtered, are processed by the Logs
         * Analytics system according to this setting. Enum options - LOGS_PROCESSING_NONE,
         * LOGS_PROCESSING_SYNC_AND_INDEX_ON_DEMAND, LOGS_PROCESSING_AUTO_SYNC_AND_INDEX,
         * LOGS_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND. Default value when not specified
         * in API or module is interpreted by ALB Controller as
         * LOGS_PROCESSING_SYNC_AND_INDEX_ON_DEMAND.
         *
         * @param nonSignificantLogProcessing New value for the property.
         */
        public Builder setNonSignificantLogProcessing(java.lang.String nonSignificantLogProcessing) {
            this.nonSignificantLogProcessing = nonSignificantLogProcessing;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.ALBClientLogConfiguration#SIGNIFICANT_LOG_PROCESSING_NONE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.ALBClientLogConfiguration#SIGNIFICANT_LOG_PROCESSING_SYNC_AND_INDEX_ON_DEMAND}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.ALBClientLogConfiguration#SIGNIFICANT_LOG_PROCESSING_AUTO_SYNC_AND_INDEX}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.ALBClientLogConfiguration#SIGNIFICANT_LOG_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND}</li>
         * </ul> Significant logs are processed by the Logs Analytics system according to
         * this setting. Enum options - LOGS_PROCESSING_NONE,
         * LOGS_PROCESSING_SYNC_AND_INDEX_ON_DEMAND, LOGS_PROCESSING_AUTO_SYNC_AND_INDEX,
         * LOGS_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND. Default value when not specified
         * in API or module is interpreted by ALB Controller as
         * LOGS_PROCESSING_SYNC_AND_INDEX_ON_DEMAND.
         *
         * @param significantLogProcessing New value for the property.
         */
        public Builder setSignificantLogProcessing(java.lang.String significantLogProcessing) {
            this.significantLogProcessing = significantLogProcessing;
            return this;
        }

        public ALBClientLogConfiguration build() {
            ALBClientLogConfiguration result = new ALBClientLogConfiguration();
            result.setEnableSignificantLogCollection(this.enableSignificantLogCollection);
            result.setFilteredLogProcessing(this.filteredLogProcessing);
            result.setNonSignificantLogProcessing(this.nonSignificantLogProcessing);
            result.setSignificantLogProcessing(this.significantLogProcessing);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("enable_significant_log_collection", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enable_significant_log_collection",
                                                                                "enableSignificantLogCollection",
                                                                                "getEnableSignificantLogCollection",
                                                                                "setEnableSignificantLogCollection");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("filtered_log_processing", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("filtered_log_processing",
                                                                                "filteredLogProcessing",
                                                                                "getFilteredLogProcessing",
                                                                                "setFilteredLogProcessing");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("non_significant_log_processing", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("non_significant_log_processing",
                                                                                "nonSignificantLogProcessing",
                                                                                "getNonSignificantLogProcessing",
                                                                                "setNonSignificantLogProcessing");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("significant_log_processing", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("significant_log_processing",
                                                                                "significantLogProcessing",
                                                                                "getSignificantLogProcessing",
                                                                                "setSignificantLogProcessing");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.ALB_client_log_configuration",
                                                            fields,
                                                            com.vmware.nsx_policy.model.ALBClientLogConfiguration.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

