/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Advanced load balancer ClientLogStreamingConfig object
 */
public final class ALBClientLogStreamingConfig implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String LOG_TYPES_TO_SEND_SIGNIFICANT_ONLY = "LOGS_SIGNIFICANT_ONLY";

    public static final java.lang.String LOG_TYPES_TO_SEND_UDF_ONLY = "LOGS_UDF_ONLY";

    public static final java.lang.String LOG_TYPES_TO_SEND_UDF_SIGNIFICANT = "LOGS_UDF_SIGNIFICANT";

    public static final java.lang.String LOG_TYPES_TO_SEND_ALL = "LOGS_ALL";

    public static final java.lang.String PROTOCOL_UDP = "LOG_STREAMING_PROTOCOL_UDP";

    public static final java.lang.String PROTOCOL_SYSLOG_OVER_UDP = "LOG_STREAMING_PROTOCOL_SYSLOG_OVER_UDP";

    public static final java.lang.String PROTOCOL_TCP = "LOG_STREAMING_PROTOCOL_TCP";

    public static final java.lang.String PROTOCOL_SYSLOG_OVER_TCP = "LOG_STREAMING_PROTOCOL_SYSLOG_OVER_TCP";

    public static final java.lang.String PROTOCOL_RAW_OVER_UDP = "LOG_STREAMING_PROTOCOL_RAW_OVER_UDP";

    public static final java.lang.String PROTOCOL_TLS = "LOG_STREAMING_PROTOCOL_TLS";

    public static final java.lang.String PROTOCOL_SYSLOG_OVER_TLS = "LOG_STREAMING_PROTOCOL_SYSLOG_OVER_TLS";

    private java.lang.String externalServer;

    private java.lang.Long externalServerPort;

    private com.vmware.nsx_policy.model.ALBClientLogStreamingFormat formatConfig;

    private java.lang.String logTypesToSend;

    private java.lang.Long maxLogsPerSecond;

    private java.lang.String protocol;

    private com.vmware.nsx_policy.model.ALBStreamingSyslogConfig syslogConfig;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBClientLogStreamingConfig() {
    }

    protected ALBClientLogStreamingConfig(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * IP address or hostnames (FQDNs) of destination servers. If an FQDN is provided,
     * this should be resolvable on Avi Service Engines. Multiple servers are supported
     * by furnishing a comma-separated list of IP addresses or host names, for example,
     * 11.11.11.11,23.12.12.4. Optionally, a separate port can be specified for each
     * external server in the list, for example, 11.11.11.11 234,12.12.12.12 343.
     *
     * @return The current value of the property.
     */
    public java.lang.String getExternalServer() {
        return this.externalServer;
    }

    /**
     * IP address or hostnames (FQDNs) of destination servers. If an FQDN is provided,
     * this should be resolvable on Avi Service Engines. Multiple servers are supported
     * by furnishing a comma-separated list of IP addresses or host names, for example,
     * 11.11.11.11,23.12.12.4. Optionally, a separate port can be specified for each
     * external server in the list, for example, 11.11.11.11 234,12.12.12.12 343.
     *
     * @param externalServer New value for the property.
     */
    public void setExternalServer(java.lang.String externalServer) {
        this.externalServer = externalServer;
    }

    /**
     * The service port to use for the external servers. If multiple external servers
     * have been specified, the single port number specified here will apply to all
     * those servers for which an explicit port number has not been specified in the
     * external server list. Default value when not specified in API or module is
     * interpreted by ALB Controller as 514. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getExternalServerPort() {
        return this.externalServerPort;
    }

    /**
     * The service port to use for the external servers. If multiple external servers
     * have been specified, the single port number specified here will apply to all
     * those servers for which an explicit port number has not been specified in the
     * external server list. Default value when not specified in API or module is
     * interpreted by ALB Controller as 514. format: int64
     *
     * @param externalServerPort New value for the property.
     */
    public void setExternalServerPort(java.lang.Long externalServerPort) {
        this.externalServerPort = externalServerPort;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.ALBClientLogStreamingFormat getFormatConfig() {
        return this.formatConfig;
    }

    /**
     *
     *
     * @param formatConfig New value for the property.
     */
    public void setFormatConfig(com.vmware.nsx_policy.model.ALBClientLogStreamingFormat formatConfig) {
        this.formatConfig = formatConfig;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogStreamingConfig#LOG_TYPES_TO_SEND_SIGNIFICANT_ONLY}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogStreamingConfig#LOG_TYPES_TO_SEND_UDF_ONLY}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogStreamingConfig#LOG_TYPES_TO_SEND_UDF_SIGNIFICANT}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogStreamingConfig#LOG_TYPES_TO_SEND_ALL}</li>
     * </ul> Type of logs to stream to the external server. Default is LOGS_ALL, i.e.,
     * send all logs. Enum options - LOGS_SIGNIFICANT_ONLY, LOGS_UDF_ONLY,
     * LOGS_UDF_SIGNIFICANT, LOGS_ALL. Default value when not specified in API or
     * module is interpreted by ALB Controller as LOGS_ALL.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLogTypesToSend() {
        return this.logTypesToSend;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogStreamingConfig#LOG_TYPES_TO_SEND_SIGNIFICANT_ONLY}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogStreamingConfig#LOG_TYPES_TO_SEND_UDF_ONLY}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogStreamingConfig#LOG_TYPES_TO_SEND_UDF_SIGNIFICANT}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogStreamingConfig#LOG_TYPES_TO_SEND_ALL}</li>
     * </ul> Type of logs to stream to the external server. Default is LOGS_ALL, i.e.,
     * send all logs. Enum options - LOGS_SIGNIFICANT_ONLY, LOGS_UDF_ONLY,
     * LOGS_UDF_SIGNIFICANT, LOGS_ALL. Default value when not specified in API or
     * module is interpreted by ALB Controller as LOGS_ALL.
     *
     * @param logTypesToSend New value for the property.
     */
    public void setLogTypesToSend(java.lang.String logTypesToSend) {
        this.logTypesToSend = logTypesToSend;
    }

    /**
     * Maximum number of logs per second streamed to the remote server. By default, 100
     * logs per second are streamed. Set this to zero(0) to not enforce any limit.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as 100. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMaxLogsPerSecond() {
        return this.maxLogsPerSecond;
    }

    /**
     * Maximum number of logs per second streamed to the remote server. By default, 100
     * logs per second are streamed. Set this to zero(0) to not enforce any limit.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as 100. format: int64
     *
     * @param maxLogsPerSecond New value for the property.
     */
    public void setMaxLogsPerSecond(java.lang.Long maxLogsPerSecond) {
        this.maxLogsPerSecond = maxLogsPerSecond;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogStreamingConfig#PROTOCOL_UDP}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.ALBClientLogStreamingConfig#PROTOCOL_SYSLOG_OVER_UDP}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogStreamingConfig#PROTOCOL_TCP}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.ALBClientLogStreamingConfig#PROTOCOL_SYSLOG_OVER_TCP}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogStreamingConfig#PROTOCOL_RAW_OVER_UDP}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogStreamingConfig#PROTOCOL_TLS}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.ALBClientLogStreamingConfig#PROTOCOL_SYSLOG_OVER_TLS}</li>
     * </ul> Protocol to use for streaming logs. Enum options -
     * LOG_STREAMING_PROTOCOL_UDP, LOG_STREAMING_PROTOCOL_SYSLOG_OVER_UDP,
     * LOG_STREAMING_PROTOCOL_TCP, LOG_STREAMING_PROTOCOL_SYSLOG_OVER_TCP,
     * LOG_STREAMING_PROTOCOL_RAW_OVER_UDP, LOG_STREAMING_PROTOCOL_TLS,
     * LOG_STREAMING_PROTOCOL_SYSLOG_OVER_TLS. Default value when not specified in API
     * or module is interpreted by ALB Controller as LOG_STREAMING_PROTOCOL_UDP.
     *
     * @return The current value of the property.
     */
    public java.lang.String getProtocol() {
        return this.protocol;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogStreamingConfig#PROTOCOL_UDP}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.ALBClientLogStreamingConfig#PROTOCOL_SYSLOG_OVER_UDP}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogStreamingConfig#PROTOCOL_TCP}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.ALBClientLogStreamingConfig#PROTOCOL_SYSLOG_OVER_TCP}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogStreamingConfig#PROTOCOL_RAW_OVER_UDP}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBClientLogStreamingConfig#PROTOCOL_TLS}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.ALBClientLogStreamingConfig#PROTOCOL_SYSLOG_OVER_TLS}</li>
     * </ul> Protocol to use for streaming logs. Enum options -
     * LOG_STREAMING_PROTOCOL_UDP, LOG_STREAMING_PROTOCOL_SYSLOG_OVER_UDP,
     * LOG_STREAMING_PROTOCOL_TCP, LOG_STREAMING_PROTOCOL_SYSLOG_OVER_TCP,
     * LOG_STREAMING_PROTOCOL_RAW_OVER_UDP, LOG_STREAMING_PROTOCOL_TLS,
     * LOG_STREAMING_PROTOCOL_SYSLOG_OVER_TLS. Default value when not specified in API
     * or module is interpreted by ALB Controller as LOG_STREAMING_PROTOCOL_UDP.
     *
     * @param protocol New value for the property.
     */
    public void setProtocol(java.lang.String protocol) {
        this.protocol = protocol;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.ALBStreamingSyslogConfig getSyslogConfig() {
        return this.syslogConfig;
    }

    /**
     *
     *
     * @param syslogConfig New value for the property.
     */
    public void setSyslogConfig(com.vmware.nsx_policy.model.ALBStreamingSyslogConfig syslogConfig) {
        this.syslogConfig = syslogConfig;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBClientLogStreamingConfig;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("external_server",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.externalServer, this._getType().getField("external_server")));
        structValue.setField("external_server_port",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.externalServerPort, this._getType().getField("external_server_port")));
        structValue.setField("format_config",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.formatConfig, this._getType().getField("format_config")));
        structValue.setField("log_types_to_send",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.logTypesToSend, this._getType().getField("log_types_to_send")));
        structValue.setField("max_logs_per_second",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxLogsPerSecond, this._getType().getField("max_logs_per_second")));
        structValue.setField("protocol",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.protocol, this._getType().getField("protocol")));
        structValue.setField("syslog_config",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.syslogConfig, this._getType().getField("syslog_config")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBClientLogStreamingConfig;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.ALBClientLogStreamingConfig.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBClientLogStreamingConfig _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBClientLogStreamingConfig(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBClientLogStreamingConfig _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBClientLogStreamingConfig(structValue);
    }

    /**
     * Builder class for {@link ALBClientLogStreamingConfig}.
     */
    public static final class Builder {
        private java.lang.String externalServer;
        private java.lang.Long externalServerPort;
        private com.vmware.nsx_policy.model.ALBClientLogStreamingFormat formatConfig;
        private java.lang.String logTypesToSend;
        private java.lang.Long maxLogsPerSecond;
        private java.lang.String protocol;
        private com.vmware.nsx_policy.model.ALBStreamingSyslogConfig syslogConfig;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBClientLogStreamingConfig}.
         */
        public Builder() {
        }

        /**
         * IP address or hostnames (FQDNs) of destination servers. If an FQDN is provided,
         * this should be resolvable on Avi Service Engines. Multiple servers are supported
         * by furnishing a comma-separated list of IP addresses or host names, for example,
         * 11.11.11.11,23.12.12.4. Optionally, a separate port can be specified for each
         * external server in the list, for example, 11.11.11.11 234,12.12.12.12 343.
         *
         * @param externalServer New value for the property.
         */
        public Builder setExternalServer(java.lang.String externalServer) {
            this.externalServer = externalServer;
            return this;
        }

        /**
         * The service port to use for the external servers. If multiple external servers
         * have been specified, the single port number specified here will apply to all
         * those servers for which an explicit port number has not been specified in the
         * external server list. Default value when not specified in API or module is
         * interpreted by ALB Controller as 514. format: int64
         *
         * @param externalServerPort New value for the property.
         */
        public Builder setExternalServerPort(java.lang.Long externalServerPort) {
            this.externalServerPort = externalServerPort;
            return this;
        }

        /**
         *
         *
         * @param formatConfig New value for the property.
         */
        public Builder setFormatConfig(com.vmware.nsx_policy.model.ALBClientLogStreamingFormat formatConfig) {
            this.formatConfig = formatConfig;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.ALBClientLogStreamingConfig#LOG_TYPES_TO_SEND_SIGNIFICANT_ONLY}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.ALBClientLogStreamingConfig#LOG_TYPES_TO_SEND_UDF_ONLY}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.ALBClientLogStreamingConfig#LOG_TYPES_TO_SEND_UDF_SIGNIFICANT}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.ALBClientLogStreamingConfig#LOG_TYPES_TO_SEND_ALL}</li>
         * </ul> Type of logs to stream to the external server. Default is LOGS_ALL, i.e.,
         * send all logs. Enum options - LOGS_SIGNIFICANT_ONLY, LOGS_UDF_ONLY,
         * LOGS_UDF_SIGNIFICANT, LOGS_ALL. Default value when not specified in API or
         * module is interpreted by ALB Controller as LOGS_ALL.
         *
         * @param logTypesToSend New value for the property.
         */
        public Builder setLogTypesToSend(java.lang.String logTypesToSend) {
            this.logTypesToSend = logTypesToSend;
            return this;
        }

        /**
         * Maximum number of logs per second streamed to the remote server. By default, 100
         * logs per second are streamed. Set this to zero(0) to not enforce any limit.
         * Default value when not specified in API or module is interpreted by ALB
         * Controller as 100. format: int64
         *
         * @param maxLogsPerSecond New value for the property.
         */
        public Builder setMaxLogsPerSecond(java.lang.Long maxLogsPerSecond) {
            this.maxLogsPerSecond = maxLogsPerSecond;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.ALBClientLogStreamingConfig#PROTOCOL_UDP}</li> <li>
         * {@link
         * com.vmware.nsx_policy.model.ALBClientLogStreamingConfig#PROTOCOL_SYSLOG_OVER_UDP}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.ALBClientLogStreamingConfig#PROTOCOL_TCP}</li> <li>
         * {@link
         * com.vmware.nsx_policy.model.ALBClientLogStreamingConfig#PROTOCOL_SYSLOG_OVER_TCP}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.ALBClientLogStreamingConfig#PROTOCOL_RAW_OVER_UDP}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.ALBClientLogStreamingConfig#PROTOCOL_TLS}</li> <li>
         * {@link
         * com.vmware.nsx_policy.model.ALBClientLogStreamingConfig#PROTOCOL_SYSLOG_OVER_TLS}</li>
         * </ul> Protocol to use for streaming logs. Enum options -
         * LOG_STREAMING_PROTOCOL_UDP, LOG_STREAMING_PROTOCOL_SYSLOG_OVER_UDP,
         * LOG_STREAMING_PROTOCOL_TCP, LOG_STREAMING_PROTOCOL_SYSLOG_OVER_TCP,
         * LOG_STREAMING_PROTOCOL_RAW_OVER_UDP, LOG_STREAMING_PROTOCOL_TLS,
         * LOG_STREAMING_PROTOCOL_SYSLOG_OVER_TLS. Default value when not specified in API
         * or module is interpreted by ALB Controller as LOG_STREAMING_PROTOCOL_UDP.
         *
         * @param protocol New value for the property.
         */
        public Builder setProtocol(java.lang.String protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         *
         *
         * @param syslogConfig New value for the property.
         */
        public Builder setSyslogConfig(com.vmware.nsx_policy.model.ALBStreamingSyslogConfig syslogConfig) {
            this.syslogConfig = syslogConfig;
            return this;
        }

        public ALBClientLogStreamingConfig build() {
            ALBClientLogStreamingConfig result = new ALBClientLogStreamingConfig();
            result.setExternalServer(this.externalServer);
            result.setExternalServerPort(this.externalServerPort);
            result.setFormatConfig(this.formatConfig);
            result.setLogTypesToSend(this.logTypesToSend);
            result.setMaxLogsPerSecond(this.maxLogsPerSecond);
            result.setProtocol(this.protocol);
            result.setSyslogConfig(this.syslogConfig);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("external_server", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("external_server",
                                                                                "externalServer",
                                                                                "getExternalServer",
                                                                                "setExternalServer");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("external_server_port", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("external_server_port",
                                                                                "externalServerPort",
                                                                                "getExternalServerPort",
                                                                                "setExternalServerPort");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("format_config", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.ALBClientLogStreamingFormat; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("format_config",
                                                                                "formatConfig",
                                                                                "getFormatConfig",
                                                                                "setFormatConfig");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("log_types_to_send", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("log_types_to_send",
                                                                                "logTypesToSend",
                                                                                "getLogTypesToSend",
                                                                                "setLogTypesToSend");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max_logs_per_second", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_logs_per_second",
                                                                                "maxLogsPerSecond",
                                                                                "getMaxLogsPerSecond",
                                                                                "setMaxLogsPerSecond");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("protocol", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("protocol",
                                                                                "protocol",
                                                                                "getProtocol",
                                                                                "setProtocol");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("syslog_config", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.ALBStreamingSyslogConfig; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("syslog_config",
                                                                                "syslogConfig",
                                                                                "getSyslogConfig",
                                                                                "setSyslogConfig");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.ALB_client_log_streaming_config",
                                                            fields,
                                                            com.vmware.nsx_policy.model.ALBClientLogStreamingConfig.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

