/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Alb Controller config details
 */
public final class ALBControllerConfiguration implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String OWNED_BY_LCM = "LCM";

    public static final java.lang.String OWNED_BY_VCF = "VCF";

    private java.lang.String clusterIp;

    private java.util.List<java.lang.String> dnsServers;

    private java.lang.String infraAdminPassword;

    private java.lang.String infraAdminUsername;

    private java.util.List<java.lang.String> ntpServers;

    private java.lang.String ownedBy;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBControllerConfiguration() {
    }

    protected ALBControllerConfiguration(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The cluster IP of the Advanced Load Balancer controller node cluster. This is
     * mandatory parameter and required for single node controller deployments as well.
     * format: ip
     *
     * @return The current value of the property.
     */
    public java.lang.String getClusterIp() {
        return this.clusterIp;
    }

    /**
     * The cluster IP of the Advanced Load Balancer controller node cluster. This is
     * mandatory parameter and required for single node controller deployments as well.
     * format: ip
     *
     * @param clusterIp New value for the property.
     */
    public void setClusterIp(java.lang.String clusterIp) {
        this.clusterIp = clusterIp;
    }

    /**
     * List of DNS servers. format: ipv4
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getDnsServers() {
        return this.dnsServers;
    }

    /**
     * List of DNS servers. format: ipv4
     *
     * @param dnsServers New value for the property.
     */
    public void setDnsServers(java.util.List<java.lang.String> dnsServers) {
        this.dnsServers = dnsServers;
    }

    /**
     * Password for the controller node admin user. For deployment, this property is
     * required. The password specified must be at least 8 characters in length.
     *
     * @return The current value of the property.
     */
    public java.lang.String getInfraAdminPassword() {
        return this.infraAdminPassword;
    }

    /**
     * Password for the controller node admin user. For deployment, this property is
     * required. The password specified must be at least 8 characters in length.
     *
     * @param infraAdminPassword New value for the property.
     */
    public void setInfraAdminPassword(java.lang.String infraAdminPassword) {
        this.infraAdminPassword = infraAdminPassword;
    }

    /**
     * Username for server authentication.
     *
     * @return The current value of the property.
     */
    public java.lang.String getInfraAdminUsername() {
        return this.infraAdminUsername;
    }

    /**
     * Username for server authentication.
     *
     * @param infraAdminUsername New value for the property.
     */
    public void setInfraAdminUsername(java.lang.String infraAdminUsername) {
        this.infraAdminUsername = infraAdminUsername;
    }

    /**
     * List of NTP servers. format: hostname-or-ipv4
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getNtpServers() {
        return this.ntpServers;
    }

    /**
     * List of NTP servers. format: hostname-or-ipv4
     *
     * @param ntpServers New value for the property.
     */
    public void setNtpServers(java.util.List<java.lang.String> ntpServers) {
        this.ntpServers = ntpServers;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBControllerConfiguration#OWNED_BY_LCM}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBControllerConfiguration#OWNED_BY_VCF}</li>
     * </ul> The policy initiates workflow by LCM/VCF
     *
     * @return The current value of the property.
     */
    public java.lang.String getOwnedBy() {
        return this.ownedBy;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBControllerConfiguration#OWNED_BY_LCM}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBControllerConfiguration#OWNED_BY_VCF}</li>
     * </ul> The policy initiates workflow by LCM/VCF
     *
     * @param ownedBy New value for the property.
     */
    public void setOwnedBy(java.lang.String ownedBy) {
        this.ownedBy = ownedBy;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBControllerConfiguration;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("cluster_ip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clusterIp, this._getType().getField("cluster_ip")));
        structValue.setField("dns_servers",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dnsServers, this._getType().getField("dns_servers")));
        structValue.setField("infra_admin_password",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.infraAdminPassword, this._getType().getField("infra_admin_password")));
        structValue.setField("infra_admin_username",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.infraAdminUsername, this._getType().getField("infra_admin_username")));
        structValue.setField("ntp_servers",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ntpServers, this._getType().getField("ntp_servers")));
        structValue.setField("owned_by",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ownedBy, this._getType().getField("owned_by")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBControllerConfiguration;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.ALBControllerConfiguration.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBControllerConfiguration _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBControllerConfiguration(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBControllerConfiguration _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBControllerConfiguration(structValue);
    }

    /**
     * Builder class for {@link ALBControllerConfiguration}.
     */
    public static final class Builder {
        private java.lang.String clusterIp;
        private java.util.List<java.lang.String> dnsServers;
        private java.lang.String infraAdminPassword;
        private java.lang.String infraAdminUsername;
        private java.util.List<java.lang.String> ntpServers;
        private java.lang.String ownedBy;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBControllerConfiguration}.
         */
        public Builder() {
        }

        /**
         * The cluster IP of the Advanced Load Balancer controller node cluster. This is
         * mandatory parameter and required for single node controller deployments as well.
         * format: ip
         *
         * @param clusterIp New value for the property.
         */
        public Builder setClusterIp(java.lang.String clusterIp) {
            this.clusterIp = clusterIp;
            return this;
        }

        /**
         * List of DNS servers. format: ipv4
         *
         * @param dnsServers New value for the property.
         */
        public Builder setDnsServers(java.util.List<java.lang.String> dnsServers) {
            this.dnsServers = dnsServers;
            return this;
        }

        /**
         * Password for the controller node admin user. For deployment, this property is
         * required. The password specified must be at least 8 characters in length.
         *
         * @param infraAdminPassword New value for the property.
         */
        public Builder setInfraAdminPassword(java.lang.String infraAdminPassword) {
            this.infraAdminPassword = infraAdminPassword;
            return this;
        }

        /**
         * Username for server authentication.
         *
         * @param infraAdminUsername New value for the property.
         */
        public Builder setInfraAdminUsername(java.lang.String infraAdminUsername) {
            this.infraAdminUsername = infraAdminUsername;
            return this;
        }

        /**
         * List of NTP servers. format: hostname-or-ipv4
         *
         * @param ntpServers New value for the property.
         */
        public Builder setNtpServers(java.util.List<java.lang.String> ntpServers) {
            this.ntpServers = ntpServers;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.ALBControllerConfiguration#OWNED_BY_LCM}</li> <li>
         * {@link com.vmware.nsx_policy.model.ALBControllerConfiguration#OWNED_BY_VCF}</li>
         * </ul> The policy initiates workflow by LCM/VCF
         *
         * @param ownedBy New value for the property.
         */
        public Builder setOwnedBy(java.lang.String ownedBy) {
            this.ownedBy = ownedBy;
            return this;
        }

        public ALBControllerConfiguration build() {
            ALBControllerConfiguration result = new ALBControllerConfiguration();
            result.setClusterIp(this.clusterIp);
            result.setDnsServers(this.dnsServers);
            result.setInfraAdminPassword(this.infraAdminPassword);
            result.setInfraAdminUsername(this.infraAdminUsername);
            result.setNtpServers(this.ntpServers);
            result.setOwnedBy(this.ownedBy);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("cluster_ip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("cluster_ip",
                                                                                "clusterIp",
                                                                                "getClusterIp",
                                                                                "setClusterIp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("dns_servers", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dns_servers",
                                                                                "dnsServers",
                                                                                "getDnsServers",
                                                                                "setDnsServers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("infra_admin_password", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("infra_admin_password",
                                                                                "infraAdminPassword",
                                                                                "getInfraAdminPassword",
                                                                                "setInfraAdminPassword");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("infra_admin_username", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("infra_admin_username",
                                                                                "infraAdminUsername",
                                                                                "getInfraAdminUsername",
                                                                                "setInfraAdminUsername");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ntp_servers", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ntp_servers",
                                                                                "ntpServers",
                                                                                "getNtpServers",
                                                                                "setNtpServers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("owned_by", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("owned_by",
                                                                                "ownedBy",
                                                                                "getOwnedBy",
                                                                                "setOwnedBy");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.ALB_controller_configuration",
                                                            fields,
                                                            com.vmware.nsx_policy.model.ALBControllerConfiguration.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

