/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Advanced Load Balancer controller node information like node IP and node name.
 */
public final class ALBControllerNodeInfo implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Boolean isDhcp;

    private java.lang.String nodeIp;

    private java.lang.String nodeName;

    private java.lang.String nodeRole;

    private java.lang.Long nodeStartTime;

    private java.lang.String nodeState;

    private java.lang.String vmId;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBControllerNodeInfo() {
    }

    protected ALBControllerNodeInfo(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Advanced Load Balancer controller node IP configuration is static or DHCP.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getIsDhcp() {
        return this.isDhcp;
    }

    /**
     * Advanced Load Balancer controller node IP configuration is static or DHCP.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param isDhcp New value for the property.
     */
    public void setIsDhcp(java.lang.Boolean isDhcp) {
        this.isDhcp = isDhcp;
    }

    /**
     * Advanced Load Balancer controller node IP. format: ip
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getNodeIp() {
        return this.nodeIp;
    }

    /**
     * Advanced Load Balancer controller node IP. format: ip
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param nodeIp New value for the property.
     */
    public void setNodeIp(java.lang.String nodeIp) {
        this.nodeIp = nodeIp;
    }

    /**
     * Advanced Load Balancer controller node name.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getNodeName() {
        return this.nodeName;
    }

    /**
     * Advanced Load Balancer controller node name.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param nodeName New value for the property.
     */
    public void setNodeName(java.lang.String nodeName) {
        this.nodeName = nodeName;
    }

    /**
     * Advanced Load Balancer controller node role in cluster.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getNodeRole() {
        return this.nodeRole;
    }

    /**
     * Advanced Load Balancer controller node role in cluster.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param nodeRole New value for the property.
     */
    public void setNodeRole(java.lang.String nodeRole) {
        this.nodeRole = nodeRole;
    }

    /**
     * Advanced Load Balancer controller node start time in its local timezone. format:
     * int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getNodeStartTime() {
        return this.nodeStartTime;
    }

    /**
     * Advanced Load Balancer controller node start time in its local timezone. format:
     * int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param nodeStartTime New value for the property.
     */
    public void setNodeStartTime(java.lang.Long nodeStartTime) {
        this.nodeStartTime = nodeStartTime;
    }

    /**
     * Advanced Load Balancer controller node current state in the cluster.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getNodeState() {
        return this.nodeState;
    }

    /**
     * Advanced Load Balancer controller node current state in the cluster.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param nodeState New value for the property.
     */
    public void setNodeState(java.lang.String nodeState) {
        this.nodeState = nodeState;
    }

    /**
     * ID of the VM maintained internally. Note: This is automatically generated and
     * cannot be modified.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getVmId() {
        return this.vmId;
    }

    /**
     * ID of the VM maintained internally. Note: This is automatically generated and
     * cannot be modified.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param vmId New value for the property.
     */
    public void setVmId(java.lang.String vmId) {
        this.vmId = vmId;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBControllerNodeInfo;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("is_dhcp",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.isDhcp, this._getType().getField("is_dhcp")));
        structValue.setField("node_ip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nodeIp, this._getType().getField("node_ip")));
        structValue.setField("node_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nodeName, this._getType().getField("node_name")));
        structValue.setField("node_role",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nodeRole, this._getType().getField("node_role")));
        structValue.setField("node_start_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nodeStartTime, this._getType().getField("node_start_time")));
        structValue.setField("node_state",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nodeState, this._getType().getField("node_state")));
        structValue.setField("vm_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vmId, this._getType().getField("vm_id")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBControllerNodeInfo;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.ALBControllerNodeInfo.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBControllerNodeInfo _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBControllerNodeInfo(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBControllerNodeInfo _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBControllerNodeInfo(structValue);
    }

    /**
     * Builder class for {@link ALBControllerNodeInfo}.
     */
    public static final class Builder {
        private java.lang.Boolean isDhcp;
        private java.lang.String nodeIp;
        private java.lang.String nodeName;
        private java.lang.String nodeRole;
        private java.lang.Long nodeStartTime;
        private java.lang.String nodeState;
        private java.lang.String vmId;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBControllerNodeInfo}.
         */
        public Builder() {
        }

        /**
         * Advanced Load Balancer controller node IP configuration is static or DHCP.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param isDhcp New value for the property.
         */
        public Builder setIsDhcp(java.lang.Boolean isDhcp) {
            this.isDhcp = isDhcp;
            return this;
        }

        /**
         * Advanced Load Balancer controller node IP. format: ip
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param nodeIp New value for the property.
         */
        public Builder setNodeIp(java.lang.String nodeIp) {
            this.nodeIp = nodeIp;
            return this;
        }

        /**
         * Advanced Load Balancer controller node name.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param nodeName New value for the property.
         */
        public Builder setNodeName(java.lang.String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        /**
         * Advanced Load Balancer controller node role in cluster.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param nodeRole New value for the property.
         */
        public Builder setNodeRole(java.lang.String nodeRole) {
            this.nodeRole = nodeRole;
            return this;
        }

        /**
         * Advanced Load Balancer controller node start time in its local timezone. format:
         * int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param nodeStartTime New value for the property.
         */
        public Builder setNodeStartTime(java.lang.Long nodeStartTime) {
            this.nodeStartTime = nodeStartTime;
            return this;
        }

        /**
         * Advanced Load Balancer controller node current state in the cluster.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param nodeState New value for the property.
         */
        public Builder setNodeState(java.lang.String nodeState) {
            this.nodeState = nodeState;
            return this;
        }

        /**
         * ID of the VM maintained internally. Note: This is automatically generated and
         * cannot be modified.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param vmId New value for the property.
         */
        public Builder setVmId(java.lang.String vmId) {
            this.vmId = vmId;
            return this;
        }

        public ALBControllerNodeInfo build() {
            ALBControllerNodeInfo result = new ALBControllerNodeInfo();
            result.setIsDhcp(this.isDhcp);
            result.setNodeIp(this.nodeIp);
            result.setNodeName(this.nodeName);
            result.setNodeRole(this.nodeRole);
            result.setNodeStartTime(this.nodeStartTime);
            result.setNodeState(this.nodeState);
            result.setVmId(this.vmId);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("is_dhcp", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("is_dhcp",
                                                                                "isDhcp",
                                                                                "getIsDhcp",
                                                                                "setIsDhcp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("node_ip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("node_ip",
                                                                                "nodeIp",
                                                                                "getNodeIp",
                                                                                "setNodeIp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("node_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("node_name",
                                                                                "nodeName",
                                                                                "getNodeName",
                                                                                "setNodeName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("node_role", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("node_role",
                                                                                "nodeRole",
                                                                                "getNodeRole",
                                                                                "setNodeRole");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("node_start_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("node_start_time",
                                                                                "nodeStartTime",
                                                                                "getNodeStartTime",
                                                                                "setNodeStartTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("node_state", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("node_state",
                                                                                "nodeState",
                                                                                "getNodeState",
                                                                                "setNodeState");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vm_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vm_id",
                                                                                "vmId",
                                                                                "getVmId",
                                                                                "setVmId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.ALB_controller_node_info",
                                                            fields,
                                                            com.vmware.nsx_policy.model.ALBControllerNodeInfo.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

