/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Advanced load balancer DnsRuleActionGslbSiteSelection object
 */
public final class ALBDnsRuleActionGslbSiteSelection implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.util.List<java.lang.String> fallbackSiteNames;

    private java.lang.Boolean isSitePreferred;

    private java.lang.String siteName;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBDnsRuleActionGslbSiteSelection() {
    }

    protected ALBDnsRuleActionGslbSiteSelection(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * GSLB fallback sites to use in case the desired site is down. Maximum of 64 items
     * allowed.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getFallbackSiteNames() {
        return this.fallbackSiteNames;
    }

    /**
     * GSLB fallback sites to use in case the desired site is down. Maximum of 64 items
     * allowed.
     *
     * @param fallbackSiteNames New value for the property.
     */
    public void setFallbackSiteNames(java.util.List<java.lang.String> fallbackSiteNames) {
        this.fallbackSiteNames = fallbackSiteNames;
    }

    /**
     * When set to true, GSLB site is a preferred site. This setting comes into play
     * when the site is down, as well as no configured fallback site is available (all
     * fallback sites are also down), then any one available site is selected based on
     * the default algorithm for GSLB pool member selection. Default value when not
     * specified in API or module is interpreted by ALB Controller as true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getIsSitePreferred() {
        return this.isSitePreferred;
    }

    /**
     * When set to true, GSLB site is a preferred site. This setting comes into play
     * when the site is down, as well as no configured fallback site is available (all
     * fallback sites are also down), then any one available site is selected based on
     * the default algorithm for GSLB pool member selection. Default value when not
     * specified in API or module is interpreted by ALB Controller as true.
     *
     * @param isSitePreferred New value for the property.
     */
    public void setIsSitePreferred(java.lang.Boolean isSitePreferred) {
        this.isSitePreferred = isSitePreferred;
    }

    /**
     * GSLB site name.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSiteName() {
        return this.siteName;
    }

    /**
     * GSLB site name.
     *
     * @param siteName New value for the property.
     */
    public void setSiteName(java.lang.String siteName) {
        this.siteName = siteName;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBDnsRuleActionGslbSiteSelection;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("fallback_site_names",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.fallbackSiteNames, this._getType().getField("fallback_site_names")));
        structValue.setField("is_site_preferred",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.isSitePreferred, this._getType().getField("is_site_preferred")));
        structValue.setField("site_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.siteName, this._getType().getField("site_name")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBDnsRuleActionGslbSiteSelection;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.ALBDnsRuleActionGslbSiteSelection.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBDnsRuleActionGslbSiteSelection _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBDnsRuleActionGslbSiteSelection(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBDnsRuleActionGslbSiteSelection _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBDnsRuleActionGslbSiteSelection(structValue);
    }

    /**
     * Builder class for {@link ALBDnsRuleActionGslbSiteSelection}.
     */
    public static final class Builder {
        private java.util.List<java.lang.String> fallbackSiteNames;
        private java.lang.Boolean isSitePreferred;
        private java.lang.String siteName;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBDnsRuleActionGslbSiteSelection}.
         */
        public Builder() {
        }

        /**
         * GSLB fallback sites to use in case the desired site is down. Maximum of 64 items
         * allowed.
         *
         * @param fallbackSiteNames New value for the property.
         */
        public Builder setFallbackSiteNames(java.util.List<java.lang.String> fallbackSiteNames) {
            this.fallbackSiteNames = fallbackSiteNames;
            return this;
        }

        /**
         * When set to true, GSLB site is a preferred site. This setting comes into play
         * when the site is down, as well as no configured fallback site is available (all
         * fallback sites are also down), then any one available site is selected based on
         * the default algorithm for GSLB pool member selection. Default value when not
         * specified in API or module is interpreted by ALB Controller as true.
         *
         * @param isSitePreferred New value for the property.
         */
        public Builder setIsSitePreferred(java.lang.Boolean isSitePreferred) {
            this.isSitePreferred = isSitePreferred;
            return this;
        }

        /**
         * GSLB site name.
         *
         * @param siteName New value for the property.
         */
        public Builder setSiteName(java.lang.String siteName) {
            this.siteName = siteName;
            return this;
        }

        public ALBDnsRuleActionGslbSiteSelection build() {
            ALBDnsRuleActionGslbSiteSelection result = new ALBDnsRuleActionGslbSiteSelection();
            result.setFallbackSiteNames(this.fallbackSiteNames);
            result.setIsSitePreferred(this.isSitePreferred);
            result.setSiteName(this.siteName);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("fallback_site_names", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("fallback_site_names",
                                                                                "fallbackSiteNames",
                                                                                "getFallbackSiteNames",
                                                                                "setFallbackSiteNames");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("is_site_preferred", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("is_site_preferred",
                                                                                "isSitePreferred",
                                                                                "getIsSitePreferred",
                                                                                "setIsSitePreferred");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("site_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("site_name",
                                                                                "siteName",
                                                                                "getSiteName",
                                                                                "setSiteName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.ALB_dns_rule_action_gslb_site_selection",
                                                            fields,
                                                            com.vmware.nsx_policy.model.ALBDnsRuleActionGslbSiteSelection.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

