/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Advanced load balancer DnsSrvRdata object
 */
public final class ALBDnsSrvRdata implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Long port;

    private java.lang.Long priority;

    private java.lang.String target;

    private java.lang.Long weight;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBDnsSrvRdata() {
    }

    protected ALBDnsSrvRdata(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Service port. Allowed values are 0-65535. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getPort() {
        return this.port;
    }

    /**
     * Service port. Allowed values are 0-65535. format: int64
     *
     * @param port New value for the property.
     */
    public void setPort(java.lang.Long port) {
        this.port = port;
    }

    /**
     * Priority of the target hosting the service, low value implies higher priority
     * for this service record. Allowed values are 0-65535. Default value when not
     * specified in API or module is interpreted by ALB Controller as 0. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getPriority() {
        return this.priority;
    }

    /**
     * Priority of the target hosting the service, low value implies higher priority
     * for this service record. Allowed values are 0-65535. Default value when not
     * specified in API or module is interpreted by ALB Controller as 0. format: int64
     *
     * @param priority New value for the property.
     */
    public void setPriority(java.lang.Long priority) {
        this.priority = priority;
    }

    /**
     * Canonical hostname, of the machine hosting the service, with no trailing period.
     * 'default.host' is valid but not 'default.host.'. Default value when not
     * specified in API or module is interpreted by ALB Controller as default.host.
     *
     * @return The current value of the property.
     */
    public java.lang.String getTarget() {
        return this.target;
    }

    /**
     * Canonical hostname, of the machine hosting the service, with no trailing period.
     * 'default.host' is valid but not 'default.host.'. Default value when not
     * specified in API or module is interpreted by ALB Controller as default.host.
     *
     * @param target New value for the property.
     */
    public void setTarget(java.lang.String target) {
        this.target = target;
    }

    /**
     * Relative weight for service records with same priority, high value implies
     * higher preference for this service record. Allowed values are 0-65535. Default
     * value when not specified in API or module is interpreted by ALB Controller as 0.
     * format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getWeight() {
        return this.weight;
    }

    /**
     * Relative weight for service records with same priority, high value implies
     * higher preference for this service record. Allowed values are 0-65535. Default
     * value when not specified in API or module is interpreted by ALB Controller as 0.
     * format: int64
     *
     * @param weight New value for the property.
     */
    public void setWeight(java.lang.Long weight) {
        this.weight = weight;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBDnsSrvRdata;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("port",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.port, this._getType().getField("port")));
        structValue.setField("priority",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.priority, this._getType().getField("priority")));
        structValue.setField("target",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.target, this._getType().getField("target")));
        structValue.setField("weight",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.weight, this._getType().getField("weight")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBDnsSrvRdata;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.ALBDnsSrvRdata.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBDnsSrvRdata _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBDnsSrvRdata(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBDnsSrvRdata _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBDnsSrvRdata(structValue);
    }

    /**
     * Builder class for {@link ALBDnsSrvRdata}.
     */
    public static final class Builder {
        private java.lang.Long port;
        private java.lang.Long priority;
        private java.lang.String target;
        private java.lang.Long weight;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBDnsSrvRdata}.
         */
        public Builder() {
        }

        /**
         * Service port. Allowed values are 0-65535. format: int64
         *
         * @param port New value for the property.
         */
        public Builder setPort(java.lang.Long port) {
            this.port = port;
            return this;
        }

        /**
         * Priority of the target hosting the service, low value implies higher priority
         * for this service record. Allowed values are 0-65535. Default value when not
         * specified in API or module is interpreted by ALB Controller as 0. format: int64
         *
         * @param priority New value for the property.
         */
        public Builder setPriority(java.lang.Long priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Canonical hostname, of the machine hosting the service, with no trailing period.
         * 'default.host' is valid but not 'default.host.'. Default value when not
         * specified in API or module is interpreted by ALB Controller as default.host.
         *
         * @param target New value for the property.
         */
        public Builder setTarget(java.lang.String target) {
            this.target = target;
            return this;
        }

        /**
         * Relative weight for service records with same priority, high value implies
         * higher preference for this service record. Allowed values are 0-65535. Default
         * value when not specified in API or module is interpreted by ALB Controller as 0.
         * format: int64
         *
         * @param weight New value for the property.
         */
        public Builder setWeight(java.lang.Long weight) {
            this.weight = weight;
            return this;
        }

        public ALBDnsSrvRdata build() {
            ALBDnsSrvRdata result = new ALBDnsSrvRdata();
            result.setPort(this.port);
            result.setPriority(this.priority);
            result.setTarget(this.target);
            result.setWeight(this.weight);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("port", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("port",
                                                                                "port",
                                                                                "getPort",
                                                                                "setPort");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("priority", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("priority",
                                                                                "priority",
                                                                                "getPriority",
                                                                                "setPriority");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("target", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("target",
                                                                                "target",
                                                                                "getTarget",
                                                                                "setTarget");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("weight", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("weight",
                                                                                "weight",
                                                                                "getWeight",
                                                                                "setWeight");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.ALB_dns_srv_rdata",
                                                            fields,
                                                            com.vmware.nsx_policy.model.ALBDnsSrvRdata.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

