/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Advanced load balancer DnsZone object
 */
public final class ALBDnsZone implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String adminEmail;

    private java.lang.String domainName;

    private java.lang.String nameServer;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBDnsZone() {
    }

    protected ALBDnsZone(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Email address of the administrator responsible for this zone. This field is used
     * in SOA records as rname (RFC 1035). If not configured, it is inherited from the
     * DNS service profile.
     *
     * @return The current value of the property.
     */
    public java.lang.String getAdminEmail() {
        return this.adminEmail;
    }

    /**
     * Email address of the administrator responsible for this zone. This field is used
     * in SOA records as rname (RFC 1035). If not configured, it is inherited from the
     * DNS service profile.
     *
     * @param adminEmail New value for the property.
     */
    public void setAdminEmail(java.lang.String adminEmail) {
        this.adminEmail = adminEmail;
    }

    /**
     * Domain name authoritatively serviced by this Virtual Service. Queries for FQDNs
     * that are sub domains of this domain and do not have any DNS record in Avi are
     * dropped or NXDomain response sent. For domains which are present, SOA parameters
     * are sent in answer section of response if query type is SOA.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDomainName() {
        return this.domainName;
    }

    /**
     * Domain name authoritatively serviced by this Virtual Service. Queries for FQDNs
     * that are sub domains of this domain and do not have any DNS record in Avi are
     * dropped or NXDomain response sent. For domains which are present, SOA parameters
     * are sent in answer section of response if query type is SOA.
     *
     * @param domainName New value for the property.
     */
    public void setDomainName(java.lang.String domainName) {
        this.domainName = domainName;
    }

    /**
     * The primary name server for this zone. This field is used in SOA records as
     * mname (RFC 1035). If not configured, it is inherited from the DNS service
     * profile. If even that is not configured, the domain name is used instead.
     *
     * @return The current value of the property.
     */
    public java.lang.String getNameServer() {
        return this.nameServer;
    }

    /**
     * The primary name server for this zone. This field is used in SOA records as
     * mname (RFC 1035). If not configured, it is inherited from the DNS service
     * profile. If even that is not configured, the domain name is used instead.
     *
     * @param nameServer New value for the property.
     */
    public void setNameServer(java.lang.String nameServer) {
        this.nameServer = nameServer;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBDnsZone;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("admin_email",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.adminEmail, this._getType().getField("admin_email")));
        structValue.setField("domain_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.domainName, this._getType().getField("domain_name")));
        structValue.setField("name_server",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nameServer, this._getType().getField("name_server")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBDnsZone;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.ALBDnsZone.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBDnsZone _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBDnsZone(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBDnsZone _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBDnsZone(structValue);
    }

    /**
     * Builder class for {@link ALBDnsZone}.
     */
    public static final class Builder {
        private java.lang.String adminEmail;
        private java.lang.String domainName;
        private java.lang.String nameServer;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBDnsZone}.
         */
        public Builder() {
        }

        /**
         * Email address of the administrator responsible for this zone. This field is used
         * in SOA records as rname (RFC 1035). If not configured, it is inherited from the
         * DNS service profile.
         *
         * @param adminEmail New value for the property.
         */
        public Builder setAdminEmail(java.lang.String adminEmail) {
            this.adminEmail = adminEmail;
            return this;
        }

        /**
         * Domain name authoritatively serviced by this Virtual Service. Queries for FQDNs
         * that are sub domains of this domain and do not have any DNS record in Avi are
         * dropped or NXDomain response sent. For domains which are present, SOA parameters
         * are sent in answer section of response if query type is SOA.
         *
         * @param domainName New value for the property.
         */
        public Builder setDomainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * The primary name server for this zone. This field is used in SOA records as
         * mname (RFC 1035). If not configured, it is inherited from the DNS service
         * profile. If even that is not configured, the domain name is used instead.
         *
         * @param nameServer New value for the property.
         */
        public Builder setNameServer(java.lang.String nameServer) {
            this.nameServer = nameServer;
            return this;
        }

        public ALBDnsZone build() {
            ALBDnsZone result = new ALBDnsZone();
            result.setAdminEmail(this.adminEmail);
            result.setDomainName(this.domainName);
            result.setNameServer(this.nameServer);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("admin_email", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("admin_email",
                                                                                "adminEmail",
                                                                                "getAdminEmail",
                                                                                "setAdminEmail");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("domain_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("domain_name",
                                                                                "domainName",
                                                                                "getDomainName",
                                                                                "setDomainName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("name_server", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("name_server",
                                                                                "nameServer",
                                                                                "getNameServer",
                                                                                "setNameServer");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.ALB_dns_zone",
                                                            fields,
                                                            com.vmware.nsx_policy.model.ALBDnsZone.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

