/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Advanced load balancer GeoLocation object
 */
public final class ALBGeoLocation implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Double latitude;

    private java.lang.Double longitude;

    private java.lang.String name;

    private java.lang.String tag;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBGeoLocation() {
    }

    protected ALBGeoLocation(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Latitude of the location. This is represented as degrees.minutes. The range is
     * from -90.0 (south) to +90.0 (north). Allowed values are -90.0-+90.0.
     *
     * @return The current value of the property.
     */
    public java.lang.Double getLatitude() {
        return this.latitude;
    }

    /**
     * Latitude of the location. This is represented as degrees.minutes. The range is
     * from -90.0 (south) to +90.0 (north). Allowed values are -90.0-+90.0.
     *
     * @param latitude New value for the property.
     */
    public void setLatitude(java.lang.Double latitude) {
        this.latitude = latitude;
    }

    /**
     * Longitude of the location. This is represented as degrees.minutes. The range is
     * from -180.0 (west) to +180.0 (east). Allowed values are -180.0-+180.0.
     *
     * @return The current value of the property.
     */
    public java.lang.Double getLongitude() {
        return this.longitude;
    }

    /**
     * Longitude of the location. This is represented as degrees.minutes. The range is
     * from -180.0 (west) to +180.0 (east). Allowed values are -180.0-+180.0.
     *
     * @param longitude New value for the property.
     */
    public void setLongitude(java.lang.Double longitude) {
        this.longitude = longitude;
    }

    /**
     * Location name in the format Country/State/City.
     *
     * @return The current value of the property.
     */
    public java.lang.String getName() {
        return this.name;
    }

    /**
     * Location name in the format Country/State/City.
     *
     * @param name New value for the property.
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }

    /**
     * Location tag string - example USEast.
     *
     * @return The current value of the property.
     */
    public java.lang.String getTag() {
        return this.tag;
    }

    /**
     * Location tag string - example USEast.
     *
     * @param tag New value for the property.
     */
    public void setTag(java.lang.String tag) {
        this.tag = tag;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBGeoLocation;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("latitude",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.latitude, this._getType().getField("latitude")));
        structValue.setField("longitude",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.longitude, this._getType().getField("longitude")));
        structValue.setField("name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.name, this._getType().getField("name")));
        structValue.setField("tag",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tag, this._getType().getField("tag")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBGeoLocation;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.ALBGeoLocation.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBGeoLocation _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBGeoLocation(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBGeoLocation _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBGeoLocation(structValue);
    }

    /**
     * Builder class for {@link ALBGeoLocation}.
     */
    public static final class Builder {
        private java.lang.Double latitude;
        private java.lang.Double longitude;
        private java.lang.String name;
        private java.lang.String tag;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBGeoLocation}.
         */
        public Builder() {
        }

        /**
         * Latitude of the location. This is represented as degrees.minutes. The range is
         * from -90.0 (south) to +90.0 (north). Allowed values are -90.0-+90.0.
         *
         * @param latitude New value for the property.
         */
        public Builder setLatitude(java.lang.Double latitude) {
            this.latitude = latitude;
            return this;
        }

        /**
         * Longitude of the location. This is represented as degrees.minutes. The range is
         * from -180.0 (west) to +180.0 (east). Allowed values are -180.0-+180.0.
         *
         * @param longitude New value for the property.
         */
        public Builder setLongitude(java.lang.Double longitude) {
            this.longitude = longitude;
            return this;
        }

        /**
         * Location name in the format Country/State/City.
         *
         * @param name New value for the property.
         */
        public Builder setName(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Location tag string - example USEast.
         *
         * @param tag New value for the property.
         */
        public Builder setTag(java.lang.String tag) {
            this.tag = tag;
            return this;
        }

        public ALBGeoLocation build() {
            ALBGeoLocation result = new ALBGeoLocation();
            result.setLatitude(this.latitude);
            result.setLongitude(this.longitude);
            result.setName(this.name);
            result.setTag(this.tag);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("latitude", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DoubleType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("latitude",
                                                                                "latitude",
                                                                                "getLatitude",
                                                                                "setLatitude");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("longitude", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DoubleType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("longitude",
                                                                                "longitude",
                                                                                "getLongitude",
                                                                                "setLongitude");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("name",
                                                                                "name",
                                                                                "getName",
                                                                                "setName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tag", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tag",
                                                                                "tag",
                                                                                "getTag",
                                                                                "setTag");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.ALB_geo_location",
                                                            fields,
                                                            com.vmware.nsx_policy.model.ALBGeoLocation.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

