/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Advanced load balancer HTTP2ApplicationProfile object
 */
public final class ALBHTTP2ApplicationProfile implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Long http2InitialWindowSize;

    private java.lang.Long maxHttp2ConcurrentStreamsPerConnection;

    private java.lang.Long maxHttp2ControlFramesPerConnection;

    private java.lang.Long maxHttp2EmptyDataFramesPerConnection;

    private java.lang.Long maxHttp2HeaderFieldSize;

    private java.lang.Long maxHttp2QueuedFramesToClientPerConnection;

    private java.lang.Long maxHttp2RequestsPerConnection;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBHTTP2ApplicationProfile() {
    }

    protected ALBHTTP2ApplicationProfile(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The initial flow control window size in KB for HTTP/2 streams. Allowed values
     * are 64-32768. Unit is KB. Default value when not specified in API or module is
     * interpreted by ALB Controller as 64. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getHttp2InitialWindowSize() {
        return this.http2InitialWindowSize;
    }

    /**
     * The initial flow control window size in KB for HTTP/2 streams. Allowed values
     * are 64-32768. Unit is KB. Default value when not specified in API or module is
     * interpreted by ALB Controller as 64. format: int64
     *
     * @param http2InitialWindowSize New value for the property.
     */
    public void setHttp2InitialWindowSize(java.lang.Long http2InitialWindowSize) {
        this.http2InitialWindowSize = http2InitialWindowSize;
    }

    /**
     * The max number of concurrent streams over a client side HTTP/2 connection.
     * Allowed values are 1-256. Default value when not specified in API or module is
     * interpreted by ALB Controller as 128. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMaxHttp2ConcurrentStreamsPerConnection() {
        return this.maxHttp2ConcurrentStreamsPerConnection;
    }

    /**
     * The max number of concurrent streams over a client side HTTP/2 connection.
     * Allowed values are 1-256. Default value when not specified in API or module is
     * interpreted by ALB Controller as 128. format: int64
     *
     * @param maxHttp2ConcurrentStreamsPerConnection New value for the property.
     */
    public void setMaxHttp2ConcurrentStreamsPerConnection(java.lang.Long maxHttp2ConcurrentStreamsPerConnection) {
        this.maxHttp2ConcurrentStreamsPerConnection = maxHttp2ConcurrentStreamsPerConnection;
    }

    /**
     * The max number of control frames that client can send over an HTTP/2 connection.
     * '0' means unlimited. Allowed values are 0-10000. Special values are 0-
     * 'Unlimited control frames on a client side HTTP/2 connection'. Default value
     * when not specified in API or module is interpreted by ALB Controller as 1000.
     * format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMaxHttp2ControlFramesPerConnection() {
        return this.maxHttp2ControlFramesPerConnection;
    }

    /**
     * The max number of control frames that client can send over an HTTP/2 connection.
     * '0' means unlimited. Allowed values are 0-10000. Special values are 0-
     * 'Unlimited control frames on a client side HTTP/2 connection'. Default value
     * when not specified in API or module is interpreted by ALB Controller as 1000.
     * format: int64
     *
     * @param maxHttp2ControlFramesPerConnection New value for the property.
     */
    public void setMaxHttp2ControlFramesPerConnection(java.lang.Long maxHttp2ControlFramesPerConnection) {
        this.maxHttp2ControlFramesPerConnection = maxHttp2ControlFramesPerConnection;
    }

    /**
     * The max number of empty data frames that client can send over an HTTP/2
     * connection. '0' means unlimited. Allowed values are 0-10000. Special values are
     * 0- 'Unlimited empty data frames over a client side HTTP/2 connection'. Default
     * value when not specified in API or module is interpreted by ALB Controller as
     * 1000. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMaxHttp2EmptyDataFramesPerConnection() {
        return this.maxHttp2EmptyDataFramesPerConnection;
    }

    /**
     * The max number of empty data frames that client can send over an HTTP/2
     * connection. '0' means unlimited. Allowed values are 0-10000. Special values are
     * 0- 'Unlimited empty data frames over a client side HTTP/2 connection'. Default
     * value when not specified in API or module is interpreted by ALB Controller as
     * 1000. format: int64
     *
     * @param maxHttp2EmptyDataFramesPerConnection New value for the property.
     */
    public void setMaxHttp2EmptyDataFramesPerConnection(java.lang.Long maxHttp2EmptyDataFramesPerConnection) {
        this.maxHttp2EmptyDataFramesPerConnection = maxHttp2EmptyDataFramesPerConnection;
    }

    /**
     * The maximum size in bytes of the compressed request header field. The limit
     * applies equally to both name and value. Allowed values are 1-8192. Unit is
     * BYTES. Default value when not specified in API or module is interpreted by ALB
     * Controller as 4096. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMaxHttp2HeaderFieldSize() {
        return this.maxHttp2HeaderFieldSize;
    }

    /**
     * The maximum size in bytes of the compressed request header field. The limit
     * applies equally to both name and value. Allowed values are 1-8192. Unit is
     * BYTES. Default value when not specified in API or module is interpreted by ALB
     * Controller as 4096. format: int64
     *
     * @param maxHttp2HeaderFieldSize New value for the property.
     */
    public void setMaxHttp2HeaderFieldSize(java.lang.Long maxHttp2HeaderFieldSize) {
        this.maxHttp2HeaderFieldSize = maxHttp2HeaderFieldSize;
    }

    /**
     * The max number of frames that can be queued waiting to be sent over a client
     * side HTTP/2 connection at any given time. '0' means unlimited. Allowed values
     * are 0-10000. Special values are 0- 'Unlimited frames can be queued on a client
     * side HTTP/2 connection'. Default value when not specified in API or module is
     * interpreted by ALB Controller as 1000. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMaxHttp2QueuedFramesToClientPerConnection() {
        return this.maxHttp2QueuedFramesToClientPerConnection;
    }

    /**
     * The max number of frames that can be queued waiting to be sent over a client
     * side HTTP/2 connection at any given time. '0' means unlimited. Allowed values
     * are 0-10000. Special values are 0- 'Unlimited frames can be queued on a client
     * side HTTP/2 connection'. Default value when not specified in API or module is
     * interpreted by ALB Controller as 1000. format: int64
     *
     * @param maxHttp2QueuedFramesToClientPerConnection New value for the property.
     */
    public void setMaxHttp2QueuedFramesToClientPerConnection(java.lang.Long maxHttp2QueuedFramesToClientPerConnection) {
        this.maxHttp2QueuedFramesToClientPerConnection = maxHttp2QueuedFramesToClientPerConnection;
    }

    /**
     * The maximum number of requests over a client side HTTP/2 connection. Allowed
     * values are 0-10000. Special values are 0- 'Unlimited requests on a client side
     * HTTP/2 connection'. Default value when not specified in API or module is
     * interpreted by ALB Controller as 1000. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMaxHttp2RequestsPerConnection() {
        return this.maxHttp2RequestsPerConnection;
    }

    /**
     * The maximum number of requests over a client side HTTP/2 connection. Allowed
     * values are 0-10000. Special values are 0- 'Unlimited requests on a client side
     * HTTP/2 connection'. Default value when not specified in API or module is
     * interpreted by ALB Controller as 1000. format: int64
     *
     * @param maxHttp2RequestsPerConnection New value for the property.
     */
    public void setMaxHttp2RequestsPerConnection(java.lang.Long maxHttp2RequestsPerConnection) {
        this.maxHttp2RequestsPerConnection = maxHttp2RequestsPerConnection;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBHTTP2ApplicationProfile;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("http2_initial_window_size",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.http2InitialWindowSize, this._getType().getField("http2_initial_window_size")));
        structValue.setField("max_http2_concurrent_streams_per_connection",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxHttp2ConcurrentStreamsPerConnection, this._getType().getField("max_http2_concurrent_streams_per_connection")));
        structValue.setField("max_http2_control_frames_per_connection",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxHttp2ControlFramesPerConnection, this._getType().getField("max_http2_control_frames_per_connection")));
        structValue.setField("max_http2_empty_data_frames_per_connection",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxHttp2EmptyDataFramesPerConnection, this._getType().getField("max_http2_empty_data_frames_per_connection")));
        structValue.setField("max_http2_header_field_size",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxHttp2HeaderFieldSize, this._getType().getField("max_http2_header_field_size")));
        structValue.setField("max_http2_queued_frames_to_client_per_connection",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxHttp2QueuedFramesToClientPerConnection, this._getType().getField("max_http2_queued_frames_to_client_per_connection")));
        structValue.setField("max_http2_requests_per_connection",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxHttp2RequestsPerConnection, this._getType().getField("max_http2_requests_per_connection")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBHTTP2ApplicationProfile;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.ALBHTTP2ApplicationProfile.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBHTTP2ApplicationProfile _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBHTTP2ApplicationProfile(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBHTTP2ApplicationProfile _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBHTTP2ApplicationProfile(structValue);
    }

    /**
     * Builder class for {@link ALBHTTP2ApplicationProfile}.
     */
    public static final class Builder {
        private java.lang.Long http2InitialWindowSize;
        private java.lang.Long maxHttp2ConcurrentStreamsPerConnection;
        private java.lang.Long maxHttp2ControlFramesPerConnection;
        private java.lang.Long maxHttp2EmptyDataFramesPerConnection;
        private java.lang.Long maxHttp2HeaderFieldSize;
        private java.lang.Long maxHttp2QueuedFramesToClientPerConnection;
        private java.lang.Long maxHttp2RequestsPerConnection;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBHTTP2ApplicationProfile}.
         */
        public Builder() {
        }

        /**
         * The initial flow control window size in KB for HTTP/2 streams. Allowed values
         * are 64-32768. Unit is KB. Default value when not specified in API or module is
         * interpreted by ALB Controller as 64. format: int64
         *
         * @param http2InitialWindowSize New value for the property.
         */
        public Builder setHttp2InitialWindowSize(java.lang.Long http2InitialWindowSize) {
            this.http2InitialWindowSize = http2InitialWindowSize;
            return this;
        }

        /**
         * The max number of concurrent streams over a client side HTTP/2 connection.
         * Allowed values are 1-256. Default value when not specified in API or module is
         * interpreted by ALB Controller as 128. format: int64
         *
         * @param maxHttp2ConcurrentStreamsPerConnection New value for the property.
         */
        public Builder setMaxHttp2ConcurrentStreamsPerConnection(java.lang.Long maxHttp2ConcurrentStreamsPerConnection) {
            this.maxHttp2ConcurrentStreamsPerConnection = maxHttp2ConcurrentStreamsPerConnection;
            return this;
        }

        /**
         * The max number of control frames that client can send over an HTTP/2 connection.
         * '0' means unlimited. Allowed values are 0-10000. Special values are 0-
         * 'Unlimited control frames on a client side HTTP/2 connection'. Default value
         * when not specified in API or module is interpreted by ALB Controller as 1000.
         * format: int64
         *
         * @param maxHttp2ControlFramesPerConnection New value for the property.
         */
        public Builder setMaxHttp2ControlFramesPerConnection(java.lang.Long maxHttp2ControlFramesPerConnection) {
            this.maxHttp2ControlFramesPerConnection = maxHttp2ControlFramesPerConnection;
            return this;
        }

        /**
         * The max number of empty data frames that client can send over an HTTP/2
         * connection. '0' means unlimited. Allowed values are 0-10000. Special values are
         * 0- 'Unlimited empty data frames over a client side HTTP/2 connection'. Default
         * value when not specified in API or module is interpreted by ALB Controller as
         * 1000. format: int64
         *
         * @param maxHttp2EmptyDataFramesPerConnection New value for the property.
         */
        public Builder setMaxHttp2EmptyDataFramesPerConnection(java.lang.Long maxHttp2EmptyDataFramesPerConnection) {
            this.maxHttp2EmptyDataFramesPerConnection = maxHttp2EmptyDataFramesPerConnection;
            return this;
        }

        /**
         * The maximum size in bytes of the compressed request header field. The limit
         * applies equally to both name and value. Allowed values are 1-8192. Unit is
         * BYTES. Default value when not specified in API or module is interpreted by ALB
         * Controller as 4096. format: int64
         *
         * @param maxHttp2HeaderFieldSize New value for the property.
         */
        public Builder setMaxHttp2HeaderFieldSize(java.lang.Long maxHttp2HeaderFieldSize) {
            this.maxHttp2HeaderFieldSize = maxHttp2HeaderFieldSize;
            return this;
        }

        /**
         * The max number of frames that can be queued waiting to be sent over a client
         * side HTTP/2 connection at any given time. '0' means unlimited. Allowed values
         * are 0-10000. Special values are 0- 'Unlimited frames can be queued on a client
         * side HTTP/2 connection'. Default value when not specified in API or module is
         * interpreted by ALB Controller as 1000. format: int64
         *
         * @param maxHttp2QueuedFramesToClientPerConnection New value for the property.
         */
        public Builder setMaxHttp2QueuedFramesToClientPerConnection(java.lang.Long maxHttp2QueuedFramesToClientPerConnection) {
            this.maxHttp2QueuedFramesToClientPerConnection = maxHttp2QueuedFramesToClientPerConnection;
            return this;
        }

        /**
         * The maximum number of requests over a client side HTTP/2 connection. Allowed
         * values are 0-10000. Special values are 0- 'Unlimited requests on a client side
         * HTTP/2 connection'. Default value when not specified in API or module is
         * interpreted by ALB Controller as 1000. format: int64
         *
         * @param maxHttp2RequestsPerConnection New value for the property.
         */
        public Builder setMaxHttp2RequestsPerConnection(java.lang.Long maxHttp2RequestsPerConnection) {
            this.maxHttp2RequestsPerConnection = maxHttp2RequestsPerConnection;
            return this;
        }

        public ALBHTTP2ApplicationProfile build() {
            ALBHTTP2ApplicationProfile result = new ALBHTTP2ApplicationProfile();
            result.setHttp2InitialWindowSize(this.http2InitialWindowSize);
            result.setMaxHttp2ConcurrentStreamsPerConnection(this.maxHttp2ConcurrentStreamsPerConnection);
            result.setMaxHttp2ControlFramesPerConnection(this.maxHttp2ControlFramesPerConnection);
            result.setMaxHttp2EmptyDataFramesPerConnection(this.maxHttp2EmptyDataFramesPerConnection);
            result.setMaxHttp2HeaderFieldSize(this.maxHttp2HeaderFieldSize);
            result.setMaxHttp2QueuedFramesToClientPerConnection(this.maxHttp2QueuedFramesToClientPerConnection);
            result.setMaxHttp2RequestsPerConnection(this.maxHttp2RequestsPerConnection);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("http2_initial_window_size", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("http2_initial_window_size",
                                                                                "http2InitialWindowSize",
                                                                                "getHttp2InitialWindowSize",
                                                                                "setHttp2InitialWindowSize");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max_http2_concurrent_streams_per_connection", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_http2_concurrent_streams_per_connection",
                                                                                "maxHttp2ConcurrentStreamsPerConnection",
                                                                                "getMaxHttp2ConcurrentStreamsPerConnection",
                                                                                "setMaxHttp2ConcurrentStreamsPerConnection");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max_http2_control_frames_per_connection", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_http2_control_frames_per_connection",
                                                                                "maxHttp2ControlFramesPerConnection",
                                                                                "getMaxHttp2ControlFramesPerConnection",
                                                                                "setMaxHttp2ControlFramesPerConnection");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max_http2_empty_data_frames_per_connection", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_http2_empty_data_frames_per_connection",
                                                                                "maxHttp2EmptyDataFramesPerConnection",
                                                                                "getMaxHttp2EmptyDataFramesPerConnection",
                                                                                "setMaxHttp2EmptyDataFramesPerConnection");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max_http2_header_field_size", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_http2_header_field_size",
                                                                                "maxHttp2HeaderFieldSize",
                                                                                "getMaxHttp2HeaderFieldSize",
                                                                                "setMaxHttp2HeaderFieldSize");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max_http2_queued_frames_to_client_per_connection", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_http2_queued_frames_to_client_per_connection",
                                                                                "maxHttp2QueuedFramesToClientPerConnection",
                                                                                "getMaxHttp2QueuedFramesToClientPerConnection",
                                                                                "setMaxHttp2QueuedFramesToClientPerConnection");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max_http2_requests_per_connection", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_http2_requests_per_connection",
                                                                                "maxHttp2RequestsPerConnection",
                                                                                "getMaxHttp2RequestsPerConnection",
                                                                                "setMaxHttp2RequestsPerConnection");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.ALBHTT_p2_application_profile",
                                                            fields,
                                                            com.vmware.nsx_policy.model.ALBHTTP2ApplicationProfile.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

