/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Advanced load balancer HealthMonitorDNS object
 */
public final class ALBHealthMonitorDNS implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String QTYPE_QUERY_TYPE = "DNS_QUERY_TYPE";

    public static final java.lang.String QTYPE_ANY_TYPE = "DNS_ANY_TYPE";

    public static final java.lang.String QTYPE_ANY_THING = "DNS_ANY_THING";

    public static final java.lang.String RCODE_NO_ERROR = "RCODE_NO_ERROR";

    public static final java.lang.String RCODE_ANYTHING = "RCODE_ANYTHING";

    public static final java.lang.String RECORD_TYPE_OTHER = "DNS_RECORD_OTHER";

    public static final java.lang.String RECORD_TYPE_A = "DNS_RECORD_A";

    public static final java.lang.String RECORD_TYPE_NS = "DNS_RECORD_NS";

    public static final java.lang.String RECORD_TYPE_CNAME = "DNS_RECORD_CNAME";

    public static final java.lang.String RECORD_TYPE_SOA = "DNS_RECORD_SOA";

    public static final java.lang.String RECORD_TYPE_PTR = "DNS_RECORD_PTR";

    public static final java.lang.String RECORD_TYPE_HINFO = "DNS_RECORD_HINFO";

    public static final java.lang.String RECORD_TYPE_MX = "DNS_RECORD_MX";

    public static final java.lang.String RECORD_TYPE_TXT = "DNS_RECORD_TXT";

    public static final java.lang.String RECORD_TYPE_RP = "DNS_RECORD_RP";

    public static final java.lang.String RECORD_TYPE_DNSKEY = "DNS_RECORD_DNSKEY";

    public static final java.lang.String RECORD_TYPE_AAAA = "DNS_RECORD_AAAA";

    public static final java.lang.String RECORD_TYPE_SRV = "DNS_RECORD_SRV";

    public static final java.lang.String RECORD_TYPE_OPT = "DNS_RECORD_OPT";

    public static final java.lang.String RECORD_TYPE_RRSIG = "DNS_RECORD_RRSIG";

    public static final java.lang.String RECORD_TYPE_AXFR = "DNS_RECORD_AXFR";

    public static final java.lang.String RECORD_TYPE_ANY = "DNS_RECORD_ANY";

    private java.lang.String qtype;

    private java.lang.String queryName;

    private java.lang.String rcode;

    private java.lang.String recordType;

    private java.lang.String responseString;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBHealthMonitorDNS() {
    }

    protected ALBHealthMonitorDNS(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBHealthMonitorDNS#QTYPE_QUERY_TYPE}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#QTYPE_ANY_TYPE}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#QTYPE_ANY_THING}</li>
     * </ul> Query_Type Response has atleast one answer of which the resource record
     * type matches the query type Any_Type Response should contain atleast one answer
     * AnyThing An empty answer is enough. Enum options - DNS_QUERY_TYPE, DNS_ANY_TYPE,
     * DNS_ANY_THING. Default value when not specified in API or module is interpreted
     * by ALB Controller as DNS_QUERY_TYPE.
     *
     * @return The current value of the property.
     */
    public java.lang.String getQtype() {
        return this.qtype;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBHealthMonitorDNS#QTYPE_QUERY_TYPE}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#QTYPE_ANY_TYPE}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#QTYPE_ANY_THING}</li>
     * </ul> Query_Type Response has atleast one answer of which the resource record
     * type matches the query type Any_Type Response should contain atleast one answer
     * AnyThing An empty answer is enough. Enum options - DNS_QUERY_TYPE, DNS_ANY_TYPE,
     * DNS_ANY_THING. Default value when not specified in API or module is interpreted
     * by ALB Controller as DNS_QUERY_TYPE.
     *
     * @param qtype New value for the property.
     */
    public void setQtype(java.lang.String qtype) {
        this.qtype = qtype;
    }

    /**
     * The DNS monitor will query the DNS server for the fully qualified name in this
     * field.
     *
     * @return The current value of the property.
     */
    public java.lang.String getQueryName() {
        return this.queryName;
    }

    /**
     * The DNS monitor will query the DNS server for the fully qualified name in this
     * field.
     *
     * @param queryName New value for the property.
     */
    public void setQueryName(java.lang.String queryName) {
        this.queryName = queryName;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RCODE_NO_ERROR}</li> <li> {@link
     * com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RCODE_ANYTHING}</li> </ul> When
     * No Error is selected, a DNS query will be marked failed is any error code is
     * returned by the server. With Any selected, the monitor ignores error code in the
     * responses. Enum options - RCODE_NO_ERROR, RCODE_ANYTHING. Default value when not
     * specified in API or module is interpreted by ALB Controller as RCODE_NO_ERROR.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRcode() {
        return this.rcode;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RCODE_NO_ERROR}</li> <li> {@link
     * com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RCODE_ANYTHING}</li> </ul> When
     * No Error is selected, a DNS query will be marked failed is any error code is
     * returned by the server. With Any selected, the monitor ignores error code in the
     * responses. Enum options - RCODE_NO_ERROR, RCODE_ANYTHING. Default value when not
     * specified in API or module is interpreted by ALB Controller as RCODE_NO_ERROR.
     *
     * @param rcode New value for the property.
     */
    public void setRcode(java.lang.String rcode) {
        this.rcode = rcode;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_OTHER}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_A}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_NS}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_CNAME}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_SOA}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_PTR}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_HINFO}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_MX}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_TXT}</li>
     * <li> {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_RP}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_DNSKEY}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_AAAA}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_SRV}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_OPT}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_RRSIG}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_AXFR}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_ANY}</li> </ul>
     * Resource record type used in the healthmonitor DNS query, only A or AAAA type
     * supported. Enum options - DNS_RECORD_OTHER, DNS_RECORD_A, DNS_RECORD_NS,
     * DNS_RECORD_CNAME, DNS_RECORD_SOA, DNS_RECORD_PTR, DNS_RECORD_HINFO,
     * DNS_RECORD_MX, DNS_RECORD_TXT, DNS_RECORD_RP, DNS_RECORD_DNSKEY,
     * DNS_RECORD_AAAA, DNS_RECORD_SRV, DNS_RECORD_OPT, DNS_RECORD_RRSIG,
     * DNS_RECORD_AXFR, DNS_RECORD_ANY. Default value when not specified in API or
     * module is interpreted by ALB Controller as DNS_RECORD_A.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRecordType() {
        return this.recordType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_OTHER}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_A}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_NS}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_CNAME}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_SOA}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_PTR}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_HINFO}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_MX}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_TXT}</li>
     * <li> {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_RP}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_DNSKEY}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_AAAA}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_SRV}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_OPT}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_RRSIG}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_AXFR}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_ANY}</li> </ul>
     * Resource record type used in the healthmonitor DNS query, only A or AAAA type
     * supported. Enum options - DNS_RECORD_OTHER, DNS_RECORD_A, DNS_RECORD_NS,
     * DNS_RECORD_CNAME, DNS_RECORD_SOA, DNS_RECORD_PTR, DNS_RECORD_HINFO,
     * DNS_RECORD_MX, DNS_RECORD_TXT, DNS_RECORD_RP, DNS_RECORD_DNSKEY,
     * DNS_RECORD_AAAA, DNS_RECORD_SRV, DNS_RECORD_OPT, DNS_RECORD_RRSIG,
     * DNS_RECORD_AXFR, DNS_RECORD_ANY. Default value when not specified in API or
     * module is interpreted by ALB Controller as DNS_RECORD_A.
     *
     * @param recordType New value for the property.
     */
    public void setRecordType(java.lang.String recordType) {
        this.recordType = recordType;
    }

    /**
     * The resource record of the queried DNS server's response for the Request Name
     * must include the IP address defined in this field.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResponseString() {
        return this.responseString;
    }

    /**
     * The resource record of the queried DNS server's response for the Request Name
     * must include the IP address defined in this field.
     *
     * @param responseString New value for the property.
     */
    public void setResponseString(java.lang.String responseString) {
        this.responseString = responseString;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBHealthMonitorDNS;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("qtype",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.qtype, this._getType().getField("qtype")));
        structValue.setField("query_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.queryName, this._getType().getField("query_name")));
        structValue.setField("rcode",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.rcode, this._getType().getField("rcode")));
        structValue.setField("record_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.recordType, this._getType().getField("record_type")));
        structValue.setField("response_string",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.responseString, this._getType().getField("response_string")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBHealthMonitorDNS;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.ALBHealthMonitorDNS.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBHealthMonitorDNS _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBHealthMonitorDNS(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBHealthMonitorDNS _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBHealthMonitorDNS(structValue);
    }

    /**
     * Builder class for {@link ALBHealthMonitorDNS}.
     */
    public static final class Builder {
        private java.lang.String qtype;
        private java.lang.String queryName;
        private java.lang.String rcode;
        private java.lang.String recordType;
        private java.lang.String responseString;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBHealthMonitorDNS}.
         */
        public Builder() {
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.ALBHealthMonitorDNS#QTYPE_QUERY_TYPE}</li> <li>
         * {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#QTYPE_ANY_TYPE}</li> <li>
         * {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#QTYPE_ANY_THING}</li>
         * </ul> Query_Type Response has atleast one answer of which the resource record
         * type matches the query type Any_Type Response should contain atleast one answer
         * AnyThing An empty answer is enough. Enum options - DNS_QUERY_TYPE, DNS_ANY_TYPE,
         * DNS_ANY_THING. Default value when not specified in API or module is interpreted
         * by ALB Controller as DNS_QUERY_TYPE.
         *
         * @param qtype New value for the property.
         */
        public Builder setQtype(java.lang.String qtype) {
            this.qtype = qtype;
            return this;
        }

        /**
         * The DNS monitor will query the DNS server for the fully qualified name in this
         * field.
         *
         * @param queryName New value for the property.
         */
        public Builder setQueryName(java.lang.String queryName) {
            this.queryName = queryName;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RCODE_NO_ERROR}</li> <li> {@link
         * com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RCODE_ANYTHING}</li> </ul> When
         * No Error is selected, a DNS query will be marked failed is any error code is
         * returned by the server. With Any selected, the monitor ignores error code in the
         * responses. Enum options - RCODE_NO_ERROR, RCODE_ANYTHING. Default value when not
         * specified in API or module is interpreted by ALB Controller as RCODE_NO_ERROR.
         *
         * @param rcode New value for the property.
         */
        public Builder setRcode(java.lang.String rcode) {
            this.rcode = rcode;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_OTHER}</li> <li>
         * {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_A}</li> <li>
         * {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_NS}</li> <li>
         * {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_CNAME}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_SOA}</li> <li>
         * {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_PTR}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_HINFO}</li> <li>
         * {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_MX}</li> <li>
         * {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_TXT}</li>
         * <li> {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_RP}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_DNSKEY}</li> <li>
         * {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_AAAA}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_SRV}</li> <li>
         * {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_OPT}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_RRSIG}</li> <li>
         * {@link com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_AXFR}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.ALBHealthMonitorDNS#RECORD_TYPE_ANY}</li> </ul>
         * Resource record type used in the healthmonitor DNS query, only A or AAAA type
         * supported. Enum options - DNS_RECORD_OTHER, DNS_RECORD_A, DNS_RECORD_NS,
         * DNS_RECORD_CNAME, DNS_RECORD_SOA, DNS_RECORD_PTR, DNS_RECORD_HINFO,
         * DNS_RECORD_MX, DNS_RECORD_TXT, DNS_RECORD_RP, DNS_RECORD_DNSKEY,
         * DNS_RECORD_AAAA, DNS_RECORD_SRV, DNS_RECORD_OPT, DNS_RECORD_RRSIG,
         * DNS_RECORD_AXFR, DNS_RECORD_ANY. Default value when not specified in API or
         * module is interpreted by ALB Controller as DNS_RECORD_A.
         *
         * @param recordType New value for the property.
         */
        public Builder setRecordType(java.lang.String recordType) {
            this.recordType = recordType;
            return this;
        }

        /**
         * The resource record of the queried DNS server's response for the Request Name
         * must include the IP address defined in this field.
         *
         * @param responseString New value for the property.
         */
        public Builder setResponseString(java.lang.String responseString) {
            this.responseString = responseString;
            return this;
        }

        public ALBHealthMonitorDNS build() {
            ALBHealthMonitorDNS result = new ALBHealthMonitorDNS();
            result.setQtype(this.qtype);
            result.setQueryName(this.queryName);
            result.setRcode(this.rcode);
            result.setRecordType(this.recordType);
            result.setResponseString(this.responseString);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("qtype", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("qtype",
                                                                                "qtype",
                                                                                "getQtype",
                                                                                "setQtype");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("query_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("query_name",
                                                                                "queryName",
                                                                                "getQueryName",
                                                                                "setQueryName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("rcode", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("rcode",
                                                                                "rcode",
                                                                                "getRcode",
                                                                                "setRcode");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("record_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("record_type",
                                                                                "recordType",
                                                                                "getRecordType",
                                                                                "setRecordType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("response_string", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("response_string",
                                                                                "responseString",
                                                                                "getResponseString",
                                                                                "setResponseString");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.ALB_health_monitor_DNS",
                                                            fields,
                                                            com.vmware.nsx_policy.model.ALBHealthMonitorDNS.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

