/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Advanced load balancer LdapDirectorySettings object
 */
public final class ALBLdapDirectorySettings implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String GROUP_SEARCH_SCOPE_BASE = "AUTH_LDAP_SCOPE_BASE";

    public static final java.lang.String GROUP_SEARCH_SCOPE_ONE = "AUTH_LDAP_SCOPE_ONE";

    public static final java.lang.String GROUP_SEARCH_SCOPE_SUBTREE = "AUTH_LDAP_SCOPE_SUBTREE";

    public static final java.lang.String USER_SEARCH_SCOPE_BASE = "AUTH_LDAP_SCOPE_BASE";

    public static final java.lang.String USER_SEARCH_SCOPE_ONE = "AUTH_LDAP_SCOPE_ONE";

    public static final java.lang.String USER_SEARCH_SCOPE_SUBTREE = "AUTH_LDAP_SCOPE_SUBTREE";

    private java.lang.String adminBindDn;

    private java.lang.String groupFilter;

    private java.lang.String groupMemberAttribute;

    private java.lang.Boolean groupMemberIsFullDn;

    private java.lang.String groupSearchDn;

    private java.lang.String groupSearchScope;

    private java.lang.Boolean ignoreReferrals;

    private java.lang.String password;

    private java.util.List<java.lang.String> userAttributes;

    private java.lang.String userIdAttribute;

    private java.lang.String userSearchDn;

    private java.lang.String userSearchScope;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBLdapDirectorySettings() {
    }

    protected ALBLdapDirectorySettings(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * LDAP Admin User DN. Administrator credentials are required to search for users
     * under user search DN or groups under group search DN.
     *
     * @return The current value of the property.
     */
    public java.lang.String getAdminBindDn() {
        return this.adminBindDn;
    }

    /**
     * LDAP Admin User DN. Administrator credentials are required to search for users
     * under user search DN or groups under group search DN.
     *
     * @param adminBindDn New value for the property.
     */
    public void setAdminBindDn(java.lang.String adminBindDn) {
        this.adminBindDn = adminBindDn;
    }

    /**
     * Group filter is used to identify groups during search. Default value when not
     * specified in API or module is interpreted by ALB Controller as
     * (objectClass=(STAR)).
     *
     * @return The current value of the property.
     */
    public java.lang.String getGroupFilter() {
        return this.groupFilter;
    }

    /**
     * Group filter is used to identify groups during search. Default value when not
     * specified in API or module is interpreted by ALB Controller as
     * (objectClass=(STAR)).
     *
     * @param groupFilter New value for the property.
     */
    public void setGroupFilter(java.lang.String groupFilter) {
        this.groupFilter = groupFilter;
    }

    /**
     * LDAP group attribute that identifies each of the group members. Default value
     * when not specified in API or module is interpreted by ALB Controller as member.
     *
     * @return The current value of the property.
     */
    public java.lang.String getGroupMemberAttribute() {
        return this.groupMemberAttribute;
    }

    /**
     * LDAP group attribute that identifies each of the group members. Default value
     * when not specified in API or module is interpreted by ALB Controller as member.
     *
     * @param groupMemberAttribute New value for the property.
     */
    public void setGroupMemberAttribute(java.lang.String groupMemberAttribute) {
        this.groupMemberAttribute = groupMemberAttribute;
    }

    /**
     * Group member entries contain full DNs instead of just user id attribute values.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getGroupMemberIsFullDn() {
        return this.groupMemberIsFullDn;
    }

    /**
     * Group member entries contain full DNs instead of just user id attribute values.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as true.
     *
     * @param groupMemberIsFullDn New value for the property.
     */
    public void setGroupMemberIsFullDn(java.lang.Boolean groupMemberIsFullDn) {
        this.groupMemberIsFullDn = groupMemberIsFullDn;
    }

    /**
     * LDAP group search DN is the root of search for a given group in the LDAP
     * directory. Only matching groups present in this LDAP directory sub-tree will be
     * checked for user membership.
     *
     * @return The current value of the property.
     */
    public java.lang.String getGroupSearchDn() {
        return this.groupSearchDn;
    }

    /**
     * LDAP group search DN is the root of search for a given group in the LDAP
     * directory. Only matching groups present in this LDAP directory sub-tree will be
     * checked for user membership.
     *
     * @param groupSearchDn New value for the property.
     */
    public void setGroupSearchDn(java.lang.String groupSearchDn) {
        this.groupSearchDn = groupSearchDn;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBLdapDirectorySettings#GROUP_SEARCH_SCOPE_BASE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBLdapDirectorySettings#GROUP_SEARCH_SCOPE_ONE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBLdapDirectorySettings#GROUP_SEARCH_SCOPE_SUBTREE}</li>
     * </ul> LDAP group search scope defines how deep to search for the group starting
     * from the group search DN. Enum options - AUTH_LDAP_SCOPE_BASE,
     * AUTH_LDAP_SCOPE_ONE, AUTH_LDAP_SCOPE_SUBTREE. Default value when not specified
     * in API or module is interpreted by ALB Controller as AUTH_LDAP_SCOPE_SUBTREE.
     *
     * @return The current value of the property.
     */
    public java.lang.String getGroupSearchScope() {
        return this.groupSearchScope;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBLdapDirectorySettings#GROUP_SEARCH_SCOPE_BASE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBLdapDirectorySettings#GROUP_SEARCH_SCOPE_ONE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBLdapDirectorySettings#GROUP_SEARCH_SCOPE_SUBTREE}</li>
     * </ul> LDAP group search scope defines how deep to search for the group starting
     * from the group search DN. Enum options - AUTH_LDAP_SCOPE_BASE,
     * AUTH_LDAP_SCOPE_ONE, AUTH_LDAP_SCOPE_SUBTREE. Default value when not specified
     * in API or module is interpreted by ALB Controller as AUTH_LDAP_SCOPE_SUBTREE.
     *
     * @param groupSearchScope New value for the property.
     */
    public void setGroupSearchScope(java.lang.String groupSearchScope) {
        this.groupSearchScope = groupSearchScope;
    }

    /**
     * During user or group search, ignore searching referrals. Default value when not
     * specified in API or module is interpreted by ALB Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getIgnoreReferrals() {
        return this.ignoreReferrals;
    }

    /**
     * During user or group search, ignore searching referrals. Default value when not
     * specified in API or module is interpreted by ALB Controller as false.
     *
     * @param ignoreReferrals New value for the property.
     */
    public void setIgnoreReferrals(java.lang.Boolean ignoreReferrals) {
        this.ignoreReferrals = ignoreReferrals;
    }

    /**
     * LDAP Admin User Password.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPassword() {
        return this.password;
    }

    /**
     * LDAP Admin User Password.
     *
     * @param password New value for the property.
     */
    public void setPassword(java.lang.String password) {
        this.password = password;
    }

    /**
     * LDAP user attributes to fetch on a successful user bind.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getUserAttributes() {
        return this.userAttributes;
    }

    /**
     * LDAP user attributes to fetch on a successful user bind.
     *
     * @param userAttributes New value for the property.
     */
    public void setUserAttributes(java.util.List<java.lang.String> userAttributes) {
        this.userAttributes = userAttributes;
    }

    /**
     * LDAP user id attribute is the login attribute that uniquely identifies a single
     * user record.
     *
     * @return The current value of the property.
     */
    public java.lang.String getUserIdAttribute() {
        return this.userIdAttribute;
    }

    /**
     * LDAP user id attribute is the login attribute that uniquely identifies a single
     * user record.
     *
     * @param userIdAttribute New value for the property.
     */
    public void setUserIdAttribute(java.lang.String userIdAttribute) {
        this.userIdAttribute = userIdAttribute;
    }

    /**
     * LDAP user search DN is the root of search for a given user in the LDAP
     * directory. Only user records present in this LDAP directory sub-tree will be
     * validated.
     *
     * @return The current value of the property.
     */
    public java.lang.String getUserSearchDn() {
        return this.userSearchDn;
    }

    /**
     * LDAP user search DN is the root of search for a given user in the LDAP
     * directory. Only user records present in this LDAP directory sub-tree will be
     * validated.
     *
     * @param userSearchDn New value for the property.
     */
    public void setUserSearchDn(java.lang.String userSearchDn) {
        this.userSearchDn = userSearchDn;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBLdapDirectorySettings#USER_SEARCH_SCOPE_BASE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBLdapDirectorySettings#USER_SEARCH_SCOPE_ONE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBLdapDirectorySettings#USER_SEARCH_SCOPE_SUBTREE}</li>
     * </ul> LDAP user search scope defines how deep to search for the user starting
     * from user search DN. Enum options - AUTH_LDAP_SCOPE_BASE, AUTH_LDAP_SCOPE_ONE,
     * AUTH_LDAP_SCOPE_SUBTREE. Default value when not specified in API or module is
     * interpreted by ALB Controller as AUTH_LDAP_SCOPE_ONE.
     *
     * @return The current value of the property.
     */
    public java.lang.String getUserSearchScope() {
        return this.userSearchScope;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBLdapDirectorySettings#USER_SEARCH_SCOPE_BASE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBLdapDirectorySettings#USER_SEARCH_SCOPE_ONE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBLdapDirectorySettings#USER_SEARCH_SCOPE_SUBTREE}</li>
     * </ul> LDAP user search scope defines how deep to search for the user starting
     * from user search DN. Enum options - AUTH_LDAP_SCOPE_BASE, AUTH_LDAP_SCOPE_ONE,
     * AUTH_LDAP_SCOPE_SUBTREE. Default value when not specified in API or module is
     * interpreted by ALB Controller as AUTH_LDAP_SCOPE_ONE.
     *
     * @param userSearchScope New value for the property.
     */
    public void setUserSearchScope(java.lang.String userSearchScope) {
        this.userSearchScope = userSearchScope;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBLdapDirectorySettings;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("admin_bind_dn",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.adminBindDn, this._getType().getField("admin_bind_dn")));
        structValue.setField("group_filter",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.groupFilter, this._getType().getField("group_filter")));
        structValue.setField("group_member_attribute",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.groupMemberAttribute, this._getType().getField("group_member_attribute")));
        structValue.setField("group_member_is_full_dn",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.groupMemberIsFullDn, this._getType().getField("group_member_is_full_dn")));
        structValue.setField("group_search_dn",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.groupSearchDn, this._getType().getField("group_search_dn")));
        structValue.setField("group_search_scope",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.groupSearchScope, this._getType().getField("group_search_scope")));
        structValue.setField("ignore_referrals",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ignoreReferrals, this._getType().getField("ignore_referrals")));
        structValue.setField("password",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.password, this._getType().getField("password")));
        structValue.setField("user_attributes",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.userAttributes, this._getType().getField("user_attributes")));
        structValue.setField("user_id_attribute",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.userIdAttribute, this._getType().getField("user_id_attribute")));
        structValue.setField("user_search_dn",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.userSearchDn, this._getType().getField("user_search_dn")));
        structValue.setField("user_search_scope",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.userSearchScope, this._getType().getField("user_search_scope")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBLdapDirectorySettings;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.ALBLdapDirectorySettings.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBLdapDirectorySettings _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBLdapDirectorySettings(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBLdapDirectorySettings _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBLdapDirectorySettings(structValue);
    }

    /**
     * Builder class for {@link ALBLdapDirectorySettings}.
     */
    public static final class Builder {
        private java.lang.String adminBindDn;
        private java.lang.String groupFilter;
        private java.lang.String groupMemberAttribute;
        private java.lang.Boolean groupMemberIsFullDn;
        private java.lang.String groupSearchDn;
        private java.lang.String groupSearchScope;
        private java.lang.Boolean ignoreReferrals;
        private java.lang.String password;
        private java.util.List<java.lang.String> userAttributes;
        private java.lang.String userIdAttribute;
        private java.lang.String userSearchDn;
        private java.lang.String userSearchScope;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBLdapDirectorySettings}.
         */
        public Builder() {
        }

        /**
         * LDAP Admin User DN. Administrator credentials are required to search for users
         * under user search DN or groups under group search DN.
         *
         * @param adminBindDn New value for the property.
         */
        public Builder setAdminBindDn(java.lang.String adminBindDn) {
            this.adminBindDn = adminBindDn;
            return this;
        }

        /**
         * Group filter is used to identify groups during search. Default value when not
         * specified in API or module is interpreted by ALB Controller as
         * (objectClass=(STAR)).
         *
         * @param groupFilter New value for the property.
         */
        public Builder setGroupFilter(java.lang.String groupFilter) {
            this.groupFilter = groupFilter;
            return this;
        }

        /**
         * LDAP group attribute that identifies each of the group members. Default value
         * when not specified in API or module is interpreted by ALB Controller as member.
         *
         * @param groupMemberAttribute New value for the property.
         */
        public Builder setGroupMemberAttribute(java.lang.String groupMemberAttribute) {
            this.groupMemberAttribute = groupMemberAttribute;
            return this;
        }

        /**
         * Group member entries contain full DNs instead of just user id attribute values.
         * Default value when not specified in API or module is interpreted by ALB
         * Controller as true.
         *
         * @param groupMemberIsFullDn New value for the property.
         */
        public Builder setGroupMemberIsFullDn(java.lang.Boolean groupMemberIsFullDn) {
            this.groupMemberIsFullDn = groupMemberIsFullDn;
            return this;
        }

        /**
         * LDAP group search DN is the root of search for a given group in the LDAP
         * directory. Only matching groups present in this LDAP directory sub-tree will be
         * checked for user membership.
         *
         * @param groupSearchDn New value for the property.
         */
        public Builder setGroupSearchDn(java.lang.String groupSearchDn) {
            this.groupSearchDn = groupSearchDn;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.ALBLdapDirectorySettings#GROUP_SEARCH_SCOPE_BASE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.ALBLdapDirectorySettings#GROUP_SEARCH_SCOPE_ONE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.ALBLdapDirectorySettings#GROUP_SEARCH_SCOPE_SUBTREE}</li>
         * </ul> LDAP group search scope defines how deep to search for the group starting
         * from the group search DN. Enum options - AUTH_LDAP_SCOPE_BASE,
         * AUTH_LDAP_SCOPE_ONE, AUTH_LDAP_SCOPE_SUBTREE. Default value when not specified
         * in API or module is interpreted by ALB Controller as AUTH_LDAP_SCOPE_SUBTREE.
         *
         * @param groupSearchScope New value for the property.
         */
        public Builder setGroupSearchScope(java.lang.String groupSearchScope) {
            this.groupSearchScope = groupSearchScope;
            return this;
        }

        /**
         * During user or group search, ignore searching referrals. Default value when not
         * specified in API or module is interpreted by ALB Controller as false.
         *
         * @param ignoreReferrals New value for the property.
         */
        public Builder setIgnoreReferrals(java.lang.Boolean ignoreReferrals) {
            this.ignoreReferrals = ignoreReferrals;
            return this;
        }

        /**
         * LDAP Admin User Password.
         *
         * @param password New value for the property.
         */
        public Builder setPassword(java.lang.String password) {
            this.password = password;
            return this;
        }

        /**
         * LDAP user attributes to fetch on a successful user bind.
         *
         * @param userAttributes New value for the property.
         */
        public Builder setUserAttributes(java.util.List<java.lang.String> userAttributes) {
            this.userAttributes = userAttributes;
            return this;
        }

        /**
         * LDAP user id attribute is the login attribute that uniquely identifies a single
         * user record.
         *
         * @param userIdAttribute New value for the property.
         */
        public Builder setUserIdAttribute(java.lang.String userIdAttribute) {
            this.userIdAttribute = userIdAttribute;
            return this;
        }

        /**
         * LDAP user search DN is the root of search for a given user in the LDAP
         * directory. Only user records present in this LDAP directory sub-tree will be
         * validated.
         *
         * @param userSearchDn New value for the property.
         */
        public Builder setUserSearchDn(java.lang.String userSearchDn) {
            this.userSearchDn = userSearchDn;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.ALBLdapDirectorySettings#USER_SEARCH_SCOPE_BASE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.ALBLdapDirectorySettings#USER_SEARCH_SCOPE_ONE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.ALBLdapDirectorySettings#USER_SEARCH_SCOPE_SUBTREE}</li>
         * </ul> LDAP user search scope defines how deep to search for the user starting
         * from user search DN. Enum options - AUTH_LDAP_SCOPE_BASE, AUTH_LDAP_SCOPE_ONE,
         * AUTH_LDAP_SCOPE_SUBTREE. Default value when not specified in API or module is
         * interpreted by ALB Controller as AUTH_LDAP_SCOPE_ONE.
         *
         * @param userSearchScope New value for the property.
         */
        public Builder setUserSearchScope(java.lang.String userSearchScope) {
            this.userSearchScope = userSearchScope;
            return this;
        }

        public ALBLdapDirectorySettings build() {
            ALBLdapDirectorySettings result = new ALBLdapDirectorySettings();
            result.setAdminBindDn(this.adminBindDn);
            result.setGroupFilter(this.groupFilter);
            result.setGroupMemberAttribute(this.groupMemberAttribute);
            result.setGroupMemberIsFullDn(this.groupMemberIsFullDn);
            result.setGroupSearchDn(this.groupSearchDn);
            result.setGroupSearchScope(this.groupSearchScope);
            result.setIgnoreReferrals(this.ignoreReferrals);
            result.setPassword(this.password);
            result.setUserAttributes(this.userAttributes);
            result.setUserIdAttribute(this.userIdAttribute);
            result.setUserSearchDn(this.userSearchDn);
            result.setUserSearchScope(this.userSearchScope);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("admin_bind_dn", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("admin_bind_dn",
                                                                                "adminBindDn",
                                                                                "getAdminBindDn",
                                                                                "setAdminBindDn");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("group_filter", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("group_filter",
                                                                                "groupFilter",
                                                                                "getGroupFilter",
                                                                                "setGroupFilter");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("group_member_attribute", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("group_member_attribute",
                                                                                "groupMemberAttribute",
                                                                                "getGroupMemberAttribute",
                                                                                "setGroupMemberAttribute");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("group_member_is_full_dn", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("group_member_is_full_dn",
                                                                                "groupMemberIsFullDn",
                                                                                "getGroupMemberIsFullDn",
                                                                                "setGroupMemberIsFullDn");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("group_search_dn", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("group_search_dn",
                                                                                "groupSearchDn",
                                                                                "getGroupSearchDn",
                                                                                "setGroupSearchDn");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("group_search_scope", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("group_search_scope",
                                                                                "groupSearchScope",
                                                                                "getGroupSearchScope",
                                                                                "setGroupSearchScope");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ignore_referrals", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ignore_referrals",
                                                                                "ignoreReferrals",
                                                                                "getIgnoreReferrals",
                                                                                "setIgnoreReferrals");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("password", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("password",
                                                                                "password",
                                                                                "getPassword",
                                                                                "setPassword");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("user_attributes", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("user_attributes",
                                                                                "userAttributes",
                                                                                "getUserAttributes",
                                                                                "setUserAttributes");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("user_id_attribute", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("user_id_attribute",
                                                                                "userIdAttribute",
                                                                                "getUserIdAttribute",
                                                                                "setUserIdAttribute");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("user_search_dn", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("user_search_dn",
                                                                                "userSearchDn",
                                                                                "getUserSearchDn",
                                                                                "setUserSearchDn");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("user_search_scope", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("user_search_scope",
                                                                                "userSearchScope",
                                                                                "getUserSearchScope",
                                                                                "setUserSearchScope");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.ALB_ldap_directory_settings",
                                                            fields,
                                                            com.vmware.nsx_policy.model.ALBLdapDirectorySettings.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

