/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Advanced load balancer OCSPConfig object
 */
public final class ALBOCSPConfig implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String URL_ACTION_FAILOVER = "OCSP_RESPONDER_URL_FAILOVER";

    public static final java.lang.String URL_ACTION_OVERRIDE = "OCSP_RESPONDER_URL_OVERRIDE";

    private java.lang.Long failedOcspJobsRetryInterval;

    private java.lang.Long maxTries;

    private java.lang.Long ocspReqInterval;

    private java.lang.Long ocspRespTimeout;

    private java.util.List<java.lang.String> responderUrlLists;

    private java.lang.String urlAction;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBOCSPConfig() {
    }

    protected ALBOCSPConfig(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Describes the Time Interval after which the next OCSP job needs to be scheduled
     * in case of the OCSP job failures. Allowed values are 60-86400. Unit is SEC.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as 3600. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getFailedOcspJobsRetryInterval() {
        return this.failedOcspJobsRetryInterval;
    }

    /**
     * Describes the Time Interval after which the next OCSP job needs to be scheduled
     * in case of the OCSP job failures. Allowed values are 60-86400. Unit is SEC.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as 3600. format: int64
     *
     * @param failedOcspJobsRetryInterval New value for the property.
     */
    public void setFailedOcspJobsRetryInterval(java.lang.Long failedOcspJobsRetryInterval) {
        this.failedOcspJobsRetryInterval = failedOcspJobsRetryInterval;
    }

    /**
     * Maximum number of times the failed OCSP jobs can be scheduled. Default value
     * when not specified in API or module is interpreted by ALB Controller as 10.
     * format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMaxTries() {
        return this.maxTries;
    }

    /**
     * Maximum number of times the failed OCSP jobs can be scheduled. Default value
     * when not specified in API or module is interpreted by ALB Controller as 10.
     * format: int64
     *
     * @param maxTries New value for the property.
     */
    public void setMaxTries(java.lang.Long maxTries) {
        this.maxTries = maxTries;
    }

    /**
     * Interval between the OCSP queries. Allowed values are 60-31536000. Unit is SEC.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as 86400. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getOcspReqInterval() {
        return this.ocspReqInterval;
    }

    /**
     * Interval between the OCSP queries. Allowed values are 60-31536000. Unit is SEC.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as 86400. format: int64
     *
     * @param ocspReqInterval New value for the property.
     */
    public void setOcspReqInterval(java.lang.Long ocspReqInterval) {
        this.ocspReqInterval = ocspReqInterval;
    }

    /**
     * Time in seconds that the system waits for a reply from the OCSP responder before
     * dropping the connection. Unit is SEC. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getOcspRespTimeout() {
        return this.ocspRespTimeout;
    }

    /**
     * Time in seconds that the system waits for a reply from the OCSP responder before
     * dropping the connection. Unit is SEC. format: int64
     *
     * @param ocspRespTimeout New value for the property.
     */
    public void setOcspRespTimeout(java.lang.Long ocspRespTimeout) {
        this.ocspRespTimeout = ocspRespTimeout;
    }

    /**
     * List of Responder URLs configured by user to do failover/override the AIA
     * extension contained in the OCSP responder's SSL/TLS certificate.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getResponderUrlLists() {
        return this.responderUrlLists;
    }

    /**
     * List of Responder URLs configured by user to do failover/override the AIA
     * extension contained in the OCSP responder's SSL/TLS certificate.
     *
     * @param responderUrlLists New value for the property.
     */
    public void setResponderUrlLists(java.util.List<java.lang.String> responderUrlLists) {
        this.responderUrlLists = responderUrlLists;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBOCSPConfig#URL_ACTION_FAILOVER}</li> <li> {@link
     * com.vmware.nsx_policy.model.ALBOCSPConfig#URL_ACTION_OVERRIDE}</li> </ul>
     * Describes the type of action to take with the Responder URLs. Enum options -
     * OCSP_RESPONDER_URL_FAILOVER, OCSP_RESPONDER_URL_OVERRIDE. Default value when not
     * specified in API or module is interpreted by ALB Controller as
     * OCSP_RESPONDER_URL_FAILOVER.
     *
     * @return The current value of the property.
     */
    public java.lang.String getUrlAction() {
        return this.urlAction;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBOCSPConfig#URL_ACTION_FAILOVER}</li> <li> {@link
     * com.vmware.nsx_policy.model.ALBOCSPConfig#URL_ACTION_OVERRIDE}</li> </ul>
     * Describes the type of action to take with the Responder URLs. Enum options -
     * OCSP_RESPONDER_URL_FAILOVER, OCSP_RESPONDER_URL_OVERRIDE. Default value when not
     * specified in API or module is interpreted by ALB Controller as
     * OCSP_RESPONDER_URL_FAILOVER.
     *
     * @param urlAction New value for the property.
     */
    public void setUrlAction(java.lang.String urlAction) {
        this.urlAction = urlAction;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBOCSPConfig;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("failed_ocsp_jobs_retry_interval",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.failedOcspJobsRetryInterval, this._getType().getField("failed_ocsp_jobs_retry_interval")));
        structValue.setField("max_tries",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxTries, this._getType().getField("max_tries")));
        structValue.setField("ocsp_req_interval",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ocspReqInterval, this._getType().getField("ocsp_req_interval")));
        structValue.setField("ocsp_resp_timeout",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ocspRespTimeout, this._getType().getField("ocsp_resp_timeout")));
        structValue.setField("responder_url_lists",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.responderUrlLists, this._getType().getField("responder_url_lists")));
        structValue.setField("url_action",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.urlAction, this._getType().getField("url_action")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBOCSPConfig;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.ALBOCSPConfig.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBOCSPConfig _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBOCSPConfig(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBOCSPConfig _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBOCSPConfig(structValue);
    }

    /**
     * Builder class for {@link ALBOCSPConfig}.
     */
    public static final class Builder {
        private java.lang.Long failedOcspJobsRetryInterval;
        private java.lang.Long maxTries;
        private java.lang.Long ocspReqInterval;
        private java.lang.Long ocspRespTimeout;
        private java.util.List<java.lang.String> responderUrlLists;
        private java.lang.String urlAction;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBOCSPConfig}.
         */
        public Builder() {
        }

        /**
         * Describes the Time Interval after which the next OCSP job needs to be scheduled
         * in case of the OCSP job failures. Allowed values are 60-86400. Unit is SEC.
         * Default value when not specified in API or module is interpreted by ALB
         * Controller as 3600. format: int64
         *
         * @param failedOcspJobsRetryInterval New value for the property.
         */
        public Builder setFailedOcspJobsRetryInterval(java.lang.Long failedOcspJobsRetryInterval) {
            this.failedOcspJobsRetryInterval = failedOcspJobsRetryInterval;
            return this;
        }

        /**
         * Maximum number of times the failed OCSP jobs can be scheduled. Default value
         * when not specified in API or module is interpreted by ALB Controller as 10.
         * format: int64
         *
         * @param maxTries New value for the property.
         */
        public Builder setMaxTries(java.lang.Long maxTries) {
            this.maxTries = maxTries;
            return this;
        }

        /**
         * Interval between the OCSP queries. Allowed values are 60-31536000. Unit is SEC.
         * Default value when not specified in API or module is interpreted by ALB
         * Controller as 86400. format: int64
         *
         * @param ocspReqInterval New value for the property.
         */
        public Builder setOcspReqInterval(java.lang.Long ocspReqInterval) {
            this.ocspReqInterval = ocspReqInterval;
            return this;
        }

        /**
         * Time in seconds that the system waits for a reply from the OCSP responder before
         * dropping the connection. Unit is SEC. format: int64
         *
         * @param ocspRespTimeout New value for the property.
         */
        public Builder setOcspRespTimeout(java.lang.Long ocspRespTimeout) {
            this.ocspRespTimeout = ocspRespTimeout;
            return this;
        }

        /**
         * List of Responder URLs configured by user to do failover/override the AIA
         * extension contained in the OCSP responder's SSL/TLS certificate.
         *
         * @param responderUrlLists New value for the property.
         */
        public Builder setResponderUrlLists(java.util.List<java.lang.String> responderUrlLists) {
            this.responderUrlLists = responderUrlLists;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.ALBOCSPConfig#URL_ACTION_FAILOVER}</li> <li> {@link
         * com.vmware.nsx_policy.model.ALBOCSPConfig#URL_ACTION_OVERRIDE}</li> </ul>
         * Describes the type of action to take with the Responder URLs. Enum options -
         * OCSP_RESPONDER_URL_FAILOVER, OCSP_RESPONDER_URL_OVERRIDE. Default value when not
         * specified in API or module is interpreted by ALB Controller as
         * OCSP_RESPONDER_URL_FAILOVER.
         *
         * @param urlAction New value for the property.
         */
        public Builder setUrlAction(java.lang.String urlAction) {
            this.urlAction = urlAction;
            return this;
        }

        public ALBOCSPConfig build() {
            ALBOCSPConfig result = new ALBOCSPConfig();
            result.setFailedOcspJobsRetryInterval(this.failedOcspJobsRetryInterval);
            result.setMaxTries(this.maxTries);
            result.setOcspReqInterval(this.ocspReqInterval);
            result.setOcspRespTimeout(this.ocspRespTimeout);
            result.setResponderUrlLists(this.responderUrlLists);
            result.setUrlAction(this.urlAction);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("failed_ocsp_jobs_retry_interval", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("failed_ocsp_jobs_retry_interval",
                                                                                "failedOcspJobsRetryInterval",
                                                                                "getFailedOcspJobsRetryInterval",
                                                                                "setFailedOcspJobsRetryInterval");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max_tries", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_tries",
                                                                                "maxTries",
                                                                                "getMaxTries",
                                                                                "setMaxTries");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ocsp_req_interval", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ocsp_req_interval",
                                                                                "ocspReqInterval",
                                                                                "getOcspReqInterval",
                                                                                "setOcspReqInterval");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ocsp_resp_timeout", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ocsp_resp_timeout",
                                                                                "ocspRespTimeout",
                                                                                "getOcspRespTimeout",
                                                                                "setOcspRespTimeout");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("responder_url_lists", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("responder_url_lists",
                                                                                "responderUrlLists",
                                                                                "getResponderUrlLists",
                                                                                "setResponderUrlLists");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("url_action", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("url_action",
                                                                                "urlAction",
                                                                                "getUrlAction",
                                                                                "setUrlAction");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.ALBOCSP_config",
                                                            fields,
                                                            com.vmware.nsx_policy.model.ALBOCSPConfig.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

