/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Advanced load balancer RateLimiter object
 */
public final class ALBRateLimiter implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Long burstSz;

    private java.lang.Long count;

    private java.lang.String name;

    private java.lang.Long period;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBRateLimiter() {
    }

    protected ALBRateLimiter(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Maximum number of connections, requests or packets to be let through
     * instantaneously. If this is less than count, it will have no effect. Allowed
     * values are 0-1000000000. Default value when not specified in API or module is
     * interpreted by ALB Controller as 0. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getBurstSz() {
        return this.burstSz;
    }

    /**
     * Maximum number of connections, requests or packets to be let through
     * instantaneously. If this is less than count, it will have no effect. Allowed
     * values are 0-1000000000. Default value when not specified in API or module is
     * interpreted by ALB Controller as 0. format: int64
     *
     * @param burstSz New value for the property.
     */
    public void setBurstSz(java.lang.Long burstSz) {
        this.burstSz = burstSz;
    }

    /**
     * Maximum number of connections, requests or packets permitted each period.
     * Allowed values are 1-1000000000. Default value when not specified in API or
     * module is interpreted by ALB Controller as 1000000000. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCount() {
        return this.count;
    }

    /**
     * Maximum number of connections, requests or packets permitted each period.
     * Allowed values are 1-1000000000. Default value when not specified in API or
     * module is interpreted by ALB Controller as 1000000000. format: int64
     *
     * @param count New value for the property.
     */
    public void setCount(java.lang.Long count) {
        this.count = count;
    }

    /**
     * Identifier for Rate Limit. Constructed according to context.
     *
     * @return The current value of the property.
     */
    public java.lang.String getName() {
        return this.name;
    }

    /**
     * Identifier for Rate Limit. Constructed according to context.
     *
     * @param name New value for the property.
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }

    /**
     * Time value in seconds to enforce rate count. Allowed values are 1-1000000000.
     * Unit is SEC. Default value when not specified in API or module is interpreted by
     * ALB Controller as 1. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getPeriod() {
        return this.period;
    }

    /**
     * Time value in seconds to enforce rate count. Allowed values are 1-1000000000.
     * Unit is SEC. Default value when not specified in API or module is interpreted by
     * ALB Controller as 1. format: int64
     *
     * @param period New value for the property.
     */
    public void setPeriod(java.lang.Long period) {
        this.period = period;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBRateLimiter;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("burst_sz",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.burstSz, this._getType().getField("burst_sz")));
        structValue.setField("count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.count, this._getType().getField("count")));
        structValue.setField("name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.name, this._getType().getField("name")));
        structValue.setField("period",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.period, this._getType().getField("period")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBRateLimiter;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.ALBRateLimiter.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBRateLimiter _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBRateLimiter(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBRateLimiter _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBRateLimiter(structValue);
    }

    /**
     * Builder class for {@link ALBRateLimiter}.
     */
    public static final class Builder {
        private java.lang.Long burstSz;
        private java.lang.Long count;
        private java.lang.String name;
        private java.lang.Long period;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBRateLimiter}.
         */
        public Builder() {
        }

        /**
         * Maximum number of connections, requests or packets to be let through
         * instantaneously. If this is less than count, it will have no effect. Allowed
         * values are 0-1000000000. Default value when not specified in API or module is
         * interpreted by ALB Controller as 0. format: int64
         *
         * @param burstSz New value for the property.
         */
        public Builder setBurstSz(java.lang.Long burstSz) {
            this.burstSz = burstSz;
            return this;
        }

        /**
         * Maximum number of connections, requests or packets permitted each period.
         * Allowed values are 1-1000000000. Default value when not specified in API or
         * module is interpreted by ALB Controller as 1000000000. format: int64
         *
         * @param count New value for the property.
         */
        public Builder setCount(java.lang.Long count) {
            this.count = count;
            return this;
        }

        /**
         * Identifier for Rate Limit. Constructed according to context.
         *
         * @param name New value for the property.
         */
        public Builder setName(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Time value in seconds to enforce rate count. Allowed values are 1-1000000000.
         * Unit is SEC. Default value when not specified in API or module is interpreted by
         * ALB Controller as 1. format: int64
         *
         * @param period New value for the property.
         */
        public Builder setPeriod(java.lang.Long period) {
            this.period = period;
            return this;
        }

        public ALBRateLimiter build() {
            ALBRateLimiter result = new ALBRateLimiter();
            result.setBurstSz(this.burstSz);
            result.setCount(this.count);
            result.setName(this.name);
            result.setPeriod(this.period);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("burst_sz", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("burst_sz",
                                                                                "burstSz",
                                                                                "getBurstSz",
                                                                                "setBurstSz");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("count",
                                                                                "count",
                                                                                "getCount",
                                                                                "setCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("name",
                                                                                "name",
                                                                                "getName",
                                                                                "setName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("period", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("period",
                                                                                "period",
                                                                                "getPeriod",
                                                                                "setPeriod");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.ALB_rate_limiter",
                                                            fields,
                                                            com.vmware.nsx_policy.model.ALBRateLimiter.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

