/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Advanced load balancer SAMLSPConfig object
 */
public final class ALBSAMLSPConfig implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String cookieName;

    private java.lang.Long cookieTimeout;

    private java.lang.String entityId;

    private java.util.List<com.vmware.nsx_policy.model.ALBHttpCookiePersistenceKey> key;

    private java.lang.String signingSslKeyAndCertificatePath;

    private java.lang.String singleSignonUrl;

    private java.lang.String spMetadata;

    private java.lang.Boolean useIdpSessionTimeout;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBSAMLSPConfig() {
    }

    protected ALBSAMLSPConfig(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * HTTP cookie name for authenticated session.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCookieName() {
        return this.cookieName;
    }

    /**
     * HTTP cookie name for authenticated session.
     *
     * @param cookieName New value for the property.
     */
    public void setCookieName(java.lang.String cookieName) {
        this.cookieName = cookieName;
    }

    /**
     * Cookie timeout in minutes. Allowed values are 1-1440. Unit is MIN. Default value
     * when not specified in API or module is interpreted by ALB Controller as 60.
     * format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCookieTimeout() {
        return this.cookieTimeout;
    }

    /**
     * Cookie timeout in minutes. Allowed values are 1-1440. Unit is MIN. Default value
     * when not specified in API or module is interpreted by ALB Controller as 60.
     * format: int64
     *
     * @param cookieTimeout New value for the property.
     */
    public void setCookieTimeout(java.lang.Long cookieTimeout) {
        this.cookieTimeout = cookieTimeout;
    }

    /**
     * Globally unique SAML entityID for this node. The SAML application entity ID on
     * the IDP should match this.
     *
     * @return The current value of the property.
     */
    public java.lang.String getEntityId() {
        return this.entityId;
    }

    /**
     * Globally unique SAML entityID for this node. The SAML application entity ID on
     * the IDP should match this.
     *
     * @param entityId New value for the property.
     */
    public void setEntityId(java.lang.String entityId) {
        this.entityId = entityId;
    }

    /**
     * Key to generate the cookie.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.ALBHttpCookiePersistenceKey> getKey() {
        return this.key;
    }

    /**
     * Key to generate the cookie.
     *
     * @param key New value for the property.
     */
    public void setKey(java.util.List<com.vmware.nsx_policy.model.ALBHttpCookiePersistenceKey> key) {
        this.key = key;
    }

    /**
     * SP will use this SSL certificate to sign requests going to the IdP and decrypt
     * the assertions coming from IdP. It is a reference to an object of type
     * SSLKeyAndCertificate.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSigningSslKeyAndCertificatePath() {
        return this.signingSslKeyAndCertificatePath;
    }

    /**
     * SP will use this SSL certificate to sign requests going to the IdP and decrypt
     * the assertions coming from IdP. It is a reference to an object of type
     * SSLKeyAndCertificate.
     *
     * @param signingSslKeyAndCertificatePath New value for the property.
     */
    public void setSigningSslKeyAndCertificatePath(java.lang.String signingSslKeyAndCertificatePath) {
        this.signingSslKeyAndCertificatePath = signingSslKeyAndCertificatePath;
    }

    /**
     * SAML Single Signon URL to be programmed on the IDP.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSingleSignonUrl() {
        return this.singleSignonUrl;
    }

    /**
     * SAML Single Signon URL to be programmed on the IDP.
     *
     * @param singleSignonUrl New value for the property.
     */
    public void setSingleSignonUrl(java.lang.String singleSignonUrl) {
        this.singleSignonUrl = singleSignonUrl;
    }

    /**
     * SAML SP metadata for this application.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSpMetadata() {
        return this.spMetadata;
    }

    /**
     * SAML SP metadata for this application.
     *
     * @param spMetadata New value for the property.
     */
    public void setSpMetadata(java.lang.String spMetadata) {
        this.spMetadata = spMetadata;
    }

    /**
     * By enabling this field IdP can control how long the SP session can exist through
     * the SessionNotOnOrAfter field in the AuthNStatement of SAML Response.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getUseIdpSessionTimeout() {
        return this.useIdpSessionTimeout;
    }

    /**
     * By enabling this field IdP can control how long the SP session can exist through
     * the SessionNotOnOrAfter field in the AuthNStatement of SAML Response.
     *
     * @param useIdpSessionTimeout New value for the property.
     */
    public void setUseIdpSessionTimeout(java.lang.Boolean useIdpSessionTimeout) {
        this.useIdpSessionTimeout = useIdpSessionTimeout;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBSAMLSPConfig;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("cookie_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.cookieName, this._getType().getField("cookie_name")));
        structValue.setField("cookie_timeout",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.cookieTimeout, this._getType().getField("cookie_timeout")));
        structValue.setField("entity_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.entityId, this._getType().getField("entity_id")));
        structValue.setField("key",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.key, this._getType().getField("key")));
        structValue.setField("signing_ssl_key_and_certificate_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.signingSslKeyAndCertificatePath, this._getType().getField("signing_ssl_key_and_certificate_path")));
        structValue.setField("single_signon_url",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.singleSignonUrl, this._getType().getField("single_signon_url")));
        structValue.setField("sp_metadata",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.spMetadata, this._getType().getField("sp_metadata")));
        structValue.setField("use_idp_session_timeout",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.useIdpSessionTimeout, this._getType().getField("use_idp_session_timeout")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBSAMLSPConfig;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.ALBSAMLSPConfig.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBSAMLSPConfig _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBSAMLSPConfig(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBSAMLSPConfig _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBSAMLSPConfig(structValue);
    }

    /**
     * Builder class for {@link ALBSAMLSPConfig}.
     */
    public static final class Builder {
        private java.lang.String cookieName;
        private java.lang.Long cookieTimeout;
        private java.lang.String entityId;
        private java.util.List<com.vmware.nsx_policy.model.ALBHttpCookiePersistenceKey> key;
        private java.lang.String signingSslKeyAndCertificatePath;
        private java.lang.String singleSignonUrl;
        private java.lang.String spMetadata;
        private java.lang.Boolean useIdpSessionTimeout;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBSAMLSPConfig}.
         */
        public Builder() {
        }

        /**
         * HTTP cookie name for authenticated session.
         *
         * @param cookieName New value for the property.
         */
        public Builder setCookieName(java.lang.String cookieName) {
            this.cookieName = cookieName;
            return this;
        }

        /**
         * Cookie timeout in minutes. Allowed values are 1-1440. Unit is MIN. Default value
         * when not specified in API or module is interpreted by ALB Controller as 60.
         * format: int64
         *
         * @param cookieTimeout New value for the property.
         */
        public Builder setCookieTimeout(java.lang.Long cookieTimeout) {
            this.cookieTimeout = cookieTimeout;
            return this;
        }

        /**
         * Globally unique SAML entityID for this node. The SAML application entity ID on
         * the IDP should match this.
         *
         * @param entityId New value for the property.
         */
        public Builder setEntityId(java.lang.String entityId) {
            this.entityId = entityId;
            return this;
        }

        /**
         * Key to generate the cookie.
         *
         * @param key New value for the property.
         */
        public Builder setKey(java.util.List<com.vmware.nsx_policy.model.ALBHttpCookiePersistenceKey> key) {
            this.key = key;
            return this;
        }

        /**
         * SP will use this SSL certificate to sign requests going to the IdP and decrypt
         * the assertions coming from IdP. It is a reference to an object of type
         * SSLKeyAndCertificate.
         *
         * @param signingSslKeyAndCertificatePath New value for the property.
         */
        public Builder setSigningSslKeyAndCertificatePath(java.lang.String signingSslKeyAndCertificatePath) {
            this.signingSslKeyAndCertificatePath = signingSslKeyAndCertificatePath;
            return this;
        }

        /**
         * SAML Single Signon URL to be programmed on the IDP.
         *
         * @param singleSignonUrl New value for the property.
         */
        public Builder setSingleSignonUrl(java.lang.String singleSignonUrl) {
            this.singleSignonUrl = singleSignonUrl;
            return this;
        }

        /**
         * SAML SP metadata for this application.
         *
         * @param spMetadata New value for the property.
         */
        public Builder setSpMetadata(java.lang.String spMetadata) {
            this.spMetadata = spMetadata;
            return this;
        }

        /**
         * By enabling this field IdP can control how long the SP session can exist through
         * the SessionNotOnOrAfter field in the AuthNStatement of SAML Response.
         *
         * @param useIdpSessionTimeout New value for the property.
         */
        public Builder setUseIdpSessionTimeout(java.lang.Boolean useIdpSessionTimeout) {
            this.useIdpSessionTimeout = useIdpSessionTimeout;
            return this;
        }

        public ALBSAMLSPConfig build() {
            ALBSAMLSPConfig result = new ALBSAMLSPConfig();
            result.setCookieName(this.cookieName);
            result.setCookieTimeout(this.cookieTimeout);
            result.setEntityId(this.entityId);
            result.setKey(this.key);
            result.setSigningSslKeyAndCertificatePath(this.signingSslKeyAndCertificatePath);
            result.setSingleSignonUrl(this.singleSignonUrl);
            result.setSpMetadata(this.spMetadata);
            result.setUseIdpSessionTimeout(this.useIdpSessionTimeout);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("cookie_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("cookie_name",
                                                                                "cookieName",
                                                                                "getCookieName",
                                                                                "setCookieName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("cookie_timeout", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("cookie_timeout",
                                                                                "cookieTimeout",
                                                                                "getCookieTimeout",
                                                                                "setCookieTimeout");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("entity_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("entity_id",
                                                                                "entityId",
                                                                                "getEntityId",
                                                                                "setEntityId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("key", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.ALBHttpCookiePersistenceKey; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("key",
                                                                                "key",
                                                                                "getKey",
                                                                                "setKey");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("signing_ssl_key_and_certificate_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("signing_ssl_key_and_certificate_path",
                                                                                "signingSslKeyAndCertificatePath",
                                                                                "getSigningSslKeyAndCertificatePath",
                                                                                "setSigningSslKeyAndCertificatePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("single_signon_url", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("single_signon_url",
                                                                                "singleSignonUrl",
                                                                                "getSingleSignonUrl",
                                                                                "setSingleSignonUrl");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("sp_metadata", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("sp_metadata",
                                                                                "spMetadata",
                                                                                "getSpMetadata",
                                                                                "setSpMetadata");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("use_idp_session_timeout", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("use_idp_session_timeout",
                                                                                "useIdpSessionTimeout",
                                                                                "getUseIdpSessionTimeout",
                                                                                "setUseIdpSessionTimeout");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.ALBSAMLSP_config",
                                                            fields,
                                                            com.vmware.nsx_policy.model.ALBSAMLSPConfig.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

