/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Advanced load balancer Server object
 */
public final class ALBServer implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String autoscalingGroupName;

    private java.lang.String availabilityZone;

    private java.lang.String description;

    private java.util.List<com.vmware.nsx_policy.model.ALBDiscoveredNetwork> discoveredNetworks;

    private java.lang.Boolean enabled;

    private java.lang.String externalOrchestrationId;

    private java.lang.String externalUuid;

    private java.lang.String hostname;

    private com.vmware.nsx_policy.model.ALBIpAddr ip;

    private java.lang.Boolean isStatic;

    private com.vmware.nsx_policy.model.ALBGeoLocation location;

    private java.lang.String macAddress;

    private java.lang.Long port;

    private java.lang.String prstHdrVal;

    private java.lang.Long ratio;

    private java.lang.Boolean resolveServerByDns;

    private java.lang.Boolean rewriteHostHeader;

    private java.lang.String serverNode;

    private java.lang.Boolean verifyNetwork;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBServer() {
    }

    protected ALBServer(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Name of autoscaling group this server belongs to. Allowed in Essentials edition,
     * Enterprise edition.
     *
     * @return The current value of the property.
     */
    public java.lang.String getAutoscalingGroupName() {
        return this.autoscalingGroupName;
    }

    /**
     * Name of autoscaling group this server belongs to. Allowed in Essentials edition,
     * Enterprise edition.
     *
     * @param autoscalingGroupName New value for the property.
     */
    public void setAutoscalingGroupName(java.lang.String autoscalingGroupName) {
        this.autoscalingGroupName = autoscalingGroupName;
    }

    /**
     * Availability-zone of the server VM.
     *
     * @return The current value of the property.
     */
    public java.lang.String getAvailabilityZone() {
        return this.availabilityZone;
    }

    /**
     * Availability-zone of the server VM.
     *
     * @param availabilityZone New value for the property.
     */
    public void setAvailabilityZone(java.lang.String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    /**
     * A description of the Server.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDescription() {
        return this.description;
    }

    /**
     * A description of the Server.
     *
     * @param description New value for the property.
     */
    public void setDescription(java.lang.String description) {
        this.description = description;
    }

    /**
     * (internal-use) Discovered networks providing reachability for server IP. This
     * field is used internally by Avi, not editable by the user.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.ALBDiscoveredNetwork> getDiscoveredNetworks() {
        return this.discoveredNetworks;
    }

    /**
     * (internal-use) Discovered networks providing reachability for server IP. This
     * field is used internally by Avi, not editable by the user.
     *
     * @param discoveredNetworks New value for the property.
     */
    public void setDiscoveredNetworks(java.util.List<com.vmware.nsx_policy.model.ALBDiscoveredNetwork> discoveredNetworks) {
        this.discoveredNetworks = discoveredNetworks;
    }

    /**
     * Enable, Disable or Graceful Disable determine if new or existing connections to
     * the server are allowed. Default value when not specified in API or module is
     * interpreted by ALB Controller as true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnabled() {
        return this.enabled;
    }

    /**
     * Enable, Disable or Graceful Disable determine if new or existing connections to
     * the server are allowed. Default value when not specified in API or module is
     * interpreted by ALB Controller as true.
     *
     * @param enabled New value for the property.
     */
    public void setEnabled(java.lang.Boolean enabled) {
        this.enabled = enabled;
    }

    /**
     * UID of server in external orchestration systems.
     *
     * @return The current value of the property.
     */
    public java.lang.String getExternalOrchestrationId() {
        return this.externalOrchestrationId;
    }

    /**
     * UID of server in external orchestration systems.
     *
     * @param externalOrchestrationId New value for the property.
     */
    public void setExternalOrchestrationId(java.lang.String externalOrchestrationId) {
        this.externalOrchestrationId = externalOrchestrationId;
    }

    /**
     * UUID identifying VM in OpenStack and other external compute.
     *
     * @return The current value of the property.
     */
    public java.lang.String getExternalUuid() {
        return this.externalUuid;
    }

    /**
     * UUID identifying VM in OpenStack and other external compute.
     *
     * @param externalUuid New value for the property.
     */
    public void setExternalUuid(java.lang.String externalUuid) {
        this.externalUuid = externalUuid;
    }

    /**
     * DNS resolvable name of the server. May be used in place of the IP address.
     *
     * @return The current value of the property.
     */
    public java.lang.String getHostname() {
        return this.hostname;
    }

    /**
     * DNS resolvable name of the server. May be used in place of the IP address.
     *
     * @param hostname New value for the property.
     */
    public void setHostname(java.lang.String hostname) {
        this.hostname = hostname;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.ALBIpAddr getIp() {
        return this.ip;
    }

    /**
     *
     *
     * @param ip New value for the property.
     */
    public void setIp(com.vmware.nsx_policy.model.ALBIpAddr ip) {
        this.ip = ip;
    }

    /**
     * If statically learned. Default value when not specified in API or module is
     * interpreted by ALB Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getIsStatic() {
        return this.isStatic;
    }

    /**
     * If statically learned. Default value when not specified in API or module is
     * interpreted by ALB Controller as false.
     *
     * @param isStatic New value for the property.
     */
    public void setIsStatic(java.lang.Boolean isStatic) {
        this.isStatic = isStatic;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.ALBGeoLocation getLocation() {
        return this.location;
    }

    /**
     *
     *
     * @param location New value for the property.
     */
    public void setLocation(com.vmware.nsx_policy.model.ALBGeoLocation location) {
        this.location = location;
    }

    /**
     * MAC address of server.
     *
     * @return The current value of the property.
     */
    public java.lang.String getMacAddress() {
        return this.macAddress;
    }

    /**
     * MAC address of server.
     *
     * @param macAddress New value for the property.
     */
    public void setMacAddress(java.lang.String macAddress) {
        this.macAddress = macAddress;
    }

    /**
     * Optionally specify the servers port number. This will override the pool's
     * default server port attribute. Allowed values are 1-65535. Special values are 0-
     * 'use backend port in pool'. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getPort() {
        return this.port;
    }

    /**
     * Optionally specify the servers port number. This will override the pool's
     * default server port attribute. Allowed values are 1-65535. Special values are 0-
     * 'use backend port in pool'. format: int64
     *
     * @param port New value for the property.
     */
    public void setPort(java.lang.Long port) {
        this.port = port;
    }

    /**
     * Header value for custom header persistence.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPrstHdrVal() {
        return this.prstHdrVal;
    }

    /**
     * Header value for custom header persistence.
     *
     * @param prstHdrVal New value for the property.
     */
    public void setPrstHdrVal(java.lang.String prstHdrVal) {
        this.prstHdrVal = prstHdrVal;
    }

    /**
     * Ratio of selecting eligible servers in the pool. Allowed values are 1-20.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as 1. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRatio() {
        return this.ratio;
    }

    /**
     * Ratio of selecting eligible servers in the pool. Allowed values are 1-20.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as 1. format: int64
     *
     * @param ratio New value for the property.
     */
    public void setRatio(java.lang.Long ratio) {
        this.ratio = ratio;
    }

    /**
     * Auto resolve server's IP using DNS name. Allowed in Basic(Allowed values- false)
     * edition, Essentials(Allowed values- false) edition, Enterprise edition. Default
     * value when not specified in API or module is interpreted by ALB Controller as
     * false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getResolveServerByDns() {
        return this.resolveServerByDns;
    }

    /**
     * Auto resolve server's IP using DNS name. Allowed in Basic(Allowed values- false)
     * edition, Essentials(Allowed values- false) edition, Enterprise edition. Default
     * value when not specified in API or module is interpreted by ALB Controller as
     * false.
     *
     * @param resolveServerByDns New value for the property.
     */
    public void setResolveServerByDns(java.lang.Boolean resolveServerByDns) {
        this.resolveServerByDns = resolveServerByDns;
    }

    /**
     * Rewrite incoming Host Header to server name. Default value when not specified in
     * API or module is interpreted by ALB Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getRewriteHostHeader() {
        return this.rewriteHostHeader;
    }

    /**
     * Rewrite incoming Host Header to server name. Default value when not specified in
     * API or module is interpreted by ALB Controller as false.
     *
     * @param rewriteHostHeader New value for the property.
     */
    public void setRewriteHostHeader(java.lang.Boolean rewriteHostHeader) {
        this.rewriteHostHeader = rewriteHostHeader;
    }

    /**
     * Hostname of the node where the server VM or container resides.
     *
     * @return The current value of the property.
     */
    public java.lang.String getServerNode() {
        return this.serverNode;
    }

    /**
     * Hostname of the node where the server VM or container resides.
     *
     * @param serverNode New value for the property.
     */
    public void setServerNode(java.lang.String serverNode) {
        this.serverNode = serverNode;
    }

    /**
     * Verify server belongs to a discovered network or reachable via a discovered
     * network. Verify reachable network isn't the OpenStack management network.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getVerifyNetwork() {
        return this.verifyNetwork;
    }

    /**
     * Verify server belongs to a discovered network or reachable via a discovered
     * network. Verify reachable network isn't the OpenStack management network.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as false.
     *
     * @param verifyNetwork New value for the property.
     */
    public void setVerifyNetwork(java.lang.Boolean verifyNetwork) {
        this.verifyNetwork = verifyNetwork;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBServer;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("autoscaling_group_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.autoscalingGroupName, this._getType().getField("autoscaling_group_name")));
        structValue.setField("availability_zone",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.availabilityZone, this._getType().getField("availability_zone")));
        structValue.setField("description",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.description, this._getType().getField("description")));
        structValue.setField("discovered_networks",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.discoveredNetworks, this._getType().getField("discovered_networks")));
        structValue.setField("enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enabled, this._getType().getField("enabled")));
        structValue.setField("external_orchestration_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.externalOrchestrationId, this._getType().getField("external_orchestration_id")));
        structValue.setField("external_uuid",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.externalUuid, this._getType().getField("external_uuid")));
        structValue.setField("hostname",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.hostname, this._getType().getField("hostname")));
        structValue.setField("ip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ip, this._getType().getField("ip")));
        structValue.setField("is_static",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.isStatic, this._getType().getField("is_static")));
        structValue.setField("location",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.location, this._getType().getField("location")));
        structValue.setField("mac_address",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.macAddress, this._getType().getField("mac_address")));
        structValue.setField("port",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.port, this._getType().getField("port")));
        structValue.setField("prst_hdr_val",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.prstHdrVal, this._getType().getField("prst_hdr_val")));
        structValue.setField("ratio",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ratio, this._getType().getField("ratio")));
        structValue.setField("resolve_server_by_dns",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resolveServerByDns, this._getType().getField("resolve_server_by_dns")));
        structValue.setField("rewrite_host_header",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.rewriteHostHeader, this._getType().getField("rewrite_host_header")));
        structValue.setField("server_node",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serverNode, this._getType().getField("server_node")));
        structValue.setField("verify_network",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.verifyNetwork, this._getType().getField("verify_network")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBServer;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.ALBServer.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBServer _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBServer(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBServer _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBServer(structValue);
    }

    /**
     * Builder class for {@link ALBServer}.
     */
    public static final class Builder {
        private java.lang.String autoscalingGroupName;
        private java.lang.String availabilityZone;
        private java.lang.String description;
        private java.util.List<com.vmware.nsx_policy.model.ALBDiscoveredNetwork> discoveredNetworks;
        private java.lang.Boolean enabled;
        private java.lang.String externalOrchestrationId;
        private java.lang.String externalUuid;
        private java.lang.String hostname;
        private com.vmware.nsx_policy.model.ALBIpAddr ip;
        private java.lang.Boolean isStatic;
        private com.vmware.nsx_policy.model.ALBGeoLocation location;
        private java.lang.String macAddress;
        private java.lang.Long port;
        private java.lang.String prstHdrVal;
        private java.lang.Long ratio;
        private java.lang.Boolean resolveServerByDns;
        private java.lang.Boolean rewriteHostHeader;
        private java.lang.String serverNode;
        private java.lang.Boolean verifyNetwork;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBServer}.
         */
        public Builder() {
        }

        /**
         * Name of autoscaling group this server belongs to. Allowed in Essentials edition,
         * Enterprise edition.
         *
         * @param autoscalingGroupName New value for the property.
         */
        public Builder setAutoscalingGroupName(java.lang.String autoscalingGroupName) {
            this.autoscalingGroupName = autoscalingGroupName;
            return this;
        }

        /**
         * Availability-zone of the server VM.
         *
         * @param availabilityZone New value for the property.
         */
        public Builder setAvailabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * A description of the Server.
         *
         * @param description New value for the property.
         */
        public Builder setDescription(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * (internal-use) Discovered networks providing reachability for server IP. This
         * field is used internally by Avi, not editable by the user.
         *
         * @param discoveredNetworks New value for the property.
         */
        public Builder setDiscoveredNetworks(java.util.List<com.vmware.nsx_policy.model.ALBDiscoveredNetwork> discoveredNetworks) {
            this.discoveredNetworks = discoveredNetworks;
            return this;
        }

        /**
         * Enable, Disable or Graceful Disable determine if new or existing connections to
         * the server are allowed. Default value when not specified in API or module is
         * interpreted by ALB Controller as true.
         *
         * @param enabled New value for the property.
         */
        public Builder setEnabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * UID of server in external orchestration systems.
         *
         * @param externalOrchestrationId New value for the property.
         */
        public Builder setExternalOrchestrationId(java.lang.String externalOrchestrationId) {
            this.externalOrchestrationId = externalOrchestrationId;
            return this;
        }

        /**
         * UUID identifying VM in OpenStack and other external compute.
         *
         * @param externalUuid New value for the property.
         */
        public Builder setExternalUuid(java.lang.String externalUuid) {
            this.externalUuid = externalUuid;
            return this;
        }

        /**
         * DNS resolvable name of the server. May be used in place of the IP address.
         *
         * @param hostname New value for the property.
         */
        public Builder setHostname(java.lang.String hostname) {
            this.hostname = hostname;
            return this;
        }

        /**
         *
         *
         * @param ip New value for the property.
         */
        public Builder setIp(com.vmware.nsx_policy.model.ALBIpAddr ip) {
            this.ip = ip;
            return this;
        }

        /**
         * If statically learned. Default value when not specified in API or module is
         * interpreted by ALB Controller as false.
         *
         * @param isStatic New value for the property.
         */
        public Builder setIsStatic(java.lang.Boolean isStatic) {
            this.isStatic = isStatic;
            return this;
        }

        /**
         *
         *
         * @param location New value for the property.
         */
        public Builder setLocation(com.vmware.nsx_policy.model.ALBGeoLocation location) {
            this.location = location;
            return this;
        }

        /**
         * MAC address of server.
         *
         * @param macAddress New value for the property.
         */
        public Builder setMacAddress(java.lang.String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        /**
         * Optionally specify the servers port number. This will override the pool's
         * default server port attribute. Allowed values are 1-65535. Special values are 0-
         * 'use backend port in pool'. format: int64
         *
         * @param port New value for the property.
         */
        public Builder setPort(java.lang.Long port) {
            this.port = port;
            return this;
        }

        /**
         * Header value for custom header persistence.
         *
         * @param prstHdrVal New value for the property.
         */
        public Builder setPrstHdrVal(java.lang.String prstHdrVal) {
            this.prstHdrVal = prstHdrVal;
            return this;
        }

        /**
         * Ratio of selecting eligible servers in the pool. Allowed values are 1-20.
         * Default value when not specified in API or module is interpreted by ALB
         * Controller as 1. format: int64
         *
         * @param ratio New value for the property.
         */
        public Builder setRatio(java.lang.Long ratio) {
            this.ratio = ratio;
            return this;
        }

        /**
         * Auto resolve server's IP using DNS name. Allowed in Basic(Allowed values- false)
         * edition, Essentials(Allowed values- false) edition, Enterprise edition. Default
         * value when not specified in API or module is interpreted by ALB Controller as
         * false.
         *
         * @param resolveServerByDns New value for the property.
         */
        public Builder setResolveServerByDns(java.lang.Boolean resolveServerByDns) {
            this.resolveServerByDns = resolveServerByDns;
            return this;
        }

        /**
         * Rewrite incoming Host Header to server name. Default value when not specified in
         * API or module is interpreted by ALB Controller as false.
         *
         * @param rewriteHostHeader New value for the property.
         */
        public Builder setRewriteHostHeader(java.lang.Boolean rewriteHostHeader) {
            this.rewriteHostHeader = rewriteHostHeader;
            return this;
        }

        /**
         * Hostname of the node where the server VM or container resides.
         *
         * @param serverNode New value for the property.
         */
        public Builder setServerNode(java.lang.String serverNode) {
            this.serverNode = serverNode;
            return this;
        }

        /**
         * Verify server belongs to a discovered network or reachable via a discovered
         * network. Verify reachable network isn't the OpenStack management network.
         * Default value when not specified in API or module is interpreted by ALB
         * Controller as false.
         *
         * @param verifyNetwork New value for the property.
         */
        public Builder setVerifyNetwork(java.lang.Boolean verifyNetwork) {
            this.verifyNetwork = verifyNetwork;
            return this;
        }

        public ALBServer build() {
            ALBServer result = new ALBServer();
            result.setAutoscalingGroupName(this.autoscalingGroupName);
            result.setAvailabilityZone(this.availabilityZone);
            result.setDescription(this.description);
            result.setDiscoveredNetworks(this.discoveredNetworks);
            result.setEnabled(this.enabled);
            result.setExternalOrchestrationId(this.externalOrchestrationId);
            result.setExternalUuid(this.externalUuid);
            result.setHostname(this.hostname);
            result.setIp(this.ip);
            result.setIsStatic(this.isStatic);
            result.setLocation(this.location);
            result.setMacAddress(this.macAddress);
            result.setPort(this.port);
            result.setPrstHdrVal(this.prstHdrVal);
            result.setRatio(this.ratio);
            result.setResolveServerByDns(this.resolveServerByDns);
            result.setRewriteHostHeader(this.rewriteHostHeader);
            result.setServerNode(this.serverNode);
            result.setVerifyNetwork(this.verifyNetwork);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("autoscaling_group_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("autoscaling_group_name",
                                                                                "autoscalingGroupName",
                                                                                "getAutoscalingGroupName",
                                                                                "setAutoscalingGroupName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("availability_zone", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("availability_zone",
                                                                                "availabilityZone",
                                                                                "getAvailabilityZone",
                                                                                "setAvailabilityZone");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("description", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("description",
                                                                                "description",
                                                                                "getDescription",
                                                                                "setDescription");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("discovered_networks", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.ALBDiscoveredNetwork; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("discovered_networks",
                                                                                "discoveredNetworks",
                                                                                "getDiscoveredNetworks",
                                                                                "setDiscoveredNetworks");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enabled",
                                                                                "enabled",
                                                                                "getEnabled",
                                                                                "setEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("external_orchestration_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("external_orchestration_id",
                                                                                "externalOrchestrationId",
                                                                                "getExternalOrchestrationId",
                                                                                "setExternalOrchestrationId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("external_uuid", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("external_uuid",
                                                                                "externalUuid",
                                                                                "getExternalUuid",
                                                                                "setExternalUuid");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("hostname", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("hostname",
                                                                                "hostname",
                                                                                "getHostname",
                                                                                "setHostname");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.ALBIpAddr; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ip",
                                                                                "ip",
                                                                                "getIp",
                                                                                "setIp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("is_static", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("is_static",
                                                                                "isStatic",
                                                                                "getIsStatic",
                                                                                "setIsStatic");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("location", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.ALBGeoLocation; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("location",
                                                                                "location",
                                                                                "getLocation",
                                                                                "setLocation");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("mac_address", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("mac_address",
                                                                                "macAddress",
                                                                                "getMacAddress",
                                                                                "setMacAddress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("port", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("port",
                                                                                "port",
                                                                                "getPort",
                                                                                "setPort");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("prst_hdr_val", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("prst_hdr_val",
                                                                                "prstHdrVal",
                                                                                "getPrstHdrVal",
                                                                                "setPrstHdrVal");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ratio", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ratio",
                                                                                "ratio",
                                                                                "getRatio",
                                                                                "setRatio");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resolve_server_by_dns", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resolve_server_by_dns",
                                                                                "resolveServerByDns",
                                                                                "getResolveServerByDns",
                                                                                "setResolveServerByDns");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("rewrite_host_header", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("rewrite_host_header",
                                                                                "rewriteHostHeader",
                                                                                "getRewriteHostHeader",
                                                                                "setRewriteHostHeader");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("server_node", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("server_node",
                                                                                "serverNode",
                                                                                "getServerNode",
                                                                                "setServerNode");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("verify_network", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("verify_network",
                                                                                "verifyNetwork",
                                                                                "getVerifyNetwork",
                                                                                "setVerifyNetwork");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.ALB_server",
                                                            fields,
                                                            com.vmware.nsx_policy.model.ALBServer.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

