/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Advanced load balancer StreamingSyslogConfig object
 */
public final class ALBStreamingSyslogConfig implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Long facility;

    private java.lang.Long filteredLogSeverity;

    private java.lang.String hostname;

    private java.lang.Long nonSignificantLogSeverity;

    private java.lang.Long significantLogSeverity;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBStreamingSyslogConfig() {
    }

    protected ALBStreamingSyslogConfig(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Facility value, as defined in RFC5424, must be between 0 and 23 inclusive.
     * Allowed values are 0-23. Default value when not specified in API or module is
     * interpreted by ALB Controller as 16. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getFacility() {
        return this.facility;
    }

    /**
     * Facility value, as defined in RFC5424, must be between 0 and 23 inclusive.
     * Allowed values are 0-23. Default value when not specified in API or module is
     * interpreted by ALB Controller as 16. format: int64
     *
     * @param facility New value for the property.
     */
    public void setFacility(java.lang.Long facility) {
        this.facility = facility;
    }

    /**
     * Severity code, as defined in RFC5424, for filtered logs. This must be between 0
     * and 7 inclusive. Allowed values are 0-7. Default value when not specified in API
     * or module is interpreted by ALB Controller as 5. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getFilteredLogSeverity() {
        return this.filteredLogSeverity;
    }

    /**
     * Severity code, as defined in RFC5424, for filtered logs. This must be between 0
     * and 7 inclusive. Allowed values are 0-7. Default value when not specified in API
     * or module is interpreted by ALB Controller as 5. format: int64
     *
     * @param filteredLogSeverity New value for the property.
     */
    public void setFilteredLogSeverity(java.lang.Long filteredLogSeverity) {
        this.filteredLogSeverity = filteredLogSeverity;
    }

    /**
     * String to use as the hostname in the syslog messages. This string can contain
     * only printable ASCII characters (hex 21 to hex 7E; no space allowed). Default
     * value when not specified in API or module is interpreted by ALB Controller as
     * AviVantage.
     *
     * @return The current value of the property.
     */
    public java.lang.String getHostname() {
        return this.hostname;
    }

    /**
     * String to use as the hostname in the syslog messages. This string can contain
     * only printable ASCII characters (hex 21 to hex 7E; no space allowed). Default
     * value when not specified in API or module is interpreted by ALB Controller as
     * AviVantage.
     *
     * @param hostname New value for the property.
     */
    public void setHostname(java.lang.String hostname) {
        this.hostname = hostname;
    }

    /**
     * Severity code, as defined in RFC5424, for non-significant logs. This must be
     * between 0 and 7 inclusive. Allowed values are 0-7. Default value when not
     * specified in API or module is interpreted by ALB Controller as 6. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getNonSignificantLogSeverity() {
        return this.nonSignificantLogSeverity;
    }

    /**
     * Severity code, as defined in RFC5424, for non-significant logs. This must be
     * between 0 and 7 inclusive. Allowed values are 0-7. Default value when not
     * specified in API or module is interpreted by ALB Controller as 6. format: int64
     *
     * @param nonSignificantLogSeverity New value for the property.
     */
    public void setNonSignificantLogSeverity(java.lang.Long nonSignificantLogSeverity) {
        this.nonSignificantLogSeverity = nonSignificantLogSeverity;
    }

    /**
     * Severity code, as defined in RFC5424, for significant logs. This must be between
     * 0 and 7 inclusive. Allowed values are 0-7. Default value when not specified in
     * API or module is interpreted by ALB Controller as 4. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getSignificantLogSeverity() {
        return this.significantLogSeverity;
    }

    /**
     * Severity code, as defined in RFC5424, for significant logs. This must be between
     * 0 and 7 inclusive. Allowed values are 0-7. Default value when not specified in
     * API or module is interpreted by ALB Controller as 4. format: int64
     *
     * @param significantLogSeverity New value for the property.
     */
    public void setSignificantLogSeverity(java.lang.Long significantLogSeverity) {
        this.significantLogSeverity = significantLogSeverity;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBStreamingSyslogConfig;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("facility",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.facility, this._getType().getField("facility")));
        structValue.setField("filtered_log_severity",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.filteredLogSeverity, this._getType().getField("filtered_log_severity")));
        structValue.setField("hostname",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.hostname, this._getType().getField("hostname")));
        structValue.setField("non_significant_log_severity",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nonSignificantLogSeverity, this._getType().getField("non_significant_log_severity")));
        structValue.setField("significant_log_severity",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.significantLogSeverity, this._getType().getField("significant_log_severity")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBStreamingSyslogConfig;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.ALBStreamingSyslogConfig.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBStreamingSyslogConfig _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBStreamingSyslogConfig(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBStreamingSyslogConfig _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBStreamingSyslogConfig(structValue);
    }

    /**
     * Builder class for {@link ALBStreamingSyslogConfig}.
     */
    public static final class Builder {
        private java.lang.Long facility;
        private java.lang.Long filteredLogSeverity;
        private java.lang.String hostname;
        private java.lang.Long nonSignificantLogSeverity;
        private java.lang.Long significantLogSeverity;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBStreamingSyslogConfig}.
         */
        public Builder() {
        }

        /**
         * Facility value, as defined in RFC5424, must be between 0 and 23 inclusive.
         * Allowed values are 0-23. Default value when not specified in API or module is
         * interpreted by ALB Controller as 16. format: int64
         *
         * @param facility New value for the property.
         */
        public Builder setFacility(java.lang.Long facility) {
            this.facility = facility;
            return this;
        }

        /**
         * Severity code, as defined in RFC5424, for filtered logs. This must be between 0
         * and 7 inclusive. Allowed values are 0-7. Default value when not specified in API
         * or module is interpreted by ALB Controller as 5. format: int64
         *
         * @param filteredLogSeverity New value for the property.
         */
        public Builder setFilteredLogSeverity(java.lang.Long filteredLogSeverity) {
            this.filteredLogSeverity = filteredLogSeverity;
            return this;
        }

        /**
         * String to use as the hostname in the syslog messages. This string can contain
         * only printable ASCII characters (hex 21 to hex 7E; no space allowed). Default
         * value when not specified in API or module is interpreted by ALB Controller as
         * AviVantage.
         *
         * @param hostname New value for the property.
         */
        public Builder setHostname(java.lang.String hostname) {
            this.hostname = hostname;
            return this;
        }

        /**
         * Severity code, as defined in RFC5424, for non-significant logs. This must be
         * between 0 and 7 inclusive. Allowed values are 0-7. Default value when not
         * specified in API or module is interpreted by ALB Controller as 6. format: int64
         *
         * @param nonSignificantLogSeverity New value for the property.
         */
        public Builder setNonSignificantLogSeverity(java.lang.Long nonSignificantLogSeverity) {
            this.nonSignificantLogSeverity = nonSignificantLogSeverity;
            return this;
        }

        /**
         * Severity code, as defined in RFC5424, for significant logs. This must be between
         * 0 and 7 inclusive. Allowed values are 0-7. Default value when not specified in
         * API or module is interpreted by ALB Controller as 4. format: int64
         *
         * @param significantLogSeverity New value for the property.
         */
        public Builder setSignificantLogSeverity(java.lang.Long significantLogSeverity) {
            this.significantLogSeverity = significantLogSeverity;
            return this;
        }

        public ALBStreamingSyslogConfig build() {
            ALBStreamingSyslogConfig result = new ALBStreamingSyslogConfig();
            result.setFacility(this.facility);
            result.setFilteredLogSeverity(this.filteredLogSeverity);
            result.setHostname(this.hostname);
            result.setNonSignificantLogSeverity(this.nonSignificantLogSeverity);
            result.setSignificantLogSeverity(this.significantLogSeverity);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("facility", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("facility",
                                                                                "facility",
                                                                                "getFacility",
                                                                                "setFacility");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("filtered_log_severity", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("filtered_log_severity",
                                                                                "filteredLogSeverity",
                                                                                "getFilteredLogSeverity",
                                                                                "setFilteredLogSeverity");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("hostname", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("hostname",
                                                                                "hostname",
                                                                                "getHostname",
                                                                                "setHostname");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("non_significant_log_severity", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("non_significant_log_severity",
                                                                                "nonSignificantLogSeverity",
                                                                                "getNonSignificantLogSeverity",
                                                                                "setNonSignificantLogSeverity");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("significant_log_severity", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("significant_log_severity",
                                                                                "significantLogSeverity",
                                                                                "getSignificantLogSeverity",
                                                                                "setSignificantLogSeverity");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.ALB_streaming_syslog_config",
                                                            fields,
                                                            com.vmware.nsx_policy.model.ALBStreamingSyslogConfig.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

