/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Advanced load balancer TCPProxyProfile object
 */
public final class ALBTCPProxyProfile implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String CC_ALGO_NEW_RENO = "CC_ALGO_NEW_RENO";

    public static final java.lang.String CC_ALGO_CUBIC = "CC_ALGO_CUBIC";

    public static final java.lang.String CC_ALGO_HTCP = "CC_ALGO_HTCP";

    public static final java.lang.String IDLE_CONNECTION_TYPE_KEEP_ALIVE = "KEEP_ALIVE";

    public static final java.lang.String IDLE_CONNECTION_TYPE_CLOSE_IDLE = "CLOSE_IDLE";

    private java.lang.Boolean aggressiveCongestionAvoidance;

    private java.lang.Boolean autoWindowGrowth;

    private java.lang.Boolean automatic;

    private java.lang.String ccAlgo;

    private java.lang.Long congestionRecoveryScalingFactor;

    private java.lang.Long idleConnectionTimeout;

    private java.lang.String idleConnectionType;

    private java.lang.Boolean ignoreTimeWait;

    private java.lang.Long ipDscp;

    private java.lang.Boolean keepaliveInHalfcloseState;

    private java.lang.Long maxRetransmissions;

    private java.lang.Long maxSegmentSize;

    private java.lang.Long maxSynRetransmissions;

    private java.lang.Long minRexmtTimeout;

    private java.lang.Boolean naglesAlgorithm;

    private java.lang.Long reassemblyQueueSize;

    private java.lang.Long receiveWindow;

    private java.lang.Long reorderThreshold;

    private java.lang.Long slowStartScalingFactor;

    private java.lang.Long timeWaitDelay;

    private java.lang.Boolean useInterfaceMtu;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBTCPProxyProfile() {
    }

    protected ALBTCPProxyProfile(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Controls the our congestion window to send, normally it's 1 mss, If this option
     * is turned on, we use 10 msses. Default value when not specified in API or module
     * is interpreted by ALB Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getAggressiveCongestionAvoidance() {
        return this.aggressiveCongestionAvoidance;
    }

    /**
     * Controls the our congestion window to send, normally it's 1 mss, If this option
     * is turned on, we use 10 msses. Default value when not specified in API or module
     * is interpreted by ALB Controller as false.
     *
     * @param aggressiveCongestionAvoidance New value for the property.
     */
    public void setAggressiveCongestionAvoidance(java.lang.Boolean aggressiveCongestionAvoidance) {
        this.aggressiveCongestionAvoidance = aggressiveCongestionAvoidance;
    }

    /**
     * Controls whether the windows are static or supports autogrowth. Maximum that it
     * can grow to is limited to 4MB. Default value when not specified in API or module
     * is interpreted by ALB Controller as true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getAutoWindowGrowth() {
        return this.autoWindowGrowth;
    }

    /**
     * Controls whether the windows are static or supports autogrowth. Maximum that it
     * can grow to is limited to 4MB. Default value when not specified in API or module
     * is interpreted by ALB Controller as true.
     *
     * @param autoWindowGrowth New value for the property.
     */
    public void setAutoWindowGrowth(java.lang.Boolean autoWindowGrowth) {
        this.autoWindowGrowth = autoWindowGrowth;
    }

    /**
     * Dynamically pick the relevant parameters for connections. Allowed in
     * Basic(Allowed values- true) edition, Enterprise edition. Default value when not
     * specified in API or module is interpreted by ALB Controller as true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getAutomatic() {
        return this.automatic;
    }

    /**
     * Dynamically pick the relevant parameters for connections. Allowed in
     * Basic(Allowed values- true) edition, Enterprise edition. Default value when not
     * specified in API or module is interpreted by ALB Controller as true.
     *
     * @param automatic New value for the property.
     */
    public void setAutomatic(java.lang.Boolean automatic) {
        this.automatic = automatic;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBTCPProxyProfile#CC_ALGO_NEW_RENO}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBTCPProxyProfile#CC_ALGO_CUBIC}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBTCPProxyProfile#CC_ALGO_HTCP}</li> </ul>
     * Controls the congestion control algorithm we use. Enum options -
     * CC_ALGO_NEW_RENO, CC_ALGO_CUBIC, CC_ALGO_HTCP. Default value when not specified
     * in API or module is interpreted by ALB Controller as CC_ALGO_NEW_RENO.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCcAlgo() {
        return this.ccAlgo;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBTCPProxyProfile#CC_ALGO_NEW_RENO}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBTCPProxyProfile#CC_ALGO_CUBIC}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBTCPProxyProfile#CC_ALGO_HTCP}</li> </ul>
     * Controls the congestion control algorithm we use. Enum options -
     * CC_ALGO_NEW_RENO, CC_ALGO_CUBIC, CC_ALGO_HTCP. Default value when not specified
     * in API or module is interpreted by ALB Controller as CC_ALGO_NEW_RENO.
     *
     * @param ccAlgo New value for the property.
     */
    public void setCcAlgo(java.lang.String ccAlgo) {
        this.ccAlgo = ccAlgo;
    }

    /**
     * Congestion window scaling factor after recovery. Allowed values are 0-8. Default
     * value when not specified in API or module is interpreted by ALB Controller as 2.
     * format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCongestionRecoveryScalingFactor() {
        return this.congestionRecoveryScalingFactor;
    }

    /**
     * Congestion window scaling factor after recovery. Allowed values are 0-8. Default
     * value when not specified in API or module is interpreted by ALB Controller as 2.
     * format: int64
     *
     * @param congestionRecoveryScalingFactor New value for the property.
     */
    public void setCongestionRecoveryScalingFactor(java.lang.Long congestionRecoveryScalingFactor) {
        this.congestionRecoveryScalingFactor = congestionRecoveryScalingFactor;
    }

    /**
     * The duration for keepalive probes or session idle timeout. Max value is 3600
     * seconds, min is 5. Set to 0 to allow infinite idle time. Allowed values are
     * 5-14400. Special values are 0 - 'infinite'. Unit is SEC. Default value when not
     * specified in API or module is interpreted by ALB Controller as 600. format:
     * int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getIdleConnectionTimeout() {
        return this.idleConnectionTimeout;
    }

    /**
     * The duration for keepalive probes or session idle timeout. Max value is 3600
     * seconds, min is 5. Set to 0 to allow infinite idle time. Allowed values are
     * 5-14400. Special values are 0 - 'infinite'. Unit is SEC. Default value when not
     * specified in API or module is interpreted by ALB Controller as 600. format:
     * int64
     *
     * @param idleConnectionTimeout New value for the property.
     */
    public void setIdleConnectionTimeout(java.lang.Long idleConnectionTimeout) {
        this.idleConnectionTimeout = idleConnectionTimeout;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBTCPProxyProfile#IDLE_CONNECTION_TYPE_KEEP_ALIVE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBTCPProxyProfile#IDLE_CONNECTION_TYPE_CLOSE_IDLE}</li>
     * </ul> Controls the behavior of idle connections. Enum options - KEEP_ALIVE,
     * CLOSE_IDLE. Default value when not specified in API or module is interpreted by
     * ALB Controller as KEEP_ALIVE.
     *
     * @return The current value of the property.
     */
    public java.lang.String getIdleConnectionType() {
        return this.idleConnectionType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBTCPProxyProfile#IDLE_CONNECTION_TYPE_KEEP_ALIVE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ALBTCPProxyProfile#IDLE_CONNECTION_TYPE_CLOSE_IDLE}</li>
     * </ul> Controls the behavior of idle connections. Enum options - KEEP_ALIVE,
     * CLOSE_IDLE. Default value when not specified in API or module is interpreted by
     * ALB Controller as KEEP_ALIVE.
     *
     * @param idleConnectionType New value for the property.
     */
    public void setIdleConnectionType(java.lang.String idleConnectionType) {
        this.idleConnectionType = idleConnectionType;
    }

    /**
     * A new SYN is accepted from the same 4-tuple even if there is already a
     * connection in TIME_WAIT state. This is equivalent of setting Time Wait Delay to
     * 0. Default value when not specified in API or module is interpreted by ALB
     * Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getIgnoreTimeWait() {
        return this.ignoreTimeWait;
    }

    /**
     * A new SYN is accepted from the same 4-tuple even if there is already a
     * connection in TIME_WAIT state. This is equivalent of setting Time Wait Delay to
     * 0. Default value when not specified in API or module is interpreted by ALB
     * Controller as false.
     *
     * @param ignoreTimeWait New value for the property.
     */
    public void setIgnoreTimeWait(java.lang.Boolean ignoreTimeWait) {
        this.ignoreTimeWait = ignoreTimeWait;
    }

    /**
     * Controls the value of the Differentiated Services Code Point field inserted in
     * the IP header. This has two options Set to a specific value, or Pass Through,
     * which uses the incoming DSCP value. Allowed values are 0-63. Special values are
     * MAX - 'Passthrough'. Default value when not specified in API or module is
     * interpreted by ALB Controller as 0. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getIpDscp() {
        return this.ipDscp;
    }

    /**
     * Controls the value of the Differentiated Services Code Point field inserted in
     * the IP header. This has two options Set to a specific value, or Pass Through,
     * which uses the incoming DSCP value. Allowed values are 0-63. Special values are
     * MAX - 'Passthrough'. Default value when not specified in API or module is
     * interpreted by ALB Controller as 0. format: int64
     *
     * @param ipDscp New value for the property.
     */
    public void setIpDscp(java.lang.Long ipDscp) {
        this.ipDscp = ipDscp;
    }

    /**
     * Controls whether to keep the connection alive with keepalive messages in the TCP
     * half close state. The interval for sending keepalive messages is 30s. If a
     * timeout is already configured in the network profile, this will not override it.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getKeepaliveInHalfcloseState() {
        return this.keepaliveInHalfcloseState;
    }

    /**
     * Controls whether to keep the connection alive with keepalive messages in the TCP
     * half close state. The interval for sending keepalive messages is 30s. If a
     * timeout is already configured in the network profile, this will not override it.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as true.
     *
     * @param keepaliveInHalfcloseState New value for the property.
     */
    public void setKeepaliveInHalfcloseState(java.lang.Boolean keepaliveInHalfcloseState) {
        this.keepaliveInHalfcloseState = keepaliveInHalfcloseState;
    }

    /**
     * The number of attempts at retransmit before closing the connection. Allowed
     * values are 3-8. Default value when not specified in API or module is interpreted
     * by ALB Controller as 8. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMaxRetransmissions() {
        return this.maxRetransmissions;
    }

    /**
     * The number of attempts at retransmit before closing the connection. Allowed
     * values are 3-8. Default value when not specified in API or module is interpreted
     * by ALB Controller as 8. format: int64
     *
     * @param maxRetransmissions New value for the property.
     */
    public void setMaxRetransmissions(java.lang.Long maxRetransmissions) {
        this.maxRetransmissions = maxRetransmissions;
    }

    /**
     * Maximum TCP segment size. Allowed values are 512-9000. Special values are 0 -
     * 'Use Interface MTU'. Unit is BYTES. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMaxSegmentSize() {
        return this.maxSegmentSize;
    }

    /**
     * Maximum TCP segment size. Allowed values are 512-9000. Special values are 0 -
     * 'Use Interface MTU'. Unit is BYTES. format: int64
     *
     * @param maxSegmentSize New value for the property.
     */
    public void setMaxSegmentSize(java.lang.Long maxSegmentSize) {
        this.maxSegmentSize = maxSegmentSize;
    }

    /**
     * The maximum number of attempts at retransmitting a SYN packet before giving up.
     * Allowed values are 3-8. Default value when not specified in API or module is
     * interpreted by ALB Controller as 8. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMaxSynRetransmissions() {
        return this.maxSynRetransmissions;
    }

    /**
     * The maximum number of attempts at retransmitting a SYN packet before giving up.
     * Allowed values are 3-8. Default value when not specified in API or module is
     * interpreted by ALB Controller as 8. format: int64
     *
     * @param maxSynRetransmissions New value for the property.
     */
    public void setMaxSynRetransmissions(java.lang.Long maxSynRetransmissions) {
        this.maxSynRetransmissions = maxSynRetransmissions;
    }

    /**
     * The minimum wait time (in millisec) to retransmit packet. Allowed values are
     * 50-5000. Unit is MILLISECONDS. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMinRexmtTimeout() {
        return this.minRexmtTimeout;
    }

    /**
     * The minimum wait time (in millisec) to retransmit packet. Allowed values are
     * 50-5000. Unit is MILLISECONDS. format: int64
     *
     * @param minRexmtTimeout New value for the property.
     */
    public void setMinRexmtTimeout(java.lang.Long minRexmtTimeout) {
        this.minRexmtTimeout = minRexmtTimeout;
    }

    /**
     * Consolidates small data packets to send clients fewer but larger packets.
     * Adversely affects real time protocols such as telnet or SSH. Default value when
     * not specified in API or module is interpreted by ALB Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getNaglesAlgorithm() {
        return this.naglesAlgorithm;
    }

    /**
     * Consolidates small data packets to send clients fewer but larger packets.
     * Adversely affects real time protocols such as telnet or SSH. Default value when
     * not specified in API or module is interpreted by ALB Controller as false.
     *
     * @param naglesAlgorithm New value for the property.
     */
    public void setNaglesAlgorithm(java.lang.Boolean naglesAlgorithm) {
        this.naglesAlgorithm = naglesAlgorithm;
    }

    /**
     * Maximum number of TCP segments that can be queued for reassembly. Configuring
     * this to 0 disables the feature and provides unlimited queuing. Default value
     * when not specified in API or module is interpreted by ALB Controller as 0.
     * format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getReassemblyQueueSize() {
        return this.reassemblyQueueSize;
    }

    /**
     * Maximum number of TCP segments that can be queued for reassembly. Configuring
     * this to 0 disables the feature and provides unlimited queuing. Default value
     * when not specified in API or module is interpreted by ALB Controller as 0.
     * format: int64
     *
     * @param reassemblyQueueSize New value for the property.
     */
    public void setReassemblyQueueSize(java.lang.Long reassemblyQueueSize) {
        this.reassemblyQueueSize = reassemblyQueueSize;
    }

    /**
     * Size of the receive window. Allowed values are 2-65536. Unit is KB. Default
     * value when not specified in API or module is interpreted by ALB Controller as
     * 64. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getReceiveWindow() {
        return this.receiveWindow;
    }

    /**
     * Size of the receive window. Allowed values are 2-65536. Unit is KB. Default
     * value when not specified in API or module is interpreted by ALB Controller as
     * 64. format: int64
     *
     * @param receiveWindow New value for the property.
     */
    public void setReceiveWindow(java.lang.Long receiveWindow) {
        this.receiveWindow = receiveWindow;
    }

    /**
     * Controls the number of duplicate acks required to trigger retransmission.
     * Setting a higher value reduces retransmission caused by packet reordering. A
     * larger value is recommended in public cloud environments where packet reordering
     * is quite common. The default value is 8 in public cloud platforms (AWS, Azure,
     * GCP), and 3 in other environments. Allowed values are 1-100. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getReorderThreshold() {
        return this.reorderThreshold;
    }

    /**
     * Controls the number of duplicate acks required to trigger retransmission.
     * Setting a higher value reduces retransmission caused by packet reordering. A
     * larger value is recommended in public cloud environments where packet reordering
     * is quite common. The default value is 8 in public cloud platforms (AWS, Azure,
     * GCP), and 3 in other environments. Allowed values are 1-100. format: int64
     *
     * @param reorderThreshold New value for the property.
     */
    public void setReorderThreshold(java.lang.Long reorderThreshold) {
        this.reorderThreshold = reorderThreshold;
    }

    /**
     * Congestion window scaling factor during slow start. Allowed values are 0-8.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as 1. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getSlowStartScalingFactor() {
        return this.slowStartScalingFactor;
    }

    /**
     * Congestion window scaling factor during slow start. Allowed values are 0-8.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as 1. format: int64
     *
     * @param slowStartScalingFactor New value for the property.
     */
    public void setSlowStartScalingFactor(java.lang.Long slowStartScalingFactor) {
        this.slowStartScalingFactor = slowStartScalingFactor;
    }

    /**
     * The time (in millisec) to wait before closing a connection in the TIME_WAIT
     * state. Allowed values are 500-2000. Special values are 0 - 'immediate'. Unit is
     * MILLISECONDS. Default value when not specified in API or module is interpreted
     * by ALB Controller as 2000. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTimeWaitDelay() {
        return this.timeWaitDelay;
    }

    /**
     * The time (in millisec) to wait before closing a connection in the TIME_WAIT
     * state. Allowed values are 500-2000. Special values are 0 - 'immediate'. Unit is
     * MILLISECONDS. Default value when not specified in API or module is interpreted
     * by ALB Controller as 2000. format: int64
     *
     * @param timeWaitDelay New value for the property.
     */
    public void setTimeWaitDelay(java.lang.Long timeWaitDelay) {
        this.timeWaitDelay = timeWaitDelay;
    }

    /**
     * Use the interface MTU to calculate the TCP max segment size. Default value when
     * not specified in API or module is interpreted by ALB Controller as true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getUseInterfaceMtu() {
        return this.useInterfaceMtu;
    }

    /**
     * Use the interface MTU to calculate the TCP max segment size. Default value when
     * not specified in API or module is interpreted by ALB Controller as true.
     *
     * @param useInterfaceMtu New value for the property.
     */
    public void setUseInterfaceMtu(java.lang.Boolean useInterfaceMtu) {
        this.useInterfaceMtu = useInterfaceMtu;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBTCPProxyProfile;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("aggressive_congestion_avoidance",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.aggressiveCongestionAvoidance, this._getType().getField("aggressive_congestion_avoidance")));
        structValue.setField("auto_window_growth",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.autoWindowGrowth, this._getType().getField("auto_window_growth")));
        structValue.setField("automatic",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.automatic, this._getType().getField("automatic")));
        structValue.setField("cc_algo",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ccAlgo, this._getType().getField("cc_algo")));
        structValue.setField("congestion_recovery_scaling_factor",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.congestionRecoveryScalingFactor, this._getType().getField("congestion_recovery_scaling_factor")));
        structValue.setField("idle_connection_timeout",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.idleConnectionTimeout, this._getType().getField("idle_connection_timeout")));
        structValue.setField("idle_connection_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.idleConnectionType, this._getType().getField("idle_connection_type")));
        structValue.setField("ignore_time_wait",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ignoreTimeWait, this._getType().getField("ignore_time_wait")));
        structValue.setField("ip_dscp",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ipDscp, this._getType().getField("ip_dscp")));
        structValue.setField("keepalive_in_halfclose_state",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.keepaliveInHalfcloseState, this._getType().getField("keepalive_in_halfclose_state")));
        structValue.setField("max_retransmissions",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxRetransmissions, this._getType().getField("max_retransmissions")));
        structValue.setField("max_segment_size",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxSegmentSize, this._getType().getField("max_segment_size")));
        structValue.setField("max_syn_retransmissions",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxSynRetransmissions, this._getType().getField("max_syn_retransmissions")));
        structValue.setField("min_rexmt_timeout",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.minRexmtTimeout, this._getType().getField("min_rexmt_timeout")));
        structValue.setField("nagles_algorithm",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.naglesAlgorithm, this._getType().getField("nagles_algorithm")));
        structValue.setField("reassembly_queue_size",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.reassemblyQueueSize, this._getType().getField("reassembly_queue_size")));
        structValue.setField("receive_window",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.receiveWindow, this._getType().getField("receive_window")));
        structValue.setField("reorder_threshold",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.reorderThreshold, this._getType().getField("reorder_threshold")));
        structValue.setField("slow_start_scaling_factor",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.slowStartScalingFactor, this._getType().getField("slow_start_scaling_factor")));
        structValue.setField("time_wait_delay",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.timeWaitDelay, this._getType().getField("time_wait_delay")));
        structValue.setField("use_interface_mtu",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.useInterfaceMtu, this._getType().getField("use_interface_mtu")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBTCPProxyProfile;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.ALBTCPProxyProfile.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBTCPProxyProfile _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBTCPProxyProfile(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBTCPProxyProfile _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBTCPProxyProfile(structValue);
    }

    /**
     * Builder class for {@link ALBTCPProxyProfile}.
     */
    public static final class Builder {
        private java.lang.Boolean aggressiveCongestionAvoidance;
        private java.lang.Boolean autoWindowGrowth;
        private java.lang.Boolean automatic;
        private java.lang.String ccAlgo;
        private java.lang.Long congestionRecoveryScalingFactor;
        private java.lang.Long idleConnectionTimeout;
        private java.lang.String idleConnectionType;
        private java.lang.Boolean ignoreTimeWait;
        private java.lang.Long ipDscp;
        private java.lang.Boolean keepaliveInHalfcloseState;
        private java.lang.Long maxRetransmissions;
        private java.lang.Long maxSegmentSize;
        private java.lang.Long maxSynRetransmissions;
        private java.lang.Long minRexmtTimeout;
        private java.lang.Boolean naglesAlgorithm;
        private java.lang.Long reassemblyQueueSize;
        private java.lang.Long receiveWindow;
        private java.lang.Long reorderThreshold;
        private java.lang.Long slowStartScalingFactor;
        private java.lang.Long timeWaitDelay;
        private java.lang.Boolean useInterfaceMtu;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBTCPProxyProfile}.
         */
        public Builder() {
        }

        /**
         * Controls the our congestion window to send, normally it's 1 mss, If this option
         * is turned on, we use 10 msses. Default value when not specified in API or module
         * is interpreted by ALB Controller as false.
         *
         * @param aggressiveCongestionAvoidance New value for the property.
         */
        public Builder setAggressiveCongestionAvoidance(java.lang.Boolean aggressiveCongestionAvoidance) {
            this.aggressiveCongestionAvoidance = aggressiveCongestionAvoidance;
            return this;
        }

        /**
         * Controls whether the windows are static or supports autogrowth. Maximum that it
         * can grow to is limited to 4MB. Default value when not specified in API or module
         * is interpreted by ALB Controller as true.
         *
         * @param autoWindowGrowth New value for the property.
         */
        public Builder setAutoWindowGrowth(java.lang.Boolean autoWindowGrowth) {
            this.autoWindowGrowth = autoWindowGrowth;
            return this;
        }

        /**
         * Dynamically pick the relevant parameters for connections. Allowed in
         * Basic(Allowed values- true) edition, Enterprise edition. Default value when not
         * specified in API or module is interpreted by ALB Controller as true.
         *
         * @param automatic New value for the property.
         */
        public Builder setAutomatic(java.lang.Boolean automatic) {
            this.automatic = automatic;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.ALBTCPProxyProfile#CC_ALGO_NEW_RENO}</li> <li>
         * {@link com.vmware.nsx_policy.model.ALBTCPProxyProfile#CC_ALGO_CUBIC}</li> <li>
         * {@link com.vmware.nsx_policy.model.ALBTCPProxyProfile#CC_ALGO_HTCP}</li> </ul>
         * Controls the congestion control algorithm we use. Enum options -
         * CC_ALGO_NEW_RENO, CC_ALGO_CUBIC, CC_ALGO_HTCP. Default value when not specified
         * in API or module is interpreted by ALB Controller as CC_ALGO_NEW_RENO.
         *
         * @param ccAlgo New value for the property.
         */
        public Builder setCcAlgo(java.lang.String ccAlgo) {
            this.ccAlgo = ccAlgo;
            return this;
        }

        /**
         * Congestion window scaling factor after recovery. Allowed values are 0-8. Default
         * value when not specified in API or module is interpreted by ALB Controller as 2.
         * format: int64
         *
         * @param congestionRecoveryScalingFactor New value for the property.
         */
        public Builder setCongestionRecoveryScalingFactor(java.lang.Long congestionRecoveryScalingFactor) {
            this.congestionRecoveryScalingFactor = congestionRecoveryScalingFactor;
            return this;
        }

        /**
         * The duration for keepalive probes or session idle timeout. Max value is 3600
         * seconds, min is 5. Set to 0 to allow infinite idle time. Allowed values are
         * 5-14400. Special values are 0 - 'infinite'. Unit is SEC. Default value when not
         * specified in API or module is interpreted by ALB Controller as 600. format:
         * int64
         *
         * @param idleConnectionTimeout New value for the property.
         */
        public Builder setIdleConnectionTimeout(java.lang.Long idleConnectionTimeout) {
            this.idleConnectionTimeout = idleConnectionTimeout;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.ALBTCPProxyProfile#IDLE_CONNECTION_TYPE_KEEP_ALIVE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.ALBTCPProxyProfile#IDLE_CONNECTION_TYPE_CLOSE_IDLE}</li>
         * </ul> Controls the behavior of idle connections. Enum options - KEEP_ALIVE,
         * CLOSE_IDLE. Default value when not specified in API or module is interpreted by
         * ALB Controller as KEEP_ALIVE.
         *
         * @param idleConnectionType New value for the property.
         */
        public Builder setIdleConnectionType(java.lang.String idleConnectionType) {
            this.idleConnectionType = idleConnectionType;
            return this;
        }

        /**
         * A new SYN is accepted from the same 4-tuple even if there is already a
         * connection in TIME_WAIT state. This is equivalent of setting Time Wait Delay to
         * 0. Default value when not specified in API or module is interpreted by ALB
         * Controller as false.
         *
         * @param ignoreTimeWait New value for the property.
         */
        public Builder setIgnoreTimeWait(java.lang.Boolean ignoreTimeWait) {
            this.ignoreTimeWait = ignoreTimeWait;
            return this;
        }

        /**
         * Controls the value of the Differentiated Services Code Point field inserted in
         * the IP header. This has two options Set to a specific value, or Pass Through,
         * which uses the incoming DSCP value. Allowed values are 0-63. Special values are
         * MAX - 'Passthrough'. Default value when not specified in API or module is
         * interpreted by ALB Controller as 0. format: int64
         *
         * @param ipDscp New value for the property.
         */
        public Builder setIpDscp(java.lang.Long ipDscp) {
            this.ipDscp = ipDscp;
            return this;
        }

        /**
         * Controls whether to keep the connection alive with keepalive messages in the TCP
         * half close state. The interval for sending keepalive messages is 30s. If a
         * timeout is already configured in the network profile, this will not override it.
         * Default value when not specified in API or module is interpreted by ALB
         * Controller as true.
         *
         * @param keepaliveInHalfcloseState New value for the property.
         */
        public Builder setKeepaliveInHalfcloseState(java.lang.Boolean keepaliveInHalfcloseState) {
            this.keepaliveInHalfcloseState = keepaliveInHalfcloseState;
            return this;
        }

        /**
         * The number of attempts at retransmit before closing the connection. Allowed
         * values are 3-8. Default value when not specified in API or module is interpreted
         * by ALB Controller as 8. format: int64
         *
         * @param maxRetransmissions New value for the property.
         */
        public Builder setMaxRetransmissions(java.lang.Long maxRetransmissions) {
            this.maxRetransmissions = maxRetransmissions;
            return this;
        }

        /**
         * Maximum TCP segment size. Allowed values are 512-9000. Special values are 0 -
         * 'Use Interface MTU'. Unit is BYTES. format: int64
         *
         * @param maxSegmentSize New value for the property.
         */
        public Builder setMaxSegmentSize(java.lang.Long maxSegmentSize) {
            this.maxSegmentSize = maxSegmentSize;
            return this;
        }

        /**
         * The maximum number of attempts at retransmitting a SYN packet before giving up.
         * Allowed values are 3-8. Default value when not specified in API or module is
         * interpreted by ALB Controller as 8. format: int64
         *
         * @param maxSynRetransmissions New value for the property.
         */
        public Builder setMaxSynRetransmissions(java.lang.Long maxSynRetransmissions) {
            this.maxSynRetransmissions = maxSynRetransmissions;
            return this;
        }

        /**
         * The minimum wait time (in millisec) to retransmit packet. Allowed values are
         * 50-5000. Unit is MILLISECONDS. format: int64
         *
         * @param minRexmtTimeout New value for the property.
         */
        public Builder setMinRexmtTimeout(java.lang.Long minRexmtTimeout) {
            this.minRexmtTimeout = minRexmtTimeout;
            return this;
        }

        /**
         * Consolidates small data packets to send clients fewer but larger packets.
         * Adversely affects real time protocols such as telnet or SSH. Default value when
         * not specified in API or module is interpreted by ALB Controller as false.
         *
         * @param naglesAlgorithm New value for the property.
         */
        public Builder setNaglesAlgorithm(java.lang.Boolean naglesAlgorithm) {
            this.naglesAlgorithm = naglesAlgorithm;
            return this;
        }

        /**
         * Maximum number of TCP segments that can be queued for reassembly. Configuring
         * this to 0 disables the feature and provides unlimited queuing. Default value
         * when not specified in API or module is interpreted by ALB Controller as 0.
         * format: int64
         *
         * @param reassemblyQueueSize New value for the property.
         */
        public Builder setReassemblyQueueSize(java.lang.Long reassemblyQueueSize) {
            this.reassemblyQueueSize = reassemblyQueueSize;
            return this;
        }

        /**
         * Size of the receive window. Allowed values are 2-65536. Unit is KB. Default
         * value when not specified in API or module is interpreted by ALB Controller as
         * 64. format: int64
         *
         * @param receiveWindow New value for the property.
         */
        public Builder setReceiveWindow(java.lang.Long receiveWindow) {
            this.receiveWindow = receiveWindow;
            return this;
        }

        /**
         * Controls the number of duplicate acks required to trigger retransmission.
         * Setting a higher value reduces retransmission caused by packet reordering. A
         * larger value is recommended in public cloud environments where packet reordering
         * is quite common. The default value is 8 in public cloud platforms (AWS, Azure,
         * GCP), and 3 in other environments. Allowed values are 1-100. format: int64
         *
         * @param reorderThreshold New value for the property.
         */
        public Builder setReorderThreshold(java.lang.Long reorderThreshold) {
            this.reorderThreshold = reorderThreshold;
            return this;
        }

        /**
         * Congestion window scaling factor during slow start. Allowed values are 0-8.
         * Default value when not specified in API or module is interpreted by ALB
         * Controller as 1. format: int64
         *
         * @param slowStartScalingFactor New value for the property.
         */
        public Builder setSlowStartScalingFactor(java.lang.Long slowStartScalingFactor) {
            this.slowStartScalingFactor = slowStartScalingFactor;
            return this;
        }

        /**
         * The time (in millisec) to wait before closing a connection in the TIME_WAIT
         * state. Allowed values are 500-2000. Special values are 0 - 'immediate'. Unit is
         * MILLISECONDS. Default value when not specified in API or module is interpreted
         * by ALB Controller as 2000. format: int64
         *
         * @param timeWaitDelay New value for the property.
         */
        public Builder setTimeWaitDelay(java.lang.Long timeWaitDelay) {
            this.timeWaitDelay = timeWaitDelay;
            return this;
        }

        /**
         * Use the interface MTU to calculate the TCP max segment size. Default value when
         * not specified in API or module is interpreted by ALB Controller as true.
         *
         * @param useInterfaceMtu New value for the property.
         */
        public Builder setUseInterfaceMtu(java.lang.Boolean useInterfaceMtu) {
            this.useInterfaceMtu = useInterfaceMtu;
            return this;
        }

        public ALBTCPProxyProfile build() {
            ALBTCPProxyProfile result = new ALBTCPProxyProfile();
            result.setAggressiveCongestionAvoidance(this.aggressiveCongestionAvoidance);
            result.setAutoWindowGrowth(this.autoWindowGrowth);
            result.setAutomatic(this.automatic);
            result.setCcAlgo(this.ccAlgo);
            result.setCongestionRecoveryScalingFactor(this.congestionRecoveryScalingFactor);
            result.setIdleConnectionTimeout(this.idleConnectionTimeout);
            result.setIdleConnectionType(this.idleConnectionType);
            result.setIgnoreTimeWait(this.ignoreTimeWait);
            result.setIpDscp(this.ipDscp);
            result.setKeepaliveInHalfcloseState(this.keepaliveInHalfcloseState);
            result.setMaxRetransmissions(this.maxRetransmissions);
            result.setMaxSegmentSize(this.maxSegmentSize);
            result.setMaxSynRetransmissions(this.maxSynRetransmissions);
            result.setMinRexmtTimeout(this.minRexmtTimeout);
            result.setNaglesAlgorithm(this.naglesAlgorithm);
            result.setReassemblyQueueSize(this.reassemblyQueueSize);
            result.setReceiveWindow(this.receiveWindow);
            result.setReorderThreshold(this.reorderThreshold);
            result.setSlowStartScalingFactor(this.slowStartScalingFactor);
            result.setTimeWaitDelay(this.timeWaitDelay);
            result.setUseInterfaceMtu(this.useInterfaceMtu);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("aggressive_congestion_avoidance", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("aggressive_congestion_avoidance",
                                                                                "aggressiveCongestionAvoidance",
                                                                                "getAggressiveCongestionAvoidance",
                                                                                "setAggressiveCongestionAvoidance");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("auto_window_growth", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("auto_window_growth",
                                                                                "autoWindowGrowth",
                                                                                "getAutoWindowGrowth",
                                                                                "setAutoWindowGrowth");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("automatic", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("automatic",
                                                                                "automatic",
                                                                                "getAutomatic",
                                                                                "setAutomatic");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("cc_algo", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("cc_algo",
                                                                                "ccAlgo",
                                                                                "getCcAlgo",
                                                                                "setCcAlgo");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("congestion_recovery_scaling_factor", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("congestion_recovery_scaling_factor",
                                                                                "congestionRecoveryScalingFactor",
                                                                                "getCongestionRecoveryScalingFactor",
                                                                                "setCongestionRecoveryScalingFactor");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("idle_connection_timeout", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("idle_connection_timeout",
                                                                                "idleConnectionTimeout",
                                                                                "getIdleConnectionTimeout",
                                                                                "setIdleConnectionTimeout");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("idle_connection_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("idle_connection_type",
                                                                                "idleConnectionType",
                                                                                "getIdleConnectionType",
                                                                                "setIdleConnectionType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ignore_time_wait", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ignore_time_wait",
                                                                                "ignoreTimeWait",
                                                                                "getIgnoreTimeWait",
                                                                                "setIgnoreTimeWait");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ip_dscp", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ip_dscp",
                                                                                "ipDscp",
                                                                                "getIpDscp",
                                                                                "setIpDscp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("keepalive_in_halfclose_state", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("keepalive_in_halfclose_state",
                                                                                "keepaliveInHalfcloseState",
                                                                                "getKeepaliveInHalfcloseState",
                                                                                "setKeepaliveInHalfcloseState");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max_retransmissions", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_retransmissions",
                                                                                "maxRetransmissions",
                                                                                "getMaxRetransmissions",
                                                                                "setMaxRetransmissions");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max_segment_size", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_segment_size",
                                                                                "maxSegmentSize",
                                                                                "getMaxSegmentSize",
                                                                                "setMaxSegmentSize");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max_syn_retransmissions", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_syn_retransmissions",
                                                                                "maxSynRetransmissions",
                                                                                "getMaxSynRetransmissions",
                                                                                "setMaxSynRetransmissions");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("min_rexmt_timeout", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("min_rexmt_timeout",
                                                                                "minRexmtTimeout",
                                                                                "getMinRexmtTimeout",
                                                                                "setMinRexmtTimeout");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("nagles_algorithm", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("nagles_algorithm",
                                                                                "naglesAlgorithm",
                                                                                "getNaglesAlgorithm",
                                                                                "setNaglesAlgorithm");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("reassembly_queue_size", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("reassembly_queue_size",
                                                                                "reassemblyQueueSize",
                                                                                "getReassemblyQueueSize",
                                                                                "setReassemblyQueueSize");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("receive_window", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("receive_window",
                                                                                "receiveWindow",
                                                                                "getReceiveWindow",
                                                                                "setReceiveWindow");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("reorder_threshold", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("reorder_threshold",
                                                                                "reorderThreshold",
                                                                                "getReorderThreshold",
                                                                                "setReorderThreshold");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("slow_start_scaling_factor", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("slow_start_scaling_factor",
                                                                                "slowStartScalingFactor",
                                                                                "getSlowStartScalingFactor",
                                                                                "setSlowStartScalingFactor");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("time_wait_delay", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("time_wait_delay",
                                                                                "timeWaitDelay",
                                                                                "getTimeWaitDelay",
                                                                                "setTimeWaitDelay");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("use_interface_mtu", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("use_interface_mtu",
                                                                                "useInterfaceMtu",
                                                                                "getUseInterfaceMtu",
                                                                                "setUseInterfaceMtu");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.ALBTCP_proxy_profile",
                                                            fields,
                                                            com.vmware.nsx_policy.model.ALBTCPProxyProfile.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

