/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Advanced load balancer URIParamQuery object
 */
public final class ALBURIParamQuery implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String addString;

    private java.lang.Boolean keepQuery;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBURIParamQuery() {
    }

    protected ALBURIParamQuery(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Concatenate a string to the query of the incoming request URI and then use it in
     * the request URI going to the backend server.
     *
     * @return The current value of the property.
     */
    public java.lang.String getAddString() {
        return this.addString;
    }

    /**
     * Concatenate a string to the query of the incoming request URI and then use it in
     * the request URI going to the backend server.
     *
     * @param addString New value for the property.
     */
    public void setAddString(java.lang.String addString) {
        this.addString = addString;
    }

    /**
     * Use or drop the query of the incoming request URI in the request URI to the
     * backend server. Default value when not specified in API or module is interpreted
     * by ALB Controller as true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getKeepQuery() {
        return this.keepQuery;
    }

    /**
     * Use or drop the query of the incoming request URI in the request URI to the
     * backend server. Default value when not specified in API or module is interpreted
     * by ALB Controller as true.
     *
     * @param keepQuery New value for the property.
     */
    public void setKeepQuery(java.lang.Boolean keepQuery) {
        this.keepQuery = keepQuery;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBURIParamQuery;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("add_string",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.addString, this._getType().getField("add_string")));
        structValue.setField("keep_query",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.keepQuery, this._getType().getField("keep_query")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBURIParamQuery;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.ALBURIParamQuery.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBURIParamQuery _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBURIParamQuery(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBURIParamQuery _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBURIParamQuery(structValue);
    }

    /**
     * Builder class for {@link ALBURIParamQuery}.
     */
    public static final class Builder {
        private java.lang.String addString;
        private java.lang.Boolean keepQuery;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBURIParamQuery}.
         */
        public Builder() {
        }

        /**
         * Concatenate a string to the query of the incoming request URI and then use it in
         * the request URI going to the backend server.
         *
         * @param addString New value for the property.
         */
        public Builder setAddString(java.lang.String addString) {
            this.addString = addString;
            return this;
        }

        /**
         * Use or drop the query of the incoming request URI in the request URI to the
         * backend server. Default value when not specified in API or module is interpreted
         * by ALB Controller as true.
         *
         * @param keepQuery New value for the property.
         */
        public Builder setKeepQuery(java.lang.Boolean keepQuery) {
            this.keepQuery = keepQuery;
            return this;
        }

        public ALBURIParamQuery build() {
            ALBURIParamQuery result = new ALBURIParamQuery();
            result.setAddString(this.addString);
            result.setKeepQuery(this.keepQuery);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("add_string", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("add_string",
                                                                                "addString",
                                                                                "getAddString",
                                                                                "setAddString");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("keep_query", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("keep_query",
                                                                                "keepQuery",
                                                                                "getKeepQuery",
                                                                                "setKeepQuery");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.ALBURI_param_query",
                                                            fields,
                                                            com.vmware.nsx_policy.model.ALBURIParamQuery.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

