/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Advanced load balancer Vip object
 */
public final class ALBVip implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String AUTO_ALLOCATE_IP_TYPE_V4_ONLY = "V4_ONLY";

    public static final java.lang.String AUTO_ALLOCATE_IP_TYPE_V6_ONLY = "V6_ONLY";

    public static final java.lang.String AUTO_ALLOCATE_IP_TYPE_V4_V6 = "V4_V6";

    private java.lang.Boolean autoAllocateFloatingIp;

    private java.lang.Boolean autoAllocateIp;

    private java.lang.String autoAllocateIpType;

    private java.lang.String availabilityZone;

    private java.lang.Boolean aviAllocatedFip;

    private java.lang.Boolean aviAllocatedVip;

    private java.util.List<com.vmware.nsx_policy.model.ALBDiscoveredNetwork> discoveredNetworks;

    private java.lang.Boolean enabled;

    private com.vmware.nsx_policy.model.ALBIpAddr floatingIp;

    private com.vmware.nsx_policy.model.ALBIpAddr floatingIp6;

    private java.lang.String floatingSubnet6Uuid;

    private java.lang.String floatingSubnetUuid;

    private com.vmware.nsx_policy.model.ALBIpAddr ip6Address;

    private com.vmware.nsx_policy.model.ALBIpAddr ipAddress;

    private com.vmware.nsx_policy.model.ALBIPNetworkSubnet ipamNetworkSubnet;

    private java.lang.String networkName;

    private java.util.List<com.vmware.nsx_policy.model.ALBVipPlacementNetwork> placementNetworks;

    private java.lang.String portUuid;

    private java.lang.Long prefixLength;

    private com.vmware.nsx_policy.model.ALBIpAddrPrefix subnet;

    private com.vmware.nsx_policy.model.ALBIpAddrPrefix subnet6;

    private java.lang.String subnet6Uuid;

    private java.lang.String subnetUuid;

    private java.lang.String vipId;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBVip() {
    }

    protected ALBVip(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Auto-allocate floating/elastic IP from the Cloud infrastructure. Allowed in
     * Basic(Allowed values- false) edition, Essentials(Allowed values- false) edition,
     * Enterprise edition. Default value when not specified in API or module is
     * interpreted by ALB Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getAutoAllocateFloatingIp() {
        return this.autoAllocateFloatingIp;
    }

    /**
     * Auto-allocate floating/elastic IP from the Cloud infrastructure. Allowed in
     * Basic(Allowed values- false) edition, Essentials(Allowed values- false) edition,
     * Enterprise edition. Default value when not specified in API or module is
     * interpreted by ALB Controller as false.
     *
     * @param autoAllocateFloatingIp New value for the property.
     */
    public void setAutoAllocateFloatingIp(java.lang.Boolean autoAllocateFloatingIp) {
        this.autoAllocateFloatingIp = autoAllocateFloatingIp;
    }

    /**
     * Auto-allocate VIP from the provided subnet. Default value when not specified in
     * API or module is interpreted by ALB Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getAutoAllocateIp() {
        return this.autoAllocateIp;
    }

    /**
     * Auto-allocate VIP from the provided subnet. Default value when not specified in
     * API or module is interpreted by ALB Controller as false.
     *
     * @param autoAllocateIp New value for the property.
     */
    public void setAutoAllocateIp(java.lang.Boolean autoAllocateIp) {
        this.autoAllocateIp = autoAllocateIp;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBVip#AUTO_ALLOCATE_IP_TYPE_V4_ONLY}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBVip#AUTO_ALLOCATE_IP_TYPE_V6_ONLY}</li>
     * <li> {@link com.vmware.nsx_policy.model.ALBVip#AUTO_ALLOCATE_IP_TYPE_V4_V6}</li>
     * </ul> Specifies whether to auto-allocate only a V4 address, only a V6 address,
     * or one of each type. Enum options - V4_ONLY, V6_ONLY, V4_V6. Allowed in
     * Basic(Allowed values- V4_ONLY) edition, Essentials(Allowed values- V4_ONLY)
     * edition, Enterprise edition. Default value when not specified in API or module
     * is interpreted by ALB Controller as V4_ONLY.
     *
     * @return The current value of the property.
     */
    public java.lang.String getAutoAllocateIpType() {
        return this.autoAllocateIpType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBVip#AUTO_ALLOCATE_IP_TYPE_V4_ONLY}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBVip#AUTO_ALLOCATE_IP_TYPE_V6_ONLY}</li>
     * <li> {@link com.vmware.nsx_policy.model.ALBVip#AUTO_ALLOCATE_IP_TYPE_V4_V6}</li>
     * </ul> Specifies whether to auto-allocate only a V4 address, only a V6 address,
     * or one of each type. Enum options - V4_ONLY, V6_ONLY, V4_V6. Allowed in
     * Basic(Allowed values- V4_ONLY) edition, Essentials(Allowed values- V4_ONLY)
     * edition, Enterprise edition. Default value when not specified in API or module
     * is interpreted by ALB Controller as V4_ONLY.
     *
     * @param autoAllocateIpType New value for the property.
     */
    public void setAutoAllocateIpType(java.lang.String autoAllocateIpType) {
        this.autoAllocateIpType = autoAllocateIpType;
    }

    /**
     * Availability-zone to place the Virtual Service. Allowed in Basic edition,
     * Essentials edition, Enterprise edition.
     *
     * @return The current value of the property.
     */
    public java.lang.String getAvailabilityZone() {
        return this.availabilityZone;
    }

    /**
     * Availability-zone to place the Virtual Service. Allowed in Basic edition,
     * Essentials edition, Enterprise edition.
     *
     * @param availabilityZone New value for the property.
     */
    public void setAvailabilityZone(java.lang.String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    /**
     * (internal-use) FIP allocated by Avi in the Cloud infrastructure. Allowed in
     * Basic(Allowed values- false) edition, Essentials(Allowed values- false) edition,
     * Enterprise edition. Default value when not specified in API or module is
     * interpreted by ALB Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getAviAllocatedFip() {
        return this.aviAllocatedFip;
    }

    /**
     * (internal-use) FIP allocated by Avi in the Cloud infrastructure. Allowed in
     * Basic(Allowed values- false) edition, Essentials(Allowed values- false) edition,
     * Enterprise edition. Default value when not specified in API or module is
     * interpreted by ALB Controller as false.
     *
     * @param aviAllocatedFip New value for the property.
     */
    public void setAviAllocatedFip(java.lang.Boolean aviAllocatedFip) {
        this.aviAllocatedFip = aviAllocatedFip;
    }

    /**
     * (internal-use) VIP allocated by Avi in the Cloud infrastructure. Allowed in
     * Basic(Allowed values- false) edition, Essentials(Allowed values- false) edition,
     * Enterprise edition. Default value when not specified in API or module is
     * interpreted by ALB Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getAviAllocatedVip() {
        return this.aviAllocatedVip;
    }

    /**
     * (internal-use) VIP allocated by Avi in the Cloud infrastructure. Allowed in
     * Basic(Allowed values- false) edition, Essentials(Allowed values- false) edition,
     * Enterprise edition. Default value when not specified in API or module is
     * interpreted by ALB Controller as false.
     *
     * @param aviAllocatedVip New value for the property.
     */
    public void setAviAllocatedVip(java.lang.Boolean aviAllocatedVip) {
        this.aviAllocatedVip = aviAllocatedVip;
    }

    /**
     * Discovered networks providing reachability for client facing Vip IP.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.ALBDiscoveredNetwork> getDiscoveredNetworks() {
        return this.discoveredNetworks;
    }

    /**
     * Discovered networks providing reachability for client facing Vip IP.
     *
     * @param discoveredNetworks New value for the property.
     */
    public void setDiscoveredNetworks(java.util.List<com.vmware.nsx_policy.model.ALBDiscoveredNetwork> discoveredNetworks) {
        this.discoveredNetworks = discoveredNetworks;
    }

    /**
     * Enable or disable the Vip. Default value when not specified in API or module is
     * interpreted by ALB Controller as true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnabled() {
        return this.enabled;
    }

    /**
     * Enable or disable the Vip. Default value when not specified in API or module is
     * interpreted by ALB Controller as true.
     *
     * @param enabled New value for the property.
     */
    public void setEnabled(java.lang.Boolean enabled) {
        this.enabled = enabled;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.ALBIpAddr getFloatingIp() {
        return this.floatingIp;
    }

    /**
     *
     *
     * @param floatingIp New value for the property.
     */
    public void setFloatingIp(com.vmware.nsx_policy.model.ALBIpAddr floatingIp) {
        this.floatingIp = floatingIp;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.ALBIpAddr getFloatingIp6() {
        return this.floatingIp6;
    }

    /**
     *
     *
     * @param floatingIp6 New value for the property.
     */
    public void setFloatingIp6(com.vmware.nsx_policy.model.ALBIpAddr floatingIp6) {
        this.floatingIp6 = floatingIp6;
    }

    /**
     * If auto_allocate_floating_ip is True and more than one floating-ip subnets
     * exist, then the subnet for the floating IPv6 address allocation. Allowed in
     * Basic edition, Essentials edition, Enterprise edition.
     *
     * @return The current value of the property.
     */
    public java.lang.String getFloatingSubnet6Uuid() {
        return this.floatingSubnet6Uuid;
    }

    /**
     * If auto_allocate_floating_ip is True and more than one floating-ip subnets
     * exist, then the subnet for the floating IPv6 address allocation. Allowed in
     * Basic edition, Essentials edition, Enterprise edition.
     *
     * @param floatingSubnet6Uuid New value for the property.
     */
    public void setFloatingSubnet6Uuid(java.lang.String floatingSubnet6Uuid) {
        this.floatingSubnet6Uuid = floatingSubnet6Uuid;
    }

    /**
     * If auto_allocate_floating_ip is True and more than one floating-ip subnets
     * exist, then the subnet for the floating IP address allocation. Allowed in Basic
     * edition, Essentials edition, Enterprise edition.
     *
     * @return The current value of the property.
     */
    public java.lang.String getFloatingSubnetUuid() {
        return this.floatingSubnetUuid;
    }

    /**
     * If auto_allocate_floating_ip is True and more than one floating-ip subnets
     * exist, then the subnet for the floating IP address allocation. Allowed in Basic
     * edition, Essentials edition, Enterprise edition.
     *
     * @param floatingSubnetUuid New value for the property.
     */
    public void setFloatingSubnetUuid(java.lang.String floatingSubnetUuid) {
        this.floatingSubnetUuid = floatingSubnetUuid;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.ALBIpAddr getIp6Address() {
        return this.ip6Address;
    }

    /**
     *
     *
     * @param ip6Address New value for the property.
     */
    public void setIp6Address(com.vmware.nsx_policy.model.ALBIpAddr ip6Address) {
        this.ip6Address = ip6Address;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.ALBIpAddr getIpAddress() {
        return this.ipAddress;
    }

    /**
     *
     *
     * @param ipAddress New value for the property.
     */
    public void setIpAddress(com.vmware.nsx_policy.model.ALBIpAddr ipAddress) {
        this.ipAddress = ipAddress;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.ALBIPNetworkSubnet getIpamNetworkSubnet() {
        return this.ipamNetworkSubnet;
    }

    /**
     *
     *
     * @param ipamNetworkSubnet New value for the property.
     */
    public void setIpamNetworkSubnet(com.vmware.nsx_policy.model.ALBIPNetworkSubnet ipamNetworkSubnet) {
        this.ipamNetworkSubnet = ipamNetworkSubnet;
    }

    /**
     * Manually override the network on which the Vip is placed. It is a reference to
     * an object of type Network.
     *
     * @return The current value of the property.
     */
    public java.lang.String getNetworkName() {
        return this.networkName;
    }

    /**
     * Manually override the network on which the Vip is placed. It is a reference to
     * an object of type Network.
     *
     * @param networkName New value for the property.
     */
    public void setNetworkName(java.lang.String networkName) {
        this.networkName = networkName;
    }

    /**
     * Placement networks/subnets to use for vip placement. Maximum of 10 items
     * allowed.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.ALBVipPlacementNetwork> getPlacementNetworks() {
        return this.placementNetworks;
    }

    /**
     * Placement networks/subnets to use for vip placement. Maximum of 10 items
     * allowed.
     *
     * @param placementNetworks New value for the property.
     */
    public void setPlacementNetworks(java.util.List<com.vmware.nsx_policy.model.ALBVipPlacementNetwork> placementNetworks) {
        this.placementNetworks = placementNetworks;
    }

    /**
     * (internal-use) Network port assigned to the Vip IP address.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPortUuid() {
        return this.portUuid;
    }

    /**
     * (internal-use) Network port assigned to the Vip IP address.
     *
     * @param portUuid New value for the property.
     */
    public void setPortUuid(java.lang.String portUuid) {
        this.portUuid = portUuid;
    }

    /**
     * Mask applied for the Vip, non-default mask supported only for wildcard Vip.
     * Allowed values are 0-32. Allowed in Basic(Allowed values- 32) edition,
     * Essentials(Allowed values- 32) edition, Enterprise edition. Default value when
     * not specified in API or module is interpreted by ALB Controller as 32. format:
     * int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getPrefixLength() {
        return this.prefixLength;
    }

    /**
     * Mask applied for the Vip, non-default mask supported only for wildcard Vip.
     * Allowed values are 0-32. Allowed in Basic(Allowed values- 32) edition,
     * Essentials(Allowed values- 32) edition, Enterprise edition. Default value when
     * not specified in API or module is interpreted by ALB Controller as 32. format:
     * int64
     *
     * @param prefixLength New value for the property.
     */
    public void setPrefixLength(java.lang.Long prefixLength) {
        this.prefixLength = prefixLength;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.ALBIpAddrPrefix getSubnet() {
        return this.subnet;
    }

    /**
     *
     *
     * @param subnet New value for the property.
     */
    public void setSubnet(com.vmware.nsx_policy.model.ALBIpAddrPrefix subnet) {
        this.subnet = subnet;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.ALBIpAddrPrefix getSubnet6() {
        return this.subnet6;
    }

    /**
     *
     *
     * @param subnet6 New value for the property.
     */
    public void setSubnet6(com.vmware.nsx_policy.model.ALBIpAddrPrefix subnet6) {
        this.subnet6 = subnet6;
    }

    /**
     * If auto_allocate_ip is True, then the subnet for the Vip IPv6 address
     * allocation. This field is applicable only if the VirtualService belongs to an
     * Openstack or AWS cloud, in which case it is mandatory, if auto_allocate is
     * selected. Allowed in Essentials edition, Enterprise edition.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSubnet6Uuid() {
        return this.subnet6Uuid;
    }

    /**
     * If auto_allocate_ip is True, then the subnet for the Vip IPv6 address
     * allocation. This field is applicable only if the VirtualService belongs to an
     * Openstack or AWS cloud, in which case it is mandatory, if auto_allocate is
     * selected. Allowed in Essentials edition, Enterprise edition.
     *
     * @param subnet6Uuid New value for the property.
     */
    public void setSubnet6Uuid(java.lang.String subnet6Uuid) {
        this.subnet6Uuid = subnet6Uuid;
    }

    /**
     * If auto_allocate_ip is True, then the subnet for the Vip IP address allocation.
     * This field is applicable only if the VirtualService belongs to an Openstack or
     * AWS cloud, in which case it is mandatory, if auto_allocate is selected.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSubnetUuid() {
        return this.subnetUuid;
    }

    /**
     * If auto_allocate_ip is True, then the subnet for the Vip IP address allocation.
     * This field is applicable only if the VirtualService belongs to an Openstack or
     * AWS cloud, in which case it is mandatory, if auto_allocate is selected.
     *
     * @param subnetUuid New value for the property.
     */
    public void setSubnetUuid(java.lang.String subnetUuid) {
        this.subnetUuid = subnetUuid;
    }

    /**
     * Unique ID associated with the vip.
     *
     * @return The current value of the property.
     */
    public java.lang.String getVipId() {
        return this.vipId;
    }

    /**
     * Unique ID associated with the vip.
     *
     * @param vipId New value for the property.
     */
    public void setVipId(java.lang.String vipId) {
        this.vipId = vipId;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBVip;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("auto_allocate_floating_ip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.autoAllocateFloatingIp, this._getType().getField("auto_allocate_floating_ip")));
        structValue.setField("auto_allocate_ip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.autoAllocateIp, this._getType().getField("auto_allocate_ip")));
        structValue.setField("auto_allocate_ip_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.autoAllocateIpType, this._getType().getField("auto_allocate_ip_type")));
        structValue.setField("availability_zone",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.availabilityZone, this._getType().getField("availability_zone")));
        structValue.setField("avi_allocated_fip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.aviAllocatedFip, this._getType().getField("avi_allocated_fip")));
        structValue.setField("avi_allocated_vip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.aviAllocatedVip, this._getType().getField("avi_allocated_vip")));
        structValue.setField("discovered_networks",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.discoveredNetworks, this._getType().getField("discovered_networks")));
        structValue.setField("enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enabled, this._getType().getField("enabled")));
        structValue.setField("floating_ip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.floatingIp, this._getType().getField("floating_ip")));
        structValue.setField("floating_ip6",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.floatingIp6, this._getType().getField("floating_ip6")));
        structValue.setField("floating_subnet6_uuid",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.floatingSubnet6Uuid, this._getType().getField("floating_subnet6_uuid")));
        structValue.setField("floating_subnet_uuid",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.floatingSubnetUuid, this._getType().getField("floating_subnet_uuid")));
        structValue.setField("ip6_address",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ip6Address, this._getType().getField("ip6_address")));
        structValue.setField("ip_address",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ipAddress, this._getType().getField("ip_address")));
        structValue.setField("ipam_network_subnet",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ipamNetworkSubnet, this._getType().getField("ipam_network_subnet")));
        structValue.setField("network_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.networkName, this._getType().getField("network_name")));
        structValue.setField("placement_networks",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.placementNetworks, this._getType().getField("placement_networks")));
        structValue.setField("port_uuid",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.portUuid, this._getType().getField("port_uuid")));
        structValue.setField("prefix_length",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.prefixLength, this._getType().getField("prefix_length")));
        structValue.setField("subnet",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.subnet, this._getType().getField("subnet")));
        structValue.setField("subnet6",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.subnet6, this._getType().getField("subnet6")));
        structValue.setField("subnet6_uuid",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.subnet6Uuid, this._getType().getField("subnet6_uuid")));
        structValue.setField("subnet_uuid",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.subnetUuid, this._getType().getField("subnet_uuid")));
        structValue.setField("vip_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vipId, this._getType().getField("vip_id")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBVip;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.ALBVip.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBVip _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBVip(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBVip _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBVip(structValue);
    }

    /**
     * Builder class for {@link ALBVip}.
     */
    public static final class Builder {
        private java.lang.Boolean autoAllocateFloatingIp;
        private java.lang.Boolean autoAllocateIp;
        private java.lang.String autoAllocateIpType;
        private java.lang.String availabilityZone;
        private java.lang.Boolean aviAllocatedFip;
        private java.lang.Boolean aviAllocatedVip;
        private java.util.List<com.vmware.nsx_policy.model.ALBDiscoveredNetwork> discoveredNetworks;
        private java.lang.Boolean enabled;
        private com.vmware.nsx_policy.model.ALBIpAddr floatingIp;
        private com.vmware.nsx_policy.model.ALBIpAddr floatingIp6;
        private java.lang.String floatingSubnet6Uuid;
        private java.lang.String floatingSubnetUuid;
        private com.vmware.nsx_policy.model.ALBIpAddr ip6Address;
        private com.vmware.nsx_policy.model.ALBIpAddr ipAddress;
        private com.vmware.nsx_policy.model.ALBIPNetworkSubnet ipamNetworkSubnet;
        private java.lang.String networkName;
        private java.util.List<com.vmware.nsx_policy.model.ALBVipPlacementNetwork> placementNetworks;
        private java.lang.String portUuid;
        private java.lang.Long prefixLength;
        private com.vmware.nsx_policy.model.ALBIpAddrPrefix subnet;
        private com.vmware.nsx_policy.model.ALBIpAddrPrefix subnet6;
        private java.lang.String subnet6Uuid;
        private java.lang.String subnetUuid;
        private java.lang.String vipId;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBVip}.
         */
        public Builder() {
        }

        /**
         * Auto-allocate floating/elastic IP from the Cloud infrastructure. Allowed in
         * Basic(Allowed values- false) edition, Essentials(Allowed values- false) edition,
         * Enterprise edition. Default value when not specified in API or module is
         * interpreted by ALB Controller as false.
         *
         * @param autoAllocateFloatingIp New value for the property.
         */
        public Builder setAutoAllocateFloatingIp(java.lang.Boolean autoAllocateFloatingIp) {
            this.autoAllocateFloatingIp = autoAllocateFloatingIp;
            return this;
        }

        /**
         * Auto-allocate VIP from the provided subnet. Default value when not specified in
         * API or module is interpreted by ALB Controller as false.
         *
         * @param autoAllocateIp New value for the property.
         */
        public Builder setAutoAllocateIp(java.lang.Boolean autoAllocateIp) {
            this.autoAllocateIp = autoAllocateIp;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.ALBVip#AUTO_ALLOCATE_IP_TYPE_V4_ONLY}</li> <li>
         * {@link com.vmware.nsx_policy.model.ALBVip#AUTO_ALLOCATE_IP_TYPE_V6_ONLY}</li>
         * <li> {@link com.vmware.nsx_policy.model.ALBVip#AUTO_ALLOCATE_IP_TYPE_V4_V6}</li>
         * </ul> Specifies whether to auto-allocate only a V4 address, only a V6 address,
         * or one of each type. Enum options - V4_ONLY, V6_ONLY, V4_V6. Allowed in
         * Basic(Allowed values- V4_ONLY) edition, Essentials(Allowed values- V4_ONLY)
         * edition, Enterprise edition. Default value when not specified in API or module
         * is interpreted by ALB Controller as V4_ONLY.
         *
         * @param autoAllocateIpType New value for the property.
         */
        public Builder setAutoAllocateIpType(java.lang.String autoAllocateIpType) {
            this.autoAllocateIpType = autoAllocateIpType;
            return this;
        }

        /**
         * Availability-zone to place the Virtual Service. Allowed in Basic edition,
         * Essentials edition, Enterprise edition.
         *
         * @param availabilityZone New value for the property.
         */
        public Builder setAvailabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * (internal-use) FIP allocated by Avi in the Cloud infrastructure. Allowed in
         * Basic(Allowed values- false) edition, Essentials(Allowed values- false) edition,
         * Enterprise edition. Default value when not specified in API or module is
         * interpreted by ALB Controller as false.
         *
         * @param aviAllocatedFip New value for the property.
         */
        public Builder setAviAllocatedFip(java.lang.Boolean aviAllocatedFip) {
            this.aviAllocatedFip = aviAllocatedFip;
            return this;
        }

        /**
         * (internal-use) VIP allocated by Avi in the Cloud infrastructure. Allowed in
         * Basic(Allowed values- false) edition, Essentials(Allowed values- false) edition,
         * Enterprise edition. Default value when not specified in API or module is
         * interpreted by ALB Controller as false.
         *
         * @param aviAllocatedVip New value for the property.
         */
        public Builder setAviAllocatedVip(java.lang.Boolean aviAllocatedVip) {
            this.aviAllocatedVip = aviAllocatedVip;
            return this;
        }

        /**
         * Discovered networks providing reachability for client facing Vip IP.
         *
         * @param discoveredNetworks New value for the property.
         */
        public Builder setDiscoveredNetworks(java.util.List<com.vmware.nsx_policy.model.ALBDiscoveredNetwork> discoveredNetworks) {
            this.discoveredNetworks = discoveredNetworks;
            return this;
        }

        /**
         * Enable or disable the Vip. Default value when not specified in API or module is
         * interpreted by ALB Controller as true.
         *
         * @param enabled New value for the property.
         */
        public Builder setEnabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         *
         *
         * @param floatingIp New value for the property.
         */
        public Builder setFloatingIp(com.vmware.nsx_policy.model.ALBIpAddr floatingIp) {
            this.floatingIp = floatingIp;
            return this;
        }

        /**
         *
         *
         * @param floatingIp6 New value for the property.
         */
        public Builder setFloatingIp6(com.vmware.nsx_policy.model.ALBIpAddr floatingIp6) {
            this.floatingIp6 = floatingIp6;
            return this;
        }

        /**
         * If auto_allocate_floating_ip is True and more than one floating-ip subnets
         * exist, then the subnet for the floating IPv6 address allocation. Allowed in
         * Basic edition, Essentials edition, Enterprise edition.
         *
         * @param floatingSubnet6Uuid New value for the property.
         */
        public Builder setFloatingSubnet6Uuid(java.lang.String floatingSubnet6Uuid) {
            this.floatingSubnet6Uuid = floatingSubnet6Uuid;
            return this;
        }

        /**
         * If auto_allocate_floating_ip is True and more than one floating-ip subnets
         * exist, then the subnet for the floating IP address allocation. Allowed in Basic
         * edition, Essentials edition, Enterprise edition.
         *
         * @param floatingSubnetUuid New value for the property.
         */
        public Builder setFloatingSubnetUuid(java.lang.String floatingSubnetUuid) {
            this.floatingSubnetUuid = floatingSubnetUuid;
            return this;
        }

        /**
         *
         *
         * @param ip6Address New value for the property.
         */
        public Builder setIp6Address(com.vmware.nsx_policy.model.ALBIpAddr ip6Address) {
            this.ip6Address = ip6Address;
            return this;
        }

        /**
         *
         *
         * @param ipAddress New value for the property.
         */
        public Builder setIpAddress(com.vmware.nsx_policy.model.ALBIpAddr ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        /**
         *
         *
         * @param ipamNetworkSubnet New value for the property.
         */
        public Builder setIpamNetworkSubnet(com.vmware.nsx_policy.model.ALBIPNetworkSubnet ipamNetworkSubnet) {
            this.ipamNetworkSubnet = ipamNetworkSubnet;
            return this;
        }

        /**
         * Manually override the network on which the Vip is placed. It is a reference to
         * an object of type Network.
         *
         * @param networkName New value for the property.
         */
        public Builder setNetworkName(java.lang.String networkName) {
            this.networkName = networkName;
            return this;
        }

        /**
         * Placement networks/subnets to use for vip placement. Maximum of 10 items
         * allowed.
         *
         * @param placementNetworks New value for the property.
         */
        public Builder setPlacementNetworks(java.util.List<com.vmware.nsx_policy.model.ALBVipPlacementNetwork> placementNetworks) {
            this.placementNetworks = placementNetworks;
            return this;
        }

        /**
         * (internal-use) Network port assigned to the Vip IP address.
         *
         * @param portUuid New value for the property.
         */
        public Builder setPortUuid(java.lang.String portUuid) {
            this.portUuid = portUuid;
            return this;
        }

        /**
         * Mask applied for the Vip, non-default mask supported only for wildcard Vip.
         * Allowed values are 0-32. Allowed in Basic(Allowed values- 32) edition,
         * Essentials(Allowed values- 32) edition, Enterprise edition. Default value when
         * not specified in API or module is interpreted by ALB Controller as 32. format:
         * int64
         *
         * @param prefixLength New value for the property.
         */
        public Builder setPrefixLength(java.lang.Long prefixLength) {
            this.prefixLength = prefixLength;
            return this;
        }

        /**
         *
         *
         * @param subnet New value for the property.
         */
        public Builder setSubnet(com.vmware.nsx_policy.model.ALBIpAddrPrefix subnet) {
            this.subnet = subnet;
            return this;
        }

        /**
         *
         *
         * @param subnet6 New value for the property.
         */
        public Builder setSubnet6(com.vmware.nsx_policy.model.ALBIpAddrPrefix subnet6) {
            this.subnet6 = subnet6;
            return this;
        }

        /**
         * If auto_allocate_ip is True, then the subnet for the Vip IPv6 address
         * allocation. This field is applicable only if the VirtualService belongs to an
         * Openstack or AWS cloud, in which case it is mandatory, if auto_allocate is
         * selected. Allowed in Essentials edition, Enterprise edition.
         *
         * @param subnet6Uuid New value for the property.
         */
        public Builder setSubnet6Uuid(java.lang.String subnet6Uuid) {
            this.subnet6Uuid = subnet6Uuid;
            return this;
        }

        /**
         * If auto_allocate_ip is True, then the subnet for the Vip IP address allocation.
         * This field is applicable only if the VirtualService belongs to an Openstack or
         * AWS cloud, in which case it is mandatory, if auto_allocate is selected.
         *
         * @param subnetUuid New value for the property.
         */
        public Builder setSubnetUuid(java.lang.String subnetUuid) {
            this.subnetUuid = subnetUuid;
            return this;
        }

        /**
         * Unique ID associated with the vip.
         *
         * @param vipId New value for the property.
         */
        public Builder setVipId(java.lang.String vipId) {
            this.vipId = vipId;
            return this;
        }

        public ALBVip build() {
            ALBVip result = new ALBVip();
            result.setAutoAllocateFloatingIp(this.autoAllocateFloatingIp);
            result.setAutoAllocateIp(this.autoAllocateIp);
            result.setAutoAllocateIpType(this.autoAllocateIpType);
            result.setAvailabilityZone(this.availabilityZone);
            result.setAviAllocatedFip(this.aviAllocatedFip);
            result.setAviAllocatedVip(this.aviAllocatedVip);
            result.setDiscoveredNetworks(this.discoveredNetworks);
            result.setEnabled(this.enabled);
            result.setFloatingIp(this.floatingIp);
            result.setFloatingIp6(this.floatingIp6);
            result.setFloatingSubnet6Uuid(this.floatingSubnet6Uuid);
            result.setFloatingSubnetUuid(this.floatingSubnetUuid);
            result.setIp6Address(this.ip6Address);
            result.setIpAddress(this.ipAddress);
            result.setIpamNetworkSubnet(this.ipamNetworkSubnet);
            result.setNetworkName(this.networkName);
            result.setPlacementNetworks(this.placementNetworks);
            result.setPortUuid(this.portUuid);
            result.setPrefixLength(this.prefixLength);
            result.setSubnet(this.subnet);
            result.setSubnet6(this.subnet6);
            result.setSubnet6Uuid(this.subnet6Uuid);
            result.setSubnetUuid(this.subnetUuid);
            result.setVipId(this.vipId);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("auto_allocate_floating_ip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("auto_allocate_floating_ip",
                                                                                "autoAllocateFloatingIp",
                                                                                "getAutoAllocateFloatingIp",
                                                                                "setAutoAllocateFloatingIp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("auto_allocate_ip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("auto_allocate_ip",
                                                                                "autoAllocateIp",
                                                                                "getAutoAllocateIp",
                                                                                "setAutoAllocateIp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("auto_allocate_ip_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("auto_allocate_ip_type",
                                                                                "autoAllocateIpType",
                                                                                "getAutoAllocateIpType",
                                                                                "setAutoAllocateIpType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("availability_zone", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("availability_zone",
                                                                                "availabilityZone",
                                                                                "getAvailabilityZone",
                                                                                "setAvailabilityZone");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("avi_allocated_fip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("avi_allocated_fip",
                                                                                "aviAllocatedFip",
                                                                                "getAviAllocatedFip",
                                                                                "setAviAllocatedFip");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("avi_allocated_vip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("avi_allocated_vip",
                                                                                "aviAllocatedVip",
                                                                                "getAviAllocatedVip",
                                                                                "setAviAllocatedVip");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("discovered_networks", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.ALBDiscoveredNetwork; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("discovered_networks",
                                                                                "discoveredNetworks",
                                                                                "getDiscoveredNetworks",
                                                                                "setDiscoveredNetworks");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enabled",
                                                                                "enabled",
                                                                                "getEnabled",
                                                                                "setEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("floating_ip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.ALBIpAddr; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("floating_ip",
                                                                                "floatingIp",
                                                                                "getFloatingIp",
                                                                                "setFloatingIp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("floating_ip6", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.ALBIpAddr; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("floating_ip6",
                                                                                "floatingIp6",
                                                                                "getFloatingIp6",
                                                                                "setFloatingIp6");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("floating_subnet6_uuid", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("floating_subnet6_uuid",
                                                                                "floatingSubnet6Uuid",
                                                                                "getFloatingSubnet6Uuid",
                                                                                "setFloatingSubnet6Uuid");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("floating_subnet_uuid", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("floating_subnet_uuid",
                                                                                "floatingSubnetUuid",
                                                                                "getFloatingSubnetUuid",
                                                                                "setFloatingSubnetUuid");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ip6_address", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.ALBIpAddr; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ip6_address",
                                                                                "ip6Address",
                                                                                "getIp6Address",
                                                                                "setIp6Address");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ip_address", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.ALBIpAddr; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ip_address",
                                                                                "ipAddress",
                                                                                "getIpAddress",
                                                                                "setIpAddress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ipam_network_subnet", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.ALBIPNetworkSubnet; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ipam_network_subnet",
                                                                                "ipamNetworkSubnet",
                                                                                "getIpamNetworkSubnet",
                                                                                "setIpamNetworkSubnet");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("network_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("network_name",
                                                                                "networkName",
                                                                                "getNetworkName",
                                                                                "setNetworkName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("placement_networks", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.ALBVipPlacementNetwork; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("placement_networks",
                                                                                "placementNetworks",
                                                                                "getPlacementNetworks",
                                                                                "setPlacementNetworks");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("port_uuid", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("port_uuid",
                                                                                "portUuid",
                                                                                "getPortUuid",
                                                                                "setPortUuid");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("prefix_length", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("prefix_length",
                                                                                "prefixLength",
                                                                                "getPrefixLength",
                                                                                "setPrefixLength");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("subnet", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.ALBIpAddrPrefix; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("subnet",
                                                                                "subnet",
                                                                                "getSubnet",
                                                                                "setSubnet");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("subnet6", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.ALBIpAddrPrefix; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("subnet6",
                                                                                "subnet6",
                                                                                "getSubnet6",
                                                                                "setSubnet6");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("subnet6_uuid", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("subnet6_uuid",
                                                                                "subnet6Uuid",
                                                                                "getSubnet6Uuid",
                                                                                "setSubnet6Uuid");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("subnet_uuid", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("subnet_uuid",
                                                                                "subnetUuid",
                                                                                "getSubnetUuid",
                                                                                "setSubnetUuid");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vip_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vip_id",
                                                                                "vipId",
                                                                                "getVipId",
                                                                                "setVipId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.ALB_vip",
                                                            fields,
                                                            com.vmware.nsx_policy.model.ALBVip.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

