/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Advanced load balancer WafPSMRule object
 */
public final class ALBWafPSMRule implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String MATCH_CASE_SENSITIVE = "SENSITIVE";

    public static final java.lang.String MATCH_CASE_INSENSITIVE = "INSENSITIVE";

    public static final java.lang.String MODE_DETECTION_ONLY = "WAF_MODE_DETECTION_ONLY";

    public static final java.lang.String MODE_ENFORCEMENT = "WAF_MODE_ENFORCEMENT";

    public static final java.lang.String PARANOIA_LEVEL_LOW = "WAF_PARANOIA_LEVEL_LOW";

    public static final java.lang.String PARANOIA_LEVEL_MEDIUM = "WAF_PARANOIA_LEVEL_MEDIUM";

    public static final java.lang.String PARANOIA_LEVEL_HIGH = "WAF_PARANOIA_LEVEL_HIGH";

    public static final java.lang.String PARANOIA_LEVEL_EXTREME = "WAF_PARANOIA_LEVEL_EXTREME";

    private java.lang.String description;

    private java.lang.Boolean enable;

    private java.lang.Long index;

    private java.lang.String matchCase;

    private java.util.List<com.vmware.nsx_policy.model.ALBWafPSMMatchElement> matchElements;

    private java.lang.Long matchValueMaxLength;

    private java.lang.String matchValuePattern;

    private java.lang.String mode;

    private java.lang.String name;

    private java.lang.String paranoiaLevel;

    private java.lang.String ruleId;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBWafPSMRule() {
    }

    protected ALBWafPSMRule(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Free-text comment about this rule.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDescription() {
        return this.description;
    }

    /**
     * Free-text comment about this rule.
     *
     * @param description New value for the property.
     */
    public void setDescription(java.lang.String description) {
        this.description = description;
    }

    /**
     * Enable or disable this rule. Default value when not specified in API or module
     * is interpreted by ALB Controller as true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnable() {
        return this.enable;
    }

    /**
     * Enable or disable this rule. Default value when not specified in API or module
     * is interpreted by ALB Controller as true.
     *
     * @param enable New value for the property.
     */
    public void setEnable(java.lang.Boolean enable) {
        this.enable = enable;
    }

    /**
     * Rule index, this is used to determine the order of the rules. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getIndex() {
        return this.index;
    }

    /**
     * Rule index, this is used to determine the order of the rules. format: int64
     *
     * @param index New value for the property.
     */
    public void setIndex(java.lang.Long index) {
        this.index = index;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBWafPSMRule#MATCH_CASE_SENSITIVE}</li> <li> {@link
     * com.vmware.nsx_policy.model.ALBWafPSMRule#MATCH_CASE_INSENSITIVE}</li> </ul> The
     * field match_value_pattern regular expression is case sensitive. Enum options -
     * SENSITIVE, INSENSITIVE. Default value when not specified in API or module is
     * interpreted by ALB Controller as INSENSITIVE.
     *
     * @return The current value of the property.
     */
    public java.lang.String getMatchCase() {
        return this.matchCase;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBWafPSMRule#MATCH_CASE_SENSITIVE}</li> <li> {@link
     * com.vmware.nsx_policy.model.ALBWafPSMRule#MATCH_CASE_INSENSITIVE}</li> </ul> The
     * field match_value_pattern regular expression is case sensitive. Enum options -
     * SENSITIVE, INSENSITIVE. Default value when not specified in API or module is
     * interpreted by ALB Controller as INSENSITIVE.
     *
     * @param matchCase New value for the property.
     */
    public void setMatchCase(java.lang.String matchCase) {
        this.matchCase = matchCase;
    }

    /**
     * The match elements, for example ARGS id or ARGS|!ARGS password. Maximum of 64
     * items allowed.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.ALBWafPSMMatchElement> getMatchElements() {
        return this.matchElements;
    }

    /**
     * The match elements, for example ARGS id or ARGS|!ARGS password. Maximum of 64
     * items allowed.
     *
     * @param matchElements New value for the property.
     */
    public void setMatchElements(java.util.List<com.vmware.nsx_policy.model.ALBWafPSMMatchElement> matchElements) {
        this.matchElements = matchElements;
    }

    /**
     * The maximum allowed length of the match_value. If this is not set, the length
     * will not be checked. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMatchValueMaxLength() {
        return this.matchValueMaxLength;
    }

    /**
     * The maximum allowed length of the match_value. If this is not set, the length
     * will not be checked. format: int64
     *
     * @param matchValueMaxLength New value for the property.
     */
    public void setMatchValueMaxLength(java.lang.Long matchValueMaxLength) {
        this.matchValueMaxLength = matchValueMaxLength;
    }

    /**
     * A regular expression which describes the expected value.
     *
     * @return The current value of the property.
     */
    public java.lang.String getMatchValuePattern() {
        return this.matchValuePattern;
    }

    /**
     * A regular expression which describes the expected value.
     *
     * @param matchValuePattern New value for the property.
     */
    public void setMatchValuePattern(java.lang.String matchValuePattern) {
        this.matchValuePattern = matchValuePattern;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBWafPSMRule#MODE_DETECTION_ONLY}</li> <li> {@link
     * com.vmware.nsx_policy.model.ALBWafPSMRule#MODE_ENFORCEMENT}</li> </ul> WAF Rule
     * mode. This can be detection or enforcement. If this is not set, the Policy mode
     * is used. This only takes effect if the policy allows delegation. Enum options -
     * WAF_MODE_DETECTION_ONLY, WAF_MODE_ENFORCEMENT.
     *
     * @return The current value of the property.
     */
    public java.lang.String getMode() {
        return this.mode;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBWafPSMRule#MODE_DETECTION_ONLY}</li> <li> {@link
     * com.vmware.nsx_policy.model.ALBWafPSMRule#MODE_ENFORCEMENT}</li> </ul> WAF Rule
     * mode. This can be detection or enforcement. If this is not set, the Policy mode
     * is used. This only takes effect if the policy allows delegation. Enum options -
     * WAF_MODE_DETECTION_ONLY, WAF_MODE_ENFORCEMENT.
     *
     * @param mode New value for the property.
     */
    public void setMode(java.lang.String mode) {
        this.mode = mode;
    }

    /**
     * Name of the rule.
     *
     * @return The current value of the property.
     */
    public java.lang.String getName() {
        return this.name;
    }

    /**
     * Name of the rule.
     *
     * @param name New value for the property.
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBWafPSMRule#PARANOIA_LEVEL_LOW}</li> <li> {@link
     * com.vmware.nsx_policy.model.ALBWafPSMRule#PARANOIA_LEVEL_MEDIUM}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBWafPSMRule#PARANOIA_LEVEL_HIGH}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBWafPSMRule#PARANOIA_LEVEL_EXTREME}</li>
     * </ul> WAF Ruleset paranoia mode. This is used to select Rules based on the
     * paranoia-level. Enum options - WAF_PARANOIA_LEVEL_LOW,
     * WAF_PARANOIA_LEVEL_MEDIUM, WAF_PARANOIA_LEVEL_HIGH, WAF_PARANOIA_LEVEL_EXTREME.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as WAF_PARANOIA_LEVEL_LOW.
     *
     * @return The current value of the property.
     */
    public java.lang.String getParanoiaLevel() {
        return this.paranoiaLevel;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBWafPSMRule#PARANOIA_LEVEL_LOW}</li> <li> {@link
     * com.vmware.nsx_policy.model.ALBWafPSMRule#PARANOIA_LEVEL_MEDIUM}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBWafPSMRule#PARANOIA_LEVEL_HIGH}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBWafPSMRule#PARANOIA_LEVEL_EXTREME}</li>
     * </ul> WAF Ruleset paranoia mode. This is used to select Rules based on the
     * paranoia-level. Enum options - WAF_PARANOIA_LEVEL_LOW,
     * WAF_PARANOIA_LEVEL_MEDIUM, WAF_PARANOIA_LEVEL_HIGH, WAF_PARANOIA_LEVEL_EXTREME.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as WAF_PARANOIA_LEVEL_LOW.
     *
     * @param paranoiaLevel New value for the property.
     */
    public void setParanoiaLevel(java.lang.String paranoiaLevel) {
        this.paranoiaLevel = paranoiaLevel;
    }

    /**
     * Id field which is used for log and metric generation. This id must be unique for
     * all rules in this group.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRuleId() {
        return this.ruleId;
    }

    /**
     * Id field which is used for log and metric generation. This id must be unique for
     * all rules in this group.
     *
     * @param ruleId New value for the property.
     */
    public void setRuleId(java.lang.String ruleId) {
        this.ruleId = ruleId;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBWafPSMRule;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("description",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.description, this._getType().getField("description")));
        structValue.setField("enable",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enable, this._getType().getField("enable")));
        structValue.setField("index",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.index, this._getType().getField("index")));
        structValue.setField("match_case",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.matchCase, this._getType().getField("match_case")));
        structValue.setField("match_elements",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.matchElements, this._getType().getField("match_elements")));
        structValue.setField("match_value_max_length",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.matchValueMaxLength, this._getType().getField("match_value_max_length")));
        structValue.setField("match_value_pattern",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.matchValuePattern, this._getType().getField("match_value_pattern")));
        structValue.setField("mode",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.mode, this._getType().getField("mode")));
        structValue.setField("name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.name, this._getType().getField("name")));
        structValue.setField("paranoia_level",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.paranoiaLevel, this._getType().getField("paranoia_level")));
        structValue.setField("rule_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ruleId, this._getType().getField("rule_id")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBWafPSMRule;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.ALBWafPSMRule.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBWafPSMRule _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBWafPSMRule(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBWafPSMRule _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBWafPSMRule(structValue);
    }

    /**
     * Builder class for {@link ALBWafPSMRule}.
     */
    public static final class Builder {
        private java.lang.String description;
        private java.lang.Boolean enable;
        private java.lang.Long index;
        private java.lang.String matchCase;
        private java.util.List<com.vmware.nsx_policy.model.ALBWafPSMMatchElement> matchElements;
        private java.lang.Long matchValueMaxLength;
        private java.lang.String matchValuePattern;
        private java.lang.String mode;
        private java.lang.String name;
        private java.lang.String paranoiaLevel;
        private java.lang.String ruleId;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBWafPSMRule}.
         */
        public Builder() {
        }

        /**
         * Free-text comment about this rule.
         *
         * @param description New value for the property.
         */
        public Builder setDescription(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Enable or disable this rule. Default value when not specified in API or module
         * is interpreted by ALB Controller as true.
         *
         * @param enable New value for the property.
         */
        public Builder setEnable(java.lang.Boolean enable) {
            this.enable = enable;
            return this;
        }

        /**
         * Rule index, this is used to determine the order of the rules. format: int64
         *
         * @param index New value for the property.
         */
        public Builder setIndex(java.lang.Long index) {
            this.index = index;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.ALBWafPSMRule#MATCH_CASE_SENSITIVE}</li> <li> {@link
         * com.vmware.nsx_policy.model.ALBWafPSMRule#MATCH_CASE_INSENSITIVE}</li> </ul> The
         * field match_value_pattern regular expression is case sensitive. Enum options -
         * SENSITIVE, INSENSITIVE. Default value when not specified in API or module is
         * interpreted by ALB Controller as INSENSITIVE.
         *
         * @param matchCase New value for the property.
         */
        public Builder setMatchCase(java.lang.String matchCase) {
            this.matchCase = matchCase;
            return this;
        }

        /**
         * The match elements, for example ARGS id or ARGS|!ARGS password. Maximum of 64
         * items allowed.
         *
         * @param matchElements New value for the property.
         */
        public Builder setMatchElements(java.util.List<com.vmware.nsx_policy.model.ALBWafPSMMatchElement> matchElements) {
            this.matchElements = matchElements;
            return this;
        }

        /**
         * The maximum allowed length of the match_value. If this is not set, the length
         * will not be checked. format: int64
         *
         * @param matchValueMaxLength New value for the property.
         */
        public Builder setMatchValueMaxLength(java.lang.Long matchValueMaxLength) {
            this.matchValueMaxLength = matchValueMaxLength;
            return this;
        }

        /**
         * A regular expression which describes the expected value.
         *
         * @param matchValuePattern New value for the property.
         */
        public Builder setMatchValuePattern(java.lang.String matchValuePattern) {
            this.matchValuePattern = matchValuePattern;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.ALBWafPSMRule#MODE_DETECTION_ONLY}</li> <li> {@link
         * com.vmware.nsx_policy.model.ALBWafPSMRule#MODE_ENFORCEMENT}</li> </ul> WAF Rule
         * mode. This can be detection or enforcement. If this is not set, the Policy mode
         * is used. This only takes effect if the policy allows delegation. Enum options -
         * WAF_MODE_DETECTION_ONLY, WAF_MODE_ENFORCEMENT.
         *
         * @param mode New value for the property.
         */
        public Builder setMode(java.lang.String mode) {
            this.mode = mode;
            return this;
        }

        /**
         * Name of the rule.
         *
         * @param name New value for the property.
         */
        public Builder setName(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.ALBWafPSMRule#PARANOIA_LEVEL_LOW}</li> <li> {@link
         * com.vmware.nsx_policy.model.ALBWafPSMRule#PARANOIA_LEVEL_MEDIUM}</li> <li>
         * {@link com.vmware.nsx_policy.model.ALBWafPSMRule#PARANOIA_LEVEL_HIGH}</li> <li>
         * {@link com.vmware.nsx_policy.model.ALBWafPSMRule#PARANOIA_LEVEL_EXTREME}</li>
         * </ul> WAF Ruleset paranoia mode. This is used to select Rules based on the
         * paranoia-level. Enum options - WAF_PARANOIA_LEVEL_LOW,
         * WAF_PARANOIA_LEVEL_MEDIUM, WAF_PARANOIA_LEVEL_HIGH, WAF_PARANOIA_LEVEL_EXTREME.
         * Default value when not specified in API or module is interpreted by ALB
         * Controller as WAF_PARANOIA_LEVEL_LOW.
         *
         * @param paranoiaLevel New value for the property.
         */
        public Builder setParanoiaLevel(java.lang.String paranoiaLevel) {
            this.paranoiaLevel = paranoiaLevel;
            return this;
        }

        /**
         * Id field which is used for log and metric generation. This id must be unique for
         * all rules in this group.
         *
         * @param ruleId New value for the property.
         */
        public Builder setRuleId(java.lang.String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public ALBWafPSMRule build() {
            ALBWafPSMRule result = new ALBWafPSMRule();
            result.setDescription(this.description);
            result.setEnable(this.enable);
            result.setIndex(this.index);
            result.setMatchCase(this.matchCase);
            result.setMatchElements(this.matchElements);
            result.setMatchValueMaxLength(this.matchValueMaxLength);
            result.setMatchValuePattern(this.matchValuePattern);
            result.setMode(this.mode);
            result.setName(this.name);
            result.setParanoiaLevel(this.paranoiaLevel);
            result.setRuleId(this.ruleId);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("description", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("description",
                                                                                "description",
                                                                                "getDescription",
                                                                                "setDescription");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("enable", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enable",
                                                                                "enable",
                                                                                "getEnable",
                                                                                "setEnable");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("index", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("index",
                                                                                "index",
                                                                                "getIndex",
                                                                                "setIndex");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("match_case", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("match_case",
                                                                                "matchCase",
                                                                                "getMatchCase",
                                                                                "setMatchCase");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("match_elements", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.ALBWafPSMMatchElement; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("match_elements",
                                                                                "matchElements",
                                                                                "getMatchElements",
                                                                                "setMatchElements");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("match_value_max_length", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("match_value_max_length",
                                                                                "matchValueMaxLength",
                                                                                "getMatchValueMaxLength",
                                                                                "setMatchValueMaxLength");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("match_value_pattern", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("match_value_pattern",
                                                                                "matchValuePattern",
                                                                                "getMatchValuePattern",
                                                                                "setMatchValuePattern");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("mode", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("mode",
                                                                                "mode",
                                                                                "getMode",
                                                                                "setMode");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("name",
                                                                                "name",
                                                                                "getName",
                                                                                "setName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("paranoia_level", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("paranoia_level",
                                                                                "paranoiaLevel",
                                                                                "getParanoiaLevel",
                                                                                "setParanoiaLevel");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("rule_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("rule_id",
                                                                                "ruleId",
                                                                                "getRuleId",
                                                                                "setRuleId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.ALB_waf_PSM_rule",
                                                            fields,
                                                            com.vmware.nsx_policy.model.ALBWafPSMRule.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

