/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Advanced load balancer WafPolicy object
 */
public final class ALBWafPolicy implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String FAILURE_MODE_OPEN = "WAF_FAILURE_MODE_OPEN";

    public static final java.lang.String FAILURE_MODE_CLOSED = "WAF_FAILURE_MODE_CLOSED";

    public static final java.lang.String MIN_CONFIDENCE_VERY_HIGH = "CONFIDENCE_VERY_HIGH";

    public static final java.lang.String MIN_CONFIDENCE_HIGH = "CONFIDENCE_HIGH";

    public static final java.lang.String MIN_CONFIDENCE_PROBABLE = "CONFIDENCE_PROBABLE";

    public static final java.lang.String MIN_CONFIDENCE_LOW = "CONFIDENCE_LOW";

    public static final java.lang.String MIN_CONFIDENCE_NONE = "CONFIDENCE_NONE";

    public static final java.lang.String MODE_DETECTION_ONLY = "WAF_MODE_DETECTION_ONLY";

    public static final java.lang.String MODE_ENFORCEMENT = "WAF_MODE_ENFORCEMENT";

    public static final java.lang.String PARANOIA_LEVEL_LOW = "WAF_PARANOIA_LEVEL_LOW";

    public static final java.lang.String PARANOIA_LEVEL_MEDIUM = "WAF_PARANOIA_LEVEL_MEDIUM";

    public static final java.lang.String PARANOIA_LEVEL_HIGH = "WAF_PARANOIA_LEVEL_HIGH";

    public static final java.lang.String PARANOIA_LEVEL_EXTREME = "WAF_PARANOIA_LEVEL_EXTREME";

    private java.util.List<com.vmware.nsx_policy.model.ResourceLink> links;

    private java.lang.String schema;

    private com.vmware.nsx_policy.model.SelfResourceLink self;

    private java.lang.Long revision;

    private java.lang.Long createTime;

    private java.lang.String createUser;

    private java.lang.Long lastModifiedTime;

    private java.lang.String lastModifiedUser;

    private java.lang.String protection;

    private java.lang.Boolean systemOwned;

    private java.lang.String description;

    private java.lang.String displayName;

    private java.lang.String id;

    private java.lang.String resourceType;

    private java.util.List<com.vmware.nsx_policy.model.Tag> tags;

    private java.lang.String originSiteId;

    private java.lang.String ownerId;

    private java.lang.String parentPath;

    private java.lang.String path;

    private java.lang.String realizationId;

    private java.lang.String relativePath;

    private java.lang.String remotePath;

    private java.lang.String uniqueId;

    private java.util.List<com.vmware.vapi.bindings.Structure> children;

    private java.lang.Boolean markedForDelete;

    private java.lang.Boolean overridden;

    private java.lang.Boolean allowModeDelegation;

    private com.vmware.nsx_policy.model.ALBWafApplicationSignatures applicationSignatures;

    private com.vmware.nsx_policy.model.ALBAppLearningConfidenceOverride confidenceOverride;

    private java.lang.String createdBy;

    private java.util.List<com.vmware.nsx_policy.model.ALBWafRuleGroupOverrides> crsOverrides;

    private java.lang.Boolean enableAppLearning;

    private java.lang.Boolean enableAutoRuleUpdates;

    private java.lang.String failureMode;

    private com.vmware.nsx_policy.model.ALBAppLearningParams learningParams;

    private java.util.List<com.vmware.nsx_policy.model.ALBRoleFilterMatchLabel> markers;

    private java.lang.String minConfidence;

    private java.lang.String mode;

    private java.lang.String paranoiaLevel;

    private com.vmware.nsx_policy.model.ALBWafPositiveSecurityModel positiveSecurityModel;

    private java.util.List<com.vmware.nsx_policy.model.ALBWafRuleGroup> postCrsGroups;

    private java.util.List<com.vmware.nsx_policy.model.ALBWafRuleGroup> preCrsGroups;

    private java.lang.String wafCrsPath;

    private java.lang.String wafProfilePath;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBWafPolicy() {
    }

    protected ALBWafPolicy(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.ResourceLink> getLinks() {
        return this.links;
    }

    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param links New value for the property.
     */
    public void setLinks(java.util.List<com.vmware.nsx_policy.model.ResourceLink> links) {
        this.links = links;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSchema() {
        return this.schema;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param schema New value for the property.
     */
    public void setSchema(java.lang.String schema) {
        this.schema = schema;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.SelfResourceLink getSelf() {
        return this.self;
    }

    /**
     *
     *
     * @param self New value for the property.
     */
    public void setSelf(com.vmware.nsx_policy.model.SelfResourceLink self) {
        this.self = self;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRevision() {
        return this.revision;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @param revision New value for the property.
     */
    public void setRevision(java.lang.Long revision) {
        this.revision = revision;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCreateTime() {
        return this.createTime;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createTime New value for the property.
     */
    public void setCreateTime(java.lang.Long createTime) {
        this.createTime = createTime;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCreateUser() {
        return this.createUser;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createUser New value for the property.
     */
    public void setCreateUser(java.lang.String createUser) {
        this.createUser = createUser;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedTime New value for the property.
     */
    public void setLastModifiedTime(java.lang.Long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLastModifiedUser() {
        return this.lastModifiedUser;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedUser New value for the property.
     */
    public void setLastModifiedUser(java.lang.String lastModifiedUser) {
        this.lastModifiedUser = lastModifiedUser;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getProtection() {
        return this.protection;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param protection New value for the property.
     */
    public void setProtection(java.lang.String protection) {
        this.protection = protection;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getSystemOwned() {
        return this.systemOwned;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param systemOwned New value for the property.
     */
    public void setSystemOwned(java.lang.Boolean systemOwned) {
        this.systemOwned = systemOwned;
    }

    /**
     * Description of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getDescription() {
        return this.description;
    }

    /**
     * Description of this resource
     *
     * @param description New value for the property.
     */
    public void setDescription(java.lang.String description) {
        this.description = description;
    }

    /**
     * Defaults to ID if not set
     *
     * @return The current value of the property.
     */
    public java.lang.String getDisplayName() {
        return this.displayName;
    }

    /**
     * Defaults to ID if not set
     *
     * @param displayName New value for the property.
     */
    public void setDisplayName(java.lang.String displayName) {
        this.displayName = displayName;
    }

    /**
     * Unique identifier of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getId() {
        return this.id;
    }

    /**
     * Unique identifier of this resource
     *
     * @param id New value for the property.
     */
    public void setId(java.lang.String id) {
        this.id = id;
    }

    /**
     * The type of this resource.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

    /**
     * The type of this resource.
     *
     * @param resourceType New value for the property.
     */
    public void setResourceType(java.lang.String resourceType) {
        this.resourceType = resourceType;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.Tag> getTags() {
        return this.tags;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @param tags New value for the property.
     */
    public void setTags(java.util.List<com.vmware.nsx_policy.model.Tag> tags) {
        this.tags = tags;
    }

    /**
     * This is a UUID generated by the system for knowing which site owns an object.
     * This is used in Pmaas
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getOriginSiteId() {
        return this.originSiteId;
    }

    /**
     * This is a UUID generated by the system for knowing which site owns an object.
     * This is used in Pmaas
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param originSiteId New value for the property.
     */
    public void setOriginSiteId(java.lang.String originSiteId) {
        this.originSiteId = originSiteId;
    }

    /**
     * This is a UUID generated by the system for knowing whoes owns this object. This
     * is used in Pmaas
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getOwnerId() {
        return this.ownerId;
    }

    /**
     * This is a UUID generated by the system for knowing whoes owns this object. This
     * is used in Pmaas
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param ownerId New value for the property.
     */
    public void setOwnerId(java.lang.String ownerId) {
        this.ownerId = ownerId;
    }

    /**
     * Path of its parent
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getParentPath() {
        return this.parentPath;
    }

    /**
     * Path of its parent
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param parentPath New value for the property.
     */
    public void setParentPath(java.lang.String parentPath) {
        this.parentPath = parentPath;
    }

    /**
     * Absolute path of this object
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPath() {
        return this.path;
    }

    /**
     * Absolute path of this object
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param path New value for the property.
     */
    public void setPath(java.lang.String path) {
        this.path = path;
    }

    /**
     * This is a UUID generated by the system for realizing the entity object. In most
     * cases this should be same as 'unique_id' of the entity. However, in some cases
     * this can be different because of entities have migrated thier unique identifier
     * to NSX Policy intent objects later in the timeline and did not use unique_id for
     * realization. Realization id is helpful for users to debug data path to correlate
     * the configuration with corresponding intent.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRealizationId() {
        return this.realizationId;
    }

    /**
     * This is a UUID generated by the system for realizing the entity object. In most
     * cases this should be same as 'unique_id' of the entity. However, in some cases
     * this can be different because of entities have migrated thier unique identifier
     * to NSX Policy intent objects later in the timeline and did not use unique_id for
     * realization. Realization id is helpful for users to debug data path to correlate
     * the configuration with corresponding intent.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param realizationId New value for the property.
     */
    public void setRealizationId(java.lang.String realizationId) {
        this.realizationId = realizationId;
    }

    /**
     * Path relative from its parent
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRelativePath() {
        return this.relativePath;
    }

    /**
     * Path relative from its parent
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param relativePath New value for the property.
     */
    public void setRelativePath(java.lang.String relativePath) {
        this.relativePath = relativePath;
    }

    /**
     * This is the path of the object on the local managers when queried on the PMaaS
     * service, and path of the object on PMaaS service when queried from the local
     * managers.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRemotePath() {
        return this.remotePath;
    }

    /**
     * This is the path of the object on the local managers when queried on the PMaaS
     * service, and path of the object on PMaaS service when queried from the local
     * managers.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param remotePath New value for the property.
     */
    public void setRemotePath(java.lang.String remotePath) {
        this.remotePath = remotePath;
    }

    /**
     * This is a UUID generated by the GM/LM to uniquely identify entites in a
     * federated environment. For entities that are stretched across multiple sites,
     * the same ID will be used on all the stretched sites.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getUniqueId() {
        return this.uniqueId;
    }

    /**
     * This is a UUID generated by the GM/LM to uniquely identify entites in a
     * federated environment. For entities that are stretched across multiple sites,
     * the same ID will be used on all the stretched sites.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param uniqueId New value for the property.
     */
    public void setUniqueId(java.lang.String uniqueId) {
        this.uniqueId = uniqueId;
    }

    /**
     * Subtree for this type within policy tree containing nested elements. Note that
     * this type is applicable to be used in Hierarchical API only.
     *
     * @return The current value of the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.ChildPolicyConfigResource}. When methods return a
     * value of this class as a return value, the property will contain all the
     * properties defined in {@link
     * com.vmware.nsx_policy.model.ChildPolicyConfigResource}.
     */
    public java.util.List<com.vmware.vapi.bindings.Structure> getChildren() {
        return this.children;
    }

    /**
     * Subtree for this type within policy tree containing nested elements. Note that
     * this type is applicable to be used in Hierarchical API only.
     *
     * @param children New value for the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.ChildPolicyConfigResource}. When methods return a
     * value of this class as a return value, the property will contain all the
     * properties defined in {@link
     * com.vmware.nsx_policy.model.ChildPolicyConfigResource}.
     */
    public void setChildren(java.util.List<com.vmware.vapi.bindings.Structure> children) {
        this.children = children;
    }

    /**
     * Intent objects are not directly deleted from the system when a delete is invoked
     * on them. They are marked for deletion and only when all the realized entities
     * for that intent object gets deleted, the intent object is deleted. Objects that
     * are marked for deletion are not returned in GET call. One can use the search API
     * to get these objects.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getMarkedForDelete() {
        return this.markedForDelete;
    }

    /**
     * Intent objects are not directly deleted from the system when a delete is invoked
     * on them. They are marked for deletion and only when all the realized entities
     * for that intent object gets deleted, the intent object is deleted. Objects that
     * are marked for deletion are not returned in GET call. One can use the search API
     * to get these objects.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param markedForDelete New value for the property.
     */
    public void setMarkedForDelete(java.lang.Boolean markedForDelete) {
        this.markedForDelete = markedForDelete;
    }

    /**
     * Global intent objects cannot be modified by the user. However, certain global
     * intent objects can be overridden locally by use of this property. In such cases,
     * the overridden local values take precedence over the globally defined values for
     * the properties.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getOverridden() {
        return this.overridden;
    }

    /**
     * Global intent objects cannot be modified by the user. However, certain global
     * intent objects can be overridden locally by use of this property. In such cases,
     * the overridden local values take precedence over the globally defined values for
     * the properties.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param overridden New value for the property.
     */
    public void setOverridden(java.lang.Boolean overridden) {
        this.overridden = overridden;
    }

    /**
     * Allow Rules to overwrite the policy mode. This must be set if the policy mode is
     * set to enforcement. Default value when not specified in API or module is
     * interpreted by ALB Controller as true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getAllowModeDelegation() {
        return this.allowModeDelegation;
    }

    /**
     * Allow Rules to overwrite the policy mode. This must be set if the policy mode is
     * set to enforcement. Default value when not specified in API or module is
     * interpreted by ALB Controller as true.
     *
     * @param allowModeDelegation New value for the property.
     */
    public void setAllowModeDelegation(java.lang.Boolean allowModeDelegation) {
        this.allowModeDelegation = allowModeDelegation;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.ALBWafApplicationSignatures getApplicationSignatures() {
        return this.applicationSignatures;
    }

    /**
     *
     *
     * @param applicationSignatures New value for the property.
     */
    public void setApplicationSignatures(com.vmware.nsx_policy.model.ALBWafApplicationSignatures applicationSignatures) {
        this.applicationSignatures = applicationSignatures;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.ALBAppLearningConfidenceOverride getConfidenceOverride() {
        return this.confidenceOverride;
    }

    /**
     *
     *
     * @param confidenceOverride New value for the property.
     */
    public void setConfidenceOverride(com.vmware.nsx_policy.model.ALBAppLearningConfidenceOverride confidenceOverride) {
        this.confidenceOverride = confidenceOverride;
    }

    /**
     * Creator name.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCreatedBy() {
        return this.createdBy;
    }

    /**
     * Creator name.
     *
     * @param createdBy New value for the property.
     */
    public void setCreatedBy(java.lang.String createdBy) {
        this.createdBy = createdBy;
    }

    /**
     * Override attributes for CRS rules.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.ALBWafRuleGroupOverrides> getCrsOverrides() {
        return this.crsOverrides;
    }

    /**
     * Override attributes for CRS rules.
     *
     * @param crsOverrides New value for the property.
     */
    public void setCrsOverrides(java.util.List<com.vmware.nsx_policy.model.ALBWafRuleGroupOverrides> crsOverrides) {
        this.crsOverrides = crsOverrides;
    }

    /**
     * Enable Application Learning for this WAF policy. Default value when not
     * specified in API or module is interpreted by ALB Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnableAppLearning() {
        return this.enableAppLearning;
    }

    /**
     * Enable Application Learning for this WAF policy. Default value when not
     * specified in API or module is interpreted by ALB Controller as false.
     *
     * @param enableAppLearning New value for the property.
     */
    public void setEnableAppLearning(java.lang.Boolean enableAppLearning) {
        this.enableAppLearning = enableAppLearning;
    }

    /**
     * Enable Application Learning based rule updates on the WAF Profile. Rules will be
     * programmed in dedicated WAF learning group. Default value when not specified in
     * API or module is interpreted by ALB Controller as true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnableAutoRuleUpdates() {
        return this.enableAutoRuleUpdates;
    }

    /**
     * Enable Application Learning based rule updates on the WAF Profile. Rules will be
     * programmed in dedicated WAF learning group. Default value when not specified in
     * API or module is interpreted by ALB Controller as true.
     *
     * @param enableAutoRuleUpdates New value for the property.
     */
    public void setEnableAutoRuleUpdates(java.lang.Boolean enableAutoRuleUpdates) {
        this.enableAutoRuleUpdates = enableAutoRuleUpdates;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBWafPolicy#FAILURE_MODE_OPEN}</li> <li> {@link
     * com.vmware.nsx_policy.model.ALBWafPolicy#FAILURE_MODE_CLOSED}</li> </ul> WAF
     * Policy failure mode. This can be 'Open' or 'Closed'. Enum options -
     * WAF_FAILURE_MODE_OPEN, WAF_FAILURE_MODE_CLOSED. Default value when not specified
     * in API or module is interpreted by ALB Controller as WAF_FAILURE_MODE_OPEN.
     *
     * @return The current value of the property.
     */
    public java.lang.String getFailureMode() {
        return this.failureMode;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBWafPolicy#FAILURE_MODE_OPEN}</li> <li> {@link
     * com.vmware.nsx_policy.model.ALBWafPolicy#FAILURE_MODE_CLOSED}</li> </ul> WAF
     * Policy failure mode. This can be 'Open' or 'Closed'. Enum options -
     * WAF_FAILURE_MODE_OPEN, WAF_FAILURE_MODE_CLOSED. Default value when not specified
     * in API or module is interpreted by ALB Controller as WAF_FAILURE_MODE_OPEN.
     *
     * @param failureMode New value for the property.
     */
    public void setFailureMode(java.lang.String failureMode) {
        this.failureMode = failureMode;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.ALBAppLearningParams getLearningParams() {
        return this.learningParams;
    }

    /**
     *
     *
     * @param learningParams New value for the property.
     */
    public void setLearningParams(com.vmware.nsx_policy.model.ALBAppLearningParams learningParams) {
        this.learningParams = learningParams;
    }

    /**
     * List of labels to be used for granular RBAC. Allowed in Basic edition,
     * Essentials edition, Enterprise edition.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.ALBRoleFilterMatchLabel> getMarkers() {
        return this.markers;
    }

    /**
     * List of labels to be used for granular RBAC. Allowed in Basic edition,
     * Essentials edition, Enterprise edition.
     *
     * @param markers New value for the property.
     */
    public void setMarkers(java.util.List<com.vmware.nsx_policy.model.ALBRoleFilterMatchLabel> markers) {
        this.markers = markers;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBWafPolicy#MIN_CONFIDENCE_VERY_HIGH}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBWafPolicy#MIN_CONFIDENCE_HIGH}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBWafPolicy#MIN_CONFIDENCE_PROBABLE}</li>
     * <li> {@link com.vmware.nsx_policy.model.ALBWafPolicy#MIN_CONFIDENCE_LOW}</li>
     * <li> {@link com.vmware.nsx_policy.model.ALBWafPolicy#MIN_CONFIDENCE_NONE}</li>
     * </ul> Minimum confidence label required for auto rule updates. Enum options -
     * CONFIDENCE_VERY_HIGH, CONFIDENCE_HIGH, CONFIDENCE_PROBABLE, CONFIDENCE_LOW,
     * CONFIDENCE_NONE. Default value when not specified in API or module is
     * interpreted by ALB Controller as CONFIDENCE_VERY_HIGH.
     *
     * @return The current value of the property.
     */
    public java.lang.String getMinConfidence() {
        return this.minConfidence;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBWafPolicy#MIN_CONFIDENCE_VERY_HIGH}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBWafPolicy#MIN_CONFIDENCE_HIGH}</li> <li>
     * {@link com.vmware.nsx_policy.model.ALBWafPolicy#MIN_CONFIDENCE_PROBABLE}</li>
     * <li> {@link com.vmware.nsx_policy.model.ALBWafPolicy#MIN_CONFIDENCE_LOW}</li>
     * <li> {@link com.vmware.nsx_policy.model.ALBWafPolicy#MIN_CONFIDENCE_NONE}</li>
     * </ul> Minimum confidence label required for auto rule updates. Enum options -
     * CONFIDENCE_VERY_HIGH, CONFIDENCE_HIGH, CONFIDENCE_PROBABLE, CONFIDENCE_LOW,
     * CONFIDENCE_NONE. Default value when not specified in API or module is
     * interpreted by ALB Controller as CONFIDENCE_VERY_HIGH.
     *
     * @param minConfidence New value for the property.
     */
    public void setMinConfidence(java.lang.String minConfidence) {
        this.minConfidence = minConfidence;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBWafPolicy#MODE_DETECTION_ONLY}</li> <li> {@link
     * com.vmware.nsx_policy.model.ALBWafPolicy#MODE_ENFORCEMENT}</li> </ul> WAF Policy
     * mode. This can be detection or enforcement. It can be overwritten by rules if
     * allow_mode_delegation is set. Enum options - WAF_MODE_DETECTION_ONLY,
     * WAF_MODE_ENFORCEMENT. Default value when not specified in API or module is
     * interpreted by ALB Controller as WAF_MODE_DETECTION_ONLY.
     *
     * @return The current value of the property.
     */
    public java.lang.String getMode() {
        return this.mode;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBWafPolicy#MODE_DETECTION_ONLY}</li> <li> {@link
     * com.vmware.nsx_policy.model.ALBWafPolicy#MODE_ENFORCEMENT}</li> </ul> WAF Policy
     * mode. This can be detection or enforcement. It can be overwritten by rules if
     * allow_mode_delegation is set. Enum options - WAF_MODE_DETECTION_ONLY,
     * WAF_MODE_ENFORCEMENT. Default value when not specified in API or module is
     * interpreted by ALB Controller as WAF_MODE_DETECTION_ONLY.
     *
     * @param mode New value for the property.
     */
    public void setMode(java.lang.String mode) {
        this.mode = mode;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBWafPolicy#PARANOIA_LEVEL_LOW}</li> <li> {@link
     * com.vmware.nsx_policy.model.ALBWafPolicy#PARANOIA_LEVEL_MEDIUM}</li> <li> {@link
     * com.vmware.nsx_policy.model.ALBWafPolicy#PARANOIA_LEVEL_HIGH}</li> <li> {@link
     * com.vmware.nsx_policy.model.ALBWafPolicy#PARANOIA_LEVEL_EXTREME}</li> </ul> WAF
     * Ruleset paranoia mode. This is used to select Rules based on the paranoia-level
     * tag. Enum options - WAF_PARANOIA_LEVEL_LOW, WAF_PARANOIA_LEVEL_MEDIUM,
     * WAF_PARANOIA_LEVEL_HIGH, WAF_PARANOIA_LEVEL_EXTREME. Default value when not
     * specified in API or module is interpreted by ALB Controller as
     * WAF_PARANOIA_LEVEL_LOW.
     *
     * @return The current value of the property.
     */
    public java.lang.String getParanoiaLevel() {
        return this.paranoiaLevel;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBWafPolicy#PARANOIA_LEVEL_LOW}</li> <li> {@link
     * com.vmware.nsx_policy.model.ALBWafPolicy#PARANOIA_LEVEL_MEDIUM}</li> <li> {@link
     * com.vmware.nsx_policy.model.ALBWafPolicy#PARANOIA_LEVEL_HIGH}</li> <li> {@link
     * com.vmware.nsx_policy.model.ALBWafPolicy#PARANOIA_LEVEL_EXTREME}</li> </ul> WAF
     * Ruleset paranoia mode. This is used to select Rules based on the paranoia-level
     * tag. Enum options - WAF_PARANOIA_LEVEL_LOW, WAF_PARANOIA_LEVEL_MEDIUM,
     * WAF_PARANOIA_LEVEL_HIGH, WAF_PARANOIA_LEVEL_EXTREME. Default value when not
     * specified in API or module is interpreted by ALB Controller as
     * WAF_PARANOIA_LEVEL_LOW.
     *
     * @param paranoiaLevel New value for the property.
     */
    public void setParanoiaLevel(java.lang.String paranoiaLevel) {
        this.paranoiaLevel = paranoiaLevel;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.ALBWafPositiveSecurityModel getPositiveSecurityModel() {
        return this.positiveSecurityModel;
    }

    /**
     *
     *
     * @param positiveSecurityModel New value for the property.
     */
    public void setPositiveSecurityModel(com.vmware.nsx_policy.model.ALBWafPositiveSecurityModel positiveSecurityModel) {
        this.positiveSecurityModel = positiveSecurityModel;
    }

    /**
     * WAF Rules are categorized in to groups based on their characterization. These
     * groups are created by the user and will be enforced after the CRS groups.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.ALBWafRuleGroup> getPostCrsGroups() {
        return this.postCrsGroups;
    }

    /**
     * WAF Rules are categorized in to groups based on their characterization. These
     * groups are created by the user and will be enforced after the CRS groups.
     *
     * @param postCrsGroups New value for the property.
     */
    public void setPostCrsGroups(java.util.List<com.vmware.nsx_policy.model.ALBWafRuleGroup> postCrsGroups) {
        this.postCrsGroups = postCrsGroups;
    }

    /**
     * WAF Rules are categorized in to groups based on their characterization. These
     * groups are created by the user and will be enforced before the CRS groups.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.ALBWafRuleGroup> getPreCrsGroups() {
        return this.preCrsGroups;
    }

    /**
     * WAF Rules are categorized in to groups based on their characterization. These
     * groups are created by the user and will be enforced before the CRS groups.
     *
     * @param preCrsGroups New value for the property.
     */
    public void setPreCrsGroups(java.util.List<com.vmware.nsx_policy.model.ALBWafRuleGroup> preCrsGroups) {
        this.preCrsGroups = preCrsGroups;
    }

    /**
     * WAF core ruleset used for the CRS part of this Policy. It is a reference to an
     * object of type WafCRS.
     *
     * @return The current value of the property.
     */
    public java.lang.String getWafCrsPath() {
        return this.wafCrsPath;
    }

    /**
     * WAF core ruleset used for the CRS part of this Policy. It is a reference to an
     * object of type WafCRS.
     *
     * @param wafCrsPath New value for the property.
     */
    public void setWafCrsPath(java.lang.String wafCrsPath) {
        this.wafCrsPath = wafCrsPath;
    }

    /**
     * WAF Profile for WAF policy. It is a reference to an object of type WafProfile.
     *
     * @return The current value of the property.
     */
    public java.lang.String getWafProfilePath() {
        return this.wafProfilePath;
    }

    /**
     * WAF Profile for WAF policy. It is a reference to an object of type WafProfile.
     *
     * @param wafProfilePath New value for the property.
     */
    public void setWafProfilePath(java.lang.String wafProfilePath) {
        this.wafProfilePath = wafProfilePath;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBWafPolicy;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("_links",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.links, this._getType().getField("_links")));
        structValue.setField("_schema",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.schema, this._getType().getField("_schema")));
        structValue.setField("_self",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.self, this._getType().getField("_self")));
        structValue.setField("_revision",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.revision, this._getType().getField("_revision")));
        structValue.setField("_create_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createTime, this._getType().getField("_create_time")));
        structValue.setField("_create_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createUser, this._getType().getField("_create_user")));
        structValue.setField("_last_modified_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedTime, this._getType().getField("_last_modified_time")));
        structValue.setField("_last_modified_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedUser, this._getType().getField("_last_modified_user")));
        structValue.setField("_protection",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.protection, this._getType().getField("_protection")));
        structValue.setField("_system_owned",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.systemOwned, this._getType().getField("_system_owned")));
        structValue.setField("description",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.description, this._getType().getField("description")));
        structValue.setField("display_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.displayName, this._getType().getField("display_name")));
        structValue.setField("id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.id, this._getType().getField("id")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
        structValue.setField("tags",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tags, this._getType().getField("tags")));
        structValue.setField("origin_site_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.originSiteId, this._getType().getField("origin_site_id")));
        structValue.setField("owner_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ownerId, this._getType().getField("owner_id")));
        structValue.setField("parent_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.parentPath, this._getType().getField("parent_path")));
        structValue.setField("path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.path, this._getType().getField("path")));
        structValue.setField("realization_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.realizationId, this._getType().getField("realization_id")));
        structValue.setField("relative_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.relativePath, this._getType().getField("relative_path")));
        structValue.setField("remote_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.remotePath, this._getType().getField("remote_path")));
        structValue.setField("unique_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.uniqueId, this._getType().getField("unique_id")));
        structValue.setField("children",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.children, this._getType().getField("children")));
        structValue.setField("marked_for_delete",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.markedForDelete, this._getType().getField("marked_for_delete")));
        structValue.setField("overridden",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.overridden, this._getType().getField("overridden")));
        structValue.setField("allow_mode_delegation",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.allowModeDelegation, this._getType().getField("allow_mode_delegation")));
        structValue.setField("application_signatures",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.applicationSignatures, this._getType().getField("application_signatures")));
        structValue.setField("confidence_override",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.confidenceOverride, this._getType().getField("confidence_override")));
        structValue.setField("created_by",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createdBy, this._getType().getField("created_by")));
        structValue.setField("crs_overrides",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.crsOverrides, this._getType().getField("crs_overrides")));
        structValue.setField("enable_app_learning",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enableAppLearning, this._getType().getField("enable_app_learning")));
        structValue.setField("enable_auto_rule_updates",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enableAutoRuleUpdates, this._getType().getField("enable_auto_rule_updates")));
        structValue.setField("failure_mode",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.failureMode, this._getType().getField("failure_mode")));
        structValue.setField("learning_params",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.learningParams, this._getType().getField("learning_params")));
        structValue.setField("markers",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.markers, this._getType().getField("markers")));
        structValue.setField("min_confidence",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.minConfidence, this._getType().getField("min_confidence")));
        structValue.setField("mode",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.mode, this._getType().getField("mode")));
        structValue.setField("paranoia_level",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.paranoiaLevel, this._getType().getField("paranoia_level")));
        structValue.setField("positive_security_model",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.positiveSecurityModel, this._getType().getField("positive_security_model")));
        structValue.setField("post_crs_groups",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.postCrsGroups, this._getType().getField("post_crs_groups")));
        structValue.setField("pre_crs_groups",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.preCrsGroups, this._getType().getField("pre_crs_groups")));
        structValue.setField("waf_crs_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.wafCrsPath, this._getType().getField("waf_crs_path")));
        structValue.setField("waf_profile_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.wafProfilePath, this._getType().getField("waf_profile_path")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ALBWafPolicy;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.ALBWafPolicy.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBWafPolicy _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBWafPolicy(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBWafPolicy _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBWafPolicy(structValue);
    }

    /**
     * Builder class for {@link ALBWafPolicy}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.nsx_policy.model.ResourceLink> links;
        private java.lang.String schema;
        private com.vmware.nsx_policy.model.SelfResourceLink self;
        private java.lang.Long revision;
        private java.lang.Long createTime;
        private java.lang.String createUser;
        private java.lang.Long lastModifiedTime;
        private java.lang.String lastModifiedUser;
        private java.lang.String protection;
        private java.lang.Boolean systemOwned;
        private java.lang.String description;
        private java.lang.String displayName;
        private java.lang.String id;
        private java.lang.String resourceType;
        private java.util.List<com.vmware.nsx_policy.model.Tag> tags;
        private java.lang.String originSiteId;
        private java.lang.String ownerId;
        private java.lang.String parentPath;
        private java.lang.String path;
        private java.lang.String realizationId;
        private java.lang.String relativePath;
        private java.lang.String remotePath;
        private java.lang.String uniqueId;
        private java.util.List<com.vmware.vapi.bindings.Structure> children;
        private java.lang.Boolean markedForDelete;
        private java.lang.Boolean overridden;
        private java.lang.Boolean allowModeDelegation;
        private com.vmware.nsx_policy.model.ALBWafApplicationSignatures applicationSignatures;
        private com.vmware.nsx_policy.model.ALBAppLearningConfidenceOverride confidenceOverride;
        private java.lang.String createdBy;
        private java.util.List<com.vmware.nsx_policy.model.ALBWafRuleGroupOverrides> crsOverrides;
        private java.lang.Boolean enableAppLearning;
        private java.lang.Boolean enableAutoRuleUpdates;
        private java.lang.String failureMode;
        private com.vmware.nsx_policy.model.ALBAppLearningParams learningParams;
        private java.util.List<com.vmware.nsx_policy.model.ALBRoleFilterMatchLabel> markers;
        private java.lang.String minConfidence;
        private java.lang.String mode;
        private java.lang.String paranoiaLevel;
        private com.vmware.nsx_policy.model.ALBWafPositiveSecurityModel positiveSecurityModel;
        private java.util.List<com.vmware.nsx_policy.model.ALBWafRuleGroup> postCrsGroups;
        private java.util.List<com.vmware.nsx_policy.model.ALBWafRuleGroup> preCrsGroups;
        private java.lang.String wafCrsPath;
        private java.lang.String wafProfilePath;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBWafPolicy}.
         */
        public Builder() {
        }

        /**
         * The server will populate this field when returing the resource. Ignored on PUT
         * and POST.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param links New value for the property.
         */
        public Builder setLinks(java.util.List<com.vmware.nsx_policy.model.ResourceLink> links) {
            this.links = links;
            return this;
        }

        /**
         * Schema for this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param schema New value for the property.
         */
        public Builder setSchema(java.lang.String schema) {
            this.schema = schema;
            return this;
        }

        /**
         *
         *
         * @param self New value for the property.
         */
        public Builder setSelf(com.vmware.nsx_policy.model.SelfResourceLink self) {
            this.self = self;
            return this;
        }

        /**
         * The _revision property describes the current revision of the resource. To
         * prevent clients from overwriting each other's changes, PUT operations must
         * include the current _revision of the resource, which clients should obtain by
         * issuing a GET operation. If the _revision provided in a PUT request is missing
         * or stale, the operation will be rejected. format: int32
         *
         * @param revision New value for the property.
         */
        public Builder setRevision(java.lang.Long revision) {
            this.revision = revision;
            return this;
        }

        /**
         * Timestamp of resource creation format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createTime New value for the property.
         */
        public Builder setCreateTime(java.lang.Long createTime) {
            this.createTime = createTime;
            return this;
        }

        /**
         * ID of the user who created this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createUser New value for the property.
         */
        public Builder setCreateUser(java.lang.String createUser) {
            this.createUser = createUser;
            return this;
        }

        /**
         * Timestamp of last modification format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedTime New value for the property.
         */
        public Builder setLastModifiedTime(java.lang.Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        /**
         * ID of the user who last modified this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedUser New value for the property.
         */
        public Builder setLastModifiedUser(java.lang.String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
            return this;
        }

        /**
         * Protection status is one of the following: PROTECTED - the client who retrieved
         * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
         * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
         * the entity is a super user and can modify it, but only when providing the
         * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
         * be determined for this entity.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param protection New value for the property.
         */
        public Builder setProtection(java.lang.String protection) {
            this.protection = protection;
            return this;
        }

        /**
         * Indicates system owned resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param systemOwned New value for the property.
         */
        public Builder setSystemOwned(java.lang.Boolean systemOwned) {
            this.systemOwned = systemOwned;
            return this;
        }

        /**
         * Description of this resource
         *
         * @param description New value for the property.
         */
        public Builder setDescription(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Defaults to ID if not set
         *
         * @param displayName New value for the property.
         */
        public Builder setDisplayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Unique identifier of this resource
         *
         * @param id New value for the property.
         */
        public Builder setId(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * The type of this resource.
         *
         * @param resourceType New value for the property.
         */
        public Builder setResourceType(java.lang.String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        /**
         * Opaque identifiers meaningful to the API user
         *
         * @param tags New value for the property.
         */
        public Builder setTags(java.util.List<com.vmware.nsx_policy.model.Tag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * This is a UUID generated by the system for knowing which site owns an object.
         * This is used in Pmaas
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param originSiteId New value for the property.
         */
        public Builder setOriginSiteId(java.lang.String originSiteId) {
            this.originSiteId = originSiteId;
            return this;
        }

        /**
         * This is a UUID generated by the system for knowing whoes owns this object. This
         * is used in Pmaas
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param ownerId New value for the property.
         */
        public Builder setOwnerId(java.lang.String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        /**
         * Path of its parent
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param parentPath New value for the property.
         */
        public Builder setParentPath(java.lang.String parentPath) {
            this.parentPath = parentPath;
            return this;
        }

        /**
         * Absolute path of this object
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param path New value for the property.
         */
        public Builder setPath(java.lang.String path) {
            this.path = path;
            return this;
        }

        /**
         * This is a UUID generated by the system for realizing the entity object. In most
         * cases this should be same as 'unique_id' of the entity. However, in some cases
         * this can be different because of entities have migrated thier unique identifier
         * to NSX Policy intent objects later in the timeline and did not use unique_id for
         * realization. Realization id is helpful for users to debug data path to correlate
         * the configuration with corresponding intent.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param realizationId New value for the property.
         */
        public Builder setRealizationId(java.lang.String realizationId) {
            this.realizationId = realizationId;
            return this;
        }

        /**
         * Path relative from its parent
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param relativePath New value for the property.
         */
        public Builder setRelativePath(java.lang.String relativePath) {
            this.relativePath = relativePath;
            return this;
        }

        /**
         * This is the path of the object on the local managers when queried on the PMaaS
         * service, and path of the object on PMaaS service when queried from the local
         * managers.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param remotePath New value for the property.
         */
        public Builder setRemotePath(java.lang.String remotePath) {
            this.remotePath = remotePath;
            return this;
        }

        /**
         * This is a UUID generated by the GM/LM to uniquely identify entites in a
         * federated environment. For entities that are stretched across multiple sites,
         * the same ID will be used on all the stretched sites.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param uniqueId New value for the property.
         */
        public Builder setUniqueId(java.lang.String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        /**
         * Subtree for this type within policy tree containing nested elements. Note that
         * this type is applicable to be used in Hierarchical API only.
         *
         * @param children New value for the property.
         * When clients pass a value of this class as a parameter, the property must
         * contain all the properties defined in {@link
         * com.vmware.nsx_policy.model.ChildPolicyConfigResource}. When methods return a
         * value of this class as a return value, the property will contain all the
         * properties defined in {@link
         * com.vmware.nsx_policy.model.ChildPolicyConfigResource}.
         */
        public Builder setChildren(java.util.List<com.vmware.vapi.bindings.Structure> children) {
            this.children = children;
            return this;
        }

        /**
         * Intent objects are not directly deleted from the system when a delete is invoked
         * on them. They are marked for deletion and only when all the realized entities
         * for that intent object gets deleted, the intent object is deleted. Objects that
         * are marked for deletion are not returned in GET call. One can use the search API
         * to get these objects.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param markedForDelete New value for the property.
         */
        public Builder setMarkedForDelete(java.lang.Boolean markedForDelete) {
            this.markedForDelete = markedForDelete;
            return this;
        }

        /**
         * Global intent objects cannot be modified by the user. However, certain global
         * intent objects can be overridden locally by use of this property. In such cases,
         * the overridden local values take precedence over the globally defined values for
         * the properties.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param overridden New value for the property.
         */
        public Builder setOverridden(java.lang.Boolean overridden) {
            this.overridden = overridden;
            return this;
        }

        /**
         * Allow Rules to overwrite the policy mode. This must be set if the policy mode is
         * set to enforcement. Default value when not specified in API or module is
         * interpreted by ALB Controller as true.
         *
         * @param allowModeDelegation New value for the property.
         */
        public Builder setAllowModeDelegation(java.lang.Boolean allowModeDelegation) {
            this.allowModeDelegation = allowModeDelegation;
            return this;
        }

        /**
         *
         *
         * @param applicationSignatures New value for the property.
         */
        public Builder setApplicationSignatures(com.vmware.nsx_policy.model.ALBWafApplicationSignatures applicationSignatures) {
            this.applicationSignatures = applicationSignatures;
            return this;
        }

        /**
         *
         *
         * @param confidenceOverride New value for the property.
         */
        public Builder setConfidenceOverride(com.vmware.nsx_policy.model.ALBAppLearningConfidenceOverride confidenceOverride) {
            this.confidenceOverride = confidenceOverride;
            return this;
        }

        /**
         * Creator name.
         *
         * @param createdBy New value for the property.
         */
        public Builder setCreatedBy(java.lang.String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        /**
         * Override attributes for CRS rules.
         *
         * @param crsOverrides New value for the property.
         */
        public Builder setCrsOverrides(java.util.List<com.vmware.nsx_policy.model.ALBWafRuleGroupOverrides> crsOverrides) {
            this.crsOverrides = crsOverrides;
            return this;
        }

        /**
         * Enable Application Learning for this WAF policy. Default value when not
         * specified in API or module is interpreted by ALB Controller as false.
         *
         * @param enableAppLearning New value for the property.
         */
        public Builder setEnableAppLearning(java.lang.Boolean enableAppLearning) {
            this.enableAppLearning = enableAppLearning;
            return this;
        }

        /**
         * Enable Application Learning based rule updates on the WAF Profile. Rules will be
         * programmed in dedicated WAF learning group. Default value when not specified in
         * API or module is interpreted by ALB Controller as true.
         *
         * @param enableAutoRuleUpdates New value for the property.
         */
        public Builder setEnableAutoRuleUpdates(java.lang.Boolean enableAutoRuleUpdates) {
            this.enableAutoRuleUpdates = enableAutoRuleUpdates;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.ALBWafPolicy#FAILURE_MODE_OPEN}</li> <li> {@link
         * com.vmware.nsx_policy.model.ALBWafPolicy#FAILURE_MODE_CLOSED}</li> </ul> WAF
         * Policy failure mode. This can be 'Open' or 'Closed'. Enum options -
         * WAF_FAILURE_MODE_OPEN, WAF_FAILURE_MODE_CLOSED. Default value when not specified
         * in API or module is interpreted by ALB Controller as WAF_FAILURE_MODE_OPEN.
         *
         * @param failureMode New value for the property.
         */
        public Builder setFailureMode(java.lang.String failureMode) {
            this.failureMode = failureMode;
            return this;
        }

        /**
         *
         *
         * @param learningParams New value for the property.
         */
        public Builder setLearningParams(com.vmware.nsx_policy.model.ALBAppLearningParams learningParams) {
            this.learningParams = learningParams;
            return this;
        }

        /**
         * List of labels to be used for granular RBAC. Allowed in Basic edition,
         * Essentials edition, Enterprise edition.
         *
         * @param markers New value for the property.
         */
        public Builder setMarkers(java.util.List<com.vmware.nsx_policy.model.ALBRoleFilterMatchLabel> markers) {
            this.markers = markers;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.ALBWafPolicy#MIN_CONFIDENCE_VERY_HIGH}</li> <li>
         * {@link com.vmware.nsx_policy.model.ALBWafPolicy#MIN_CONFIDENCE_HIGH}</li> <li>
         * {@link com.vmware.nsx_policy.model.ALBWafPolicy#MIN_CONFIDENCE_PROBABLE}</li>
         * <li> {@link com.vmware.nsx_policy.model.ALBWafPolicy#MIN_CONFIDENCE_LOW}</li>
         * <li> {@link com.vmware.nsx_policy.model.ALBWafPolicy#MIN_CONFIDENCE_NONE}</li>
         * </ul> Minimum confidence label required for auto rule updates. Enum options -
         * CONFIDENCE_VERY_HIGH, CONFIDENCE_HIGH, CONFIDENCE_PROBABLE, CONFIDENCE_LOW,
         * CONFIDENCE_NONE. Default value when not specified in API or module is
         * interpreted by ALB Controller as CONFIDENCE_VERY_HIGH.
         *
         * @param minConfidence New value for the property.
         */
        public Builder setMinConfidence(java.lang.String minConfidence) {
            this.minConfidence = minConfidence;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.ALBWafPolicy#MODE_DETECTION_ONLY}</li> <li> {@link
         * com.vmware.nsx_policy.model.ALBWafPolicy#MODE_ENFORCEMENT}</li> </ul> WAF Policy
         * mode. This can be detection or enforcement. It can be overwritten by rules if
         * allow_mode_delegation is set. Enum options - WAF_MODE_DETECTION_ONLY,
         * WAF_MODE_ENFORCEMENT. Default value when not specified in API or module is
         * interpreted by ALB Controller as WAF_MODE_DETECTION_ONLY.
         *
         * @param mode New value for the property.
         */
        public Builder setMode(java.lang.String mode) {
            this.mode = mode;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.ALBWafPolicy#PARANOIA_LEVEL_LOW}</li> <li> {@link
         * com.vmware.nsx_policy.model.ALBWafPolicy#PARANOIA_LEVEL_MEDIUM}</li> <li> {@link
         * com.vmware.nsx_policy.model.ALBWafPolicy#PARANOIA_LEVEL_HIGH}</li> <li> {@link
         * com.vmware.nsx_policy.model.ALBWafPolicy#PARANOIA_LEVEL_EXTREME}</li> </ul> WAF
         * Ruleset paranoia mode. This is used to select Rules based on the paranoia-level
         * tag. Enum options - WAF_PARANOIA_LEVEL_LOW, WAF_PARANOIA_LEVEL_MEDIUM,
         * WAF_PARANOIA_LEVEL_HIGH, WAF_PARANOIA_LEVEL_EXTREME. Default value when not
         * specified in API or module is interpreted by ALB Controller as
         * WAF_PARANOIA_LEVEL_LOW.
         *
         * @param paranoiaLevel New value for the property.
         */
        public Builder setParanoiaLevel(java.lang.String paranoiaLevel) {
            this.paranoiaLevel = paranoiaLevel;
            return this;
        }

        /**
         *
         *
         * @param positiveSecurityModel New value for the property.
         */
        public Builder setPositiveSecurityModel(com.vmware.nsx_policy.model.ALBWafPositiveSecurityModel positiveSecurityModel) {
            this.positiveSecurityModel = positiveSecurityModel;
            return this;
        }

        /**
         * WAF Rules are categorized in to groups based on their characterization. These
         * groups are created by the user and will be enforced after the CRS groups.
         *
         * @param postCrsGroups New value for the property.
         */
        public Builder setPostCrsGroups(java.util.List<com.vmware.nsx_policy.model.ALBWafRuleGroup> postCrsGroups) {
            this.postCrsGroups = postCrsGroups;
            return this;
        }

        /**
         * WAF Rules are categorized in to groups based on their characterization. These
         * groups are created by the user and will be enforced before the CRS groups.
         *
         * @param preCrsGroups New value for the property.
         */
        public Builder setPreCrsGroups(java.util.List<com.vmware.nsx_policy.model.ALBWafRuleGroup> preCrsGroups) {
            this.preCrsGroups = preCrsGroups;
            return this;
        }

        /**
         * WAF core ruleset used for the CRS part of this Policy. It is a reference to an
         * object of type WafCRS.
         *
         * @param wafCrsPath New value for the property.
         */
        public Builder setWafCrsPath(java.lang.String wafCrsPath) {
            this.wafCrsPath = wafCrsPath;
            return this;
        }

        /**
         * WAF Profile for WAF policy. It is a reference to an object of type WafProfile.
         *
         * @param wafProfilePath New value for the property.
         */
        public Builder setWafProfilePath(java.lang.String wafProfilePath) {
            this.wafProfilePath = wafProfilePath;
            return this;
        }

        public ALBWafPolicy build() {
            ALBWafPolicy result = new ALBWafPolicy();
            result.setLinks(this.links);
            result.setSchema(this.schema);
            result.setSelf(this.self);
            result.setRevision(this.revision);
            result.setCreateTime(this.createTime);
            result.setCreateUser(this.createUser);
            result.setLastModifiedTime(this.lastModifiedTime);
            result.setLastModifiedUser(this.lastModifiedUser);
            result.setProtection(this.protection);
            result.setSystemOwned(this.systemOwned);
            result.setDescription(this.description);
            result.setDisplayName(this.displayName);
            result.setId(this.id);
            result.setResourceType(this.resourceType);
            result.setTags(this.tags);
            result.setOriginSiteId(this.originSiteId);
            result.setOwnerId(this.ownerId);
            result.setParentPath(this.parentPath);
            result.setPath(this.path);
            result.setRealizationId(this.realizationId);
            result.setRelativePath(this.relativePath);
            result.setRemotePath(this.remotePath);
            result.setUniqueId(this.uniqueId);
            result.setChildren(this.children);
            result.setMarkedForDelete(this.markedForDelete);
            result.setOverridden(this.overridden);
            result.setAllowModeDelegation(this.allowModeDelegation);
            result.setApplicationSignatures(this.applicationSignatures);
            result.setConfidenceOverride(this.confidenceOverride);
            result.setCreatedBy(this.createdBy);
            result.setCrsOverrides(this.crsOverrides);
            result.setEnableAppLearning(this.enableAppLearning);
            result.setEnableAutoRuleUpdates(this.enableAutoRuleUpdates);
            result.setFailureMode(this.failureMode);
            result.setLearningParams(this.learningParams);
            result.setMarkers(this.markers);
            result.setMinConfidence(this.minConfidence);
            result.setMode(this.mode);
            result.setParanoiaLevel(this.paranoiaLevel);
            result.setPositiveSecurityModel(this.positiveSecurityModel);
            result.setPostCrsGroups(this.postCrsGroups);
            result.setPreCrsGroups(this.preCrsGroups);
            result.setWafCrsPath(this.wafCrsPath);
            result.setWafProfilePath(this.wafProfilePath);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("_links", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.resourceLink; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_links",
                                                                                "links",
                                                                                "getLinks",
                                                                                "setLinks");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_schema", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_schema",
                                                                                "schema",
                                                                                "getSchema",
                                                                                "setSchema");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_self", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.selfResourceLink; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_self",
                                                                                "self",
                                                                                "getSelf",
                                                                                "setSelf");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_revision", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_revision",
                                                                                "revision",
                                                                                "getRevision",
                                                                                "setRevision");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_time",
                                                                                "createTime",
                                                                                "getCreateTime",
                                                                                "setCreateTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_user",
                                                                                "createUser",
                                                                                "getCreateUser",
                                                                                "setCreateUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_time",
                                                                                "lastModifiedTime",
                                                                                "getLastModifiedTime",
                                                                                "setLastModifiedTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_user",
                                                                                "lastModifiedUser",
                                                                                "getLastModifiedUser",
                                                                                "setLastModifiedUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_protection", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_protection",
                                                                                "protection",
                                                                                "getProtection",
                                                                                "setProtection");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_system_owned", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_system_owned",
                                                                                "systemOwned",
                                                                                "getSystemOwned",
                                                                                "setSystemOwned");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("description", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("description",
                                                                                "description",
                                                                                "getDescription",
                                                                                "setDescription");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("display_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("display_name",
                                                                                "displayName",
                                                                                "getDisplayName",
                                                                                "setDisplayName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("id",
                                                                                "id",
                                                                                "getId",
                                                                                "setId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                "setResourceType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tags", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.tag; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tags",
                                                                                "tags",
                                                                                "getTags",
                                                                                "setTags");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("origin_site_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("origin_site_id",
                                                                                "originSiteId",
                                                                                "getOriginSiteId",
                                                                                "setOriginSiteId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("owner_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("owner_id",
                                                                                "ownerId",
                                                                                "getOwnerId",
                                                                                "setOwnerId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("parent_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("parent_path",
                                                                                "parentPath",
                                                                                "getParentPath",
                                                                                "setParentPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("path",
                                                                                "path",
                                                                                "getPath",
                                                                                "setPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("realization_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("realization_id",
                                                                                "realizationId",
                                                                                "getRealizationId",
                                                                                "setRealizationId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("relative_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("relative_path",
                                                                                "relativePath",
                                                                                "getRelativePath",
                                                                                "setRelativePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("remote_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("remote_path",
                                                                                "remotePath",
                                                                                "getRemotePath",
                                                                                "setRemotePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("unique_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("unique_id",
                                                                                "uniqueId",
                                                                                "getUniqueId",
                                                                                "setUniqueId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("children", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.DynamicStructType(java.util.Arrays.<com.vmware.vapi.internal.data.ConstraintValidator>asList(new com.vmware.vapi.internal.bindings.HasFieldsOfValidator(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.childPolicyConfigResource; } }))))));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("children",
                                                                                "children",
                                                                                "getChildren",
                                                                                "setChildren");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("marked_for_delete", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("marked_for_delete",
                                                                                "markedForDelete",
                                                                                "getMarkedForDelete",
                                                                                "setMarkedForDelete");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("overridden", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("overridden",
                                                                                "overridden",
                                                                                "getOverridden",
                                                                                "setOverridden");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("allow_mode_delegation", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("allow_mode_delegation",
                                                                                "allowModeDelegation",
                                                                                "getAllowModeDelegation",
                                                                                "setAllowModeDelegation");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("application_signatures", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.ALBWafApplicationSignatures; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("application_signatures",
                                                                                "applicationSignatures",
                                                                                "getApplicationSignatures",
                                                                                "setApplicationSignatures");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("confidence_override", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.ALBAppLearningConfidenceOverride; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("confidence_override",
                                                                                "confidenceOverride",
                                                                                "getConfidenceOverride",
                                                                                "setConfidenceOverride");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("created_by", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("created_by",
                                                                                "createdBy",
                                                                                "getCreatedBy",
                                                                                "setCreatedBy");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("crs_overrides", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.ALBWafRuleGroupOverrides; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("crs_overrides",
                                                                                "crsOverrides",
                                                                                "getCrsOverrides",
                                                                                "setCrsOverrides");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("enable_app_learning", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enable_app_learning",
                                                                                "enableAppLearning",
                                                                                "getEnableAppLearning",
                                                                                "setEnableAppLearning");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("enable_auto_rule_updates", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enable_auto_rule_updates",
                                                                                "enableAutoRuleUpdates",
                                                                                "getEnableAutoRuleUpdates",
                                                                                "setEnableAutoRuleUpdates");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("failure_mode", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("failure_mode",
                                                                                "failureMode",
                                                                                "getFailureMode",
                                                                                "setFailureMode");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("learning_params", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.ALBAppLearningParams; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("learning_params",
                                                                                "learningParams",
                                                                                "getLearningParams",
                                                                                "setLearningParams");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("markers", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.ALBRoleFilterMatchLabel; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("markers",
                                                                                "markers",
                                                                                "getMarkers",
                                                                                "setMarkers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("min_confidence", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("min_confidence",
                                                                                "minConfidence",
                                                                                "getMinConfidence",
                                                                                "setMinConfidence");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("mode", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("mode",
                                                                                "mode",
                                                                                "getMode",
                                                                                "setMode");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("paranoia_level", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("paranoia_level",
                                                                                "paranoiaLevel",
                                                                                "getParanoiaLevel",
                                                                                "setParanoiaLevel");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("positive_security_model", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.ALBWafPositiveSecurityModel; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("positive_security_model",
                                                                                "positiveSecurityModel",
                                                                                "getPositiveSecurityModel",
                                                                                "setPositiveSecurityModel");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("post_crs_groups", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.ALBWafRuleGroup; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("post_crs_groups",
                                                                                "postCrsGroups",
                                                                                "getPostCrsGroups",
                                                                                "setPostCrsGroups");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("pre_crs_groups", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.ALBWafRuleGroup; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("pre_crs_groups",
                                                                                "preCrsGroups",
                                                                                "getPreCrsGroups",
                                                                                "setPreCrsGroups");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("waf_crs_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("waf_crs_path",
                                                                                "wafCrsPath",
                                                                                "getWafCrsPath",
                                                                                "setWafCrsPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("waf_profile_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("waf_profile_path",
                                                                                "wafProfilePath",
                                                                                "getWafProfilePath",
                                                                                "setWafProfilePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.ALB_waf_policy",
                                                            fields,
                                                            com.vmware.nsx_policy.model.ALBWafPolicy.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

