/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * BFD information
 */
public final class BFDProperties implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String BFD_ENCAP_GENEVE = "GENEVE";

    public static final java.lang.String BFD_ENCAP_NONE = "NONE";

    public static final java.lang.String BFD_ENCAP_UNKNOWN_ENCAP = "UNKNOWN_ENCAP";

    public static final java.lang.String REMOTE_STATE_UNKNOWN_STATE = "UNKNOWN_STATE";

    public static final java.lang.String REMOTE_STATE_ADMIN_DOWN = "ADMIN_DOWN";

    public static final java.lang.String REMOTE_STATE_DOWN = "DOWN";

    public static final java.lang.String REMOTE_STATE_INIT = "INIT";

    public static final java.lang.String REMOTE_STATE_UP = "UP";

    public static final java.lang.String STATE_UNKNOWN_STATE = "UNKNOWN_STATE";

    public static final java.lang.String STATE_ADMIN_DOWN = "ADMIN_DOWN";

    public static final java.lang.String STATE_DOWN = "DOWN";

    public static final java.lang.String STATE_INIT = "INIT";

    public static final java.lang.String STATE_UP = "UP";

    private java.lang.Boolean active;

    private java.lang.String bfdEncap;

    private java.lang.String diagnostic;

    private java.lang.Boolean forwarding;

    private java.lang.String remoteDiagnostic;

    private java.lang.String remoteState;

    private java.lang.String state;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public BFDProperties() {
    }

    protected BFDProperties(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * True if tunnel is active in a gateway HA setup
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getActive() {
        return this.active;
    }

    /**
     * True if tunnel is active in a gateway HA setup
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param active New value for the property.
     */
    public void setActive(java.lang.Boolean active) {
        this.active = active;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.BFDProperties#BFD_ENCAP_GENEVE}</li> <li> {@link
     * com.vmware.nsx_policy.model.BFDProperties#BFD_ENCAP_NONE}</li> <li> {@link
     * com.vmware.nsx_policy.model.BFDProperties#BFD_ENCAP_UNKNOWN_ENCAP}</li> </ul>
     * The encapsulation type of BFD. GENEVE - BFD with GENEVE encapsulation NONE - BFD
     * with no encapsulation UNKNOWN_ENCAP - BFD with unknown encapsulation
     *
     * @return The current value of the property.
     */
    public java.lang.String getBfdEncap() {
        return this.bfdEncap;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.BFDProperties#BFD_ENCAP_GENEVE}</li> <li> {@link
     * com.vmware.nsx_policy.model.BFDProperties#BFD_ENCAP_NONE}</li> <li> {@link
     * com.vmware.nsx_policy.model.BFDProperties#BFD_ENCAP_UNKNOWN_ENCAP}</li> </ul>
     * The encapsulation type of BFD. GENEVE - BFD with GENEVE encapsulation NONE - BFD
     * with no encapsulation UNKNOWN_ENCAP - BFD with unknown encapsulation
     *
     * @param bfdEncap New value for the property.
     */
    public void setBfdEncap(java.lang.String bfdEncap) {
        this.bfdEncap = bfdEncap;
    }

    /**
     * A short message indicating what the BFD session thinks is wrong in case of a
     * problem
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDiagnostic() {
        return this.diagnostic;
    }

    /**
     * A short message indicating what the BFD session thinks is wrong in case of a
     * problem
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param diagnostic New value for the property.
     */
    public void setDiagnostic(java.lang.String diagnostic) {
        this.diagnostic = diagnostic;
    }

    /**
     * True if the BFD session believes this interface may be used to forward traffic
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getForwarding() {
        return this.forwarding;
    }

    /**
     * True if the BFD session believes this interface may be used to forward traffic
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param forwarding New value for the property.
     */
    public void setForwarding(java.lang.Boolean forwarding) {
        this.forwarding = forwarding;
    }

    /**
     * A short message indicating what the remote interface's BFD session thinks is
     * wrong in case of a problem
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRemoteDiagnostic() {
        return this.remoteDiagnostic;
    }

    /**
     * A short message indicating what the remote interface's BFD session thinks is
     * wrong in case of a problem
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param remoteDiagnostic New value for the property.
     */
    public void setRemoteDiagnostic(java.lang.String remoteDiagnostic) {
        this.remoteDiagnostic = remoteDiagnostic;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.BFDProperties#REMOTE_STATE_UNKNOWN_STATE}</li> <li>
     * {@link com.vmware.nsx_policy.model.BFDProperties#REMOTE_STATE_ADMIN_DOWN}</li>
     * <li> {@link com.vmware.nsx_policy.model.BFDProperties#REMOTE_STATE_DOWN}</li>
     * <li> {@link com.vmware.nsx_policy.model.BFDProperties#REMOTE_STATE_INIT}</li>
     * <li> {@link com.vmware.nsx_policy.model.BFDProperties#REMOTE_STATE_UP}</li>
     * </ul> State of the remote interface's BFD session
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRemoteState() {
        return this.remoteState;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.BFDProperties#REMOTE_STATE_UNKNOWN_STATE}</li> <li>
     * {@link com.vmware.nsx_policy.model.BFDProperties#REMOTE_STATE_ADMIN_DOWN}</li>
     * <li> {@link com.vmware.nsx_policy.model.BFDProperties#REMOTE_STATE_DOWN}</li>
     * <li> {@link com.vmware.nsx_policy.model.BFDProperties#REMOTE_STATE_INIT}</li>
     * <li> {@link com.vmware.nsx_policy.model.BFDProperties#REMOTE_STATE_UP}</li>
     * </ul> State of the remote interface's BFD session
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param remoteState New value for the property.
     */
    public void setRemoteState(java.lang.String remoteState) {
        this.remoteState = remoteState;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.BFDProperties#STATE_UNKNOWN_STATE}</li> <li> {@link
     * com.vmware.nsx_policy.model.BFDProperties#STATE_ADMIN_DOWN}</li> <li> {@link
     * com.vmware.nsx_policy.model.BFDProperties#STATE_DOWN}</li> <li> {@link
     * com.vmware.nsx_policy.model.BFDProperties#STATE_INIT}</li> <li> {@link
     * com.vmware.nsx_policy.model.BFDProperties#STATE_UP}</li> </ul> State of the BFD
     * session
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getState() {
        return this.state;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.BFDProperties#STATE_UNKNOWN_STATE}</li> <li> {@link
     * com.vmware.nsx_policy.model.BFDProperties#STATE_ADMIN_DOWN}</li> <li> {@link
     * com.vmware.nsx_policy.model.BFDProperties#STATE_DOWN}</li> <li> {@link
     * com.vmware.nsx_policy.model.BFDProperties#STATE_INIT}</li> <li> {@link
     * com.vmware.nsx_policy.model.BFDProperties#STATE_UP}</li> </ul> State of the BFD
     * session
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param state New value for the property.
     */
    public void setState(java.lang.String state) {
        this.state = state;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.BFDProperties;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("active",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.active, this._getType().getField("active")));
        structValue.setField("bfd_encap",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.bfdEncap, this._getType().getField("bfd_encap")));
        structValue.setField("diagnostic",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.diagnostic, this._getType().getField("diagnostic")));
        structValue.setField("forwarding",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.forwarding, this._getType().getField("forwarding")));
        structValue.setField("remote_diagnostic",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.remoteDiagnostic, this._getType().getField("remote_diagnostic")));
        structValue.setField("remote_state",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.remoteState, this._getType().getField("remote_state")));
        structValue.setField("state",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.state, this._getType().getField("state")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.BFDProperties;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.BFDProperties.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static BFDProperties _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new BFDProperties(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static BFDProperties _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new BFDProperties(structValue);
    }

    /**
     * Builder class for {@link BFDProperties}.
     */
    public static final class Builder {
        private java.lang.Boolean active;
        private java.lang.String bfdEncap;
        private java.lang.String diagnostic;
        private java.lang.Boolean forwarding;
        private java.lang.String remoteDiagnostic;
        private java.lang.String remoteState;
        private java.lang.String state;

        /**
         * Constructor with parameters for the required properties of
         * {@link BFDProperties}.
         */
        public Builder() {
        }

        /**
         * True if tunnel is active in a gateway HA setup
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param active New value for the property.
         */
        public Builder setActive(java.lang.Boolean active) {
            this.active = active;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.BFDProperties#BFD_ENCAP_GENEVE}</li> <li> {@link
         * com.vmware.nsx_policy.model.BFDProperties#BFD_ENCAP_NONE}</li> <li> {@link
         * com.vmware.nsx_policy.model.BFDProperties#BFD_ENCAP_UNKNOWN_ENCAP}</li> </ul>
         * The encapsulation type of BFD. GENEVE - BFD with GENEVE encapsulation NONE - BFD
         * with no encapsulation UNKNOWN_ENCAP - BFD with unknown encapsulation
         *
         * @param bfdEncap New value for the property.
         */
        public Builder setBfdEncap(java.lang.String bfdEncap) {
            this.bfdEncap = bfdEncap;
            return this;
        }

        /**
         * A short message indicating what the BFD session thinks is wrong in case of a
         * problem
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param diagnostic New value for the property.
         */
        public Builder setDiagnostic(java.lang.String diagnostic) {
            this.diagnostic = diagnostic;
            return this;
        }

        /**
         * True if the BFD session believes this interface may be used to forward traffic
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param forwarding New value for the property.
         */
        public Builder setForwarding(java.lang.Boolean forwarding) {
            this.forwarding = forwarding;
            return this;
        }

        /**
         * A short message indicating what the remote interface's BFD session thinks is
         * wrong in case of a problem
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param remoteDiagnostic New value for the property.
         */
        public Builder setRemoteDiagnostic(java.lang.String remoteDiagnostic) {
            this.remoteDiagnostic = remoteDiagnostic;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.BFDProperties#REMOTE_STATE_UNKNOWN_STATE}</li> <li>
         * {@link com.vmware.nsx_policy.model.BFDProperties#REMOTE_STATE_ADMIN_DOWN}</li>
         * <li> {@link com.vmware.nsx_policy.model.BFDProperties#REMOTE_STATE_DOWN}</li>
         * <li> {@link com.vmware.nsx_policy.model.BFDProperties#REMOTE_STATE_INIT}</li>
         * <li> {@link com.vmware.nsx_policy.model.BFDProperties#REMOTE_STATE_UP}</li>
         * </ul> State of the remote interface's BFD session
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param remoteState New value for the property.
         */
        public Builder setRemoteState(java.lang.String remoteState) {
            this.remoteState = remoteState;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.BFDProperties#STATE_UNKNOWN_STATE}</li> <li> {@link
         * com.vmware.nsx_policy.model.BFDProperties#STATE_ADMIN_DOWN}</li> <li> {@link
         * com.vmware.nsx_policy.model.BFDProperties#STATE_DOWN}</li> <li> {@link
         * com.vmware.nsx_policy.model.BFDProperties#STATE_INIT}</li> <li> {@link
         * com.vmware.nsx_policy.model.BFDProperties#STATE_UP}</li> </ul> State of the BFD
         * session
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param state New value for the property.
         */
        public Builder setState(java.lang.String state) {
            this.state = state;
            return this;
        }

        public BFDProperties build() {
            BFDProperties result = new BFDProperties();
            result.setActive(this.active);
            result.setBfdEncap(this.bfdEncap);
            result.setDiagnostic(this.diagnostic);
            result.setForwarding(this.forwarding);
            result.setRemoteDiagnostic(this.remoteDiagnostic);
            result.setRemoteState(this.remoteState);
            result.setState(this.state);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("active", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("active",
                                                                                "active",
                                                                                "getActive",
                                                                                "setActive");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("bfd_encap", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("bfd_encap",
                                                                                "bfdEncap",
                                                                                "getBfdEncap",
                                                                                "setBfdEncap");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("diagnostic", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("diagnostic",
                                                                                "diagnostic",
                                                                                "getDiagnostic",
                                                                                "setDiagnostic");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("forwarding", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("forwarding",
                                                                                "forwarding",
                                                                                "getForwarding",
                                                                                "setForwarding");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("remote_diagnostic", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("remote_diagnostic",
                                                                                "remoteDiagnostic",
                                                                                "getRemoteDiagnostic",
                                                                                "setRemoteDiagnostic");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("remote_state", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("remote_state",
                                                                                "remoteState",
                                                                                "getRemoteState",
                                                                                "setRemoteState");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("state", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("state",
                                                                                "state",
                                                                                "getState",
                                                                                "setState");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.BFD_properties",
                                                            fields,
                                                            com.vmware.nsx_policy.model.BFDProperties.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

