/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Match criteria based on a community list
 */
public final class CommunityMatchCriteria implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String MATCH_OPERATOR_ANY = "MATCH_ANY";

    public static final java.lang.String MATCH_OPERATOR_ALL = "MATCH_ALL";

    public static final java.lang.String MATCH_OPERATOR_EXACT = "MATCH_EXACT";

    public static final java.lang.String MATCH_OPERATOR_COMMUNITY_REGEX = "MATCH_COMMUNITY_REGEX";

    public static final java.lang.String MATCH_OPERATOR_LARGE_COMMUNITY_REGEX = "MATCH_LARGE_COMMUNITY_REGEX";

    private java.lang.String criteria;

    private java.lang.String matchOperator;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public CommunityMatchCriteria() {
    }

    protected CommunityMatchCriteria(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Match criteria specified as a community list path or a regular expression.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCriteria() {
        return this.criteria;
    }

    /**
     * Match criteria specified as a community list path or a regular expression.
     *
     * @param criteria New value for the property.
     */
    public void setCriteria(java.lang.String criteria) {
        this.criteria = criteria;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.CommunityMatchCriteria#MATCH_OPERATOR_ANY}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.CommunityMatchCriteria#MATCH_OPERATOR_ALL}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.CommunityMatchCriteria#MATCH_OPERATOR_EXACT}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.CommunityMatchCriteria#MATCH_OPERATOR_COMMUNITY_REGEX}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.CommunityMatchCriteria#MATCH_OPERATOR_LARGE_COMMUNITY_REGEX}</li>
     * </ul> Match operator for community list entries. Not valid when a regular
     * expression is specified for criteria.
     *
     * @return The current value of the property.
     */
    public java.lang.String getMatchOperator() {
        return this.matchOperator;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.CommunityMatchCriteria#MATCH_OPERATOR_ANY}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.CommunityMatchCriteria#MATCH_OPERATOR_ALL}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.CommunityMatchCriteria#MATCH_OPERATOR_EXACT}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.CommunityMatchCriteria#MATCH_OPERATOR_COMMUNITY_REGEX}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.CommunityMatchCriteria#MATCH_OPERATOR_LARGE_COMMUNITY_REGEX}</li>
     * </ul> Match operator for community list entries. Not valid when a regular
     * expression is specified for criteria.
     *
     * @param matchOperator New value for the property.
     */
    public void setMatchOperator(java.lang.String matchOperator) {
        this.matchOperator = matchOperator;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.communityMatchCriteria;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("criteria",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.criteria, this._getType().getField("criteria")));
        structValue.setField("match_operator",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.matchOperator, this._getType().getField("match_operator")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.communityMatchCriteria;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.communityMatchCriteria.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static CommunityMatchCriteria _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new CommunityMatchCriteria(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static CommunityMatchCriteria _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new CommunityMatchCriteria(structValue);
    }

    /**
     * Builder class for {@link CommunityMatchCriteria}.
     */
    public static final class Builder {
        private java.lang.String criteria;
        private java.lang.String matchOperator;

        /**
         * Constructor with parameters for the required properties of
         * {@link CommunityMatchCriteria}.
         */
        public Builder() {
        }

        /**
         * Match criteria specified as a community list path or a regular expression.
         *
         * @param criteria New value for the property.
         */
        public Builder setCriteria(java.lang.String criteria) {
            this.criteria = criteria;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.CommunityMatchCriteria#MATCH_OPERATOR_ANY}</li> <li>
         * {@link
         * com.vmware.nsx_policy.model.CommunityMatchCriteria#MATCH_OPERATOR_ALL}</li> <li>
         * {@link
         * com.vmware.nsx_policy.model.CommunityMatchCriteria#MATCH_OPERATOR_EXACT}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.CommunityMatchCriteria#MATCH_OPERATOR_COMMUNITY_REGEX}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.CommunityMatchCriteria#MATCH_OPERATOR_LARGE_COMMUNITY_REGEX}</li>
         * </ul> Match operator for community list entries. Not valid when a regular
         * expression is specified for criteria.
         *
         * @param matchOperator New value for the property.
         */
        public Builder setMatchOperator(java.lang.String matchOperator) {
            this.matchOperator = matchOperator;
            return this;
        }

        public CommunityMatchCriteria build() {
            CommunityMatchCriteria result = new CommunityMatchCriteria();
            result.setCriteria(this.criteria);
            result.setMatchOperator(this.matchOperator);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("criteria", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("criteria",
                                                                                "criteria",
                                                                                "getCriteria",
                                                                                "setCriteria");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("match_operator", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("match_operator",
                                                                                "matchOperator",
                                                                                "getMatchOperator",
                                                                                "setMatchOperator");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.community_match_criteria",
                                                            fields,
                                                            com.vmware.nsx_policy.model.CommunityMatchCriteria.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

